/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_poweroff.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMI
*                
*                V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
/*****************************************************************************
                         ͷļ
******************************************************************************/
#include <fcntl.h>
#include <sys/syscall.h>
#include <linux/reboot.h>
#include <linux/input.h>
#include "mmi_common.h"
#include "mmi_lcd.h"

/************************************************************************************
                            ȫֱ
***********************************************************************************/
static BOOL g_mmi_abnormal_poweroff_flag = FALSE;//쳣ػ־ڵ͵¶쳣ʱٹػҪػ
extern sem_t g_mmi_poweroff_sem_id ;
extern E_zMmiShowMode g_showMode;
extern UINT32 g_temp_protect;
extern UINT32 g_discharge_protect;
extern UINT32 g_fast_poweron;
/***********************************************************************************
 :Źػ
***********************************************************************************/
VOID mmi_lcd_poweroff_end_callback()
{
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_lcd_poweroff_end_callback !\n");
	mmi_PutSemaphore(&g_mmi_poweroff_sem_id);
}

VOID mmi_play_poweroff_cartoon(E_zMmi_Work_Mode mode)
{
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_play_poweroff_cartoon !mode=%d\n", mode);

#ifndef DISABLE_LCD
	mmi_registerLcdPowerOnOff(mmi_lcd_poweroff_end_callback);
	mmi_set_lcd_mode(mode);
	slog(MMI_PRINT, SLOG_DEBUG, "mmi_play_poweroff_cartoon mmi_set_lcd_mode end\n");
#endif

	mmi_set_led_mode(mode);
	slog(MMI_PRINT, SLOG_DEBUG, "mmi_play_poweroff_cartoon mmi_set_led_mode end\n");
	mmi_set_update_flag(MMI_TASK_CTRL);
	slog(MMI_PRINT, SLOG_DEBUG, "mmi_play_poweroff_cartoon mmi_set_update_flag end\n");

#ifndef DISABLE_LCD
	int sem_ret = -1;
	sem_ret = mmi_GetSemaphoreEintr(&g_mmi_poweroff_sem_id, MMI_WAIT_FOREVER);
	if (sem_ret != MMI_SUCCESS) {
		slog(MMI_PRINT, SLOG_ERR, "mmi_play_poweroff_cartoon FAILED! errno=%d\n",errno);
	}    
	slog(MMI_PRINT, SLOG_DEBUG, "mmi_play_poweroff_cartoon mmi_GetSemaphore end\n");

	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {		
		mmi_lcd_backlight_end();
	}
#endif
}


static VOID mmi_killtimer_for_poweroff(VOID)
{
	mmi_kill_idle_timer();
	mmi_kill_tip_timer();
	mmi_kill_wifi_data_timer();
	mmi_kill_traffic_timer();
}

/***********************************************************************************
 :ٹػʱŹػֱӹػػ磬
***********************************************************************************/
static VOID mmi_factory_reset_without_cartoon(void)
{
	struct ext_msg_data ext_data;
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_factory_reset_without_cartoon!!\n");
	
#ifndef DISABLE_LCD
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		mmi_lcd_backlight_end();
	}
#endif

	if ((mmi_get_charge_state() == STATE_CHARGING) || (mmi_get_charge_state() == STATE_FULL)) {
		slog(MMI_PRINT, SLOG_NORMAL, "MMI system poweroffcharging !!!\n");
		//mmi_key_reboot();
		ext_data.cmd = Ext_Cmd_REBOOT;
	} else {
		slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_poweroff!!\n");
		//system("poweroff");
		ext_data.cmd = Ext_Cmd_POWEROFF;
	}
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_RESET_RSP, sizeof(struct ext_msg_data), (CHAR *)(&ext_data), 0);
}

/***********************************************************************************
 :Ļָò
***********************************************************************************/
static VOID mmi_handle_normal_factory_reset(void)
{
	struct ext_msg_data ext_data;
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_handle_normal_factory_reset!!\n");
	mmi_killtimer_for_poweroff();
	mmi_play_poweroff_cartoon(MMI_RESET_MODE);

	slog(MMI_PRINT, SLOG_NORMAL, "mmi_reboot!!\n");
	//system("reboot");
	ext_data.cmd = Ext_Cmd_REBOOT;
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_RESET_RSP, sizeof(struct ext_msg_data), (CHAR *)(&ext_data), 0);
}

/***********************************************************************************
 :ָò
***********************************************************************************/
static VOID mmi_handle_factory_reset(VOID)
{
	if (g_fast_poweron && (mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE
	                       || mmi_get_led_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_led_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE)) {
		mmi_factory_reset_without_cartoon();
	} else {
		mmi_handle_normal_factory_reset();
	}
}

/***********************************************************************************
   :쳣ػ־
   (ڵ͵¶쳣ʱʹ˿ٿҲҪػ)
***********************************************************************************/
VOID mmi_set_abnormal_poweroff_flag()
{
	//g_mmi_abnormal_poweroff_flag = TRUE;
	sc_cfg_set("abnormal_poweroff_flag", "1");
}
VOID mmi_get_abnormal_poweroff_flag()
{
	char nv_abnormal_poweroff[2] = {0};
	sc_cfg_get("abnormal_poweroff_flag", nv_abnormal_poweroff, sizeof(nv_abnormal_poweroff));

	slog(MMI_PRINT, SLOG_DEBUG, "mmi_get_abnormal_poweroff_flag  nv_abnormal_poweroff= %s\n", nv_abnormal_poweroff);
	if (!strncmp(nv_abnormal_poweroff, "1", 1)) {
		g_mmi_abnormal_poweroff_flag = TRUE;
	} else {
		g_mmi_abnormal_poweroff_flag = FALSE;
	}
}

/***********************************************************************************
   :ػ,RJ45߻PIN뿪߿ٹػ
***********************************************************************************/
static void mmi_handle_poweroff(VOID)
{
	char rj45_sta[24] = {0};
	char nv_poweron_mode[8] = {0};
	char nv_sim_pin[8] = {0};
	sc_cfg_get(NV_RJ45_PLUG, rj45_sta, sizeof(rj45_sta));
	sc_cfg_get(POWERON_MODE, nv_poweron_mode, sizeof(nv_poweron_mode));
	sc_cfg_get(NV_NEED_SIM_PIN, nv_sim_pin, sizeof(nv_sim_pin));
	mmi_get_abnormal_poweroff_flag();
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_handle_poweroff poweroff_flag = %d\n", g_mmi_abnormal_poweroff_flag);
	if (g_fast_poweron) {
		if (g_mmi_abnormal_poweroff_flag) {
			if (mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE
			    || mmi_get_led_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_led_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE) {
				mmi_poweroff_without_cartoon();
			} else {
				slog(MMI_PRINT, SLOG_DEBUG, "mmi_handle_poweroff abnormal!!\n");
				mmi_handle_normal_poweroff();
			}
		} else {
			if ((!strncmp(rj45_sta, RJ45_WAN_ON_LAN_OFF, strlen(RJ45_WAN_ON_LAN_OFF)))
			    || (!strncmp(rj45_sta, RJ45_WAN_OFF_LAN_ON, strlen(RJ45_WAN_OFF_LAN_ON)))
			    || (!strncmp(rj45_sta, RJ45_WAN_LAN_ON, strlen(RJ45_WAN_LAN_ON)))) {
				slog(MMI_PRINT, SLOG_DEBUG, "mmi_handle_poweroff wan_lan_on!!\n");
				mmi_handle_normal_poweroff();
			} else {
				if (!strncmp(nv_poweron_mode, FAST_POWERON_MODE, sizeof(FAST_POWERON_MODE)) && strncmp(nv_sim_pin, "yes", sizeof("yes"))) {
					slog(MMI_PRINT, SLOG_DEBUG, "mmi_handle_fast_poweroff!!\n");
					mmi_handle_fast_poweroff();
				} else {
					mmi_handle_normal_poweroff();
				}
			}
		}
	} else
		mmi_handle_normal_poweroff();
}

/***********************************************************************************
 :ٹػʱŹػֱӹػػ磬
***********************************************************************************/
static VOID mmi_restart_without_cartoon(void)
{
	struct ext_msg_data ext_data;
	
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_restart_without_cartoon!!\n");

#ifndef DISABLE_LCD
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		mmi_lcd_backlight_end();
	}
#endif

	if ((mmi_get_charge_state() == STATE_CHARGING) || (mmi_get_charge_state() == STATE_FULL)) {
		slog(MMI_PRINT, SLOG_NORMAL, "MMI system poweroffcharging!!\n");
		//mmi_key_reboot();
		ext_data.cmd = Ext_Cmd_POWEROFF_CHARGING;
	} else {
		//system("poweroff");
		ext_data.cmd = Ext_Cmd_POWEROFF;
	}
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_RESTART_RSP, sizeof(struct ext_msg_data), (CHAR *)(&ext_data), 0);
}

/***********************************************************************************
 :
***********************************************************************************/
static VOID mmi_handle_normal_restart(VOID)
{
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_handle_normal_restart!!\n");
	struct ext_msg_data ext_data;

	mmi_killtimer_for_poweroff();
	mmi_play_poweroff_cartoon(MMI_RESTART_MODE);

	slog(MMI_PRINT, SLOG_NORMAL, "system restart!!!\n");
	//sc_cfg_save();
	//system("reboot");
	ext_data.cmd = Ext_Cmd_REBOOT;
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_RESTART_RSP, sizeof(struct ext_msg_data), (CHAR *)(&ext_data), 0);
}

/***********************************************************************************
   :
***********************************************************************************/
static VOID mmi_handle_restart(VOID)
{
	if (g_fast_poweron) {
		if (mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_lcd_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE
		    || mmi_get_led_mode() == MMI_FAKE_POWEROFF_MODE || mmi_get_led_mode() == MMI_FAKE_POWEROFF_CHARGE_MODE) {
			mmi_restart_without_cartoon();
		} else {
			mmi_handle_normal_restart();
		}
	} else
		mmi_handle_normal_restart();
}

/**********************************************************************************
:ָòϢ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Factory_Reset(VOID *data)
{
	set_wake_lock(MMI_POWEROFF_LOCK_ID);
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Factory_Reset !!\n");
	if (g_discharge_protect) {
		mmi_set_discharge_switch(FALSE);
	}
	mmi_handle_factory_reset();
	return 0;
	//mmi_send_message(MODULE_ID_BLC_POWEROFF, MSG_CMD_MAINCTRL_RESET_RESULT, 0, NULL);
}

/**********************************************************************************
:Ϣ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Restart(VOID *data)
{
	set_wake_lock(MMI_POWEROFF_LOCK_ID);
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Restart !!\n");

	if (g_discharge_protect) {
		mmi_set_discharge_switch(FALSE);
	}
	mmi_handle_restart();
	return 0;
}
/**********************************************************************************
:ػϢ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Poweroff(VOID *data)
{
	if (g_discharge_protect) {
		mmi_set_discharge_switch(FALSE);
	}
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Poweroff !!\n");
	mmi_handle_poweroff();
	return 0;
}
/**********************************************************************************
:ػϢ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Plugout(VOID *data)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI poweroff,CHARGE_STATUS_DISCHARGING !!!\n");

	system("poweroff");
	return 0;
}

/**********************************************************************************
:MMIûָҪ
***********************************************************************************/
VOID  mmi_set_factory_reset()
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_set_factory_reset send MSG!!\n");
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_RESET_REQUEST, 0, NULL, 0);
}
/**********************************************************************************
:MMIùػҪ
***********************************************************************************/
VOID  mmi_set_poweroff()
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_set_poweroff send MSG!!\n");
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_POWEROFF_REQUEST, 0, NULL, 0);
}

/***********************************************************************************
:ػ
***********************************************************************************/
VOID mmi_poweroff_without_cartoon(void)
{
	struct ext_msg_data ext_data;
	
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_poweroff_without_cartoon!!\n");
	
	set_wake_lock(MMI_POWEROFF_LOCK_ID);
	
#ifndef DISABLE_LCD
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		mmi_lcd_backlight_end();
	}
#endif

	if ((mmi_get_charge_state() == STATE_CHARGING) || (mmi_get_charge_state() == STATE_FULL)) {
		slog(MMI_PRINT, SLOG_NORMAL, "MMI system poweroffcharging!!\n");
		ext_data.cmd = Ext_Cmd_REBOOT;
	} else {
		ext_data.cmd = Ext_Cmd_POWEROFF;
	}
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_POWEROFF_RSP, sizeof(struct ext_msg_data), (CHAR *)(&ext_data), 0);
}

VOID mmi_handle_normal_poweroff(void)
{
	struct ext_msg_data ext_data;
	slog(MMI_PRINT, SLOG_NORMAL, "mmi_handle_normal_poweroff!!\n");
	set_wake_lock(MMI_POWEROFF_LOCK_ID);

	mmi_killtimer_for_poweroff();
	mmi_play_poweroff_cartoon(MMI_POWEROFF_MODE);
	//if (mmi_get_usb_insert_state()) { //kw 3
	//	slog(MMI_PRINT, SLOG_NORMAL, "MMI system poweroffcharging!!\n");
	//	ext_data.cmd = Ext_Cmd_POWEROFF_CHARGING;
	//} else 
	{
		slog(MMI_PRINT, SLOG_NORMAL, "MMI poweroff,normal!!!\n");
		ext_data.cmd = Ext_Cmd_POWEROFF;
	}
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_POWEROFF_RSP, sizeof(struct ext_msg_data), (CHAR *)(&ext_data), 0);
}


