/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_batterry.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIȡ͵Ϣ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
******************************************************************************/


/************************************************************************************
                           ͷļ
***********************************************************************************/
#include <wdt_common.h>
#include <limits.h>

/************************************************************************************
                            ȫֱ
***********************************************************************************/
UINT32 g_temp_protect_wd = 0;
UINT32 g_discharge_protect_wd = 0;
UINT32 g_charge_protect_wd = 0;


static WDT_TEMP_DETECT last_temp = TEMP_DETECT_MAX;//һ¶״̬
static SINT32 s_temp_count = 0;//¶쳣ʱ3κӦ
static BOOL g_chg_switch_off = FALSE;//¼رտأĬ

static T_WdtChgStateStringItem g_chgStateStringTab[] = {
	{CHARGE_STATUS_FULL,     	STATE_FULL},
	{CHARGE_STATUS_CHARGING, 	STATE_CHARGING},
	{CHARGE_STATUS_DISCHARGING,	STATE_DISCHARGE},
	{CHARGE_STATUS_NOTCHARGING,	STATE_CHARGERROR}
};

/**********************************************************************************
*˵¶ȼ쳣ػ¼
***********************************************************************************/
VOID record_temperror_offnum2()
{
	int numTemp = 0;
	char num[12] = {0};
	int i_num = 0;
	sc_cfg_get(BATERROROFF_NV, num, 4);
#if 1    
    i_num = atoi(num);
    if(i_num < 0 || i_num > INT_MAX-1)
    {
        i_num  = 0;
    }
#endif	
	numTemp = i_num + 1 ;

	itoa(numTemp, num, 10);
	sc_cfg_set(BATERROROFF_NV, num);
}

/**********************************************************************************
*˵ȡ¶ȵѹ
***********************************************************************************/
WDT_TEMP_DETECT wdt_get_battery_temp_voltage(VOID)
{
	char buf[CHARGE_STATUS_LENGTH+1] = {0};
	FILE* f_couter = NULL;
	int len = 0;
	int temp_voltage = 0;
	WDT_TEMP_DETECT temp_detect = TEMP_DETECT_MAX;

	f_couter = fopen(CHARGE_BAT_TEMP_PATH, "r");
	if (f_couter == NULL) {
		perror(CHARGE_BAT_TEMP_PATH);
		slog(MMI_PRINT, SLOG_ERR, "WDT open battery_temp file fail!\n");
		return TEMP_DETECT_MAX;
	}
	len = fread(buf, 1, CHARGE_STATUS_LENGTH, f_couter);
	if (len > 0) {//kw 3
		temp_voltage = atoi(buf);
		fclose(f_couter);
	} else {
		slog(MMI_PRINT, SLOG_ERR, "WDT read battery_temp file fail!\n");
		fclose(f_couter);
		return TEMP_DETECT_MAX;
	}
	slog(MMI_PRINT, SLOG_ERR,  "WDT BATTERY wdt_get_battery_temp_voltage temp = %d!\n", temp_voltage);

	if (temp_voltage <= g_superhightempvol || temp_voltage >= g_superlowtempvol) {
		temp_detect = TEMP_DETECT_ERROR;
	} else if ((temp_voltage > g_hightempvol) && (temp_voltage < g_lowtempvol)) {
		temp_detect = TEMP_DETECT_NORMAL;
	} else {
		temp_detect = TEMP_DETECT_ABNORMAL;
	}

	return temp_detect;

}

/**********************************************************************************
*˵¶ȼ 쳣ʱػ
 ***********************************************************************************/
static VOID wdt_battery_temp_check(VOID)
{
	WDT_TEMP_DETECT temp = TEMP_DETECT_MAX;

	temp = wdt_get_battery_temp_voltage();
	if (temp != last_temp) {
		last_temp = temp;
		s_temp_count = 1;
	} else {
		s_temp_count ++;
		slog(MMI_PRINT, SLOG_ERR, "WDT BATTERY wdt_battery_temp_check = %d, temp=%d, g_chg_switch_off = %d!\n", s_temp_count, temp,g_chg_switch_off);
		
		if (s_temp_count == 3) {
			s_temp_count = 0;
			if (temp == TEMP_DETECT_ABNORMAL) {
				if (!g_chg_switch_off) {
					record_temperror_offnum2();
					slog(MMI_PRINT, SLOG_ERR, "WDT BATTERY temp abnormal!\n");
					system(TURN_OFF_CHG);
					g_chg_switch_off = TRUE;
				}
			} else if (temp == TEMP_DETECT_ERROR) {
				record_temperror_offnum2();
				slog(MMI_PRINT, SLOG_ERR, "WDT  BATTERY temp error,TURN OFF DISCHG!!!\n");

				if (g_discharge_protect_wd) {
					system(TURN_OFF_DISCHG);
				}
				sc_cfg_set("abnormal_poweroff_flag", "1");
				#if (PRODUCT_TYPE == PRODUCT_PHONE)
				struct ext_msg_data ext_msg = {0};
    			ext_msg.cmd = Ext_Cmd_POWEROFF;
				platform_send_msg(MODULE_ID_WDT,MODULE_ID_MAIN_CTRL, MSG_CMD_POWEROFF_REQUEST, sizeof(struct ext_msg_data), &ext_msg);
				#else
				ipc_send_message(MODULE_ID_WDT, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_POWEROFF_REQUEST, 0, NULL, 0);//mmi_set_poweroff();
				#endif
			} else if (temp == TEMP_DETECT_NORMAL) {
				if (g_chg_switch_off) {
					slog(MMI_PRINT, SLOG_ERR, "WDT BATTERY temp normal,TURN_ON_CHG!\n");
					system(TURN_ON_CHG);
					g_chg_switch_off = FALSE;
				}
			} else {
				slog(MMI_PRINT, SLOG_ERR, "WDT wdt_battery_temp_check invalid temp = %d!\n", temp);
			}
		}
		
	}
}

/**********************************************************************************
*˵ȡ״̬
 ***********************************************************************************/
E_WDT_Charge_State wdt_get_charge_status(VOID)
{
	char chg_state_buf[CHARGE_STATUS_LENGTH] = {0};
	int len = 0;
	UINT32 i = 0;
	FILE* fd_charger = NULL;

	fd_charger = fopen(CHARGE_STATUS_PATH, "r");
	if (fd_charger == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt_get_charge_status open charging file fail!\n");
		//MMI_ASSERT(0);
		return STATE_CHARGE_MAX;
	}
	len = fread(chg_state_buf, 1, CHARGE_STATUS_LENGTH, fd_charger);
	if (len > 0) { //kw 3
		fclose(fd_charger);
		slog(MMI_PRINT, SLOG_DEBUG, "WDT wdt_get_charge_status chg_state_buf=%s !\n", chg_state_buf);
		for (i = 0; i < sizeof(g_chgStateStringTab) / sizeof(T_WdtChgStateStringItem); ++ i) {
			if (strncmp(chg_state_buf, g_chgStateStringTab[i].devString, strlen(g_chgStateStringTab[i].devString)) == 0) {
				return g_chgStateStringTab[i].chg_sta;
			}
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt_get_charge_status read voltage file fail len = %d !\n", len);
		fclose(fd_charger);
		return STATE_CHARGE_MAX;
	}
	return STATE_CHARGE_MAX;
}

/**********************************************************************************
*˵ ȡѹֵ
***********************************************************************************/
static SINT32 wdt_voltage_state_read(VOID)
{
	char buf_volt[CHARGE_VOLTAGE_LENGTH+1] = {0};
	FILE* fd_voltage = NULL;
	int len = 0;
	int voltagepower = 0;

	fd_voltage = fopen(CHARGE_VOLTAGE_PATH, "r");
	if (fd_voltage == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "WDT open voltage file fail!\n");
		//MMI_ASSERT(0);
		return -1;
	}
	len = fread(buf_volt, 1, CHARGE_VOLTAGE_LENGTH, fd_voltage);
	if (len > 0) { //kw 3
		voltagepower = atoi(buf_volt);
		fclose(fd_voltage);
		return voltagepower;
	} else {
		slog(MMI_PRINT, SLOG_ERR, "WDT read voltage file fail len = %d !\n", len);
		fclose(fd_voltage);
		return -1;
	}
}

/**********************************************************************************
*˵״̬ رճʱ ѹһֵ򿪳
 ***********************************************************************************/
static VOID wdt_battery_charge_check(VOID)
{
	SINT32 bat_volt = 0;
	E_WDT_Charge_State chg_sta = STATE_CHARGE_MAX;
	
	bat_volt = wdt_voltage_state_read();
	slog(MMI_PRINT, SLOG_DEBUG, "WDT wdt_voltage_state_read bat_volt =%d\n\n", bat_volt);

	chg_sta = wdt_get_charge_status();
	slog(MMI_PRINT, SLOG_DEBUG, "WDT wdt_get_charge_status chg_sta = %d!!\n", chg_sta);

	if (bat_volt != -1 && bat_volt < CHARGEONLEVEL && chg_sta == STATE_FULL) {
		system(TURN_ON_CHG);
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt_battery_charge_check charge on!\n");
	}

}

/**********************************************************************************
*˵ι
***********************************************************************************/
VOID *wdt_temp_check_process()
{
	UINT32 voltagepower = 0;

	if (g_temp_protect_wd) {
		char mode[2] = {0};
		sc_cfg_get(BOOT_TESTBATTERY_MODE, mode, 2);
		slog(MMI_PRINT, SLOG_ERR, "WDT BOOT_TESTBATTERY_MODE=%s\n", mode);
		if (strcmp(mode, "0") != 0) {
			wdt_battery_temp_check();
			if (g_charge_protect_wd) {
				wdt_battery_charge_check();
			}
		}
	}
	return NULL;
}


