/************************************************************************
* Ȩ (C)2008, ͨѶɷ޹˾
* 
* ļƣ sms_code.c
* ļʶ 
* ժҪ SMSģԶݽб
* ˵ 
* ǰ汾 V0.1
*     ߣ zhengyt
* ڣ 2008-12-13
* 
* ޸ļ¼1    
* ޸ݣʼ汾
************************************************************************/
#include <time.h>
#include <ctype.h>
#include "os_type_def.h"
#include "sms_code.h"



#ifdef WIN32
#include <wchar.h>
#endif
/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define     NON_GSM                         0x20
#define     NON_GSM_P                       NON_GSM
extern T_zUfiSms_ConcatInfo g_zUfiSms_ConcatSms;

//static pthread_mutex_t wmsts_mutex = PTHREAD_MUTEX_INITIALIZER;
static const wms_udh_s_type *const_header;

char g_zUfiSms_DigAscMap[16] =
{
    '0', '1', '2', '3', '4', '5', '6', '7',
    '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};

extern SMS_PARAM    g_zUfiSms_SendingSms;
extern UINT16 g_zUfiSms_IsLanguageShift;
extern int g_zUfiSms_Language;

static int SerializeNumbers_sms(const char* pSrc, char* pDst, int nSrcLength);

/**************************************************************************
 *                           ֲԭ                                 *
 **************************************************************************/
 const unsigned short g_zUfiSms_AsciiToGsmdefaultTable[] =
{
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',' ',' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', '!',0x22, '#', 0x02, '%', '&',0x27, '(', ')', '*', '+', ',', '-', '.', '/',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
    0x00, 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 0x1b3c, 0x1b2f, 0x1b3e, 0x1b14, 0x11,
    ' ', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
    'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 0x1b28, 0x1b40, 0x1b29,0x1b3d, ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', 0x40, ' ', 0x01, 0x24, 0x03, ' ', 0x5F, ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 0x0B, ' ', ' ', ' ', ' ', ' ', ' ', 0x60,
    ' ', ' ', ' ', ' ', 0x5B, 0x0E, 0x1C, 0x09, ' ', 0x1F, ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', 0x5D, ' ', ' ', ' ', ' ', 0x5C, ' ', ' ', ' ', ' ', ' ', 0x5E, ' ', ' ', 0x1E,
    0x7F, ' ', ' ', ' ', 0x7B, 0x0F, 0x1D, ' ', 0x04, 0x05, ' ', ' ', 0x07, ' ', ' ', ' ',
    ' ', 0x7D, 0x08, ' ', ' ', ' ', 0x7C, ' ', 0x0C, 0x06, ' ', ' ', 0x7E, ' ', ' ', ' ',
};

 const unsigned short zte_sms_GSM7_SPANISH_To_UCS2_Table_Ex[][2] =
{
    { 0x09, 0x00E7 },
    { 0x0A, 0x000C },   /* FORM FEED */
    { 0x0D, 0x000D },
    { 0x14, 0x005E },   /* CIRCUMFLEX ACCENT */
    { 0x28, 0x007B },   /* LEFT CURLY BRACKET */
    { 0x29, 0x007D },   /* RIGHT CURLY BRACKET */
    { 0x2F, 0x005C },   /* REVERSE SOLIDUS */
    { 0x3C, 0x005B },   /* LEFT SQUARE BRACKET */
    { 0x3D, 0x007E },   /* TILDE */
    { 0x3E, 0x005D },   /* RIGHT SQUARE BRACKET */
    { 0x40, 0x007C },   /* VERTICAL LINE */
    { 0x41, 0x00C1 },
    { 0x49, 0x00CD },
    { 0x4F, 0x00D3 },
    { 0x55, 0x00DA },
    { 0x61, 0x00E1 },
    { 0x65, 0x20AC },   /* EURO SIGN */
    { 0x69, 0x00ED },
    { 0x6F, 0x00F3 },
    { 0x75, 0x00FA },
};

  const unsigned short Ucs2_To_Gsm7_SPANISH_Table_UCS[][2] =
{
    { 0x10 , 0x0394 },   /* GREEK CAPITAL LETTER DELTA */
    { 0x12 , 0x03A6 },   /* GREEK CAPITAL LETTER PHI */
    { 0x13 , 0x0393 },   /* GREEK CAPITAL LETTER GAMMA */
    { 0x14 , 0x039B },   /* GREEK CAPITAL LETTER LAMDA */
    { 0x15 , 0x03A9 },   /* GREEK CAPITAL LETTER OMEGA */
    { 0x16 , 0x03A0 },   /* GREEK CAPITAL LETTER PI */
    { 0x17 , 0x03A8 },   /* GREEK CAPITAL LETTER PSI */
    { 0x18 , 0x03A3 },   /* GREEK CAPITAL LETTER SIGMA */
    { 0x19 , 0x0398 },   /* GREEK CAPITAL LETTER THETA */
    { 0x1A , 0x039E },   /* GREEK CAPITAL LETTER XI */
};

  const unsigned char  Ucs2_To_Gsm7_SPANISH_Table_ASC[] =
{
    /*          +0x0     +0x1     +0x2     +0x3     +0x4     +0x5     +0x6     +0x7*/
    /*0x00*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0x08*/    NON_GSM, NON_GSM, 0x0a,    NON_GSM, NON_GSM, 0x0d,    NON_GSM, NON_GSM,  
    /* . . \r. . \d. . */
    /*0x10*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, 
    /* . . . . . . . . */
    /*0x18*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0x20*/    0x20,    0x21,    0x22,    0x23,    0x02,    0x25,    0x26,    0x27,    
    /*   ! " # $ % & ' */
    /*0x28*/    0x28,    0x29,    0x2a,    0x2b,    0x2c,    0x2d,    0x2e,    0x2f,     
    /* ( ) * + , - . / */
    /*0x30*/    0x30,    0x31,    0x32,    0x33,    0x34,    0x35,    0x36,    0x37,     /* 0 1 2 3 4 5 6 7 */
    /*0x38*/    0x38,    0x39,    0x3a,    0x3b,    0x3c,    0x3d,    0x3e,    0x3f,     /* 8 9 : ; < = > ? */
    /*0x40*/    0x00,    0x41,    0x42,    0x43,    0x44,    0x45,    0x46,    0x47,     /* @ A B C D E F G */
    /*0x48*/    0x48,    0x49,    0x4a,    0x4b,    0x4c,    0x4d,    0x4e,    0x4f,     /* H I J K L M N O */
    /*0x50*/    0x50,    0x51,    0x52,    0x53,    0x54,    0x55,    0x56,    0x57,     /* P Q R S T U V W */
    /*0x58*/    0x58,    0x59,    0x5a,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x11,     /* X Y Z . . . . _ */
    /*0x60*/    NON_GSM, 0x61,    0x62,    0x63,    0x64,    0x65,    0x66,    0x67,     /* . a b c d e f g */
    /*0x68*/    0x68,    0x69,    0x6a,    0x6b,    0x6c,    0x6d,    0x6e,    0x6f,     /* h i j k l m n o */
    /*0x70*/    0x70,    0x71,    0x72,    0x73,    0x74,    0x75,    0x76,    0x77,     /* p q r s t u v w */
    /*0x78*/    0x78,    0x79,    0x7a,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* x y z . . . . . */
    /*0x80*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0x88*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0x90*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0x98*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0xa0*/    0x1b,    0x40,    NON_GSM, 0x01,    0x24,    0x03,    NON_GSM, 0x5f,     /* . . . . . . . . */
    /*0xa8*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0xb0*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0xb8*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x60,     /* . . . . . . . . */
    /*0xc0*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x5b,    0x0e,    0x1c,    0x09,  /* . . . . . . . . */
    /*0xc8*/    NON_GSM, 0x1f,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0xd0*/    NON_GSM, 0x5d,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x5c,    NON_GSM,  /* . . . . . . . . */
    /*0xd8*/    0x0b,    NON_GSM, NON_GSM, NON_GSM, 0x5e,    NON_GSM, NON_GSM, 0x1e,     /* . . . . . . . . */
    /*0xe0*/    0x7f,    NON_GSM, NON_GSM, NON_GSM, 0x7b,    0x0f,    0x1d,    NON_GSM,     /* . . . . . . . . */
    /*0xe8*/    0x04,    0x05,    NON_GSM, NON_GSM, 0x07,    NON_GSM, NON_GSM, NON_GSM,  /* . . . . . . . . */
    /*0xf0*/    NON_GSM, 0x7d,    0x08   , NON_GSM, NON_GSM, NON_GSM, 0x7c,    NON_GSM,  /* . . . . . . . . */
    /*0xf8*/    0x0c,    0x06,    NON_GSM, NON_GSM, 0x7e,    NON_GSM, NON_GSM, NON_GSM   /* . . . . . . . . */
};

 const unsigned short zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[][2] =
{
    { 0x05, 0x00EA },
    { 0x09, 0x00E7 },
    { 0x0A, 0x000C },   /* FORM FEED */
    { 0x0B, 0x00D4 },
    { 0x0C, 0x00F4 },
    { 0x0D, 0x000D },
    { 0x0E, 0x00C1 },
    { 0x0F, 0x00E1 },
    { 0x12, 0x03A6 },
    { 0x13, 0x0393 },
    { 0x14, 0x005E },   /* CIRCUMFLEX ACCENT */
    { 0x15, 0x03A9 },
    { 0x16, 0x03A0 },
    { 0x17, 0x03A8 },
    { 0x18, 0x03A3 },
    { 0x19, 0x0398 },
    { 0x1F, 0x00CA },
    { 0x28, 0x007B },   /* LEFT CURLY BRACKET */
    { 0x29, 0x007D },   /* RIGHT CURLY BRACKET */
    { 0x2F, 0x005C },   /* REVERSE SOLIDUS */
    { 0x3C, 0x005B },   /* LEFT SQUARE BRACKET */
    { 0x3D, 0x007E },   /* TILDE */
    { 0x3E, 0x005D },   /* RIGHT SQUARE BRACKET */
    { 0x40, 0x007C },   /* VERTICAL LINE */
    { 0x41, 0x00C0 },
    { 0x49, 0x00CD },
    { 0x4F, 0x00D3 },
    { 0x55, 0x00DA },
    { 0x5B, 0x00C3 },
    { 0x5C, 0x00D5 },
    { 0x61, 0x00C2 },
    { 0x65, 0x20AC },   /* EURO SIGN */
    { 0x69, 0x00ED },
    { 0x6F, 0x00F3 },
    { 0x75, 0x00FA },
    { 0x7B, 0x00E3 },
    { 0x7C, 0x00F5 },
    { 0x7F, 0x00E2 },
};

  const unsigned short Ucs2_To_Gsm7_PORTUGUESE_Table_UCS[][2] =
{
    { 0x10 , 0x0394 },   /* GREEK CAPITAL LETTER DELTA */
    //{ 0x12 , 0x03A6 },   /* GREEK CAPITAL LETTER PHI */
    //{ 0x13 , 0x0393 },   /* GREEK CAPITAL LETTER GAMMA */
    //{ 0x14 , 0x039B },   /* GREEK CAPITAL LETTER LAMDA */
    { 0x15 , 0x22E1 },
    //{ 0x16 , 0x03A0 },   /* GREEK CAPITAL LETTER PI */
    //{ 0x17 , 0x03A8 },   /* GREEK CAPITAL LETTER PSI */
    { 0x18 , 0x20AC },
    //{ 0x19 , 0x0398 },   /* GREEK CAPITAL LETTER THETA */
    //{ 0x1A , 0x039E },   /* GREEK CAPITAL LETTER XI */
    { 0x65 , 0x20AC },   /* EURO SIGN */
};
 const unsigned char Ucs2_To_Gsm7_PORTUGUESE_Table_ASC[] =
{
    /*          +0x0       +0x1       +0x2     +0x3     +0x4     +0x5       +0x6     +0x7*/
    /*0x00*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0x08*/    NON_GSM,  NON_GSM,  0x0a,     NON_GSM, NON_GSM,  0x0d,     NON_GSM,  NON_GSM,  /* . . \r. . \d. . */
    /*0x10*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0x18*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0x20*/    0x20,     0x21,     0x22,     0x23,    0x02,     0x25,     0x26,     0x27,     /*   ! " # $ % & ' */
    /*0x28*/    0x28,     0x29,     0x2a,     0x2b,    0x2c,     0x2d,     0x2e,     0x2f,     /* ( ) * + , - . / */
    /*0x30*/    0x30,     0x31,     0x32,     0x33,    0x34,     0x35,     0x36,     0x37,     /* 0 1 2 3 4 5 6 7 */
    /*0x38*/    0x38,     0x39,     0x3a,     0x3b,    0x3c,     0x3d,     0x3e,     0x3f,     /* 8 9 : ; < = > ? */
    /*0x40*/    0x00,     0x41,     0x42,     0x43,    0x44,     0x45,     0x46,     0x47,     /* @ A B C D E F G */
    /*0x48*/    0x48,     0x49,     0x4a,     0x4b,    0x4c,     0x4d,     0x4e,     0x4f,     /* H I J K L M N O */
    /*0x50*/    0x50,     0x51,     0x52,     0x53,    0x54,     0x55,     0x56,     0x57,     /* P Q R S T U V W */
    /*0x58*/    0x58,     0x59,     0x5a,     NON_GSM, 0x0017,   NON_GSM,  0x0016,   0x11,     /* X Y Z . . . . _ */
    /*0x60*/    0x007D,   0x61,     0x62,     0x63,    0x64,     0x65,     0x66,     0x67,     /* . a b c d e f g */
    /*0x68*/    0x68,     0x69,     0x6a,     0x6b,    0x6c,     0x6d,     0x6e,     0x6f,     /* h i j k l m n o */
    /*0x70*/    0x70,     0x71,     0x72,     0x73,    0x74,     0x75,     0x76,     0x77,     /* p q r s t u v w */
    /*0x78*/    0x78,     0x79,     0x7a,     NON_GSM, 0x001A,   NON_GSM,  0x0060,   NON_GSM,  /* x y z . . . . . */
    /*0x80*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0x88*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0x90*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0x98*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0xa0*/    0x1b,     NON_GSM_P,NON_GSM,  0x01,    NON_GSM_P,0x03,     NON_GSM,  0x5f,     /* . . . . . . . . */
    /*0xa8*/    NON_GSM,  NON_GSM,  0x0012,   NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0xb0*/    0X0024,   NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0xb8*/    NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM, NON_GSM,  NON_GSM,  NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0xc0*/    0x0014,   0x000E,   0x001C,   0x005B,  NON_GSM_P,NON_GSM_P,NON_GSM_P,0x0013,   /* . . . . . . . . */
    /*0xc8*/    NON_GSM,  0x1f,     0x001E,   NON_GSM, NON_GSM,  0x0040,   NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0xd0*/    NON_GSM,  NON_GSM_P,NON_GSM,  0x0019,  0x000B,   0x005C,   NON_GSM_P,NON_GSM,  /* . . . . . . . . */
    /*0xd8*/    NON_GSM_P,NON_GSM,  0x005D,   NON_GSM, 0x5e,     NON_GSM,  NON_GSM,  NON_GSM_P,/* . . . . . . . . */
    /*0xe0*/    0x7f,     0x000F,   0x001D,   0x007B,  NON_GSM_P,NON_GSM_P,NON_GSM_P,0x09,     /* . . . . . . . . */
    /*0xe8*/    NON_GSM_P,0x05,     0x0004,   NON_GSM, NON_GSM_P,0x0007,   NON_GSM,  NON_GSM,  /* . . . . . . . . */
    /*0xf0*/    NON_GSM,  NON_GSM_P,NON_GSM_P,0x0008,  0x000C,   0x007C,   NON_GSM_P,NON_GSM,  /* . . . . . . . . */
    /*0xf8*/    NON_GSM_P,NON_GSM_P,0x0006,   NON_GSM, 0x7e,     NON_GSM,  NON_GSM,  NON_GSM   /* . . . . . . . . */
};

   const unsigned short zte_sms_GSMDefault_To_UCS2_Table_Ex[][2] =
{
    { 0x0A, 0x000C },   /* FORM FEED */
    { 0x14, 0x005E },   /* CIRCUMFLEX ACCENT */
    { 0x28, 0x007B },   /* LEFT CURLY BRACKET */
    { 0x29, 0x007D },   /* RIGHT CURLY BRACKET */
    { 0x2F, 0x005C },   /* REVERSE SOLIDUS */
    { 0x3C, 0x005B },   /* LEFT SQUARE BRACKET */
    { 0x3D, 0x007E },   /* TILDE */
    { 0x3E, 0x005D },   /* RIGHT SQUARE BRACKET */
    { 0x40, 0x007C },   /* VERTICAL LINE */
    { 0x65, 0x20AC },   /* EURO SIGN */
};

    const unsigned short UCS2_To_GSMDefault_Table_UCS2[][2] =
{
    { 0x10 , 0x0394 },   /* GREEK CAPITAL LETTER DELTA */
    { 0x12 , 0x03A6 },   /* GREEK CAPITAL LETTER PHI */
    { 0x13 , 0x0393 },   /* GREEK CAPITAL LETTER GAMMA */
    { 0x14 , 0x039B },   /* GREEK CAPITAL LETTER LAMDA */
    { 0x15 , 0x03A9 },   /* GREEK CAPITAL LETTER OMEGA */
    { 0x16 , 0x03A0 },   /* GREEK CAPITAL LETTER PI */
    { 0x17 , 0x03A8 },   /* GREEK CAPITAL LETTER PSI */
    { 0x18 , 0x03A3 },   /* GREEK CAPITAL LETTER SIGMA */
    { 0x19 , 0x0398 },   /* GREEK CAPITAL LETTER THETA */
    { 0x1A , 0x039E },   /* GREEK CAPITAL LETTER XI */
};

 const unsigned char  UCS2_To_GSMDefault_Table_ASC[] =
{
    /*          +0x0     +0x1     +0x2     +0x3     +0x4     +0x5     +0x6     +0x7*/
    /*0x00*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0x08*/    NON_GSM, NON_GSM, 0x0a,    NON_GSM, NON_GSM, 0x0d,    NON_GSM, NON_GSM, 
    /* . . \r. . \d. . */
    /*0x10*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0x18*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0x20*/    0x20,    0x21,    0x22,    0x23,    0x02,    0x25,    0x26,    0x27,     
    /*   ! " # $ % & ' */
    /*0x28*/    0x28,    0x29,    0x2a,    0x2b,    0x2c,    0x2d,    0x2e,    0x2f,    
    /* ( ) * + , - . / */
    /*0x30*/    0x30,    0x31,    0x32,    0x33,    0x34,    0x35,    0x36,    0x37,     
    /* 0 1 2 3 4 5 6 7 */
    /*0x38*/    0x38,    0x39,    0x3a,    0x3b,    0x3c,    0x3d,    0x3e,    0x3f,     
    /* 8 9 : ; < = > ? */
    /*0x40*/    0x00,    0x41,    0x42,    0x43,    0x44,    0x45,    0x46,    0x47,     
    /* @ A B C D E F G */
    /*0x48*/    0x48,    0x49,    0x4a,    0x4b,    0x4c,    0x4d,    0x4e,    0x4f,    
    /* H I J K L M N O */
    /*0x50*/    0x50,    0x51,    0x52,    0x53,    0x54,    0x55,    0x56,    0x57,   
    /* P Q R S T U V W */
    /*0x58*/    0x58,    0x59,    0x5a,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x11,     
    /* X Y Z . . . . _ */
    /*0x60*/    NON_GSM, 0x61,    0x62,    0x63,    0x64,    0x65,    0x66,    0x67,     
    /* . a b c d e f g */
    /*0x68*/    0x68,    0x69,    0x6a,    0x6b,    0x6c,    0x6d,    0x6e,    0x6f,     
    /* h i j k l m n o */
    /*0x70*/    0x70,    0x71,    0x72,    0x73,    0x74,    0x75,    0x76,    0x77,    
    /* p q r s t u v w */
    /*0x78*/    0x78,    0x79,    0x7a,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* x y z . . . . . */
    /*0x80*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0x88*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0x90*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, 
    /* . . . . . . . . */
    /*0x98*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, 
    /* . . . . . . . . */
    /*0xa0*/    0x1b,    0x40,    NON_GSM, 0x01,    0x24,    0x03,    NON_GSM, 0x5f,    
    /* . . . . . . . . */
    /*0xa8*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0xb0*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0xb8*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x60,   
    /* . . . . . . . . */
    /*0xc0*/    NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x5b,    0x0e,    0x1c,    0x09,  
    /* . . . . . . . . */
    /*0xc8*/    NON_GSM, 0x1f,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, NON_GSM, 
    /* . . . . . . . . */
    /*0xd0*/    NON_GSM, 0x5d,    NON_GSM, NON_GSM, NON_GSM, NON_GSM, 0x5c,    NON_GSM, 
    /* . . . . . . . . */
    /*0xd8*/    0x0b,    NON_GSM, NON_GSM, NON_GSM, 0x5e,    NON_GSM, NON_GSM, 0x1e,     
    /* . . . . . . . . */
    /*0xe0*/    0x7f,    NON_GSM, NON_GSM, NON_GSM, 0x7b,    0x0f,    0x1d,    NON_GSM,     
    /* . . . . . . . . */
    /*0xe8*/    0x04,    0x05,    NON_GSM, NON_GSM, 0x07,    NON_GSM, NON_GSM, NON_GSM,  
    /* . . . . . . . . */
    /*0xf0*/    NON_GSM, 0x7d,    0x08   , NON_GSM, NON_GSM, NON_GSM, 0x7c,    NON_GSM,  
    /* . . . . . . . . */
    /*0xf8*/    0x0c,    0x06,    NON_GSM, NON_GSM, 0x7e,    NON_GSM, NON_GSM, NON_GSM  
    /* . . . . . . . . */
};

 const unsigned short zte_sms_GSM7_PORTUGUESE_To_UCS2_Table[] =
{
    /* 0x00 */ 0x0040,   /* COMMERCIAL AT */
    /* 0x01 */ 0x00A3,   /* POUND SIGN */
    /* 0x02 */ 0x0024,   /* DOLLAR SIGN */
    /* 0x03 */ 0x00A5,   /* YEN SIGN */
    /* 0x04 */ 0x00EA,   /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
    /* 0x05 */ 0x00E9,   /* LATIN SMALL LETTER E WITH ACUTE */
    /* 0x06 */ 0x00FA,   /* LATIN SMALL LETTER U WITH ACUTE */
    /* 0x07 */ 0x00ED,   /* LATIN SMALL LETTER I WITH ACUTE */
    /* 0x08 */ 0x00F3,   /* LATIN SMALL LETTER O WITH ACUTE */
    /* 0x09 */ 0x00E7,   /* LATIN SMALL LETTER C WITH CEDILLA */
    /* 0x0A */ 0x000A,   /* LINE FEED */
    /* 0x0B */ 0x00D4,   /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
    /* 0x0C */ 0x00F4,   /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
    /* 0x0D */ 0x000D,   /* CARRIAGE RETURN */
    /* 0x0E */ 0x00C1,   /* LATIN CAPITAL LETTER A WITH ACUTE */
    /* 0x0F */ 0x00E1,   /* LATIN SMALL LETTER A WITH ACUTE */
    /* 0x10 */ 0x0394,   /* GREEK CAPITAL LETTER DELTA */
    /* 0x11 */ 0x005F,   /* LOW LINE */
    /* 0x12 */ 0x00AA,   /* FEMININE ORDINAL INDICATOR */
    /* 0x13 */ 0x00C7,
    /* 0x14 */ 0x00C0,   /* LATIN CAPITAL LETTER A WITH GRAVE */
    /* 0x15 */ 0x221E,   /* INFINITY */
    /* 0x16 */ 0x005E,
    /* 0x17 */ 0x005C,
    /* 0x18 */ 0x20AC,
    /* 0x19 */ 0x00D3,
    /* 0x1A */ 0x007C,
    /* 0x1B */ 0x00A0,   /* ESCAPE TO EXTENSION TABLE */
    /* 0x1C */ 0x00C2,   /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
    /* 0x1D */ 0x00E2,   /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
    /* 0x1E */ 0x00CA,   /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
    /* 0x1F */ 0x00C9,   /* LATIN CAPITAL LETTER E WITH ACUTE */
    /* 0x20 */ 0x0020,   /* SPACE */
    /* 0x21 */ 0x0021,   /* EXCLAMATION MARK */
    /* 0x22 */ 0x0022,   /* QUOTATION MARK */
    /* 0x23 */ 0x0023,   /* NUMBER SIGN */
    /* 0x24 */ 0x00B0,   /* MASCULINE ORDINAL INDICATOR */
    /* 0x25 */ 0x0025,   /* PERCENT SIGN */
    /* 0x26 */ 0x0026,   /* AMPERSAND */
    /* 0x27 */ 0x0027,   /* APOSTROPHE */
    /* 0x28 */ 0x0028,   /* LEFT PARENTHESIS */
    /* 0x29 */ 0x0029,   /* RIGHT PARENTHESIS */
    /* 0x2A */ 0x002A,   /* ASTERISK */
    /* 0x2B */ 0x002B,   /* PLUS SIGN */
    /* 0x2C */ 0x002C,   /* COMMA */
    /* 0x2D */ 0x002D,   /* HYPHEN-MINUS */
    /* 0x2E */ 0x002E,   /* FULL STOP */
    /* 0x2F */ 0x002F,   /* SOLIDUS */
    /* 0x30 */ 0x0030,   /* DIGIT ZERO */
    /* 0x31 */ 0x0031,   /* DIGIT ONE */
    /* 0x32 */ 0x0032,   /* DIGIT TWO */
    /* 0x33 */ 0x0033,   /* DIGIT THREE */
    /* 0x34 */ 0x0034,   /* DIGIT FOUR */
    /* 0x35 */ 0x0035,   /* DIGIT FIVE */
    /* 0x36 */ 0x0036,   /* DIGIT SIX */
    /* 0x37 */ 0x0037,   /* DIGIT SEVEN */
    /* 0x38 */ 0x0038,   /* DIGIT EIGHT */
    /* 0x39 */ 0x0039,   /* DIGIT NINE */
    /* 0x3A */ 0x003A,   /* COLON */
    /* 0x3B */ 0x003B,   /* SEMICOLON */
    /* 0x3C */ 0x003C,   /* LESS-THAN SIGN */
    /* 0x3D */ 0x003D,   /* EQUALS SIGN */
    /* 0x3E */ 0x003E,   /* GREATER-THAN SIGN */
    /* 0x3F */ 0x003F,   /* QUESTION MARK */
    /* 0x40 */ 0x00CD,   /* LATIN CAPITAL LETTER I WITH ACUTE */
    /* 0x41 */ 0x0041,   /* LATIN CAPITAL LETTER A */
    /* 0x42 */ 0x0042,   /* LATIN CAPITAL LETTER B */
    /* 0x43 */ 0x0043,   /* LATIN CAPITAL LETTER C */
    /* 0x44 */ 0x0044,   /* LATIN CAPITAL LETTER D */
    /* 0x45 */ 0x0045,   /* LATIN CAPITAL LETTER E */
    /* 0x46 */ 0x0046,   /* LATIN CAPITAL LETTER F */
    /* 0x47 */ 0x0047,   /* LATIN CAPITAL LETTER G */
    /* 0x48 */ 0x0048,   /* LATIN CAPITAL LETTER H */
    /* 0x49 */ 0x0049,   /* LATIN CAPITAL LETTER I */
    /* 0x4A */ 0x004A,   /* LATIN CAPITAL LETTER J */
    /* 0x4B */ 0x004B,   /* LATIN CAPITAL LETTER K */
    /* 0x4C */ 0x004C,   /* LATIN CAPITAL LETTER L */
    /* 0x4D */ 0x004D,   /* LATIN CAPITAL LETTER M */
    /* 0x4E */ 0x004E,   /* LATIN CAPITAL LETTER N */
    /* 0x4F */ 0x004F,   /* LATIN CAPITAL LETTER O */
    /* 0x50 */ 0x0050,   /* LATIN CAPITAL LETTER P */
    /* 0x51 */ 0x0051,   /* LATIN CAPITAL LETTER Q */
    /* 0x52 */ 0x0052,   /* LATIN CAPITAL LETTER R */
    /* 0x53 */ 0x0053,   /* LATIN CAPITAL LETTER S */
    /* 0x54 */ 0x0054,   /* LATIN CAPITAL LETTER T */
    /* 0x55 */ 0x0055,   /* LATIN CAPITAL LETTER U */
    /* 0x56 */ 0x0056,   /* LATIN CAPITAL LETTER V */
    /* 0x57 */ 0x0057,   /* LATIN CAPITAL LETTER W */
    /* 0x58 */ 0x0058,   /* LATIN CAPITAL LETTER X */
    /* 0x59 */ 0x0059,   /* LATIN CAPITAL LETTER Y */
    /* 0x5A */ 0x005A,   /* LATIN CAPITAL LETTER Z */
    /* 0x5B */ 0x00C3,   /* LATIN CAPITAL LETTER A WITH TILDE */
    /* 0x5C */ 0x00D5,   /* LATIN CAPITAL LETTER O WITH TILDE */
    /* 0x5D */ 0x00DA,   /* LATIN CAPITAL LETTER U WITH ACUTE */
    /* 0x5E */ 0x00DC,   /* LATIN CAPITAL LETTER U WITH DIAERESIS */
    /* 0x5F */ 0x00A7,   /* SECTION SIGN */
    /* 0x60 */ 0x007E,   /* INVERTED QUESTION MARK */
    /* 0x61 */ 0x0061,   /* LATIN SMALL LETTER A */
    /* 0x62 */ 0x0062,   /* LATIN SMALL LETTER B */
    /* 0x63 */ 0x0063,   /* LATIN SMALL LETTER C */
    /* 0x64 */ 0x0064,   /* LATIN SMALL LETTER D */
    /* 0x65 */ 0x0065,   /* LATIN SMALL LETTER E */
    /* 0x66 */ 0x0066,   /* LATIN SMALL LETTER F */
    /* 0x67 */ 0x0067,   /* LATIN SMALL LETTER G */
    /* 0x68 */ 0x0068,   /* LATIN SMALL LETTER H */
    /* 0x69 */ 0x0069,   /* LATIN SMALL LETTER I */
    /* 0x6A */ 0x006A,   /* LATIN SMALL LETTER J */
    /* 0x6B */ 0x006B,   /* LATIN SMALL LETTER K */
    /* 0x6C */ 0x006C,   /* LATIN SMALL LETTER L */
    /* 0x6D */ 0x006D,   /* LATIN SMALL LETTER M */
    /* 0x6E */ 0x006E,   /* LATIN SMALL LETTER N */
    /* 0x6F */ 0x006F,   /* LATIN SMALL LETTER O */
    /* 0x70 */ 0x0070,   /* LATIN SMALL LETTER P */
    /* 0x71 */ 0x0071,   /* LATIN SMALL LETTER Q */
    /* 0x72 */ 0x0072,   /* LATIN SMALL LETTER R */
    /* 0x73 */ 0x0073,   /* LATIN SMALL LETTER S */
    /* 0x74 */ 0x0074,   /* LATIN SMALL LETTER T */
    /* 0x75 */ 0x0075,   /* LATIN SMALL LETTER U */
    /* 0x76 */ 0x0076,   /* LATIN SMALL LETTER V */
    /* 0x77 */ 0x0077,   /* LATIN SMALL LETTER W */
    /* 0x78 */ 0x0078,   /* LATIN SMALL LETTER X */
    /* 0x79 */ 0x0079,   /* LATIN SMALL LETTER Y */
    /* 0x7A */ 0x007A,   /* LATIN SMALL LETTER Z */
    /* 0x7B */ 0x00E3,   /* LATIN SMALL LETTER A WITH TILDE */
    /* 0x7C */ 0x00F5,   /* LATIN SMALL LETTER O WITH TILDE */
    /* 0x7D */ 0x0060,   /* GRAVE ACCENT */
    /* 0x7E */ 0x00FC,   /* LATIN SMALL LETTER U WITH DIAERESIS */
    /* 0x7F */ 0x00E0    /* LATIN SMALL LETTER A WITH GRAVE */
};

 const unsigned short zte_sms_GSMDefault_To_UCS2_Table[] =
{
    /* 0x00 */ 0x0040,   /* COMMERCIAL AT */
    /* 0x01 */ 0x00A3,   /* POUND SIGN */
    /* 0x02 */ 0x0024,   /* DOLLAR SIGN */
    /* 0x03 */ 0x00A5,   /* YEN SIGN */
    /* 0x04 */ 0x00E8,   /* LATIN SMALL LETTER E WITH GRAVE */
    /* 0x05 */ 0x00E9,   /* LATIN SMALL LETTER E WITH ACUTE */
    /* 0x06 */ 0x00F9,   /* LATIN SMALL LETTER U WITH GRAVE */
    /* 0x07 */ 0x00EC,   /* LATIN SMALL LETTER I WITH GRAVE */
    /* 0x08 */ 0x00F2,   /* LATIN SMALL LETTER O WITH GRAVE */
    /* 0x09 */ 0x00C7,   /* LATIN SMALL LETTER C WITH CEDILLA */
    /* 0x0A */ 0x000A,   /* LINE FEED */
    /* 0x0B */ 0x00D8,   /* LATIN CAPITAL LETTER O WITH STROKE */
    /* 0x0C */ 0x00F8,   /* LATIN SMALL LETTER O WITH STROKE */
    /* 0x0D */ 0x000D,   /* CARRIAGE RETURN */
    /* 0x0E */ 0x00C5,   /* LATIN CAPITAL LETTER A WITH RING ABOVE */
    /* 0x0F */ 0x00E5,   /* LATIN SMALL LETTER A WITH RING ABOVE */
    /* 0x10 */ 0x0394,   /* GREEK CAPITAL LETTER DELTA */
    /* 0x11 */ 0x005F,   /* LOW LINE */
    /* 0x12 */ 0x03A6,   /* GREEK CAPITAL LETTER PHI */
    /* 0x13 */ 0x0393,   /* GREEK CAPITAL LETTER GAMMA */
    /* 0x14 */ 0x039B,   /* GREEK CAPITAL LETTER LAMDA */
    /* 0x15 */ 0x03A9,   /* GREEK CAPITAL LETTER OMEGA */
    /* 0x16 */ 0x03A0,   /* GREEK CAPITAL LETTER PI */
    /* 0x17 */ 0x03A8,   /* GREEK CAPITAL LETTER PSI */
    /* 0x18 */ 0x03A3,   /* GREEK CAPITAL LETTER SIGMA */
    /* 0x19 */ 0x0398,   /* GREEK CAPITAL LETTER THETA */
    /* 0x1A */ 0x039E,   /* GREEK CAPITAL LETTER XI */
    /* 0x1B */ 0x00A0,   /* ESCAPE TO EXTENSION TABLE */
    /* 0x1C */ 0x00C6,   /* LATIN CAPITAL LETTER AE */
    /* 0x1D */ 0x00E6,   /* LATIN SMALL LETTER AE */
    /* 0x1E */ 0x00DF,   /* LATIN SMALL LETTER SHARP S (German) */
    /* 0x1F */ 0x00C9,   /* LATIN CAPITAL LETTER E WITH ACUTE */
    /* 0x20 */ 0x0020,   /* SPACE */
    /* 0x21 */ 0x0021,   /* EXCLAMATION MARK */
    /* 0x22 */ 0x0022,   /* QUOTATION MARK */
    /* 0x23 */ 0x0023,   /* NUMBER SIGN */
    /* 0x24 */ 0x00A4,   /* CURRENCY SIGN */
    /* 0x25 */ 0x0025,   /* PERCENT SIGN */
    /* 0x26 */ 0x0026,   /* AMPERSAND */
    /* 0x27 */ 0x0027,   /* APOSTROPHE */
    /* 0x28 */ 0x0028,   /* LEFT PARENTHESIS */
    /* 0x29 */ 0x0029,   /* RIGHT PARENTHESIS */
    /* 0x2A */ 0x002A,   /* ASTERISK */
    /* 0x2B */ 0x002B,   /* PLUS SIGN */
    /* 0x2C */ 0x002C,   /* COMMA */
    /* 0x2D */ 0x002D,   /* HYPHEN-MINUS */
    /* 0x2E */ 0x002E,   /* FULL STOP */
    /* 0x2F */ 0x002F,   /* SOLIDUS */
    /* 0x30 */ 0x0030,   /* DIGIT ZERO */
    /* 0x31 */ 0x0031,   /* DIGIT ONE */
    /* 0x32 */ 0x0032,   /* DIGIT TWO */
    /* 0x33 */ 0x0033,   /* DIGIT THREE */
    /* 0x34 */ 0x0034,   /* DIGIT FOUR */
    /* 0x35 */ 0x0035,   /* DIGIT FIVE */
    /* 0x36 */ 0x0036,   /* DIGIT SIX */
    /* 0x37 */ 0x0037,   /* DIGIT SEVEN */
    /* 0x38 */ 0x0038,   /* DIGIT EIGHT */
    /* 0x39 */ 0x0039,   /* DIGIT NINE */
    /* 0x3A */ 0x003A,   /* COLON */
    /* 0x3B */ 0x003B,   /* SEMICOLON */
    /* 0x3C */ 0x003C,   /* LESS-THAN SIGN */
    /* 0x3D */ 0x003D,   /* EQUALS SIGN */
    /* 0x3E */ 0x003E,   /* GREATER-THAN SIGN */
    /* 0x3F */ 0x003F,   /* QUESTION MARK */
    /* 0x40 */ 0x00A1,   /* INVERTED EXCLAMATION MARK */
    /* 0x41 */ 0x0041,   /* LATIN CAPITAL LETTER A */
    /* 0x42 */ 0x0042,   /* LATIN CAPITAL LETTER B */
    /* 0x43 */ 0x0043,   /* LATIN CAPITAL LETTER C */
    /* 0x44 */ 0x0044,   /* LATIN CAPITAL LETTER D */
    /* 0x45 */ 0x0045,   /* LATIN CAPITAL LETTER E */
    /* 0x46 */ 0x0046,   /* LATIN CAPITAL LETTER F */
    /* 0x47 */ 0x0047,   /* LATIN CAPITAL LETTER G */
    /* 0x48 */ 0x0048,   /* LATIN CAPITAL LETTER H */
    /* 0x49 */ 0x0049,   /* LATIN CAPITAL LETTER I */
    /* 0x4A */ 0x004A,   /* LATIN CAPITAL LETTER J */
    /* 0x4B */ 0x004B,   /* LATIN CAPITAL LETTER K */
    /* 0x4C */ 0x004C,   /* LATIN CAPITAL LETTER L */
    /* 0x4D */ 0x004D,   /* LATIN CAPITAL LETTER M */
    /* 0x4E */ 0x004E,   /* LATIN CAPITAL LETTER N */
    /* 0x4F */ 0x004F,   /* LATIN CAPITAL LETTER O */
    /* 0x50 */ 0x0050,   /* LATIN CAPITAL LETTER P */
    /* 0x51 */ 0x0051,   /* LATIN CAPITAL LETTER Q */
    /* 0x52 */ 0x0052,   /* LATIN CAPITAL LETTER R */
    /* 0x53 */ 0x0053,   /* LATIN CAPITAL LETTER S */
    /* 0x54 */ 0x0054,   /* LATIN CAPITAL LETTER T */
    /* 0x55 */ 0x0055,   /* LATIN CAPITAL LETTER U */
    /* 0x56 */ 0x0056,   /* LATIN CAPITAL LETTER V */
    /* 0x57 */ 0x0057,   /* LATIN CAPITAL LETTER W */
    /* 0x58 */ 0x0058,   /* LATIN CAPITAL LETTER X */
    /* 0x59 */ 0x0059,   /* LATIN CAPITAL LETTER Y */
    /* 0x5A */ 0x005A,   /* LATIN CAPITAL LETTER Z */
    /* 0x5B */ 0x00C4,   /* LATIN CAPITAL LETTER A WITH DIAERESIS */
    /* 0x5C */ 0x00D6,   /* LATIN CAPITAL LETTER O WITH DIAERESIS */
    /* 0x5D */ 0x00D1,   /* LATIN CAPITAL LETTER N WITH TILDE */
    /* 0x5E */ 0x00DC,   /* LATIN CAPITAL LETTER U WITH DIAERESIS */
    /* 0x5F */ 0x00A7,   /* SECTION SIGN */
    /* 0x60 */ 0x00BF,   /* INVERTED QUESTION MARK */
    /* 0x61 */ 0x0061,   /* LATIN SMALL LETTER A */
    /* 0x62 */ 0x0062,   /* LATIN SMALL LETTER B */
    /* 0x63 */ 0x0063,   /* LATIN SMALL LETTER C */
    /* 0x64 */ 0x0064,   /* LATIN SMALL LETTER D */
    /* 0x65 */ 0x0065,   /* LATIN SMALL LETTER E */
    /* 0x66 */ 0x0066,   /* LATIN SMALL LETTER F */
    /* 0x67 */ 0x0067,   /* LATIN SMALL LETTER G */
    /* 0x68 */ 0x0068,   /* LATIN SMALL LETTER H */
    /* 0x69 */ 0x0069,   /* LATIN SMALL LETTER I */
    /* 0x6A */ 0x006A,   /* LATIN SMALL LETTER J */
    /* 0x6B */ 0x006B,   /* LATIN SMALL LETTER K */
    /* 0x6C */ 0x006C,   /* LATIN SMALL LETTER L */
    /* 0x6D */ 0x006D,   /* LATIN SMALL LETTER M */
    /* 0x6E */ 0x006E,   /* LATIN SMALL LETTER N */
    /* 0x6F */ 0x006F,   /* LATIN SMALL LETTER O */
    /* 0x70 */ 0x0070,   /* LATIN SMALL LETTER P */
    /* 0x71 */ 0x0071,   /* LATIN SMALL LETTER Q */
    /* 0x72 */ 0x0072,   /* LATIN SMALL LETTER R */
    /* 0x73 */ 0x0073,   /* LATIN SMALL LETTER S */
    /* 0x74 */ 0x0074,   /* LATIN SMALL LETTER T */
    /* 0x75 */ 0x0075,   /* LATIN SMALL LETTER U */
    /* 0x76 */ 0x0076,   /* LATIN SMALL LETTER V */
    /* 0x77 */ 0x0077,   /* LATIN SMALL LETTER W */
    /* 0x78 */ 0x0078,   /* LATIN SMALL LETTER X */
    /* 0x79 */ 0x0079,   /* LATIN SMALL LETTER Y */
    /* 0x7A */ 0x007A,   /* LATIN SMALL LETTER Z */
    /* 0x7B */ 0x00E4,   /* LATIN SMALL LETTER A WITH DIAERESIS */
    /* 0x7C */ 0x00F6,   /* LATIN SMALL LETTER O WITH DIAERESIS */
    /* 0x7D */ 0x00F1,   /* LATIN SMALL LETTER N WITH TILDE */
    /* 0x7E */ 0x00FC,   /* LATIN SMALL LETTER U WITH DIAERESIS */
    /* 0x7F */ 0x00E0    /* LATIN SMALL LETTER A WITH GRAVE */
};
 /**************************************************************************
* ƣ int Bytes2String(const unsigned char* pSrc, char* pDst, int nSrcLength)
*  ֽתΪɴӡַ 磺{0xC8, 0x32, 0x9B, 0xFD, 0x0E, 0x01} --> "C8329BFD0E01"
* ʵı
* ޸ĵı
* 
             pSrc: Դָ
             pDst: Ŀַָ
             nSrcLength: Դݳ
* 
             ޣ
*   ֵ
             Ŀݳȣ
* ˵
* ޸    汾     ޸      ޸
* -----------------------------------------------
* 2004/10/18  V1.0             ú
**************************************************************************/
int Bytes2String(const unsigned char* pSrc, char* pDst, int nSrcLength)
{
    const char tab[]="0123456789ABCDEF";    // 0x0-0xfַұ
    int i=0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i=0; i<nSrcLength; i++)
    {
        *pDst++ = tab[*pSrc >> 4];      // 4λ
        *pDst++ = tab[*pSrc & 0x0f];    // 4λ
        pSrc++;
    }

    // ַӸ
    *pDst = '\0';

    // Ŀַ
    return nSrcLength * 2;
}

 /**************************************************************************
* ƣ int String2Bytes(const char* pSrc, unsigned char* pDst, int nSrcLength)
*  ɴӡַתΪֽ 磺"C8329BFD0E01" --> {0xC8, 0x32, 0x9B, 0xFD, 0x0E, 0x01}
* ʵı 
* ޸ĵı 
* 
             pSrc: Դַָ
             pDst: Ŀָ
            nSrcLength: Դַ
*  
             ޣ 
*   ֵ
             Ŀݳȣ
* ˵ 
* ޸    汾     ޸      ޸
* -----------------------------------------------
* 2004/10/18  V1.0             ú
**************************************************************************/
int String2Bytes(const char* pSrc, unsigned char* pDst, int nSrcLength)
{
    int i=0;
    
    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i = 0; i < nSrcLength; i += 2)
    {
        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst = (*pSrc - '0') << 4;
        }
        else
        {
            *pDst = ((toupper(*pSrc) - 'A') + 10) << 4;
        }

        pSrc++;

        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst |= *pSrc - '0';
        }
        else
        {
            *pDst |= (toupper(*pSrc) - 'A') + 10;
        }

        pSrc++;
        pDst++;
    }

    // Ŀݳ
    return nSrcLength / 2;
}

int EncodeUcs2(const char* pSrc, unsigned char* pDst, int nSrcLength)
{
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }
    (void)String2Bytes(pSrc, pDst, (int)nSrcLength);
    return nSrcLength / 2;
}


int Encode7bit(const char* pSrc, unsigned char* pDst, int nSrcLength)
{
    int nSrc;        // Դַļֵ
    int nDst;        // Ŀ봮ļֵ
    int nChar;       // ǰڴַֽڵţΧ0-7
    unsigned char nLeft = 0;    // һֽڲ

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    // ֵʼ
    nSrc = 0;
    nDst = 0;

    // Դÿ8ֽڷΪһ飬ѹ7ֽ
    // ѭộֱԴ
    // 鲻8ֽڣҲȷ
    while(nSrc<nSrcLength)
    {
        // ȡԴַļֵ3λ
        nChar = nSrc & 7;

        // Դÿֽ
        if(nChar == 0)
        {
            // ڵһֽڣֻǱһֽʱʹ
            nLeft = *pSrc;
			if((g_zUfiSms_ConcatSms.total_msg > 1) && (nSrc == (nSrcLength -1)))
			{
				nDst++;
			}
        }
        else
        {
            // ֽڣұ߲ӣõһĿֽ
            *pDst = (*pSrc << (8-nChar)) | nLeft;

            // ֽʣµ߲֣Ϊݱ
            nLeft = *pSrc >> nChar;

            // ޸Ŀ괮ָͼֵ
            pDst++;
            nDst++;
        }

        // ޸Դָͼֵ
        pSrc++;
        nSrc++;
    }

    // Ŀ괮
    return nDst;
}

SINT32 zUfiSms_EncodePdu_DeliverReport(CHAR* pDst, UINT8 TP_FCS)
{
    SINT32 nLength = 0;
    SINT32 nDstLength = 0;			                   // ĿPDU
    UINT8 buf[256] = {0};	                   // ڲõĻ

    if(NULL == pDst)
    {
        return -1;
    }
    if(TP_FCS != 0x00)//rp_error
    {
        buf[0] = 0x00;
        buf[1] = TP_FCS;
        buf[2] = 0x00;
        nDstLength += Bytes2String(buf, &pDst[nDstLength], 3);//tp_fcs
    }
    else
    {
        buf[0] = 0x00;
        buf[1] = 0x00;
        nDstLength += Bytes2String(buf, &pDst[nDstLength], 2);//tp_fcs
    }

    return nDstLength;
}


unsigned long zUfiSms_ConvertAsciiToGsmDefault(
    const unsigned char * inputs,  unsigned char * outputs,   unsigned long len)
{
    unsigned long i = 0;
    unsigned long j = 0;
    unsigned long k = 0;

    if(NULL == inputs || NULL == outputs)
    {
        printf("sms:invalid inputs");
        return 0;
    }
    for( i = 0; i < len; i++)
    {
        j = inputs[i];
        if (g_zUfiSms_AsciiToGsmdefaultTable[j] < 255)
        {
            outputs[k] = g_zUfiSms_AsciiToGsmdefaultTable[j];
        }
        else
        {
            outputs[k] = (g_zUfiSms_AsciiToGsmdefaultTable[j] & 0xff00) >> 8;
            k ++;
            outputs[k] = (g_zUfiSms_AsciiToGsmdefaultTable[j] & 0xff);
        }
        k++;
    }
    return k;
}


unsigned long zUfiSms_ConvertUcs2ToSpanish
(
    const unsigned char * def,
    unsigned char * gsm_default,
    unsigned long len
)
{
    unsigned long i = 0;
    unsigned long k = 0;
    unsigned long p = 0;
    unsigned long tmp = 0;
    unsigned long s1 = 0, s2 = 0;
    unsigned long q = 0;

    s1 = sizeof(zte_sms_GSM7_SPANISH_To_UCS2_Table_Ex)/sizeof(zte_sms_GSM7_SPANISH_To_UCS2_Table_Ex[0]);
    s2 = sizeof(Ucs2_To_Gsm7_SPANISH_Table_UCS)/sizeof(Ucs2_To_Gsm7_SPANISH_Table_UCS[0]);


    for(i = 0; i < len; i++)
    {
        if(def[i] == 0)
        {
            // is_find = 0;
            i++;
            if(Ucs2_To_Gsm7_SPANISH_Table_ASC[def[i]] != NON_GSM)
            {
                gsm_default[k] = Ucs2_To_Gsm7_SPANISH_Table_ASC[def[i]];
                k++;
                continue;
            }
            else if((Ucs2_To_Gsm7_SPANISH_Table_ASC[def[i]] == NON_GSM) && (def[i] == 0x20))
            {
                gsm_default[k] = 0x20;
                k++;
                continue;
            }

            for(q = 0; q < s1; q++)
            {
                if(def[i] == zte_sms_GSM7_SPANISH_To_UCS2_Table_Ex[q][1])
                {
                    gsm_default[k] = 0x1b;
                    k++;
                    gsm_default[k] = zte_sms_GSM7_SPANISH_To_UCS2_Table_Ex[q][0];
                    // is_find = 1;
                    break;
                }
            }
        }
        else
        {
            // is_find = 0;
            tmp = (def[i] << 8) + def[i+1];
            i++;
            if(tmp == 0x20AC)   /* EURO SIGN */
            {
                gsm_default[k] = 0x1b;
                k++;
                gsm_default[k] = 0x65;
                // is_find = 1;
                k++;
            }
            for(p = 0; p < s2; p++)
            {
                if(tmp == Ucs2_To_Gsm7_SPANISH_Table_UCS[p][1])
                {
                    gsm_default[k] = Ucs2_To_Gsm7_SPANISH_Table_UCS[p][0];
                    // is_find = 1;
                    break;
                }
            }
        }
        k++;
    }
    gsm_default[k] = '\0';
    return k;
}

 unsigned long zUfiSms_ConvertUcs2ToPortuguese
(
    const unsigned char * def,
    unsigned char * gsm_default,
    unsigned long len
)
{
    unsigned long i = 0;
    unsigned long k = 0;
    unsigned long p = 0;
    unsigned long tmp = 0;
    unsigned long s1 = 0, s2 = 0;
//    unsigned long is_find = 0;
    unsigned long q = 0;

    s1 = sizeof(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex)/sizeof(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[0]);
    s2 = sizeof(Ucs2_To_Gsm7_PORTUGUESE_Table_UCS)/sizeof(Ucs2_To_Gsm7_PORTUGUESE_Table_UCS[0]);


    for(i = 0; i < len; i++)
    {
        if(def[i] == 0)
        {
            // is_find = 0;
            i++;
            if(Ucs2_To_Gsm7_PORTUGUESE_Table_ASC[def[i]] != NON_GSM)
            {
                gsm_default[k] = Ucs2_To_Gsm7_PORTUGUESE_Table_ASC[def[i]];
                k++;
                continue;
            }
            else if((Ucs2_To_Gsm7_PORTUGUESE_Table_ASC[def[i]] == NON_GSM) && (def[i] == 0x20))
            {
                gsm_default[k] = 0x20;
                k++;
                continue;
            }
            for(q = 0; q < s1; q++)
            {
                if(def[i] == zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[q][1])
                {
                    gsm_default[k] = 0x1b;
                    k++;
                    gsm_default[k] = zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[q][0];
                    // is_find = 1;
                    break;
                }
            }
        }
        else
        {
            // is_find = 0;
            tmp = (def[i] << 8) + def[i+1];
            i++;
            if(tmp == 0x20AC)   /* EURO SIGN */
            {
                gsm_default[k] = 0x1b;
                k++;
                gsm_default[k] = 0x65;
                // is_find = 1;
                k++;
                continue;
            }
            for(p = 0; p < s2; p++)
            {
                if(tmp == Ucs2_To_Gsm7_PORTUGUESE_Table_UCS[p][1])
                {
                    gsm_default[k] = Ucs2_To_Gsm7_PORTUGUESE_Table_UCS[p][0];
                    // is_find = 1;
                    break;
                }
            }
        }
        k++;
    }
    gsm_default[k] = '\0';
    return k;
}

 unsigned long zUfiSms_ConvertUcs2ToGsmDefault
( const unsigned char * def,  unsigned char * gsm_default, unsigned long len)
{
    unsigned long i = 0;
    unsigned long k = 0;
    unsigned long p = 0;
    unsigned long tmp = 0;
    unsigned long s1 = 0, s2 = 0;
     unsigned long q = 0;

    s1 = sizeof(zte_sms_GSMDefault_To_UCS2_Table_Ex)/sizeof(zte_sms_GSMDefault_To_UCS2_Table_Ex[0]);
    s2 = sizeof(UCS2_To_GSMDefault_Table_UCS2)/sizeof(UCS2_To_GSMDefault_Table_UCS2[0]);
    for(i = 0; i < len; i++)
    {
        if(def[i] == 0)
        {
            // is_find = 0;
            i++;
            if(UCS2_To_GSMDefault_Table_ASC[def[i]] != NON_GSM)
            {
                gsm_default[k] = UCS2_To_GSMDefault_Table_ASC[def[i]];
                k++;
                continue;
            }
            else if((UCS2_To_GSMDefault_Table_ASC[def[i]] == NON_GSM) && (def[i] == 0x20))
            {
                gsm_default[k] = 0x20;
                k++;
                continue;
            }
            for(q = 0; q < s1; q++)
            {
                if(def[i] == zte_sms_GSMDefault_To_UCS2_Table_Ex[q][1])
                {
                    gsm_default[k] = 0x1b;
                    k++;
                    gsm_default[k] = zte_sms_GSMDefault_To_UCS2_Table_Ex[q][0];
                    // is_find = 1;
                    break;
                }
            }
        }
        else
        {
            // is_find = 0;
            tmp = (def[i] << 8) + def[i+1];
            i++;
            if(tmp == 0x20AC)   /* EURO SIGN */
            {
                gsm_default[k] = 0x1b;
                k++;
                gsm_default[k] = 0x65;
                // is_find = 1;
                k++;
                continue;
            }
            for(p = 0; p < s2; p++)
            {
                if(tmp == UCS2_To_GSMDefault_Table_UCS2[p][1])
                {
                    gsm_default[k] = UCS2_To_GSMDefault_Table_UCS2[p][0];
                    // is_find = 1;
                    break;
                }
            }
        }
        k++;
    }

    gsm_default[k] = '\0';
    return k;
}

UINT8 zUfiSms_TsIntToBcd( const UINT8 i )
{
    return (UINT8)(((i % 10) + ((i / 10) << 4)));
}

void zUfiSms_DecodeRelativeTime(UINT8 iValidTime,  T_zUfiSms_TimeStamp  *ptTimeStamp)
{
    uint32  i = 0;

    if (ptTimeStamp != NULL)
    {
        memset( (void*) ptTimeStamp, 0, sizeof(wms_timestamp_s_type) );

        if( iValidTime < 144 )
        {
            i = ( iValidTime + 1 ) * 5; /* minutes */
            ptTimeStamp->hour    = (UINT8)zUfiSms_TsIntToBcd((UINT8)(i/60));
            ptTimeStamp->minute  = (UINT8)zUfiSms_TsIntToBcd((UINT8)(i % 60));
        }
        else if (iValidTime < 167)
        {
            i = ( iValidTime - 143 ) * 30; /* minutes */
            ptTimeStamp->hour    = (UINT8)zUfiSms_TsIntToBcd((UINT8)(12 + i/60));
            ptTimeStamp->minute  = (UINT8)zUfiSms_TsIntToBcd((UINT8)(i % 60));
        }
        else if (iValidTime < 197)
        {
            i = iValidTime - 166; /* days */
            ptTimeStamp->month    = (UINT8)zUfiSms_TsIntToBcd((UINT8)(i/30));
            ptTimeStamp->day      = (UINT8)zUfiSms_TsIntToBcd((UINT8)(i % 30));
        }
        else
        {
            i = ( iValidTime - 192 ) * 7; /* days */
            ptTimeStamp->year     = (UINT8)zUfiSms_TsIntToBcd((UINT8)(i/365));
            ptTimeStamp->month    = (UINT8)zUfiSms_TsIntToBcd((UINT8)((i%365)/30));
            ptTimeStamp->day      = (UINT8)zUfiSms_TsIntToBcd((UINT8)(( i % 365 ) % 30));
        }

    }
    else
    {
        printf("null pointer in wms_ts_decode_relative_time");
    }
} /* wms_ts_decode_relative_time() */

 /* addrеַתΪ֣洢digits */
int zUfiSms_CharToInt(char *pCharArray,  int iLen,   unsigned char  *pIntArray)
{
    int i = 0;

    if (pIntArray == NULL || pCharArray == NULL)
    {
        return ZUFI_FAIL;
    }

    for (i = 0; i < iLen; i++)
    {
        pIntArray[i] = pCharArray[i] - '0';
    }
	return ZUFI_SUCC;
}


//gsm7ʽļ¼Ϣȫg_zUfiSms_SendingSms
void zUfiSms_FillGlobalTpudGsm7
(
    T_zUfiSms_SubmitTpdu *ptSubmit,
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_DbStoreData *ptDbSaveData
)
{
    int i = 0;
    
    if(ptConcatSms->total_msg > 1)
    {
        //ţ7ֽڵͷ
        g_zUfiSms_SendingSms.TP_UDHI = 1;
        g_zUfiSms_SendingSms.TP_UD[0] = 5;
        g_zUfiSms_SendingSms.TP_UD[1] = 5;
        g_zUfiSms_SendingSms.TP_UD[2] = 3;
        g_zUfiSms_SendingSms.TP_UD[3] = (char)ptDbSaveData->concat_info[0] % 0xff;
        g_zUfiSms_SendingSms.TP_UD[4] = (char) ptConcatSms->total_msg;
        g_zUfiSms_SendingSms.TP_UD[5] = (char) ptConcatSms->current_sending+1;   
        g_zUfiSms_SendingSms.TP_UD[6] = 6;

        for(i = 0; i < ptSubmit->user_data.sm_len; i++)
        {
            g_zUfiSms_SendingSms.TP_UD[i+7] = ptSubmit->user_data.sm_data[i] ;
        }
        g_zUfiSms_SendingSms.TP_UDLength = ptSubmit->user_data.sm_len + 7;
    }
    else
    {
        for(i = 0; i < ptSubmit->user_data.sm_len; i++)
        {
            g_zUfiSms_SendingSms.TP_UD[i] = ptSubmit->user_data.sm_data[i] ;
        }
        g_zUfiSms_SendingSms.TP_UDLength = ptSubmit->user_data.sm_len;
    }
}
//ucs2ʽļ¼Ϣȫg_zUfiSms_SendingSms
void zUfiSms_FillGlobalTpudUcs2
(
    T_zUfiSms_SubmitTpdu *ptSubmit,
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_DbStoreData *ptDbSaveData
)
{
    if(ptConcatSms->total_msg > 1)
    {
        g_zUfiSms_SendingSms.TP_UDHI = 1;
        g_zUfiSms_SendingSms.TP_UD[0] = 5;
        g_zUfiSms_SendingSms.TP_UD[1] = 5;
        g_zUfiSms_SendingSms.TP_UD[2] = 3;
        g_zUfiSms_SendingSms.TP_UD[3] = (char) ptDbSaveData->concat_info[0] % 0xff;
        g_zUfiSms_SendingSms.TP_UD[4] = (char) ptConcatSms->total_msg;
        g_zUfiSms_SendingSms.TP_UD[5] = (char) ptConcatSms->current_sending+1;   
        (void)Bytes2String(ptSubmit->user_data.sm_data, &g_zUfiSms_SendingSms.TP_UD[6], ptSubmit->user_data.sm_len); 
    }
    else
    {
        (void)Bytes2String(ptSubmit->user_data.sm_data, g_zUfiSms_SendingSms.TP_UD, ptSubmit->user_data.sm_len);  
    }
}

unsigned char zUfiSms_Low2High(unsigned char x)
{
    if (x >= 'a' && x < 'g')
    {
        x = (x - 'a') + 'A';
    }

    return x;
}

unsigned char zUfiSms_Char2Dec(unsigned char x)
{
    unsigned char d = 0;
    
    if (x >= 'A'  && x <'G')
    {
        d = (x - 'A') + 10;
    }
    else
    {
        d = x - '0';
    }

    return d;
}

unsigned char zUfiSms_Char2Byte(unsigned char a, unsigned char b)
{
    unsigned char data = 0;
    unsigned char l = 0, h = 0;

    a = zUfiSms_Low2High(a);
    b = zUfiSms_Low2High(b);
    h = zUfiSms_Char2Dec(a);
    l = zUfiSms_Char2Dec(b);

    data = h*16  + l;

    return data;
}


void zUfiSms_Str2Bytes(unsigned char *text, int text_len,unsigned char *data, int data_len)
{
    int i = 0;

    while (2 * i + 1 < text_len)
    {
        data[i] = zUfiSms_Char2Byte(text[2*i], text[2*i + 1]);
        i ++;
    }
}


//inputеַַcMatchCharΪָзָָηŵָoutputУָĸ
int zUfiSms_SplitString(char *input, char ***output,char cMatchChar)
{
    int src = 0;
    int dst = 0;
    int  count = 0;
    int size = 8;
    char quoted = 0;
	char **tmpout = NULL;

    //ȷ8ֽڣҪ
    *output = (char**)malloc(sizeof(char*) * size);
    if(NULL == *output)
    {
        return -1;
    }
    
    /* split alias_string */
    (*output)[count++] = input;
    for (src = dst = 0; input[src];)
    {
        char cInputChar = input[src];
        if (!quoted && cInputChar == cMatchChar)
        {
            input[dst++] = 0;
            while (input[++src] && (int)isspace(input[src])) {} ; /* ո */
            if (count >= size)
            {
                size += 16;
                //*output = (char**)realloc(*output, sizeof(char*) * size);
				//klocwork
				tmpout = (char**)realloc(*output, sizeof(char*) * size);
				if (NULL == tmpout) {
					return -1;
				}
				*output = tmpout;
			}
            (*output)[count++] = input + dst;
        }
        else if (!quoted && (cInputChar == '\'' || cInputChar == '"'))
        {
            quoted = cInputChar;
            src++;
        }
        else if (cInputChar == quoted)
        {
            quoted = 0;
            src++;
        }
        else
        {
            if (cInputChar == '\\' && quoted != '\'')
            {
                src++;
                cInputChar = input[src];
                if (!cInputChar)
                {
                    free(*output);
                    *output = NULL;
                    return -1;
                }
            }
            input[dst++] = cInputChar;
            src++;
        }
    }
    input[dst] = 0;

    if (quoted)
    {
        free(*output);
        *output = NULL;
        return -1;
    }
    return count;
}

int zUfiSms_atohex(char c)
{
    int result = 0;
    
    if(c >= '0' && c <= '9')
    {
        result = c - '0';
    }
    else if(c>='a' && c<='f')
    {
        result = (c - 'a') + 10;
    }
    else if(c>='A' && c<='F')
    {
        result = (c - 'A') + 10;
    }
    else
    {
        at_print(LOG_DEBUG,"zUfiSms_atohex error,can unknown char:%c\n",c);
        return result;
    }
    return result;
}

/* in_ptrһֳ16ƣout_ptr*/
int zUfiSms_DispatchWtoi(unsigned char *in_ptr,int iLength,unsigned char *out_ptr)
{
    int low = 0;
    int high = 0;

    if (in_ptr == NULL || out_ptr == NULL)
    {
        printf("sms:invaild parameter\n");
        return ZUFI_FAIL;
    }

    while (iLength > 0)
    {
        low  = in_ptr[iLength - 1] & 0xf;
        high = (in_ptr[iLength - 1] & 0xf0) >> 4;
        out_ptr[2*iLength - 1] = g_zUfiSms_DigAscMap[low];
        out_ptr[2*iLength - 2] = g_zUfiSms_DigAscMap[high];
        iLength --;
    }
    return ZUFI_SUCC;
}
 unsigned int zte_wms_convert_PORTUGUESE_To_UCS2
(
    const unsigned char   *gsmdef,
    unsigned char        *ucs2,
    unsigned int          len
)
{
    unsigned int  i = 0;
    unsigned int  j = 0;
    unsigned int  k = 0;
    unsigned int  p = 0;
    unsigned int    s = 0;
//    unsigned int is_find = 0;

    s = sizeof(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex)/sizeof(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[0]);
    for( i = 0; i < len; i++ )
    {
        j = gsmdef[i];
        if (j == 0x1b)
        {
            i++;
            for(p = 0; p < s; p++)
            {
                if(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[p][0] == gsmdef[i])
                {
                    ucs2[k] = zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[p][1] >> 8;
                    k++;
                    ucs2[k] = (unsigned char)(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table_Ex[p][1]);
                    // is_find = 1;
                    break;
                }
            }
        }
        else
        {
            ucs2[k] = zte_sms_GSM7_PORTUGUESE_To_UCS2_Table[j] >> 8;
            k++;
            ucs2[k] = (unsigned char)(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table[j]);
        }
        k++;
    }
    ucs2[k] = '\0';

    return k;
}

 unsigned int zte_wms_convert_PORTUGUESE_To_UCS2_USE_GSM7_SS_PORTU_LS
(
    const unsigned char   *gsmdef,
    unsigned char        *ucs2,
    unsigned int          len
)
{
    unsigned int  i = 0;
    unsigned int  j = 0;
    unsigned int  k = 0;
    unsigned int  p = 0;
    unsigned int    s = 0;
//    unsigned int is_find = 0;

    s = sizeof(zte_sms_GSMDefault_To_UCS2_Table_Ex)/sizeof(zte_sms_GSMDefault_To_UCS2_Table_Ex[0]);
    for( i = 0; i < len; i++ )
    {
        j = gsmdef[i];
        if (j == 0x1b)
        {
            i++;
            for(p = 0; p < s; p++)
            {
                if(zte_sms_GSMDefault_To_UCS2_Table_Ex[p][0] == gsmdef[i])
                {
                    ucs2[k] = zte_sms_GSMDefault_To_UCS2_Table_Ex[p][1] >> 8;
                    k++;
                    ucs2[k] = (unsigned char)(zte_sms_GSMDefault_To_UCS2_Table_Ex[p][1]);
                    // is_find = 1;
                    break;
                }
            }
        }
        else
        {
            ucs2[k] = zte_sms_GSM7_PORTUGUESE_To_UCS2_Table[j] >> 8;
            k++;
            ucs2[k] = (unsigned char)(zte_sms_GSM7_PORTUGUESE_To_UCS2_Table[j]);
        }
        k++;
    }
    ucs2[k] = '\0';

    return k;
}

 unsigned long zte_wms_convert_GSMDefault_to_UCS2
(
    const unsigned char   *gsmdef,
    unsigned char       *ucs2,
    unsigned long          len
)
{
    unsigned long  i = 0;
    unsigned long  j = 0;
    unsigned long  k = 0;
    unsigned long  p = 0;
    unsigned long    s = 0;
    unsigned long is_find = 0;

    s = sizeof(zte_sms_GSMDefault_To_UCS2_Table_Ex)/sizeof(zte_sms_GSMDefault_To_UCS2_Table_Ex[0]);
    for( i = 0; i < len; i++ )
    {
        j = gsmdef[i];
        if (j == 0x1b)
        {
            i++;
            for(p = 0; p < s; p++)
            {
                if(zte_sms_GSMDefault_To_UCS2_Table_Ex[p][0] == gsmdef[i])
                {
                    ucs2[k] = zte_sms_GSMDefault_To_UCS2_Table_Ex[p][1] >> 8;
                    k++;
                    ucs2[k] = (unsigned char)(zte_sms_GSMDefault_To_UCS2_Table_Ex[p][1]);
                    is_find = 1;
                    break;
                }
            }
            if(!is_find)
            {
                at_print(LOG_DEBUG,"sms: data = %d not find in gsmdefault extension table\n", gsmdef[i]);
				/*ʵܾ0x1bҪ˴*/
				i--;
				ucs2[k] = zte_sms_GSMDefault_To_UCS2_Table[j] >> 8;
				k++;
				ucs2[k] = (unsigned char)(zte_sms_GSMDefault_To_UCS2_Table[j]);
            }
        }
        else
        {
            ucs2[k] = zte_sms_GSMDefault_To_UCS2_Table[j] >> 8;
            k++;
            ucs2[k] = (unsigned char)(zte_sms_GSMDefault_To_UCS2_Table[j]);
        }
        k++;
    }
    ucs2[k] = '\0';

    return k;
}
 

void zUfiSms_ConvertUcs2(char *data,  UINT16 sms_len, char *out_content)
{
    char ascii_content [2 * ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX+1] = {0};
    UINT16 len = 0;
    
    switch (g_zUfiSms_Language)
    {
        case DCS_PORTUGUESE:
            if (g_zUfiSms_IsLanguageShift == WMS_UDH_NAT_LANG_SS)
            {
                len = zte_wms_convert_PORTUGUESE_To_UCS2 (
                          (const UINT8*)data,
                          (UINT8*)ascii_content,sms_len);
            }
            else if (g_zUfiSms_IsLanguageShift == WMS_UDH_NAT_LANG_LS)
            {
                len = zte_wms_convert_PORTUGUESE_To_UCS2_USE_GSM7_SS_PORTU_LS(
                          (const UINT8*)data,
                          (UINT8*)ascii_content,sms_len);
            }
            break;
            /* added by zhangjingkun for locking shift 20130114 end*/
        case DCS_USC:
        default:
            len = zte_wms_convert_GSMDefault_to_UCS2(
                      (const UINT8*)data,
                      (UINT8*)ascii_content,sms_len);
            break;
    }
    (void)zUfiSms_DispatchWtoi((char*)ascii_content, len, (char*)out_content);
}


boolean zUfiSms_DecodeContent(char *msg_content, UINT16 sms_len, boolean isEsc, char *out_content)
{
    boolean endEsc = FALSE;
    char *p = NULL;
    static char data [1 + 160 + 1] = {0};
    int len = 0;
    //klocwork
    if (msg_content == NULL || out_content == NULL || sms_len > 320 || sms_len < 2)
    {
        return endEsc;
    }
    
    len = sms_len;
    memset(data, 0, 162);
    p = data;
    if (isEsc)
    {
        *p = 0x1b;
        p++;
    }
    zUfiSms_Str2Bytes ((unsigned char *)msg_content, len, (unsigned char *)p, 160);
    if (p[len / 2 -1] == 0x1b)
    {
        endEsc = TRUE;
    }
    zUfiSms_ConvertUcs2(data,len/2 + (isEsc?1:0) - (endEsc?1:0), out_content);
    return endEsc;
}

byte * zUfiSms_SmsiUtilitoa
(
    uint32 v,         /*  Value to convert to ASCII     */
    byte *s,        /*  Pointer to string for result  */
    UINT16 r          /*  Conversion radix              */
)
{
    byte buf[33], c;
    int n;

    n = sizeof(buf) - 1;
    buf[n] = '\0';

    do
    {
        c = (byte) (v % r);
        if (n <= 0)
        {
            printf("OVERFLOW " );
            break;
        }
        buf[--n] = (byte) ( (c > 9) ? c + 'A' - 10 : c + '0');
    }
    while ( (v /= r) > 0);
    while ( (*s++ = buf[n++]) != 0);

    return (s-1);
}

byte* zUfiSms_SmsiAddrToStr
(
    wms_address_s_type addr,  /* Address data structure           */
    byte * res_ptr,           /* pointer to result buffer         */
    UINT8 * type_of_addr     /* pointer to type of address field */
)
{
    byte bcd_idx=0;
    UINT8 temp = 0;

    *type_of_addr  = 0;
    temp = (UINT8)((uint32)addr.number_type & 0x07);
    *type_of_addr = (UINT8)((*type_of_addr | temp ) << 4);
    temp = (UINT8)((uint32)addr.number_plan & 0x07);
    *type_of_addr = *type_of_addr | temp ;
    *type_of_addr = *type_of_addr | 0x80;

    while(bcd_idx < addr.number_of_digits)
    {
        if (addr.digits[bcd_idx] == 0xa)
        {
            addr.digits[bcd_idx] = 0;
        }
        res_ptr = zUfiSms_SmsiUtilitoa((uint32) addr.digits[bcd_idx], res_ptr, 16);
        bcd_idx++;
    }

    return res_ptr;
}/* dsatetsismsi_addr_to_str */

 byte * zUfiSms_SmsiUtilitoaFill(word v, byte *rb_ptr)
{
    int n;
    byte c, *ptr;

    ptr = rb_ptr + 2;
    *ptr = '\0';

    for (n = 0; n < 2; ++n)
    {
        c = (byte) (v % 10);
        v /= 10;
        *--ptr = (c + '0');
    }

    return rb_ptr + 2;
}

 void zUfiSms_SprintfTime(char *str_time, int len,int t)
{
    if (t < 10)
    {
        snprintf(str_time, len,"0%x", t);
    }
    else
    {
        snprintf(str_time, len,"%x", t);
    }
}


/* parse the deliver 8bit header **/
static void zUfiSms_ParseDeliverConcat8
(
    T_zUfiSms_UdhConcat8 *concat_8,
    T_zUfiSms_DbStoreData *db_data
)
{
    int mux = 0;

    concat_8->seq_num--;

    if (concat_8->total_sm > ZTE_WMS_CONCAT_SMS_COUNT_MAX)
    {
        mux = (concat_8->seq_num - concat_8->seq_num %
               ZTE_WMS_CONCAT_SMS_COUNT_MAX) / ZTE_WMS_CONCAT_SMS_COUNT_MAX;
    }

    db_data->concat_sms = 1;
    db_data->concat_info[0] = 255 * mux + concat_8->msg_ref;
    db_data->concat_info[2] = concat_8->seq_num % ZTE_WMS_CONCAT_SMS_COUNT_MAX + 1;
    db_data->concat_info[1] =
        concat_8->total_sm - ZTE_WMS_CONCAT_SMS_COUNT_MAX * mux >
        ZTE_WMS_CONCAT_SMS_COUNT_MAX -1 ? ZTE_WMS_CONCAT_SMS_COUNT_MAX :
        (concat_8->total_sm % ZTE_WMS_CONCAT_SMS_COUNT_MAX);
}


static void zUfiSms_ParserLangSs( wms_udh_s_type *user_data_header)
{
    if (user_data_header == NULL)
    {
        return ;
    }

    switch(user_data_header->u.nat_lang_ss.nat_lang_id)
    {
        case WMS_UDH_NAT_LANG_PORTUGUESE:
            g_zUfiSms_Language = DCS_PORTUGUESE;
            break;
        default:
            break;
    }
}

static void zUfiSms_ParserLangLs(T_zUfiSms_Udh *user_data_header)
{
    if (user_data_header == NULL)
    {
        return ;
    }
    switch(user_data_header->u.nat_lang_ss.nat_lang_id)
    {
        case WMS_UDH_NAT_LANG_PORTUGUESE:
            g_zUfiSms_Language = DCS_PORTUGUESE;
            break;
        default:
            break;
    }

}

/** parse the deliver 16bit header  ***/
static void  zUfiSms_ParseDeliverConcat16
(
    T_zUfiSms_UdhConcat16 *concat_16,
    T_zUfiSms_DbStoreData *db_data
)
{
    int mux = 0;
    concat_16->seq_num--;
    db_data->concat_sms = 1;
#if 0
    db_data->concat_info[0] = concat_16->msg_ref;
    db_data->concat_info[1] = concat_16->total_sm;
    db_data->concat_info[2] = concat_16->seq_num;
#endif
    if (concat_16->total_sm > ZTE_WMS_CONCAT_SMS_COUNT_MAX)
    {
        mux = (concat_16->seq_num - concat_16->seq_num %
               ZTE_WMS_CONCAT_SMS_COUNT_MAX) / ZTE_WMS_CONCAT_SMS_COUNT_MAX;
    }

    db_data->concat_info[0] = 255 * mux + concat_16->msg_ref;
    db_data->concat_info[2] = concat_16->seq_num % ZTE_WMS_CONCAT_SMS_COUNT_MAX + 1;
    db_data->concat_info[1] =
        concat_16->total_sm - ZTE_WMS_CONCAT_SMS_COUNT_MAX * mux >
        ZTE_WMS_CONCAT_SMS_COUNT_MAX -1  ? ZTE_WMS_CONCAT_SMS_COUNT_MAX :
        (concat_16->total_sm % ZTE_WMS_CONCAT_SMS_COUNT_MAX);
}

static int zUfiSms_ParseUdhiData
(
    T_zUfiSms_Udh *user_data_header,
    T_zUfiSms_DbStoreData *db_data
)
{
    if(NULL == user_data_header || NULL == db_data)
    {
        printf("invalid inputs.");
        return ZUFI_FAIL;
    }
    switch (user_data_header->header_id)
    {
        case WMS_UDH_CONCAT_8:
            db_data->concat_sms = 1;
            zUfiSms_ParseDeliverConcat8(&(user_data_header->u.concat_8), db_data);
            break;
        case WMS_UDH_CONCAT_16:
            db_data->concat_sms = 1;
            zUfiSms_ParseDeliverConcat16(&(user_data_header->u.concat_16), db_data);
            break;
        case WMS_UDH_NAT_LANG_SS:
            g_zUfiSms_IsLanguageShift = WMS_UDH_NAT_LANG_SS;
            zUfiSms_ParserLangSs(user_data_header);
            break;

        case WMS_UDH_NAT_LANG_LS:
            g_zUfiSms_IsLanguageShift = WMS_UDH_NAT_LANG_LS;
            zUfiSms_ParserLangLs(user_data_header);
            break;

        default:
            printf("not support those user header");
            break;
    }
    return ZUFI_SUCC;
}

int zUfiSms_FormatDeliverDbdata
(
    T_zUfiSms_ClientTsData *ts_data_ptr,
    T_zUfiSms_DbStoreData *db_data
)
{
    int result = ZUFI_SUCC;
    wms_address_s_type *address_ptr = NULL;
    wms_gw_alphabet_e_type tp_dcs = WMS_GW_ALPHABET_MAX32;
    int i = 0;
    int ind = 0;

    if((NULL == ts_data_ptr) || (NULL == db_data))
    {
        printf("invalid inputs.");
        return ZUFI_FAIL;
    }

    //g_zUfiSms_Language = 0;

    address_ptr = &(ts_data_ptr->u.gw_pp.u.deliver.address);/*set number address */
    if(WMS_NUMBER_INTERNATIONAL == address_ptr->number_type)
    {
        memset(db_data->number, 0,ZTE_WMS_ADDRESS_LEN_MAX+1);
        db_data->number[0] = '+';
        for ( i = 0; i < address_ptr->number_of_digits; i++)
        {
            if (0x0a == address_ptr->digits[i])
            {
                db_data->number[i+1] = '0';
            }
            else
            {
                db_data->number[i+1] = '0'+address_ptr->digits[i];
            }
        }
    }
    else if (WMS_NUMBER_ALPHANUMERIC == address_ptr->number_type)
    {
        memcpy(db_data->number, address_ptr->digits, address_ptr->number_of_digits);
    }
    else
    {
        if (address_ptr->digit_mode == WMS_DIGIT_MODE_8_BIT)
        {
            memcpy(&(db_data->number[1]), address_ptr->digits, address_ptr->number_of_digits);
        }
        else
        {
            for ( i = 0; i < address_ptr->number_of_digits; i++)
            {
                if (0x0a == address_ptr->digits[i])
                {
                    db_data->number[i] = '0';
                }
                else
                {
                    db_data->number[i] = '0'+address_ptr->digits[i];
                }
            }
        }
    }
    (void)zUfiSms_UtilTimeStamp(ts_data_ptr->u.gw_pp.u.deliver.timestamp,
                                 db_data->tp_scts, &db_data->julian_date);

    if (ts_data_ptr->u.gw_pp.u.deliver.user_data_header_present)
    {
        db_data->tp_udhi = 1;
    }
    else
    {
        db_data->tp_udhi = 0;
    }
    if (db_data->tp_udhi == 1)
    {
        for (ind = 0; ind < ts_data_ptr->u.gw_pp.u.deliver.user_data.num_headers; ind ++)
        {
            result = zUfiSms_ParseUdhiData(
                         &(ts_data_ptr->u.gw_pp.u.deliver.user_data.headers[ind]),
                         db_data);
            if(ZTE_WMS_CONCAT_SMS_COUNT_MAX < db_data->concat_info[1])
            {
                printf("the concat sms segment is %d,and larger then the  supported %d segments,so did not deal the concat sms. ",
                       db_data->concat_info[1],ZTE_WMS_CONCAT_SMS_COUNT_MAX);
                if(WMS_STORAGE_TYPE_NV_V01 == db_data->mem_store)
                {
                    zUfiSms_DelModemSms(db_data->index);  
                }
                result = ZUFI_FAIL;
            }
        }
    }
    tp_dcs = ts_data_ptr->u.gw_pp.u.deliver.dcs.alphabet;       /*dcs,pid*/
    db_data->sms_class  = ts_data_ptr->u.gw_pp.u.deliver.dcs.msg_class;//added by tianfuling 20130301 for sms class
    if (WMS_GW_ALPHABET_8_BIT >= tp_dcs)
    {
        db_data->tp_dcs = (unsigned char)1;        /*1-->ASCII, 2-->UNICODE*/
    }
    else if (WMS_GW_ALPHABET_UCS2 == tp_dcs)
    {
        db_data->tp_dcs = (unsigned char)2;
    }
    else
    {
        printf("invalid tp_dcs=%d",tp_dcs);
    }
    db_data->tp_pid = (unsigned char)ts_data_ptr->u.gw_pp.u.deliver.pid;

    if (ts_data_ptr->u.gw_pp.u.deliver.dcs.alphabet == WMS_GW_ALPHABET_UCS2)
    {
        result = zUfiSms_DispatchWtoi(
                     ts_data_ptr->u.gw_pp.u.deliver.user_data.sm_data,
                     ts_data_ptr->u.gw_pp.u.deliver.user_data.sm_len,
                     db_data->sms_content);
        db_data->alphabet = WMS_GW_ALPHABET_UCS2; //added by tianfuling for extension character bug 20121126
    }
    else if (ts_data_ptr->u.gw_pp.u.deliver.dcs.alphabet  == WMS_GW_ALPHABET_8_BIT)
    {
        for (ind = 0; ind < ts_data_ptr->u.gw_pp.u.deliver.user_data.sm_len; ind ++)
        {
            db_data->sms_content[4 * ind] = '0';
            db_data->sms_content[4 * ind + 1] = '0';
            db_data->sms_content[4 * ind + 2] =
                g_zUfiSms_DigAscMap[((ts_data_ptr->u.gw_pp.u.deliver.user_data.sm_data[ind] & 0xf0) >> 4)];
            db_data->sms_content[4 * ind + 3] =
                g_zUfiSms_DigAscMap[(ts_data_ptr->u.gw_pp.u.deliver.user_data.sm_data[ind] & 0xf)];
            db_data->alphabet = WMS_GW_ALPHABET_UCS2;
        }
    }
    else if (ts_data_ptr->u.gw_pp.u.deliver.dcs.alphabet == WMS_GW_ALPHABET_7_BIT_DEFAULT)
    {
        result = zUfiSms_DispatchWtoi(
                     ts_data_ptr->u.gw_pp.u.deliver.user_data.sm_data,
                     ts_data_ptr->u.gw_pp.u.deliver.user_data.sm_len,
                     db_data->sms_content);
        db_data->alphabet = WMS_GW_ALPHABET_7_BIT_DEFAULT;
        //modified by tianfuling for extension character bug 20121126 end
        db_data->tp_dcs = (unsigned char)2;
    }
 return result;
}

int  zUfiSms_FormatSubmitDbdata
(
    T_zUfiSms_ClientTsData *ts_data_ptr,
    T_zUfiSms_DbStoreData *db_data
)
{
    int result = ZUFI_SUCC;
    wms_address_s_type *address_ptr = NULL;
    wms_gw_alphabet_e_type tp_dcs = WMS_GW_ALPHABET_MAX32;
    int i = 0;
    int ind = 0;

    if((NULL == ts_data_ptr) || (NULL == db_data))
    {
        printf("invalid inputs.");
        return ZUFI_FAIL;
    }

    /*set number address */
    address_ptr = &(ts_data_ptr->u.gw_pp.u.submit.address);
    if ((WMS_NUMBER_INTERNATIONAL == address_ptr->number_type))
    {
        db_data->number[0] = '+'; /*need a plus */
        for ( i = 0; i < address_ptr->number_of_digits; i++)
        {
            if (0x0a == address_ptr->digits[i])
            {
                db_data->number[i+1] = '0';
            }
            else
            {
                db_data->number[i+1] = '0'+address_ptr->digits[i];
            }
        }
    }
    else
    {
        for ( i = 0; i < address_ptr->number_of_digits; i++)
        {
            if (0x0a == address_ptr->digits[i])
            {
                db_data->number[i] = '0';
            }
            else
            {
                db_data->number[i] = '0'+address_ptr->digits[i];
            }
        }
    }
    
    /*dcs,pid*/
    tp_dcs = ts_data_ptr->u.gw_pp.u.submit.dcs.alphabet;
    db_data->sms_class  = ts_data_ptr->u.gw_pp.u.submit.dcs.msg_class;//added by tianfuling 20130301 for sms class
    if (WMS_GW_ALPHABET_8_BIT >= tp_dcs)
    {
        db_data->tp_dcs = (unsigned char)1;      /*1-->ASCII, 2-->UNICODE*/
    }
    else if (WMS_GW_ALPHABET_UCS2 == tp_dcs)
    {
        db_data->tp_dcs = (unsigned char)2;
    }
    else
    {
        printf("invalid tp_dcs=%d",tp_dcs);
    }
    db_data->tp_pid = (unsigned char)ts_data_ptr->u.gw_pp.u.submit.pid;
    /*db_data->tp_vp*/
    db_data->msg_ref = (unsigned char)ts_data_ptr->u.gw_pp.u.submit.message_reference;
    /*only for submit msg*/
    if (ts_data_ptr->u.gw_pp.u.submit.user_data_header_present)
    {
        db_data->tp_udhi = 1;
    }
    else
    {
        db_data->tp_udhi = 0;
    }
    if (db_data->tp_udhi == 1)
    {
        for (ind = 0; ind < ts_data_ptr->u.gw_pp.u.submit.user_data.num_headers; ind ++)
        {
            result = zUfiSms_ParseUdhiData(&(ts_data_ptr->u.gw_pp.u.submit.user_data.headers[ind]),db_data);
            if(ZTE_WMS_CONCAT_SMS_COUNT_MAX < db_data->concat_info[1])
            {
                printf("the concat sms segment is larger then the  supported segments,so did not deal the concat sms.");
                if(WMS_STORAGE_TYPE_NV_V01 == db_data->mem_store)
                {
                    zUfiSms_DelModemSms(db_data->index);
                }
                result = ZUFI_FAIL;
            }
        }
    }
    if (ts_data_ptr->u.gw_pp.u.submit.dcs.alphabet == WMS_GW_ALPHABET_UCS2)
    {
        result = zUfiSms_DispatchWtoi(
                     ts_data_ptr->u.gw_pp.u.submit.user_data.sm_data,
                     ts_data_ptr->u.gw_pp.u.submit.user_data.sm_len,
                     db_data->sms_content);
        db_data->alphabet = WMS_GW_ALPHABET_UCS2; //added by tianfuling for extension character bug 20121126
    }
    else if (ts_data_ptr->u.gw_pp.u.submit.dcs.alphabet  == WMS_GW_ALPHABET_8_BIT)
    {

        for (ind = 0; ind < ts_data_ptr->u.gw_pp.u.submit.user_data.sm_len; ind ++)
        {
            db_data->sms_content[4 * ind] = '0';
            db_data->sms_content[4 * ind + 1] = '0';
            db_data->sms_content[4 * ind + 2] =
                g_zUfiSms_DigAscMap[((ts_data_ptr->u.gw_pp.u.submit.user_data.sm_data[ind]
                              & 0xf0) >> 4)];
            db_data->sms_content[4 * ind + 3]   =
                g_zUfiSms_DigAscMap[(ts_data_ptr->u.gw_pp.u.submit.user_data.sm_data[ind] & 0xf)];
            db_data->alphabet = WMS_GW_ALPHABET_UCS2;
        }
    }
    else if (ts_data_ptr->u.gw_pp.u.submit.dcs.alphabet == WMS_GW_ALPHABET_7_BIT_DEFAULT)
    {
        result = zUfiSms_DispatchWtoi(
                     ts_data_ptr->u.gw_pp.u.submit.user_data.sm_data,
                     ts_data_ptr->u.gw_pp.u.submit.user_data.sm_len,
                     db_data->sms_content);
        db_data->alphabet = WMS_GW_ALPHABET_7_BIT_DEFAULT;
        //modified by tianfuling for extension character bug 20121126 end

        db_data->tp_dcs = (unsigned char)2;
    }
    return result;
}
/**************************************************************************
* ƣ int InvertNumbers(const char* pSrc, char* pDst, int nSrcLength)
*  ˳ַתΪߵַΪ'F'ճż
             磺"8613851872468" --> "683158812764F8"
* ʵı
* ޸ĵı
* 
             pSrc: Դַָ
             pDst: Ŀ봮ָ
             nSrcLength: Դַ
* 
             ޣ
*   ֵ
             Ŀݳȣ
* ˵
* ޸    汾     ޸      ޸
* -----------------------------------------------
* 2004/10/18  V1.0             ú
**************************************************************************/
int InvertNumbers(const char* pSrc, char* pDst, int nSrcLength)
{
    int nDstLength;     // Ŀַ
    char ch;            // ڱһַ
    int i=0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    // ƴ
    nDstLength = nSrcLength;

    // ߵ
    for(i=0; i<nSrcLength;i+=2)
    {
        ch = *pSrc++;       // ȳֵַ
        *pDst++ = *pSrc++;  // ƺֵַ
        *pDst++ = ch;       // ȳֵַ
    }

    // Դ
    if(nSrcLength & 1)
    {
        *(pDst-2) = 'F';    // 'F'
        nDstLength++;       // Ŀ괮ȼ1
    }

    // ַӸ
    *pDst = '\0';

    // Ŀַ
    return nDstLength;
}

int code_is_gsm7(const SMS_PARAM* pSrc, unsigned char buf[], int nLength)
{
    //begin add for concat sms
    //int i = 0;
    /*for(i=0;i<100;i++)
    {
        at_print(LOG_DEBUG, "in code_is_gsm7 buf[%d] is %d\n", i,buf[i]);
    }*/
    if (pSrc->TP_UDHI == 1)
    {
        buf[3] = (unsigned char) nLength;
        buf[4] = (unsigned char) pSrc->TP_UD[0];
        buf[5] = 0;
        buf[6] = (unsigned char) pSrc->TP_UD[2];
        buf[7] = (unsigned char) pSrc->TP_UD[3];
        buf[8] = (unsigned char) pSrc->TP_UD[4];
        buf[9] = (unsigned char) pSrc->TP_UD[5];
        //buf[10] = (unsigned char) pSrc->TP_UD[6];//cov m
        buf[10] = (unsigned char) pSrc->TP_UD[7];
        buf[10] = (unsigned char) (buf[10] << 1);                //һַһλ
        
        nLength = nLength - 7;
        nLength = Encode7bit(&(pSrc->TP_UD[8]), &buf[11], nLength + 1) + 4 + 6; // תTP-DAĿPDU // תTP-DAĿPDU
#if 0//ndef TSP_MODEL 
        nLength += 2;///  test for tsp
#endif
    }
    else
    {  
        // 7-bit뷽ʽ
        nLength = pSrc->TP_UDLength;
        buf[3] = nLength;
        //at_print(LOG_DEBUG, "when set buf[3] buf  is %d\n", buf);
       /* for(i=0;i<100;i++)
        {
            at_print(LOG_DEBUG, "when set buf[3]  buf[%d] is %d.\n", i,buf[i]);
        }*/
        nLength = Encode7bit(pSrc->TP_UD, &buf[4], nLength+1)+ 4;   // GSM7룬תTP-UDĿPDU
    }
    //end add for concat sms
    at_print(LOG_DEBUG, "buf is %s\n", buf);
    return nLength;
}
int code_is_ucs2(const SMS_PARAM* pSrc,unsigned char buf[], int nLength)
{
    //begin add for concat sms
    nLength = strlen(pSrc->TP_UD);
    if (pSrc->TP_UDHI == 1)
    {
        buf[3] = (unsigned char) nLength;
        buf[4] = (unsigned char) pSrc->TP_UD[0];
        buf[5] = 0;
        buf[6] = (unsigned char) pSrc->TP_UD[2];
        buf[7] = (unsigned char) pSrc->TP_UD[3];
        buf[8] = (unsigned char) pSrc->TP_UD[4];
        buf[9] = (unsigned char) pSrc->TP_UD[5];
        buf[3] = (unsigned char) (EncodeUcs2(&(pSrc->TP_UD[6]), &buf[10], nLength-6) + 6);  // תTP-DAĿPDU,nLengthڸöݳ
        nLength = buf[3] + 4;
    }
    else
    {
        // UCS2뷽ʽ
      
        buf[3] = EncodeUcs2(pSrc->TP_UD, &buf[4], nLength); // תTP-DAĿPDU
        nLength = buf[3] + 4;                               // nLengthڸöݳ

       
    } 
    //end add for concat sms  
    return nLength;
}

/**************************************************************************
* ƣ int Encode8bit(const char* pSrc, unsigned char* pDst, int nSrcLength)
*  GSM8λ
* ʵı
* ޸ĵı
* 
             pSrc: Դַָ
             pDst: Ŀ봮ָ
             nSrcLength: Դַ
* 
             ޣ
*   ֵ
             Ŀݳȣ
* ˵
* ޸    汾     ޸      ޸
* -----------------------------------------------
* 2004/10/18  V1.0             ú
**************************************************************************/
int Encode8bit(const char* pSrc, unsigned char* pDst, int nSrcLength)
{
    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    // 򵥸
    memcpy(pDst, pSrc, nSrcLength);

    return nSrcLength;
}

/**************************************************************************
* ƣ int EncodePdu_Submit(const SM_PARAM* pSrc, char* pDst)
*  PDU룬ڱ Submit Ϣ
* ʵı
* ޸ĵı
* 
             const SM_PARAM* pSrc: Ϣṹ ԴPDUָ
             pDst: Ŀ봮ָ
* 
             ޣ
*   ֵ
             Ŀݳȣ
* ˵
* ޸    汾     ޸      ޸
* -----------------------------------------------
* 2004/10/18  V1.0             ú
* 2005/9/20   V1.0           ٸ          ޸ĸú
**************************************************************************/
int EncodePdu_Submit(const SMS_PARAM* pSrc, char* pDst)
{
    int nLength = 0;         // ڲõĴ
    int nDstLength = 0;      // ĿPDU
    unsigned char buf[256] = {0};    // ڲõĻ
    char tmpSCA[36] = {0};
    int check_udl = 0;  
    memset(tmpSCA,0,sizeof(tmpSCA));

    //У
    if(pSrc ==  NULL || pDst == NULL)
    {
        return -1;
    }
	#if 1//corem for debug
	printf("[SMScorem] EncodePdu_Submit make pdu data\n");
    printf("[SMScorem]tpud:%s\n",pSrc->TP_UD);
	printf("[SMScorem]pdst1:%s\n",pDst);
	printf("[SMScorem]sca:%s\n",pSrc->SCA);
	#endif
    // SMSCַϢ
    nLength = strlen(pSrc->SCA);    // SMSCַַĳ
    buf[0] = (char)(((nLength) & 1) == 0 ? (nLength) : nLength+1) / 2 + 1;  // SMSCַϢ
    buf[1] = 0x81;                                                          // ̶: ùʸʽ
    strncpy(tmpSCA,pSrc->SCA,sizeof(tmpSCA)-1);
    //0086Ϣʱʧܵ⣬0086Ϊ+86ȥ ٸ 2005.9.20
    if(!(strncmp(pSrc->SCA , "0086",4)))
    {
        memset(tmpSCA,0,sizeof(tmpSCA));
        nLength = nLength - 1;
#if 1//def TSP_MODEL  /*add by sunxj delete '+' in SCA,20120718*/
        nLength = nLength - 1;
        strncpy(tmpSCA,&(pSrc->SCA[2]),sizeof(tmpSCA)-1);
#else
        tmpSCA[0] = '+';
        strcpy(&(tmpSCA[1]),&(pSrc->SCA[2]));
#endif
        buf[0] = (char)((nLength & 1) == 0 ? nLength : nLength + 1) / 2 + 1;    // SMSCַϢ
        buf[1] = 0x91;

    }
    else if('+' == pSrc->SCA[0])
    {
        memset(tmpSCA,0,sizeof(tmpSCA));
#if 1//def TSP_MODEL  /*add by sunxj delete '+' in SCA,20120718*/
        nLength = nLength - 1;
        strncpy(tmpSCA,&(pSrc->SCA[1]),sizeof(tmpSCA)-1);
#else
        strcpy(tmpSCA,pSrc->SCA);
#endif
        buf[0] = (char)((nLength & 1) == 0 ? (nLength) : nLength+1) / 2 + 1;    // SMSCַϢ
        buf[1] = 0x91;                                                          // ̶: ùʸʽ
    }
	#if 1//corem for debug
	printf("[SMScorem]pdst2:%s\n",pDst);
	#endif
	if (nLength < 1 || nLength >= sizeof(tmpSCA))//klocwork
		return -1;
    nDstLength = Bytes2String(buf, pDst, 2);                      // ת2ֽڵĿPDU
    nDstLength += InvertNumbers(tmpSCA, &pDst[nDstLength], nLength);        // תSMSC뵽ĿPDU

	#if 1//corem for debug
	printf("[SMScorem]pdst3:%s\n",pDst);
	#endif
    // TPDUλĿַ

    if(pSrc->TPA[0] == '+')
    {
        nLength = strlen(&(pSrc->TPA[1]));  // TP-DAַַĳ
    }
    else
    {
        nLength = strlen(pSrc->TPA);    // TP-DAַַĳ
    }
    //begin add for concat sms
    if (pSrc->TP_UDHI == 0)
    {
        if (pSrc->TP_SRR == 0)               //Ҫ״̬
        {
            buf[0] = 0x11;
        }

        if (pSrc->TP_SRR == 1)          //Ҫ״̬
        {
            buf[0] = 0x31;
        }
    }
    if (pSrc->TP_UDHI == 1)
    {
        if (pSrc->TP_SRR == 0)               //Ҫ״̬
        {
            buf[0] = 0x51;
        }

        if (pSrc->TP_SRR == 1)          //Ҫ״̬
        {
            buf[0] = 0x71;
        }
    }   
	
    //end add for concat sms
    buf[1]  = 0;            // TP-MR=0
    buf[2]  = (char)nLength;        // Ŀַָ(TP-DAַַʵ)

    if(pSrc->TPA[0] == '+')
    {
        buf[3]  = 0x91;         // ̶: ʺʽ
        nDstLength += Bytes2String(buf, &pDst[nDstLength], 4);              // ת4ֽڵĿPDU
        nDstLength += InvertNumbers(&(pSrc->TPA[1]), &pDst[nDstLength], nLength);   // תTP-DAĿPDU
    }
    else if(!(strncmp(pSrc->TPA , "0086",4)))
    {
     buf[2]  = (char)nLength-2;
        buf[3]  = 0x91;         // ̶: ʺʽ
        nDstLength += Bytes2String(buf, &pDst[nDstLength], 4);              // ת4ֽڵĿPDU
        nDstLength += InvertNumbers(&(pSrc->TPA[2]), &pDst[nDstLength], nLength-2); // תTP-DAĿPDU
        
    }
    else
    {
        buf[3]  = 0x81;         // ̶: ָʽ
        nDstLength += Bytes2String(buf, &pDst[nDstLength], 4);              // ת4ֽڵĿPDU
        nDstLength += InvertNumbers(pSrc->TPA, &pDst[nDstLength], nLength); // תTP-DAĿPDU
    }
	#if 1//corem for debug
	printf("[SMScorem]pdst4:%s\n",pDst);
	#endif

    // TPDUЭʶ뷽ʽûϢ
    
    //nLength = strlen(pSrc->TP_UD);            // ûϢַĳ
    nLength = (int) pSrc->TP_UDLength;
    buf[0]  = pSrc->TP_PID;         // Эʶ(TP-PID)
    buf[1]  = pSrc->TP_DCS;         // ûϢ뷽ʽ(TP-DCS)
    buf[2]  = pSrc->TP_VP;          // Ч(TP-VP)

    if(pSrc->TP_DCS == CODE_GSM7)
    {
        nLength = code_is_gsm7(pSrc,buf, nLength);
    }
    else if(pSrc->TP_DCS == CODE_UCS2)
    {
        nLength = code_is_ucs2(pSrc,buf, nLength);  
    }
    else
    {
         // 8-bit뷽ʽ
        //begin add for concat sms
        nLength = strlen(pSrc->TP_UD);
        if (pSrc->TP_UDHI == 1)
        {
            buf[3] = (unsigned char) nLength;
            buf[4] = (unsigned char) pSrc->TP_UD[0];
            buf[5] = 0;
            buf[6] = (unsigned char) pSrc->TP_UD[2];
            buf[7] = (unsigned char) pSrc->TP_UD[3];
            buf[8] = (unsigned char) pSrc->TP_UD[4];
            buf[9] = (unsigned char) pSrc->TP_UD[5];
			if (nLength - 6 <= 0 || nLength - 6 >= sizeof(buf) - 10) //klocwork
				return -1;
            buf[3] = (unsigned char) (Encode8bit(&(pSrc->TP_UD[6]), &buf[10], (unsigned short) (nLength - 6)) + 6);  // תTP-DAĿPDU,nLengthڸöݳ
            nLength = buf[3] + 4;
        }
        else
        {
        	if (nLength <= 0 || nLength >= sizeof(buf) - 4) //klocwork
				return -1;
            buf[3] = Encode8bit(pSrc->TP_UD, &buf[4], nLength); // תTP-DAĿPDU
            nLength = buf[3] + 4;                               // nLengthڸöݳ
        } 
        //end add for concat sms
    }
    check_udl = nLength -4;
    
    nDstLength += Bytes2String(buf, &pDst[nDstLength], nLength);  // תöݵĿPDU
    sc_cfg_set(NV_CHECK_UDL,"");
    if(check_udl>140)
    {
        sc_cfg_set(NV_CHECK_UDL,"error");
    }
	#if 1//corem for debug
	printf("[SMScorem] EncodePdu_Submit end make pdu data\n");
    printf("[SMScorem]len:%d, tpud:%s\n",nDstLength, pSrc->TP_UD);
	#endif
	#if 1//corem for debug
	printf("[SMScorem]pdst5:%s\n",pDst);
	#endif
    return nDstLength;                                           // Ŀַ
}

/**************************************************************************
* ƣ int Decode7bit(const unsigned char* pSrc, char* pDst, int nSrcLength)
*  GSM7λ
* ʵı
* ޸ĵı
* 
             pSrc: Դַָ
             pDst: Ŀ봮ָ
             nSrcLength: Դַ
* 
             ޣ
*   ֵ
             Ŀݳȣ
* ˵
* ޸    汾     ޸	     ޸
* -----------------------------------------------
* 2004/10/18  V1.0	     	     ú
**************************************************************************/
int Decode7bit(const unsigned char* pSrc, char* pDst, int nSrcLength)
{
    int nSrc;		// Դַļֵ
    int nDst;		// Ŀ봮ļֵ
    int nByte;		// ǰڴֽڵţΧ0-6
    unsigned char nLeft;	// һֽڲ

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    // ֵʼ
    nSrc = 0;
    nDst = 0;

    // ֽźͲݳʼ
    nByte = 0;
    nLeft = 0;

    // Դÿ7ֽڷΪһ飬ѹ8ֽ
    // ѭộֱԴݱ
    // 鲻7ֽڣҲȷ
    while(nSrc<nSrcLength)
    {
        // Դֽұ߲ӣȥλõһĿֽ
        *pDst = ((*pSrc << nByte) | nLeft) & 0x7f;

        // ֽʣµ߲֣Ϊݱ
        nLeft = *pSrc >> (7-nByte);

        // ޸Ŀ괮ָͼֵ
        pDst++;
        nDst++;

        // ޸ֽڼֵ
        nByte++;

        // һһֽ
        if(nByte == 7)
        {
            // õһĿֽ
            *pDst = nLeft;

            // ޸Ŀ괮ָͼֵ
            pDst++;
            nDst++;

            // ֽźͲݳʼ
            nByte = 0;
            nLeft = 0;
        }

        // ޸Դָͼֵ
        pSrc++;
        nSrc++;
    }

    // ַӸ
    *pDst = '\0';

    // Ŀ괮
    return nDst;
}

/**************************************************************************
* ƣ int DecodePushPdu(const char* pSrcPdu, SM_PARAM* pDst)
*  PDU룬ڽաĶdelevery Ϣ
* ʵı
* ޸ĵı
* 
             const char* pSrcPdu: ԴPDUָ
             pDst: Ŀṹָ
* 
             ޣ
*   ֵ 0 not push  1 push  2 notification  3 bootstrap
             
* ˵
* ޸    汾     ޸	     ޸
* -----------------------------------------------
* 2004/10/18  V1.0	     	     ú
**************************************************************************/
int DecodePushPdu(const char* pSrcPdu, SMS_PARAM* pDst)
{
    int nDstLength = 0;			           // ĿPDU
    unsigned char tmp = 0;		                   // ڲõʱֽڱ
    int ud_length = 0;
    unsigned char buf[256] = {0};	                   // ڲõĻ
    char temp_num[100] = {0};
    unsigned char first_octet = 0;                    //汣first octetϢ
    unsigned char udhl = 0;                           //ûͷϢԪصĳ
    unsigned int halftmp = 0;//klocwork
    char tp_ra[3] = {0};
	int tmplen =0;
	unsigned char IEIDL; 
	int pushType = 0;
    const char *pSrc = pSrcPdu;	
		
	if(pSrcPdu ==  NULL || pDst == NULL)
    {
        printf( "DecodePushPdu para null. \n");
        return -1;
    }
	//at_print(LOG_DEBUG, "DecodePushPdu input = %s.\n", pSrc);   
    String2Bytes(pSrc, &tmp, 2);	    // SMSCַϢ,   ȡ
    
	at_print(LOG_DEBUG, "DecodePushPdu tmp = %d.\n", tmp);    
    if(tmp == 0)// ϢĵַΪ0ֵָֻ2
    {
        pSrc += 2;
    }    
    else//  ϢĵַȲΪ0ֵָtmpֵ
    {
        tmp = (tmp - 1) * 2;// SMSC봮
        pSrc += 4;// ָƣSMSCַʽ        
        if(tmp > 32)//modified by panqinge 2005.06.30 Խ
        {
            SerializeNumbers_sms(pSrc, pDst->SCA, 32);
            tmp = 32;
        }
        else
        {
            SerializeNumbers_sms(pSrc, pDst->SCA, tmp);// תSMSC뵽ĿPDU
        }
        pSrc += tmp;// ָ
    }	    
    String2Bytes(pSrc, &tmp, 2);// TPDUλظַȡ
    //at_print(LOG_DEBUG, "DecodePushPdu tmp = %d.\n", tmp);
    first_octet = tmp;//סfirst octet Ϣ
    pSrc += 2;// ָ
    String2Bytes(pSrc, &tmp, 2);// ȡ
    //at_print(LOG_DEBUG, "DecodePushPdu tmp = %d.\n", tmp);
    halftmp = tmp;
    if(tmp & 1) tmp += 1;// ż
    pSrc += 2;// ָƣظַ(TP-RA)ʽ    
    memset(tp_ra,0,sizeof(tp_ra));
    String2Bytes(pSrc, tp_ra, 2);
    //at_print(LOG_DEBUG, "DecodePushPdu tp_ra = 0x%02x, 0x%02x.\n", tp_ra[0], tp_ra[1]);
    pSrc += 2;
    // added by panqinge,˺ӢַжϺӢַĽ뺯
    if((tp_ra[0] & 0x50) == 0x50)    //ֵĵַʽ23.040,9.1.2.5
    {
        char tempra[128];                             //ڽǰӦָΪʵʵֽ
        char acAsc[128];		
        if(halftmp >=14)
        {
            halftmp = (tmp/2)/7 + (tmp/2);      //modified by panqinge 2005.8.1 ռʱǰѹİֽ
        }
        else
        {
             halftmp = tmp/2;
        }
        //at_print(LOG_DEBUG, "DecodePushPdu halftmp = %d.\n", halftmp);

        memset(tempra,0,sizeof(tempra));
        memcpy(tempra, pSrc, tmp);
        //at_print(LOG_DEBUG, "DecodePushPdu tempra = %s.\n", tempra);

        memset(acAsc,0,sizeof(acAsc));		
        nDstLength = String2Bytes(tempra, buf, halftmp & 7 ? (int)halftmp * 7 / 4 + 2 : (int)halftmp * 7 / 4);	// ʽת
        halftmp = Decode7bit(buf, acAsc, nDstLength);	// תTP-DU
        memset(pDst->TPA, 0 , sizeof(pDst->TPA));
        if(halftmp > 32)
        {
            memcpy(pDst->TPA,acAsc,32);
            tmp = 32;
        }
        else
        {
            memcpy(pDst->TPA,acAsc,halftmp);//klocwork
        }        
    }
    else
    {         
        if(tmp > 32)//modified by panqinge 2005.06.30 Խ
        {
            SerializeNumbers_sms(pSrc, pDst->TPA, 32);         // ȡTP-RA
        }
        else
        {
            SerializeNumbers_sms(pSrc, pDst->TPA, tmp);         // ȡTP-RA
        }
        if((tp_ra[0] & 0x91) == 0x91)   //ΪInternation Number
        {
            memset(temp_num,0,sizeof(temp_num));
            if(pDst->TPA[0] != '+')   //һλ"+"
            {
                snprintf(temp_num,sizeof(temp_num),"%s%s","+",pDst->TPA);
                if(strlen(temp_num) > 32)
                {
                    snprintf(pDst->TPA,sizeof(pDst->TPA),"%32s",temp_num);
                }
                else
                {
                    snprintf(pDst->TPA,sizeof(pDst->TPA),"%s",temp_num);
                }
            }
        }
    }
    pSrc += tmp;// ָ
    //at_print(LOG_DEBUG, "DecodePushPdu TPA = %s.\n", pDst->TPA);
    
    String2Bytes(pSrc, (unsigned char*)&pDst->TP_PID, 2);	// TPDUЭʶ뷽ʽûϢ,ȡЭʶ(TP-PID)
    pSrc += 2;		                                        // ָ
    String2Bytes(pSrc, (unsigned char*)&pDst->TP_DCS, 2);	// ȡ뷽ʽ(TP-DCS)
    pSrc += 2;		                                        // ָ
    SerializeNumbers_sms(pSrc, pDst->TP_SCTS, 14);		        // ʱַ(TP_SCTS)
    pSrc += 14;		                                        // ָ
    String2Bytes(pSrc, &tmp, 2);	                        // ûϢ(TP-UDL)
    pSrc += 2;                                              // ָ    
    //at_print(LOG_DEBUG, "DecodePushPdu TP_DCS = 0x%02x.\n", pDst->TP_DCS);
    memset(pDst->TP_UD, 0 , sizeof(pDst->TP_UD));
    
	at_print(LOG_DEBUG, "DecodePushPdu first_octet = 0x%02x.\n", first_octet);
	//add for wap
    if (first_octet & 0x40)                //˵ûݺͷϢ
    {
        const char *temp = pSrc;
        unsigned char pduType;        
        unsigned char wspLen;
        unsigned char udhLen;
        unsigned char DestPort1;
        unsigned char DestPort2;
        unsigned char RefNum1;
        unsigned char RefNum2;       

		pushType = SMS_NO_PUSH;
        String2Bytes(temp, &udhl, 2);    //ȡһֽڷŵtp_udhl,ϢԪس
        temp += 2;                       //ָ
        tmplen = String2Bytes(temp, &pDst->TP_IEI, 2);  //ȡϢԪָʾΪ0ʾӶϢ
        at_print(LOG_DEBUG, "DecodePushPdu TP_IEI = 0x%02x.\n", pDst->TP_IEI);
        if(pDst->TP_IEI == 5)
        {
          temp += 2 * tmplen+2;
          tmplen = String2Bytes(temp, &DestPort1, 2);
		  at_print(LOG_DEBUG, "DecodePushPdu DestPort1 = 0x%02x.\n", DestPort1);
          temp += 2 * tmplen;
          tmplen = String2Bytes(temp, &DestPort2, 2);
		  at_print(LOG_DEBUG, "DecodePushPdu DestPort2 = 0x%02x.\n", DestPort2);
          if((DestPort1==0x0B)&&((DestPort2==0X84)||(DestPort2==0X85)))
          {
                pushType = SMS_PUSH;
          }
        }
		
		if(SMS_PUSH !=pushType)
		{
		    return pushType;
		}

        temp = pSrc + udhl * 2 + 4;
        tmplen = String2Bytes(temp, &pduType, 2);
        if(pduType==6)
        {
          pushType = SMS_PUSH;
          temp += 4;
          tmplen = String2Bytes(temp, &pduType, 2);
          if(pduType==0xC4)
          {
             //notification
             pushType = SMS_NOTIFICATION;
          }
          else
          {
            temp += 4;
            tmplen = String2Bytes(temp, &pduType, 2);
            if((pduType==0xC2)||(pduType==0xB6))
            {
               //bootstrap
               pushType = SMS_BOOTSTRAP;
            }
          }
        }
        
        if((pDst->TP_IEI == 4)||(pDst->TP_IEI == 5)||(pDst->TP_IEI == 8))
        {
            temp = pSrc+4;
            tmplen = String2Bytes(temp, &IEIDL, 2);   //ȡϢԪݳȣӶϢ˵һΪ3
            if(IEIDL==(udhl-2))
            {

            }
            else
            {
              temp += 2 * 6;
              tmplen = String2Bytes(temp, &udhLen, 2);
              if(udhLen==3)
              {
                temp += 2 * tmplen;
                tmplen = String2Bytes(temp, &RefNum1, 2);   //ȡο룬һӶϢĸͬĲο
                pDst->TP_ReferNum = RefNum1;
				temp += 2 * tmplen;                       //ָ
                tmplen = String2Bytes(temp, &pDst->TP_AllPieceNum, 2);   //ȡӶϢֳɵܵĶ
                temp += 2 * tmplen;                       //ָ
                tmplen = String2Bytes(temp, &pDst->TP_CurrentPieceNum, 2);   //ȡǰεĶ
                temp += 2 * tmplen;
              }
              else if(udhLen==4)
              {
                temp += 2 * tmplen ;
                tmplen = String2Bytes(temp, &RefNum1, 2);   //ȡο룬һӶϢĸͬĲο
                temp += 2 * tmplen ;
                tmplen = String2Bytes(temp, &RefNum2, 2);   //ȡο룬һӶϢĸͬĲο
                int ReferNum = RefNum2+ RefNum1*256;
                pDst->TP_ReferNum = ReferNum;
				temp += 2 * tmplen;                       //ָ
                tmplen = String2Bytes(temp, &pDst->TP_AllPieceNum, 2);   //ȡӶϢֳɵܵĶ
                temp += 2 * tmplen;                       //ָ
                tmplen = String2Bytes(temp, &pDst->TP_CurrentPieceNum, 2);   //ȡǰεĶ
                temp += 2 * tmplen;
              }
            }
        }
		at_print(LOG_DEBUG, "DecodePushPdu ReferNum = %d,AllNum =%d,CurNum =%d.\n", pDst->TP_ReferNum,pDst->TP_AllPieceNum,pDst->TP_CurrentPieceNum);

		if(SMS_NOTIFICATION==pushType)
		{
			temp= pSrc + udhl * 2+6;
			tmplen = String2Bytes(temp, &wspLen, 2);
			temp = temp+wspLen *2+2;
		}
		else //if((SMS_PUSH==pushType)||(SMS_BOOTSTRAP==pushType)) //kw 3
		{
			temp= pSrc + udhl * 2+2;
		}
		//klocwork
		nDstLength = ((strlen(temp) < sizeof(pDst->TP_UD)) ? strlen(temp) : (sizeof(pDst->TP_UD) - 1));
		memcpy(pDst->TP_UD, temp, nDstLength);
		at_print(LOG_DEBUG, "DecodePushPdu pDst->TP_UD = %s.\n", pDst->TP_UD);   
	}
	at_print(LOG_DEBUG, "DecodePushPdu pushType = %d.\n", pushType);	
	return pushType;
	// end add for wap
}


/**************************************************************************
* ƣ int SerializeNumbers(const char* pSrc, char* pDst, int nSrcLength)
*  ߵַתΪ˳ַ
             磺"683158812764F8" --> "8613851872468"
* ʵı
* ޸ĵı
* 
             pSrc: Դַָ
             pDst: Ŀ봮ָ
             nSrcLength: Դַ
* 
             ޣ
*   ֵ
             Ŀݳȣ
* ˵
* ޸    汾     ޸	     ޸
* -----------------------------------------------
* 2004/10/18  V1.0	     	     ú
**************************************************************************/
static int SerializeNumbers_sms(const char* pSrc, char* pDst, int nSrcLength)
{
    int nDstLength;		// Ŀַ
    char ch;			// ڱһַ
    int i=0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    // ƴ
    nDstLength = nSrcLength;

    // ߵ
    for(i=0; i<nSrcLength;i+=2)
    {
        ch = *pSrc++;		// ȳֵַ
        *pDst++ = *pSrc++;	// ƺֵַ
        *pDst++ = ch;		// ȳֵַ
    }

    // ַ'F'
    if(*(pDst-1) == 'F')
    {
        pDst--;
        nDstLength--;		// Ŀַȼ1
    }

    // ַӸ
    *pDst = '\0';

    // Ŀַ
    return nDstLength;
}

UINT16 wms_ts_pack_gw_7_bit_chars
(
    const UINT8     * in,
    UINT16          in_len,      /* Number of 7-bit characters */
    UINT16          shift,
    UINT16          out_len_max, /* Number of 7-bit characters */
    UINT8           * out
)
{
    UINT16    i=0;
    UINT16    pos = 0;

    if (in == NULL || out == NULL)
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_pack_gw_7_bit_chars");
        return 0;
    }
    /* pack the ASCII characters */
    shift %= 7;

    if (shift != 0)
    {
        /* Pack the upper bytes of the first character */
        out[pos] |= (UINT8) (in[i] << shift);
        shift = (7 - shift) + 1;
        if (shift == 7)
        {
            shift = 0;
            i++;
        }
        pos++;
    }

    for( ; pos < out_len_max && i < in_len;
         pos++, i++ )
    {
        /* pack the low bits */
        out[pos] = in[i] >> shift;

        if( i+1 < in_len )
        {
            /* pack the high bits using the low bits of the next character */
            out[pos] |= (UINT8) (in[i+1] << (7-shift));

            shift ++;

            if( shift == 7 )
            {
                shift = 0;
                i ++;
            }
        }
    }

    /* done */
    return pos;

} /* wms_ts_pack_gw_7_bit_chars() */

UINT8 wms_ts_encode_address
(
    const wms_address_s_type    * addr,
    UINT8                       * data
)
{
    UINT8   i, pos = 0;

    if( addr->number_of_digits > WMS_GW_ADDRESS_MAX )
    {
        at_print(LOG_DEBUG,"Addr len too long: %d", addr->number_of_digits);
        return 0;
    }

    if (addr->number_type == WMS_NUMBER_ALPHANUMERIC )
    {
        data[pos] = (UINT8)((addr->number_of_digits*7 + 3)/4);
    }
    else
    {
        /* Len field: */
        data[pos] = addr->number_of_digits;
    }
    pos ++;

    /* TON & NPI: */
    data[pos] = 0x80;
    data[pos] |= (UINT8) ((UINT8) addr->number_type << 4);
    data[pos] |= (UINT8) addr->number_plan;
    pos ++;

    if (addr->number_type == WMS_NUMBER_ALPHANUMERIC )
    {
        /* Alphanumberic Number Type */
        pos += (UINT8)wms_ts_pack_gw_7_bit_chars
               (
                   addr->digits,
                   addr->number_of_digits,
                   0,
                   WMS_GW_ADDRESS_MAX,
                   &data[pos]
               );
    }
    else
    {
        /* the digits: */
        for( i=0; i<addr->number_of_digits; i++ )
        {
            /* pack two digits each time */
            data[pos]  = (UINT8) (addr->digits[i++] & 0x0F);
			//kw 3
            //if( i == addr->number_of_digits )
            //{
            //    data[pos] |= 0xF0;
            //}
            //else
            {
                data[pos] |= (UINT8)(addr->digits[i] << 4);
            }
            pos ++;
        }
    }
    /* done */
    return pos;
} /* wms_ts_encode_address() */

UINT8 wms_ts_encode_dcs
(
    const wms_gw_dcs_s_type   *dcs,  /* IN */
    UINT8                     *data  /* OUT */
)
{
    UINT8 pos = 0;

    if( dcs->msg_waiting == WMS_GW_MSG_WAITING_NONE )
    {
        /* Using the pattern 00xx xxxx */

        /* bit 5 */
        data[pos] = dcs->is_compressed ? 0x20 : 0;

        /* bit 4 */
        data[pos] |= (dcs->msg_class != WMS_MESSAGE_CLASS_NONE ) ? 0x10 : 0;

        /* bits 3-2 */
        data[pos] |= dcs->alphabet << 2;

        /* bits 1-0 */
        data[pos] |= dcs->msg_class & 0x03;
    }
    else if (dcs->msg_waiting == WMS_GW_MSG_WAITING_NONE_1111)
    {
        /* Using the pattern 1111 xxxx */

        data[pos] = 0xf0;

        /*bit 2*/
        if (dcs->alphabet == WMS_GW_ALPHABET_8_BIT)
            data[pos] |= 0x04;


        /* bits 1-0 */
        data[pos] |= dcs->msg_class & 0x03;
    }
    else
    {
        /* bits 7-4 */
        if( dcs->msg_waiting == WMS_GW_MSG_WAITING_DISCARD )
        {
            data[pos] = 0xc0;
        }
        else if( dcs->msg_waiting == WMS_GW_MSG_WAITING_STORE &&
                 dcs->alphabet    == WMS_GW_ALPHABET_7_BIT_DEFAULT )
        {
            data[pos] = 0xd0;
        }
        else
        {
            data[pos] = 0xe0;
        }

        /* bit 3 */
        data[pos] |= ( dcs->msg_waiting_active == TRUE ) ? 0x08 : 0;

        /* bit 2 is reserved, set to 0 */

        /* bits 1-0 */
        data[pos] |= dcs->msg_waiting_kind & 0x03;
    }

    pos ++;

    return pos;
} /* wms_ts_encode_dcs() */

UINT8 wms_ts_bcd_to_int
(
    const UINT8 bcd, /*IN*/
    UINT8 *result    /*OUT*/
)
{
	//kw 3 ,kw bug
    //if ( (bcd & 0x0F) > 9 || ((bcd & 0xF0) >> 4) > 9)
    unsigned char low_bit = (bcd & 0x0F);
	unsigned char high_bit = ((bcd & 0xF0) >> 4);
    if(low_bit > 9 || high_bit > 9)
    {
        at_print(LOG_DEBUG,"Invalid BCD digit!");
        *result = 0;
        return FALSE;
    }
    else
    {
        *result = ( (bcd & 0x0F) + (((bcd & 0xF0) >> 4) * 10) );
        return TRUE;
    }
}

UINT8 wms_ts_encode_timestamp
(
    const wms_timestamp_s_type    *timestamp, /* IN */
    UINT8                           *data     /* OUT */
)
{
    sint7     i;
    UINT8     pos = 0, j;

    /* year check */
    if ( !wms_ts_bcd_to_int(timestamp->year, &j) )
    {
        return 0;
    }
    data[pos] = ((timestamp->year & 0x0F) << 4) + ((timestamp->year& 0xF0) >> 4);
    pos ++;

    /* month check */
    if ( wms_ts_bcd_to_int(timestamp->month, &j) )
    {
        if (j > 12 || j < 1)
        {
            at_print(LOG_DEBUG,"Month is invalid: %d", j);
            return 0;
        }
    }
    else
    {
        return 0;
    }
    data[pos] = ((timestamp->month & 0x0F) << 4) + ((timestamp->month & 0xF0) >> 4);
    pos ++;

    /* day check */
    if ( wms_ts_bcd_to_int(timestamp->day, &j) )
    {
        if (j > 31 || j < 1)
        {
            at_print(LOG_DEBUG,"Day is invalid: %d", j);
            return 0;
        }
    }
    else
    {
        return 0;
    }
    data[pos] = ((timestamp->day & 0x0F) << 4) + ((timestamp->day & 0xF0) >> 4);
    pos ++;

    /* hour check */
    if ( wms_ts_bcd_to_int(timestamp->hour, &j) )
    {
        if (j > 23)
        {
            at_print(LOG_DEBUG,"Hour is invalid: %d", j);
            return 0;
        }
    }
    else
    {
        return 0;
    }
    data[pos] = ((timestamp->hour & 0x0F) << 4) + ((timestamp->hour & 0xF0) >> 4);
    pos ++;

    /* minute check */
    if ( wms_ts_bcd_to_int(timestamp->minute, &j) )
    {
        if (j > 59)
        {
            at_print(LOG_DEBUG,"Minute is invalid: %d", j);
            return 0;
        }
    }
    else
    {
        return 0;
    }
    data[pos] = ((timestamp->minute & 0x0F) << 4) + ((timestamp->minute & 0xF0) >> 4);
    pos ++;

    /* second check */
    if ( wms_ts_bcd_to_int(timestamp->second, &j) )
    {
        if (j > 59)
        {
            at_print(LOG_DEBUG,"Second is invalid: %d", j);
            return 0;
        }
    }
    else
    {
        return 0;
    }
    data[pos] = ((timestamp->second & 0x0F) << 4) + ((timestamp->second & 0xF0) >> 4);
    pos ++;

    /* timezone check */
    i = (sint7)timestamp->timezone;
    if (i > 48|| i < -48)
    {
        at_print(LOG_DEBUG,"Timezone is out of bound: %d", i);
        return 0;
    }

    if (i >= 0)
    {
        data[pos] = (UINT8) (((UINT8)( i % 10 )) << 4);
        data[pos] |= ( i / 10 );
    }
    else
    {
        i *= (-1);
        data[pos] = (UINT8) (((UINT8)( i % 10 )) << 4);
        data[pos] |= ( i / 10 );
        data[pos] |= 0x08;
    }
    pos ++;

    return pos;

} /* wms_ts_encode_timestamp() */


UINT8 wms_ts_get_udh_length(const wms_udh_s_type *udh)
{
    UINT8 length = 0;
    if (udh != NULL)
    {
        switch(udh->header_id)
        {
                /* 0x00 */
            case WMS_UDH_CONCAT_8:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + WMS_UDH_OCTETS_CONCAT8;
                break;

                /* 0x08 */
            case WMS_UDH_CONCAT_16:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + WMS_UDH_OCTETS_CONCAT16;
                break;

                /* 0x01 */
            case WMS_UDH_SPECIAL_SM:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + WMS_UDH_OCTETS_SPECIAL_SM;
                break;

                /* 0x02 - 0x03 Reserved */

                /* 0x04 */
            case WMS_UDH_PORT_8:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + WMS_UDH_OCTETS_PORT8;
                break;

                /* 0x05 */
            case WMS_UDH_PORT_16:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + WMS_UDH_OCTETS_PORT16;
                break;

                /* 0x06 */
            case WMS_UDH_SMSC_CONTROL:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + udh->u.other.header_length;
                break;

                /* 0x07 */
            case WMS_UDH_SOURCE:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + udh->u.other.header_length;
                break;

                /* 0x09 */
            case WMS_UDH_WCMP:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + udh->u.other.header_length;
                break;

                /* 0x0A */
            case WMS_UDH_TEXT_FORMATING:
                /* Header ID Octet + Header Length Octet + Header Length */
                if(!udh->u.text_formating.is_color_present)
                {
                    length = 1 + 1 + WMS_UDH_OCTETS_TEXT_FORMATTING;
                }
                else
                {
                    /* Header ID Octet + Header Length Octet + Header Length + text color octet */
                    length = 1 + 1 + WMS_UDH_OCTETS_TEXT_FORMATTING + 1;
                }
                break;

                /* 0x0B */
            case WMS_UDH_PRE_DEF_SOUND:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + WMS_UDH_OCTETS_PRE_DEF;
                break;

                /* 0x0C */
            case WMS_UDH_USER_DEF_SOUND:
                /* Header ID Octet + Header Length Octet + Header Length + 1 (for position octet)*/
                length = 1 + 1 + udh->u.user_def_sound.data_length + 1;
                break;

                /* 0x0D */
            case WMS_UDH_PRE_DEF_ANIM:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + WMS_UDH_OCTETS_PRE_DEF;
                break;

                /* 0x0E */
            case WMS_UDH_LARGE_ANIM:
                /* Header ID Octet + Header Length Octet + Header Length + 1 (for position octet)*/
                length = 1 + 1 + WMS_UDH_LARGE_BITMAP_SIZE * WMS_UDH_ANIM_NUM_BITMAPS + 1;
                break;

                /* 0x0F */
            case WMS_UDH_SMALL_ANIM:
                /* Header ID Octet + Header Length Octet + Header Length + 1 (for position octet)*/
                length = 1 + 1 + WMS_UDH_SMALL_BITMAP_SIZE * WMS_UDH_ANIM_NUM_BITMAPS + 1;
                break;

                /* 0x10 */
            case WMS_UDH_LARGE_PICTURE:
                /* Header ID Octet + Header Length Octet + Header Length + 1 (for position octet)*/
                length = 1 + 1 + WMS_UDH_LARGE_PIC_SIZE + 1;
                break;

                /* 0x11 */
            case WMS_UDH_SMALL_PICTURE:
                /* Header ID Octet + Header Length Octet + Header Length + 1 (for position octet)*/
                length = 1 + 1 + WMS_UDH_SMALL_PIC_SIZE + 1;
                break;

                /* 0x12 */
            case WMS_UDH_VAR_PICTURE:
                /* Header ID Octet + Header Length Octet + Header Length + 3 (for height, width and position octets)*/
                length = 1 + 1 + (UINT8)(udh->u.var_picture.height * udh->u.var_picture.width/8) + 3;
                break;

                /* 0x13 - 0x1F Reserved for future EMS*/

                /* 0x20 */
            case WMS_UDH_RFC822:
                /* Header ID Octet + Header Length Octet + Header Length*/
                length = 1 + 1 + WMS_UDH_OCTETS_RFC822;
                break;
                /*add by yangpeng, 2011.4.5, begin*/
                /* 0x24 */
            case WMS_UDH_NAT_LANG_SS:
                /* Header ID Octet + Header Length Octet + Header Length*/
                length = 1 + 1 + WMS_UDH_OCTETS_NAT_LANG_SS;
                break;

                /* 0x25 */
            case WMS_UDH_NAT_LANG_LS:
                /* Header ID Octet + Header Length Octet + Header Length*/
                length = 1 + 1 + WMS_UDH_OCTETS_NAT_LANG_LS;
                break;
                /*add by yangpeng, 2011.4.5, end*/

                /*  0x21 - 0x6F Reserved for future use*/
                /*  0x70 - 0x7f Reserved for (U)SIM Toolkit Security Headers */
                /*  0x80 - 0x9F SME to SME specific use*/
                /*  0xA0 - 0xBF Reserved for future use*/
                /*  0xC0 - 0xDF SC specific use*/
                /*  0xE0 - 0xFF Reserved for future use*/
            case WMS_UDH_USER_PROMPT:
                length = 1 + 1 + WMS_UDH_OCTETS_USER_PROMPT;
                break;

            case WMS_UDH_EXTENDED_OBJECT:
                length = 1 + 1 + udh->u.eo.content.length;
                if( udh->u.eo.first_segment == TRUE )
                {
                    length += WMS_UDH_OCTETS_EO_HEADER;
                }
                break;

            default:
                /* Header ID Octet + Header Length Octet + Header Length */
                length = 1 + 1 + udh->u.other.header_length;
                break;

        }
    }
    return length;
}

uint32 wms_ts_compute_user_data_header_length
(
    const UINT8           num_headers,
    const wms_udh_s_type *headers
)
{
    uint32 length = 0;

    uint32 i;

    if( headers == NULL )
    {
        at_print(LOG_DEBUG,"Null pointer in wms_ts_compute_user_data_header_length!");
        return 0;
    }

    if (num_headers > 0)
    {
        length += 1; /* 1 UINT8 for UDHL UINT8 */

        /* User Data Headers Length */
        for ( i=0 ; i<num_headers && i<WMS_MAX_UD_HEADERS ; i++)
        {
            length += (uint32)wms_ts_get_udh_length(&headers[i]);
        }
    }

    return length;
}


uint32 wms_ts_compute_gw_user_data_length
(
    const wms_gw_dcs_s_type         *dcs,
    const wms_gw_user_data_s_type   *user_data
)
{
    uint32 length = 0;

    if( dcs == NULL || user_data == NULL )
    {
        at_print(LOG_DEBUG,"Null pointer in wms_ts_compute_gw_user_data_length!");
        return 0;
    }

    length += wms_ts_compute_user_data_header_length(user_data->num_headers, user_data->headers);

    if( dcs->alphabet == WMS_GW_ALPHABET_7_BIT_DEFAULT )
    {
        length += ((user_data->sm_len * 7) + 7)/8;
    }
    else
    {
        length += user_data->sm_len;
    }

    return length;

} /* wms_ts_compute_gw_user_data_length */


static int wms_ts_encode_udh_concat_8
(
    UINT8 *udh
)
{
    int pos =0;

    if ( const_header->u.concat_8.total_sm == 0 ||
         const_header->u.concat_8.seq_num  == 0 ||
         const_header->u.concat_8.seq_num > const_header->u.concat_8.total_sm)

    {
        at_print(LOG_DEBUG,"SMS UDH Header id %d Present with no Data", const_header->header_id);
        return 0;
    }


    udh[pos++] = (UINT8) WMS_UDH_CONCAT_8;
    udh[pos++] = (UINT8) WMS_UDH_OCTETS_CONCAT8;
    udh[pos++] = const_header->u.concat_8.msg_ref;
    udh[pos++] = const_header->u.concat_8.total_sm;
    udh[pos++] = const_header->u.concat_8.seq_num;

    return pos;
}/*wms_ts_encode_udh_concat_8*/

static int wms_ts_encode_udh_concat16
(
    UINT8 *udh
)
{
    int pos=0;

    if (const_header->u.concat_16.total_sm == 0 ||
        const_header->u.concat_16.seq_num == 0 ||
        const_header->u.concat_16.seq_num > const_header->u.concat_16.total_sm)
    {
        at_print(LOG_DEBUG,"SMS UDH Header id %d Present with no Data", const_header->header_id);
        return 0;
    }

    udh[pos++] = (UINT8) WMS_UDH_CONCAT_16;
    udh[pos++] = (UINT8) WMS_UDH_OCTETS_CONCAT16;
    udh[pos++] = (UINT8)((const_header->u.concat_16.msg_ref & 0xFF00) >> 8);
    udh[pos++] = (UINT8)(const_header->u.concat_16.msg_ref & 0x00FF);
    udh[pos++] = const_header->u.concat_16.total_sm;
    udh[pos++] = const_header->u.concat_16.seq_num;

    return pos;
}/*wms_ts_encode_udh_concat16*/

int wms_ts_encode_udh_nat_lang_ss
(
    UINT8 *udh
)
{
    int pos=0;

    udh[pos++] = (UINT8) WMS_UDH_NAT_LANG_SS;
    udh[pos++] = (UINT8) WMS_UDH_OCTETS_NAT_LANG_SS;
    udh[pos++] = (UINT8)const_header->u.nat_lang_ss.nat_lang_id;

    return pos;
}/*wms_ts_encode_udh_nat_lang_ss*/


int wms_ts_encode_udh_nat_lang_ls
(
    UINT8 *udh
)
{
    int pos=0;

    udh[pos++] = (UINT8) WMS_UDH_NAT_LANG_LS;
    udh[pos++] = (UINT8) WMS_UDH_OCTETS_NAT_LANG_LS;
    udh[pos++] = (UINT8)const_header->u.nat_lang_ls.nat_lang_id;

    return pos;
}/*wms_ts_encode_udh_nat_lang_ss*/

int wms_ts_encode_udh_other
(
    UINT8 *udh,
    wms_udh_id_e_type header_id
)
{
    int i=0;
    int pos =0;

    udh[pos++] = (UINT8) const_header->u.other.header_id;
    udh[pos++] = const_header->u.other.header_length;

    for(i = 0; i< const_header->u.other.header_length; i++)
    {
        udh[pos++] = const_header->u.other.data[i];
    }

    return pos;
}

UINT8 wms_ts_encode_user_data_header
(
    UINT8                           num_headers, /* IN */
    const wms_udh_s_type            * headers,   /* IN */
    UINT8                           *data        /* OUT */
)
{
    int i,pos=0;

    if (num_headers == 0)
        return 0;

    ++pos; /*Fill the user data header length later*/


    for (i=0; i<WMS_MAX_UD_HEADERS && i< num_headers; i++)
    {
        const_header = &headers[i];
        switch(const_header->header_id)
        {
            case WMS_UDH_CONCAT_8:
                pos+= wms_ts_encode_udh_concat_8(data+pos);
                break;

            case WMS_UDH_CONCAT_16:
                pos+= wms_ts_encode_udh_concat16(data+pos);
                break;
#if 0
            case WMS_UDH_SPECIAL_SM:
                pos+= wms_ts_encode_udh_special_sm(data+pos);
                break;

            case WMS_UDH_PORT_8:
                pos+= wms_ts_encode_udh_port_8(data+pos);
                break;

            case WMS_UDH_PORT_16:
                pos+= wms_ts_encode_udh_port16(data+pos);
                break;

            case WMS_UDH_TEXT_FORMATING:
                pos+= wms_ts_encode_udh_text_formatting(data+pos);
                break;


            case WMS_UDH_PRE_DEF_SOUND:
                pos+= wms_ts_encode_udh_pre_def_sound(data+pos);
                break;

            case WMS_UDH_USER_DEF_SOUND:
                pos+= wms_ts_encode_udh_user_def_sound(data+pos);
                break;

            case WMS_UDH_PRE_DEF_ANIM:
                pos+= wms_ts_encode_udh_pre_def_anim(data+pos);
                break;

            case WMS_UDH_LARGE_ANIM:
                pos+= wms_ts_encode_udh_large_anim(data+pos);
                break;

            case WMS_UDH_SMALL_ANIM:
                pos+= wms_ts_encode_udh_small_anim(data+pos);
                break;

            case WMS_UDH_LARGE_PICTURE:
                pos+= wms_ts_encode_udh_large_picture(data+pos);
                break;

            case WMS_UDH_SMALL_PICTURE:
                pos+= wms_ts_encode_udh_small_picture(data+pos);
                break;

            case WMS_UDH_VAR_PICTURE:
                pos+= wms_ts_encode_udh_var_picture(data+pos);
                break;

            case WMS_UDH_USER_PROMPT:
                pos+= wms_ts_encode_udh_user_prompt(data+pos);
                break;

            case WMS_UDH_EXTENDED_OBJECT:
                pos+= wms_ts_encode_udh_eo(data+pos);
                break;

            case WMS_UDH_RFC822:
                pos+= wms_ts_encode_udh_rfc822(data+pos);
                break;
                #endif
                /*add by yangpeng, 2011.4.5, begin*/
            case WMS_UDH_NAT_LANG_SS:
                pos+= wms_ts_encode_udh_nat_lang_ss(data+pos);
                break;

            case WMS_UDH_NAT_LANG_LS:
                pos+= wms_ts_encode_udh_nat_lang_ls(data+pos);
                break;
                /*add by yangpeng, 2011.4.5, end*/

            default:
                pos+= wms_ts_encode_udh_other(data+pos,const_header->header_id);
        }

    }
    data[0] = (UINT8)(pos-1); /*User Data Header Length*/
    return ((UINT8)(pos-1));

} /*wms_ts_encode_user_data_header*/


UINT8 wms_ts_encode_gw_user_data
(
    const wms_gw_dcs_s_type         *dcs,
    const wms_gw_user_data_s_type   *user_data,
    UINT8                           *data
)
{
    UINT16 i, pos=0;
    UINT8 fill_bits = 0;
    UINT16 total_bits_occupied;

    UINT8 user_data_header_length;
    UINT16 user_data_length; /*User Data Length with the header*/

    data[pos] = (UINT8)user_data->sm_len; /*User Data length*/
    pos++;
    if( dcs->alphabet == WMS_GW_ALPHABET_7_BIT_DEFAULT )
    {
        /* pack GSM default characters */
        if (user_data->num_headers > 0)
        {
            /* Check for Memory Corruption - data[WMS_MAX_LEN] */
            if (wms_ts_compute_user_data_header_length(user_data->num_headers, user_data->headers) <= WMS_SMS_UDL_MAX_8_BIT)
            {

                user_data_header_length = wms_ts_encode_user_data_header( user_data->num_headers,
                                          user_data->headers,
                                          data+pos);

                pos += user_data_header_length + 1;

                total_bits_occupied = (user_data_header_length + 1) * 8;
                fill_bits = (total_bits_occupied % 7);    /* fill_bits vary from 0 to 6 */

                if (fill_bits != 0)
                {
                    fill_bits = 7 - fill_bits;
                }

                user_data_length = (total_bits_occupied + fill_bits + (user_data->sm_len * 7)) / 7;

                data[0] = (UINT8)user_data_length;   /* UDL */
                data[1] = user_data_header_length;   /* UDHL */
            }
            else
            {
                at_print(LOG_DEBUG,"Encode User Data Header Exceeds Capacity - Skipping UDH");
            }
        }

        i = wms_ts_pack_gw_7_bit_chars( user_data->sm_data,
                                        user_data->sm_len,
                                        fill_bits,
                                        (UINT16) (WMS_MAX_LEN - pos),
                                        & data[pos] );
        pos += i;
    }
    else
    {
        if (user_data->num_headers > 0)
        {
            /* Check for Memory Corruption - data[WMS_MAX_LEN] */
            if (wms_ts_compute_user_data_header_length(user_data->num_headers, user_data->headers) <= WMS_SMS_UDL_MAX_8_BIT)
            {
                user_data_header_length =
                    wms_ts_encode_user_data_header(user_data->num_headers,
                                                   user_data->headers,
                                                   data+pos);

                /*TP-UDL is modified to actual user data + udhl */
                data[0] = (UINT8)(user_data->sm_len + user_data_header_length +1);
                pos += user_data_header_length+1;
            }
            else
            {
                at_print(LOG_DEBUG,"Encode User Data Header Exceeds Capacity - Skipping UDH");
            }
        }

        memcpy( & data[pos],
                user_data->sm_data,
                user_data->sm_len );
        pos += user_data->sm_len;
    }

    return (UINT8)pos;

} /* wms_ts_encode_gw_user_data() */



wms_status_e_type wms_ts_encode_deliver
(
    const wms_gw_deliver_s_type   *deliver,
    T_zUfiSms_RawTsData        *raw_ts_data_ptr
)
{
    wms_status_e_type     st = WMS_OK_S;
    UINT8                *data;
    UINT8                 pos = 0, i;

    if( deliver == NULL || raw_ts_data_ptr == NULL )
    {
        at_print(LOG_DEBUG,"Null pointer in wms_ts_encode_deliver!");
        return WMS_NULL_PTR_S;
    }

    data = raw_ts_data_ptr->data;

    /* Setting Data to 0 */
    (void)memset(data, 0, WMS_MAX_LEN);

    /* TP-MTI, TP-MMS, TP-SRI, TP_UDHI, TP-RP:
    */
    data[pos] = 0x00; /* DELIVER: bits 0, 1 */
    data[pos] |= deliver->more ? 0 : 0x04; /* bit 2 */
    /* bits 3, 4 are not used */
    data[pos] |= deliver->status_report_enabled ? 0x20 : 0; /* bit 5 */
    data[pos] |= deliver->user_data_header_present ? 0x40 : 0; /* bit 6 */
    data[pos] |= deliver->reply_path_present ? 0x80 : 0;    /* bit 7 */
    pos ++;

    /* TP-OA
    */
    i = wms_ts_encode_address( & deliver->address, & data[pos] );
    if( i==0 )
    {
        return WMS_INVALID_PARM_SIZE_S;
    }
    pos += i;

    /* TP-PID
    */
    data[pos] = deliver->pid;
    pos ++;

    /* TP-DCS
    */
    pos += wms_ts_encode_dcs( & deliver->dcs, data+pos );

    /* TP-SCTS
    */
    i = wms_ts_encode_timestamp( & deliver->timestamp, data+pos );
    if( i==0 )
    {
        return WMS_INVALID_PARM_VALUE_S;
    }
    pos += i;

    /* TP-UDL
    */
    /* data[pos] = (UINT8)deliver->user_data.sm_len;
       pos ++;*/

    /*TP_UDL is filled in encode_gw_user_data function*/
    /* TP-UD
    */
    if (wms_ts_compute_gw_user_data_length( &deliver->dcs, &deliver->user_data) > WMS_SMS_UDL_MAX_8_BIT)
    {
        at_print(LOG_DEBUG,"User Data Length has exceeded capacity");
        st = WMS_INVALID_USER_DATA_SIZE_S;
    }
    else
    {
        i = wms_ts_encode_gw_user_data( & deliver->dcs,
                                        & deliver->user_data,
                                        data+pos );
        pos += i;
    }

    raw_ts_data_ptr->tpdu_type  = WMS_TPDU_DELIVER;
    raw_ts_data_ptr->len        = pos;

    return st;

} /* wms_ts_encode_deliver() */

UINT8 wms_ts_encode_relative_time
(
    const wms_timestamp_s_type  *timestamp
)
{
    uint32    i;
    UINT8     v = 0, j;
    /* round up to the next time unit boundary*/

    if (timestamp != NULL)
    {
        if ( !wms_ts_bcd_to_int(timestamp->year, &j) )
        {
            at_print(LOG_DEBUG,"Year is invalid: %d", j);
        }
        i = j * 365;

        if ( !wms_ts_bcd_to_int(timestamp->month, &j) )
        {
            at_print(LOG_DEBUG,"Month is invalid: %d", j);
        }
        i = i + j * 30;

        if ( !wms_ts_bcd_to_int(timestamp->day, &j) )
        {
            at_print(LOG_DEBUG,"Day is invalid: %d", j);
        }
        i += j;

        if( i > 30 )
        {
            /* 197 - 255: (TP-VP - 192) weeks */
            v = (UINT8) ( (i+6) / 7 + 192 );
        }
        else if( i >= 1 )
        {
            /* 168 to 196: (TP-VP - 166 ) days */
            v = (UINT8) ( i + 166 );
        }
        else
        {
            if ( !wms_ts_bcd_to_int(timestamp->day, &j) )
            {
                at_print(LOG_DEBUG,"Day is invalid: %d", j);
            }
            i = j * 24 * 60;

            if ( !wms_ts_bcd_to_int(timestamp->hour, &j) )
            {
                at_print(LOG_DEBUG,"Hour is invalid: %d", j);
            }
            i = i + j * 60;

            if ( !wms_ts_bcd_to_int(timestamp->minute, &j) )
            {
                at_print(LOG_DEBUG,"Minute is invalid: %d", j);
            }
            i += j;

            if( i > 12 * 60 ) /* greater than 12 hours */
            {
                /* 144 - 167: 12 hours + ( (TP-VP - 143) * 30 minutes ) */
                v = (UINT8) ( ( i - ((12 * 60) + 29) ) / 30 + 143 );
            }
            else
            {
                /* 0 - 143: (TP-VP + 1) * 5 minutes */
                v = (UINT8) ( ( i + 4 ) / 5 - 1 );
            }
        }
    }
    else
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_encode_relative_time");
    }
    /* done */
    return v;

} /* wms_ts_encode_relative_time() */


UINT8 wms_ts_encode_gw_validity
(
    const wms_gw_validity_s_type      *validity,
    UINT8                               *data
)
{
    UINT8 i, pos = 0;

    switch( validity->format )
    {
        case WMS_GW_VALIDITY_NONE:
            break;

        case WMS_GW_VALIDITY_RELATIVE:
            data[pos] = wms_ts_encode_relative_time( & validity->u.time );
            pos ++;
            break;

        case WMS_GW_VALIDITY_ABSOLUTE:
            i = wms_ts_encode_timestamp( & validity->u.time, data+pos );
            if( i == 0 )
            {
                at_print(LOG_DEBUG,"Error while Decoding Absolute Validity Timestamp");
            }
            pos += i;
            break;

        case WMS_GW_VALIDITY_ENHANCED:
            // TBD
            break;

        default:
            break;
    } /* switch */

    return pos;

} /* wms_ts_encode_gw_validity() */


wms_status_e_type wms_ts_encode_submit
(
    const wms_gw_submit_s_type    *submit,
    T_zUfiSms_RawTsData        *raw_ts_data_ptr
)
{
    wms_status_e_type     st = WMS_OK_S;
    UINT8                *data;
    UINT8                 pos = 0, i;

    if( submit == NULL || raw_ts_data_ptr == NULL )
    {
        at_print(LOG_DEBUG,"Null pointer in wms_ts_encode_submit!");
        return WMS_NULL_PTR_S;
    }

    data = raw_ts_data_ptr->data;

    /* Setting Data to 0 */
    (void)memset(data, 0, WMS_MAX_LEN);

    /* TP-MTI, TP-RD, TP-VPF, TP-SRR, TP_UDHI, TP-RP:
    */
    data[pos] = 0x01; /* SUBMIT: bits 0, 1 */
    data[pos] |= submit->reject_duplicates ? 0x04 : 0; /* bit 2 */

    if (submit->validity.format > 3 )
    {
        return st = WMS_INVALID_VALIDITY_FORMAT_S;
    }
    data[pos] |= submit->validity.format << 3;                /* bits 3, 4 */

    data[pos] |= submit->status_report_enabled ? 0x20 : 0;    /* bit 5 */
    data[pos] |= submit->user_data_header_present ? 0x40 : 0; /* bit 6 */
    data[pos] |= submit->reply_path_present ? 0x80 : 0;       /* bit 7 */
    pos ++;

    /* TP-MR
    */
    data[pos] = (UINT8) submit->message_reference;
    pos ++;

    /* TP-DA
    */
    i = wms_ts_encode_address( & submit->address, & data[pos] );
    if( i==0 )
    {
        return WMS_INVALID_PARM_SIZE_S;
    }
    pos += i;


    /* TP-PID
    */
    data[pos] = submit->pid;
    pos ++;

    /* TP-DCS
    */
    pos += wms_ts_encode_dcs( & submit->dcs, data+pos );

    /* TP-VP
    */
    pos += wms_ts_encode_gw_validity( & submit->validity, data+pos );

    /* TP-UDL
    */
    /*data[pos] =(UINT8) submit->user_data.sm_len;
      pos ++;*/

    /*TP_UDL is filled in encode_gw_user_data function*/

    /* TP-UD
    */

    if (wms_ts_compute_gw_user_data_length( &submit->dcs, &submit->user_data) > WMS_SMS_UDL_MAX_8_BIT)
    {
        at_print(LOG_DEBUG,"User Data Length has exceeded capacity");
        st = WMS_INVALID_USER_DATA_SIZE_S;
    }
    else
    {
        i = wms_ts_encode_gw_user_data( & submit->dcs,
                                        & submit->user_data,
                                        data+pos );
        pos += i;
    }

    raw_ts_data_ptr->tpdu_type  = WMS_TPDU_SUBMIT;
    raw_ts_data_ptr->len        = pos;

    return st;

} /* wms_ts_encode_submit() */

wms_status_e_type wms_ts_encode_status_report
(
    const wms_gw_status_report_s_type    *status_report,
    T_zUfiSms_RawTsData               *raw_ts_data_ptr
)
{
    wms_status_e_type     st = WMS_OK_S;
    UINT8                 *data;
    UINT8                 pos = 0, i;

    if( status_report == NULL || raw_ts_data_ptr == NULL )
    {
        at_print(LOG_DEBUG,"Null pointer in wms_ts_encode_status_report!");
        return WMS_NULL_PTR_S;
    }

    data = raw_ts_data_ptr->data;

    /* Setting Data to 0 */
    (void)memset(data, 0, WMS_MAX_LEN);

    /* TP-MTI, TP_UDHI:
    */
    data[pos] = 0x10; /* Status Report bits 0, 1 */
    data[pos] |= status_report->more ? 0 : 0x04;/*bit 2*/
    data[pos] |= status_report->status_report_qualifier ? 0x20 : 0; /*bit 5*/
    data[pos] |= status_report->user_data_header_present ? 0x40 : 0;
    /* bit 6 */
    pos ++;

    /* TP-MR
    */
    data[pos] = (UINT8) status_report->message_reference;
    pos ++;

    /* TP-RA
    */
    i = wms_ts_encode_address( & status_report->address, & data[pos] );
    if( i==0 )
    {
        return WMS_INVALID_PARM_SIZE_S;
    }
    pos += i;


    /* TP-SCTS
    */
    i = wms_ts_encode_timestamp( & status_report->timestamp, data+pos );
    if( i==0 )
    {
        return WMS_INVALID_PARM_VALUE_S;
    }
    pos += i;

    /* TP-DT*/
    i = wms_ts_encode_timestamp( & status_report->discharge_time, data+pos );
    if( i==0 )
    {
        return WMS_INVALID_PARM_VALUE_S;
    }
    pos += i;

    /*TP-ST*/
    data[pos] = status_report->tp_status;
    pos++;

    /*TP-PI*/
    data[pos] = (UINT8) status_report->mask;
    pos ++;

    /*TP-PID*/
    if( status_report->mask & WMS_TPDU_MASK_PID )
    {
        data[pos] = status_report->pid;
        pos ++;
    }

    /* TP-DCS
    */
    if( status_report->mask & WMS_TPDU_MASK_DCS )
    {
        pos += wms_ts_encode_dcs( & status_report->dcs, data+pos );
    }

    if( status_report->mask & WMS_TPDU_MASK_USER_DATA)
    {
        /* TP-UDL
        */
        /*data[pos] =(UINT8) deliver_report_error->user_data.sm_len;
          pos ++;*/

        /*TP_UDL is filled in encode_gw_user_data function*/

        /* TP-UD
        */
        if (wms_ts_compute_gw_user_data_length( &status_report->dcs, &status_report->user_data) > WMS_SMS_UDL_MAX_8_BIT)
        {
            at_print(LOG_DEBUG,"User Data Length has exceeded capacity");
            st = WMS_INVALID_USER_DATA_SIZE_S;
        }
        else
        {
            i = wms_ts_encode_gw_user_data( & status_report->dcs,
                                            & status_report->user_data,
                                            data+pos );
            pos += i;
        }
    }

    raw_ts_data_ptr->tpdu_type  = WMS_TPDU_STATUS_REPORT;
    raw_ts_data_ptr->len        = pos;

    return st;

} /* wms_ts_encode_status_report() */

wms_status_e_type wms_ts_encode
(
    const T_zUfiSms_ClientTsData         * ptClientTsData,
    T_zUfiSms_RawTsData                  * ptRawTsData
)
{
    wms_status_e_type   st = WMS_OK_S;
    const wms_gw_pp_ts_data_s_type *msg;
    
    if( ptClientTsData == NULL || ptRawTsData == NULL )
    {
        return WMS_NULL_PTR_S;
    }

    msg = & ptClientTsData->u.gw_pp;
    //pthread_mutex_lock( &wmsts_mutex );

    switch( ptClientTsData->format )
    {
    #if 0
        case WMS_FORMAT_CDMA:
        case WMS_FORMAT_ANALOG_AWISMS:
        case WMS_FORMAT_ANALOG_CLI:
        case WMS_FORMAT_ANALOG_VOICE_MAIL:
        case WMS_FORMAT_ANALOG_SMS:
        case WMS_FORMAT_MWI:
            st = wms_ts_encode_bearer_data( & ptClientTsData->u.cdma,
                                            ptRawTsData );
            break;
    #endif
        case WMS_FORMAT_GW_PP:
            /* ---------- Start encoding --------- */

            ptRawTsData->tpdu_type    = msg->tpdu_type;

            switch( msg->tpdu_type )
            {
                case WMS_TPDU_DELIVER:
                    st = wms_ts_encode_deliver( & msg->u.deliver, ptRawTsData );
                    break;

                case WMS_TPDU_SUBMIT:
                    st = wms_ts_encode_submit( & msg->u.submit, ptRawTsData );
                    break;

                case WMS_TPDU_STATUS_REPORT:
                    st = wms_ts_encode_status_report( & msg->u.status_report,
                                                      ptRawTsData );
                    break;
#if 0
                case WMS_TPDU_SUBMIT_REPORT_ACK:
                    st = wms_ts_encode_submit_report_ack( & msg->u.submit_report_ack,
                                                          ptRawTsData );
                    break;


                case WMS_TPDU_SUBMIT_REPORT_ERROR:
                    st = wms_ts_encode_submit_report_error( & msg->u.submit_report_error,
                                                            ptRawTsData );
                    break;

                case WMS_TPDU_COMMAND:
                    st = wms_ts_encode_command( & msg->u.command,
                                                ptRawTsData );
                    break;

                case WMS_TPDU_DELIVER_REPORT_ACK:
                    st = wms_ts_encode_deliver_report_ack( & msg->u.deliver_report_ack,
                                                           ptRawTsData );
                    break;

                case WMS_TPDU_DELIVER_REPORT_ERROR:
                    st = wms_ts_encode_deliver_report_error( & msg->u.deliver_report_error,
                            ptRawTsData );
                    break;

#endif

                default:
                    at_print(LOG_DEBUG,"Invalid TPDU type %d", msg->tpdu_type);
                    st = WMS_INVALID_TPDU_TYPE_S;
                    break;
            }

            /* ---------- End of encoding --------- */
            break;
/*
        case WMS_FORMAT_GW_CB:
            st = wms_ts_encode_gw_cb(&ptClientTsData->u.gw_cb,
                                     ptRawTsData);
            break;
*/
        default:
            st = WMS_INVALID_FORMAT_S;
            at_print(LOG_DEBUG,"Invalid format: %d", ptClientTsData->format);
            break;
    }

    ptRawTsData->format = ptClientTsData->format;

    //printf(">>>>>>>>>> pthread_mutex_unlock() : wmsts_mutex >>>>>>>>>>\n" );
    //pthread_mutex_unlock( &wmsts_mutex );

    return st;

} /* wms_ts_encode() */

UINT8 wms_ts_unpack_gw_7_bit_chars
(
    const UINT8       * in,
    UINT8             in_len,        /* Number of 7-bit characters */
    UINT8             out_len_max,   /* Number of maximum 7-bit characters after unpacking */
    UINT16            shift,
    UINT8             * out
)
{
    int      i=0;
    UINT16   pos=0;

    if (in == NULL || out == NULL)
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_unpack_gw_7_bit_chars");
        return 0;
    }

    /*If the number of fill bits != 0, then it would cause an additional shift*/
    if (shift != 0)
        pos = pos+1;

    if (shift ==7)
    {
        out[0] = in[0] >> 1; /*7 fillbits*/
        shift =0;            /*First Byte is a special case*/
        i=1;
    }

    for( i=i;
         i < out_len_max && i< in_len;
         i++, pos++ )
    {
        out[i] = ( in[pos] << shift ) & 0x7F;

        if( pos != 0 )
        {
            /* except the first UINT8, a character contains some bits
            ** from the previous UINT8.
            */
#if 1       // cov M 
            if(shift == 0)
            {
                out[i] |= 0;
            }
            else
            {
                out[i] |= in[pos-1] >> (8-shift);
            }
#else
            out[i] |= in[pos-1] >> (8-shift);
#endif
        }

        shift ++;

        if( shift == 7 )
        {
            shift = 0;

            /* a possible extra complete character is available */
            i ++;
            if( i >= out_len_max )
            {
                at_print(LOG_DEBUG,"Not enough output buffer for unpacking!");
                break;
            }
            out[i] = in[pos] >> 1;
        }
    }

    return(UINT8)(pos);

} /* wms_ts_unpack_gw_7_bit_chars() */

UINT8 wms_ts_decode_address
(
    const UINT8               * data,
    wms_address_s_type        * addr
)
{
    UINT8   i, pos = 0;

    /* Len field: number of digits */
    i = data[pos];

    if( i > WMS_GW_ADDRESS_MAX )
    {
        /* Address is too long */
        at_print(LOG_DEBUG,"Addr len too long: %d", i);
        return 0;
    }

    addr->number_of_digits = i;

    pos ++;

    /* TON & NPI: */
    addr->digit_mode  = WMS_DIGIT_MODE_4_BIT;
    addr->number_type = (wms_number_type_e_type) (( data[pos] & 0x70 ) >> 4);
    addr->number_plan = (wms_number_plan_e_type) (data[pos] & 0x0F);
    pos ++;

    if (addr->number_type == WMS_NUMBER_ALPHANUMERIC )
    {
        UINT8 bytes_increment=0;
        /* Alphanumberic Number Type */
        addr->digit_mode = WMS_DIGIT_MODE_8_BIT;

        /* length = number of BCD digits */
        bytes_increment = (addr->number_of_digits+1)/2;

        addr->number_of_digits = (UINT8)(addr->number_of_digits*4/7);

        (void)wms_ts_unpack_gw_7_bit_chars
        (
            &data[pos],
            addr->number_of_digits,
            WMS_GW_ADDRESS_MAX,
            0,
            addr->digits
        );

        pos += bytes_increment;
    }
    else
    {
        /* the digits: */
        for( i=0; i<addr->number_of_digits; i++ )
        {
            /* unpack two digits each time */
            addr->digits[i++] = data[pos] & 0x0F;
            addr->digits[i]   = ( data[pos] & 0xF0 ) >> 4;
            pos ++;
        }
    }
    return pos;
} /* wms_ts_decode_address() */

UINT8 wms_ts_decode_dcs
(
    const UINT8           *data,
    wms_gw_dcs_s_type     *dcs
)
{
    UINT8 pos = 0;
    UINT8 i;
    /* initialize the values */

    if (data == NULL || dcs == NULL)
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_decode_dcs");
        return 0;
    }

    dcs->msg_class          = WMS_MESSAGE_CLASS_NONE;
    dcs->msg_waiting    = WMS_GW_MSG_WAITING_NONE;
    dcs->alphabet       = WMS_GW_ALPHABET_7_BIT_DEFAULT;
    dcs->is_compressed  = FALSE;


    /* bits 7-6 */
    i = ( data[pos] & 0xC0 ) >> 6;
    switch( i )
    {
        case 0:
            /* pattern 00xx xxxx */
            dcs->is_compressed = data[pos] & 0x20;
            if( data[pos] & 0x10 )
            {
                dcs->msg_class = (wms_message_class_e_type) (data[pos] & 0x03);
            }
            else
            {
                /* no class information */
                dcs->msg_class = WMS_MESSAGE_CLASS_NONE;
            }
            dcs->alphabet = (wms_gw_alphabet_e_type) (( data[pos] & 0x0C ) >> 2);
            break;

        case 3:
            /* bits 5-4 */
            if( (data[pos] & 0x30) == 0x30 )
            {
                /* pattern 1111 xxxx */

                /* bit 3 is reserved */

                /* bit 2 */
                dcs->alphabet = (data[pos] & 0x04 ) ? WMS_GW_ALPHABET_8_BIT:
                                WMS_GW_ALPHABET_7_BIT_DEFAULT;

                /* bits 1-0 */
                dcs->msg_class = (wms_message_class_e_type) (data[pos] & 0x03);

                /* set remaining fields */
                dcs->is_compressed  = FALSE;
                dcs->msg_waiting    = WMS_GW_MSG_WAITING_NONE_1111;
            }
            else
            {
                /* Message waiting groups
                */
                dcs->is_compressed  = FALSE;
                dcs->msg_class          = WMS_MESSAGE_CLASS_NONE;

                /* bits 5-4 */
                if( (data[pos] & 0x30) == 0x00 )
                {
                    dcs->msg_waiting  = WMS_GW_MSG_WAITING_DISCARD;
                    dcs->alphabet     = WMS_GW_ALPHABET_7_BIT_DEFAULT;
                }
                else if( (data[pos] & 0x30) == 0x10 )
                {
                    dcs->msg_waiting  = WMS_GW_MSG_WAITING_STORE;
                    dcs->alphabet     = WMS_GW_ALPHABET_7_BIT_DEFAULT;
                }
                else
                {
                    dcs->msg_waiting  = WMS_GW_MSG_WAITING_STORE;
                    dcs->alphabet     = WMS_GW_ALPHABET_UCS2;
                }

                /* bit 3 */
                dcs->msg_waiting_active = ( data[pos] & 0x08 ) ? TRUE : FALSE;

                /* bit 2 is reserved */

                /* bits 1-0 */
                dcs->msg_waiting_kind = (wms_gw_msg_waiting_kind_e_type) (data[pos] & 0x03);
            }
            break;

        default:
            // reserved values
            at_print(LOG_DEBUG,"Invalid DCS: %x", data[pos]);
            dcs->alphabet       = WMS_GW_ALPHABET_7_BIT_DEFAULT;
            dcs->is_compressed  = FALSE;
            dcs->msg_waiting    = WMS_GW_MSG_WAITING_NONE;
            dcs->msg_class          = WMS_MESSAGE_CLASS_NONE;
            break;
    }

    if ( dcs->alphabet > WMS_GW_ALPHABET_UCS2 )
    {
        dcs->alphabet = WMS_GW_ALPHABET_7_BIT_DEFAULT;
    }

    dcs->raw_dcs_data = data[pos];

    pos ++;

    return pos;

} /* wms_ts_decode_dcs() */

UINT8 wms_ts_decode_timestamp
(
    const UINT8             *data,
    wms_timestamp_s_type  *timestamp
)
{
    UINT8 pos = 0, i, j;

    if (data == NULL || timestamp == NULL)
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_decode_timestamp");
        return 0;
    }

    /*year check*/

    /* in GW, swap the order of LSB, MSB */
    i = ((data[pos] & 0x0F) << 4) + ((data[pos] & 0xF0) >> 4);
    if ( !wms_ts_bcd_to_int(i, &j) )
    {
        at_print(LOG_DEBUG,"Invalid BCD Digits in Encoded Timestamp Year : %d",data[pos]);
        i = 0;  /* Modifying it to a Good Value */
    }
    timestamp->year = i;
    pos ++;

    /*month check*/
    i = ((data[pos] & 0x0F) << 4) + ((data[pos] & 0xF0) >> 4);
    if ( wms_ts_bcd_to_int(i, &j) )
    {
        if (j > 12 || j < 1)
        {
            at_print(LOG_DEBUG,"Month is invalid: %d", j);
            i = 1;  /* Modifying it to a Good Value */
        }
    }
    else
    {
        at_print(LOG_DEBUG,"Invalid BCD Digits in Encoded Timestamp Month : %d",data[pos]);
        i = 1;  /* Modifying it to a Good Value */
    }
    timestamp->month = i;
    pos ++;

    /*day check*/
    i = ((data[pos] & 0x0F) << 4) + ((data[pos] & 0xF0) >> 4);
    if ( wms_ts_bcd_to_int(i, &j) )
    {
        if (j > 31 || j < 1)
        {
            at_print(LOG_DEBUG,"Day is invalid: %d", j);
            i = 1;  /* Modifying it to a Good Value */
        }
    }
    else
    {
        at_print(LOG_DEBUG,"Invalid BCD Digits in Encoded Timestamp Day : %d",data[pos]);
        i = 1;  /* Modifying it to a Good Value */
    }
    timestamp->day = i;
    pos ++;

    /*hour check*/
    i = ((data[pos] & 0x0F) << 4) + ((data[pos] & 0xF0) >> 4);
    if ( wms_ts_bcd_to_int(i, &j) )
    {
        if (j > 23)
        {
            at_print(LOG_DEBUG,"Hour is too large: %d", j);
            i = 0;  /* Modifying it to a Good Value */
        }
    }
    else
    {
        at_print(LOG_DEBUG,"Invalid BCD Digits in Encoded Timestamp Hour : %d",data[pos]);
        i = 0;  /* Modifying it to a Good Value */
    }
    timestamp->hour = i;
    pos ++;

    /*minute check*/
    i = ((data[pos] & 0x0F) << 4) + ((data[pos] & 0xF0) >> 4);
    if ( wms_ts_bcd_to_int(i, &j) )
    {
        if (j > 59)
        {
            at_print(LOG_DEBUG,"Minute is too large: %d", j);
            i = 0;  /* Modifying it to a Good Value */
        }
    }
    else
    {
        at_print(LOG_DEBUG,"Invalid BCD Digits in Encoded Timestamp Minute : %d",data[pos]);
        i = 0;  /* Modifying it to a Good Value */
    }
    timestamp->minute = i;
    pos ++;

    /*seconds check*/
    i = ((data[pos] & 0x0F) << 4) + ((data[pos] & 0xF0) >> 4);
    if ( wms_ts_bcd_to_int(i, &j) )
    {
        if (j > 59)
        {
            at_print(LOG_DEBUG,"Second is too large: %d", i);
            i = 0;  /* Modifying it to a Good Value */
        }
    }
    else
    {
        at_print(LOG_DEBUG,"Invalid BCD Digits in Encoded Timestamp Second : %d",data[pos]);
        i = 0;  /* Modifying it to a Good Value */
    }
    timestamp->second = i;
    pos ++;

    /*timezone, special case where timestamp->timezone is an integer value*/
    if (data[pos] & 0x08)
    {
        timestamp->timezone = (data[pos] & 0x07) * 10 + ((data[pos] & 0xF0)>>4);
        timestamp->timezone *= (-1);
    }
    else
    {
        timestamp->timezone = (sint7)((data[pos] & 0x0F) * 10 + ((data[pos] & 0xF0) >> 4 ));
    }

    if (timestamp->timezone > 48 || timestamp->timezone < -48)
    {
        at_print(LOG_DEBUG,"Timezone is out of bound: %d", timestamp->timezone);
        timestamp->timezone = 0;  /* Modifying it to a Good Value */
    }
    pos ++;

    return pos;

} /* wms_ts_decode_timestamp() */


static UINT8 wms_ts_decode_udh_concat_8
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr /* OUT */
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if (udh[pos] < 3)  /*Length of information element*/
    {
        at_print(LOG_DEBUG,"UDH Header Concat 8 Present with invalid data length = %d", udh[pos]);
        return 0; /*Return 0*/
    }


    /* if the maximum number of messages is 0     Or*/
    /* if the sequence number of the message is 0 Or*/
    /* if the sequence number of the current message is greater than the max messages*/
    if (udh[pos +2] == 0 ||
        //udh[pos +3] == 0 ||
        udh[pos +3] > udh[pos +2])
    {
        at_print(LOG_DEBUG,"UDH Header Contact 8 with out of bound max messages");
        return 0;
    }

    pos++;
    header_ptr->header_id          = WMS_UDH_CONCAT_8;
    header_ptr->u.concat_8.msg_ref = udh[pos++];
    header_ptr->u.concat_8.total_sm= udh[pos++];
    header_ptr->u.concat_8.seq_num = udh[pos++];

    return (udh[0] + 1);

}/*wms_ts_decode_udh_concat_8*/

static UINT8 wms_ts_decode_udh_concat16
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] < 4) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Concat16 Present with invalid data length = %d", udh[pos]);
        return 0;
    }

    /* if the maximum number of messages is 0     Or*/
    /* if the sequence number of the message is 0 Or*/
    /* if the sequence number of the current message is greater than the max messages*/
    if (udh[pos +3] == 0 ||
        udh[pos +4] == 0 ||
        udh[pos +4] > udh[pos +3])
        return 0;

    header_ptr->header_id           = WMS_UDH_CONCAT_16;
    pos++;
    header_ptr->u.concat_16.msg_ref = udh[pos++];
    header_ptr->u.concat_16.msg_ref = (UINT16)(header_ptr->u.concat_16.msg_ref << 8) | udh[pos++];
    header_ptr->u.concat_16.total_sm= udh[pos++];
    header_ptr->u.concat_16.seq_num = udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_concat16*/


/*=========================================================================
FUNCTION
  wms_ts_udh_decode_first_seg_check

DESCRIPTION

  Local helper function used during decoding to check if message segment
  is first segment or not.

DEPENDENCIES
  None

RETURN VALUE
  TRUE/FALSE depending on if function is successful or not.

SIDE EFFECTS
  Modifies is_first_segment_ptr with result
=========================================================================*/
static UINT8 wms_ts_udh_decode_first_seg_check
(
    const UINT8  len,                /* user_data_length*/
    const UINT8  *data,              /* first UINT8 of user data */
    UINT8      *is_first_segment_ptr      /* OUT */
)
{
    UINT8 pos = 0;
    UINT8 num_headers = 0;
    UINT8 udhl = 0;
    UINT8 iedl = 0;
    UINT8 iei = 0;

    // Default to true - it might not have concat header present
    *is_first_segment_ptr = TRUE;

    if (data == NULL || data[pos] == 0 || len == 0 )
    {
        at_print(LOG_DEBUG,"null in wms_ts_udh_decode_first_seg_check");
        return FALSE;
    }

    // First UINT8 is the UDH Length
    udhl = data[pos];

    // Move pos to first user data header
    pos++;

    while ((pos < udhl) && (num_headers < WMS_MAX_UD_HEADERS))
    {
        // First UINT8 is UDH, next UINT8 is length
        iei  = data[pos];
        iedl = data[pos+1];

        if ( iei == WMS_UDH_CONCAT_16 )
        {
            // For concat16 element, peek and see seq#
            // -------------------------------------------
            // || IEI | IEDL | Ref# | Ref# |Max# | Seq# ||
            // -------------------------------------------
            if ( data[pos+5] != 1 )
            {
                at_print(LOG_DEBUG,"WMS_UDH_CONCAT_16 not first segment!");
                *is_first_segment_ptr = FALSE;
                return TRUE;
            }
            else
            {
                return TRUE;
            }
        }
        // Not a concat header, so we dont care, skip over it's length
        else
        {
            num_headers++;
            pos += (2 + iedl); // IEI + IEDL + Actual Data Length
        }
    } // while

    return TRUE;
}


static UINT8 wms_ts_decode_udh_special_sm
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] < 2) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Special SM Present with invalid data length = %d", udh[pos]);
        return 0;
    }

    pos++;
    header_ptr->header_id                             = WMS_UDH_SPECIAL_SM;

    /* Bit 7 of octet 1 indicates if the message shall be stored or not.
       Bit 6..0 of octet 1 indicate which indicator is to be updated.
            000 0000 = Voice Message Waiting
            000 0001 = Fax Message Waiting
            000 0010 = Email Message Waiting
            000 0011 = Other Message Waiting
      Octet 2 represents the number of waiting messages
            The number can range from 0 to 255 with the value of 255 meaning
            that there are 255 or more messages waiting
    */

    header_ptr->u.special_sm.msg_waiting =  (wms_gw_msg_waiting_e_type) ((udh[pos] >> 7 == 0) ? WMS_GW_MSG_WAITING_DISCARD : WMS_GW_MSG_WAITING_STORE);
    header_ptr->u.special_sm.msg_waiting_kind         = (wms_gw_msg_waiting_kind_e_type) (udh[pos++] & 0x7f);
    header_ptr->u.special_sm.message_count            = udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_special_sm*/

static UINT8 wms_ts_decode_udh_port_8
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }


    if (udh[pos] < 2)  /*Length of information element*/
    {
        at_print(LOG_DEBUG,"UDH Header Port 8 Present with invalid data length = %d", udh[pos]);
        return 0; /*Return 0*/
    }


    pos++;
    header_ptr->header_id          = WMS_UDH_PORT_8;
    header_ptr->u.wap_8.dest_port  = udh[pos++];
    header_ptr->u.wap_8.orig_port  = udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_port_8*/

static UINT8 wms_ts_decode_udh_port16
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] < 4) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Port16 Present with invalid data length = %d", udh[pos]);
        return 0;
    }

    header_ptr->header_id           = WMS_UDH_PORT_16;
    pos++;
    header_ptr->u.wap_16.dest_port = udh[pos++];
    header_ptr->u.wap_16.dest_port = (UINT16)(header_ptr->u.wap_16.dest_port << 8) | udh[pos++];
    header_ptr->u.wap_16.orig_port = udh[pos++];
    header_ptr->u.wap_16.orig_port = (UINT16)(header_ptr->u.wap_16.orig_port << 8) | udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_port16*/


static UINT8 wms_ts_decode_udh_text_formatting
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] < 3 ) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Text Formatting Present with invalid data length = %d", udh[pos]);
        return 0;
    }

    if(udh[pos] >= 4)
    {
        header_ptr->u.text_formating.is_color_present = TRUE;
    }
    else
    {
        header_ptr->u.text_formating.is_color_present = FALSE;
    }
    pos++;


    header_ptr->header_id                                 = WMS_UDH_TEXT_FORMATING;
    header_ptr->u.text_formating.start_position           = udh[pos++];
    header_ptr->u.text_formating.text_formatting_length   = udh[pos++];
    header_ptr->u.text_formating.alignment_type           = (wms_udh_alignment_e_type) (udh[pos] & 0x03 ); /*bit 0 and  bit 1*/
    header_ptr->u.text_formating.font_size                = (wms_udh_font_size_e_type) ((udh[pos] & 0x0c) >> 2); /*bit 3 and  bit 2*/

    header_ptr->u.text_formating.style_bold               = (udh[pos] & 0x10) >> 4; /*bit 4 */
    header_ptr->u.text_formating.style_italic             = (udh[pos] & 0x20) >> 5; /*bit 5 */
    header_ptr->u.text_formating.style_underlined         = (udh[pos] & 0x40) >> 6; /*bit 6 */
    header_ptr->u.text_formating.style_strikethrough      = (udh[pos] & 0x80) >> 7; /*bit 7 */
    pos++;

    if(header_ptr->u.text_formating.is_color_present)
    {
        header_ptr->u.text_formating.text_color_foreground   = (wms_udh_text_color_e_type) (udh[pos] & 0x0F);  /* bit 0-3 */
        header_ptr->u.text_formating.text_color_background   = (wms_udh_text_color_e_type) ((udh[pos] & 0xF0) >> 4);  /* bit 4-7 */
        pos++;
    }
    return (udh[0] + 1);
}/*wms_ts_decode_udh_text_formatting*/

static UINT8 wms_ts_decode_udh_pre_def_sound
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] < 2) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Pre Defined Sound Present with invalid data length = %d",
               udh[pos]);
        return 0;
    }

    pos++;
    header_ptr->header_id                                 = WMS_UDH_PRE_DEF_SOUND;
    header_ptr->u.pre_def_sound.position                  = udh[pos++];
    header_ptr->u.pre_def_sound.snd_number                = udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_pre_def_sound*/

static UINT8 wms_ts_decode_udh_user_def_sound
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0,j;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] == 0) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header User Defined Sound Present with no Data");
        return 0;
    }

    header_ptr->header_id                                 = WMS_UDH_USER_DEF_SOUND;
    header_ptr->u.user_def_sound.data_length              = udh[pos++]-1;
    header_ptr->u.user_def_sound.position                 = udh[pos++];


    if (header_ptr->u.user_def_sound.data_length > WMS_UDH_MAX_SND_SIZE)
    {
        at_print(LOG_DEBUG,"Max Size Exceed Header id %d ", header_ptr->header_id);
        //data[pos] += data[pos]; /*Skip the bytes*/
        return 0;
    }

    //pos++;
    memset (header_ptr->u.user_def_sound.user_def_sound, 0xff,WMS_UDH_MAX_SND_SIZE);

    for(j=0; j<header_ptr->u.user_def_sound.data_length; j++)
        header_ptr->u.user_def_sound.user_def_sound[j]      = udh[pos++];

    return pos;
}/*wms_ts_decode_udh_user_def_sound*/


static UINT8 wms_ts_decode_udh_pre_def_anim
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] != 2) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Pre Defined Animation Present with invalid data length = %d",
               udh[pos]);
        return 0;
    }

    pos++;
    header_ptr->header_id                                 = WMS_UDH_PRE_DEF_ANIM;
    header_ptr->u.pre_def_anim.position                   = udh[pos++];
    header_ptr->u.pre_def_anim.animation_number           = udh[pos++];

    return pos;
}/*wms_ts_decode_udh_pre_def_anim*/

static UINT8 wms_ts_decode_udh_large_anim
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0,j,k;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] != (WMS_UDH_ANIM_NUM_BITMAPS * WMS_UDH_LARGE_BITMAP_SIZE + 1) ) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Large Defined Animation Present with invalid data length = %d",
               udh[pos]);
        return 0;
    }

    header_ptr->header_id                             = WMS_UDH_LARGE_ANIM;
    pos++; /*Skip the Size*/
    header_ptr->u.large_anim.position                 = udh[pos++];

    for(j=0; j<WMS_UDH_ANIM_NUM_BITMAPS; j++)
        for (k=0; k<WMS_UDH_LARGE_BITMAP_SIZE; k++)
            header_ptr->u.large_anim.data[j][k] = udh[pos++];

    return pos;
}/*wms_ts_decode_udh_large_anim*/


static UINT8 wms_ts_decode_udh_small_anim
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0,j,k;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] != (WMS_UDH_ANIM_NUM_BITMAPS * WMS_UDH_SMALL_BITMAP_SIZE + 1) ) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Large Defined Animation Present with invalid data length = %d",
               udh[pos]);
        return 0;
    }

    header_ptr->header_id                             = WMS_UDH_SMALL_ANIM;

    pos++; /*Skip the Size*/
    header_ptr->u.small_anim.position                 = udh[pos++];

    for(j=0; j<WMS_UDH_ANIM_NUM_BITMAPS; j++)
        for (k=0; k<WMS_UDH_SMALL_BITMAP_SIZE; k++)
            header_ptr->u.small_anim.data[j][k] = udh[pos++];

    return pos;
}/*wms_ts_decode_udh_small_anim*/

static UINT8 wms_ts_decode_udh_large_picture
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0,j;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] != WMS_UDH_LARGE_PIC_SIZE + 1) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Large Picture Present with invalid data length = %d",
               udh[pos]);
        return 0;
    }


    header_ptr->header_id                                 = WMS_UDH_LARGE_PICTURE;
    pos++; /*Skip the Size*/
    header_ptr->u.large_picture.position                  = udh[pos++];

    for(j=0; j<WMS_UDH_LARGE_PIC_SIZE; j++)
        header_ptr->u.large_picture.data[j]    = udh[pos++];

    return pos;
}/*wms_ts_decode_udh_large_picture*/


static UINT8 wms_ts_decode_udh_small_picture
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0,j;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] != WMS_UDH_SMALL_PIC_SIZE + 1) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Small Picture Present with invalid data legnth = %d",
               udh[pos]);
        return 0;
    }

    header_ptr->header_id                                 = WMS_UDH_SMALL_PICTURE;
    pos++; /*Skip the size*/
    header_ptr->u.small_picture.position                  = udh[pos++];

    for(j=0; j<WMS_UDH_SMALL_PIC_SIZE; j++)
        header_ptr->u.small_picture.data[j]           = udh[pos++];

    return pos;
}/*wms_ts_decode_udh_small_picture*/


static UINT8 wms_ts_decode_udh_var_picture
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0,j,pic_size;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] > WMS_UDH_VAR_PIC_SIZE + 3) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Var Picture Present with invalid data length = %d",
               udh[pos]);
        return 0;
    }

    if ( (udh[pos] - 3) != (udh[pos+2] * udh[pos+3]) )
    {
        at_print(LOG_DEBUG,"SMS UDH Header Var Picture, pic size value mismatch with heigt and weight");
        return 0;
    }

    pic_size                                          = udh[pos++] -3;
    header_ptr->header_id                                 = WMS_UDH_VAR_PICTURE;
    header_ptr->u.var_picture.position                    = udh[pos++];
    header_ptr->u.var_picture.width                       = (UINT8) (udh[pos++] * 8);
    header_ptr->u.var_picture.height                      = udh[pos++];

    for(j=0; j<pic_size && j<WMS_UDH_VAR_PIC_SIZE; j++)
        header_ptr->u.var_picture.data[j]             = udh[pos++];


    return pos;
}/*wms_ts_decode_udh_var_picture*/


static UINT8 wms_ts_decode_udh_user_prompt
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] < 1) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH User Prompt present with invalid data length = %d",
               udh[pos]);
        return 0;
    }

    pos ++; /* Skip udh length */

    header_ptr->header_id                                 = WMS_UDH_USER_PROMPT;
    header_ptr->u.user_prompt.number_of_objects           = udh[pos++];

    return (udh[0] + 1);

} /* wms_ts_decode_udh_user_prompt() */


/* Decoding UDH Extended Object
*/
static UINT8 wms_ts_decode_udh_eo
(
    const UINT8 *udh,
    UINT8     first_segment,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0, udh_length;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] == 0) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Extended Object present with no Data");
        return 0;
    }

    /* Get the length of this UDH */
    udh_length = udh[pos++];

    header_ptr->header_id                  = WMS_UDH_EXTENDED_OBJECT;
    header_ptr->u.eo.first_segment         = first_segment;

    if( first_segment == TRUE )
    {
        /* The following fields in the first segment occupy 7 bytes */
        if( udh_length < WMS_UDH_OCTETS_EO_HEADER )
        {
            return 0;
        }

        header_ptr->u.eo.reference           = udh[pos++];
        header_ptr->u.eo.length              = udh[pos++] << 8;
        header_ptr->u.eo.length              |= udh[pos++];
        header_ptr->u.eo.control             = udh[pos++];
        header_ptr->u.eo.type                = (wms_udh_eo_id_e_type) udh[pos++];
        header_ptr->u.eo.position            = udh[pos++] << 8;
        header_ptr->u.eo.position            |= udh[pos++];
    }

    /* Decode EO content */
    header_ptr->u.eo.content.length = (udh_length - pos) + 1;
    memcpy( header_ptr->u.eo.content.data,
            udh + pos,
            header_ptr->u.eo.content.length );

    pos += header_ptr->u.eo.content.length;

    return pos;

} /* wms_ts_decode_udh_eo() */

static UINT8 wms_ts_decode_udh_rfc822
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if(udh[pos] <  1) /*Length of information element*/
    {
        at_print(LOG_DEBUG,"SMS UDH Header Rfc822 Present with invalid data length = %d", udh[pos]);
        return 0;
    }

    pos++;
    header_ptr->header_id                                 = WMS_UDH_RFC822;
    header_ptr->u.rfc822.header_length                    = udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_rfc822*/

static UINT8 wms_ts_decode_udh_nat_lang_ss
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        //QSR_MSG_ERROR( 3402803813ULL, "udh is NULL",0,0,0);//auto-gen, to change remove 'QSR_' and first param
        return 0;
    }

    if(udh[pos] !=  WMS_UDH_OCTETS_NAT_LANG_SS) /*Length of information element*/
    {
        //QSR_MSG_ERROR( 1901262068ULL, "SMS UDH National Lang Single Shift Present with invalid data length = %d",
        //          udh[pos], 0, 0 );//auto-gen, to change remove 'QSR_' and first param
        return 0;
    }

    pos++;
    header_ptr->header_id                 = WMS_UDH_NAT_LANG_SS;
    /* Validate national language id */
    if ((WMS_UDH_NAT_LANG_TURKISH > udh[pos]) ||
        (WMS_UDH_NAT_LANG_PORTUGUESE < udh[pos]))
    {
        //QSR_MSG_ERROR( 1506461877ULL, "SMS UDH National Lang Single Shift Present with invalid id = %d",
        //            udh[pos], 0, 0 );//auto-gen, to change remove 'QSR_' and first param
        return 0;
    }
    header_ptr->u.nat_lang_ss.nat_lang_id = (wms_udh_nat_lang_id_e_type)udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_nat_lang_ss*/

static UINT8 wms_ts_decode_udh_nat_lang_ls
(
    const UINT8 *udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0;

    if (udh == NULL || header_ptr == NULL )
    {
        //QSR_MSG_ERROR( 3402803813ULL, "udh is NULL",0,0,0);//auto-gen, to change remove 'QSR_' and first param
        return 0;
    }

    if(udh[pos] !=  WMS_UDH_OCTETS_NAT_LANG_LS) /*Length of information element*/
    {
        //QSR_MSG_ERROR( 1752724994ULL, "SMS UDH National Lang Locking Shift Present with invalid data length = %d", udh[pos], 0, 0 );//auto-gen, to change remove 'QSR_' and first param
        return 0;
    }

    pos++;
    header_ptr->header_id                 = WMS_UDH_NAT_LANG_LS;
    /* Validate national language id */
    if ((WMS_UDH_NAT_LANG_TURKISH > udh[pos]) ||
        (WMS_UDH_NAT_LANG_PORTUGUESE < udh[pos]))
    {
        //QSR_MSG_ERROR( 1843098272ULL, "SMS UDH National Lang Locking Shift Present with invalid id = %d", udh[pos], 0, 0 );//auto-gen, to change remove 'QSR_' and first param
        return 0;
    }
    header_ptr->u.nat_lang_ls.nat_lang_id = (wms_udh_nat_lang_id_e_type)udh[pos++];

    return (udh[0] + 1);
}/*wms_ts_decode_udh_nat_lang_ls*/

static UINT8 wms_ts_decode_udh_other
(
    const UINT8* udh,
    wms_udh_s_type *header_ptr
)
{
    UINT8 pos=0, i=0;

    if (udh == NULL || header_ptr == NULL )
    {
        at_print(LOG_DEBUG,"udh is NULL");
        return 0;
    }

    if (udh[pos+1] > WMS_UDH_OTHER_SIZE)
    {
        at_print(LOG_DEBUG,"SMS UDH Header Other data length exceeding 226");
        return 0;
    }

    header_ptr->header_id                                 = (wms_udh_id_e_type) udh[pos];
    header_ptr->u.other.header_id                         = (wms_udh_id_e_type) udh[pos++];
    header_ptr->u.other.header_length                     = udh[pos++];

    for(i=0; i<header_ptr->u.other.header_length; i++)
    {
        header_ptr->u.other.data[i] = udh[pos++];
    }

    return pos;
}


UINT8 wms_ts_decode_user_data_header
(
    const UINT8               len, /* user_data_length*/
    const UINT8               *data, /* first UINT8 of user data */
    UINT8                     * num_headers_ptr, /* OUT */
    wms_udh_s_type            * udh_ptr          /* OUT */
)
{
    UINT8 pos =0;
    UINT8 header_length =0, num_headers=0;
    UINT8 udhl;

    UINT8    first_segment = TRUE; /* Used for Extended Object decoding */

    if (data == NULL || len == 0 || data[pos] == 0 || num_headers_ptr == NULL || udh_ptr == NULL )
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_decode_user_data_header");
        return 0;
    }

    udhl = data[pos];

    pos++;

    while ((pos < udhl)&&(num_headers<WMS_MAX_UD_HEADERS))
    {
        /*first UINT8 - header id*/
        /*second UINT8 - header length*/
        switch(data[pos++])
        {
            case WMS_UDH_CONCAT_8:
                header_length = wms_ts_decode_udh_concat_8(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_CONCAT_16:
                header_length = wms_ts_decode_udh_concat16(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_SPECIAL_SM:
                header_length = wms_ts_decode_udh_special_sm(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_PORT_8:
                header_length = wms_ts_decode_udh_port_8(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_PORT_16:
                header_length = wms_ts_decode_udh_port16(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_TEXT_FORMATING:
                header_length = wms_ts_decode_udh_text_formatting(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_PRE_DEF_SOUND:
                header_length = wms_ts_decode_udh_pre_def_sound(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_USER_DEF_SOUND:
                header_length = wms_ts_decode_udh_user_def_sound(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_PRE_DEF_ANIM:
                header_length = wms_ts_decode_udh_pre_def_anim(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_LARGE_ANIM:
                header_length = wms_ts_decode_udh_large_anim(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_SMALL_ANIM:
                header_length = wms_ts_decode_udh_small_anim(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_LARGE_PICTURE:
                header_length = wms_ts_decode_udh_large_picture(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_SMALL_PICTURE:
                header_length = wms_ts_decode_udh_small_picture(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_VAR_PICTURE:
                header_length = wms_ts_decode_udh_var_picture(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_USER_PROMPT:
                header_length = wms_ts_decode_udh_user_prompt( data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_EXTENDED_OBJECT:
				//kw 3
                wms_ts_udh_decode_first_seg_check(len, data, &first_segment);
                header_length = wms_ts_decode_udh_eo(data+pos, first_segment, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_RFC822:
                header_length = wms_ts_decode_udh_rfc822(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_NAT_LANG_SS:
                header_length = wms_ts_decode_udh_nat_lang_ss(data+pos, &udh_ptr[num_headers]);
                break;

            case WMS_UDH_NAT_LANG_LS:
                header_length = wms_ts_decode_udh_nat_lang_ls(data+pos, &udh_ptr[num_headers]);
                break;

            default:
                pos --;
                header_length = wms_ts_decode_udh_other(data+pos, &udh_ptr[num_headers]);
                break;
        } /* End of Switch */

        if ( (UINT16)pos + (UINT16)header_length  > WMS_MAX_LEN )
        {
            at_print(LOG_DEBUG,"number of bytes decoded has exceeded UDHL value of %d",udhl);
            return 0;
        }
        else if(header_length != 0)
        {
            pos += header_length;
            num_headers++;
        }
        else
        {
            at_print(LOG_DEBUG,"Bad UDH: pos=%d, data[pos]=%d", pos, data[pos]);
            * num_headers_ptr = 0;
            return 0;  /* SHORT-RETURN */
        }
    } /* End of While loop */


    if (num_headers >= WMS_MAX_UD_HEADERS)
    {
        /* Num Headers has Exceeded Max */
        at_print(LOG_DEBUG,"decode_udh: Num Headers has exceeded WMS_MAX_UD_HEADERS");

        /* Placing the correct value */
        pos = udhl+1;
    }

    if (pos!= (udhl+1))
    {
        at_print(LOG_DEBUG,"SMS UDH could not be decoded");
        num_headers =0;
        udhl =0;
    }

    if (num_headers >0)
    {
        * num_headers_ptr = num_headers;
    }

    return udhl;
}

UINT8 wms_ts_decode_gw_user_data
(
    const wms_gw_dcs_s_type   *dcs,
    const UINT8               len, // user data length
    const UINT8               *data,
    const UINT8             user_data_header_present,
    wms_gw_user_data_s_type   *user_data
)
{
    UINT8 i, pos=0;
    UINT8   fill_bits =0;
    UINT8   user_data_length;

    UINT8   user_data_header_length = 0; /* only the user data header length*/

    if (dcs == NULL || data == NULL || user_data == NULL)
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_decode_gw_user_data");
        return 0;
    }

    /* Defaulting to all zeroes */
    (void)memset(user_data, 0, sizeof(wms_gw_user_data_s_type));

    if (len == 0)
    {
        return 0;
    }

    if( dcs->alphabet == WMS_GW_ALPHABET_7_BIT_DEFAULT )
    {
        if (len > WMS_SMS_UDL_MAX_7_BIT)
        {
            at_print(LOG_DEBUG,"user data length > max value for gw 7-bit alphabet");
            return 0;
        }
        user_data_length = len;

        if(user_data_header_present)
        {
            user_data_header_length = wms_ts_decode_user_data_header( data[pos], data+pos,
                                      & user_data->num_headers, user_data->headers );
        }
        if (user_data_header_length > len)
        {
            at_print(LOG_DEBUG,"user data header length > total length");
            return 0;
        }
        /*len would be the number of septets*/
        if(user_data_header_length > 0)
        {
            /*The number of fill bits required to make a septet boundary*/
            fill_bits =( (len * 7) - ((user_data_header_length+1)*8) ) % 7;
            user_data_length = (UINT8)(( (len * 7) - ((user_data_header_length+1)*8) ) / 7);
            pos = user_data_header_length + 1;

            if (fill_bits != 0)
            {
                fill_bits = 8-fill_bits;
            }
        }

        i = wms_ts_unpack_gw_7_bit_chars
            (
                & data[pos],
                user_data_length,
                WMS_MAX_LEN,
                fill_bits,
                user_data->sm_data
            );
        user_data->sm_len = user_data_length;
    }
    else
    {
        if (len > WMS_SMS_UDL_MAX_8_BIT)
        {
            at_print(LOG_DEBUG,"user data length > max value for 8-bit chararacters");
            return 0;
        }
        user_data_length = len;
        if(user_data_header_present)
        {
            user_data_header_length = wms_ts_decode_user_data_header( data[pos],
                                      data+pos,
                                      & user_data->num_headers,
                                      user_data->headers );
            if (user_data_header_length > len)
            {
                at_print(LOG_DEBUG,"user data header length > total length");
                return 0;
            }
            pos += user_data_header_length +1;
            user_data_length = (len - user_data_header_length) - 1;
        }

        memcpy( user_data->sm_data, data+pos, user_data_length );
        user_data->sm_len = user_data_length;
        i = (UINT8)user_data->sm_len;
    }

    pos += i;

    return pos;

} /* wms_ts_decode_gw_user_data() */

wms_status_e_type wms_ts_decode_deliver
(
    const T_zUfiSms_RawTsData            * ptRawTsData,
    wms_gw_deliver_s_type                   * deliver
)
{
    wms_status_e_type     st = WMS_OK_S;
    uint32                pos = 0, i;
    const UINT8           *data = ptRawTsData->data;

    /* TP-MTI, TP-MMS, TP-SRI, TP-UDHI, TP-RP
    */
    if (ptRawTsData == NULL || deliver == NULL)
    {
        printf("null pointer in wms_ts_decode_deliver");
        return WMS_NULL_PTR_S;
    }
    else if ( (data[pos] & 0x03) != 0x00) /* check bit 0 and bit 1 for TP-MTI for deliver */
    {
        printf("invalid tpdu type in wms_ts_decode_deliver");
        return WMS_INVALID_TPDU_TYPE_S;
    }
    else
    {
        deliver->more                     = (data[pos] & 0x04) ? FALSE : TRUE;
        /* bit 2 */
        /* bits 3, 4 are not used */
        deliver->status_report_enabled    = (data[pos] & 0x20) ? TRUE : FALSE;
        /* bit 5 */
        deliver->user_data_header_present = (data[pos] & 0x40) ? TRUE : FALSE;
        /* bit 6 */
        deliver->reply_path_present       = (data[pos] & 0x80) ? TRUE : FALSE;
        /* bit 7 */
        pos ++;

        /* TP-OA
        */
        i = wms_ts_decode_address( & data[pos], & deliver->address);
        if( i==0 )
        {
            printf("invalid param size in wms_ts_decode_deliver");
            return WMS_INVALID_PARM_SIZE_S;
        }
        pos += i;

        /* TP-PID
        */
        deliver->pid = (wms_pid_e_type) data[pos];
        pos ++;

        /* TP-DCS
        */
        pos += wms_ts_decode_dcs( data+pos, & deliver->dcs );

        if (deliver->dcs.msg_waiting_kind != WMS_GW_MSG_WAITING_VOICEMAIL)
        {
            if (deliver->pid == WMS_PID_RETURN_CALL)
            {
                deliver->dcs.msg_waiting        = WMS_GW_MSG_WAITING_STORE;
                deliver->dcs.msg_waiting_active = TRUE;
                deliver->dcs.msg_waiting_kind   = WMS_GW_MSG_WAITING_VOICEMAIL;
            }
        }

        /* TP-SCTS
        */
        i = wms_ts_decode_timestamp( data+pos, & deliver->timestamp );
        if ( i==0 )
        {
            printf("invalid param value in wms_ts_decode_deliver");
            return WMS_INVALID_PARM_VALUE_S;
        }
        pos += i;


        /* TP-UDL
        */
        //  deliver->user_data_len = data[pos];
        pos ++;

        /* TP-UD
        */
        i = wms_ts_decode_gw_user_data( & deliver->dcs,
                                        data[pos-1],
                                        data+pos,
                                        deliver->user_data_header_present,
                                        & deliver->user_data );

        if (i > WMS_SMS_UDL_MAX_8_BIT)
        {
            printf("User Data Length has exceeded capacity: UDL = %lu", i);
            st = WMS_INVALID_USER_DATA_SIZE_S;
        }

        pos += i;

        /* Set the global raw ts data len
        */
        //raw_ts_len = pos;

        return st;
    }
} /* wms_ts_decode_deliver() */

UINT8 wms_ts_decode_gw_validity
(
    const UINT8                 * data,
    wms_gw_validity_s_type    * validity
)
{
    UINT8 i, pos = 0;

    if (data == NULL || validity == NULL)
    {
        at_print(LOG_DEBUG,"null pointer in wms_ts_decode_gw_validity");
        return 0;
    }
    else
    {
        switch( validity->format )
        {
            case WMS_GW_VALIDITY_NONE:
                memset( validity, 0, sizeof(wms_gw_validity_s_type) );
                break;

            case WMS_GW_VALIDITY_RELATIVE:
                zUfiSms_DecodeRelativeTime( data[pos], & validity->u.time );
                pos ++;
                break;

            case WMS_GW_VALIDITY_ABSOLUTE:
                i = wms_ts_decode_timestamp( data+pos, & validity->u.time );
				/* //kw 3
				if( i == 0 )
                {
                    at_print(LOG_DEBUG,"Error while Decoding Absolute Validity Timestamp");
                }
                */
                pos += i;
                break;

            case WMS_GW_VALIDITY_ENHANCED:
                // TBD
                break;

            default:
                break;
        } /* switch */
        return pos;
    }

} /* wms_ts_decode_gw_validity() */


wms_status_e_type wms_ts_decode_submit
(
    const T_zUfiSms_RawTsData            * ptRawTsData,
    wms_gw_submit_s_type                    * submit
)
{
    wms_status_e_type     st = WMS_OK_S;
    uint32                pos = 0, i;
    const UINT8           *data;

    if( ptRawTsData == NULL || submit == NULL )
    {
        printf("Null pointer in wms_ts_decode_submit!");
        return WMS_NULL_PTR_S;
    }

    data = ptRawTsData->data;

    /* TP-MTI, TP-RD, TP-VPF, TP-SRR, TP_UDHI, TP-RP:
    */
    submit->reject_duplicates         = (data[pos] & 0x04) ? TRUE : FALSE;
    /* bit 2 */
    submit->validity.format           = (wms_gw_validity_format_e_type) (( data[pos] & 0x18 ) >> 3); /* bits 3, 4 */
    submit->status_report_enabled     = (data[pos] & 0x20) ? TRUE : FALSE;
    /* bit 5 */
    submit->user_data_header_present  = (data[pos] & 0x40) ? TRUE : FALSE;
    /* bit 6 */
    submit->reply_path_present        = (data[pos] & 0x80) ? TRUE : FALSE;
    /* bit 7 */
    pos ++;


    /* TP-MR
    */
    submit->message_reference = data[pos];
    pos ++;

    /* TP-DA
    */
    i = wms_ts_decode_address( & data[pos], & submit->address );
    if( i == 0 )
    {
        return WMS_INVALID_PARM_SIZE_S;
    }

    pos += i;

    /* TP-PID
    */
    submit->pid = (wms_pid_e_type) data[pos];
    pos ++;

    /* TP-DCS
    */
    pos += wms_ts_decode_dcs( data+pos, & submit->dcs );

    /* TP-VP
    */
    i = wms_ts_decode_gw_validity( data+pos, & submit->validity );
    if ((submit->validity.format != WMS_GW_VALIDITY_NONE) && ( i == 0 ))
    {
        return WMS_INVALID_PARM_VALUE_S;
    }

    pos += i;

    /* TP-UDL
    */
//  submit->user_data_len = data[pos];
    pos ++;

    /* TP-UD
    */
    i = wms_ts_decode_gw_user_data( & submit->dcs,
                                    data[pos-1],
                                    data+pos,
                                    submit->user_data_header_present,
                                    & submit->user_data );

    if (i > WMS_SMS_UDL_MAX_8_BIT)
    {
        printf("User Data Length has exceeded capacity: UDL = %lu", i);
        st = WMS_INVALID_USER_DATA_SIZE_S;
    }

    pos += i;

    /* Set the global raw ts data len
    */
    //raw_ts_len = pos;

    return st;

} /* wms_ts_decode_submit() */

wms_status_e_type wms_ts_decode_status_report
(
    const T_zUfiSms_RawTsData              * ptRawTsData,
    wms_gw_status_report_s_type               * status_report
)
{
    wms_status_e_type     st = WMS_OK_S;
    uint32                pos = 0, i;
    const UINT8           *data;

    if( ptRawTsData == NULL || status_report == NULL )
    {
        printf("Null pointer in wms_ts_decode_status_report!");
        return WMS_NULL_PTR_S;
    }

    data = ptRawTsData->data;

    /* TP-MTI, TP_UDHI:
    */
    status_report->more = data[pos] & 0x04? FALSE:TRUE;/*bit 2*/
    status_report->status_report_qualifier = data[pos]  & 0x20 ? TRUE:FALSE;
    /*bit 5*/
    status_report->user_data_header_present =
        (data[pos] & 0x40) ? TRUE : FALSE; /* bit 6 */
    pos ++;

    /* TP-MR
    */
    status_report->message_reference = data[pos];
    pos ++;

    /* TP-RA
    */
    i = wms_ts_decode_address( & data[pos], & status_report->address);
    if( i==0 )
    {
        return WMS_INVALID_PARM_SIZE_S;
    }
    pos += i;

    /* TP-SCTS
    */
    i = wms_ts_decode_timestamp( data+pos, & status_report->timestamp);
    if( i==0 )
    {
        return WMS_INVALID_PARM_VALUE_S;
    }
    pos += i;

    /* TP-DT*/
    i = wms_ts_decode_timestamp( data+pos, & status_report->discharge_time);
    if( i==0 )
    {
        return WMS_INVALID_PARM_VALUE_S;
    }
    pos += i;

    /*TP-ST*/
    status_report->tp_status = (wms_tp_status_e_type) data[pos];
    pos++;

    /*TP-PI*/
    status_report->mask = data[pos];

    /*TP-PID*/
    status_report->pid = (wms_pid_e_type) 0;

    status_report->user_data.sm_len = 0;

    /* to extract last UINT8 */
    status_report->mask &= 0xFF;

    /* to check for valid mask */
    if ((status_report->mask != 0xFF)
        && (status_report->mask != 0))
    {
        /* Increment only if mask is valid */
        pos ++;

        if( status_report->mask & WMS_TPDU_MASK_PID )
        {
            status_report->pid = (wms_pid_e_type) data[pos];
            pos ++;
        }

        /* TP-DCS
        */
        if( status_report->mask & WMS_TPDU_MASK_DCS )
        {
            pos += wms_ts_decode_dcs( data+pos, & status_report->dcs );
        }

        if( status_report->mask & WMS_TPDU_MASK_USER_DATA )
        {
            /* TP-UDL
            */
            pos ++;
            /* TP-UD
            */
            i = wms_ts_decode_gw_user_data( & status_report->dcs,
                                            data[pos-1],
                                            data+pos,
                                            status_report->user_data_header_present,
                                            & status_report->user_data );

            if (i > WMS_SMS_UDL_MAX_8_BIT)
            {
                printf("User Data Length has exceeded capacity: UDL = %lu", i);
                st = WMS_INVALID_USER_DATA_SIZE_S;
            }

            pos += i;
        }
    }
    else
    {
        status_report->mask = 0;
    }
    /* Set the global raw ts data len
    */
    //raw_ts_len = pos;

    return st;

} /* wms_ts_decode_status_report() */

wms_status_e_type wms_ts_decode
(
    const T_zUfiSms_RawTsData            * ptRawTsData,
    T_zUfiSms_ClientTsData* ptClientTsData
)
{
    // TBD: GW format only
    wms_status_e_type   st = WMS_OK_S;
    wms_gw_pp_ts_data_s_type *msg;

    if( ptRawTsData == NULL || ptClientTsData == NULL )
    {
        return WMS_NULL_PTR_S;
    }

    msg = & ptClientTsData->u.gw_pp;

    //pthread_mutex_lock( &wmsts_mutex );
    switch( ptRawTsData->format )
    {
        case WMS_FORMAT_CDMA:
        case WMS_FORMAT_ANALOG_AWISMS:
        case WMS_FORMAT_ANALOG_CLI:
        case WMS_FORMAT_ANALOG_VOICE_MAIL:
        case WMS_FORMAT_ANALOG_SMS:
        case WMS_FORMAT_MWI:
            /*
            st = wms_ts_decode_bearer_data( ptRawTsData,
                                            & ptClientTsData->u.cdma );
                                            */
            at_print(AT_DEBUG,"!!!!!!!!wms_ts_decode Error: Get Omit format!!! Format[%d]\n",ptRawTsData->format);
            break;

        case WMS_FORMAT_GW_PP:
            msg->tpdu_type = ptRawTsData->tpdu_type;
            
            switch( msg->tpdu_type )
            {
                case WMS_TPDU_DELIVER:
                    st = wms_ts_decode_deliver( ptRawTsData, & msg->u.deliver );
                    break;

                case WMS_TPDU_SUBMIT:
                    st = wms_ts_decode_submit( ptRawTsData, & msg->u.submit );
                    break;

                case WMS_TPDU_STATUS_REPORT:
                    st = wms_ts_decode_status_report( ptRawTsData,
                                                      & msg->u.status_report);
                    break;
                    
                case WMS_TPDU_DELIVER_REPORT_ACK:
                case WMS_TPDU_DELIVER_REPORT_ERROR:
                case WMS_TPDU_SUBMIT_REPORT_ACK:
                case WMS_TPDU_SUBMIT_REPORT_ERROR:
                case WMS_TPDU_COMMAND:
                    at_print(AT_DEBUG,"!!!!!!!!wms_ts_decode Error: Get Omit branch!!! tpdu_type[%d]\n",msg->tpdu_type );
                    break;

                default:
                    at_print(LOG_DEBUG,"Invalid TPDU type %d", msg->tpdu_type);
                    st = WMS_INVALID_TPDU_TYPE_S;
                    break;
            }

            break;

        case WMS_FORMAT_GW_CB:
            /*st = wms_ts_decode_gw_cb( ptRawTsData,
                                      & ptClientTsData->u.gw_cb );
                                      */
            at_print(AT_DEBUG,"!!!!!!!!wms_ts_decode Error: Get Omit format!!! Format[%d]\n",ptRawTsData->format);
            break;

        default:
            st = WMS_INVALID_FORMAT_S;
            at_print(AT_DEBUG,"Invalid format: %d", ptRawTsData->format);
            break;
    }

    ptClientTsData->format = ptRawTsData->format;
    //pthread_mutex_unlock( &wmsts_mutex );

    return st;

} /* wms_ts_decode() */
 
