#include <pthread.h>
#include <sched.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <sys/msg.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include <sys/prctl.h>
#include <netdb.h>
#include <limits.h>
//#include "softap_api.h"
//#include "errorcode.h"
//#include "cfg_api.h"
//#include "at_com.h"
#include "sntp.h"
#include "pub_debug_info.h"


/**************************************************************************
* 
**************************************************************************/
struct list_head sntp_server_head;
struct list_head wait_sync_sntp;

int	 sntp_default_server_count = 13;
int  sntp_server_count = 3;

int g_sntp_cmd_from = 0; // 0: webui, 1:not webui
int g_sntp_success_count = 0;

int g_sntp_sync_interval_time = 1;     //ͬɹٴԶͬļʱ䣬λ:
char MODULE_ID_SNTP_DEBUG[20] = "ap_sntp";

// sem_idִp
static int sem_p(int sem_id)
{
	struct sembuf sem_buf;
	sem_buf.sem_num = 0; //ź
	sem_buf.sem_op = -1; //P
	sem_buf.sem_flg = SEM_UNDO; //ϵͳ˳ǰδͷźϵͳԶͷ
	if (semop(sem_id, &sem_buf, 1) == -1) {
		return -1;
	}
	return 0;
}

// sem_idִV
static int sem_v(int sem_id)
{
	struct sembuf sem_buf;
	sem_buf.sem_num = 0;
	sem_buf.sem_op = 1; //V
	sem_buf.sem_flg = SEM_UNDO;
	if (semop(sem_id, &sem_buf, 1) == -1) {
		return -1;
	}
	return 0;
}

static int get_sem(key_t sem_key)
{
	int sem_id = -1;

	sem_id = semget(sem_key, 1, 0666 | IPC_CREAT);
	if (sem_id < 0) {
		if (errno == EEXIST) {
			return semget(sem_key, 1, 0666 | IPC_CREAT);
		}
		slog(MISC_PRINT, SLOG_ERR, "[SNTP]semget errno=%d\n", errno);
		return -1;
	}

	union semun sem_union;
	sem_union.val = 1;
	if (semctl(sem_id, 0, SETVAL, sem_union) == -1) {
		return -1;
	}

	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]semget init sem_id= %d, get sem success\n", sem_id);;
	return sem_id;
}




void zte_sntp_set_error_state(sntp_error_type_t error_type)
{
	char buf[NV_ITEM_STRING_LEN_64] = {0};

	if (error_type == SNTP_ERROR_NOT_GET_HOST) {
		strncpy(buf, "error getaddrinfo", sizeof(buf) - 1);
	} else if (error_type == SNTP_ERROR_CREATE_SOCKET) {
		strncpy(buf, "error create socket", sizeof(buf) - 1);
	} else if (error_type == SNTP_ERROR_SELECT_OVER_TIME) {
		strncpy(buf, "error selete over time", sizeof(buf) - 1);
	} else if (error_type == SNTP_ERROR_SELECT_RETURN_ERR) {
		strncpy(buf, "error selete value<0", sizeof(buf) - 1);
	} else if (error_type == SNTP_ERROR_SEND_TO) {
		strncpy(buf, "error send to", sizeof(buf) - 1);
	} else if (error_type == SNTP_ERROR_RECV_FROM) {
		strncpy(buf, "error recv from", sizeof(buf) - 1);
	} else if (error_type == SNTP_ERROR_ALL_SERVER_INVALID) {
		strncpy(buf, "all server invalid", sizeof(buf) - 1);
	} else {
		strncpy(buf, "error other", sizeof(buf) - 1);
	}
	//sc_cfg_set(SNTP_ERROR_STATE,buf);
	slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_set_error_state: %s \n", buf);
}

void zte_sntp_set_process_result(int result)
{
	long now_time = 0;
	char now_time_str[NV_ITEM_STRING_LEN_20] = {0};
	int count = 0;
	char buf[NV_ITEM_STRING_LEN_20] = {0};

	if (result == SNTP_RESULT_OK) {
		sc_cfg_set(SNTP_PROCESS_RESULT, "success");
		//sc_cfg_set(SNTP_SYN_DONE, "1");
		/*
		sc_cfg_get(SNTP_SUCCESS_COUNT, buf, sizeof(buf));
		count = atoi(buf);
		count++;
		memset(buf,0,sizeof(buf));
		sprintf(buf,"%d", count);
		sc_cfg_set(SNTP_SUCCESS_COUNT, buf);
		*/

		g_sntp_success_count++;
		sc_cfg_set("need_clear_traffic_data", "yes");//豸ͨʱûдﵽһ촥sntpڿµʱͲͳ
		slog(MISC_PRINT, SLOG_NORMAL,"[SNTP] sntp_set_process_result = success \r\n");
		zte_sntp_success_notify();
	} else {
		sc_cfg_set(SNTP_PROCESS_RESULT, "failure");
		//sc_cfg_set(SNTP_SYN_DONE, "0");
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_set_process_result = fail \r\n");
	}

	time(&now_time);//Ϊλ
	sprintf(now_time_str, "%ld", now_time);
	sc_cfg_set(SNTP_PROCESS_OVER_TIME, now_time_str);
	//sc_cfg_set("systime_mode", "auto");
	sc_cfg_set(SNTP_PROCESS_STATE, "over");
	//zte_sntp_set_end_time(now_time); //sntp_end_timeNVֵûеطʹøNV
}

int zte_sntp_get_select_interval_time()
{
	char interval[NV_ITEM_STRING_LEN_10] = {0};

	/*λΪ*/
	sc_cfg_get("sntp_sync_select_interval_time", interval, sizeof(interval));
	if (strlen(interval) == 0) {
		return SNTP_DEFAULT_SYNC_SELECT_INTERVAL_TIME;
	}

	if (atoi(interval) <= 5) {
		return 5;
	}

	return atoi(interval);
}

int  zte_sntp_get_group_addr_by_name(char *ntpServer, unsigned long *ip_addr, int max_len)
{
	int ret      = 0;

	int ip_index = 0;

	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_get_group_addr_by_name start\n");

	struct addrinfo hints           = { 0 };
	struct addrinfo *result         = NULL;
	struct addrinfo *result_pointer = NULL;

	hints.ai_family   = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags    = AI_CANONNAME;
	hints.ai_protocol = 0;

	pthread_mutex_lock(&g_sntp_getaddrinfo_mutex);
	ret = getaddrinfo(ntpServer, NULL, &hints, &result);
	pthread_mutex_unlock(&g_sntp_getaddrinfo_mutex);

	if (ret != 0) {
		zte_sntp_set_error_state(SNTP_ERROR_NOT_GET_HOST);
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] error in getaddrinfo: %s\n", gai_strerror(ret));
		return SNTP_RESULT_FAIL;
	}

	for (result_pointer = result; result_pointer != NULL; result_pointer = result_pointer->ai_next) {
		char hostname[1025] = {0};

		if (result_pointer->ai_family == AF_INET6) {
			continue;
		}

		pthread_mutex_lock(&g_sntp_getnameinfo_mutex);
		ret = getnameinfo(result_pointer->ai_addr, result_pointer->ai_addrlen, hostname, sizeof hostname, NULL, 0, NI_NUMERICHOST);
		pthread_mutex_unlock(&g_sntp_getnameinfo_mutex);
		if (ret != 0) {
			slog(MISC_PRINT, SLOG_ERR, "[SNTP] error in getnameinfo: %s.\n", gai_strerror(ret));
			continue;
		}

		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] Server ip = %s.\n", hostname);

		ip_addr[ip_index] = (unsigned long)inet_addr(hostname);
		ip_index++;

		if (ip_index >= max_len - 1) {
			break;
		}
	}

	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_get_group_addr_by_name, get ip count = %d \n", ip_index);

	freeaddrinfo(result);
	return (ip_index == 0) ? SNTP_RESULT_FAIL : ip_index;
}


int zte_sntp_get_ntp_server(int server_index, char *ntp_server, int max_len)
{
	char ntp_server_name[NV_ITEM_STRING_LEN_20] = {0};

	memset(ntp_server, 0, max_len);
	if (server_index >= 0 && server_index < sntp_server_count) {
		snprintf(ntp_server_name, sizeof(ntp_server_name), "sntp_server%d", server_index);
		sc_cfg_get(ntp_server_name, ntp_server, max_len);
		if (strcmp(ntp_server, "Other") == 0) {
			memset(ntp_server, 0, max_len);
			memset(ntp_server_name, 0, NV_ITEM_STRING_LEN_20);
			snprintf(ntp_server_name, sizeof(ntp_server_name), "sntp_other_server%d", server_index);
			sc_cfg_get(ntp_server_name, ntp_server, max_len);
		}
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_get_ntp_server, %s == %s\n", ntp_server_name, ntp_server);
	}

	if (ntp_server[0] == '\0') {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP]  sntp_get_ntp_server, ntpServer == NULL, server_index = %d \n", server_index);
		return SNTP_RESULT_INVALID_SERVER;
	}

	return SNTP_RESULT_OK;
}

int zte_sntp_get_one_ntp_server_ip(int server_index, unsigned long *ip_addr, int max_len)
{
	char ntpServer[NV_ITEM_STRING_LEN_64] = {0};
	int result = SNTP_RESULT_OK;

	if (ip_addr == NULL) {
		return SNTP_RESULT_FAIL;
	}

	result = zte_sntp_get_ntp_server(server_index, ntpServer, NV_ITEM_STRING_LEN_64);
	if (result != SNTP_RESULT_OK) {
		return SNTP_RESULT_FAIL;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_get_one_ntp_server_ip, ntp_server: %s; server_index = %d\n", ntpServer, server_index);

	if (inet_addr(ntpServer) == INADDR_NONE) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_get_one_ntp_server_ip  start getnameinfo\n");
		result = zte_sntp_get_group_addr_by_name(ntpServer, ip_addr, max_len);
#if 0
		if (result == SNTP_RESULT_FAIL) {
			return SNTP_RESULT_FAIL;
		}
#endif
	} else {
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_get_one_ntp_server_ip, single  IP: %s  \n", ntpServer);
		ip_addr[0] = inet_addr(ntpServer);
		result = 1;
	}

	return result;
}

void zte_sntp_set_ip_addr(unsigned long *ip_addr, int max_len, char *ntp_ip)
{
	int i = 0;

	for (i = 0; i < max_len; i++) {
		if (ip_addr[i] == 0) {
			ip_addr[i] = inet_addr(ntp_ip);
			break;
		}
	}
}
void zte_sntp_set_ip_addr_hostname(unsigned long *ip_addr, int max_len, char *ntp_ip)
{
	int i = 0;
	struct hostent* host = NULL;
	for (i = 0; i < max_len; i++) {
		if (ip_addr[i] == 0) {
			host = gethostbyname(ntp_ip);
			if (host != NULL) {
				ip_addr[i] = *((unsigned long *) host->h_addr);
			}
			break;
		}
	}
}

int zte_sntp_get_default_ip_addr(unsigned long *ip_addr, int max_len)
{
//    int    i = 0;
	char  buf[NV_ITEM_STRING_LEN_64 + 1] = {0};
	char sntp_default[NV_ITEM_STRING_LEN_64] = {0};
	//char index[NV_ITEM_STRING_LEN_10] = {0};
	int count = 0;

	struct sntp_server *temp = NULL;

	list_for_each_entry(temp, &sntp_server_head, list) {
		memset(buf, 0, sizeof(buf));

		strcpy(buf, temp->sntp_server_ip);

		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_get_default_ip_addr, %s =%s \n", sntp_default, buf);
		if (strlen(buf) == 0) {
			continue;
		}

		if (temp->is_ipaddr == 1) {
			zte_sntp_set_ip_addr(ip_addr, max_len, buf);
		} else {
			zte_sntp_set_ip_addr_hostname(ip_addr, max_len, buf);
		}
		count++;
	}

	return count;
}

static int parse_string(char *str, char split, char out_str[][NV_ITEM_STRING_LEN_64])
{
	char *curr = NULL;
	char *prev = NULL;
	char *tail = NULL;
	int count = 0;

	prev = str;
	tail = str + strlen(str);


	while ((curr = strchr(prev, split)) != 0) {
		strncpy(out_str[count], prev, curr - prev);
		prev = curr + 1;
		count++;
	}

	if (prev < tail) {
		strncpy(out_str[count], prev, tail - prev);
		count++;
	}

	return count;
}

//жַǷΪipַ
int check_addr_ip(const char *str, int str_len)
{
	char *p = NULL;
	int i = 0;

	p = str;
	while (*p != '\0' && i < str_len) {
		if ((*p < '0' || *p > '9') || (*p != '.'))
			return 0;
		p++;
		i++;
	}
	return 1;
}

int zte_sntp_default_server_ip_addr()
{
	int    i = 0;
	char  sntp_default_ip[NV_ITEM_STRING_LEN_64 * 20 + 20] = {0};
	char  sntp_ip[20][NV_ITEM_STRING_LEN_64] = {{0}};
	//int count = 0;
	INIT_LIST_HEAD(&sntp_server_head);

	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_default_server_ip_addr\n");

	struct sntp_server *tmp = NULL;

	sc_cfg_get("sntp_default_ip", sntp_default_ip, sizeof(sntp_default_ip));
	//ȴ½ӿ
	sntp_default_server_count = parse_string(sntp_default_ip, ';', sntp_ip);

	for (i = 0; i < sntp_default_server_count; i++) {
		tmp = malloc(sizeof(struct sntp_server));
		if (tmp == NULL) {
			slog(MISC_PRINT, SLOG_ERR, "[SNTP]server_ip malloc failed\n");
			continue;
		}
		INIT_LIST_HEAD(&tmp->list);
		memset(tmp->sntp_server_ip, 0, sizeof(tmp->sntp_server_ip));
		strncpy(tmp->sntp_server_ip, sntp_ip[i], sizeof(tmp->sntp_server_ip)-1);
		tmp->is_ipaddr = check_addr_ip(tmp->sntp_server_ip, strlen(tmp->sntp_server_ip) + 1); //жַipַַ
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] server_ip sntp_ip[%d] = %s\n", i, sntp_ip[i]);

		list_add_tail(&tmp->list, &sntp_server_head);
	}
	return sntp_default_server_count;
}

float zte_sntp_get_timezone()
{
	float tz = 0;
	char time_zone[NV_ITEM_STRING_LEN_10] = {0};

	sc_cfg_get("sntp_timezone", time_zone, sizeof(time_zone));
	sscanf(time_zone, "%f", &tz);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_timezone timezone = %f\n", tz);
	return tz;
}

void zte_sntp_login_timemark_set(time_t synBeforeTime, time_t synAfterTime)
{
	long user_login_timemark = 0;
	char login_timemark[NV_ITEM_STRING_LEN_20] = {0};
	long now_timemark = 0;
	long connect_time = 0;

	sc_cfg_get("user_login_timemark", login_timemark, sizeof(login_timemark));
	user_login_timemark = atol(login_timemark);
	if (user_login_timemark == 0 || user_login_timemark > LONG_MAX - 1) {
		return;
	}

	memset(&login_timemark, 0, sizeof(login_timemark));
	connect_time = synBeforeTime - user_login_timemark;
	now_timemark = synAfterTime - connect_time;
	sprintf(login_timemark, "%ld", now_timemark);
	sc_cfg_set("user_login_timemark", login_timemark);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] timemark, connect_time = %ld, synAfterTime = %ld, user_login_timemark=%ld\n", connect_time, synAfterTime, now_timemark);
}

int zte_sntp_set_clear_traffic_data_nv_flag()
{
	char temp[10] = {0};
	//sc_cfg_get(SNTP_SUCCESS_COUNT,temp,sizeof(temp));
	int count = atoi(temp);

	//if(count == 0)
	if (g_sntp_success_count == 0) {
		slog(MISC_PRINT, SLOG_DEBUG,"[zyl]set nv need_clear = no\n");
		sc_cfg_set("need_clear_traffic_data", "no");
	} else {
		slog(MISC_PRINT, SLOG_DEBUG,"[zyl]set nv need_clear = yes\n");
		sc_cfg_set("need_clear_traffic_data", "yes");
	}
	return 0;
}

int zte_sntp_handle_time(struct timeval tp)
{
	time_t nowtime;
	time_t SynBeforeTime = 0;
	int ltime = 0, mtime = 0, ntime = 0;
	char SynSystemTotal[NV_ITEM_STRING_LEN_20] = {0};
	char SynPppTotal[NV_ITEM_STRING_LEN_20] = {0};
	char SynSecond[NV_ITEM_STRING_LEN_20] = {0};
	char default_wan_rel[NV_ITEM_STRING_LEN_50] = {0};
	char default_wan6_rel[NV_ITEM_STRING_LEN_50] = {0};
//   int count;
//   int flag = 0;
//   int i;
//    int ret = 0;
	int sem_id = -1;
	int result = 0;
	time(&SynBeforeTime);

	slog(MISC_PRINT, SLOG_DEBUG, "[SYSTEM] auto set sntp time!");

	sc_cfg_get("syn_after_time", SynSecond, sizeof(SynSecond));
	sscanf(SynSecond, "%d", &ltime);

	sc_cfg_get("syn_system_total", SynSystemTotal, sizeof(SynSystemTotal));
	sscanf(SynSystemTotal, "%d", &mtime);

	if(ltime > INT_MAX-1)  // kw 3
	{
	    ltime = INT_MAX;
	}	

	if(mtime > INT_MAX-1)  // kw 3
	{
	    mtime = INT_MAX;
	}

	if (0 != mtime) {
		mtime += (SynBeforeTime - ltime);
	} else {
		mtime = (SynBeforeTime - SNTP_JAN_2000);
	}
	sprintf(SynSystemTotal, "%d", mtime);
	sc_cfg_set("syn_system_total", SynSystemTotal);

	sc_cfg_get("default_wan_rel", default_wan_rel, sizeof(default_wan_rel));
	sc_cfg_get("default_wan6_rel", default_wan6_rel, sizeof(default_wan6_rel));
	if ((0 != strcmp(default_wan_rel, "")) || (0 != strcmp(default_wan6_rel, ""))) {
		sc_cfg_get("syn_ppp_total", SynPppTotal, sizeof(SynPppTotal));
		sscanf(SynPppTotal, "%d", &mtime);

		if(mtime > INT_MAX-1)  // kw 3
		{
			mtime = INT_MAX;
		}
	
		if (0 != mtime) {
			mtime += (SynBeforeTime - ltime);
		} else {
			memset(&SynSecond, 0, sizeof(SynSecond));
			sc_cfg_get("ppp_start_time", SynSecond, sizeof(SynSecond));
			sscanf(SynSecond, "%d", &ntime);
    		if(ntime > INT_MAX-1)  // kw 3
    		{
    			ntime = INT_MAX;
    		}			
			mtime = SynBeforeTime - ntime;
		}
		sprintf(SynPppTotal, "%d", mtime);
		sc_cfg_set("syn_ppp_total", SynPppTotal);
		sc_cfg_set("syn_order_flag", "ppp_on");
	} else {
		sc_cfg_set("syn_order_flag", "ppp_off");
		sc_cfg_set("syn_ppp_total", "0");
	}

	sem_id = get_sem(TIME_SEM_KEY_2);

	if (sem_id != -1) {
		result = sem_p(sem_id);
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_handle_time, sem_p, sem_id = %d, result = %d\r\n", sem_id, result);
	}

	if (0 == settimeofday(&tp, NULL)) {
		system("zte-rtc-clock");
		sc_debug_info_record(MODULE_ID_SNTP_DEBUG, "sntp time synchronization successful!\n");
		slog(MISC_PRINT, SLOG_DEBUG, "[zyl]system zte-rtc-clock \n");
	}

#if 1
	time_t t_synSecond = 0;
	t_synSecond = time((time_t *)NULL);
	
	sprintf(SynSecond, "%d", (int)(t_synSecond));
	sc_cfg_set("syn_after_time", SynSecond);
	zte_sntp_login_timemark_set(SynBeforeTime, t_synSecond);
#else
    sprintf(SynSecond, "%d", (int)(time((time_t *)NULL)));
    sc_cfg_set("syn_after_time", SynSecond);
    zte_sntp_login_timemark_set(SynBeforeTime, atol(SynSecond));

#endif

	if (sem_id != -1) {
		result = sem_v(sem_id);
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_parse_time, sem_v, sem_id = %d, result = %d\r\n", sem_id, result);
	}

	return SNTP_RESULT_OK;
}


int zte_sntp_parse_time(SNTP_HEADER *sntp_header)
{
	NTP_TIME_FMT ct;
	struct tm ptm = {0};
//    struct tm time_tm = {0};
	struct timeval  time_tv;
	float tz = 0;
	int trip;
	int sem_id = 0;
	int result = 0;
	char tmp_buf[NV_ITEM_STRING_LEN_10] = {0};
	char temp_nv[NV_ITEM_STRING_LEN_10] = {0};
	//tz = zte_sntp_get_timezone();
	ct.seconds = time(NULL);
	ct.fractional = 0;

    struct tm tm_utc = {0};            
    struct tm tm_os = {0};            
    time_t org_time = 0;
    time_t rcv_time = 0;
    time_t trn_time = 0;
    time_t timezone = 0;
	sntp_header->rootDelay = ntohl(sntp_header->rootDelay);
	sntp_header->rootDispersion = ntohl(sntp_header->rootDispersion);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] RootDelay = %lu\r\n", sntp_header->rootDelay);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] RootDispersion = %lu\r\n", sntp_header->rootDispersion);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] RefrenceID = %02X %02X %02X %02X\r\n", sntp_header->referenceID[0], sntp_header->referenceID[1], sntp_header->referenceID[2], sntp_header->referenceID[3]);

    org_time = ntohl(sntp_header->originateTimestamp.seconds) - SNTP_SECONDS_FROM_1900_TO_1970;
    rcv_time = ntohl(sntp_header->receiveTimestamp.seconds) - SNTP_SECONDS_FROM_1900_TO_1970;
    trn_time = ntohl(sntp_header->transmitTimestamp.seconds) - SNTP_SECONDS_FROM_1900_TO_1970;
/*        
	sntp_header->referenceTimestamp.seconds = ntohl(sntp_header->referenceTimestamp.seconds) - SNTP_SECONDS_FROM_1900_TO_1970 + (long)(tz * 3600);
	sntp_header->referenceTimestamp.fractional = ntohl(sntp_header->referenceTimestamp.fractional);

	//ptm = gmtime(&sntp_header->referenceTimestamp.seconds);
	gmtime_r(&sntp_header->referenceTimestamp.seconds, &ptm);
	//if(ptm)
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] ReferenceTime = %d-%02d-%02d %02d:%02d:%02d\r\n", ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour, ptm.tm_min, ptm.tm_sec);


	sntp_header->originateTimestamp.seconds = ntohl(sntp_header->originateTimestamp.seconds) - SNTP_SECONDS_FROM_1900_TO_1970 + (long)(tz * 3600);
	sntp_header->originateTimestamp.fractional = ntohl(sntp_header->originateTimestamp.fractional);

	//ptm = gmtime(&sntp_header->originateTimestamp.seconds);
	gmtime_r(&sntp_header->originateTimestamp.seconds, &ptm);
	//if(ptm)
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] OriginateTime = %d-%02d-%02d %02d:%02d:%02d\r\n", ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour, ptm.tm_min, ptm.tm_sec);


	sntp_header->receiveTimestamp.seconds = ntohl(sntp_header->receiveTimestamp.seconds) - SNTP_SECONDS_FROM_1900_TO_1970 + (long)(tz * 3600);
	sntp_header->receiveTimestamp.fractional = ntohl(sntp_header->receiveTimestamp.fractional);

	//ptm = gmtime(&sntp_header->receiveTimestamp.seconds);
	gmtime_r(&sntp_header->receiveTimestamp.seconds, &ptm);
	//if(ptm)
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] ReceiveTime = %d-%02d-%02d %02d:%02d:%02d\r\n", ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour, ptm.tm_min, ptm.tm_sec);


	sntp_header->transmitTimestamp.seconds = ntohl(sntp_header->transmitTimestamp.seconds) - SNTP_SECONDS_FROM_1900_TO_1970 + (long)(tz * 3600);
	sntp_header->transmitTimestamp.fractional = ntohl(sntp_header->transmitTimestamp.fractional);

	//ptm = gmtime(&sntp_header->transmitTimestamp.seconds);
	gmtime_r(&sntp_header->transmitTimestamp.seconds, &ptm);
	//if(ptm)
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] transmitTime = %d-%02d-%02d %02d:%02d:%02d (%d s)\r\n", ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour, ptm.tm_min, ptm.tm_sec, (int)sntp_header->transmitTimestamp.seconds);
*/
    gmtime_r(&trn_time, &tm_utc);
    localtime_r(&trn_time, &tm_os);
    timezone = mktime(&tm_os) - mktime(&tm_utc);

	trip = (ct.seconds - org_time) - (trn_time- rcv_time);
	//slog(MISC_PRINT, SLOG_DEBUG,"[zyl] ct.seconds = %ld\r\n", ct.seconds);
	//slog(MISC_PRINT, SLOG_DEBUG,"[zyl] sntp_header->originateTimestamp.seconds = %ld\r\n", sntp_header->originateTimestamp.seconds);
	//slog(MISC_PRINT, SLOG_DEBUG,"[zyl] sntp_header->transmitTimestamp.seconds = %ld\r\n", sntp_header->transmitTimestamp.seconds);
	//slog(MISC_PRINT, SLOG_DEBUG,"[zyl] sntp_header->receiveTimestamp.seconds = %ld\r\n", sntp_header->receiveTimestamp.seconds);

	ct.seconds = trn_time + trip / 2;
	ct.fractional = ntohl(sntp_header->transmitTimestamp.fractional);
/*
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] RoundTripDelay = %d\r\n", trip);
	//ptm = gmtime(&ct.seconds);
	gmtime_r(&ct.seconds, &ptm);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] Synchronize system time to %d-%02d-%02d %02d:%02d:%02d\r\n", ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour, ptm.tm_min, ptm.tm_sec);
*/
	//snprintf(temp_nv,sizeof(temp_nv),"%d",ptm.tm_year+1900);
	//sc_cfg_set("sntp_year_fluxstat", temp_nv);
	//slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_year_fluxstat = %s\n", temp_nv);
	//snprintf(temp_nv,sizeof(temp_nv),"%d",ptm.tm_mon+1);
	//sc_cfg_set("sntp_month_fluxstat", temp_nv);
	//slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_month_fluxstat = %s\n", temp_nv);
	//sc_cfg_save();
	time_tv.tv_sec = ct.seconds;
	time_tv.tv_usec = 0;

	//slog(MISC_PRINT, SLOG_DEBUG,"[zyl] time_tv.tv_sec = %ld\r\n", time_tv.tv_sec);

	sc_cfg_get("sntp_dst_enable", tmp_buf, sizeof(tmp_buf));
	if (0 == strcmp(tmp_buf, "1")) {
		time_tv.tv_sec = time_tv.tv_sec + 60 * 60;
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] use dst time!!!\n");
	}

	sem_id = get_sem(TIME_SEM_KEY_1);
	if (sem_id != -1) {
		result = sem_p(sem_id);
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_parse_time, sem_p, sem_id = %d, result = %d\r\n", sem_id, result);
	}

	zte_sntp_handle_time(time_tv);
	zte_sntp_set_clear_traffic_data_nv_flag();
	if (sem_id != -1) {
		result = sem_v(sem_id);
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_parse_time, sem_v, sem_id = %d, result = %d\r\n", sem_id, result);
	}

	return SNTP_RESULT_OK;
}

int zte_sntp_socket_create()
{
	int sock_fd = -1;
	sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sock_fd < 0) {
		zte_sntp_set_error_state(SNTP_ERROR_CREATE_SOCKET);
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sendSocket Creation Fail!\n");
		return  SNTP_RESULT_FAIL;
	}
	return  sock_fd;
}

void zte_sntp_socket_close(int sock_fd)
{
	if (sock_fd != -1) {
		close(sock_fd);
	}
}


int zte_sntp_socket_sendto(int sock_fd, unsigned long *ip_addr, int ip_count)
{
	struct sockaddr_in toAddr;
	NTP_TIME_FMT ct = {0};
	int addrLen;
	SNTP_HEADER sntp_header = {0};
	int retValue;
	float tz = 0;
	int i = 0;
	int count = 0;
	char IPdotdec[20] = {0};
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_socket_sendto, need send ip count = %d\n", ip_count);

	//tz = zte_sntp_get_timezone();
	toAddr.sin_family      = AF_INET;
	toAddr.sin_port        = htons(SNTP_PORT);
	addrLen = sizeof(struct sockaddr);
#ifdef _OS_TOS
	ct.seconds = zOss_Time(NULL);
#else
	ct.seconds = time(NULL);
#endif
	memset(&sntp_header, 0, sizeof(sntp_header));
	sntp_header.liVnMode = 0x1b;
	sntp_header.transmitTimestamp.seconds = htonl((long)ct.seconds + (long)SNTP_SECONDS_FROM_1900_TO_1970 - (long)(tz * 3600));
	sntp_header.transmitTimestamp.fractional = 0;

	for (i = 0; i < ip_count; i++) {
		if (ip_addr[i] == 0) continue;

		count++;
		toAddr.sin_addr.s_addr = ip_addr[i];
		inet_ntop(AF_INET, &toAddr.sin_addr, IPdotdec, 16);
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_socket_sendto Send, i = %d, IP: %s \n", i, IPdotdec);

		retValue = sendto(sock_fd, &sntp_header, sizeof(SNTP_HEADER), 0,
		                  (struct sockaddr *)&toAddr, addrLen);
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_socket_sendto Send addrLen = %d . \n", addrLen);
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_socket_sendto Send success %d chars, need send %d chars\n", retValue, sizeof(SNTP_HEADER));
		//sleep(50);
	}
	slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_socket_sendto Send success %d ip!!!!!!!\n", count);

	return  SNTP_RESULT_OK;
}

int zte_sntp_socket_select(int sock_fd)
{
	fd_set readfds;
	struct timeval tv;
	int retValue;
	long before_time = 0;
	long after_time = 0;

	time(&before_time);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_socket_select  start to select ======before_time = %ld\n", before_time);

	FD_ZERO(&readfds);
	FD_SET(sock_fd, &readfds);
	tv.tv_sec = zte_sntp_get_select_interval_time();
	tv.tv_usec = 0;
	do {
		retValue = select(sock_fd + 1, &readfds, NULL, NULL, &tv);
	} while (retValue < 0 && errno == EINTR);

	if (retValue < 0) {
		zte_sntp_set_error_state(SNTP_ERROR_SELECT_RETURN_ERR);
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] 1...select data fail...break \n");
		return  SNTP_RESULT_FAIL;
	}

	time(&after_time);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] 2...select data, after_time = %ld, use time = %ld \n", after_time, after_time - before_time);

	if (retValue == 0) {
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] 3...select data, retValue==0, after_time = %ld, use time = %ld \n", after_time, after_time - before_time);
		return  SNTP_RESULT_CONTINUE;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] 4...select data, retValue==1, after_time = %ld, use time = %ld \n", after_time, after_time - before_time);
	return  SNTP_RESULT_OK;
}

int zte_sntp_socket_recvfrom(int sock_fd)
{
	int retValue = 0;
	int addrLen = 0;
	//NTP_TIME_FMT ct;
	struct sockaddr_in  recvAddr;
	SNTP_HEADER sntp_header = {0};

	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_socket_recvfrom...Received msg ... \n");
	addrLen = sizeof(struct sockaddr);
	memset(&sntp_header, 0, sizeof(sntp_header));
	retValue = recvfrom(sock_fd, (char*)&sntp_header, sizeof(SNTP_HEADER), 0, (struct sockaddr*)&recvAddr, &addrLen);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] recvfrom  retValue = %d\n", retValue);
	if (retValue <= 0) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] ...recvfrom data fail... \n");
		zte_sntp_set_error_state(SNTP_ERROR_RECV_FROM);
		return  SNTP_RESULT_FAIL;
	}

	return zte_sntp_parse_time(&sntp_header);
}

void zte_sntp_init_param()
{
	sc_cfg_set(SNTP_PROCESS_STATE, "processing");
	sc_cfg_set(SNTP_PROCESS_RESULT, "processing");
	//sc_cfg_set(SNTP_SYN_DONE, "processing");
}

void zte_sntp_process_for_webui()
{
	int  result = 0;
	int  sock_fd = -1;
	int  curr_server_index = 0;
	int ip_count = 0;
	unsigned long ip_addr[20] = {0};
	//BOOL first_use_config_ip = FALSE;

	zte_sntp_init_param();
	sock_fd = zte_sntp_socket_create();
	if (sock_fd == SNTP_RESULT_FAIL) {
		zte_sntp_set_process_result(SNTP_RESULT_FAIL);
		return;
	}

	/*result = zte_sntp_get_config_ip_addr(&ip_addr, sizeof(ip_addr));
	if(result == SNTP_RESULT_OK)
	{
	    first_use_config_ip = TRUE;
	}*/

	for (curr_server_index = 0; curr_server_index < sntp_server_count; curr_server_index++) {
		/*if(!first_use_config_ip)
		   {
		       memset(ip_addr, 0, sizeof(ip_addr));
		       if(curr_server_index >= SNTP_MAX_SERVER_NUM)
		       {
		           zte_sntp_set_error_state(SNTP_ERROR_ALL_SERVER_INVALID);
		           slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_get_ntp_server_ip: all server invalide, return \n");
		           break;
		       }

		       result = zte_sntp_get_one_ntp_server_ip(curr_server_index, &ip_addr, SNTP_MAX_SUPPORT_IP_COUNT);
		       if(result != SNTP_RESULT_OK)
		       {
		           curr_server_index++;
		           continue;
		       }
		   }*/
		memset(ip_addr, 0, sizeof(ip_addr));

		ip_count = zte_sntp_get_one_ntp_server_ip(curr_server_index, ip_addr, 2 * sntp_server_count);
		if (ip_count == SNTP_RESULT_FAIL) {
			continue;
		}

		result = zte_sntp_socket_sendto(sock_fd, ip_addr, ip_count);
		if (result == SNTP_RESULT_FAIL) {
			slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_socket_sendto failed!\n");
			break;
		}

		result = zte_sntp_socket_select(sock_fd);
		if (result == SNTP_RESULT_CONTINUE) {
			continue;
		} else if (result == SNTP_RESULT_FAIL) {
			break;
		}

		result = zte_sntp_socket_recvfrom(sock_fd);
		if (result == SNTP_RESULT_FAIL) {
			break;
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_process_for_webui=========success!\n");
		break;
	}

	if (curr_server_index >= sntp_server_count) {
		zte_sntp_set_error_state(SNTP_ERROR_ALL_SERVER_INVALID);
		result = SNTP_RESULT_FAIL;
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_get_ntp_server_ip: all server invalide, return \n");
	}
	zte_sntp_socket_close(sock_fd);
	zte_sntp_set_process_result(result);
	return;
}

void zte_sntp_process_for_background()
{
	int  result = 0;
	int  sock_fd = -1;
	int  curr_server_index = 0;
	int  ip_count = 0;
	unsigned long ip_addr[20] = {0};
	BOOL  first_use_default_ip = TRUE;

	zte_sntp_init_param();
	sock_fd = zte_sntp_socket_create();
	if (sock_fd == SNTP_RESULT_FAIL) {
		zte_sntp_set_process_result(SNTP_RESULT_FAIL);
		return;
	}

	for (curr_server_index = 0; curr_server_index < sntp_server_count; curr_server_index++) {
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_process_for_background first_use_default_ip= %d!\n", first_use_default_ip);
		memset(ip_addr, 0, sizeof(ip_addr));
		if (first_use_default_ip) {
			ip_count = zte_sntp_get_default_ip_addr(ip_addr, sntp_default_server_count);
			curr_server_index--;
		} else {
			ip_count = zte_sntp_get_one_ntp_server_ip(curr_server_index, ip_addr, 2 * sntp_server_count);
			if (ip_count == SNTP_RESULT_FAIL) {
				continue;
			}
		}

		if (ip_count == 0) {
			first_use_default_ip = FALSE;
			slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_process_for_background ip_count == 0!\n");
			continue;
		}

		result = zte_sntp_socket_sendto(sock_fd, ip_addr, ip_count);
		if (result == SNTP_RESULT_FAIL) {
			break;
		}

		result = zte_sntp_socket_select(sock_fd);
		if (result == SNTP_RESULT_CONTINUE) {
			first_use_default_ip = FALSE;
			slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_socket_select,SNTP_RESULT_CONTINUE curr_server_index = %d!\n", curr_server_index);
			continue;
		} else if (result == SNTP_RESULT_FAIL) {
			break;
		}

		result = zte_sntp_socket_recvfrom(sock_fd);
		if (result == SNTP_RESULT_FAIL) {
			break;
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] sntp_process_for_background=========success!\n");
		break;
	}
	if (curr_server_index >= sntp_server_count) {
		zte_sntp_set_error_state(SNTP_ERROR_ALL_SERVER_INVALID);
		result = SNTP_RESULT_FAIL;
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_get_ntp_server_ip: all server invalide, return \n");
	}
	zte_sntp_socket_close(sock_fd);
	zte_sntp_set_process_result(result);
	return;
}

int zte_sntp_check_ip()
{
	char sntp_server[NV_ITEM_STRING_LEN_20] = {0};
//	char sntp_default[NV_ITEM_STRING_LEN_20] = {0};
	char sntp_server_nv[NV_ITEM_STRING_LEN_20] = {0};
//	char sntp_default_nv[NV_ITEM_STRING_LEN_20] = {0};
	struct sntp_server *temp = NULL;
	int p = 0;
//	int q = 0;
	for (p = 0; p < sntp_server_count; p++) {
		snprintf(sntp_server, sizeof(sntp_server), "sntp_server%d", p);
		sc_cfg_get(sntp_server, sntp_server_nv, sizeof(sntp_server_nv));

		list_for_each_entry(temp, &sntp_server_head, list) {
			if (strcmp(temp->sntp_server_ip, sntp_server_nv) == 0) {
				slog(MISC_PRINT, SLOG_DEBUG,"[sntp]sntp server have one record same with default\n");
				slog(MISC_PRINT, SLOG_DEBUG,"[sntp]sntp_server_nv:%s,sntp_server_nv:%s\n", sntp_server_nv, sntp_server_nv);
				return 1;
			}
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[sntp]sntp_server%d:%s have no record\n", p, sntp_server_nv);
	}
	return 0;

}
void zte_sntp_thread_process()
{
	char buf[NV_ITEM_STRING_LEN_20] = {0};

	//sc_cfg_get("sntp_cmd_from", buf, sizeof(buf));
	//if(0 == strcmp(buf, "WEBUI"))
	if (g_sntp_cmd_from == 0) {
		if (zte_sntp_check_ip() == 0) {
			slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_thread_process, cmd form WEBUI!\n");
			zte_sntp_process_for_webui();
		} else {
			slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_thread_process, cmd form background!\n");
			zte_sntp_process_for_background();
		}
	} else {
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_thread_process, cmd form background!\n");
		zte_sntp_process_for_background();
	}
}

void sntp_set_mode(MSG_BUF *msg)
{
	int mode = -1;

	slog(MISC_PRINT, SLOG_ERR, "[SNTP]sntp_set_mode enter \n");

	if (msg->usDataLen <= 0) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP]sntp_set_mode param error len=0\n");
		return;
	}

	mode = atoi(msg->aucDataBuf);
	if (mode == 1) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_set_mode: auto\n");
		sc_cfg_set("sntp_process_state", "idle");
		sc_cfg_set("sntp_time_set_mode", "auto");
		sc_cfg_set("sntp_process_result", "");
		ipc_send_message(MODULE_ID_SNTP, MODULE_ID_SNTP, MSG_CMD_SNTP_START, 0, NULL, 0);
	} else if (mode == 0) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_set_mode: manual\n");
		sc_cfg_set("sntp_time_set_mode", "manual");
		sc_cfg_set("sntp_process_result", "success");
	} else
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_set_mode: mode unexpected\n");

	//sc_cfg_save();
	slog(MISC_PRINT, SLOG_ERR, "[SNTP]sntp_set_mode leave \n");
}

void sntp_set_time(MSG_BUF *msg)
{
	struct tm set_tm = {0};
	struct timeval time_tv;
    long timeSec = 0;
    int ret = 0;
	
	slog(MISC_PRINT, SLOG_ERR, "[SNTP]sntp_set_time, %d, %d \n", sizeof(struct tm), msg->usDataLen);

	//memcpy(&rtc_tm, msg->aucDataBuf, sizeof(struct rtc_time));
	memcpy(&set_tm, msg->aucDataBuf, msg->usDataLen);

	slog(MISC_PRINT, SLOG_ERR, "[SNTP]sntp_set_time, year:%d, month:%d, day:%d, hour:%d, min:%d, sec:%d, wday:%d \n",
	     set_tm.tm_year, set_tm.tm_mon, set_tm.tm_mday, set_tm.tm_hour, set_tm.tm_min, set_tm.tm_sec, set_tm.tm_wday);

	time_tv.tv_sec = mktime(&set_tm);
	time_tv.tv_usec = 0;

	if(time_tv.tv_sec < 0)  //  cov M NEGATIVE_RETURNS
	{
	    slog(MISC_PRINT, SLOG_ERR, "mktime return -1, set time_tv.tv_Sec to 0");
		time_tv.tv_sec = 0;
	}

	if (0 != settimeofday(&time_tv, NULL)) {
        slog(MISC_PRINT, SLOG_DEBUG, "[SNTP]sntp_set_time failed \n");
        return ;
    }
    
    timeSec = time(0);
    
    ret = ipc_send_message2(MODULE_ID_SNTP, MODULE_ID_RTC_SERVICE, RTC_MSG_SET_TIME, 
                        sizeof(timeSec), &timeSec, 0);
    if(ret != 0)
        slog(MISC_PRINT, SLOG_ERR, "[SNTP]send msg RTC_MSG_SET_TIME to rtc-service failed. \n");
}

void zte_sntp_start()
{
	pthread_t  sntp_thread_id;
	pthread_attr_t attr;
	int  result = 0;

	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] start sntp\n");

	sc_cfg_set(SNTP_PROCESS_STATE, "idle");
	pthread_attr_init(&attr);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	result = pthread_create(&sntp_thread_id, &attr, zte_sntp_thread_process, NULL);
	pthread_attr_destroy(&attr);
	if (result != 0) {
		sc_cfg_set(SNTP_PROCESS_STATE, "over");
		slog(MISC_PRINT, SLOG_ERR, "[SNTP] pthread_create faild!\n");
	} else {
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] pthread_create  SUCCESS!\n");
	}
}

void zte_sntp_add_list(MSG_BUF *stMsg)
{
	char result_buf[NV_ITEM_STRING_LEN_20] = {0};
	struct sntp_sync_queue *tmp = NULL;

	tmp = malloc(sizeof(struct sntp_sync_queue));
	if (tmp == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP]sntp_sync_queue malloc failed\n");
		return;
	}
	INIT_LIST_HEAD(&tmp->list);
	tmp->src_id = stMsg->src_id;
	list_add_tail(&tmp->list, &wait_sync_sntp);

	slog(MISC_PRINT, SLOG_ERR, "[SNTP] sntp_register_id = %d\n", stMsg->src_id);

	sc_cfg_get(SNTP_PROCESS_RESULT, result_buf, sizeof(result_buf));
	if (strcmp(result_buf, "success") == 0) {
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]get sync register and sync now!\n");
		ipc_send_message(MODULE_ID_SNTP, stMsg->src_id, MSG_CMD_SNTP_SUCCESS, 0, NULL, 0);
	}
}

void zte_sntp_success_notify()
{
	struct sntp_sync_queue *temp = NULL;
	slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] enter sntp_success_notify!\n");

	//϶Ҫ֪ͨģ
	ipc_send_message(MODULE_ID_SNTP, MODULE_ID_RTC_SERVICE, MSG_CMD_SNTP_SUCCESS, 0, NULL, 0);

	//һͨעҪ֪ͨģ
	list_for_each_entry(temp, &wait_sync_sntp, list) {
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_notify_process_id = %d\n", temp->src_id);
		ipc_send_message(MODULE_ID_SNTP, temp->src_id, MSG_CMD_SNTP_SUCCESS, 0, NULL, 0);
	}
}

void zte_sntp_remove_list(MSG_BUF *stMsg)
{
	struct sntp_sync_queue *temp = NULL;
	struct sntp_sync_queue *temp1 = NULL;
	list_for_each_entry_safe(temp, temp1, &wait_sync_sntp, list) {
		if (temp->src_id == stMsg->src_id) {
			slog(MISC_PRINT, SLOG_DEBUG, "[SNTP] sntp_unregister_id = %d\n", temp->src_id);
			list_del(&temp->list);
			free(temp);
			break;
		}
	}
}

unsigned long net_state_check()//0,error;
{
//	int i = -1;
//	char sntp_index[32] = {0};
	struct hostent* host = NULL;
	unsigned long ip = 0;
	struct sntp_server *temp = NULL;

	list_for_each_entry(temp, &sntp_server_head, list) {
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP][ZYL]value->%s\n", temp->sntp_server_ip);

		if (0 == strcmp("", temp->sntp_server_ip)) {
			continue;
		}
		if (temp->is_ipaddr == 1) {
			ip = inet_addr(temp->sntp_server_ip);
		} else {
			host = gethostbyname(temp->sntp_server_ip);
			if (host != NULL) {
				ip = *((unsigned long *) host->h_addr);
				slog(MISC_PRINT, SLOG_DEBUG, "[SNTP][ZYL]ip->%s\n", inet_ntoa(*(struct in_addr *)*host->h_addr_list));
			}
		}

		if (ip != 0) {
			slog(MISC_PRINT, SLOG_DEBUG,"[SNTP][ZYL]get host\n");
			break;
		}

		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP]net_state_check errorname->%s\n", temp->sntp_server_ip);
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP][ZYL]ip->%lu\n", ip);
	return ip;
}

int zte_sntp_check()//0:error;
{
	char state[NV_ITEM_STRING_LEN_20] = {0};
	char mode[NV_ITEM_STRING_LEN_10] = {0};
	char default_wan_rel[NV_ITEM_STRING_LEN_50] = {0};

	sc_cfg_get("default_wan_rel", default_wan_rel, sizeof(default_wan_rel));

	if (0 == strcmp(default_wan_rel, "")) {
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] Network disconnected, can not sntp!\n");
		return 0;
	}

	sc_cfg_get(SNTP_PROCESS_STATE, state, sizeof(state));
	sc_cfg_get("sntp_time_set_mode", mode, sizeof(mode));

	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] state->%s\n", state);
	slog(MISC_PRINT, SLOG_DEBUG,"[SNTP] mode->%s\n", mode);

	if ((strcmp(state, "over") == 0) && (strcmp(mode, "auto") == 0)) {
		return net_state_check();//0:error;
	}

	return 0;
}

void zte_sntp_cfg_init()
{
	char server_count[20] = {0};
	char mode[NV_ITEM_STRING_LEN_10] = {0};
        char interval[NV_ITEM_STRING_LEN_10] = {0};
	sc_cfg_set("sntp_process_state", "over");
	//sc_cfg_set("poweron_sntp","1");
	sc_cfg_get("sntp_time_set_mode", mode, sizeof(mode));
	sc_cfg_get("sntp_sync_time", interval, sizeof(interval));
        g_sntp_sync_interval_time = atoi(interval);
        if(g_sntp_sync_interval_time <= 0)
            g_sntp_sync_interval_time = 1;
	if (strcmp(mode, "manual") == 0) {
		sc_cfg_set("sntp_process_result", "success");
	} else {
		sc_cfg_set("sntp_process_result", "");
	}

//	sc_cfg_save();
	pthread_mutex_init(&g_sntp_getaddrinfo_mutex, NULL);
	pthread_mutex_init(&g_sntp_getnameinfo_mutex, NULL);
	zte_sntp_default_server_ip_addr();

	sc_cfg_get(SNTP_SERVER_NUM, server_count, sizeof(server_count));
	sntp_server_count = atoi(server_count);
}
int zte_sntp_action()
{
	long now_time = 0;
	long last_time = 0;
	char last_time_str[NV_ITEM_STRING_LEN_20] = {0};
	char result[NV_ITEM_STRING_LEN_20] = {0};

	sc_cfg_get(SNTP_PROCESS_RESULT, result, sizeof(result));
	time(&now_time);
	sc_cfg_get(SNTP_PROCESS_OVER_TIME, last_time_str, sizeof(last_time_str));
	last_time = atol(last_time_str);
    if(last_time > LONG_MAX-1)  // kw 3
    {
    	last_time = LONG_MAX;
    }	

	if (0 == zte_sntp_check()) {
		slog(MISC_PRINT, SLOG_DEBUG, "[SNTP][ZYL]Plz check net state or sntp mode\n");
		return -1;
	}

	if (strcmp(result, "success") != 0 || (now_time - last_time) >(g_sntp_sync_interval_time*SNTP_WAIT_TIME_DAY)) {
		//sc_cfg_set("sntp_cmd_from", "NO_WEBUI");
		g_sntp_cmd_from = 1;
		zte_sntp_start();
		//ڽʱͬȴһѭ
		return SNTP_DEFAULT_NEXT_SYNC_INTERVAL_TIME_WHEN_FAILURE;
	}

	//Ѿͬɹ˯ֱʱ
	return SNTP_DEFAULT_NEXT_SYNC_INTERVAL_TIME_WHEN_SUCCESS;

}

int sntp_proc()
{
	prctl(PR_SET_NAME, "sntp-proc", 0, 0, 0);

	while (1) {
		int time = 0;
		/*
		char result[NV_ITEM_STRING_LEN_20] = {0};
		zte_sntp_handle(&time);
		sc_cfg_get(SNTP_PROCESS_RESULT, result, sizeof(result));
		*/
		time = zte_sntp_action();
		if (time == SNTP_DEFAULT_NEXT_SYNC_INTERVAL_TIME_WHEN_FAILURE)
			sleep(time);
		else if (time == SNTP_DEFAULT_NEXT_SYNC_INTERVAL_TIME_WHEN_SUCCESS)
			sleep(SNTP_WAIT_TIME_HOUR);    
		else
			sleep(10);//绷δ
	}
}


int sntp_main(int argc, char * argv[])
{
	int interruptSIG = 0;
	int Create_Data_Thread_result = 0; //߳̽
	int iMsgHandle;
	int iRet = 0;
	MSG_BUF stMsg;
	LONG msgSize;
	pthread_attr_t attr;
	pthread_t  Create_Data_Thread_id;
	prctl(PR_SET_NAME, "sntp", 0, 0, 0);
	//NVʼӡ𣬲עᶯ̬ӡź
	loglevel_init();
	
	INIT_LIST_HEAD(&wait_sync_sntp);
	zte_sntp_cfg_init();

	pthread_attr_init(&attr);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	Create_Data_Thread_result = pthread_create(&Create_Data_Thread_id, &attr, sntp_proc, NULL);
	pthread_attr_destroy(&attr);
	if (Create_Data_Thread_result != 0) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP]Create_Data_Thread_result faild!\n");
		exit(-1);
	}

	iMsgHandle = msgget(MODULE_ID_SNTP, IPC_CREAT | 0600);
	msgSize =  sizeof(MSG_BUF) - sizeof(LONG);
	if (iMsgHandle == -1) {
		slog(MISC_PRINT, SLOG_ERR, "[SNTP]Create_msg_result faild!\n");
		exit(-1);
	}

	//FPҪȡCPʱ䣬ֶʱ䣬SNTPAPʱ
#if (PRODUCT_TYPE == PRODUCT_PHONE)
	iRet = ipc_send_message(MODULE_ID_SNTP, MODULE_ID_RTC_SERVICE, RTC_MSG_GET_TIME, 0, NULL, 0);
	if (iRet != 0)
		slog(MISC_PRINT, SLOG_ERR, "[SNTP]send msg RTC_MSG_GET_TIME failed. \n");
#endif

	for (; ;) {
		if (0 == interruptSIG) {
			slog(MISC_PRINT, SLOG_ERR, "[SNTP]data begin to rcv msg from queue %d. \n", iMsgHandle);
		}
		memset(&stMsg, '\0', sizeof(stMsg));

		iRet = 0;

		//Ϣ
		iRet = msgrcv(iMsgHandle, &stMsg, msgSize, 0, 0);
		if (-1 == iRet) {
			if (EINTR == errno) {
				slog(MISC_PRINT, SLOG_ERR, "[SNTP]received msg EINTR\n");
				interruptSIG = 1;
				continue;
			} else {
				slog(MISC_PRINT, SLOG_ERR, "[SNTP]recv msg from the MODULE_ID_DATA fail errno=%d!", errno);
				return -1;
			}
		} else {
			interruptSIG = 1;
		}

#if 0
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]iMsgHandle->%d\n", iMsgHandle);
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]usSourceModuleID->%d\n", stMsg.usSourceModuleID);
		slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]usMsgCmd->%d\n", stMsg.usMsgCmd);
#endif

		if (stMsg.dst_id == MODULE_ID_SNTP) {
			if (stMsg.usMsgCmd == MSG_CMD_SNTP_SET_MODE) {
				slog(MISC_PRINT, SLOG_ERR, "[SNTP]MSG_CMD_SNTP_SET \n");
				sntp_set_mode(&stMsg);
			} else if (stMsg.usMsgCmd == MSG_CMD_SNTP_SET_TIME) {
				slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]MSG_CMD_SNTP_SET_TIME\n");
				sntp_set_time(&stMsg);
			} else if (stMsg.usMsgCmd == MSG_CMD_SNTP_START) {
				slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]sntp_start\n");
				g_sntp_cmd_from = 0;
				zte_sntp_start();
			} else if (stMsg.usMsgCmd == MSG_CMD_SNTP_REGISTER) {
				slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]get sntp register msg\n");
				zte_sntp_add_list(&stMsg);
			} else if (stMsg.usMsgCmd == MSG_CMD_SNTP_UNREGISTER) {
				slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]get sync unregister msg\n");
				zte_sntp_remove_list(&stMsg);
			} else {
				slog(MISC_PRINT, SLOG_DEBUG,"[SNTP]usMsgCmd error!\n");
			}
		} else {
			slog(MISC_PRINT, SLOG_ERR, "[SNTP]src_id error!\n");
		}
	}
}
