/*
 *  wlan-station.c -- wifi station mode Deal module
 *
 *  Copyright (c) ZTE Corporation All Rights Reserved.
 *
 *  $Id: wlan-station.c, v 0.1 2015-03-09 $
 *   Authors :  XUJIAN - xu.jian5@zte.com.cn>
 */
#include "wifi_util.h"
#include "wlan_sta_manager.h"
#include "Vector.h"
#include "wifi_sta_ctrl.h"
#include "soft_timer.h"
#include "rtk_arch.h"
#include <semaphore.h>

#include "wlan_sm.h"
#include <ctype.h>
#include "wifi_socket.h"
extern struct   wlan_sta_manager  *sta_manager;

#define UEVENT_BUFFER_SIZE   1024*2

extern sem_t g_wpa_supplicant_id;
int g_wpa_supplicant = 0;

wlan_sta_handle_t   g_wlan_handle;

static spot_t *g_spot_list_p[WIFI_STATION_SPOT_LIST_NUM] = {NULL};//ȵбָ

static scan_result_t *g_scan_result_list_p[WIFI_STATION_SCAN_RESULT_LIST_NUM] = {NULL};//ɨȵбָ



static int wifi_station_connect (void);

static void sta_connect (int network_id);
static int  find_linked_ap_index(void);
static void delete_quote (char * str);
static void wlan_station_deinit(void);
void update_global_scan_result_list(spot_action_t action, spot_t *spot) ;
static void HexStrToByte(const char* source, unsigned char* dest, int sourceLen);
void hex_dump(char *buf);


inline char * sta_docmd(const char *cmd)
{
	return docmd (&sta_manager->sock, cmd);
}

void wpa_supplicant_scan (void)
{
	sta_docmd("SCAN only");
}
//kw
static void *wifi_station_scan_timer_callback(void* arg)
{
	wf_msg_to_self(MSG_CMD_WIFI_STATION_SCAN, 0, NULL);
	return NULL;
}

static void create_scan_timer(void)
{
	if(0 == g_wlan_handle.softtimer){
		sc_timer_create(WIFI_STATION_TIMER_SCAN, 
					 TIMER_FLAG_RESTART, WIFI_STATION_TIMER_SCAN_INTERVAL, 
					 wifi_station_scan_timer_callback, NULL);

		g_wlan_handle.softtimer = 1;
	}
}

static void delete_scan_timer(void)
{
	if(1 == g_wlan_handle.softtimer){
		sc_timer_delete(WIFI_STATION_TIMER_SCAN);
		g_wlan_handle.softtimer = 0;
	}
}


wlan_sm_state_t wf_sm_state(void)
{
	return wlan_sm_get_state(g_wlan_handle.sm_handle);
}

spot_t * find_spot_by_id(int id)
{
	int i=0;
	while(g_spot_list_p[i]){
		if(g_spot_list_p[i]->network_id == id)
			return g_spot_list_p[i];

		i++;
	}
	return NULL;
}

spot_t * find_spot_by_mac(char*mac)
{
	int i=0;
	while(g_spot_list_p[i]){
		if(!strcmp(g_spot_list_p[i]->mac,mac))
			return g_spot_list_p[i];

		i++;
	}
	return NULL;
}


//ִһshellд洢resvecУ
static int32_t  convert2vector (const char *str, vector_t* resvec)
{
	char *tmp = NULL; //һʵĳȣԴ洢ÿһ
	char *ret = NULL;
	FILE  *fp = NULL;
	int tmp_len = 0;

	if (str == NULL || resvec == NULL) {
		return -1;
	}

	fp = fopen ("/tmp/scan_results", "w+"); //ܵ
	if (!fp) {
		wf_log ("fopen errno: %d\n", errno); 
		return -1;
	}
	fprintf (fp, "%s", str);
	fseek (fp, 0, SEEK_SET);
	tmp = safe_malloc (WIFI_STATION_SCRIPT_RSP_LINE_LEN, TRUE);

again:
	while ((ret=fgets (tmp, WIFI_STATION_SCRIPT_RSP_LINE_LEN, fp)) != NULL) {
		tmp_len = strlen (tmp);
		if (tmp_len > 0) {
			if (tmp[tmp_len - 1] == '\n') {
				tmp[tmp_len - 1] = '\0'; //ȥз
			}
			vector_push_back (resvec, var_string (tmp));
		}
	}

	if (EINTR ==errno) { //kw 3
		goto again;
	}

	fclose (fp); 
	safe_free (tmp);

	return vector_size (resvec);
}


//TODO DOWN UPװ
static void network_down_up (BOOL is_up)
{
	if (is_up == TRUE) {
		sc_cfg_set ("WAN_MODE", "WIFI"); //usb,ppp,wifi
		netdev_connect_internet (WIFI_WAN_DEV, MODULE_ID_WIFI);

		wf_log ("netdev_connect_internet");
	} else {
		netdev_disconnect_internet (WIFI_WAN_DEV, MODULE_ID_WIFI);
		sc_cfg_set ("WAN_MODE", "PPP"); //usb,ppp,wifi
	}
}


static void  save_config (spot_t *spot)
{

	char cmd[WIFI_STATION_CMD_LEN] = {0};
	char *ptr = NULL;
	char *ptr2 = NULL;
	char *ptr3 = NULL;
	//char *ptr4 = NULL;
	char *ptr5 = NULL;
	char *ptr6 = NULL;
//	int  key_len = 0;
	int id;

	if (spot == NULL)    {
		return;
	}

	if (spot->network_id   == -1) {

		//id = atoi (sta_docmd ("ADD_NETWORK"));
		//klocwork
		char *reply = NULL;
		reply = sta_docmd("ADD_NETWORK");
		if (reply == NULL) {
			return;
		}
		id = atoi(reply);
		
		spot->network_id = id;
		wf_log ("[sav_config] new spot  get new networkid=%d", id);

	} else {
		id = spot->network_id ;
		wf_log ("[sav_config] old spot  have networkid=%d", id);

	}


	sprintf (cmd,  "SET_NETWORK %d ssid \"%s\"", id , spot->ssid);
	sta_docmd (cmd);

	sprintf (cmd,  "SET_NETWORK %d bssid %s", id , spot->mac);
	sta_docmd (cmd);

	memset (cmd, 0, WIFI_STATION_CMD_LEN);
	ptr = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA_PSK);
	ptr2 = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA2_PSK);
	ptr3 = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA_EAP);
	// ptr4 = strstr(auth_mode, WIFI_STATION_PROFILE_AUTH_WPA2_EAP);

	ptr5 = strstr (spot->encrypt_type, WIFI_STATION_PROFILE_ENCRYPT_CCMP);
	ptr6 = strstr (spot->encrypt_type, WIFI_STATION_PROFILE_ENCRYPT_TKIP);

	sprintf (cmd, "SET_NETWORK %d priority 1", id);
	sta_docmd (cmd);


	if (ptr || ptr2) {
		sprintf (cmd, "SET_NETWORK %d key_mgmt WPA-PSK", id);
		sta_docmd (cmd);

		if (ptr && !ptr2) {
			sprintf (cmd, "SET_NETWORK %d proto WPA", id);
			sta_docmd (cmd);
		} else if (!ptr && ptr2) {
			sprintf (cmd, "SET_NETWORK %d proto RSN", id);
			sta_docmd (cmd);
		}
		else{
			sprintf (cmd, "SET_NETWORK %d proto WPA RSN", id);
			sta_docmd (cmd);

		}
		if (ptr5 && !ptr6) {
			sprintf (cmd, "SET_NETWORK %d pairwise CCMP", id);
			sta_docmd (cmd);
		} else if (!ptr5 && ptr6) {
			sprintf (cmd, "SET_NETWORK %d pairwise TKIP", id);
			sta_docmd (cmd);
		} else {
			sprintf (cmd, "SET_NETWORK %d pairwise CCMP TKIP", id);
			sta_docmd (cmd);
		}

		sprintf (cmd, "SET_NETWORK %d psk \"%s\" ", id , spot->password);
		sta_docmd (cmd);
	}
#if 0
	else if (ptr3) { //|| ptr4)
		sprintf (cmd, "SET_NETWORK %d key_mgmt WPA-EAP", id);
		sta_docmd (cmd);

		if (g_cardmode == CARD_MODE_USIM) {
			sprintf (cmd, "SET_NETWORK %d eap AKA", id);
			sta_docmd (cmd);
		} else {
			sprintf (cmd, "SET_NETWORK %d eap SIM", id);
			sta_docmd (cmd);
		}
		sprintf (cmd, "SET_NETWORK %d pcsc '\" \"'", id);
		sta_docmd (cmd);

//¸ȼΪ
		sprintf (cmd, "SET_NETWORK %d priority 4", id);
		sta_docmd (cmd);

	} 

#endif
	else {
		sprintf (cmd, "SET_NETWORK %d key_mgmt NONE", id);
		sta_docmd (cmd);
	}

#if 0
	ptr = NULL;
	ptr = strstr (spot->encrypt_type, WIFI_STATION_PROFILE_ENCRYPT_WEP);
	if (ptr) {
		sprintf (cmd, "SET_NETWORK %d wep_tx_keyidx %d", id , spot->keyID);
		sta_docmd (cmd);

		key_len = strlen (spot->password);
		wf_log ("key_len=%d,password_wep=%s",  key_len, spot->password);
		memset (cmd, 0, WIFI_STATION_CMD_LEN);
		if (key_len == 5 || key_len == 13) { //ascii
			sprintf (cmd, "SET_NETWORK %d wep_key%d \"%s\"", id , spot->keyID, spot->password);
		} else if (key_len == 10 || key_len == 26) { //hex
			sprintf (cmd, "SET_NETWORK %d wep_key%d %s", id,  spot->keyID, spot->password);
		} else {
			sprintf (cmd, "SET_NETWORK %d wep_key%d \"%s\"", id, spot->keyID, spot->password);
		}
		sta_docmd (cmd);
	}

	ptr = NULL;
	ptr = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_SHARED);
	if (ptr) {
		sprintf (cmd, "SET_NETWORK %d auth_alg SHARED", id);
		sta_docmd (cmd);
	}
#endif
//	sprintf (cmd, "SET_NETWORK %d scan_ssid 1", id);
//	sta_docmd (cmd);


	sta_docmd ("SAVE_CONFIG");
	sta_docmd ("LIST_NETWORKS");
}



void dump_spot(void)
{
	int i = 0;
	int spot_num = g_wlan_handle.spots_num;
	int scan_result_num = g_wlan_handle.scan_spot_num;

	wf_log("spot list:spot_num=%d", spot_num);
//ʱĸѾǼˣԸҪ1
	for (i = 0; i < spot_num; i++) {
		if (NULL != g_spot_list_p[i]) {
			wf_log ("spot[%d]%s,%s,%s,%s,%s,%d", i , 
			        g_spot_list_p[i]->ssid, g_spot_list_p[i]->auth_mode, g_spot_list_p[i]->encrypt_type,
			        g_spot_list_p[i]->password, g_spot_list_p[i]->mac, g_spot_list_p[i]->network_id);
		} else {
			wf_log ("ERROR, g_spot_list_p[%d] should not be NULL spot_num = %d\n ", i, spot_num);
		}
	}

	wf_log(">>>>>>scan result list:scan_result_num=%d", scan_result_num);

	for (i = 0; i < scan_result_num; i++) {
		if (NULL != g_scan_result_list_p[i]) {
			wf_log ("spot[%d]%d,%d,%s,%s,%d", i , 
			        g_scan_result_list_p[i]->connect_status, g_scan_result_list_p[i]->signal,
			        g_scan_result_list_p[i]->ssid, g_scan_result_list_p[i]->mac, g_scan_result_list_p[i]->network_id);
		}else
			break;
	}

	wf_log("<<<<<<<");

}

static void del_spot (int network_id)
{
	int i = 0;
	int del_index = 0;
	int spot_num = g_wlan_handle.spots_num;

	for (i = 0; i < spot_num; i++) {
		if(network_id == g_spot_list_p[i]->network_id){
			del_index = i;// ҵҪɾĸ
			g_spot_list_p[i]->network_id = -1;
		}
	}

	update_global_scan_result_list(DEL_ACTION, g_spot_list_p[del_index]);//ɨб ĳȵ
	safe_free (g_spot_list_p[del_index]);

//ʱĸѾǼˣԸҪ1
	for (i = del_index + 1; i < spot_num; i++) {

		if (g_spot_list_p[i] != NULL) {
			g_spot_list_p[i - 1] = g_spot_list_p[i];
			g_spot_list_p[i] = NULL;
		}
	}
	g_wlan_handle.spots_num--;

	dump_spot();
}
void dump_ap(spot_t *conn_ap)
{
	printf("mac=%s\n",conn_ap->mac);
	printf("ssid=%s\n",conn_ap->ssid);
	printf("auth_mode=%s\n",conn_ap->auth_mode);
	printf("encrypt_type=%s\n",conn_ap->encrypt_type);
	printf("password=%s\n",conn_ap->password);
	printf("network_id=%d\n",conn_ap->network_id);
}

/*webui Ѿȵnv
   ˺Ҫnvȵ µӦõȫֱ
   ȵļȡnetworkid ȫֱ

*/
static void  mmi_connect_spot (spot_t *info)
{

	if(WIFI_STATION_SPOT_LIST_NUM == g_wlan_handle.spots_num)
	{
		//remove the the not exist spot
		if(info->network_id == -1) {//cov
			wf_log ("network list full!!!");
			return;
		}
	}

	if(info->network_id == -1)
	{		
		spot_t *spot = NULL;
	//ӵȵ㲻Ӫȵ㣬ӵȵ㣬Զͨȵ㣬ֱӰ˳ں
		spot = safe_malloc (sizeof (spot_t), FALSE);
		if (spot == NULL) {
			return;
		}
	//	dump_ap(info);
		memcpy(spot,info, sizeof(spot_t));
		spot->network_id = -1;
		
		dump_ap(spot);
		save_config (spot);
		g_spot_list_p[g_wlan_handle.spots_num] = spot;
		g_wlan_handle.spots_num++;

		g_wlan_handle.disc_type = DISCONNECT_AUTO;
		update_global_scan_result_list(SAVE_ACTION, spot);
		dump_spot();
		sta_connect (spot->network_id);

	}
	else {	
		//ȵopenʱ ıܷʽ ʱЯ add_networkʱŻЯ,ʱֱӱҲ磬ǼȨʧ
		char cmd[WIFI_STATION_CMD_LEN] = {0};
		int reason = WIFI_STATION_WRONG_KEY;
		spot_t *spot = find_spot_by_id(info->network_id);
		if(NULL != spot 
			&& 0 == strcmp(spot->ssid, info->ssid)
			&& 0 == strcmp(spot->mac, info->mac)
			&& 0 == strcmp(spot->auth_mode, info->auth_mode)
			&& 0 == strcmp(spot->encrypt_type, info->encrypt_type)) {
			wf_log ("mmi_connect_spot network match!");
			sta_connect (info->network_id);
		}
		else {
			wf_log ("mmi_connect_spot network mismatch!");
			dump_ap(info);
			dump_spot();

			if (NULL != spot) { // mminetwork_idûDEL_ACTIONΪ-1ʱ
				sprintf(cmd, "REMOVE_NETWORK %d", info->network_id);
				sta_docmd(cmd);
				sta_docmd("SAVE_CONFIG");
				del_spot(info->network_id);
			}
			
			wf_msg_to_mmi(MSG_CMD_WIFI_STATION_CONNECT_FAIL, 4, &reason);
		}
		
	}
}


void read_spot_config(spot_t  *info, char * result)
{
	char *splited_string = NULL;
	char *save = NULL;
	const char *delimiter = "\t";
	char spot_string_tmp[256] = {0};
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	char *reply=NULL;

	char key_mgmt[32]={0};
	char proto[32]={0};
	char pairwise[32]={0};
	char auth_alg[32]={0};

	//safe_strcpy(spot_string_tmp, result, 256);
	strncpy(spot_string_tmp, result, sizeof(spot_string_tmp)-1);//kw
	splited_string = strtok_r(spot_string_tmp, delimiter, &save);
	
	while (splited_string) {
		info->network_id = atoi(splited_string);
		break;
	}

	sprintf (cmd, "GET_NETWORK %d ssid", info->network_id);
	reply = sta_docmd (cmd);
	if (reply != NULL) {
		wf_log ("reply SSID=%s", reply);
		
		char tmp[128]={0};
		
		if (reply[0] == '"'){
			strncpy(tmp, reply, sizeof(tmp)-1);//kw
			delete_quote (tmp);
		}
		else{
			HexStrToByte (reply, tmp, strlen(reply));
		}

		hex_dump (tmp);
		strcpy (info->ssid, tmp);
	}

	sprintf (cmd, "GET_NETWORK %d bssid", info->network_id);
	reply = sta_docmd (cmd);
	if (reply != NULL)strncpy (info->mac, reply, sizeof(info->mac)-1);


	sprintf (cmd, "GET_NETWORK %d key_mgmt", info->network_id);//NONE, WPA-PSK, WPA-EAP,IEEE8021X, "WPA2_PSK ???"
	reply = sta_docmd (cmd);
	if (reply != NULL)strncpy (key_mgmt, reply, sizeof(key_mgmt)-1);
	else
		strcpy (key_mgmt,  "WPA-PSK WPA-EAP");
	
	sprintf (cmd, "GET_NETWORK %d proto", info->network_id);// WPA, RSN
	reply = sta_docmd (cmd);
	if (reply != NULL)strncpy (proto, reply, sizeof(proto)-1);
	else
			strcpy (key_mgmt,  "WPA RSN");

	sprintf (cmd, "GET_NETWORK %d pairwise", info->network_id);//NONE, TKIP,CCMP
	reply = sta_docmd (cmd);
	if (reply != NULL)strncpy (pairwise, reply, sizeof(pairwise)-1);
	else
			strcpy (key_mgmt,  "CCMP TKIP");

	sprintf (cmd, "GET_NETWORK %d auth_alg", info->network_id);//OPEN, SHARED,LEAP
	reply = sta_docmd (cmd);
	if (reply != NULL)strncpy (auth_alg, reply, sizeof(auth_alg)-1);

	wf_log("key_mgmt=%s,proto=%s,pairwise=%s, auth_alg=%s\n", key_mgmt,proto,pairwise, auth_alg);

	if(strstr(key_mgmt, "WPA-PSK")){
		if(strstr(proto, "WPA") && !strstr(proto, "RSN")){
			snprintf (info->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPAPSK");
		}
		else if(!strstr(proto, "WPA") && strstr(proto, "RSN")){
			snprintf (info->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPA2PSK");
		}else if(strstr(proto, "WPA") && strstr(proto, "RSN")){
			snprintf (info->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPAPSKWPA2PSK");
		}
		else
			snprintf (info->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPAPSKWPA2PSK");
		
		if(strstr(pairwise, "CCMP") && !strstr(pairwise, "TKIP")){
			snprintf (info->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "CCMP");
		}
		else if(!strstr(pairwise, "CCMP") && strstr(pairwise, "TKIP")){
			snprintf (info->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "TKIP");

		}else if(strstr(pairwise, "CCMP") && strstr(pairwise, "TKIP")){
			snprintf (info->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "TKIPCCMP");
		}
		else
			snprintf (info->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "TKIPCCMP");
	
		
	}
	else if(strstr(key_mgmt, "NONE")){
		if(strstr(auth_alg, "SHARED")){///???
			snprintf (info->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "SHARED");
		}
		else
		 snprintf (info->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "NONE");
	}

}

static void  load_spots_form_conf (void)
{

	int i = 0, j=0;
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	char * reply = NULL;

	char *splited_string = NULL;
	char *save = NULL;
	const char *delimiter = "\n";
	char *spot_string_tmp  = safe_malloc (4096, FALSE);
	if(NULL == spot_string_tmp){
		wf_log("spot_string_tmp  malloc failed");
		return;
	}

	//ͷ֮ǰ洢ȵбڴ
	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		safe_free (g_spot_list_p[i]);
	}

	reply = sta_docmd ("LIST_NETWORKS");
	//klocwork
	if (reply == NULL) {
		safe_free(spot_string_tmp);
		return;
	}
	
	strncpy(spot_string_tmp, reply, 4096-1);
	*(spot_string_tmp + 4096 - 1) = '\0';//kw 1
	splited_string = strtok_r(spot_string_tmp, delimiter, &save);
	
	i =0;
	wf_log("splited_string = %s\n",splited_string);
	
	while (splited_string) {
		if(0 == j){
			j = 1;
		}
		else{
			g_spot_list_p[i] = safe_malloc (sizeof (spot_t), FALSE);
			if (g_spot_list_p[i] == NULL) {
				safe_free(spot_string_tmp);
				return;
			}
			read_spot_config(g_spot_list_p[i], splited_string);
			i++;
		}
		splited_string = strtok_r(NULL, delimiter, &save);
		
		wf_log("splited_string = %s\n",splited_string);
	}

	g_wlan_handle.spots_num = i;

	safe_free(spot_string_tmp);
	dump_spot();
}


/**/
static void  delete_quote (char * str)
{
	int len = 0;
	printf("str=%s\n", str);
	if (*str == '\"') {
		//strcpy (str, str + 1); //cov m
		len = strlen(str + 1);
		memmove(str, str + 1, len + 1); 
		*(str + len) = '\0';
	}
	printf("str=%s\n", str);

	if (*(str + strlen(str) - 1) == '\"')
		*(str + strlen(str) - 1) = '\0';

	printf("str=%s\n", str);
}


static void sort_scan_result_by_signal (scan_result_t **scan_result, int size)
{
	int i, j = 0;
	scan_result_t *insertnode = NULL;

	if (scan_result == NULL) {
		return;
	}

	for (i = 0; i < size; i++) {
		if (scan_result[i] == NULL) {
			return;
		}
	}

	//ֱӲ㷨
	for (i = 1; i < size; i++) { //βֵ
		insertnode = scan_result[i];  //ֵ,ڱ
		j = i - 1;                                             //Ŀʼλ
		while (j >= 0 && insertnode->signal > scan_result[j]->signal) { //ʵĲλ
			scan_result[j + 1] = scan_result[j];
			j--;
		}
		scan_result[j + 1] = insertnode;
	}

}

/*
    inputStr: if there is a  \, then
    outputStr: add \\ before, to be \\\


*/

static char* process_backlash (char* inputStr, char* outputStr)
{
	int len = 0;
	int i, j = 0;
	if ( (NULL == inputStr) || (NULL == outputStr)) {
		return NULL;
	}

	len = strlen (inputStr);
	for (i = 0; i < len; i++) { //linux ת
		if ( (inputStr[i] == 0x5c && inputStr[i + 1] == 'x')) {
			outputStr[j++]  = 0x5c;
		}
		outputStr[j++] = inputStr[i];
	}
	outputStr[j] = '\0';
	//printf("[process_backlash]inputStr=%s,outputStr=%s",inputStr,outputStr);

	return outputStr;
}

static void save_scan_result (scan_result_t*  scan_result, char *scan_result_str, char *scan_result_str1)
{
	char *scan_result_str_temp = NULL;
	char one_scan_result_str[WIFI_STATION_SCAN_ONE_RESULT_STR_LEN] = {0};
	int one_scan_result_str_len = 0;

	char ssid[128] = {0};
	if (scan_result == NULL
	    || scan_result_str == NULL
	    || scan_result_str1 == NULL) {
		return;
	}

	if (strlen (scan_result->ssid) <= 0) {
		return;
	}

	scan_result_str_temp = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, TRUE);


//	process_backlash (scan_result->ssid, ssid);

	snprintf (one_scan_result_str, WIFI_STATION_SCAN_ONE_RESULT_STR_LEN, "%s,%s,%s,%s,%d,%d,%d,%d",scan_result->mac, scan_result->ssid,
	            scan_result->auth_mode, scan_result->encrypt_type, scan_result->channel, scan_result->signal, scan_result->connect_status,scan_result->network_id);

//	wf_log("%s",one_scan_result_str);
	one_scan_result_str_len = strlen (one_scan_result_str);

	//cfgӿ"nv name=nv value\0"ʽ洢һΪ1024+2
	if (one_scan_result_str_len + strlen (scan_result_str) + strlen ("EX_APLIST") + 2 > WIFI_STATION_SCAN_RESULT_STR_LEN) {
		if (one_scan_result_str_len + strlen (scan_result_str1) + strlen ("EX_APLIST1") + 2 > WIFI_STATION_SCAN_RESULT_STR_LEN) {
			//2048ֽˣ˳
			safe_free (scan_result_str_temp);
			return;
		} else {
			safe_strcpy (scan_result_str_temp, scan_result_str1, strlen (scan_result_str1) + 1);

			strncat (scan_result_str_temp, one_scan_result_str, one_scan_result_str_len);
			strncat (scan_result_str_temp, ";", 1);

			//ֵ
			safe_strcpy (scan_result_str1, scan_result_str_temp, WIFI_STATION_SCAN_RESULT_STR_LEN);
		}
	} else {
		safe_strcpy (scan_result_str_temp, scan_result_str, strlen (scan_result_str) + 1);

		strncat (scan_result_str_temp, one_scan_result_str, one_scan_result_str_len);
		strncat (scan_result_str_temp, ";", 1);

		//ֵ
		safe_strcpy (scan_result_str, scan_result_str_temp, WIFI_STATION_SCAN_RESULT_STR_LEN);
	}

	safe_free (scan_result_str_temp);

}

void update_scan_spot_connect_status(scan_result_t *scan_result)
{
	if (CONNECTED_STATUS == g_wlan_handle.conn_status) {
		if (g_wlan_handle.list_id !=  -1) {
//			wf_log ("g_spot_list_p[i]->ssid=[%s],scan_result->ssid=[%s]",
//					g_spot_list_p[i]->ssid, scan_result->ssid);

			if (strcmp (g_spot_list_p[g_wlan_handle.list_id]->mac, scan_result->mac) == 0
				&& strcmp (g_spot_list_p[g_wlan_handle.list_id]->ssid, scan_result->ssid) == 0) {
				scan_result->connect_status = CONNECTED_STATUS;
			} else {
				scan_result->connect_status = DISCONNECT_STATUS;

			}
//			wf_log ("connect_status = [%d]",  scan_result->connect_status);
		} else {
			scan_result->connect_status = DISCONNECT_STATUS;
		}

	} else {
		scan_result->connect_status = DISCONNECT_STATUS;
	}

}



/* ʮַתΪֽ
 * ege8(16ƣ2ֽ)---תΪe8һֽڣ
 */
static void HexStrToByte(const char* source, unsigned char* dest, int sourceLen)
{
    short i;
    unsigned char highByte, lowByte;

    for (i = 0; i < sourceLen; i += 2)
    {
        highByte = toupper(source[i]);
        lowByte  = toupper(source[i + 1]);

        if (highByte > 0x39)
            highByte -= 0x37;
        else
            highByte -= 0x30;

        if (lowByte > 0x39)
            lowByte -= 0x37;
        else
            lowByte -= 0x30;

        dest[i / 2] = (highByte << 4) | lowByte;
    }
    return ;
}

/* ַ𿪣װ
 * eg: ab\xe8\x80\x83\xe5\x8b\xa4תΪ
 *        ab????ab)
 */
static void string_reerect(char *src, char *destBuf)
{
    int i = 0;
    int j = 0;
	char tmp[8]={0};

    while(src[j] != '\0')
    {
        if(strncmp(&src[j], "\\x", 2) != 0)
        {
			memcpy(&destBuf[i], &src[j], 1);
            i = i + 1;
            j = j + 1;
        }
        else
        {
            HexStrToByte(&src[j+2], &destBuf[i],2);
            i = i+1;
            j = j+4;
        }
		memset(tmp,0,8);
    }
    destBuf[i] = '\0';

    return ;
}

void hex_dump(char *buf)
{
	int len = strlen(buf);
	int i=0;
	printf("\n dump[%s]\n", buf);

	for(i=0;i<len;i++)
		printf("%x ", buf[i]);

	printf("\n");

}

void update_scan_spot_network_id(scan_result_t *scan_result)
{
	int i=0;
	int num = g_wlan_handle.spots_num;
	char ssid_tmp[WIFI_STATION_SSID_LEN]={0};
//	wf_log("enter");
//	hex_dump(scan_result->ssid);

	string_reerect(scan_result->ssid, ssid_tmp);
//	hex_dump(ssid_tmp);
	for(i = 0;i < num; i++){
//		hex_dump(g_spot_list_p[i]->ssid);
		if(!strcmp(scan_result->mac, g_spot_list_p[i]->mac) && 
			!strcmp(ssid_tmp, g_spot_list_p[i]->ssid)){
			scan_result->network_id = g_spot_list_p[i]->network_id;
			break;
		}
	}

//	wf_log("exit");
}

static scan_result_t* parse_scan_result (Var *var)
{
	char *ptr = NULL;
	char *ptr2 = NULL;
	char *ptr3 = NULL;
	char *ptr4 = NULL;
	char *ptr5 = NULL;
	scan_result_t *scan_result = NULL;
	int frequency = 0;
	int signal = 0;
	char flags[WIFI_STATION_FLAGS_LEN] = {0};

	if (var == NULL) {
		return NULL;
	}

	//ǷǿɺԵһ
	ptr = strstr (var->val.str.sval, WIFI_STATION_SCAN_RESULT_PARSE_IGNORE);
	if (ptr) {
		return NULL;
	} else {
		//ɨڴ
		scan_result = safe_malloc (sizeof (scan_result_t), FALSE);
		if (scan_result == NULL) {
			return NULL;
		}

		scan_result->network_id = -1;// ʼΪ-1 ûнбȵ
	

		//ƥɨϢ
		sscanf (var->val.str.sval, "%19[0-9,a-f,A-F,:]       %d    %d     %127s    %127[^\n]", scan_result->mac, &frequency, &signal, flags, scan_result->ssid);

		if (strncmp (scan_result->ssid, "\\x00", 4) == 0) {
			wf_log ("scan_result->mac=[%s] scan_result->ssid=[%s]is a hidden AP",
			        scan_result->mac, scan_result->ssid);
			safe_free (scan_result);
			return NULL;
		}


		//connectStatus ״̬
		update_scan_spot_connect_status(scan_result);

		update_scan_spot_network_id(scan_result);

		//signalźǿ
		if (signal > WIFI_STATION_SIGNAL_LEVEL4) {
			scan_result->signal = 4;
		} else if (signal > WIFI_STATION_SIGNAL_LEVEL3) {//kw 3
			scan_result->signal = 3;
		} else if (signal > WIFI_STATION_SIGNAL_LEVEL2) {
			scan_result->signal = 2;
		} else if (signal > WIFI_STATION_SIGNAL_LEVEL1) {
			scan_result->signal = 1;
		} else {
			scan_result->signal = 0;
		}

		//channel
		switch (frequency) {
		case WIFI_STATION_CHANNEL1:
			scan_result->channel = 1;
			break;
		case WIFI_STATION_CHANNEL2:
			scan_result->channel = 2;
			break;
		case WIFI_STATION_CHANNEL3:
			scan_result->channel = 3;
			break;
		case WIFI_STATION_CHANNEL4:
			scan_result->channel = 4;
			break;
		case WIFI_STATION_CHANNEL5:
			scan_result->channel = 5;
			break;
		case WIFI_STATION_CHANNEL6:
			scan_result->channel = 6;
			break;
		case WIFI_STATION_CHANNEL7:
			scan_result->channel = 7;
			break;
		case WIFI_STATION_CHANNEL8:
			scan_result->channel = 8;
			break;
		case WIFI_STATION_CHANNEL9:
			scan_result->channel = 9;
			break;
		case WIFI_STATION_CHANNEL10:
			scan_result->channel = 10;
			break;
		case WIFI_STATION_CHANNEL11:
			scan_result->channel = 11;
			break;
		case WIFI_STATION_CHANNEL12:
			scan_result->channel = 12;
			break;
		case WIFI_STATION_CHANNEL13:
			scan_result->channel = 13;
			break;
		default:
			scan_result->channel = 0;
			break;
		}

		//authModeȨģʽ
		ptr = NULL;
		ptr2 = NULL;
		ptr3 = NULL;
		ptr = strstr (flags, WIFI_STATION_AUTH_WPA_PSK);
		ptr2 = strstr (flags, WIFI_STATION_AUTH_WPA2_PSK);
		ptr3 = strstr (flags, WIFI_STATION_AUTH_SHARED);
		ptr4 = strstr (flags, WIFI_STATION_AUTH_WPA_EAP);
		ptr5 = strstr (flags, WIFI_STATION_AUTH_WPA2_EAP);
		if (ptr && ptr2) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPAPSKWPA2PSK");
		} else if (ptr) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPAPSK");
		} else if (ptr2) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPA2PSK");
		} else if (ptr3) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "SHARED");
		} else if (ptr4 && ptr5) {

			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "802.1X");
			//TODO  scan_result->from_provider = 1;//fromProvider ǷӪ
		} else if (ptr4) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "802.1X");

			//TODO scan_result->from_provider = 1;//fromProvider ǷӪ
		} else if (ptr5) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "802.1X");

			//TODO scan_result->from_provider = 1;//fromProvider ǷӪ
		} else {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "OPEN");
		}

		//encryptType
		ptr = NULL;
		ptr2 = NULL;
		ptr3 = NULL;
		ptr = strstr (flags, WIFI_STATION_ENCRYPT_CCMP);
		ptr2 = strstr (flags, WIFI_STATION_ENCRYPT_TKIP);
		ptr3 = strstr (flags, WIFI_STATION_ENCRYPT_WEP);
		if (ptr && ptr2) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "TKIPCCMP");
		} else if (ptr) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "CCMP");
		} else if (ptr2) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "TKIP");
		} else if (ptr3) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "WEP");
		} else {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "NONE");
		}
	}

	return scan_result;

}

/*
	j : the num of scan results
	p_mas_data: msg_act_spot_t , ssid action info
*/
static void handle_scan_result_to_nv (int j, msg_act_spot_t *p_mas_data)
{
	int i = 0;

	char *scan_result_str = NULL;
	char *scan_result_str1 = NULL;
	int scan_result_str_len = 0;
	int scan_result_str_len1 = 0;

	scan_result_str = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, FALSE);
	scan_result_str1 = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, FALSE);

	if (scan_result_str == NULL || scan_result_str1 == NULL) {
		safe_free (scan_result_str);
		safe_free (scan_result_str1);
		return;
	}


	for (i = 0; i < j; i++) {
		save_scan_result (g_scan_result_list_p[i], scan_result_str, scan_result_str1);
	}

	scan_result_str_len = strlen (scan_result_str);
	scan_result_str_len1 = strlen (scan_result_str1);

	wf_log ("scan_result_str_len = %d scan_result_str_len1 = %d j = %d", scan_result_str_len, scan_result_str_len1, j);

	//ɨбNVд
	sc_cfg_set ("EX_APLIST", "");
	sc_cfg_set ("EX_APLIST1", "");

	if (scan_result_str_len > 0 && scan_result_str_len < WIFI_STATION_SCAN_RESULT_STR_LEN) {//kw
		scan_result_str[scan_result_str_len - 1] = '\0'; //ȥһֺ
		sc_cfg_set ("EX_APLIST", scan_result_str);
	}
	if (scan_result_str_len1 > 0 && scan_result_str_len1 < WIFI_STATION_SCAN_RESULT_STR_LEN) {
		scan_result_str1[scan_result_str_len1 - 1] = '\0'; //ȥһֺ
		sc_cfg_set ("EX_APLIST1", scan_result_str1);
	}

	safe_free (scan_result_str);
	safe_free (scan_result_str1);

	if(NULL!=p_mas_data)
		wf_msg_to_mmi(MSG_CMD_WIFI_STATION_INDICATE_SCAN_RESULTS, sizeof(msg_act_spot_t), p_mas_data);
	else
		wf_msg_to_mmi(MSG_CMD_WIFI_STATION_INDICATE_SCAN_RESULTS, 0, NULL);

	dump_spot();
	
}

static void handle_scan_result (vector_t* v)
{
	int i = 0;
	int j = 0;
	Var *var = NULL;
	scan_result_t *scan_result = NULL;

	if (v == NULL) {
		return;
	}

	//ͷ֮ǰ洢ɨȵбڴ
	for (i = 0; i < WIFI_STATION_SCAN_RESULT_LIST_NUM; i++) {
		safe_free (g_scan_result_list_p[i]);
 	}

// ֻwebuiбŻȥȡбҪ
//    get_spot_list();
	//ȳʼȵбźΪ0
//	update_spot_list_signal_connect_status (0, -1);

	for (i = 0; i < vector_size (v); i++) {
		if (j >= WIFI_STATION_SCAN_RESULT_LIST_NUM) {
			break;
		}

		var = vector_get (v, i);
		if (var->type == IS_STRING) {
			scan_result = parse_scan_result (var); //   ɨб ȵmacַƥ
			if (scan_result != NULL) {
				g_scan_result_list_p[j] = scan_result;
				j++;
//				wf_log("[%d], ssid=%s", j, scan_result->ssid);
			}
		}
	}
	sort_scan_result_by_signal (g_scan_result_list_p, j);

	g_wlan_handle.scan_spot_num = j;

	handle_scan_result_to_nv(j,NULL);
}


/*
	add new  spot
	del spot forget spot
	connect spot
	disconnect spot
*/
void update_global_scan_result_list(spot_action_t action, spot_t *spot) 
{
	int i=0;
	char ssid_tmp[WIFI_STATION_SSID_LEN]={0};

	
	msg_act_spot_t  mas_data={0};
	mas_data.act = action;
	strcpy(mas_data.mac,spot->mac);
	
	mas_data.network_id = -1;
	while(g_scan_result_list_p[i]){

		string_reerect(g_scan_result_list_p[i]->ssid, ssid_tmp);
		if(!strcmp(g_scan_result_list_p[i]->mac, spot->mac) &&
			!strcmp(ssid_tmp, spot->ssid)){

			strcpy(mas_data.ssid,g_scan_result_list_p[i]->ssid);
			
			if(SAVE_ACTION == action){
				g_scan_result_list_p[i]->network_id = spot->network_id;
				mas_data.network_id  = spot->network_id;
			}
			else if(DEL_ACTION == action)
				g_scan_result_list_p[i]->network_id = -1;
			else if(CONNECTING_ACTION == action)
				g_scan_result_list_p[i]->connect_status = CONNECTING_STATUS;
			else if(DHCPING_ACTION == action)
				g_scan_result_list_p[i]->connect_status = DHCPING_STATUS;
			else if(CONNECTED_ACTION == action)
				g_scan_result_list_p[i]->connect_status = CONNECTED_STATUS;
			else if(DISCONNECT_ACTION == action)
				g_scan_result_list_p[i]->connect_status = DISCONNECT_STATUS;
			else
				wf_log("not used action"); //kw 3
			
			break;
		}
		i++;
		if(i == WIFI_STATION_SCAN_RESULT_LIST_NUM){
			wf_log("should not be here");
			break;
		}
	}

	

	wf_log("action = %d, ssid = %s", action, mas_data.ssid);
	handle_scan_result_to_nv(g_wlan_handle.scan_spot_num, &mas_data);

}

static  void  ipfail_disconnect_ap()
{
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int spot_num = g_wlan_handle.spots_num;

	g_wlan_handle.dhcp_retry_times++;

	if(g_wlan_handle.dhcp_retry_times >= DHCP_RETRY_TIMES){// ֱɾȵ㣬֪ͨmmiʧ

		int reason = WIFI_STATION_IP_FAIL;
		
		sprintf (cmd, "DISCONNECT");
		sta_docmd (cmd);

		sprintf (cmd, "REMOVE_NETWORK %d", g_wlan_handle.linked_id);
		sta_docmd (cmd);
		sta_docmd ("SAVE_CONFIG");
		del_spot (g_wlan_handle.linked_id);

		wf_msg_to_mmi (MSG_CMD_WIFI_STATION_CONNECT_FAIL, 
			4, &reason);
	}
	else{//
		sprintf (cmd, "DISCONNECT");
		sta_docmd (cmd);
		sprintf (cmd, "RECONNECT");
		sta_docmd (cmd);
	}

//	wifi_station_connect ();
// disable cmd will disconnect the ap , and  sta_disconnected will deal the process
	// i guess wpa_supplicant will  connect other enabled  spot

}


static void wpa_supplicant_get_scan_result (vector_t* v)
{
	char *reply = NULL;

	if (v == NULL) {
		return;
	}

	//ȡɨ
	wf_log ("wlan-station get_scan_result");
//    exec_script(WPA_CLI" scan_results", v);
	reply = sta_docmd ("SCAN_RESULTS");

//   wf_log("[scan] scan results:\n %s" , reply);
	convert2vector (reply, v);
}


static void wifi_station_get_scan_results (void)
{
	vector_t *v = NULL;
	v = vector_init();
	wf_log ("starting scan result");

	//ȡɨ
	wpa_supplicant_get_scan_result (v);

	//ɨ
	handle_scan_result (v);
	vector_free (v);
}


static void sta_enable_all_networks (void)
{
	if(1 == g_wlan_handle.disable_others && g_wlan_handle.spots_num > 0){
		sta_docmd ("ENABLE_NETWORK all");
		sta_docmd("SAVE_CONFIG");
		g_wlan_handle.disable_others = 0;
	}
}
static void supplicant_disconnected (void)
{
	if (CONNECTING_STATUS == g_wlan_handle.conn_status) // connecting ״̬᲻disconnect Ϣأɾȵ㣿
	{
		if(strlen(g_wlan_handle.linking_mac)>0){
			spot_t *spot = find_spot_by_mac(g_wlan_handle.linking_mac);
			if(NULL!=spot)
				update_global_scan_result_list(DISCONNECT_ACTION, spot);
			else
				wf_log("Error!, sc_data->mac=%s",g_wlan_handle.linking_mac);
			
		}
	}
	else if(DHCPING_STATUS == g_wlan_handle.conn_status ||
			CONNECTED_STATUS == g_wlan_handle.conn_status)
	{
		
		if(CONNECTED_STATUS == g_wlan_handle.conn_status)network_down_up (FALSE);
		g_wlan_handle.conn_status =DISCONNECT_STATUS;
		
		spot_t *spot = find_spot_by_id(g_wlan_handle.linked_id);
		if(NULL!=spot)
			update_global_scan_result_list(DISCONNECT_ACTION, spot);
		else
			wf_log("Error, g_wlan_handle.linked_id=%d",g_wlan_handle.linked_id);
	}

	g_wlan_handle.linked_id = -1;
	g_wlan_handle.list_id = -1;
	memset(g_wlan_handle.linking_mac, 0, WIFI_STATION_MAC_LEN);
	delete_scan_timer ();// бȵ㣬wpa_supplicantԶ15Sɨһ

}


static void sta_disconnected (sup_connected_t  *sc_data)
{
	char cmd[WIFI_STATION_CMD_LEN]={0};
	wf_log("g_wlan_handle.conn_status=%d",g_wlan_handle.conn_status);

	if (CONNECTING_STATUS == g_wlan_handle.conn_status) // connecting ״̬᲻disconnect Ϣأɾȵ㣿
	{
		spot_t *spot = find_spot_by_mac(sc_data->mac);
		if ( NULL != spot )
			update_global_scan_result_list(DISCONNECT_ACTION, spot);
		else {
			wf_log("Error!, sc_data->mac=%s",sc_data->mac);
			return;
		}

		if(g_wlan_handle.disc_type == DISCONNECT_MANUAL ){
			// ֶĻѾȵɾֻҪ״̬Ϳ
			sprintf (cmd, "REMOVE_NETWORK %d", spot->network_id);
			sta_docmd (cmd);
			sta_docmd ("SAVE_CONFIG");
			del_spot (spot->network_id);
		}
		else{
			//ԶĻwpa_supplicantٴԶӣconnecting״̬Ͽ˵֤ʧˣҲ

		}
		
	}
	else if(DHCPING_STATUS == g_wlan_handle.conn_status ||
			CONNECTED_STATUS == g_wlan_handle.conn_status)
	{
		
		if(CONNECTED_STATUS == g_wlan_handle.conn_status)network_down_up (FALSE);
		g_wlan_handle.conn_status =DISCONNECT_STATUS;
		
		spot_t *spot = find_spot_by_id(g_wlan_handle.linked_id);
		if(NULL!=spot)
			update_global_scan_result_list(DISCONNECT_ACTION, spot);
		else
			wf_log("Error, g_wlan_handle.linked_id=%d",g_wlan_handle.linked_id);
		
		if(g_wlan_handle.disc_type == DISCONNECT_MANUAL ){//ֶϿֱɾ
			// ֶĻѾȵɾҪϿ״̬MMI
			sprintf (cmd, "REMOVE_NETWORK %d", g_wlan_handle.linked_id);
			sta_docmd (cmd);
			sta_docmd ("SAVE_CONFIG");
			del_spot (g_wlan_handle.linked_id);
		
		}
		else{//ԶĻȵѾرգ߸Ҫȵ
//			sprintf(cmd,"DISABLE_NETWORK %d", sc_data->id);
//			wifi_station_connect();
		}
	}

	g_wlan_handle.linked_id = -1;
	g_wlan_handle.list_id = -1;
	memset(g_wlan_handle.linking_mac, 0, WIFI_STATION_MAC_LEN);
	g_wlan_handle.conn_status = DISCONNECT_STATUS;

	if( 0 == g_wlan_handle.spots_num)
		create_scan_timer ();//Ѿûбȵˣʱ1ɨһ
	else
		delete_scan_timer ();// бȵ㣬wpa_supplicantԶ15Sɨһ

		
}

static void sta_disconnect (int network_id)
{
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	g_wlan_handle.disc_type = DISCONNECT_MANUAL;

	if (network_id != -1) {
		sprintf (cmd, "DISCONNECT");
		sta_docmd (cmd);

	} else {
		wf_log ("All SSID AP already  disconnect, do not disconnect again");
	}
}

static void sta_connect (int network_id)
{
	int i = 0;
	char cmd[WIFI_STATION_CMD_LEN] = {0};


	if (network_id == -1) {
		wf_log ("got the wrong network id");

		//wf_msg_to_mmi();
		return;
	} else {
		if(WLAN_SM_STATE_CONNECTED == wf_sm_state() ||
			WLAN_SM_STATE_CONNECTING == wf_sm_state() ||
			WLAN_SM_STATE_DHCPING == wf_sm_state())
		{
			sprintf (cmd, "SELECT_NETWORK %d", network_id);
			sta_docmd (cmd);
			g_wlan_handle.disable_others = 1;
		}else{//disconnect
			sprintf (cmd, "ENABLE_NETWORK %d", network_id);
			sta_docmd (cmd);
		}
		sta_docmd ("SAVE_CONFIG");
		sta_docmd ("RECONNECT");
		g_wlan_handle.conn_type = CONNECT_MANUAL;

	}

}

static void do_dhcp (void)
{
	//ӳɹӿڽDHCP̷IPַ
	wf_log ("enter");
	network_down_up (TRUE);
}

/*

Ͽʱ򣬸ȵ״̬g_linked_network_id Ǽ¼ӵȵ

sta_ip_status ¼״̬connect ״̬
*/
static int  find_linked_ap_index(void)
{

	int i = 0;

	if (-1 == g_wlan_handle.linked_id)  return -1;

	for (i = 0; i < g_wlan_handle.spots_num; i++) {
		if (g_spot_list_p[i]->network_id == g_wlan_handle.linked_id) {
			wf_log ("find_linked_ap_index = %d", i); //  һ 0Ӫȵʱܲ0
			return i;
		}
	}

	return  -1;

}



static void disable_other_network (int  network_id)
{

	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int spot_num = g_wlan_handle.spots_num;
	int i = 0;

	if(0 == g_wlan_handle.disable_others){
		for (i = 0; i < spot_num; i++) {
			if (g_spot_list_p[i]->network_id == network_id) {
				continue;
			}

			sprintf (cmd, "DISABLE_NETWORK %d", g_spot_list_p[i]->network_id);
			sta_docmd (cmd);
		}
		sta_docmd ("SAVE_CONFIG");

		g_wlan_handle.disable_others =  1;
	}

}

static void sta_connected(sup_connected_t  *sc_data)
{

	if( NULL != sc_data){//just wifi connnect ap
		g_wlan_handle.linked_id = sc_data->id;
		g_wlan_handle.list_id  = find_linked_ap_index();
		g_wlan_handle.conn_status = DHCPING_STATUS;

		create_scan_timer ();
	}
	else{
		g_wlan_handle.conn_status = CONNECTED_STATUS;
		spot_t *spot = find_spot_by_id(g_wlan_handle.linked_id);
		if(NULL!=spot)update_global_scan_result_list(CONNECTED_ACTION, spot);
		else wf_log("error, not found the connect ap by id");

		disable_other_network (g_wlan_handle.linked_id);
	}
}


/*
  * just enable all networks let supplicant to connect automaticly
  */
static int wifi_station_connect (void)
{
	sta_enable_all_networks();
	g_wlan_handle.conn_type = CONNECT_AUTO;
	return 0;
}

static void wifi_station_nv_init (void)
{
	g_wlan_handle.list_id = -1;
	g_wlan_handle.linked_id = -1;
	g_wlan_handle.conn_status = DISCONNECT_STATUS;
	g_wlan_handle.disc_type = DISCONNECT_AUTO;
	g_wlan_handle.conn_type = CONNECT_AUTO;
	g_wlan_handle.spots_num = 0;
	g_wlan_handle.dhcp_retry_times = 0;
	g_wlan_handle.conn_retry_times = 0;
	g_wlan_handle.disable_others = 1;
	g_wlan_handle.softtimer = 0;
	load_spots_form_conf();
}

int wlan_station_init (void)
{
	int ret = -1;

	if(1 == g_wpa_supplicant)return 0;

	wf_log ("time=%d", time(NULL));
	if (sta_manager->start_supplicant(sta_manager) == 0) {
		wf_log ("time=%d", time(NULL));
		wf_log (" wpa_supplicant run success");
		
		if (0 == wifi_connect_to_supplicant(&sta_manager->sock)) {
			wf_log (" socket connect success");
			sem_post (&g_wpa_supplicant_id);
			g_wpa_supplicant = 1;		
			ret = 0;
		} else {
			wf_log (" socket connect or attach failed.");
		}
	} else {
		wf_log ("wpa_supplicant start failed");
		//wifi_stop_supplicant(sta_manager);
	}

	return ret;

}


static void clear_conf_file(void)
{
	sta_docmd ("REMOVE_NETWORK all");
	sta_docmd ("SAVE_CONFIG");
}

static void clear_spot_list(void)
{
	int i = 0;
	wf_log ("[clear_spot_list]");

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (g_spot_list_p[i] != NULL) {
			safe_free (g_spot_list_p[i]);
		}

	}

}

static void wlan_station_env_deinit(void)
{
	
	sta_manager->close_connection(sta_manager);
	clear_spot_list();
	sc_cfg_set ("EX_APLIST", "");
	sc_cfg_set ("EX_APLIST1", "");
	sc_timer_delete (WIFI_STATION_TIMER_SCAN);
	g_wpa_supplicant = 0;
}


static void wlan_station_deinit(void)
{
	sta_docmd ("DISABLE_NETWORK all");
	sta_docmd ("SAVE_CONFIG");
	sta_docmd ("TERMINATE");
}


void wifi_station_close()
{
//	sta_disconnected();
	wlan_station_deinit();
}

void indicate_mmi_fail_reason(tmp_disabled_t *td_data)
{
	if(CONNECT_MANUAL == g_wlan_handle.conn_type)
	{
		if(1 == td_data->wrong_key){
			int reason = WIFI_STATION_WRONG_KEY;
			wf_msg_to_mmi (MSG_CMD_WIFI_STATION_CONNECT_FAIL, 
			4, (unsigned char*)&reason);
		}
		else{
			int reason = WIFI_STATION_OTHER;
			wf_msg_to_mmi (MSG_CMD_WIFI_STATION_CONNECT_FAIL, 
			4, (unsigned char*)&reason);
		}
	}

}

void handle_terminate()
{
	supplicant_evt_t sup={0};
	supplicant_disconnected();
	wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CLOSING);
	sup.evt=WLAN_SM_EVT_TERMINATING;
	wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);
	wf_msg_to_self (MSG_CMD_WIFI_STATION_OPEN, 0, NULL);
}

void closed_sm_handler(wlan_sm_event_t evt, void *data)
{
	wf_log ("enter");

	switch (evt){
		case 		WLAN_SM_CMD_OPEN:
			if(0 == wlan_station_init()){
				
				wifi_station_nv_init();
				sta_docmd ("SCAN_INTERVAL 15");
				if(0 == g_wlan_handle.spots_num ){
					sta_docmd ("SCAN");
					create_scan_timer ();
				}else{
					wifi_station_connect ();
				}
				sc_cfg_set(NV_WIFI_ENABLED,"1");
				sc_cfg_save();
				wf_msg_to_mmi (MSG_CMD_WIFI_STATION_OPEN_SUCCESS, 0, NULL);
				wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_DISCONNECT);
			}
			else{
				wf_msg_to_mmi (MSG_CMD_WIFI_STATION_OPEN_FAIL, 0, NULL);
			}
			break;
		case 		WLAN_SM_CMD_CLOSE:
		case 		WLAN_SM_CMD_SCAN:
			break;
		case 		WLAN_SM_EVT_SCAN_RESULTS:
		case 		WLAN_SM_EVT_SCAN_FAILED:
		case 		WLAN_SM_EVT_STATE_CHANGE:
		case 		WLAN_SM_EVT_BSS_ADDED:
		case 		WLAN_SM_EVT_BSS_REMOVED:
		case 		WLAN_SM_EVT_NETWORK_NOT_FOUND:
		case 		WLAN_SM_EVT_SIGNAL_CHANGE:
		case 		WLAN_SM_EVT_CHANNEL_SWITCH:
		case 		WLAN_SM_EVT_SSID_TEMP_DISABLED:
		case 		WLAN_SM_EVT_SSID_REENABLED:
		case 		WLAN_SM_EVT_CONNECTED:
		case 		WLAN_SM_EVT_DISCONNECTED:
		case 		WLAN_SM_EVT_ASSOC_REJECT:
		case 		WLAN_SM_EVT_AUTH_REJECT:
		case 		WLAN_SM_EVT_TERMINATING:
			break;

		case 		WLAN_SM_ENTER_EVT:
		case		WLAN_SM_EXIT_EVT:
		default:
			break;

	}
}


void closing_sm_handler(wlan_sm_event_t evt, void *data)
{
	wf_log ("enter");

	switch (evt){
		case 		WLAN_SM_CMD_OPEN:
			break;
		case 		WLAN_SM_CMD_CLOSE:
			break;
		case 		WLAN_SM_EVT_DISCONNECTED:
			if(CONNECTED_STATUS == g_wlan_handle.conn_status)
				network_down_up (FALSE);
			break;
		case 		WLAN_SM_EVT_TERMINATING:
			wlan_station_env_deinit();
			sc_cfg_set(NV_WIFI_ENABLED,"0");
			sc_cfg_save();
			wf_msg_to_mmi (MSG_CMD_WIFI_STATION_CLOSE_SUCCESS, 0, NULL);
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CLOSED);
			break;

		case 		WLAN_SM_ENTER_EVT:
		case		WLAN_SM_EXIT_EVT:
		default:
			break;

	}
}


void disconnect_sm_handler(wlan_sm_event_t evt, void *data)
{
	wf_log ("enter");

	switch (evt){
		case 	WLAN_SM_CMD_CLOSE:
			wlan_station_deinit();
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CLOSING);
			break;
		case 	WLAN_SM_CMD_SCAN:
			wpa_supplicant_scan();
			break;
		case	WLAN_SM_CMD_CONNECT:
			mmi_connect_spot((spot_t*) data);
			break;
		case	WLAN_SM_EVT_SCAN_RESULTS:
			wifi_station_get_scan_results();
			break;
		
		case	WLAN_SM_EVT_ASSOC_REJECT:
		case	WLAN_SM_EVT_AUTH_REJECT:
		case	WLAN_SM_EVT_NETWORK_NOT_FOUND:
			break;
		case	WLAN_SM_EVT_CONNECTING:
		{
			g_wlan_handle.disc_type = DISCONNECT_AUTO;
			g_wlan_handle.conn_status = CONNECTING_STATUS;
			delete_scan_timer ();// ʼӺɾʱɨtimer
			try_assoc_t  *ta_data = (try_assoc_t  *)data;
			strncpy(g_wlan_handle.linking_mac,ta_data->mac,WIFI_STATION_MAC_LEN-1);
			spot_t *spot = find_spot_by_mac(ta_data->mac);
			if(NULL!=spot)update_global_scan_result_list(CONNECTING_ACTION, spot);
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CONNECTING);
			break;
		}
		case	WLAN_SM_EVT_SSID_TEMP_DISABLED://disconnect Ϣ֮ǰִ
		{
			tmp_disabled_t *td_data = (tmp_disabled_t *)data;
			char cmd[WIFI_STATION_CMD_LEN] = {0};
			if(1 == td_data->wrong_key|| td_data->auth_failed >=3 )
			{
				sprintf (cmd, "REMOVE_NETWORK %d", td_data->id);
				sta_docmd (cmd);
				sta_docmd ("SAVE_CONFIG");
				del_spot (td_data->id);
				indicate_mmi_fail_reason(td_data);
			}
			//ԶϿҪ鿴Ƿȵӣenable
			else if(g_wlan_handle.disc_type == DISCONNECT_AUTO)
				wifi_station_connect();
/*
			if(3 == td_data->auth_failed){
				wifi_station_connect();
				sprintf(cmd, "DISABLE NETWORK %d", td_data->id);
				sta_docmd(cmd);
				sta_docmd("SAVE_CONFIG");

			}
*/
			break;
		}
		case 		WLAN_SM_EVT_TERMINATING:
			handle_terminate();
			break;

		default:
			break;

	}
}
void connecting_sm_handler(wlan_sm_event_t evt, void *data)
{
	wf_log ("enter");

	switch (evt){
		case 	WLAN_SM_CMD_CLOSE:
			wlan_station_deinit();
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CLOSING);
			break;
		case 	WLAN_SM_CMD_SCAN:
			wpa_supplicant_scan();
			break;
		case	WLAN_SM_CMD_CONNECT:
			mmi_connect_spot((spot_t*) data);
			break;
		case	WLAN_SM_CMD_DISCONNECT:
		{
			spot_t *disc = (spot_t*)data;
			sta_disconnect(disc->network_id);
			break;
		}
		case	WLAN_SM_EVT_CONNECTED:
		{
			sup_connected_t  *sc_data = (sup_connected_t *)data;
			wf_log("linked id = %d", sc_data->id);
			sta_connected(sc_data);
			do_dhcp();
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_DHCPING);
			break;
		}
		case		WLAN_SM_EVT_SCAN_RESULTS:
//			wifi_station_get_scan_results();
			break;
		case	WLAN_SM_EVT_NETWORK_NOT_FOUND:
			g_wlan_handle.conn_status = DISCONNECT_STATUS;
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_DISCONNECT);
			break;

		case	WLAN_SM_EVT_SSID_TEMP_DISABLED:
		{
			tmp_disabled_t *td_data = (tmp_disabled_t *)data;
			char cmd[WIFI_STATION_CMD_LEN] = {0};
			if(1 == td_data->wrong_key|| td_data->auth_failed >= 3)
			{
				sprintf (cmd, "REMOVE_NETWORK %d", td_data->id);
				sta_docmd (cmd);
				sta_docmd ("SAVE_CONFIG");
				del_spot (td_data->id);
				indicate_mmi_fail_reason(td_data);
			}
			else if(g_wlan_handle.disc_type == DISCONNECT_AUTO)
				wifi_station_connect();
			
			g_wlan_handle.conn_status = DISCONNECT_STATUS;
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_DISCONNECT);
			break;
		}
		case	WLAN_SM_EVT_DISCONNECTED:
		{
			sup_connected_t *sc_data = (sup_connected_t*)data;
			sta_disconnected(sc_data);
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_DISCONNECT);
			break;
		}
		case		WLAN_SM_EVT_TERMINATING:
			handle_terminate();
			break;

		case		WLAN_SM_ENTER_EVT:
		case		WLAN_SM_EXIT_EVT:

		default:
			break;

	}
}

void dhcping_sm_handler(wlan_sm_event_t evt, void *data)
{
	wf_log ("enter");

	switch (evt){
		case 	WLAN_SM_CMD_CLOSE:
			wlan_station_deinit();
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CLOSING);
			break;		
		case 	WLAN_SM_CMD_SCAN:
			wpa_supplicant_scan();
			break;
		case	WLAN_SM_CMD_CONNECT:
			mmi_connect_spot((spot_t*) data);
			break;
		case	WLAN_SM_CMD_DISCONNECT:
		{
			spot_t *disc = (spot_t*)data;
			sta_disconnect(disc->network_id);
			break;
		}
		case	WLAN_SM_EVT_IP_CONNECTED:
		{
			sta_connected(NULL);
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CONNECTED);
			break;
		}
		case	WLAN_SM_EVT_DHCP_FAIL:
		{
			ipfail_disconnect_ap();
			break;
		}
		case		WLAN_SM_EVT_SCAN_RESULTS:
			wifi_station_get_scan_results();
			break;
		case	WLAN_SM_EVT_DISCONNECTED:// disconnect ,but dhcp ok then what?
		{
			sup_connected_t  *sc_data = (sup_connected_t *)data;
			
			sta_disconnected(sc_data);
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_DISCONNECT);
			break;
		}
		case	WLAN_SM_EVT_TERMINATING:
			handle_terminate();
			break;

		case		WLAN_SM_ENTER_EVT:
		case		WLAN_SM_EXIT_EVT:
		default:
			break;

	}
}

void connected_sm_handler(wlan_sm_event_t evt, void *data)
{
	wf_log ("enter");

	switch (evt){
		case 	WLAN_SM_CMD_CLOSE:
			wlan_station_deinit();
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_CLOSING);
			break;		
		case 	WLAN_SM_CMD_SCAN:
			wpa_supplicant_scan();
			break;
		case	WLAN_SM_CMD_CONNECT:
			mmi_connect_spot((spot_t*) data);
			break;
		case	WLAN_SM_CMD_DISCONNECT:
		{
			spot_t *disc = (spot_t*)data;
			sta_disconnect(disc->network_id);
			break;
		}
		case	WLAN_SM_EVT_SCAN_RESULTS:
			wifi_station_get_scan_results();
			break;
		case	WLAN_SM_EVT_DISCONNECTED:
		{
			sup_connected_t *sc_data = (sup_connected_t*)data;
			sta_disconnected(sc_data);
			wlan_sm_change_state(g_wlan_handle.sm_handle, WLAN_SM_STATE_DISCONNECT);
			break;
		}
		case	WLAN_SM_EVT_TERMINATING:
			handle_terminate();
			break;

		case		WLAN_SM_ENTER_EVT:
			break;
		case		WLAN_SM_EXIT_EVT:

		default:
			break;

	}
}

sta_sm_handler_t  wlan_sta_sm_handlers[]={
	closed_sm_handler,
	disconnect_sm_handler,
	connecting_sm_handler,
	dhcping_sm_handler,
	connected_sm_handler,
	closing_sm_handler,
};


int  get_int_from_event (char * buf,  char * tag)
{
	int  ret = -1;
	char * pstr = NULL;

	if(NULL == buf || NULL == tag)
		return -1;

	pstr = strstr (buf, tag);
	if (pstr != NULL)  {
		pstr += strlen (tag);
		ret = atoi (pstr);
	}

	return  ret;
}

void *station_loop (void *param)
{
	char buf[UEVENT_BUFFER_SIZE];
	char name[32] = {0};
	int  loop_run = 0;

	strncpy (name, (char*) param, sizeof(name)-1);//kw
	prctl (PR_SET_NAME, name, 0, 0, 0);

	while (1) {    //charging״̬Ĳ

		if (g_wpa_supplicant == 0 || 0 == loop_run) {
			sem_wait (&g_wpa_supplicant_id);
		}
		loop_run = 1;
	
		// ¼οwpa_supplantwpa_ctrl.hж
		int nread = wifi_wait_for_event (&sta_manager->sock, buf, sizeof (buf));

		//wake_sta_lock();
		if (nread > 0) {
			wf_log ("STA: %s", buf);

			supplicant_evt_t sup={0};
			if (strstr (buf, "CTRL-EVENT-SCAN-RESULTS")) {
				sup.evt = WLAN_SM_EVT_SCAN_RESULTS;
				
				wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);
			}
			else if (strstr (buf, "CTRL-EVENT-NETWORK-NOT-FOUND")) {
				sup.evt = WLAN_SM_EVT_NETWORK_NOT_FOUND;
				
				wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);
			}
			//STA: CTRL-EVENT-CONNECTED - Connection to a6:44:d1:86:c5:d9 completed [id=0 id_str=]
			else if (strstr (buf, "CTRL-EVENT-CONNECTED")) {
				sup_connected_t  sc_data = {0};

				char *p = strstr (buf, "Connection to ");
				if (p != NULL){
					p += strlen ("Connection to ");
					strncpy (sc_data.mac, p, 17);
				}
				sc_data.id = get_int_from_event (buf, "[id=");
				
				sup.evt = WLAN_SM_EVT_CONNECTED;
				memcpy(sup.data, &sc_data, sizeof(sup_connected_t));
				
				wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);
				
			} else if (strstr (buf, "CTRL-EVENT-DISCONNECTED")) {
//CTRL-EVENT-DISCONNECTED bssid=00:90:49:58:00:73 reason=3 locally_generated=1	
				sup_connected_t  sc_data = {0};
				char *p = strstr (buf, "bssid=");
				if (p != NULL) {
					p += strlen ("bssid=");
					strncpy (sc_data.mac, p, 17);
				}
				sup.evt = WLAN_SM_EVT_DISCONNECTED;
				memcpy(sup.data, &sc_data, sizeof(sup_connected_t));
				wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);
			}
			//STA: CTRL-EVENT-SSID-REENABLED id=0 ssid="ZONG MBB-MF920W+-000012"
			else if (strstr (buf, "CTRL-EVENT-SSID-REENABLED")) {
			//	sup.evt = WLAN_SM_EVT_CONNECTING;
			}
			//STA: Trying to associate with 00:90:49:58:00:73 (SSID='Wo4G-0073' freq=2412 MHz)
			else if (strstr (buf, "Trying to associate with")) {
				try_assoc_t  ta_data=  {0};
				char * start = NULL;
				char * end = NULL;
				int len = 0;
				
				start = strstr (buf, "SSID=\'") + strlen("SSID=\'");
				end = strstr (buf, "\' ");
				
				strncpy (ta_data.mac, buf + strlen ("Trying to associate with "), 17);
				wf_log ("Trying to associate with  mac=%s", ta_data.mac);
				if (end != NULL && start != NULL) {
					len = end - start;
					len = MIN(len, WIFI_STATION_SSID_LEN-1);
					//strncpy (ta_data.ssid, start, len);
					snprintf(ta_data.ssid,len+1,"%s",start);//kw
					wf_log ("Trying to associate with ssid= %s", ta_data.ssid);
				}else{
					strcpy (ta_data.ssid, "wrong ssid");
				}
				sup.evt = WLAN_SM_EVT_CONNECTING;
				memcpy(sup.data, &ta_data, sizeof(try_assoc_t));
				
				wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);
			} else if (strstr (buf , "CTRL-EVENT-SIGNAL-CHANGE")) {
				wf_log ("snd msg to update signal level");
			}
			// CTRL-EVENT-SSID-TEMP-DISABLED id=0 ssid="CPE_E3DE4E" auth_failures=2 duration=20 reason=WRONG_KEY AUTH_FAILEDCONN_FAILED
			else if (strstr (buf, "CTRL-EVENT-SSID-TEMP-DISABLED")) {
				tmp_disabled_t  td_data = {0};
				char *p_WRONG_KEY   = NULL;
				char *p_AUTH_FAILED = NULL;
				char *p_CONN_FAILED = NULL;

				p_WRONG_KEY =  strstr (buf, "WRONG_KEY");
				if(NULL!=p_WRONG_KEY) td_data.wrong_key =1;
				p_AUTH_FAILED =  strstr(buf, "AUTH_FAILED");
				if(NULL!=p_AUTH_FAILED) td_data.auth_failed =1;
				p_CONN_FAILED =  strstr(buf, "CONN_FAILED");
				if(NULL!=p_CONN_FAILED) td_data.conn_failed =1;
				
				td_data.auth_failures = get_int_from_event (buf, "auth_failures=");
				td_data.id = get_int_from_event (buf, "id=");
				wf_log ("network_id = %d  tmp_disabled_times = %d",  td_data.id, td_data.auth_failures);
				sup.evt=WLAN_SM_EVT_SSID_TEMP_DISABLED;

				memcpy(sup.data, &td_data, sizeof(tmp_disabled_t));
				wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);

			}
			else if (strstr (buf, "CTRL-EVENT-TERMINATING")) {
				sup.evt=WLAN_SM_EVT_TERMINATING;
				wf_msg_to_self (MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, sizeof(sup), &sup);
				loop_run = 0;
			}
			
		
		}
		else {
			wf_log ("Could not read pending message.");
		}
	}

	return NULL;
}




static const char* sm_state_to_string (void)
{
	int status = wlan_sm_get_state (g_wlan_handle.sm_handle);

	switch (status) {
		CASE_RETURN_STR (WLAN_SM_STATE_CLOSED);
		CASE_RETURN_STR (WLAN_SM_STATE_DISCONNECT);
		CASE_RETURN_STR (WLAN_SM_STATE_CONNECTING);
		CASE_RETURN_STR (WLAN_SM_STATE_DHCPING);
		CASE_RETURN_STR (WLAN_SM_STATE_CONNECTED);
		CASE_RETURN_STR (WLAN_SM_STATE_CLOSING);
	}
	return "err sm state";
}

static const char* evt_to_string (int status)
{
	switch (status) {
		CASE_RETURN_STR (WLAN_SM_CMD_OPEN);           /* 0*/
		CASE_RETURN_STR (WLAN_SM_CMD_CLOSE);              /*1*/
		CASE_RETURN_STR (WLAN_SM_CMD_CONNECT);       /* 2*/
		CASE_RETURN_STR (WLAN_SM_CMD_DISCONNECT);               //3
		CASE_RETURN_STR (WLAN_SM_CMD_SCAN);  //4
		CASE_RETURN_STR (WLAN_SM_EVT_SCAN_RESULTS);    			/*5*/
		CASE_RETURN_STR (WLAN_SM_EVT_SCAN_FAILED);         /*6*/
		CASE_RETURN_STR (WLAN_SM_EVT_STATE_CHANGE);             /*7*/
		CASE_RETURN_STR (WLAN_SM_EVT_ASSOCATING);  //8
		CASE_RETURN_STR (WLAN_SM_EVT_BSS_ADDED);  //9
		CASE_RETURN_STR (WLAN_SM_EVT_BSS_REMOVED);  //10
		CASE_RETURN_STR (WLAN_SM_EVT_NETWORK_NOT_FOUND);  //11
		CASE_RETURN_STR (WLAN_SM_EVT_SIGNAL_CHANGE);  //12
		CASE_RETURN_STR (WLAN_SM_EVT_CHANNEL_SWITCH);  //13
		CASE_RETURN_STR (WLAN_SM_EVT_SSID_TEMP_DISABLED);  //14
		CASE_RETURN_STR (WLAN_SM_EVT_SSID_REENABLED);  //15
		CASE_RETURN_STR (WLAN_SM_EVT_DHCP_FAIL);  //16
		CASE_RETURN_STR (WLAN_SM_EVT_CONNECTED);  //17
		CASE_RETURN_STR (WLAN_SM_EVT_DISCONNECTED);  //18
		CASE_RETURN_STR (WLAN_SM_EVT_CONNECTING);  //19
		CASE_RETURN_STR (WLAN_SM_EVT_IP_CONNECTED);  //20
		CASE_RETURN_STR (WLAN_SM_EVT_ASSOC_REJECT);  //21
		CASE_RETURN_STR (WLAN_SM_EVT_AUTH_REJECT);  //22
		CASE_RETURN_STR (WLAN_SM_EVT_TERMINATING);  //23
		CASE_RETURN_STR (WLAN_SM_ENTER_EVT);  //FFFE
		CASE_RETURN_STR (WLAN_SM_EXIT_EVT);  //FFFF

	}
	return "UNKNOWN  Module ID";
}


extern void dump_spot(void);

void dump_global_wlan_handle()
{
	printf("+++++++++++++>>>>>\n");
	printf("ssid_id=%d\n",g_wlan_handle.list_id);
	printf("linked_id=%d\n",g_wlan_handle.linked_id);
	printf("conn_status=%d\n",g_wlan_handle.conn_status);
	printf("conn_type=%d\n",g_wlan_handle.disc_type);
	printf("spots_num=%d\n",g_wlan_handle.spots_num);
	printf("+++++++++++++<<<<<\n");

	dump_spot();
	printf("+++++++++++++<<<<<\n");
}
void dispatch_msg(wlan_sm_event_t event,      void *data)
{
	wlan_sm_dispatch(g_wlan_handle.sm_handle, event, data);
}
int wlan_sta_parse_msg (MSG_BUF *pMsg)
{

	int ret = 0;

	wf_log ("wlan_sm current state=[%d][%s]", wlan_sm_get_state(g_wlan_handle.sm_handle), sm_state_to_string());

	void *data = (void*)pMsg->aucDataBuf;
	switch (pMsg->usMsgCmd) {
		case MSG_CMD_WIFI_STATION_OPEN: {
			dispatch_msg(WLAN_SM_CMD_OPEN, data);
	
			break;
		}
		case MSG_CMD_WIFI_STATION_CLOSE: {
			dispatch_msg(WLAN_SM_CMD_CLOSE, data);
			break;
		}
		case MSG_CMD_WIFI_STATION_CONNECT: {
			dispatch_msg(WLAN_SM_CMD_CONNECT, data);
			break;
		}
		case MSG_CMD_WIFI_STATION_DISCONNECT: {
			dispatch_msg(WLAN_SM_CMD_DISCONNECT, data);
			break;
		}
		case MSG_CMD_WIFI_STATION_FORGET: {
			dispatch_msg(WLAN_SM_CMD_DISCONNECT, data);
			break;
		}
		case MSG_CMD_BLC_OPEN_WIFISTATION_ACCESS: { //	you can connect
			dispatch_msg(WLAN_SM_CMD_CONNECT, data);
			break;
		}
		case MSG_CMD_BLC_CLOSE_WIFISTATION_ACCESS: {
			dispatch_msg(WLAN_SM_CMD_DISCONNECT, data);
			break;
		}
		case MSG_CMD_WIFI_STATION_BLC_CONNECTED: {
			dispatch_msg(WLAN_SM_EVT_IP_CONNECTED, data);
			break;
		}
		case MSG_CMD_NET_WAN_DIAL_FAIL: {
			wf_log ("wlan0-vxd dhcp ip failed");
			dispatch_msg(WLAN_SM_EVT_DHCP_FAIL, data);
			break;
		}
		case MSG_CMD_WIFI_STATION_SCAN: {
			dispatch_msg( WLAN_SM_CMD_SCAN, data);
			break;
		}
	
		case MSG_CMD_WIFI_STATION_SUPPLICANT_EVT: {
			supplicant_evt_t  *sup = (void*)pMsg->aucDataBuf;
			wf_log ("evt=[%d][%s]", sup->evt, evt_to_string(sup->evt));
			dispatch_msg(sup->evt, sup->data);
			break;
		}
		case MSG_CMD_WIFI_STATION_DEBUG_DUMP: {
			dump_global_wlan_handle();
			break;
		}
		case MSG_CMD_WIFI_STATION_WPA_CMD: {
			sta_docmd((const char*)pMsg->aucDataBuf);
			break;
		}
		default: {
			ret = -1;
			break;
		}
	}
	wf_log ("done time=%d",time(NULL));

	return ret;
}


void  wlan_statemachine_init()
{
	wf_status_t ret = WF_STATUS_SUCCESS;
	
	if(NULL == g_wlan_handle.sm_handle){
		g_wlan_handle.sm_handle = wlan_sm_init(wlan_sta_sm_handlers, WLAN_SM_STATE_CLOSED);

	}

}

void  wlan_station_open()
{
#if (PRODUCT_TYPE == PRODUCT_PHONE)
	int i = 0;
	while (i < 10) {
		int lTgtMsgID = 0;
		int errNo = 0;
		lTgtMsgID = msgget(MODULE_ID_MMI_SVR, 0);
		if (-1 == lTgtMsgID) {
			errNo = errno;
			wf_log ("cant get MODULE_ID_MMI_SVR, errNo:%d\n", errNo);
			sleep(2);
		} else {
			wf_log ("get MODULE_ID_MMI_SVR ok\n");
			break;
		}
		i++;
	}
#endif
	wf_msg_to_self(MSG_CMD_WIFI_STATION_OPEN, 0, NULL);

}
