/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_voip.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIʾƲ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
#include "mmi_common.h"
#include "mmi_lcd.h"

static SINT32 s_mmi_sms_tip_timer_status = 0;
static SINT32 s_mmi_sms_new_tip_num = 0;
static SINT32 sms_unread_number = 0;
static E_zMmi_Voip_Status s_mmi_voip_state = VOIP_STATUS_NOR;//voipĵǰ״̬
extern E_zMmiShowMode g_showMode;


/**********************************************************************************
*ҢԶcpe rj11
***********************************************************************************/
static E_zMmi_Rj11_Status s_mmi_rj11_state = RJ11_STATUS_NOR;//voipĵǰ״̬

SINT32 mmi_get_rj11info(UINT32 rj11info)
{
	if (rj11info != 0) {
		T_zMmi_Rj11_Info * pVoipInfo = (T_zMmi_Voip_Info *)rj11info;
		pVoipInfo->rj11_sta = s_mmi_rj11_state;
	}
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterRj11TaskInfoItem()
{
	T_zMMITaskInfoItem voipTaskInfoItem = {0};
	voipTaskInfoItem.task = MMI_TASK_RJ11;
	voipTaskInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMmi_Rj11_Info));
	voipTaskInfoItem.get_taskinfo_fun = mmi_get_rj11info;
	voipTaskInfoItem.get_ledinfo_fun = mmi_getLedRj11Info;
	voipTaskInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	//smsAppInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&voipTaskInfoItem);
	return MMI_SUCCESS;
}

static VOID mmi_set_rj11_update()
{
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode mode = mmi_get_led_mode();
		if (mode != MMI_IDLE_LEDOFF_MODE && mode != MMI_IDLE_CHG_LEDOFF_MODE
		    && mode != MMI_FAKE_POWEROFF_MODE && mode != MMI_FAKE_POWEROFF_CHARGE_MODE && mode != MMI_IDLE_STANDBY_LEDOFF_MODE) {
			mmi_set_update_flag(MMI_TASK_RJ11);
		}
	}
}

VOID mmi_get_rj11_status(VOID)
{
	char nv_voip_status[16] = {0};
	sc_cfg_get("cc_rj11_status", nv_voip_status, sizeof(nv_voip_status));
	if (!strcmp(nv_voip_status, VOIP_IN_CALL)) {
		s_mmi_rj11_state = RJ11_STATUS_IN;
	} else if (!strcmp(nv_voip_status, VOIP_HANG_UP)) {
		s_mmi_rj11_state = RJ11_STATUS_OUT;
	} else {
		s_mmi_rj11_state = RJ11_STATUS_NOR;
	}
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_get_rj11_status nv_status = %s s_mmi_rj11_state= %d !\n", nv_voip_status, s_mmi_rj11_state);
}

SINT32 zMMI_Handle_Msg_Rj11_Status(VOID * data)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Rj11_Status !\n");
	mmi_get_rj11_status();
	mmi_set_rj11_update();
	return 0;
}
//-------yaoyuan cpe end--------


/**********************************************************************************
*:ȡŵϢ
***********************************************************************************/
SINT32 mmi_get_voipinfo(UINT32 voipinfo)
{
	if (voipinfo != 0) {
		T_zMmi_Voip_Info * pVoipInfo = (T_zMmi_Voip_Info *)voipinfo;
		pVoipInfo->voip_sta = s_mmi_voip_state;
	}
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterVoipTaskInfoItem()
{
	T_zMMITaskInfoItem voipTaskInfoItem = {0};
	voipTaskInfoItem.task = MMI_TASK_VOIP;
	voipTaskInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMmi_Voip_Info));
	voipTaskInfoItem.get_taskinfo_fun = mmi_get_voipinfo;
	voipTaskInfoItem.get_ledinfo_fun = mmi_getLedVoipInfo;
	voipTaskInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	//smsAppInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&voipTaskInfoItem);
	return MMI_SUCCESS;
}

static VOID mmi_set_voip_update()
{
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode mode = mmi_get_led_mode();
		if (mode != MMI_IDLE_LEDOFF_MODE && mode != MMI_IDLE_CHG_LEDOFF_MODE
		    && mode != MMI_FAKE_POWEROFF_MODE && mode != MMI_FAKE_POWEROFF_CHARGE_MODE && mode != MMI_IDLE_STANDBY_LEDOFF_MODE) {
			mmi_set_update_flag(MMI_TASK_VOIP);
		}
	}
}

/************************************************************************************
:ȡVOIP״̬ӦNV
***********************************************************************************/
VOID mmi_get_voip_status(VOID)
{
	char nv_voip_status[16] = {0};
	sc_cfg_get(NV_VOIP_STATUS, nv_voip_status, sizeof(nv_voip_status));
	if (!strcmp(nv_voip_status, VOIP_IN_CALL)) {
		s_mmi_voip_state = VOIP_STATUS_IN_CALL;
	} else if (!strcmp(nv_voip_status, VOIP_IN_CONNECTION)) {
		s_mmi_voip_state = VOIP_STATUS_IN_CONNECTION;
	} else if (!strcmp(nv_voip_status, VOIP_HANG_UP)) {
		s_mmi_voip_state = VOIP_STATUS_HANG_UP;
	} else {
		s_mmi_voip_state = VOIP_STATUS_NOR;
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI zMMI_Handle_Msg_Voip_Status nv_voip_status = %s s_mmi_voip_state= %d !\n", nv_voip_status, s_mmi_voip_state);
}

/************************************************************************************
:VOIPʾ״̬仯ʱӦϢ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Voip_Status(VOID * data)
{
	slog(MMI_PRINT, SLOG_DEBUG, "MMI zMMI_Handle_Msg_Voip_Status !\n");
	mmi_get_voip_status();
	mmi_set_voip_update();
	return 0;
}

/************************************************************************************
:ʼVOIPʾ
***********************************************************************************/
VOID mmi_voip_init(VOID)
{
	mmi_get_voip_status();
	mmi_set_voip_update();
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_voip_init finish!!!\n");
}

