/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi.c
*  ļʶ  
*  ļ  
*  ʵֹ  
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
******************************************************************************/

/*****************************************************************************
 ͷļ
******************************************************************************/
#include <wdt_common.h>

/********************************************************************************
  ȫֱ
**********************************************************************************/


/********************************************************************************
  ȫֱ
**********************************************************************************/
int g_wdt_msgQue_Id = 0;

SINT32 g_hightempvol = 0;
SINT32 g_superhightempvol = 0;
SINT32 g_lowtempvol = 0;
SINT32 g_superlowtempvol = 0;
UINT32 g_watchdog_flag = 0;

/**********************************************************************************
:̵Ϣ
***********************************************************************************/
long wdt_create_msg_queue()
{
	int msgid = 0;
	if ((msgid = msgget(MODULE_ID_WDT, IPC_CREAT | 0600)) == -1) {
		slog(MMI_PRINT, SLOG_ERR, "WDT [error]:Create MODULE_ID_WDT queue faild! msgid=%d\n", msgid);
		return -1;
	}
	slog(MMI_PRINT, SLOG_DEBUG, "WDT Creating mmi message queue success! MODULE_ID_WDT=0x%x\n", msgid);
	return msgid;
}

int wdt_RecvMsgFromQueue(int msgQueueId, MSG_BUF *pstMsg, long MsgType)
{
	int iRet = -1;
	long msgSize =  sizeof(MSG_BUF) - sizeof(long);

	if (NULL == pstMsg) {
		return -1;
	}

	iRet = msgrcv(msgQueueId, pstMsg, msgSize, MsgType, MSG_NOERROR);
	slog(MMI_PRINT, SLOG_ERR, "WDT wdt_RecvMsgFromQueue : iRet : %ld, pstMsg->src_id:%ld,  pstMsg->usMsgCmd:%ld \n", iRet, pstMsg->src_id, pstMsg->usMsgCmd);

	if (iRet <= 0) {
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt_RecvMsgFromQueue Failed : iRet : %ld, pstMsg->src_id:%ld,  pstMsg->usMsgCmd:%ld \n", iRet, pstMsg->src_id, pstMsg->usMsgCmd);
		return -1;
	} else {
		return 0;
	}
}

static int wdt_ProcMsg(MSG_BUF *pstMsg)
{
	int i = 0;
	if (NULL == pstMsg) {
		return -1;
	}
	if ((pstMsg->usMsgCmd != MSG_CMD_MMICHECK_TIP_INFO) && (pstMsg->usMsgCmd != MSG_CMD_MMIGET_WIFI_DATA)) {
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt_ProcMsg msg:src_id = 0x%04x,lMsgType = %d,usMsgCmd = 0x%08x,usDataLen = %d,data = %s\n", pstMsg->src_id, pstMsg->lMsgType, pstMsg->usMsgCmd, pstMsg->usDataLen, pstMsg->aucDataBuf);
	}
	switch (pstMsg->usMsgCmd) {
	case RTC_MSG_ALARM_ELAPSED:
		//¿غι
		slog(MMI_PRINT, SLOG_ERR, "WDT RTC_MSG_ALARM_ELAPSED\n");
		set_wake_lock(WDT_GET_POWER_LOCK_ID);
		wdt_feet();
		wdt_temp_check_process();
		wdt_rtc_add(WDT_INTERVAL_TIME);
		set_wake_unlock(WDT_GET_POWER_LOCK_ID);
		break;
	}
	return 0;
}


static void *wdt_handleMsgEntry(void *arg)
{
	long MsgType = 0;
	MSG_BUF Msg;
	prctl(PR_SET_NAME, "wdthandlemsg", 0, 0, 0);
	while (1) {
		memset((VOID *)(&Msg), 0, sizeof(MSG_BUF));//warning516
		if (-1 != wdt_RecvMsgFromQueue(g_wdt_msgQue_Id, &Msg, MsgType)) {
			wdt_ProcMsg(&Msg);
		}
	}
}

/**********************************************************************************
:MMIں  Ϣ Ƴʼ Ϣ
***********************************************************************************/
VOID wdt_creatMsgThread()
{
	//pthread_t handlemsg_thread;

	slog(MMI_PRINT, SLOG_ERR, "WDT start wdt_creatMsgThread\n");

	long MsgType = 0;
	MSG_BUF Msg;
	prctl(PR_SET_NAME, "zte_watchdog", 0, 0, 0);
	while (1) {
		memset((VOID *)(&Msg), 0, sizeof(MSG_BUF));
		if (-1 != wdt_RecvMsgFromQueue(g_wdt_msgQue_Id, &Msg, MsgType)) {
			wdt_ProcMsg(&Msg);
		}
	}

}

static VOID *wdt_creatTempCheckThread(VOID *arg)
{
	UINT32 voltagepower = 0;

	prctl(PR_SET_NAME, "zte_tempvheck", 0, 0, 0);

	while (1) {
		set_wake_lock(WDT_GET_POWER_LOCK_ID);
		wdt_temp_check_process();
		set_wake_unlock(WDT_GET_POWER_LOCK_ID);
		sleep(TEMPCHECK_INTERVAL_TIME);
	}
}

static int get_nv()
{
	char nv_value[NV_NAME_LEN] = {0};

	sc_cfg_get("mmi_temp_voltage_line", nv_value, sizeof(nv_value));
	slog(MMI_PRINT, SLOG_ERR, "mmi_temp_voltage_line = %s\n", nv_value);
	char *tmp = NULL;
	char *substr = strtok_r(nv_value, "+", &tmp);
	SINT32 temp[4] = {0};
	int i = 0;
	while (substr != NULL) {
		temp[i] = atoi(substr);
		i++;
		substr = strtok_r(NULL, "+", &tmp);
	}
	g_superhightempvol = temp[0];
	g_hightempvol = temp[1];
	g_lowtempvol = temp[2];
	g_superlowtempvol = temp[3];
	slog(MMI_PRINT, SLOG_ERR, "g_mmi_temp = %d %d %d %d %d\n", i, g_superhightempvol, g_hightempvol, g_lowtempvol, g_superlowtempvol);
	if(i != 4)
		softap_assert("");
	sc_cfg_get("mmi_use_protect", nv_value, sizeof(nv_value));

	if (strstr(nv_value, "discharge_protect")) {
		g_discharge_protect_wd = 1;
	}

	if (strstr(nv_value, "temp_protect")) {
		g_temp_protect_wd = 1;
		if (strstr(nv_value, "charge_protect")) {
			g_charge_protect_wd = 1;
		}
	}

	sc_cfg_get("watchdog_app", nv_value, sizeof(nv_value));
	slog(MMI_PRINT, SLOG_ERR, "WDT watchdog_app = %s\n", nv_value);

	if (strcmp(nv_value, "1") == 0) {
		g_watchdog_flag = 1;
	}

	return 0;
}

/**********************************************************************************
:MMIں  Ϣ Ƴʼ Ϣ
***********************************************************************************/
int zte_watchdog_main(int argc, char * argv[])
{
	pthread_t temp_check_thread;
	prctl(PR_SET_NAME, "mmi_watchdog", 0, 0, 0);
	//ʼӡ𣬲עᶯ̬ӡź
	loglevel_init();
	
	//zdmnvתȫֱйܿ
	slog(MMI_PRINT, SLOG_ERR, "WDT ######START######\n");

	if ((g_wdt_msgQue_Id = wdt_create_msg_queue()) == -1) {
		slog(MMI_PRINT, SLOG_ERR, "WDT create g_mmi_msgQue_Id failed!!!\n");
		assert(0);
	}

	get_nv();

	if (!g_watchdog_flag && !g_temp_protect_wd) {
		slog(MMI_PRINT, SLOG_ERR, "WDT ######END######\n");
		return -1;
	}
	if (g_watchdog_flag) {
		wdt_init();
		wdt_rtc_add(WDT_INTERVAL_TIME);
	} else {
		if (pthread_create(&temp_check_thread, NULL, &wdt_creatTempCheckThread, NULL) == -1) {
			slog(MMI_PRINT, SLOG_ERR, "WDT temp_check_thread creat error\n");
			return -1;
		}
	}

	wdt_creatMsgThread();
	return 0;
}

