/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : sms
*    : sms_main.c
* ļ :
* ʵֹ : SMSϢ̿ƴ
*      : ŷ
*      : V1.0
*  : 2017.2.9
* ˵ :
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include <errno.h>
#include <sys/msg.h>
#include <semaphore.h>
#include <limits.h>
#include <pthread.h>

#include "sms_code.h"
/**************************************************************************
* 
**************************************************************************/
//#define MODULE_ID_SMS_LOCAL 0x2001
/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID (*pAtWeb_SmsMsgProc)(UINT8 *pDatabuf); 

typedef struct
{
	UINT32 msg_id;
	VOID (*func_ptr)(UINT8 *pDatabuf);
	BOOL need_block;//ǷҪҪϢתڲ̴߳
}T_zSmsHandleTable;


/**************************************************************************
* static
**************************************************************************/

VOID atWeb_SendSms(UINT8 *pDatabuf);
VOID atWeb_DelSmsByIndex(UINT8 *pDatabuf);
VOID atWeb_DelSmsByType(UINT8 *pDatabuf);
VOID atWeb_ReadSms(UINT8 *pDatabuf);
VOID atWeb_SaveSms(UINT8 *pDatabuf);
VOID atWeb_SetSms(UINT8 *pDatabuf);
VOID atWeb_OutdateSmsCheck(UINT8 *pDatabuf);

int zSms_SendZmgrReq(int index);

/**************************************************************************
* ȫֱ
**************************************************************************/
extern UINT8 g_zUfiSms_MemFullFlag[ZTE_WMS_MEMORY_MAX];
extern T_zSms_SendSmsReq g_zUfiSms_FinalCmgsBuf;
extern int g_zUfiSms_CurConcatSegNo;
extern T_zUfiSms_DbStoreData g_zUfiSms_DbStoreData[ZTE_WMS_CONCAT_SMS_COUNT_MAX];
extern int g_zUfiSms_SendFailedCount;
extern int g_zUfiSms_ConcatTotalNum;
extern UINT8 g_zUfiSms_IsConcatSendSuc;

//cmgrм¼indexӦϢеĴ洢
int iSmsIndex = 0;
int  g_zSms_MsqId  = -1;
int  g_zSms_LocalMsqId  = -1;
sem_t   g_sms_sem_id;
T_zSms_optRsp g_smsOptRsp = {0};

	
static const T_zSmsHandleTable  SmsHandleWebTab[]  =
{
	{MSG_CMD_SEND_SMS, atWeb_SendSms, TRUE},          
    {MSG_CMD_DEL_SMS_BY_INDEX, atWeb_DelSmsByIndex, TRUE},   
    //{MSG_CMD_DEL_SMS_BY_TYPE, atWeb_DelSmsByType},     
    {MSG_CMD_SMS_MODIFY_TAG, atWeb_ReadSms, TRUE},     
    {MSG_CMD_DRAFTS_SAVE, atWeb_SaveSms, FALSE}, //corem         
    {MSG_CMD_SMS_LOCATION_SET, atWeb_SetSms, TRUE},
    {MSG_CMD_SMS_OUTDATE_CHECK, atWeb_OutdateSmsCheck, TRUE},
    {0, NULL, FALSE}
};


/**************************************************************************
* ʵ
**************************************************************************/

// pDatabufΪpstMsg->aucDataBuf
VOID atWeb_SendSms(UINT8 *pDatabuf)
{
    T_zGoaheadMsgBuf *ptMessage = NULL;
    T_zUfiSms_StatusInfo tStatus = {0};
    assert(pDatabuf != NULL);
    
    ptMessage = (T_zGoaheadMsgBuf *)pDatabuf;  
    
    zUfiSms_InitCmdStatus(&tStatus,WMS_SMS_CMD_MSG_SEND);

	
	//pthread_mutex_lock(&smsdb_mutex);
    (void)zUfiSms_SendRawSms((T_zUfiSms_SendReq *)ptMessage->msg_data);
	//pthread_mutex_unlock(&smsdb_mutex);
}

VOID atWeb_DelSmsByIndex(UINT8 *pDatabuf)
{
    T_zUfiSms_DelReq tDelReq = {0};
    T_zUfiSms_CmdStatus result = WMS_CMD_PROCESSING;
    T_zUfiSms_StatusInfo tStatus = {0};
    assert(pDatabuf != NULL);

    printf("[SMS] atWeb_DelSmsByIndex recv msg\n");
    memcpy(&tDelReq, pDatabuf,sizeof(T_zUfiSms_DelReq));
    
    zUfiSms_InitCmdStatus(&tStatus,WMS_SMS_CMD_MSG_DELETE);
    result = zUfiSms_DeleteSms(&tDelReq);

    tStatus.cmd_status = result;
    (void)zUfiSms_SetCmdStatus(&tStatus);
	zUfiMmi_SendSmsStatus();
}

VOID atWeb_DelSmsByType(UINT8 *pDatabuf)
{
    #if 0
    WEB_DEL_SMS_BY_TYPE *req = NULL;
    req = (WEB_DEL_SMS_BY_TYPE *)pDatabuf;
    assert(req != NULL); 
    if(req->eLocation != ZSMS_LOCATION_SIM)
    {
        ZTE_LOG(LOG_ERR, "zSms_PrepDelByType para NULL.\n");
        return;
    }
    zSms_ChangeMainState(ZSMS_STATE_DELING);
    ZTE_LOG(LOG_DEBUG, "zSms_PrepDelByType pstReq->eBoxName=%d\n",req->eBoxName);
    SMS_DeleteRecordFromXML(SMS_LOCATION_SIM, 0, req->eBoxName);
    if (req->eBoxName == SMS_INBOX)
    {
    sms_LoadSmsFromSim();
    }
    #endif
}
//״̬δΪѶ
VOID atWeb_ReadSms(UINT8 *pDatabuf)
{
    T_zGoaheadMsgBuf * ptMessage = NULL;
    T_zUfiSms_CmdStatus result = WMS_CMD_PROCESSING;
    T_zUfiSms_StatusInfo tStatus = {0};
    assert(pDatabuf != NULL);

    ptMessage = (T_zGoaheadMsgBuf *)pDatabuf; 
    
    zUfiSms_InitCmdStatus(&tStatus,WMS_SMS_CMD_MSG_MODIFY_TAG);
    result = zUfiSms_ModifySmsTag((T_zUfiSms_ModifyFlag *)ptMessage->msg_data);

    tStatus.cmd_status = result;
    (void)zUfiSms_SetCmdStatus(&tStatus);
}

VOID atWeb_SaveSms(UINT8 *pDatabuf)
{
    T_zGoaheadMsgBuf * ptMessage = NULL;
    T_zUfiSms_CmdStatus result = WMS_CMD_PROCESSING;
    T_zUfiSms_StatusInfo tStatus = {0};
    assert(pDatabuf != NULL);

    ptMessage = (T_zGoaheadMsgBuf *)pDatabuf; 
    
    zUfiSms_InitCmdStatus(&tStatus,WMS_SMS_CMD_MSG_WRITE);
    result = zUfiSms_WriteRawSms((T_zUfiSms_SaveReq *)ptMessage->msg_data);

    if(g_zUfiSms_MemFullFlag[ZTE_WMS_MEMORY_NV])
    {
        tStatus.err_code = ZTE_SMS_CMS_MEM_FULL;
        printf("[SMS] atWeb_SaveSms mem full\n");
    }
    tStatus.cmd_status = result;
    (void)zUfiSms_SetCmdStatus(&tStatus);

    //zSms_ChangeMainState(ZSMS_STATE_SAVING);
    zUfiSms_ChangeMainState(SMS_STATE_SAVING);  
    sc_cfg_set(NV_SMS_SAVE_RESULT, "ok");
    
}

VOID atWeb_SetSms(UINT8 *pDatabuf)
{
	T_zGoaheadMsgBuf * ptMessage = NULL;
    T_zUfiSms_CmdStatus result = WMS_CMD_PROCESSING;
    T_zUfiSms_StatusInfo tStatus = {0};      

	printf( "INTO atWeb_SetSms.\n");
	
    assert(pDatabuf != NULL);

    ptMessage = (T_zGoaheadMsgBuf *)pDatabuf;
	
    zUfiSms_InitCmdStatus(&tStatus,WMS_SMS_CMD_CFG_SET_PARAMETERS);
	result = zUfiSms_SetSmsPara((T_zUfiSms_ParaInfo *)ptMessage->msg_data);

	tStatus.cmd_status = result;
	(void)zUfiSms_SetCmdStatus(&tStatus);	
}

VOID atWeb_OutdateSmsCheck(UINT8 *pDatabuf)
{
    T_zUfiSms_DelReq tSmsDel = {0};

    zUfiSms_CheckDbOutdateSms(ZTE_WMS_DB_NV_TABLE, &tSmsDel);
    printf("----out coun nvt: %d----\n",tSmsDel.all_or_count);
    //for(i=0;i<tSmsDel.all_or_count;i++)printf("----out id: %d----\n",tSmsDel.id[i]);
	
    if(tSmsDel.all_or_count > 0)
    {
        atWeb_DelSmsByIndex(&tSmsDel);
    }
	
    memset(&tSmsDel, 0, sizeof(T_zUfiSms_DelReq));
    zUfiSms_CheckDbOutdateSms(ZTE_WMS_DB_SIM_TABLE, &tSmsDel);
    printf("----out count sim: %d----\n",tSmsDel.all_or_count);
    //for(i=0;i<tSmsDel.all_or_count;i++)printf("----out id: %d----\n",tSmsDel.id[i]);
	
    if(tSmsDel.all_or_count > 0)
    {
        atWeb_DelSmsByIndex(&tSmsDel);
    }
}

VOID zSms_HandleWebMsg(MSG_BUF *ptMsgBuf)
{
	UINT32 i = 0;
	assert(ptMsgBuf != NULL);

	printf("sms recv msg from webserver:%d\n", ptMsgBuf->usMsgCmd);
    while(0 != SmsHandleWebTab[i].msg_id)
    {
        if(ptMsgBuf->usMsgCmd == SmsHandleWebTab[i].msg_id)
        {
        	if(SmsHandleWebTab[i].need_block && ptMsgBuf->src_id != MODULE_ID_SMS)
        	{
				ipc_send_message(MODULE_ID_SMS, MODULE_ID_SMS_LOCAL, ptMsgBuf->usMsgCmd, ptMsgBuf->usDataLen, (unsigned char *)ptMsgBuf->aucDataBuf, 0);
			}        	
            else if(NULL != SmsHandleWebTab[i].func_ptr)
            {
                SmsHandleWebTab[i].func_ptr(ptMsgBuf->aucDataBuf);                
            }
            break;
        }
        i++;
    }	
}


//
SINT32 zSms_SendMsg(USHORT Msg_cmd,USHORT us_DataLen,UCHAR *pData)
{
	printf( "sms send msg cmd:%d\n", Msg_cmd);
    ipc_send_message(MODULE_ID_SMS, MODULE_ID_AT_CTL, Msg_cmd, us_DataLen, (unsigned char *)pData,0);
   
    return 0;    
}


/*ӦatSms_SendCmgsReq*/
SINT32 zSms_SendCmgsReq(VOID)
{
 	T_zSms_SendSmsReq  sendSmsInfo = {0};
 
 	memset(&sendSmsInfo, 0x00, sizeof(T_zSms_SendSmsReq));
 	sendSmsInfo.length = g_zUfiSms_FinalCmgsBuf.length;

	if(strlen(g_zUfiSms_FinalCmgsBuf.pdu)< ZSMS_PDU_SIZE-1)
    {
        memcpy(sendSmsInfo.pdu, g_zUfiSms_FinalCmgsBuf.pdu, strlen(g_zUfiSms_FinalCmgsBuf.pdu));
    }
    else
    {
        printf("[SMS] atSms_SendCmgsReq pdu too long:%s\n",g_zUfiSms_FinalCmgsBuf.pdu);
        memcpy(sendSmsInfo.pdu, g_zUfiSms_FinalCmgsBuf.pdu, ZSMS_PDU_SIZE-2);
    }
 	// ӽβ
	*(sendSmsInfo.pdu + strlen(g_zUfiSms_FinalCmgsBuf.pdu)) = ZSMS_CTRL_Z_CHAR;
#if 1//corem for debug
	printf("[SMS] atSms_SendCmgsReq send data\n");
    printf("\n[SMS]%s\n",sendSmsInfo.pdu);
#endif

	zSms_SendMsg(MSG_CMD_SENDSMS_REQ, sizeof(T_zSms_SendSmsReq), &sendSmsInfo);

	sem_wait(&g_sms_sem_id);

	if(g_smsOptRsp.result == 1)
	{
		return ZSMS_RESULT_OK;
	}
	else
	{
		return ZSMS_RESULT_ERROR;
	}
}

VOID zSms_RecvCmgsOk(VOID)
{
    printf("sms sended success. \n");	
    g_zUfiSms_CurConcatSegNo++;
    
    if(g_zUfiSms_CurConcatSegNo > ZTE_WMS_CONCAT_SMS_COUNT_MAX)
    {
        return;
    }
    
    //ͳɹһ
    g_zUfiSms_DbStoreData[g_zUfiSms_CurConcatSegNo-1].tag = WMS_TAG_TYPE_MO_SENT_V01;
    
	zUfiSms_CmgsRespProc();
}

VOID zSms_RecvCmgsErr(VOID)
{   
    printf("sms sended fail. \n");
    g_zUfiSms_CurConcatSegNo++;
    if(g_zUfiSms_CurConcatSegNo > ZTE_WMS_CONCAT_SMS_COUNT_MAX)
    {
        return;
    }
    
    //ʧдݿ
    g_zUfiSms_SendFailedCount++;
    
    printf("send sms failed,so write sms to draftbox.\n");
    g_zUfiSms_DbStoreData[g_zUfiSms_CurConcatSegNo-1].tag = WMS_TAG_TYPE_MO_NOT_SENT_V01;
    if(g_zUfiSms_ConcatTotalNum > 1)
    {
        // ŷʧܣΪfalse
        g_zUfiSms_IsConcatSendSuc = FALSE;
    }
    
	zUfiSms_CmgsRespProc();
}

/*ӦatSms_SendCmgdReq*/
SINT32 zSms_SendCmgdReq(UINT8 index)
{
	T_zSms_DelSmsReq  delSmsReq = {0};

	delSmsReq.index = index;
	
	zSms_SendMsg(MSG_CMD_DELSMS_REQ, sizeof(T_zSms_DelSmsReq), &delSmsReq);

	sem_wait(&g_sms_sem_id);

	if(g_smsOptRsp.result == 1)
	{
		return ZSMS_RESULT_OK;
	}
	else
	{
		return ZSMS_RESULT_ERROR;
	}
}

VOID zSms_RecvCmgdOk(VOID)
{
    CHAR  strUsed[10]    = {0};
    int used = 0;
	int tmp_i = 0;
    
    sc_cfg_set(NV_SMS_DEL_RESULT, "ok");
    printf("[SMS] set sim_del_result to OK. \n");
    
    sc_cfg_get(ZTE_WMS_NVCONFIG_SIM_CARD_USED,strUsed,sizeof(strUsed));

	tmp_i = atoi(strUsed); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) {
		at_print(LOG_ERR,"[SMS]WMS_NVCONFIG_SIM_CARD_USED tmp_i err:%d\n", tmp_i);
		tmp_i = 0;
	}

	used = tmp_i - 1;
    if(used < 0)
    {
        used = 0;
    }
    memset(&strUsed, 0, 10);
    snprintf(strUsed,sizeof(strUsed),"%d", used);
    sc_cfg_set(ZTE_WMS_NVCONFIG_SIM_CARD_USED, strUsed);
}

VOID zSms_RecvCmgdErr(VOID)
{
    
    sc_cfg_set(NV_SMS_DEL_RESULT, "fail");
    printf("[SMS] set sim_del_result to fail. \n");
}

VOID zSms_RecvCmgdFinish(VOID)
{
    char StrValue[10] = {0};
    CHAR  strTotal[10]    = {0};
    CHAR  strUsed[10]    = {0};
    int total = 0;
    int used = 0;
    int remain = 0;
    
    sc_cfg_get(ZTE_WMS_NVCONFIG_SIM_CARD_USED,strUsed,sizeof(strUsed));
    used = atoi(strUsed);
	if(used < 0 || used > INT_MAX-1) { //kw 3
		at_print(LOG_ERR,"[SMS]WMS_NVCONFIG_SIM_CARD_USED err:%d\n", used);
		used = 0;
	}
    sc_cfg_get(ZTE_WMS_NVCONFIG_SIM_CARD_TOTAL,strTotal,sizeof(strTotal));
    total = atoi(strTotal);
	if(total < 0 || total > INT_MAX-1) { //kw 3
		at_print(LOG_ERR,"[SMS]WMS_NVCONFIG_SIM_CARD_TOTAL err:%d\n", total);
		total = 0;
	}
	
    remain = total - used;
    if(remain < 0)
    {
        remain = 0;
    }
    
    memset(&StrValue, 0, 10);
    snprintf(StrValue,sizeof(StrValue),"%d", remain);
    sc_cfg_set(ZTE_WMS_NVCONFIG_SIM_CARD_REMAIN,StrValue);
    printf("[SMS] zUfiSms_DeleteSimSms used=%d,remain=%d,total=%d\n",used,remain,total);
    zUfiSms_ChangeMainState(SMS_STATE_DELED);
    sc_cfg_set(NV_SMS_DB_CHANGE,"1");
}

/*ӦatSms_SendZmenaReq*/
int zSms_SendZmenaReq(SINT32 avail)
{
	T_zSms_StroageReq  storageReq = {0};

	storageReq.type = avail;
	
	zSms_SendMsg(MSG_CMD_STORAGE_CAP_REQ, sizeof(T_zSms_StroageReq), &storageReq);

	sem_wait(&g_sms_sem_id);

	if(g_smsOptRsp.result == 1)
	{
		return ZSMS_RESULT_OK;
	}
	else
	{
		return ZSMS_RESULT_ERROR;
	}
}

//SMScmgrӦ
/*ӦatSms_SendCmgrReq*/
int zSms_SendCmgrReq(UINT8 index)
{
	T_zSms_ModifyTagReq  modTagReq = {0};

	modTagReq.index = index;
	
	zSms_SendMsg(MSG_CMD_MODIFY_TAG_REQ, sizeof(T_zSms_ModifyTagReq), &modTagReq);

	sem_wait(&g_sms_sem_id);

	if(g_smsOptRsp.result == 1)
	{
		return ZSMS_RESULT_OK;
	}
	else
	{
		return ZSMS_RESULT_ERROR;
	}
}

/*Ӧ atBase_SendAtCscaSetReq*/
int zSms_SetCscaReq(PSTR sca)
{
	T_zSms_SetScaReq  setscareq;
	
	strncpy(setscareq.sca, sca, sizeof(setscareq.sca)-1);
	
	zSms_SendMsg(MSG_CMD_SCA_SET_REQ, sizeof(T_zSms_SetScaReq), &setscareq);

	sem_wait(&g_sms_sem_id);

	if(g_smsOptRsp.result == 1)
	{
		return ZSMS_RESULT_OK;
	}
	else
	{
		return ZSMS_RESULT_ERROR;
	}
}

/*ӦatBase_SendAtCnmiReq*/
int zSms_SendCnmiReq(PSTR pAtCmdPara)
{ 
	T_zSms_NotifySetReq  notifySetReq = {0};

	if(0 == strcmp(pAtCmdPara, "sim"))
	{
		notifySetReq.mt = 1;
	}
	else
	{
		notifySetReq.mt = 2;
	}
		
	zSms_SendMsg(MSG_CMD_NOTIFY_SET_REQ, sizeof(T_zSms_NotifySetReq), &notifySetReq);

	sem_wait(&g_sms_sem_id);

	if(g_smsOptRsp.result == 1)
	{
		return ZSMS_RESULT_OK;
	}
	else
	{
		return ZSMS_RESULT_ERROR;
	}
}

/*ӦatSms_RecvCmtRsp*/
VOID zSms_RecvCmtInd(UINT8 *pDatabuf)
{
    //жǷ֧SMS
    //added by wenqin 2016-5-18
    CHAR needSMS[50] = {0};

	sc_cfg_get(NV_NEED_SUPPORT_SMS,needSMS,sizeof(needSMS));
    if(0 == strcmp(needSMS, "no"))
    {
        printf("[SMS]atSms_RecvCmtRsp needSMS=no!");
        return;
    }
    
    T_zSms_SmsInd tCmtRsp = {0};

	memcpy(&tCmtRsp, (T_zSms_SmsInd*)pDatabuf, sizeof(T_zSms_SmsInd));

	//pthread_mutex_lock(&smsdb_mutex);
	zUfiSms_CmtRespProc(&tCmtRsp);
	zUfiMmi_SendSmsStatus();
	//pthread_mutex_unlock(&smsdb_mutex);
	sc_cfg_set(NV_SMS_RECV_RESULT, "ok");
    
}

/*ӦatSms_RecvCmtiRsp */
VOID zSms_RecvCmtiInd(UINT8 *pDatabuf)
{
    char sms_Main_state[30] = {0};
	T_zSms_SmsIndexInd  *smsIdxInd = (T_zSms_SmsIndexInd*)pDatabuf;

	//жǷ֧SMS
    //added by wenqin 2016-5-18
    CHAR needSMS[50] = {0};
    sc_cfg_get(NV_NEED_SUPPORT_SMS,needSMS,sizeof(needSMS));
    if(0 == strcmp(needSMS, "no"))
    {
        printf("[SMS]atSms_RecvCmtRsp needSMS=no!");
        return;
    }

	//ɾв¶
    sc_cfg_get(NV_SMS_STATE,sms_Main_state,sizeof(sms_Main_state));
    if(strcmp(sms_Main_state,"sms_deling")==0)
    {
    	printf("[SMS] atSms_RecvCmtiRsp: sms_deling\n");
        return;
    }

	if(0 == strncmp("SM", smsIdxInd->storetype, 2))	
	{
		zUfiSms_SetSmsLocation(SMS_LOCATION_SIM);       
        zUfiSms_ChangeMainState(SMS_STATE_RECVING);
		//send ZMGR
		zSms_SendZmgrReq(smsIdxInd->index);
	}
	else //ģ󾭳ֶŴ洢λΪSR
    {
        printf("[SMS] atSms_RecvCmtiRsp :store location not SM.\n");
    }
    sc_cfg_set(NV_SMS_RECV_RESULT, "");	
}

/*ӦatSms_RecvCdsRsp*/
VOID zSms_RecvCdsInd(UINT8 *pDatabuf)
{
    //жǷ֧SMS
    //added by wenqin 2016-5-18
    CHAR needSMS[50] = {0};
    sc_cfg_get(NV_NEED_SUPPORT_SMS,needSMS,sizeof(needSMS));
    if(0 == strcmp(needSMS, "no"))
    {
        printf("[SMS]atSms_RecvCmtRsp needSMS=no!");
        return;
    }

    T_zSms_SmsInd tCmtRsp = {0};

	memcpy(&tCmtRsp, (T_zSms_SmsInd*)pDatabuf, sizeof(T_zSms_SmsInd));

	//pthread_mutex_lock(&smsdb_mutex);
    zUfiSms_CdsRespProc(&tCmtRsp);
    zUfiMmi_SendSmsStatus();
    //pthread_mutex_unlock(&smsdb_mutex);
    sc_cfg_set(NV_SMS_RECV_RESULT, "ok");    
}


/*ӦatSms_RecvCdsiRsp*/
VOID zSms_RecvCdsiInd(UINT8 *pDatabuf)
{
    char sms_Main_state[30] = {0};
	T_zSms_SmsIndexInd  *smsIdxInd = (T_zSms_SmsIndexInd*)pDatabuf;

	//жǷ֧SMS
    //added by wenqin 2016-5-18
    CHAR needSMS[50] = {0};
    sc_cfg_get(NV_NEED_SUPPORT_SMS,needSMS,sizeof(needSMS));
    if(0 == strcmp(needSMS, "no"))
    {
        printf("[SMS]atSms_RecvCmtRsp needSMS=no!");
        return;
    }

	//ɾв¶
    sc_cfg_get(NV_SMS_STATE,sms_Main_state,sizeof(sms_Main_state));
    if(strcmp(sms_Main_state,"sms_deling")==0)
    {
        printf("[SMS] atSms_RecvCdsiRsp: sms_deling\n");
        return;
    }

	if(0 == strncmp("SM", smsIdxInd->storetype, 2))	
	{
		zUfiSms_SetSmsLocation(SMS_LOCATION_SIM);       
        zUfiSms_ChangeMainState(SMS_STATE_RECVING);
		//send ZMGR
		zSms_SendZmgrReq(smsIdxInd->index);
	}
	else //ģ󾭳ֶŴ洢λΪSR
    {
        printf("[SMS] atSms_RecvCdsiRsp :store location not SM.\n");
    }
    sc_cfg_set(NV_SMS_RECV_RESULT, "");    
}


/*ӦatSms_SendCnmaReq*/
int zSms_SendCnmaReq(int ack_mode)
{
	T_zSms_SmsAckReq ackReq = {0};    
    CHAR ackPduStr[50] = {0};

	ackReq.ackmode = ack_mode;

	if(ack_mode == 2)
	{
		zUfiSms_EncodePdu_DeliverReport(ackPduStr, 0xD3); 
		memcpy(ackReq.pdu, ackPduStr, strlen(ackPduStr));
#if 0
		if(strlen(ackPduStr)< ZSMS_PDU_SIZE-1)
        {
            memcpy(ackReq.pdu, ackPduStr, strlen(ackPduStr));
        }
        else
        {
            at_print(LOG_DEBUG"[SMS] atSms_SendCnmaReq pdu too long:%s\n",ackPduStr);
            memcpy(ackReq.pdu, ackPduStr, ZSMS_PDU_SIZE-2);
        }
#endif     
        // ӽβ
        *(ackReq.pdu + strlen(ackPduStr)) = ZSMS_CTRL_Z_CHAR;
        printf("[SMS] atSms_SendCnmaReq. pdu= %s\n", ackReq.pdu);

		ackReq.length = strlen(ackPduStr)/2;
	}  
	
  	zSms_SendMsg(MSG_CMD_SMSACK_REQ, sizeof(T_zSms_SmsAckReq), &ackReq);

    sem_wait(&g_sms_sem_id);

	if(g_smsOptRsp.result == 1)
	{
		return ZSMS_RESULT_OK;
	}
	else
	{
		return ZSMS_RESULT_ERROR;
	}
}


/*ӦatSms_SendZmgrReq*/
int zSms_SendZmgrReq(int index)
{
   	T_zSms_ReadSmsReq readSmsReq = {0};

	iSmsIndex = index;
	printf("[SMS] atSms_SendZmgrReq Get index:%d.\n",iSmsIndex);	

	readSmsReq.index = index;
	zSms_SendMsg(MSG_CMD_READSMS_REQ, sizeof(T_zSms_ReadSmsReq), &readSmsReq);

    //˴ȴ
    return 0;
}

/*ӦatSms_RecvZmgrRsp */
VOID zSms_RecvZmgrRsp(UINT8 *pDatabuf)
{
    T_zSms_SmsInd tCmgrRsp = {0};

	memcpy(&tCmgrRsp, (T_zSms_SmsInd*)pDatabuf, sizeof(T_zSms_SmsInd));

	tCmgrRsp.index = iSmsIndex;

	zUfiSms_ZmgrRespProc(&tCmgrRsp);
	zUfiMmi_SendSmsStatus();
	
}

VOID zSms_RecvZmgrOk(UINT8 *pDatabuf)
{
	T_zSms_optRsp smsOptRsp = {0};

	memcpy(&smsOptRsp, (T_zSms_optRsp*)pDatabuf, sizeof(T_zSms_optRsp));
	if(smsOptRsp.result == 1)
	{
		sc_cfg_set(NV_SMS_RECV_RESULT, "ok");
	}
	else
	{
		printf("[SMS] atSms_RecvZmgrErr  SMS zmgr is fail\n");    
       
        sc_cfg_set(NV_SMS_RECV_RESULT, "fail");
        zUfiSms_ChangeMainState(SMS_STATE_RECVED);
    
	}
}

VOID zSms_RecvZpbicInd(UINT8 *pDatabuf)
{
	T_zAt_ZpbicRes *ptPara = ZUFI_NULL;	
    if(pDatabuf == NULL)
    {
        return;
    }
    ptPara = (T_zAt_ZpbicRes*)(pDatabuf);
	
	if((1 == ptPara->result) && (0 == ptPara->opertype))
    {
        //жNV,added by wenqin 2016-5-18
        CHAR needSms[50]={0};
        sc_cfg_get(NV_NEED_SUPPORT_SMS,needSms,sizeof(needSms));
        if(0 != strcmp(needSms,"no"))
        {
            zSvr_Zpbic_Sms_Init();
        }        
    }
}



VOID zSms_RecvCpmsInd(UINT8 *pDatabuf)
{
	T_zSms_CpmsInd *cpmsInd = (T_zSms_CpmsInd*)pDatabuf;
 	CHAR  strBuf[10]    = {0};
    int   remainSpace = 0;

    snprintf(strBuf,sizeof(strBuf),"%d", cpmsInd->total);
    sc_cfg_set(ZTE_WMS_NVCONFIG_SIM_CARD_TOTAL,strBuf);
    sc_cfg_set(ZTE_WMS_NVCONFIG_SIM_CAPABILITY,strBuf);

    memset(&strBuf, 0, 10);
    snprintf(strBuf,sizeof(strBuf),"%d", cpmsInd->used);
    sc_cfg_set(ZTE_WMS_NVCONFIG_SIM_CARD_USED,strBuf);
	
    remainSpace = cpmsInd->total - cpmsInd->used;
    memset(&strBuf, 0, 10);
    snprintf(strBuf,sizeof(strBuf),"%d", remainSpace);
    sc_cfg_set(ZTE_WMS_NVCONFIG_SIM_CARD_REMAIN,strBuf);

    sc_cfg_set(NV_SMS_STORE,"ok");

}

/**************************************************************************
* : VOID atBase_PreProcRes(char *)
* : ԤкΪ˷Уڽ֮ǰԤò
*           УڷָĶţÿո滻ַͲеĿո
*           ÿո滻滻ڱʶַ˫ɾڿյַ
* ˵: (IN) pParaLine     : ԤַУ
*           (OUT)pParaLine     : ԤַУ
*   ֵ:
* ˵:ֲ
**************************************************************************/
#define AT_CMD_MAX 64

#define ZAT_TAB_REPLACE                     ((unsigned char )(0xFC))    /* Ʊ滻     */
#define ZAT_NULL_FILL                       ((unsigned char )(0xFD))    /* մռλ       */
#define ZAT_SPACE_REPLACE                   ((unsigned char )(0xFE))    /* ո滻       */
#define ZAT_LF_REPLACE                      ((unsigned char )(0xFB))    /* LF滻         */
#define ZAT_CR_REPLACE                      ((unsigned char )(0xFA))    /* CR滻 */
static void atBase_PreProcRes(char *pParaLine, int paraSize)//ַʽʹãҪŻ򵥻
{
    signed long  flg                                     = 0;
    unsigned long  i                                       = 0;
    unsigned long  length                                  = 0;
    char    *pSource                                = pParaLine;
    char    *pDest                                  = NULL;
    
    char    *pStrDestMalloc = (char *)malloc(AT_CMD_MAX);
    if(NULL == pStrDestMalloc)
    {
        return;
    }
    memset(pStrDestMalloc, 0, AT_CMD_MAX); 
    
    assert(pParaLine != NULL);
    pDest = pStrDestMalloc;
    length = strlen(pParaLine);
    if ((length == 0) || (length >= AT_CMD_MAX))
    {
        free(pStrDestMalloc);
        return;
    }
    for (i = 0; (i < length )&& (pDest - pStrDestMalloc < AT_CMD_MAX); i++)
    {
        if ('"' == *pSource)
        {
            flg = (0 == flg)?1:0;                           /* ˫ ɾ  */
            if ('"' == *(pSource + 1))                      /* ǺźǺţմռλ */
            {
                *pDest++ = (char)ZAT_NULL_FILL;
            }
        }
        else if ((',' == *pSource) && (0 == flg))
        {
            *pDest++ = ' ';                                 /* ˫Ķţ滻ɿո */
            if(',' == *(pSource + 1))                       /* źţԶŽβմռλ */
            {
                *pDest++ = '9';                             //9ʱ
            }
            else if('\0' == *(pSource + 1))                 /* źţԶŽβմռλ */
            {
                *pDest++ = (char)ZAT_NULL_FILL;
            }
        }
        else
        {
            //*pDest++ = ((' ' == *pSource) && (1 == flg))?(char)ZAT_SPACE_REPLACE:((('\t' == *pSource) && (1 == flg))?(char)ZAT_TAB_REPLACE:((('\n' == *pSource) && (1 == flg))?(char)ZAT_LF_REPLACE:((('\r' == *pSource) && (1 == flg))?(char)ZAT_CR_REPLACE:(*pSource))));
            if((' ' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_SPACE_REPLACE;
			}
			else if(('\t' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_TAB_REPLACE;
			}
			else if(('\n' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_LF_REPLACE;
			}
			else if(('\r' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_CR_REPLACE;
			}
			else
			{
				*pDest++ = *pSource;
			}
        }
        pSource++;
    }
    memset(pParaLine, 0, paraSize);                           /* Ԥݿز */
    strncpy(pParaLine, pStrDestMalloc,paraSize-1);
    free(pStrDestMalloc);
}

//洢
VOID zSms_RecvCscaInd(UINT8 *pDatabuf)
{
	T_zSms_CscaInd cscaInd = {0};

	#if 1//corem for debug
	printf("[SMScorem]zSms_RecvCscaInd databuf:%s\n",pDatabuf);
	#endif
	atBase_PreProcRes(pDatabuf, strlen(pDatabuf));
	
    sscanf(pDatabuf, "%21s %21s", cscaInd.sca, cscaInd.tosca);
	#if 1//corem for debug
	printf("[SMScorem]zSms_RecvCscaInd sca:%s, tosca%s\n", cscaInd.sca, cscaInd.tosca);
	#endif
	sc_cfg_set(NV_SMS_CENTER_NUM,cscaInd.sca); 
	zUfiSms_SetScaPara(cscaInd.sca);
}

	
VOID zSms_RecvZmglInd(UINT8 *pDatabuf)
{
	zUfiSms_CmglRespProc((T_zSms_SmsInd*)pDatabuf);
}


int zSms_SendSmsInitReq(VOID)
{ 		
	zSms_SendMsg(MSG_CMD_SMSINIT_REQ, 0, NULL);
	return 0;
}

VOID zSms_initAtOk(VOID)
{
    T_zUfiSms_StatusInfo tStatus = {0};
    //˴ᵼcmglٷһμصME
    //zUfiSms_ChangeMainState(SMS_STATE_LOADED);
 	sc_cfg_set(NV_SMS_STORE,"ok");
	
	sc_cfg_set(NV_SMS_LOAD_RESULT, "ok");
    tStatus.cmd_status = WMS_CMD_SUCCESS;
    tStatus.cmd = WMS_SMS_CMD_INIT;
    (void)zUfiSms_SetCmdStatus(&tStatus);
    zUfiSms_ChangeMainState(SMS_STATE_LOADED);
}

VOID zSms_initAtErr(VOID)
{
    T_zUfiSms_StatusInfo tStatus = {0};
    
    sc_cfg_set(NV_SMS_LOAD_RESULT, "fail");
    zUfiSms_ChangeMainState(SMS_STATE_LOADED);
    
    tStatus.cmd_status = WMS_CMD_FAILED;
    tStatus.cmd = WMS_SMS_CMD_INIT;
    (void)zUfiSms_SetCmdStatus(&tStatus);    
}

VOID zSms_RecvSmsInitRst(UINT8 *pDatabuf)
{
	memcpy(&g_smsOptRsp, pDatabuf, sizeof(T_zSms_optRsp));

	if(g_smsOptRsp.result == 1)
	{
		zSms_initAtOk();
	}
	else
	{
		zSms_initAtErr();
	}
}
	



UINT8 zSms_SmsMsgCreat(VOID)
{
	g_zSms_MsqId = msgget(MODULE_ID_SMS, IPC_CREAT | 0600);
    if(g_zSms_MsqId == -1)
    {
        return ZUFI_FAIL;
    }
	g_zSms_LocalMsqId = msgget(MODULE_ID_SMS_LOCAL, IPC_CREAT | 0600);
    if(g_zSms_LocalMsqId == -1)
    {
        return ZUFI_FAIL;
    }
	sem_init(&g_sms_sem_id, 0 ,0);

	return ZUFI_SUCC;
}

void zSms_HandleAtctlLocalMsg(MSG_BUF *ptMsgBuf)
{
	assert(ptMsgBuf != NULL);
	printf( "sms local recv msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
		case MSG_CMD_ZPBIC_IND:
			zSms_RecvZpbicInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_ZMGL_IND:
			zSms_RecvZmglInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_NEWSMS_STATUS_IND:
			zSms_RecvCdsInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_NEWSMS_IND:
			zSms_RecvCmtInd(ptMsgBuf->aucDataBuf);
		default:
			break;

	}
}

VOID zSms_HandleAtctlMsg(MSG_BUF *ptMsgBuf)
{
    assert(ptMsgBuf != NULL);
	printf( "sms recv msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
		case MSG_CMD_SENDSMS_RSP:
		case MSG_CMD_DELSMS_RSP:	
		case MSG_CMD_STORAGE_CAP_RSP:	
		case MSG_CMD_MODIFY_TAG_RSP:
		case MSG_CMD_NOTIFY_SET_RSP:
		case MSG_CMD_SCA_SET_RSP:
		case MSG_CMD_SMSACK_RSP:
			{
				memcpy(&g_smsOptRsp, ptMsgBuf->aucDataBuf, sizeof(T_zSms_optRsp));
				sem_post(&g_sms_sem_id);
			}
			break;
		case MSG_CMD_CPMS_IND:
			zSms_RecvCpmsInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_CSCA_IND:
			zSms_RecvCscaInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_ZMGR_IND://ZMGRһ;ϱϢ
			zSms_RecvZmgrRsp(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_READSMS_RSP://ZMGRһŽOK/ERROR
		    zSms_RecvZmgrOk(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_SMSINIT_RSP:
			zSms_RecvSmsInitRst(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_NEWSMS_INDEX_IND:
			zSms_RecvCmtiInd(ptMsgBuf->aucDataBuf);
			break;

		case MSG_CMD_NEWSMS_STATUS_INDEX_IND:
			zSms_RecvCdsiInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_NEWSMS_IND:
		case MSG_CMD_ZPBIC_IND:
		case MSG_CMD_ZMGL_IND:
		case MSG_CMD_NEWSMS_STATUS_IND:
			ipc_send_message(MODULE_ID_SMS, MODULE_ID_SMS_LOCAL, ptMsgBuf->usMsgCmd, ptMsgBuf->usDataLen, (unsigned char *)ptMsgBuf->aucDataBuf,0);
			break;
			
		default:
			break;

	}
}	

VOID zSms_HandleResetToFactory()
{
    CHAR clearSms[50] = {0};
	
    sc_cfg_get(NV_CLEAR_SMS_WHEN_RESTORE,clearSms,sizeof(clearSms));

	printf("atWeb_RestoreFactorySetting entered! \n");
	printf("clear_sms_when_restore=%s \n", clearSms);	
	if(strcmp(clearSms, "yes") == 0)
    {
        printf("zUfiSms_DropAllTable entered! \n");		
		zUfiSms_DropAllTable();
    }
	else
	{
	    printf("zUfiSms_DropAllTableExceptSms entered! \n");		
		zUfiSms_DropAllTableExceptSms();
	}
	ipc_send_message(MODULE_ID_SMS, MODULE_ID_MAIN_CTRL, MSG_CMD_RESET_RSP, 0, NULL,0);
}

void zSms_HandleMainCtrlMsg(MSG_BUF *ptMsgBuf)
{
	assert(ptMsgBuf != NULL);
	printf( "sms recv main ctrl msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
		case MSG_CMD_RESET_NOTIFY:
			zSms_HandleResetToFactory(ptMsgBuf->aucDataBuf);
			break;
		default:
			break;

	}
}


void sms_msg_thread_proc(void* arg)
{
	int iRet = 0;
	MSG_BUF stMsg = {0};
	int msgSize = sizeof(MSG_BUF) - sizeof(long);
	int queueId = *((int*)arg);
	prctl(PR_SET_NAME, "sms_local", 0, 0, 0);
	while(1)
	{
		iRet = 0;
		memset(&stMsg, 0x00, sizeof(MSG_BUF));
		iRet = msgrcv(queueId, &stMsg, msgSize, 0, 0);
		if (iRet >= 0)
		{
			switch (stMsg.src_id)
	        {
	            case MODULE_ID_WEB_CGI:
	            {
					zSms_HandleWebMsg(&stMsg);
	                break;
	            }
	            case MODULE_ID_AT_CTL:
	            {                
					zSms_HandleAtctlMsg(&stMsg);
	                break;
	            }
	            case MODULE_ID_SMS:
				{
					zSms_HandleWebMsg(&stMsg);				
					zSms_HandleAtctlLocalMsg(&stMsg);
					break;
				}
				case MODULE_ID_MAIN_CTRL:
				{
					zSms_HandleMainCtrlMsg(&stMsg);
					break;
				}
	            default:
	            {
	                break;
	            }
	        }
		}
		else
		{    
			at_print(AT_DEBUG,"errno = %d, errmsg = %s\n", errno,strerror(errno));
		}
	} 
}


int sms_main(int argc, char* argv[])
{
	pthread_t recv_thread_tid = 0;
    MSG_BUF   msgBuf      = {0};
	CHAR needSMS[50] = {0};
	prctl(PR_SET_NAME, "sms_main", 0, 0, 0);
	//NVʼӡ𣬲עᶯ̬ӡź
	loglevel_init();
	
	//жNV,added by wenqin 2016-5-18
    sc_cfg_get(NV_NEED_SUPPORT_SMS,needSMS,sizeof(needSMS));
    if(0 != strcmp(needSMS, "no"))
    {
 		zUfiSms_InitDb();
        zUfiSms_CfgSmsNvInit();
    	zUfiMmi_SendSmsStatus();
		zSms_SmsMsgCreat();
    }
	else
	{
		return -1;
	}
    printf("sms app init finished, will to receive msg, msgid:%d\n", g_zSms_MsqId);	
	//߳ڴڲϢӦϢsourceIdMODULE_ID_SMS
    if(pthread_create(&recv_thread_tid, NULL, sms_msg_thread_proc, (void*)(&g_zSms_LocalMsqId)) == -1)
    {
		assert(0);
    }
	//߳ڴⲿϢӦϢsourceIdMODULE_ID_SMS
    sms_msg_thread_proc(&g_zSms_MsqId);
	return 0;
}

