#ifndef USBCFGMNG_H
#define USBCFGMNG_H

#include <sys/msg.h>
#include "message.h"
#include "softap_api.h"
#include "hotplug.h"

#define USBCFG_MS_LUN_MAX_NUM     2   /*洢lun豸*/
#define USBCFG_MAX_ACM_NUM        3   /*ACM*/
#define USBCFG_MAX_SERIAL_NUM     4   /*SERIAL*/

#define USB_PLUG_FILE_NAME              "/sys/dwc_usb/usbconfig/usbPlug"
#define CHARGER_PLUG_FILE_NAME          "/sys/dwc_usb/usbconfig/chargerPlug"
#define USB_ENABLE_FILE_PATH            "/sys/devices/virtual/android_usb/android0/enable"
#define USB_FUNCTIONS_FILE_PATH         "/sys/devices/virtual/android_usb/android0/functions"
#define USB_IDPRODUCT_FILE_PATH         "/sys/devices/virtual/android_usb/android0/idProduct"
#define USB_IDVENDOR_FILE_PATH          "/sys/devices/virtual/android_usb/android0/idVendor"
#define USB_MANUFACTURER_FILE_PATH      "/sys/devices/virtual/android_usb/android0/iManufacturer"
#define USB_PRODUCT_FILE_PATH           "/sys/devices/virtual/android_usb/android0/iProduct"
#define USB_ISERIAL_FILE_PATH           "/sys/devices/virtual/android_usb/android0/iSerial"
#define USB_CONFIG_FILE_PATH            "/sys/devices/virtual/android_usb/android0/iConfiguration"
#define USB_RELEASEID_FILE_PATH         "/sys/devices/virtual/android_usb/android0/bcdDevice"
#define USB_BMATTR_FILE_PATH            "/sys/devices/virtual/android_usb/android0/bmAttributes"
#define USB_ACM_FILE_PATH               "/sys/devices/virtual/android_usb/android0/f_acm/instances"
#define USB_SERIAL_FILE_PATH            "/sys/devices/virtual/android_usb/android0/f_serial/instances_serial"

#define USB_ENUM_MODE_PATH        		"/sys/devices/virtual/android_usb/android0/usb_enum_mode"
#define UART_CONSOLE_INPUT_PATH   		"/sys/devices/platform/zx29_uart.1/console_input"

#define USB_MS_LUN_NUM                  "/sys/devices/virtual/android_usb/android0/f_mass_storage/nluns"
#define USB_RNDIS_FILE_PATH             "/sys/devices/virtual/android_usb/android0/f_rndis/wceis"
#define USB_RNDIS_MAC_ADDR_PATH             "/sys/devices/virtual/android_usb/android0/f_rndis/ethaddr"
#define USB_SYS_ID_FILE_NAME            "/sys/dwc_usb/usbconfig/sysId"

#define USB_FORCE_NET_FILE_NAME            "/sys/dwc_usb/usbconfig/forcenet"

#define USB_ECM_FILE_PATH               "/sys/devices/virtual/android_usb/android0/f_ecm/ecm_instances"
#define USB_ECM_MAC_ADDR_PATH               "/sys/devices/virtual/android_usb/android0/f_ecm/ethaddr_ecm"
#define USB_RNDIS_PKTNUM_FILE_PATH      "/sys/devices/virtual/android_usb/android0/f_rndis/pktNum"
#define USB_MBIM_PKTNUM_FILE_PATH       "/sys/devices/virtual/android_usb/android0/f_mbim/mbimPktNum"


#define USB_MMC_FILE_NAME               "/sys/kernel/debug/mmc1/present"
#define USB_ENMODS_FILE_NAME            "/sys/dwc_usb/usbconfig/enMods"
#define USB_GPIO_DETECT_ENABLE          "/sys/dwc_usb/usbconfig/gpio_detect"

/*USB_MS_LUN_FILE_PATHƴӻȡ·, 
  :USB_MS_LUN_FILE_PATH + lun_id + STR_USB_MS_LUN_FILE
 */
#define USB_MS_LUN_FILE_PATH            "/sys/devices/platform/zx29_hsotg.0/gadget/lun"
#define STR_USB_MS_LUN_FILE             "/file"     /*洢·*/
#define STR_USB_MS_LUN_INQUIRY          "/inquiry"  /*洢inquiryϢ*/
#define STR_USB_MS_LUN_CDROM            "/cdrom"    /*洢cdromڵ*/
#define STR_USB_MS_LUN_RO               "/ro"       /*洢roڵ*/

#define USBCFG_MAIN_LOCK_ID             "usbcfgmng_lock" 

//#define UEVENT_BUFFER_SIZE           (1024 * 6)  
#define USB_FLAG_BUF_LEN             20
#define USB_STR_FUNCTIONS_MAX_LEN    40
#define USBCFG_MSG_MAX_LENGTH        32
#define USBCFG_LUN_PATH_MAX_LENGTH   64
#define MAX_FILENAME_LEN             64      /*ļ·󳤶*/

#define USB_STR_MASSSTORAGE              "mass_storage"

/*nv궨*/
/*add by 0045002184 for mass_storage*/
//#define USB_LUN_NUM_DEBUG       "usb_lun_num_debug"
//#define USB_LUN_NUM_CDROM       "usb_lun_num_cdrom"
//#define USB_LUN_NUM_USER       "usb_lun_num_user"
//#define USB_LUN0_TYPE         "usb_lun0_type"
//#define USB_LUN1_TYPE         "usb_lun1_type"
#define USB_LUN_TYPE_DEBUG         "usb_lun_type_debug"
#define USB_LUN_TYPE_USER         "usb_lun_type_user"
#define USB_LUN_TYPE_CDROM         "usb_lun_type_cdrom"
/*set lun num and type of each lun*/

#define USB_STR_ENUM_DEVICES_DEBUG       "usb_devices_debug"
#define USB_STR_ENUM_DEVICES_DEBUG_MBIM  "usb_devices_debug_mbim"

#define USB_STR_ENUM_DEVICES_USER        "usb_devices_user"
#define USB_STR_ENUM_DEVICES_FACTORY     "usb_devices_factory"
#define USB_STR_ENUM_DEVICES_AMT         "usb_devices_amt"

#define USB_ACM_NUM_DEBUG                "usb_acm_num_debug"
#define USB_ACM_NUM_USER                 "usb_acm_num_user"
#define USB_ACM_NUM_FACTORY              "usb_acm_num_factory"
#define USB_ACM_NUM_AMT                  "usb_acm_num_amt"

#define USB_SERIAL_NUM_DEBUG                "usb_serial_num_debug"
#define USB_SERIAL_NUM_USER                 "usb_serial_num_user"
#define USB_SERIAL_NUM_FACTORY              "usb_serial_num_factory"
#define USB_SERIAL_NUM_AMT                  "usb_serial_num_amt"
#define USB_SERIAL_TYPE						"usb_serial_type"

#define STR_PID_TSP_MBIM                 "PID_TSP_MBIM"//
#define STR_PID_TSP_NDIS                 "PID_TSP_NDIS"//
#define STR_PID_TSP_RNDIS                "PID_TSP_RNDIS"// 0x0536
#define STR_PID_TSP_ECM                  "PID_TSP_ECM"//0x0536
#define STR_PID_TSP_CDROM                "PID_TSP_CDROM"//    0x0548
#define STR_PID_USER_CDROM               "PID_USER_CDROM"//
#define STR_PID_USER_MBIM                "PID_USER_MBIM"//
#define STR_PID_USER_RNDIS               "PID_USER_RNDIS"//
#define STR_PID_USER_ECM                 "PID_USER_ECM"//
#define STR_PID_USER_NDIS                "PID_USER_NDIS"//    
#define STR_PID_USER_NOVNIC              "PID_USER_NOVNIC"//  
#define STR_PID_FACTORY                  "PID_FACTORY"//  0x0534 
#define STR_PID_AMT                      "PID_AMT"//  0x0201 
#define STR_PID_TEST                     "PID_TEST"//0xff00
#define STR_PID_EYE_DIAGRAM                     "PID_YT"

#define STR_VID_TSP                      "VID_TSP"//0x19D2
#define STR_SERIAL_TSP                   "SERIAL_TSP"//1234567890ABCDEF
#define STR_RELEASEID_TSP                "RELEASEID_TSP"//0x0100
#define STR_RELEASEID_USER               "RELEASEID_USER"//0x0100
#define STR_MANUFACTURER_TSP             "MANUFACTURER_TSP"//ZXIC,Incorporated
#define STR_PRODUCT_TSP                  "PRODUCT_TSP"//ZXIC Mobile Boardband
#define STR_CONFIG_TSP                   "CONFIG_TSP"//ZXIC Configuration

#define STR_USB_VNIC_USER                "usb_vnic_user"
#define USB_SET_SERNUM_BY_CHIPID                "usb_sernum_chipid"

#define STR_INQUIRY_MS_CDROM              "INQUIRY_MS_CDROM"//ZXIC
//#define STR_VENDOR_MS_CDROM              "VENDOR_MS_CDROM"//ZXIC
//#define STR_PRODUCT_MS_CDROM             "PRODUCT_MS_CDROM"//USB SCSI CD-ROM
//#define STR_RELEASE_MS_CDROM             "RELEASE_MS_CDROM"//2
#define STR_INQUIRY_MS_MMC              "INQUIRY_MS_MMC"//ZXIC
//#define STR_VENDOR_MS_MMC                "VENDOR_MS_MMC"//ZXIC
//#define STR_PRODUCT_MS_MMC               "PRODUCT_MS_MMC"//MMC Storage
//#define STR_RELEASE_MS_MMC               "RELEASE_MS_MMC"//2

#define STR_VER_MODE       "ver_mode"//汾ͣ0Ϊamt汾1Ϊ汾
#define STR_ECM_NUM                      "ECM_NUM"//1~3
#define STR_RNDIS_PKT_NUM                "RNDIS_PKT_NUM"//1~10
#define STR_MBIM_PKT_NUM                 "MBIM_PKT_NUM"//1~10


#define STR_CDROM_LUNPATH                "usb_cdrom_lun_path"       /*̽·洢NV*/
#define STR_TCARD_LUNPATH               "usb_tcard_lun_path"      /*T·洢NV*/
#define STR_FLASHTCARD_LUNPATH           "usb_flashtcard_lun_path"  /*flashT·洢NV*/

#define NV_NEED_CP_UDISK                 "need_support_cp_udisk"        /*ʶǷ֧CPTл*/
#define NV_NEED_CDROM_STEP1              "cdrom_state"                  /*һ׶öcdrom*/
#define NV_NEED_CDROM_STEP2              "need_support_cdrom_step2"     /*ڶ׶öcdrom*/

#define STR_SDCARD_MODE_OPT              "sdcard_mode_option"      /*жhttpshareöΪU*/
#define STR_SELECT_TYPE                  "select_type"
#define STR_USB_MODE_TYPE                "usb_modetype"
#define STR_FORCE_NETCARD_TYPE           "forcenetcard_type"
#define NV_USB_GPIO_DETECT				 "usb_gpio_detect"
#define NV_MMC                "MMC"
#define NV_CDROM           "CDROM"


/*ãȶ*/
#define USB_MS_VENDOR_LEN  8
#define USB_MS_PRODUCT_LEN 16
#define USB_MS_RELEASE_LEN 4
#define USB_MS_INQUIRY_LEN 29


typedef int (*USBCFG_MSG_PROC_PTR)(VOID* data);
typedef enum {
	USB_SERIAL_TYPE_SERIAL = 0,
	USB_SERIAL_TYPE_ACM,
	USB_SERIAL_TYPE_MAX,
}e_usb_serial_type;

typedef struct
{
    unsigned int id;
    USBCFG_MSG_PROC_PTR func_ptr;
}USBCFG_MSG_PROC_INFO;

typedef enum
{
    MS_TYPE_CDROM = 0,  
    MS_TYPE_MMC = 1,  
}e_usb_MsType;

/*ô洢豸*/
typedef enum
{
    USB_NUM_LUN_1 = 1,  
    USB_NUM_LUN_2,  
    USB_NUM_LUN_3,
    USB_NUM_LUN_4,
    USB_NUM_LUN_5,
    USB_NUM_LUN_6,
    USB_NUM_LUN_7,
    USB_NUM_LUN_8,
}e_usb_MsLunNum;

/*usbģʽ*/
typedef enum{
    USB_MODETYPE_DEBUG = 0,
    USB_MODETYPE_USER,
    USB_MODETYPE_FACTORY,
    USB_MODETYPE_AMT,
    USB_MODETYPE_EYE_DIAGRAM,
    USB_MODETYPE_MAX_CONFIG_NUM,
}e_usbEnum_modeType;

/*usbö*/
typedef enum{
    USB_CDROM = 0,
    USB_DEBUG,
    USB_USER,
    USB_FACTORY,
    USB_AMT,
    USB_EYE_DIAGRAM,
    USB_MAX_CONFIG_NUM,
    USB_INVALID,
}e_usbEnum_type;

/*wangchao add to force netCard type*/
typedef enum _T_SYS_NV_FORCE_NETCARD_TYPE
{    
    FORCE_INVALID   =0xFFUL,
    FORCE_NDIS      =0x00UL,
    FORCE_RNDIS     =0x01UL,    
    FORCE_ECM       =0x02UL,
    FORCE_MBIM      =0x03UL,
    FORCE_ERR       =0x55UL
}T_SYS_NV_FORCE_NETCARD_TYPE;

typedef enum _T_SYS_NV_NETCARD_TYPE_FOR_WIN
{
    SELECT_NDIS     =0xFFUL,
    SELECT_RNDIS    =0x00UL,
    SELECT_MBIM     =0x01UL,
    
    SELECT_ERR      =0x55UL
}T_SYS_NV_NETCARD_TYPE_FOR_WIN;

typedef struct _T_REF_NV_USB
{
    int CDROMFlag;
    int CDROMFlagStep2;
    //int lun_num;
    T_SYS_NV_FORCE_NETCARD_TYPE forcetVNICType;
    T_SYS_NV_NETCARD_TYPE_FOR_WIN VNICTypeForWin;
    e_usbEnum_modeType nvModeType;
    e_usbEnum_type currentModeType;
    int Fast_PowerOffFlag;
	e_usb_serial_type nv_serial;
}T_REF_NV_USB;

typedef enum _T_ZDrvUsb_OSType
{
    OSType_Windows=0,
    OSType_Others=1,
    
    OS_MAX_TYPE_NUM=2,
    OS_TYPE_END=0xff    /* all device uninstalled */
}T_ZDrvUsb_OSType;

typedef enum
{
    USBCFG_ERROR_MODE = -1,
    USBCFG_USB = 0,
    USBCFG_HTTPSHARE = 1,
    USBCFG_RESERVE_MODE 
}e_usbEnum_Tcardtype;

struct lun_info
{
    e_usb_MsType mstype;              /*lun*/
    char lun_path[MAX_FILENAME_LEN];  /*lun豸Ľ·*/
};

typedef struct
{
    unsigned int     usb_lunNum;
	int has_mmc;
    struct lun_info  lun_info[USBCFG_MS_LUN_MAX_NUM];
}T_UsbCfg_MsLunInfo;
#if 0
/*UEVENT¼*/
enum kobject_action {
	KOBJ_ADD,
	KOBJ_REMOVE,
	KOBJ_CHANGE,
	KOBJ_MOVE,
	KOBJ_ONLINE,
	KOBJ_OFFLINE,
	KOBJ_MAX
};

/*豸ֽͣʹ*/
enum device_type {
	DEVICE_TYPE_USB,     /*USB*/
	DEVICE_TYPE_RJ45,    /*rj45*/
	DEV_TYPE_USB,              /*USB*/
    DEV_TYPE_SDCARD,           /*sdcard*/
    DEV_TYPE_VIRTUAL_SDCARD,   /*T*/
    DEV_TYPE_SERIAL,           /*SERIAL*/
	DEVICE_TYPE_MAX,
};

/*usbϢ¼*/
enum usb_event
{
    USB_EVENT_CHARGE = 0,
    USB_EVENT_DEVICE,
    USB_EVENT_CDROMOBJ,
    USB_EVENT_USER,
    USB_EVENT_DEBUG,
    USB_EVENT_FACTORY,
    USB_EVENT_AMT,
    USB_EVENT_YT,
    USB_EVENT_RESET,
    USB_EVENT_MAX,
};

/*ȰβϢ*/
struct hotplug_event
{
    int type;        /*豸*/
    int action;      /*ͣӦkobject_action*/

    union
    {
        struct usb_dev
        {
            int event_type;
        } usb;
    }u;
};
#endif

typedef struct
{
	unsigned int pubKeyRsaE[32];
	unsigned int pubKeyRsaN[32];
	unsigned int secureFlag;
	unsigned int pubKeyHash[4];
	unsigned int secureDevId[3];
}ZDrvEfuse_Secure;

#define EFUSE_IOC_MAGIC 	'E'
#define EFUSE_GET_DATA 		_IOWR(EFUSE_IOC_MAGIC, 1, char *)

typedef int (*T_USBCFG_UDISKFunc)(void);
typedef int (*hotplug_parse_func)(const char *msg, int msglen, struct hotplug_event *event);
typedef int (*hotplug_proc_func)(struct hotplug_event *event);

#if 0
extern hotplug_parse_func usb_hotplug_parse_ptr[DEV_TYPE_MAX];
extern hotplug_proc_func usb_hotplug_proc_ptr[DEV_TYPE_MAX];
#endif
extern T_USBCFG_UDISKFunc g_usbcfg_udiskProcFnc;

#if 0
/*עdeviceueventϢ*/
static inline int hotplug_parse_register(int device_type, hotplug_parse_func func)
{
    if(device_type < DEV_TYPE_MAX && device_type >= 0)
    {
        usb_hotplug_parse_ptr[device_type] = func;
    }

    return 0;
}

/*עdeviceueventϢ*/
static inline int hotplug_proc_register(int device_type, hotplug_proc_func func)
{
    if(device_type < DEV_TYPE_MAX && device_type >= 0)
    {
        usb_hotplug_proc_ptr[device_type] = func;
    }

    return 0;
}
#endif

long usbcfg_create_msg_queue(void);
long usbcfg_send_message(unsigned short Msg_cmd,unsigned short us_DataLen, unsigned char *pData);
int usbcfg_RecvMsgFromQueue(int msgQueueId, MSG_BUF *pstMsg, long MsgType);
int usbcfg_Handle_Msg_UsbModeFastPowerOff(void *data);
int usbcfg_Handle_Msg_SetUdiskState(void *data);
int usbcfg_Handle_Msg_UsbPlug(void *data);
void usb_initUsbCfgMsg(void);
int usbcfg_getMutex(pthread_mutex_t *mutex_id);
int usbcfg_putMutex(pthread_mutex_t *mutex_id);
int usb_GetUsbPlugState(void);
int usb_isMmcExist(void);
void usb_PlugInProc(int plugType);
void usb_CfgInfoInit(void);
void usb_disable();
void do_usb_enum(e_usbEnum_type type);
void usb_event_analyse(char*buf, int count);
void usbcfg_AppInitProc(void);
void usb_NvGetCdromState(void);

/*sdueventʼ*/
int sd_event_proc(unsigned short sd_msg);
int vsd_event_proc(unsigned short vsd_msg);
void config_console_input(void);
void usb_set_serialid_by_chipid(void);

#if 0
void sdcard_hotplug_init();
void virtual_sdcard_hotplug_init();
#endif

/*udiskע*/
void usb_RegisterUdiskHook(T_USBCFG_UDISKFunc func);
void usb_UnRegisterUdiskHook(void);

#endif

