/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_net.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIȡϢ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/

/*****************************************************************************
*                       ͷļ
*******************************************************************************/
#include <limits.h>

#include "mmi_common.h"
#include "mmi_lcd.h"

/*****************************************************************************
*                       ȫֱ
*******************************************************************************/
#define NETWORKMODE_2G                      3
#define NETWORKMODE_3G_5                    5
#define NETWORKMODE_3G_15                   15
#define NETWORKMODE_4G                      17
#define NETTYPE_NO_SERVICE                  "No Service"
#define NETTYPE_LIMITED_SERVICE             "Limited Service"
#define NETTYPE_NULL                        ""
#define NETTYPE_E                           "E"
#define NETTYPE_G                           "G"
#define NETTYPE_3G                          "3G"
#define NETTYPE_4G                          "4G"
#define NETTYPE_4G_LTE                      "LTE"
#define PPP_STATUS_CONNECTED                "ppp_connected"
#define PPP_STATUS_IPV6_CONNECTED           "ipv6_connected"
#define PPP_STATUS_IPV4_IPV6_CONNECTED      "ipv4_ipv6_connected"

static UINT32 NET_Connect_State  = 0;	//״̬
static UINT32 NET_MutilConnect_State  = 0;	//·PDP״̬״̬
static UINT32 NET_Signal_num = 0;       //źŸ  LCDʹ
static UINT32 NET_Signal_Weak = 0;   	//źű״̬ LEDʹ
static UINT32 NET_Roam_Mode = 0;    	//ģʽ
static UINT32 NET_Socket_State = NET_SOCKET_INACTIVE;     //SOCKETǷ״̬
static UINT32 NET_McuSocket_State = NET_SOCKET_INACTIVE;     //SOCKETǷ״̬

struct list_head g_mmi_socket_queue;//ͽSOCKETϢģ
struct list_head g_mmi_multiconnect_queue;//Ͷ·PDPϢģ

static E_zMmi_Net_Mode s_mmi_net_mode = NET_MODE_DEFAULT;//ʽ
extern E_zMmiShowMode g_showMode;
extern int g_customer_type;
/**********************************************************************************
*:Ƿ״̬
***********************************************************************************/
BOOL mmi_net_connected()
{
	if (NET_Connect_State == 1 && s_mmi_net_mode != NET_MODE_NOSERVICE && s_mmi_net_mode != NET_MODE_LIMITSERVICE) { //e58
		return TRUE;
	}
	return FALSE;
}

/**********************************************************************************
*:ȡϢ
***********************************************************************************/
SINT32 mmi_get_netinfo(UINT32 netinfo)
{
	if (netinfo != 0) {
		T_zMMINetInfo * pNetInfo = (T_zMMINetInfo *)netinfo;
		pNetInfo->net_mode = s_mmi_net_mode;
		pNetInfo->connect_status = (E_zMmi_Net_State)NET_Connect_State;
		pNetInfo->signal_num = NET_Signal_num;
		pNetInfo->signal_weak = NET_Signal_Weak;
		pNetInfo->roam_mode = NET_Roam_Mode;
		pNetInfo->socket_state = NET_Socket_State || NET_McuSocket_State;
	}
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterNetTaskInfoItem()
{
	T_zMMITaskInfoItem netTaskInfoItem = {0};
	netTaskInfoItem.task = MMI_TASK_NET;
	netTaskInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMINetInfo));
	netTaskInfoItem.get_taskinfo_fun = mmi_get_netinfo;
	netTaskInfoItem.get_ledinfo_fun = mmi_getLedNetInfo;
#ifndef DISABLE_LCD
	netTaskInfoItem.get_lcdinfo_fun = mmi_getLcdNetInfo;
#endif
	netTaskInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	mmi_register_taskinfo_item(&netTaskInfoItem);
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterNetSigTaskInfoItem()
{
	T_zMMITaskInfoItem netTaskInfoItem = {0};
	netTaskInfoItem.task = MMI_TASK_NETSIGNAL;
	netTaskInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMINetInfo));
	netTaskInfoItem.get_taskinfo_fun = mmi_get_netinfo;
	netTaskInfoItem.get_ledinfo_fun = mmi_getLedNetSigInfo;
#ifndef DISABLE_LCD
	//netTaskInfoItem.get_lcdinfo_fun = mmi_getLcdNetInfo;
#endif
	netTaskInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	mmi_register_taskinfo_item(&netTaskInfoItem);
	return MMI_SUCCESS;
}

static VOID mmi_set_net_update()
{
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_set_net_update LCD!!!\n");
		mmi_set_update_flag(MMI_TASK_NET);
		mmi_set_update_flag(MMI_TASK_NETSIGNAL);
	}
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode mode = mmi_get_led_mode();
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_set_net_update LED mode=%d!!!\n",mode);
		if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN){//guodian
			mmi_set_update_flag(MMI_TASK_NET);
		}else{
			if (mode != MMI_RESET_MODE && mode != MMI_RESTART_MODE && mode != MMI_POWEROFF_MODE && mode != MMI_IDLE_LEDOFF_MODE && mode != MMI_IDLE_CHG_LEDOFF_MODE
				&& mode != MMI_FAKE_POWEROFF_MODE && mode != MMI_FAKE_POWEROFF_CHARGE_MODE && mode != MMI_IDLE_STANDBY_LEDOFF_MODE) {
				mmi_set_update_flag(MMI_TASK_NET);
				mmi_set_update_flag(MMI_TASK_NETSIGNAL);
			}
		}
	}
}

UINT32 mmi_get_net_state(VOID)
{
	return NET_Connect_State;
}

/**********************************************************************************
:SIMγʱżat_serverϱ״̬н״̬ΪϿ״̬
***********************************************************************************/
VOID mmi_clean_net_state()
{
	s_mmi_net_mode = NET_MODE_NOSERVICE;
	NET_Connect_State = 0;
	mmi_set_net_update();
	mmi_update_net_tip(NET_Connect_State, s_mmi_net_mode);
}

/**********************************************************************************
:״̬
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Connect_Status(VOID *data)
{
	NET_Connect_State = *(UINT32*)data;//״̬0-Ͽ1-  2- 3-Ͽ
	if(1 == NET_MutilConnect_State && 0 == NET_Connect_State){
		slog(MMI_PRINT, SLOG_ERR, "MMI svr_handle_msg_connect_status NET_Connect_State = %d\n", NET_Connect_State);
		return 0;
	}
	slog(MMI_PRINT, SLOG_NORMAL, "MMI svr_handle_msg_connect_status NET_Connect_State = %d\n", NET_Connect_State);
	if (NET_Connect_State == 1 || NET_Connect_State == 0) {
		mmi_set_net_update();
		ipc_send_message(MODULE_ID_MMI, MODULE_ID_FLUXSTAT, MSG_CMD_CHANNEL_CONNECT_STATUS, sizeof(NET_Connect_State), (UCHAR *)&NET_Connect_State, 0);
	}
	mmi_update_net_tip(NET_Connect_State, s_mmi_net_mode);

	return 0;
}
/**********************************************************************************
:ݶ·PDP״̬ƣ,עܻжsocket_proxyж·PDP
***********************************************************************************/
SINT32 zMMI_Handle_Msg_MultiConnect_Status(VOID *data, int src_id)
{	
	NET_MutilConnect_State = *(UINT32*)data;//״̬0-Ͽ1-  	
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_MultiConnect_Status NET_MutilConnect_State = %d\n", NET_MutilConnect_State);

	if(1 == NET_MutilConnect_State){
		mmi_add_list(&g_mmi_multiconnect_queue, src_id);
	}else{
		mmi_del_list(&g_mmi_multiconnect_queue, src_id);
	}
	if(list_empty(&g_mmi_multiconnect_queue)) {
		NET_MutilConnect_State = 0;
	}else {
		NET_MutilConnect_State = 1;
	}
	NET_Connect_State = NET_MutilConnect_State;
	mmi_set_net_update();
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_FLUXSTAT, MSG_CMD_CHANNEL_CONNECT_STATUS, sizeof(NET_Connect_State), (UCHAR *)&NET_Connect_State, 0);

	mmi_update_net_tip(NET_Connect_State, s_mmi_net_mode);

	return 0;
}

/**********************************************************************************
:ʽ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Network_Mode(VOID *data)
{
	SINT32 networkStatus = 0;
	SINT32 networkMode = 0;
	SINT32 netroamMode = 0;
	networkMode = ((T_zAt_SysinfoRes*)data) ->sysMode;	//ʽ
	networkStatus = ((T_zAt_SysinfoRes*)data) ->srvStatus;//Ƿ:0-޷ 1-Ʒ -
	netroamMode = ((T_zAt_SysinfoRes*)data) ->roamStatus;
	slog(MMI_PRINT, SLOG_NORMAL, "MMI svr_handle_msg_network_mode networkStatus = %d,networkMode=%d !!!\n", networkStatus, networkMode);

	if (netroamMode == 1) {
		NET_Roam_Mode = 1;
	} else {
		NET_Roam_Mode = 0;
	}
	if (networkStatus == 0) {
		s_mmi_net_mode = NET_MODE_NOSERVICE;
		mmi_update_net_tip(NET_Connect_State, s_mmi_net_mode);
	} else if (networkStatus == 1) {
		s_mmi_net_mode = NET_MODE_LIMITSERVICE;
		mmi_update_net_tip(NET_Connect_State, s_mmi_net_mode);
	} else {
		if (NETWORKMODE_2G == networkMode) {
			s_mmi_net_mode = NET_MODE_2G;
		} else if ((NETWORKMODE_3G_5 == networkMode) || (NETWORKMODE_3G_15 == networkMode)) {
			s_mmi_net_mode = NET_MODE_3G;
		} else if (NETWORKMODE_4G == networkMode) {
			s_mmi_net_mode = NET_MODE_4G;
		} else {
			s_mmi_net_mode = NET_MODE_NOSERVICE;
		}
		mmi_update_net_tip(NET_Connect_State, s_mmi_net_mode);
	}
	mmi_set_net_update();
	return 0;
}

/**********************************************************************************
:źűʱ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Signal_Num(VOID *data)
{
	UINT32 sig_num = 0;
	sig_num = *(UINT32*)data;
	slog(MMI_PRINT, SLOG_NORMAL, "MMI svr_handle_msg_Signal_Num sig_num = %d\n", sig_num);
	if (sig_num <= 2) {
		NET_Signal_Weak = 1;
	} else {
		NET_Signal_Weak = 0;
	}
	NET_Signal_num = sig_num;
	mmi_set_net_update();
	return 0;

}

/**********************************************************************************
:SIMcard γδ봦
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Simcard_Info(VOID *data)
{
	UINT32 sig_num = 0;
	sig_num = *(UINT32*)data;
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Simcard_Info sig_num = %d\n", sig_num);

	if (g_showMode == MMI_MODE_LCD)
		return 0;

	mmi_clean_net_state();

	return 0;

}
/**********************************************************************************
:SOCKET״̬仯,עܻжsocket_proxySOCKET
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Socket_Status(VOID *data, int src_id)
{
	NET_Socket_State = *(UINT32*)data;//socket״̬0-Ͽ1- 
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Socket_Status NET_Socket_State = %d\n", NET_Socket_State);
	
	if(1 == NET_Socket_State){
		mmi_add_list(&g_mmi_socket_queue, src_id);
	}else{
		mmi_del_list(&g_mmi_socket_queue, src_id);
	}
	if(list_empty(&g_mmi_socket_queue)) {
		NET_Socket_State = NET_SOCKET_INACTIVE;
	}else {
		NET_Socket_State = NET_SOCKET_ACTIVE;
	}
	mmi_set_net_update();
	return 0;
}
/**********************************************************************************
:SOCKET״̬仯
***********************************************************************************/
SINT32 zMMI_Handle_Msg_MCUSocket_Status(VOID *data)
{
	NET_McuSocket_State = *(UINT32*)data;//socket״̬0-Ͽ1- 
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_MCUSocket_Status NET_McuSocket_State = %d\n", NET_McuSocket_State);
	if (NET_McuSocket_State == NET_SOCKET_INACTIVE || NET_McuSocket_State == NET_SOCKET_ACTIVE) {
		mmi_set_net_update();		
	}
	return 0;
}

/**********************************************************************************
:ʼָʾ
***********************************************************************************/
static VOID mmi_init_wan_led(VOID)
{
	CHAR nettype[20] = {0};
	CHAR netstate[20] = {0};
	CHAR signal_num[2] = {0};
	UINT32 tmp_signal_num = 0;

	sc_cfg_get(NV_NETWORK_TYPE, nettype, 20);
	sc_cfg_get(NV_PPP_STATUS, netstate, 20);
	sc_cfg_get(NV_SIGNALBAR, signal_num, 2);
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_init_wan_led nettype = %s netstate = %s signal_num = %s\n", nettype, netstate, signal_num);
	if (!strncmp(nettype, NETTYPE_LIMITED_SERVICE, strlen(NETTYPE_LIMITED_SERVICE))) {
		s_mmi_net_mode = NET_MODE_LIMITSERVICE;
	} else if ((!strncmp(nettype, NETTYPE_G, 1)) || (!strncmp(nettype, NETTYPE_E, 1))) {
		s_mmi_net_mode = NET_MODE_2G;
	} else if (!strncmp(nettype, NETTYPE_3G, 2)) {
		s_mmi_net_mode = NET_MODE_3G;
	} else if (!strncmp(nettype, NETTYPE_4G, 2)) {
		s_mmi_net_mode = NET_MODE_4G;
	} else if (!strncmp(nettype, NETTYPE_4G_LTE, 3)) {
		s_mmi_net_mode = NET_MODE_4G;
	} else {
		s_mmi_net_mode = NET_MODE_NOSERVICE;
	}
	if ((!strncmp(netstate, PPP_STATUS_CONNECTED, strlen(PPP_STATUS_CONNECTED))) || (!strncmp(netstate, PPP_STATUS_IPV6_CONNECTED, strlen(PPP_STATUS_IPV6_CONNECTED))) || (!strncmp(netstate, PPP_STATUS_IPV4_IPV6_CONNECTED, strlen(PPP_STATUS_IPV4_IPV6_CONNECTED)))) {
		NET_Connect_State = 1;
	} else {
		NET_Connect_State = 0;
	}
	if (strlen(signal_num) != 0 && (atoi(signal_num)) <= 2) {
		NET_Signal_Weak = 1;
	} else {
		NET_Signal_Weak = 0;
	}
	//kw 3
	tmp_signal_num = (strlen(signal_num) == 0 ? 0 : atoi(signal_num));
	if (tmp_signal_num > INT_MAX-1) {
		tmp_signal_num = 0;
		slog(MMI_PRINT, SLOG_ERR, "MMI signal_num = %s\n", signal_num);
	}
	NET_Signal_num = tmp_signal_num;
	mmi_update_net_tip(NET_Connect_State, s_mmi_net_mode);
	mmi_set_net_update();
}

/**********************************************************************************
:ָʾƳʼ
***********************************************************************************/
VOID mmi_net_init(VOID)
{
	INIT_LIST_HEAD(&g_mmi_socket_queue);
	INIT_LIST_HEAD(&g_mmi_multiconnect_queue);
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_net_Led_Init finish !!\n");
}

