/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_time.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIȡʱϢ
*        
*  汾      V1.0
*    2015-2-3
*  ˵  
*
******************************************************************************/
#include "mmi_lcd.h"

static BOOL s_mmi_time_mode = TRUE;

static char s_mmi_hour[4] = {0};
static char s_mmi_minute[4] = {0};

/**********************************************************************************
*:ȡʱϢ
***********************************************************************************/
SINT32 mmi_get_timeTrafficinfo(UINT32 timeinfo)
{
	if (timeinfo != 0) {
		T_zMMITimeInfo * pTimeInfo = (T_zMMITimeInfo *)timeinfo;
		pTimeInfo->mode = s_mmi_time_mode;
		pTimeInfo->hour = s_mmi_hour;
		pTimeInfo->minute = s_mmi_minute;
	}
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterTimeTaskInfoItem(VOID)
{
	T_zMMITaskInfoItem timeTaskInfoItem = {0};

	timeTaskInfoItem.task = MMI_TASK_TIME;
	timeTaskInfoItem.taskinfo = malloc(sizeof(T_zMMITimeInfo));
	timeTaskInfoItem.get_taskinfo_fun = mmi_get_timeTrafficinfo;
	timeTaskInfoItem.get_lcdinfo_fun = mmi_getLcdTimeInfo;
	//timeAppInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&timeTaskInfoItem);
	return MMI_SUCCESS;
}
/**********************************************************************************
:ʱⶨʱ 1S
***********************************************************************************/

static VOID * mmi_time_check_timer_cb(VOID *arg)
{
	sc_cfg_get(HOUR_NV, s_mmi_hour, 4);
	sc_cfg_get(MINUTE_NV, s_mmi_minute, 4);
	mmi_set_update_flag(MMI_TASK_TIME);
}

static VOID mmi_time_check_timer_create(VOID)
{
	int ret = -1;
	ret = sc_timer_create(SET_TIME_CHECK_TIMER, TIMER_FLAG_RESTART, SET_TIME_CHECK_TIME, &mmi_time_check_timer_cb, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, " MMI mmi_time_check_timer_create FAILED!!\n");
	}
}


VOID mmi_init_time()
{
	mmi_time_check_timer_create();
}
