/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spi_nand_devices.c
* File Mark:
* Description:  
* Others:
* Version:  
* Author:  
* Date:   

* History 1:
*     Date: 
*     Version:
*     Author: 
*     Modification:
* History 2:
**********************************************************************/

#include <malloc.h> 
#include <errno.h>
#include <asm/io.h> 
#include <linux/mtd/mtd.h>
#include <asm-generic/ioctl.h>
#include <config.h>
#include <common.h>
#include <command.h>
#include <asm/arch/nand.h> 
#include <linux/mtd/nand.h>
#include <asm/arch/lsp_crpm.h>
#include <drvs_gpio.h>
#include "spi_nand.h"

unsigned char  g_maf_id = 0;
unsigned char  g_dev_id = 0;

static struct nand_ecclayout nand_gd_oob_64 = {
	.eccbytes = 0,
	.oobfree = {{4,12},{20,12},{36,12},{52,12}}
};

static struct nand_ecclayout nand_gd_oob_128 = {
	.eccbytes = 64,
	.oobfree = {{4,12},{20,12},{36,12},{52,12}}
};

static struct nand_ecclayout nand_gd5f4gm8_oob_128 = {
	.eccbytes = 64,
	.oobfree = {{2,62}}
};

static struct nand_ecclayout nand_gd_oob_256 = {
	.eccbytes = 128,
	.oobfree = {{2,2},{16,4},{32,4},{48,4},{64,4},{80,4},{96,4},{112,4}}
};

static struct nand_ecclayout nand_paragon_oob_128 =
{
    .eccbytes = 52,
	.oobfree = {{4,2}, {19,2}, {34,2}, {49,2}}
};
static struct nand_ecclayout nand_heyangtek_oob_128 =
{
    .eccbytes = 56,
	.oobfree = {{2,16}, {32,18}, {64,18}, {96,18}}
};

 static struct nand_ecclayout nand_winbond_oob_64= {
	 .eccbytes = 32,
	 .oobfree = {{4,4}, {20,4}, {36,4}, {52,4}}
 };
 static struct nand_ecclayout nand_Toshiba_OOB_64= {
	 .eccbytes = 64,
	 .oobfree = {{2,62}}
 };
 
static struct nand_ecclayout nand_zetta_oob_64= {
	 .eccbytes = 32,
	 .oobfree = {{4,4}, {20,4}, {36,4}, {52,4}}
 };

static struct nand_ecclayout nand_dosilicon_oob_64= {
	 .eccbytes = 32,
	 .oobfree = {{4,4}, {20,4}, {36,4}, {52,4}}
 };

static struct nand_ecclayout nand_dosilicon_oob_128= {
	 .eccbytes = 64,
	 .oobfree = {{2,62}}
 };

static struct nand_ecclayout nand_fudanwei_oob_128= {
	.eccbytes = 64,
	.oobfree = {{2,62}}
 };

static struct nand_ecclayout nand_hosin_oob_64= {
	 .eccbytes = 32,
	 .oobfree = {{4,4}, {20,4}, {36,4}, {52,4}}
 };

static struct nand_ecclayout nand_emst_oob_64= {
	 .eccbytes = 32,
	 .oobfree = {{4,4}, {20,4}, {36,4}, {52,4}}
 };

static struct nand_ecclayout nand_foresee_oob_64= {
	 .oobfree = {{2,62}}
 };

static struct nand_ecclayout nand_micron_oob_128= {
	.eccbytes = 64,
	.oobfree = {{32,8}, {40,8}, {48,8}, {56,8}}
 };

 static struct nand_ecclayout nand_esmt_oob_256= {
	.oobfree = {{64,64}}
 };

 static struct nand_ecclayout nand_xtx_oob_256= {
	 .eccbytes = 192,
	 .oobfree = {{2,62}}
  };

 static struct nand_ecclayout nand_unim_oob_64= {
    .oobfree = {{2,62}}
 };

static void	spi_nand_winbond_init(struct spi_nand_info *spi_nand)
{
	uint8_t dev_id = spi_nand->para->device_id;	
	struct nand_chip *chip = spi_nand->nand;
	struct mtd_info *mtd = spi_nand->mtd;
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
    uint8_t feature;
	int ret;

	if(mtd->oobsize==64 && mtd->writesize==2048)
	{
		chip->ecc.layout =&nand_winbond_oob_64;
	}

	if(dev_id == NAND_DEVID_WINBOND_2G)
	{
		if(ctrl->switch_die(1))
			BUG();
		spi_nand_common_init(spi_nand);
		ctrl->get_feature(REG_FEATURE, &feature);
		feature |= REG_BUF_WINBOND;
	    ret = ctrl->set_feature(REG_FEATURE, &feature);
	    if ( ret != 0 )
	    {
	        printf("[SPI-NAND][spi_fc_set_winbond]\n");
	        BUG();
	    }	

		if(ctrl->switch_die(0))
			BUG();
	}

	spi_nand_common_init(spi_nand);
	ctrl->get_feature(REG_FEATURE, &feature);
	feature |= REG_BUF_WINBOND;
    ret = ctrl->set_feature(REG_FEATURE, &feature);
    if ( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_set_winbond]\n");
        BUG();
    }	
	
}

static void	spi_nand_toshiba_init(struct spi_nand_info *spi_nand)
{
	struct nand_chip *chip = spi_nand->nand;
	struct mtd_info *mtd = spi_nand->mtd;
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
    uint8_t feature;
	int ret;

	if(mtd->oobsize==64 && mtd->writesize==2048)
	{
		chip->ecc.layout =&nand_Toshiba_OOB_64;
	}

	ctrl->get_feature(REG_FEATURE, &feature);
	feature |= HSE_EN;
    ret = ctrl->set_feature(REG_FEATURE, &feature);
    if ( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_set_toshiba]\n");
        BUG();
    }		
}

inline unsigned int spi_nand_get_trans_mode(int rw_mode)
{
	if(WRITE_TRANSFER_MODE == rw_mode)
	{
		if(g_maf_id == NAND_MFR_TOSHIBA)
			return SINGLE_MODE;
		else
			return WR_MODE;
	}		
	else
	{
		if((g_maf_id == NAND_MFR_TOSHIBA) 
			|| (g_maf_id == NAND_MFR_ZETTA)
			|| (g_maf_id == NAND_MFR_DOSILICON)
			|| (g_maf_id == NAND_MFR_PARAGON)
			|| (g_maf_id == NAND_MFR_GIGADEVICE)
			|| (g_maf_id == NAND_MFR_HOSIN)
			||((g_maf_id == NAND_MFR_EMST) && (g_dev_id == NAND_DEVID_EMST_F50D1G41LB_1G))
			|| (g_maf_id == NAND_MFR_FORESEE)
			|| (g_maf_id == NAND_MFR_XTX)
			|| (g_maf_id == NAND_MFR_UNIM)
			|| (g_maf_id == NAND_MFR_MICRON))
			return RDX4_MODE;
		else
			return RD_MODE;
	}		
}


void spi_nand_special_init(struct spi_nand_info *spi_nand)
{
	uint8_t maf_id = spi_nand->para->manuf_id;
	uint8_t dev_id = spi_nand->para->device_id;	
	struct nand_chip *chip = spi_nand->nand;
	struct mtd_info *mtd = spi_nand->mtd;

	spi_nand->pages_per_die = (spi_nand->para->pages_per_block
								*spi_nand->para->block_num)
								/spi_nand->para->die_num;
	g_maf_id = maf_id;
	g_dev_id = dev_id;

	switch(maf_id)
	{
	case NAND_MFR_HEYANGTEK:
		if(mtd->oobsize == 128 && mtd->writesize==2048)
		{
			chip->bbt_td->offs = BBT_INFO_OOB_OFFSET_HEYANGTEK;
			chip->bbt_td->veroffs = BBT_INFO_OOB_VER_OFFSET_HEYANGTEK;
			chip->bbt_md->offs = BBT_INFO_OOB_OFFSET_HEYANGTEK;
			chip->bbt_md->veroffs = BBT_INFO_OOB_VER_OFFSET_HEYANGTEK;
			chip->ecc.layout =&nand_heyangtek_oob_128;
		}
		break;		
	case NAND_MFR_PARAGON:
		if(dev_id == NAND_DEVID_FDANWEI_1G)
		{
			if(mtd->oobsize==128 && mtd->writesize==2048)
			{
				chip->ecc.layout =&nand_fudanwei_oob_128;
			}
		}
		else
		{
			if(mtd->oobsize == 128 && mtd->writesize==2048)
		    {
   				chip->bbt_td->offs = BBT_INFO_OOB_OFFSET_PARAGON;
				chip->bbt_td->veroffs = BBT_INFO_OOB_VER_OFFSET_PARAGON;
				chip->bbt_md->offs = BBT_INFO_OOB_OFFSET_PARAGON;
				chip->bbt_md->veroffs = BBT_INFO_OOB_VER_OFFSET_PARAGON;
				chip->ecc.layout =&nand_paragon_oob_128;
		    }
			else
			{
				BUG();
			}				
		}		
		break;	
	case NAND_MFR_GIGADEVICE:
		if(dev_id == NAND_DEVID_EMST_F50D1G41LB_1G)
		{
			if(mtd->oobsize==64 && mtd->writesize==2048)
			{
				chip->ecc.layout =&nand_emst_oob_64;
			}
		}
		else if(dev_id == NAND_DEVID_GD5F4GM8)
		{
			chip->ecc.layout =&nand_gd5f4gm8_oob_128;
		}
		else
		{
			if(mtd->oobsize==64 && mtd->writesize==2048)
				chip->ecc.layout = &nand_gd_oob_64;		
			else if(mtd->oobsize==128 && mtd->writesize==2048)
				chip->ecc.layout = &nand_gd_oob_128;
			else if(mtd->oobsize==256 && mtd->writesize==4096)
				chip->ecc.layout = &nand_gd_oob_256;
			else
				BUG();
		}
		break;
	case NAND_MFR_WINBOND:
		spi_nand_winbond_init(spi_nand);
		break;		
	case NAND_MFR_TOSHIBA:
		spi_nand_toshiba_init(spi_nand);
		break;
	case NAND_MFR_ZETTA:
		if(mtd->oobsize==64 && mtd->writesize==2048)
		{
			chip->ecc.layout =&nand_zetta_oob_64;
		}
		break;
	case NAND_MFR_DOSILICON:
		if(mtd->oobsize==64 && mtd->writesize==2048)
			chip->ecc.layout =&nand_dosilicon_oob_64;
		else if(mtd->oobsize==128 && mtd->writesize==2048)
			chip->ecc.layout = &nand_dosilicon_oob_128;
		else
			BUG();
		break;
	case NAND_MFR_HOSIN:
		if(mtd->oobsize==64 && mtd->writesize==2048)
		{
			chip->ecc.layout =&nand_hosin_oob_64;
		}
		break;	
	case NAND_MFR_FORESEE:
		if(mtd->oobsize==64 && mtd->writesize==2048)
		{
			chip->ecc.layout =&nand_foresee_oob_64;
		}
		break;
	case NAND_MFR_MICRON:
		if(dev_id == 0x35)
		{
            if(mtd->oobsize==256 && mtd->writesize==4096)
			{
				chip->ecc.layout =&nand_esmt_oob_256;
			}
		}
		else
		{
            if(mtd->oobsize==128 && mtd->writesize==2048)
			{
				chip->ecc.layout =&nand_micron_oob_128;
			}
		}
		break;
	case NAND_MFR_XTX:
		if(mtd->oobsize==256 && mtd->writesize==4096)
		{
			chip->ecc.layout =&nand_xtx_oob_256;
		}
		break;
	case NAND_MFR_UNIM:
		if(mtd->oobsize==64 && mtd->writesize==2048)
		{
			chip->ecc.layout =&nand_unim_oob_64;
		}
		break;
	default:
		break;
	}

}

