#ifndef __LYNQ_UBOOT_NV_CFG__H__
#define __LYNQ_UBOOT_NV_CFG__H__

#define RAS_BIT_LEN 1024
#define RSA_BYTE_LEN (RAS_BIT_LEN / 8)
#define RSA_U32_LEN (RSA_BYTE_LEN / sizeof(u32))
#define LYNQ_NV_CFG_SIGN_LEN RSA_BYTE_LEN
#define LYNQ_NV_CFG_PUBLICKEY_LEN (RSA_BYTE_LEN + sizeof(u32))

#pragma pack(1)

struct lynq_nv_cfg_header
{
    unsigned short magic_flag;
    unsigned short valid_flag:1;
    unsigned short content_len:15;
};
struct lynq_nv_cfg
{
    struct lynq_nv_cfg_header head;
    unsigned char content[4];
    struct lynq_nv_cfg_header tail;
    unsigned int lynq_reserved[1];
};
#pragma pack()

static const char lynq_nv_cfg_version[] = "T106_CN_20240912";
static const char lynq_nv_cfg_value[] = {
    '\x55', '\xaa', '\x09', '\x00', '\xc0', '\x80', '\x80', '\x00', '\xaa', '\x55', '\x09', '\x00', '\x01', '\x00', '\x5c', '\x28'
};

static const char lynq_nv_cfg_bitmap[] = {
    '\xc0', '\x80', '\x80', '\x80'
};
static const char oem_nv_cfg_bitmap[] = {
    '\x80', '\x80', '\x80', '\x80'
};
static const char lynq_nv_cfg_publickey[] = {
    '\xc0', '\xee', '\xaf', '\x8d', '\x4e', '\x5f', '\x20', '\x48', '\xfa', '\x64', '\xb2', '\x53', '\xde', '\x46', '\x84', '\xdd', 
    '\xdf', '\xbe', '\xb2', '\x10', '\xbb', '\x15', '\x29', '\xe4', '\xd2', '\xc0', '\x57', '\x23', '\x66', '\x73', '\xbc', '\x6d', 
    '\xc2', '\x3f', '\x4d', '\xaa', '\x8e', '\x5b', '\x37', '\xb2', '\x60', '\xd4', '\x8e', '\x2b', '\x4b', '\x82', '\x25', '\x1f', 
    '\x29', '\x1c', '\x9b', '\xe8', '\x1f', '\x70', '\x6c', '\x09', '\x0f', '\x2e', '\x48', '\x14', '\xb6', '\xc7', '\x06', '\xaf', 
    '\x5b', '\xf0', '\xd0', '\x42', '\x3f', '\xb6', '\xcf', '\xec', '\x92', '\xd6', '\xc3', '\x94', '\x69', '\x42', '\x86', '\xff', 
    '\x4e', '\x5a', '\xd7', '\x8b', '\x91', '\x10', '\xe2', '\x7e', '\xcb', '\x2a', '\xaa', '\x6b', '\x78', '\x4a', '\x02', '\xd3', 
    '\xfc', '\xdf', '\x4d', '\xd0', '\x04', '\x1e', '\x2b', '\xa9', '\x1f', '\x84', '\xfc', '\xe2', '\x01', '\x42', '\xc7', '\x29', 
    '\x6d', '\x76', '\x63', '\xba', '\xc8', '\x3b', '\x99', '\xf1', '\x50', '\x25', '\xf0', '\x4a', '\x6b', '\x61', '\xd1', '\x49', 
    '\x01', '\x00', '\x01', '\x00'
};
static const char lynq_nv_cfg_sign[] = {
    '\x12', '\xdb', '\x92', '\x5b', '\xd0', '\x5d', '\x6c', '\x53', '\xc5', '\x23', '\x64', '\xed', '\x0f', '\x66', '\x95', '\x10', 
    '\xbe', '\x6a', '\x33', '\xfa', '\x36', '\x71', '\x79', '\x16', '\xca', '\x90', '\xd7', '\x68', '\xa5', '\xd3', '\x0b', '\xda', 
    '\x4d', '\xf2', '\x27', '\x34', '\x13', '\xc6', '\xa9', '\x57', '\x62', '\xed', '\xbc', '\xe1', '\xca', '\xf3', '\x45', '\x74', 
    '\xc7', '\x14', '\x83', '\xf9', '\x97', '\x6c', '\x0a', '\x84', '\x6f', '\xb2', '\x41', '\x58', '\xf7', '\x85', '\x72', '\x76', 
    '\x99', '\x21', '\x6d', '\x34', '\xaa', '\x18', '\xe6', '\xe5', '\xf2', '\x2c', '\x67', '\xd8', '\xc8', '\xa8', '\x5c', '\x79', 
    '\xbf', '\x88', '\x02', '\x02', '\x5f', '\x00', '\xec', '\xf2', '\x64', '\x4b', '\xcb', '\x9f', '\x19', '\xc7', '\xfc', '\xf7', 
    '\xfb', '\x09', '\x8c', '\xc8', '\x10', '\x58', '\xa2', '\x1e', '\x01', '\x75', '\xd8', '\xac', '\x7a', '\xd9', '\xcc', '\x22', 
    '\x08', '\xb0', '\xfa', '\xc1', '\x8b', '\x4f', '\xda', '\x76', '\xe4', '\x92', '\xb9', '\x5f', '\x11', '\x64', '\xb0', '\x48'
};

#endif
