#include "drvs_general.h"
#include <oss_clib.h>
#include <oss_kernel.h>
#include "drvs_ramlog.h"
#include "drvs_voiceprocess.h"
#include "hal_dtmf_detect.h"

#define MAX_BINS 8
#define GOERTZEL_N 160


extern Dtmf_Info dtmfTxInfo;
extern Dtmf_Info dtmfRxInfo;

//ڼ
extern T_zDrvVoice_GbVar g_voiceVar;

T_DrvDtmf_Detect_Opt gDrvDtmf_Detect_Obj = {0};

typedef struct
{
	UINT8 currentDigit;
    char digit_char;
    SINT32 maxval;
    SINT32 pm;
    SINT32 sample_count;

    SINT32 q1[MAX_BINS];
    SINT32 q2[MAX_BINS];
    SINT32 r[MAX_BINS];

    SINT32 row;
    SINT32 col;

    SINT32 bDetected;
    SINT32 pre_detected;
    SINT32 pre_row;
    SINT32 pre_col;
}DtmfDetect;

DtmfDetect dtmf_tx = {.q1 = {0}, .q2 = {0}, .r = {0}, .pre_detected = -1, .pre_row = -1, .pre_col = -1};
DtmfDetect dtmf_rx = {.q1 = {0}, .q2 = {0}, .r = {0}, .pre_detected = -1, .pre_row = -1, .pre_col = -1};

char *row_col_ascii_codes[4][4] = {//ַҪָ
    {"1", "2", "3", "A"},
    {"4", "5", "6", "B"},
    {"7", "8", "9", "C"},
    {"*", "0", "#", "D"}
};

SINT64 coefs_8k[MAX_BINS] = {55960, 53912, 51402, 48438, 38146, 32650, 26170, 18630};//8KHz
SINT64 coefs_16k[MAX_BINS] = {63096, 62563, 61902, 61112, 58287, 56721, 54818, 52516};//16KHz

SINT32 halDtmfRx_report(char *dtmf_string, unsigned char string_len)
{   
    if((dtmf_string == NULL) || ((string_len == 0) || (string_len > 29)))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"halDtmfRx_report err! dtmf_string=0x%p, string_len=%d\n", dtmf_string, string_len);
        return DRV_ERR_NOT_SUPPORTED;   
    }
    if(gDrvDtmf_Detect_Obj.drv_dtmfrx_report_cb != NULL)
    {
         gDrvDtmf_Detect_Obj.drv_dtmfrx_report_cb(dtmf_string, string_len);
         return DRV_SUCCESS;
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"halDtmfRx_report err! gDrvDtmf_Detect_Obj.drv_dtmfrx_report_cb=NULL\n");
        return DRV_ERR_NOT_SUPPORTED;
    }
}

SINT32 halDtmfTx_report(char *dtmf_string, unsigned char string_len)
{   
    if((dtmf_string == NULL) || ((string_len == 0) || (string_len > 29)))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"halDtmfTx_report err! dtmf_string=0x%p, string_len=%d\n", dtmf_string, string_len);
        return DRV_ERR_NOT_SUPPORTED;   
    }
    if(gDrvDtmf_Detect_Obj.drv_dtmftx_report_cb != NULL)
    {
        gDrvDtmf_Detect_Obj.drv_dtmftx_report_cb(dtmf_string, string_len);
        return DRV_SUCCESS;
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"halDtmfTx_report err! gDrvDtmf_Detect_Obj.drv_dtmftx_report_cb=NULL\n");
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*---------------------------------------------------------------------------*
 * о compare
   3ȶź
    ʵʵDTMFźӦһȵʱ䡣
   Ӧ⵽λͬһźʱΪźŴ
*                                    *
 *---------------------------------------------------------------------------*/
SINT32 compare(SINT32 a, SINT32 b, SINT32 x, SINT32 y)
{
    if ((a==x)&&(b==y))
    {
        return 1;

    }
    else
    {
        return 0;
    }
}

/*----------------------------------------------------------------------------
 *  post_testing
 * This is where we look at the bins and decide if we have a valid signal.
 *----------------------------------------------------------------------------
 */
SINT32 post_testing_tx()
{
    SINT32 i;
    int lowgroup=-1;
    int highgroup=-1;
    //SINT32 pm;

    /* Find the largest in the group. */
    dtmf_tx.pm = 0;
    for ( i = 0; i < MAX_BINS; i++ )
    {
        if ( dtmf_tx.r[i] > dtmf_tx.pm )
        {
            dtmf_tx.pm = dtmf_tx.r[i];
        }
    }
    
    if(dtmf_tx.pm < 8000000)//4*10^9/2^16=61035
    {
        return 0;
    }
    
    for (i = 0; i < MAX_BINS; i++) {
		if (8*dtmf_tx.r[i] < dtmf_tx.pm)
			continue;  /* ignore */
		if (4*dtmf_tx.r[i] < dtmf_tx.pm) {
			lowgroup = -1;
			highgroup = -1;
			break;  /* noise in between */ //ֻҪһP(P>=12.5%Pm && P<25%Pm)ûʶdtmf
		}
		/* good level found. This is allowed only one time per group */
		if (i < 4) { //ĸƵӦֻһ>=25%Pm<12.5%Pm
			/* lowgroup */
			if (lowgroup >= 0) {
				/* Bad. Another tone found. */ //PmӦƵƵС12.5%Pm
				lowgroup = -1;                 //ҸƵһ>=25%PmҸƵ<12.5%Pm
				break;
			} else
				lowgroup = i;
		} else {
			/* higroup */
			if (highgroup >= 0) {
				/* Bad. Another tone found. */ //Ƶڽӽж޷ʶdtmf
				highgroup = -1;
				break;
			} else
				highgroup = i;
		}
	}
    if (lowgroup >= 0 && highgroup >= 0)
    {
        dtmf_tx.row=lowgroup;
        dtmf_tx.col=highgroup;
        return 1;
    }
    return 0;
}
SINT32 post_testing_rx()
{
    SINT32 i;
    int lowgroup=-1;
    int highgroup=-1;
    //SINT32 pm;

    /* Find the largest in the group. */
    dtmf_rx.pm = 0;
    for ( i = 0; i < MAX_BINS; i++ )
    {
        if ( dtmf_rx.r[i] > dtmf_rx.pm )
        {
            dtmf_rx.pm = dtmf_rx.r[i];
        }
    }
    
    if(dtmf_rx.pm < 400000)
    {
        return 0;
    }
    
    for (i = 0; i < MAX_BINS; i++) {
		if (8*dtmf_rx.r[i] < dtmf_rx.pm)
			continue;  /* ignore */
		if (4*dtmf_rx.r[i] < dtmf_rx.pm) {
			lowgroup = -1;
			highgroup = -1;
			break;  /* noise in between */ //ֻҪһP(P>=12.5%Pm && P<25%Pm)ûʶdtmf
		}
		/* good level found. This is allowed only one time per group */
		if (i < 4) { //ĸƵӦֻһ>=25%Pm<12.5%Pm
			/* lowgroup */
			if (lowgroup >= 0) {
				/* Bad. Another tone found. */ //PmӦƵƵС12.5%Pm
				lowgroup = -1;                 //ҸƵһ>=25%PmҸƵ<12.5%Pm
				break;
			} else
				lowgroup = i;
		} else {
			/* higroup */
			if (highgroup >= 0) {
				/* Bad. Another tone found. */ //Ƶڽӽж޷ʶdtmf
				highgroup = -1;
				break;
			} else
				highgroup = i;
		}
	}
    if (lowgroup >= 0 && highgroup >= 0)
    {
        dtmf_rx.row=lowgroup;
        dtmf_rx.col=highgroup;
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------
 *  goertzel
 *----------------------------------------------------------------------------
 */
SINT32 goertzel_tx( int sample )
{
    SINT32 q0;
    SINT32 i;
    SINT32 bDetected = 0;
    dtmf_tx.sample_count++;
    
    if(dtmfTxInfo.fs == 8000)
    {
        for ( i=0; i<MAX_BINS; i++ )
        {
            q0 = ((coefs_8k[i] * dtmf_tx.q1[i]) >> 15) - dtmf_tx.q2[i] + sample;
            dtmf_tx.q2[i] = dtmf_tx.q1[i];
            dtmf_tx.q1[i] = q0;
        }
    }
    else if(dtmfTxInfo.fs == 16000)
    {
        for ( i=0; i<MAX_BINS; i++ )
        {
            q0 = ((coefs_16k[i] * dtmf_tx.q1[i]) >> 15) - dtmf_tx.q2[i] + sample;
            dtmf_tx.q2[i] = dtmf_tx.q1[i];
            dtmf_tx.q1[i] = q0;
        }
    }

    if (dtmf_tx.sample_count == GOERTZEL_N)
    {
        for ( i=0; i<MAX_BINS; i++ )
        {
            dtmf_tx.q1[i] >>= 8;
            dtmf_tx.q2[i] >>= 8;
        }
        
        if(dtmfTxInfo.fs == 8000)
        {
            for ( i=0; i<MAX_BINS; i++ )
            {
                dtmf_tx.r[i] = (dtmf_tx.q1[i] * dtmf_tx.q1[i]) + (dtmf_tx.q2[i] * dtmf_tx.q2[i]) - (((coefs_8k[i] * dtmf_tx.q1[i]) >> 15) * dtmf_tx.q2[i]);
                dtmf_tx.q1[i] = 0;
                dtmf_tx.q2[i] = 0;
            }
        }
        else if(dtmfTxInfo.fs == 16000)
        {
            for ( i=0; i<MAX_BINS; i++ )
            {
                dtmf_tx.r[i] = (dtmf_tx.q1[i] * dtmf_tx.q1[i]) + (dtmf_tx.q2[i] * dtmf_tx.q2[i]) - (((coefs_16k[i] * dtmf_tx.q1[i]) >> 15) * dtmf_tx.q2[i]);
                dtmf_tx.q1[i] = 0;
                dtmf_tx.q2[i] = 0;
            }
        }
        bDetected = post_testing_tx();
        dtmf_tx.sample_count = 0;
    }
    return bDetected;
}
SINT32 goertzel_rx( int sample )
{
    SINT32 q0;
    SINT32 i;
    SINT32 bDetected = 0;
    dtmf_rx.sample_count++;
    
    if(dtmfRxInfo.fs == 8000)
    {
        for ( i=0; i<MAX_BINS; i++ )
        {
            q0 = ((coefs_8k[i] * dtmf_rx.q1[i]) >> 15) - dtmf_rx.q2[i] + sample;
            dtmf_rx.q2[i] = dtmf_rx.q1[i];
            dtmf_rx.q1[i] = q0;
        }
    }
    else if(dtmfRxInfo.fs == 16000)
    {
        for ( i=0; i<MAX_BINS; i++ )
        {
            q0 = ((coefs_16k[i] * dtmf_rx.q1[i]) >> 15) - dtmf_rx.q2[i] + sample;
            dtmf_rx.q2[i] = dtmf_rx.q1[i];
            dtmf_rx.q1[i] = q0;
        }
    }

    if (dtmf_rx.sample_count == GOERTZEL_N)
    {
        for ( i=0; i<MAX_BINS; i++ )
        {
            dtmf_rx.q1[i] >>= 8;
            dtmf_rx.q2[i] >>= 8;
        }
        
        if(dtmfRxInfo.fs == 8000)
        {
            for ( i=0; i<MAX_BINS; i++ )
            {
                dtmf_rx.r[i] = (dtmf_rx.q1[i] * dtmf_rx.q1[i]) + (dtmf_rx.q2[i] * dtmf_rx.q2[i]) - (((coefs_8k[i] * dtmf_rx.q1[i]) >> 15) * dtmf_rx.q2[i]);
                dtmf_rx.q1[i] = 0;
                dtmf_rx.q2[i] = 0;
            }
        }
        else if(dtmfRxInfo.fs == 16000)
        {
            for ( i=0; i<MAX_BINS; i++ )
            {
                dtmf_rx.r[i] = (dtmf_rx.q1[i] * dtmf_rx.q1[i]) + (dtmf_rx.q2[i] * dtmf_rx.q2[i]) - (((coefs_16k[i] * dtmf_rx.q1[i]) >> 15) * dtmf_rx.q2[i]);
                dtmf_rx.q1[i] = 0;
                dtmf_rx.q2[i] = 0;
            }
        }
        bDetected = post_testing_rx();
        dtmf_rx.sample_count = 0;
    }
    return bDetected;
}

SINT32 detectDTMF_rx( UINT8 *tempbuffer, UINT8 *prebuffer)
{
    SINT32 i = 0;
    SHORT *pBuffer = tempbuffer;//ֵ
    UINT8 newDigit = 0;
    
    if(prebuffer == NULL)
    {
        return 0;
    }
    if(pBuffer == NULL)
    {
        return 0;
    }
    
    zOss_Memset(prebuffer,0,320);
    zOss_Memcpy(prebuffer, tempbuffer,320);
    if(dtmf_rx.pre_detected > 0)
    {
        zOss_Memset(prebuffer, 0, dtmf_rx.pre_detected*sizeof(SHORT));
    }
    dtmf_rx.pre_detected = -1;
    
    while(i < 160)
    {
        int j = 0;
        for(; j < GOERTZEL_N; j++)
        {
            dtmf_rx.bDetected = goertzel_rx(pBuffer[i+j]);
        }

        if(dtmf_rx.bDetected)
        {
            dtmf_rx.bDetected = compare(dtmf_rx.pre_row, dtmf_rx.pre_col, dtmf_rx.row, dtmf_rx.col);

            if(dtmf_rx.bDetected == 0 && i ==120)
            {
                zOss_Memset(prebuffer + 120, 0, 40*sizeof(SHORT));
                newDigit = 1;
                dtmf_rx.digit_char = *row_col_ascii_codes[dtmf_rx.row][dtmf_rx.col-4];
                dtmf_rx.maxval = dtmf_rx.pm;
            }

            if(dtmf_rx.bDetected == 1)
            {
                zOss_Memset(prebuffer, 0, 160*sizeof(SHORT));
                dtmf_rx.pre_detected = i;
                newDigit = 1;
                dtmf_rx.digit_char = *row_col_ascii_codes[dtmf_rx.row][dtmf_rx.col-4];
                dtmf_rx.maxval = dtmf_rx.pm;
            } 
            dtmf_rx.pre_row = dtmf_rx.row;
            dtmf_rx.pre_col = dtmf_rx.col;
        }
        i = i + 40;
    }

    if(newDigit != dtmf_rx.currentDigit)
    {
        dtmf_rx.currentDigit = newDigit;
        if(!dtmf_rx.currentDigit)
        {
            //ɿʱ400000ırowcolrow_col_ascii_codesһ׼ȷ
            //zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"DTMFDETECT RX row_col_ascii_codes[%d][%d] = %s\n", dtmf_rx.row, dtmf_rx.col - 4, row_col_ascii_codes[dtmf_rx.row][dtmf_rx.col-4]);
            //printk("DTMF RX detect digit_char = %c, maxval= %ld\n", dtmf_rx.digit_char, dtmf_rx.maxval);//ɿʱϱַɿǰĽ׼ȷ
            halDtmfRx_report(&dtmf_rx.digit_char, 1);
        }
    }
    return 0;
}

SINT32 detectDTMF_tx( UINT8 *tempbuffer, UINT8 *prebuffer)
{
    SINT32 i = 0;
    SHORT *pBuffer = tempbuffer;//ֵ
    UINT8 newDigit = 0;
    
    if(prebuffer == NULL)
    {
        return 0;
    }
    if(pBuffer == NULL)
    {
        return 0;
    }
    
    zOss_Memset(prebuffer,0,320);
    zOss_Memcpy(prebuffer, tempbuffer,320);
    if(dtmf_tx.pre_detected > 0)
    {
        zOss_Memset(prebuffer, 0, dtmf_tx.pre_detected*sizeof(SHORT));
    }
    dtmf_tx.pre_detected = -1;
    
    while(i < 160)
    {
        int j = 0;
        for(; j < GOERTZEL_N; j++)
        {
            dtmf_tx.bDetected = goertzel_tx(pBuffer[i+j]);
        }

        if(dtmf_tx.bDetected)
        {
			
            dtmf_tx.bDetected = compare(dtmf_tx.pre_row, dtmf_tx.pre_col, dtmf_tx.row, dtmf_tx.col);

            if(dtmf_tx.bDetected == 0 && i ==120)
            {
                zOss_Memset(prebuffer + 120, 0, 40*sizeof(SHORT));
                newDigit = 1;
                dtmf_tx.digit_char = *row_col_ascii_codes[dtmf_tx.row][dtmf_tx.col-4];
                dtmf_tx.maxval = dtmf_tx.pm;
            }

            if(dtmf_tx.bDetected == 1)
            {
			    if(g_voiceVar.vpI2sStatus == VP_I2S_INUSE)
			    {
                    g_voiceVar.muteCount = 20;//ⰴʱ
					zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "detectDTMF_tx g_voiceVar.muteCount=20\n");
                }
			
                zOss_Memset(prebuffer, 0, 160*sizeof(SHORT));
                dtmf_tx.pre_detected = i;
                newDigit = 1;
                dtmf_tx.digit_char = *row_col_ascii_codes[dtmf_tx.row][dtmf_tx.col-4];
                dtmf_tx.maxval = dtmf_tx.pm;
            } 
            dtmf_tx.pre_row = dtmf_tx.row;
            dtmf_tx.pre_col = dtmf_tx.col;
        }
        i = i + 40;
    }

    if(newDigit != dtmf_tx.currentDigit)
    {
        dtmf_tx.currentDigit = newDigit;
        if(!dtmf_tx.currentDigit)
        {
            //ɿʱ400000ırowcolrow_col_ascii_codesһ׼ȷ
            //zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"DTMFDETECT TX row_col_ascii_codes[%d][%d] = %s\n", dtmf_tx.row, dtmf_tx.col - 4, row_col_ascii_codes[dtmf_tx.row][dtmf_tx.col-4]);
            //printk("DTMF TX detect digit_char = %c, maxval= %ld\n", dtmf_tx.digit_char, dtmf_tx.maxval);//ɿʱϱַɿǰĽ׼ȷ
            halDtmfTx_report(&dtmf_tx.digit_char, 1);

        }
    }
    return 0;
}

//
#if 0
//#include <stdio.h>
//#include "math.h"
//#include <stdlib.h>
//#include "drv_pub.h" //ûͷļ
#include "drvs_general.h"
#include <oss_clib.h>
#include <oss_kernel.h>
#include "drvs_ramlog.h"
#include "drvs_voiceprocess.h"

#define SAMPLING_RATE 8000
#define MAX_BINS 8
#define GOERTZEL_N 160
#define THRESHOLD_SUM  0.7//0.9
#define THRESHOLD_ROW  14.2
#define THRESHOLD_LINE 14.2

extern T_zDrvVp_SpeechState s_speechState;
extern UINT8 currentDigit;
extern unsigned char digit_char;

SINT32 sample_count = 0;
double q1[ MAX_BINS ] = {0};
double q2[ MAX_BINS ] = {0};
double r[ MAX_BINS ] = {0};
unsigned char *row_col_ascii_codes[4][4] = {//ַҪָ
    {"1", "2", "3", "A"},
    {"4", "5", "6", "B"},
    {"7", "8", "9", "C"},
    {"*", "0", "#", "D"}
};
SINT32 row, col;
double freqs[ MAX_BINS] =
{
    697,
    770,
    852,
    941,
    1209,
    1336,
    1477,
    1633
};

double coefs[ MAX_BINS ] ;

/*----------------------------------------------------------------------------
 * calc_coeffs
 * This is where we calculate the correct co-efficients.
 *----------------------------------------------------------------------------
 */
void calc_coeffs()
{
    SINT32 n;
    for(n = 0; n < MAX_BINS; n++)
    {
        coefs[n] = 2.0 * cos(2.0 * 3.141592654 * freqs[n] / s_speechState.vpCfgParam.clock_rate);
    }
}

/*---------------------------------------------------------------------------*
 * о check1
   1DTMFźǿ
 *  Ҫ:СƵֵ֮ռ8ƵİٷֱǷENERGY_THRESHOLD
 *Ĭ0.9ΪDTMFź                                      *
 *---------------------------------------------------------------------------*/
int  check1(double a[],int x,int y)
{
    SINT32 i;
    double max_sum = 0;
    double total_sum = 0;
    for(i = 0; i < 8; i++)
    {
        total_sum += a[i];
    }
    max_sum = a[x] + a[y];
    if (max_sum/total_sum <= THRESHOLD_SUM)//0.9޷ʶ360.8޷ʶ3DSP0.625
    {
        return 0;
    }
    return 1;
}
/*---------------------------------------------------------------------------*
 * о check2
   2Сзֵ
 *  Ҫ:Сֵ/δֵ> PEAK_VALUE_THRESHOLD(Ĭ14.2)
 *  ΪDTMFź,Ϊ˼,жֵûѰҴδֵ*                                    *
 *---------------------------------------------------------------------------*/
SINT32  check2(double a[],SINT32 x,SINT32 y)
{
    SINT32 i;
    //о
    for(i = 0; i < 4; i++)
    {
        if((x != i) && (a[x]/a[i]) < THRESHOLD_ROW)
        {
            return 0;
        }
    }
    //о
    for(; i < 8; i++)
    {
        if((y != i) && (a[y]/a[i]) < THRESHOLD_LINE)
        {
            return 0;
        }
    }
    return 1;
}


/*---------------------------------------------------------------------------*
 * о compare
   3ȶź
    ʵʵDTMFźӦһȵʱ䡣
   Ӧ⵽λͬһźʱΪźŴ
*                                    *
 *---------------------------------------------------------------------------*/
SINT32  compare(SINT32 a, SINT32 b, SINT32 x, SINT32 y)
{
    if ((a==x)&&(b==y))
    {
        return 1;

    }
    else
    {
        return 0;
    }
}

/*----------------------------------------------------------------------------
 *  post_testing
 * This is where we look at the bins and decide if we have a valid signal.
 *----------------------------------------------------------------------------
 */
SINT32 post_testing()
{
    SINT32 see_digit;
    double maxval;
    SINT32 i;

    /* Find the largest in the row group. */
    row = 0;
    maxval = 0.0;
    for ( i = 0; i < 4; i++ )
    {
        if ( r[i] > maxval )
        {
            maxval = r[i];
            row = i;
        }
    }
    if(maxval == 0.0)
    {
        return 0;
    }
    /* Find the largest in the column group. */
    col = 4;
    maxval = 0.0;
    for ( i = 4; i < 8; i++ )
    {
        if ( r[i] > maxval )
        {
            maxval = r[i];
            col = i;
        }
    }
    if(maxval == 0.0)
    {
        return 0;
    }
    //see_digit = check1(r,row,col) && check2(r,row,col) ;

    int lowgroup=-1;
    int highgroup=-1;
    double pm;
    if(r[row] > r[col])
        pm = r[row];
    else 
        pm = r[col];
    if(pm < 4000000000)
        return 0;
    for (i = 0; i < 8; i++) {
		if (r[i] < 0.125*pm)
			continue;  /* ignore */
		if (r[i] < 0.25*pm) {
			lowgroup = -1;
			highgroup = -1;
			break;  /* noise in between */ //ֻҪһP(P>=12.5%Pm && P<25%Pm)ûʶdtmf
		}
		/* good level found. This is allowed only one time per group */
		if (i < 4) { //ĸƵӦֻһ>=25%Pm<12.5%Pm
			/* lowgroup */
			if (lowgroup >= 0) {
				/* Bad. Another tone found. */ //PmӦƵƵС12.5%Pm
				lowgroup = -1;                 //ҸƵһ>=25%PmҸƵ<12.5%Pm
				break;
			} else
				lowgroup = i;
		} else {
			/* higroup */
			if (highgroup >= 0) {
				/* Bad. Another tone found. */ //Ƶڽӽж޷ʶdtmf
				highgroup = -1;
				break;
			} else
				highgroup = i;
		}
	}
    if (lowgroup >= 0 && highgroup >= 0)
    {
        row=lowgroup;
        col=highgroup;
        return 1;
    }
    return 0;
    
    //return see_digit;
}


/*----------------------------------------------------------------------------
 *  goertzel
 *----------------------------------------------------------------------------
 */
SINT32 goertzel( int sample )
{
    double q0;
    SINT32 i;
    SINT32 bDetected = 0;
    sample_count++;
    for ( i=0; i<MAX_BINS; i++ )
    {
        q0 = coefs[i] * q1[i] - q2[i] + sample;
        q2[i] = q1[i];
        q1[i] = q0;
    }

    if (sample_count == GOERTZEL_N)
    {
        for ( i=0; i<MAX_BINS; i++ )
        {
            r[i] = (q1[i] * q1[i]) + (q2[i] * q2[i]) - (coefs[i] * q1[i] * q2[i]);
            q1[i] = 0.0;
            q2[i] = 0.0;
        }
        bDetected = post_testing();
        sample_count = 0;
    }
    return bDetected;
}



SINT32 bDetected = 0;
SINT32 pre_detected = -1;
SINT32 pre_row = -1, pre_col = -1;
SINT32 bFirstDetected = 0;

SINT32 detectDTMF( UINT8 *tempbuffer, UINT8 *prebuffer)
{
    SINT32 i = 0;
    SHORT *pBuffer = tempbuffer;//ֵ
    UINT8 newDigit = 0;
    
    if(prebuffer == NULL)
    {
        return 0;
    }

    if(pBuffer == NULL)
    {
        return 0;
    }
    calc_coeffs();
    zOss_Memset(prebuffer,0,320);
    zOss_Memcpy(prebuffer, tempbuffer,320);
    if(pre_detected > 0)
    {
        zOss_Memset(prebuffer,0,pre_detected*sizeof(SHORT));
    }
    pre_detected = -1;
    while(i < 160)
    {
        int j = 0;
        for(; j < GOERTZEL_N; j++)
        {
            bDetected = goertzel(pBuffer[i+j]);
        }

        if(bDetected)
        {
            bDetected = compare(pre_row, pre_col, row, col);

            if(bDetected == 0 && i ==120)
            {
                zOss_Memset(prebuffer + 120, 0, 40*sizeof(SHORT));
                newDigit = 1;
                digit_char = *row_col_ascii_codes[row][col-4];
            }

            if(bDetected == 1)
            {
                zOss_Memset(prebuffer, 0, 160*sizeof(SHORT));
                pre_detected = i;
                newDigit = 1;
                digit_char = *row_col_ascii_codes[row][col-4];
            } 
            pre_row = row;
            pre_col =col;
        }
        i =i + 40;
    }

    if(newDigit != currentDigit)
    {
        currentDigit = newDigit;
        if(!currentDigit)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"DTMFDETECT row_col_ascii_codes[%d][%d] = %c\n",row, col - 4, row_col_ascii_codes[row][col-4]);
            printk("digit_char = %c\n", digit_char);
        }
    }
    return 0;
}

#endif
