/************************************************************************
 * Ȩ (C)2007,ͨѶɷ޹˾
 * ģ   ģ
 * ļƣ zte_dc.c
 * ļʶ 
 * ժҪ 
 *
 * ޸      汾     ޸ı    ޸          ޸      
 * ----------------------------------------------------------------------
 * 2009/07/18    1.0                    ΰ          
 * 2010/01/16    1.1                            ʵģ    
 * 2012/07/18    P98CV3.2.3B01      P98C-CXX-0001           EC:617001630060÷ֱʡ쳣 
 ************************************************************************/
  

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/

//#include "os_type.h"

#include "zte_display.h"

#include "zMsp_Com.h"

#include "zte_dc.h"

#include "zte_dv.h"

/**************************************************************************
 *                                                                    *
 **************************************************************************/
enum
{
    EV_DC_START_PREVIEW = 0,
    EV_DC_GET_VIDEO_DATA,
    EV_DC_STOP_PREVIEW,
    EV_DC_CAPTURE_ONE,
//    EV_DC_SET_RESOLUTION,
    EV_DC_PHOTO_REVIEW
};

/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define DC_PREVIEW_THREAD_PRIORITY   20 /* ߳ȼ */
#define DC_CAM_PREVIEW_THREAD_STACK  (UINT32)10*1024   /* ߳ջС */

#define DC_CAM_PREVIEW_THREAD        "dv_cam_preview_thread" /* Ƶݲɼ߳ */
#define DC_CTRL_SEMP                 "dc_control_semp"         /* ģͬź */
/**************************************************************************
 *                                                                 *
 **************************************************************************/
typedef enum
{
    CAM_IDLE = 0,
    CAM_OPEN,
    CAM_PREVIEW,
    CAM_CAPTURE
}CAM_STATE_E;

typedef enum
{
    DC_ERROR = -1,
    DC_SUCCESS
}DC_RETURN;

typedef struct
{
    T_MSP_CAM_SENSOR SensorId;
    UINT32  uiCamFd;
    UINT32  uiVideoFd;
    UINT32  uiState;                    /* Ԥģ״̬ */

    ZOSS_SEMAPHORE_ID  pControlSemp;   
    ZOSS_THREAD_ID     pCamPreviewThread;  /* Ԥ߳ID             */
    PREVIEW_PARAM_T    tPreviewParam;
    
}T_PreviewControlParam;

typedef struct
{
    EFFECT_TYPE_E          effect;           // Ч
    ZOOM_LEVEL_E           zoomlevel;        // ˮƽ
    DROTATION_MODE_E       rotation_mode;    // תǶ    
    BRITENESS_E            brightness;       // 
    CONTRAST_E             contrastness;     // Աȶ
    CAPTURE_MODE_E         mode;             // ģʽ
    RESOLUTION_MODE_E      resolution;       // ֱ
    QUALITY_MODE_E         quality;          // 
    WHITEBALANCE_MODE_E    whitebalance;     // ƽ
    MIRROR_PARAM_T         mirror;           // 
}T_PreviewInitParam;

typedef struct
{
    T_ZDrvVideo_BufInfo   tVideoData;
    UINT32                uiWidth;               /* video image width */
    UINT32                uiHeight;              /* video image height */
    T_ZDrv_PixelFmt       tPixelFmt;             /* video image pixel format */    

}T_DCDataInfo;



/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static VOID DC_CamPreviewThreadEntry(SINT32 iArg);
static SINT32 DC_GetVideoData(SINT32 iType);
static SINT32 DC_SetPreviewInitParam(T_PreviewInitParam tParam);
static SINT32 DC_SetResolutionEx(RESOLUTION_MODE_E resolution);
static SINT32 DC_PpuForRefreshScreen(T_ZDrv_CamDataInfo *pCamData, T_ZDrvVideo_BufInfo *ptPostBuf);
static SINT32 DC_PhotoReviewMsg(VOID);
static SINT32 DC_EncYUV2JPEG(T_ZDrv_CamDataInfo *pYUVDataIn);
static SINT32 DC_DecJPEG2YUV(T_ZDrvVideo_BufInfo *pJpegDecBuf);
static SINT32 DC_PpuForSelfMode(T_ZDrv_CamDataInfo *ptDataIn, T_DCDataInfo *ptDataOut);

/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static T_PreviewControlParam g_tPreviewCtrlParam;         /* ԤģƲ */
static T_ZDrvVideo_BufInfo   g_tCaptureVideoData;         /* պƵݱ棬ڻ */
static SNAPSHOT_PARAM_T     *g_pPictureBuffer    = NULL;  /* JPEGָ */
static REVIEW_PARAM_T       *g_pReviewBuffer     = NULL;  /* ջָ */
static DC_RETURN      g_ErrorCode         = DC_SUCCESS; /* ȫִ룬߳ڲ */
/**************************************************************************
 *                        ȫֺʵ                                    *
 **************************************************************************/
 
/**
 * ƣ DC_Open
 *  豸
 * ˵ (IN)paramDCAMERA_SENSOR_MAIN,DCAMERA_SENSOR_SUBͷѡ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */  
#if 0
static BOOL s_bMspTest_Added = FALSE;
extern VOID MspTest( T_Shell_CommandMessage *CmdMsg );
#endif
DCAMERA_RETURN_VALUE_E DC_Open(DCAMERA_SENSOR_E param)
{
    SINT32             iCamFd           = 0;
    SINT32             iVideoFd         = 0;
    SINT32             iRet              = 0;
    T_MSP_CAM_SENSOR   eSensor           = MSP_SENSOR_SUB;
#if 0
    /* ضýԴ --begin */
    if(!s_bMspTest_Added)
    {
        zOss_AddShellCmd("msptest", (const Shell_Func)MspTest, "ý");
        s_bMspTest_Added = TRUE;
    }
    /* ضýԴ --end */
#endif    
    if(g_tPreviewCtrlParam.uiState != CAM_IDLE)
    {
        return DCAMERA_OP_ERROR;
    }
    
    if(param != DCAMERA_SENSOR_MAIN && param != DCAMERA_SENSOR_SUB)
    {
        return DCAMERA_OP_ERROR;
    }

    zOss_Memset(&g_tPreviewCtrlParam, 0, sizeof(T_PreviewControlParam));
    zOss_Memset(&g_tCaptureVideoData, 0, sizeof(T_ZDrvVideo_BufInfo));
    
    /* 豸 */ 
    eSensor = (T_MSP_CAM_SENSOR)param;
    //eSensor = MSP_SENSOR_SUB; /* ʱ */
    iCamFd = zMspCom_CamOpen(eSensor);
    if (iCamFd <= 0)
    {
        return DCAMERA_OP_ERROR;
    } 
    
    g_tPreviewCtrlParam.uiCamFd  = (UINT32)iCamFd;
    g_tPreviewCtrlParam.SensorId = eSensor;

    iVideoFd = zMspCom_VideoOpen();
    if (iVideoFd <= 0)
    {
        zMspCom_CamClose();
        g_tPreviewCtrlParam.uiCamFd = 0;
        
        return DCAMERA_OP_ERROR;
    }    
    g_tPreviewCtrlParam.uiVideoFd = (UINT32)iVideoFd;

    iRet = Zte_OsdInit(g_tPreviewCtrlParam.uiVideoFd, 15);
    if (0 != iRet)
    {
        zMspCom_VideoClose();
        zMspCom_CamClose();
        g_tPreviewCtrlParam.uiVideoFd = 0;        
        g_tPreviewCtrlParam.uiCamFd   = 0;
        
        return DCAMERA_OP_ERROR;
    } 
    zMspOsd_SetUseDefTransColor(0);

    g_tPreviewCtrlParam.uiState = CAM_OPEN;

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_Close
 *  ر豸
 * ˵ (IN)
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_Close(void)
{
    SINT32 iRet = 0;

    /* ǰ״̬ΪOPEN״̬ʵд */
    if(g_tPreviewCtrlParam.uiState != CAM_OPEN)
    {
        /* ǰģ飬Ԥ߳û˳˳Ԥ߳ */
        if(APP_PREVIEW_CAM == g_tPreviewCtrlParam.tPreviewParam.previewtype
            && g_tPreviewCtrlParam.uiState > CAM_OPEN)
        {
            /* Ƶɼ̷ֹ߳ͣԤϢ */
            iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_STOP_PREVIEW);
            if(iRet != MSP_COM_OP_SUCCESS)
            {
                return DCAMERA_OP_ERROR;
            }

            /* ȴԤ̴߳ */
            zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp, ZOSS_WAIT_FOREVER);

            /* رͷɼ */
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_STOP, NULL);    
            if (DRV_SUCCESS != iRet)
            {
                return DCAMERA_OP_ERROR;      
            }

            /* ɾźԴ */
            if (NULL != g_tPreviewCtrlParam.pControlSemp)
            {
                zOss_DeleteSemaphore(g_tPreviewCtrlParam.pControlSemp);
                g_tPreviewCtrlParam.pControlSemp = NULL;
            } 

            /* ״̬ǨΪOPEN */
            g_tPreviewCtrlParam.uiState = CAM_OPEN;
        }
        else
        {
            return DCAMERA_OP_ERROR;
        }
    }

    /* ǰ¼ģ鴦ڷIDLE״̬ر豸 */
    if(!DV_IsStateIdle())
    {
        return DCAMERA_OP_ERROR;
    }
    
    zMspOsd_SetUseDefTransColor(FALSE);
    Zte_OsdUnInit();
    zMspCom_VideoClose();
    zMspCom_CamClose();

    //zOss_Memset(&g_tPreviewCtrlParam, 0, sizeof(T_PreviewControlParam));

    g_tPreviewCtrlParam.uiState = CAM_IDLE;
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_Startpreview
 *  Ԥ
 * ˵ (IN)paramPREVIEW_PARAM_Tָ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵
 * ޸ļ¼:  2009-7-31  
 * 1.Ԥ״̬жϣ
 * 2.ӡƸ֧쳣;
 * 3.״̬ǨƸĶ̴߳ɹ֮Ϣ֮ǰ
 * 4.Ԥ
 */
DCAMERA_RETURN_VALUE_E DC_Startpreview(PREVIEW_PARAM_T *param)
{
    SINT32             iRet              = 0;
    ZOSS_THREAD_ID     pCamPreviewThread = NULL; 
    T_PreviewInitParam tPreviewInitParam ;

    zOss_Memset(&tPreviewInitParam, 0, sizeof(T_PreviewInitParam));

    /* 2009-08-27 cyx  MMIʱûйرԤսʱԤ,
       ʱ᷵ش󣬵޷Ԥ,ж */
    if(CAM_CAPTURE == g_tPreviewCtrlParam.uiState)
    {
        /* ʼ */
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_START, NULL);
        if (iRet != DRV_SUCCESS)
        {
            return DCAMERA_OP_ERROR;
        }
        
        g_tPreviewCtrlParam.uiState = CAM_PREVIEW;
        iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_START_PREVIEW);
        if(MSP_COM_OP_SUCCESS != iRet)
        {
            zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_STOP, NULL);
            return DCAMERA_OP_ERROR;
        }
        
        zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp, ZOSS_WAIT_FOREVER);

        if(g_ErrorCode != DC_SUCCESS)
        {
            zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_STOP, NULL);
            g_ErrorCode = DC_SUCCESS;
            
            return DCAMERA_OP_ERROR;
        }
        
        return DCAMERA_OP_SUCCESS;
    }

    if(CAM_OPEN != g_tPreviewCtrlParam.uiState)
    {
        return DCAMERA_OP_ERROR;
    }
    
    if (NULL == param
        || (param->previewtype != APP_PREVIEW_CAM && param->previewtype != APP_PREVIEW_VID))
    {
        return DCAMERA_OP_ERROR;
    }

    /* ¼Ԥ¼ģ鲻IDLE״̬Ԥʧ */
    if(!DV_IsStateIdle() && APP_PREVIEW_VID == param->previewtype)
    {
        return DCAMERA_OP_ERROR;
    }

    g_tPreviewCtrlParam.tPreviewParam = *param;

        
    /* ͷԤһЩ */
    tPreviewInitParam.brightness    = param->brightness;
    tPreviewInitParam.contrastness  = param->contrastness;
    tPreviewInitParam.effect        = param->effect;
    tPreviewInitParam.mirror        = param->mirror;
    tPreviewInitParam.mode          = param->mode;
    tPreviewInitParam.quality       = param->quality;
    tPreviewInitParam.resolution    = param->resolution;
    tPreviewInitParam.rotation_mode = param->rotation_mode;
    tPreviewInitParam.whitebalance  = param->whitebalance;
    tPreviewInitParam.zoomlevel     = param->zoomlevel;

    iRet = DC_SetPreviewInitParam(tPreviewInitParam);
    if (DC_SUCCESS != iRet)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ʼ */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_START, NULL);
    if (iRet != DRV_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    g_tPreviewCtrlParam.pControlSemp = zOss_CreateSemaphore(DC_CTRL_SEMP, 0);
    if (NULL == g_tPreviewCtrlParam.pControlSemp)
    {
        zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_STOP, NULL);
         
        return DCAMERA_OP_ERROR;
    }

    /* Ԥ߳ */  
    pCamPreviewThread = zOss_CreateThread(DC_CAM_PREVIEW_THREAD,
                                           DC_CamPreviewThreadEntry,
                                           0,
                                           DC_CAM_PREVIEW_THREAD_STACK,
                                           DC_PREVIEW_THREAD_PRIORITY,
                                           0,
                                           1);
    if(NULL == pCamPreviewThread)
    {
        zOss_DeleteSemaphore(g_tPreviewCtrlParam.pControlSemp);
        
        zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_STOP, NULL);
         
        return DCAMERA_OP_ERROR;
    }

    /* ȴԤ̴߳ɹ */
    zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp, ZOSS_WAIT_FOREVER);

    g_tPreviewCtrlParam.pCamPreviewThread = pCamPreviewThread;

    /* 2009-7-31 
       ̴߳ɹ֮Ӧ޸״̬ڽϢʱܻʧ
     */
    g_tPreviewCtrlParam.uiState = CAM_PREVIEW;


    /* Ƶɼ̷߳ͿʼԤϢ */
    iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_START_PREVIEW);
    if(MSP_COM_OP_SUCCESS != iRet)
    {
        zOss_DeleteThread(g_tPreviewCtrlParam.pCamPreviewThread);
        zOss_DeleteSemaphore(g_tPreviewCtrlParam.pControlSemp);
        
        zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_STOP, NULL);
        
        g_tPreviewCtrlParam.uiState = CAM_OPEN;
        
        return DCAMERA_OP_ERROR;
    }
        
    zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp, ZOSS_WAIT_FOREVER);

    if(g_ErrorCode != DC_SUCCESS)
    {
        zOss_DeleteThread(g_tPreviewCtrlParam.pCamPreviewThread);
        zOss_DeleteSemaphore(g_tPreviewCtrlParam.pControlSemp);
        
        zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd,IOCTL_CAM_STOP, NULL);
        
        g_tPreviewCtrlParam.uiState = CAM_OPEN;
        g_ErrorCode = DC_SUCCESS;
            
        return DCAMERA_OP_ERROR;
    }
   
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_GetPreviewTypeAndState
 *  õǰԤ
 * ˵ (IN)APP_PREVIEW_E ָ
 *   ֵ 豸״̬2,Ԥ״̬1,IDLE״̬0,״̬-1
 * ˵ ýӿڽŸ¼ģʹ
 */
SINT32 DC_GetPreviewTypeAndState(APP_PREVIEW_E *pPreviewType)
{
    if(NULL == pPreviewType)
    {
        return -1;
    }
    
    *pPreviewType = g_tPreviewCtrlParam.tPreviewParam.previewtype;

    if(CAM_OPEN == g_tPreviewCtrlParam.uiState)
    {
        return 2;
    }
    
    if(CAM_PREVIEW== g_tPreviewCtrlParam.uiState)
    {
        return 1;
    }
    
    if(CAM_IDLE== g_tPreviewCtrlParam.uiState)
    {
        return 0;
    }
    
    //״̬
    return -1;
}

/**
 * ƣ DC_Stoppreview
 *  رԤ
 * ˵ (IN)
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 * ޸ļ¼:  2009-7-31  
 * 1.ʼλ״̬жϣ
 * 2.״̬ǨƷŵ߳Ϣ;
 */
DCAMERA_RETURN_VALUE_E DC_Stoppreview(void)
{
    SINT32 iRet = -1;

    /*  2007-7-31 
       ֻдԤ״̬ܹرԤ
    */
    /* ״̬£δԤ״̬֮ǰǷصԤ */
    if(CAM_PREVIEW != g_tPreviewCtrlParam.uiState)
    {
        return DCAMERA_OP_ERROR;
    }
    
    /* Ƶɼ̷ֹ߳ͣԤϢ */
    iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_STOP_PREVIEW);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp, ZOSS_WAIT_FOREVER);

    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_STOP, NULL);    
    if (DRV_SUCCESS != iRet)
    {
        return DCAMERA_OP_ERROR;      
    }
      
    if (NULL != g_tPreviewCtrlParam.pControlSemp)
    {
        zOss_DeleteSemaphore(g_tPreviewCtrlParam.pControlSemp);
        g_tPreviewCtrlParam.pControlSemp = NULL;
    }

    /* 2009-7-31 
       ״̬ǨƷŵ̴֮߳ܽ״̬Ǩƣܻ򱨴
     */
    g_tPreviewCtrlParam.uiState = CAM_OPEN;
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_CaptureOne
 *  ա
 * ˵ (IN)paramSNAPSHOT_PARAM_Tָ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ cyx 2009-8-27 Ӻʵ
 * :  Ԥ״̬״̬еã״̬ʱԤ
 *            ¿ʼԤɼһ֡ݽձ룬
 *            ùر˳ģ顣
 */
DCAMERA_RETURN_VALUE_E DC_CaptureOne(SNAPSHOT_PARAM_T *param)
{
    SINT32 iRet = 0;
    
    if(CAM_PREVIEW != g_tPreviewCtrlParam.uiState
        /*&& CAM_CAPTURE != g_tPreviewCtrlParam.uiState*/)
    {
        return DCAMERA_OP_ERROR;
    }

    if(NULL == param 
        || NULL == param->data_buffer
        || 0 == param->data_length)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ¼´ָд */
    g_pPictureBuffer = param;

    /* ״̬Ǩƣ׼ݲɼ */
    g_tPreviewCtrlParam.uiState = CAM_CAPTURE;
    
    iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_CAPTURE_ONE);
    if(MSP_COM_OP_SUCCESS != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    /* ȴԤ̴߳ */
    zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp,ZOSS_WAIT_FOREVER);
    if(g_ErrorCode != DC_SUCCESS)
    {
        g_ErrorCode = DC_SUCCESS;

        return DCAMERA_OP_ERROR;
    }
    
    /* ֹͣͷɼ */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_STOP, NULL);    
    if (DRV_SUCCESS != iRet)
    {
        return DCAMERA_OP_ERROR;      
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_CaptureMultim
 *  ġ
 * ˵ (IN)
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 956Ŀǰӿǿʵ֣ĿͨDC_CaptureOneʵ֡
 */
DCAMERA_RETURN_VALUE_E DC_CaptureMultim(void)
{
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_PhotoReview
 *  ջԡ
 * ˵ (IN)paramREVIEW_PARAM_Tָ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ cyx 2009-9-3 Ӻʵ
 */
DCAMERA_RETURN_VALUE_E DC_PhotoReview(REVIEW_PARAM_T *param)
{
    SINT32 iRet = 0;

    /* ״̬ܽл */
    if(g_tPreviewCtrlParam.uiState != CAM_CAPTURE)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    if(NULL == param
        || NULL == param->data_buffer
        || 0 == param->data_length)
    {
        zMspCom_Print();

        return DCAMERA_OP_ERROR;
    }

    /* ȫֱ¼ûָ룬JPEG */
    g_pReviewBuffer = param;

    /* Ԥ̷߳ͻϢ */
    iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_PHOTO_REVIEW);
    if(MSP_COM_OP_SUCCESS != iRet)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ȴԤ̻߳Դ */
    zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp,ZOSS_WAIT_FOREVER);
    if(g_ErrorCode != DC_SUCCESS)
    {
        g_ErrorCode = DC_SUCCESS;

        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
    
}

/**
 * ƣ DC_SetRotate
 *  ת
 * ˵ (IN)paramMAN_ROTATE_TYPEṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ Ŀǰ2960ֱ֧ת
 */
DCAMERA_RETURN_VALUE_E DC_SetRotate(/*MAN_ROTATE_TYPE*/DROTATION_MODE_E param)
{
    /* Ϊ2960sensorûṩתùܣֻڱʱ
     * ҪȱٽԲʵָùܣҲʵָù
     * ǷҪʵ
     */
     
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetZoom
 *  š
 * ˵ (IN)paramż
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetZoom(ZOOM_LEVEL_E param)
{
    SINT32         iRet     = -1;
    T_MSP_ZOOM_LEVEL tZoomLevel = (T_MSP_ZOOM_LEVEL)param;

    /* ݲֻ֧Ź */
#if 1  
    if(g_tPreviewCtrlParam.SensorId == MSP_SENSOR_MAIN)  
    {
    	  iRet = zMspCom_SetZoom(tZoomLevel);
		    if (0 != iRet)
		    {
		        return DCAMERA_OP_ERROR;
		    }
    }
#endif

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetBright
 *  ȡ
 * ˵ (IN)paramȼ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetBright(BRITENESS_E level)
{
    SINT32               iRet           = -1;
    T_MSP_BRIGHTNESS_LEVEL tBriLevel = (T_MSP_BRIGHTNESS_LEVEL)level;


    iRet = zMspCom_SetBrightness(tBriLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetContrast
 *  öԱȶȡ
 * ˵ (IN)paramԱȶȼ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetContrast(CONTRAST_E level)
{
    SINT32             iRet         = -1;
    T_MSP_CONTRAST_LEVEL  tConLevel = (T_MSP_CONTRAST_LEVEL)level;


    iRet = zMspCom_SetContrast(tConLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetEffect
 *  Ч
 * ˵ (IN)effectEFFECT_TYPE_Eṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetEffect(EFFECT_TYPE_E effect)
{
    SINT32           iRet       = -1;
    T_MSP_EFFECT_LEVEL tEffectLevel = (T_MSP_EFFECT_LEVEL)effect;


    iRet = zMspCom_SetEffect(tEffectLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }

    return DCAMERA_OP_SUCCESS;
}
#if 0
/**
 * ƣ zMspCom_SetCaputureMode
 *  ģʽ
 * ˵ (IN)modeCAPTURE_MODE_Eṹ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ˺ƶģ cyx 2009-9-7
 */
DCAMERA_RETURN_VALUE_E zMspCom_SetCaputureMode(CAPTURE_MODE_E mode)
{
    SINT32 iRet = -1;
    T_ZDrv_CamNightMode tNightMode = NIGHT_MODE_0;
    T_ZDrv_CamFps       tFrameRate = Fps714;
    if(g_tPreviewCtrlParam.uiCamFd <= 0)
    {
        return DCAMERA_OP_ERROR;
    }
    
    switch (mode)
    {
        case CAPTURE_MODE_NIGHT:
        {
            tNightMode = NIGHT_MODE_0;
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_SENSOR_NIGHTMODE, &tNightMode);
            if (DRV_SUCCESS != iRet)
            {
                return DCAMERA_OP_ERROR;
            }
            
            break;
        }

        case CAPTURE_MODE_NORMAL:
        {
            tFrameRate = Fps15;
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_SENSOR_FRAMERATE, &tFrameRate);
            if (DRV_SUCCESS != iRet)
            {
                return DCAMERA_OP_ERROR;
            }
            break;
        }

        default:
        {
            tFrameRate = Fps15;
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_SENSOR_FRAMERATE, &tFrameRate);
            if (DRV_SUCCESS != iRet)
            {
                return DCAMERA_OP_ERROR;
            }
            break;
        }
    }

    return DCAMERA_OP_SUCCESS;       
}
#endif

/**
 * ƣ DC_SetCaputureMode
 *  ģʽ
 * ˵ (IN)modeCAPTURE_MODE_Eṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetCaputureMode(CAPTURE_MODE_E mode)
{
    SINT32 iRet = 0;

    /* ͷΪֱʱ֡ʻģʽлӰ֡ʣ */
    if(RESOLUTION_1280X960 == g_tPreviewCtrlParam.tPreviewParam.resolution)
    {
        return DCAMERA_OP_SUCCESS;
    }

    iRet = zMspCom_SetCaputureMode(mode);
    if(iRet != DC_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetFrame
 *  ֡ʡ
 * ˵ (IN)frameFRAME_PARAM_Tṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ ˴Ĳṹ֡ʲṹһ£޷䣬
              ˺ĿǰûеãЧӿڣ
              ݲʵ
 */
DCAMERA_RETURN_VALUE_E DC_SetFrame(FRAME_PARAM_T *frame)
{
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetWhiteBalance
 *  ðƽ⡣
 * ˵ (IN)paramWHITEBALANCE_MODE_Eṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ ֧֣ݲʵ
 */
DCAMERA_RETURN_VALUE_E DC_SetWhiteBalance(WHITEBALANCE_MODE_E param)
{
    SINT32  iRet = -1;
    T_MSP_WHITE_BALANCE whiteBalance = (T_MSP_WHITE_BALANCE)param;

    iRet = zMspCom_SetWhiteBalance(whiteBalance);
    if(iRet != 0)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetResolution
 *  ÷ֱʡ
 * ˵ (IN)paramRESOLUTION_MODE_Eṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetResolution(RESOLUTION_MODE_E resolution)
{
#if 0
     SINT32 iRet = -1;

    if(g_tPreviewCtrlParam.uiState != CAM_PREVIEW)
    {
        return DCAMERA_OP_ERROR;
    }
#endif
    /* P98C-CXX-0001 2012-7-18EC:617001630060÷ֱ쳣 BEGIN */
    if(g_tPreviewCtrlParam.uiCamFd == 0)
    {
	zOss_Printf(1, 1, "ͷδ");
	return DCAMERA_OP_ERROR;	
    }	
    /* P98C-CXX-0001 2012-7-18EC:617001630060÷ֱ쳣 END */
    g_tPreviewCtrlParam.tPreviewParam.resolution = resolution;
#if 0  
    iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_SET_RESOLUTION);
    if(MSP_COM_OP_SUCCESS != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    zOss_GetSemaphore(g_tPreviewCtrlParam.pControlSemp, ZOSS_WAIT_FOREVER);
    if(g_ErrorCode != DC_SUCCESS)
    {
        g_ErrorCode = DC_SUCCESS;

        return DCAMERA_OP_ERROR;
    }
#endif
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetQuality
 *  
 * ˵ (IN)paramQUALITY_MODE_Eṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ ͼƬJPEGĿǰδýӿڣʱ޷ʵ
 */
DCAMERA_RETURN_VALUE_E DC_SetQuality(QUALITY_MODE_E param)
{
    /* P98C-CXX-0001 2012-7-18EC:617001630060û쳣 BEGIN */
    if(g_tPreviewCtrlParam.uiCamFd == 0)
    {
	zOss_Printf(1, 1, "ͷδ");
	return DCAMERA_OP_ERROR;	
    }	
    if(param < QUALITY_LOW || param > QUALITY_HIGHT)
    {
	zOss_Printf(1, 1, "Ϸ");
	return DCAMERA_OP_ERROR;	
    }	
    /* P98C-CXX-0001 2012-7-18EC:617001630060û쳣 END */
    g_tPreviewCtrlParam.tPreviewParam.quality = (QUALITY_MODE_E)param;
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetMirror
 *  þ
 * ˵ (IN)paramMIRROR_PARAM_Tṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetMirror(MIRROR_PARAM_T *param)
{
    SINT32 iRet = 0;

    iRet = zMspCom_SetMirror(param);
    if(iRet != 0)
    {
        return DCAMERA_OP_ERROR;
    }
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetCaputureMode_Sub
 *  øͷģʽ
 * ˵ (IN)modeCAPTURE_MODE_Eṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetCaputureMode_Sub(CAPTURE_MODE_E mode)
{
    SINT32 iRet = 0;

    iRet = zMspCom_SetCaputureMode(mode);
    if(iRet != DC_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetBright_Sub
 *  øͷȡ
 * ˵ (IN)modeȼ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetBright_Sub(BRITENESS_E level)
{
    SINT32               iRet           = -1;
    T_MSP_BRIGHTNESS_LEVEL tBriLevel = (T_MSP_BRIGHTNESS_LEVEL)level;


    iRet = zMspCom_SetBrightness(tBriLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetContrast_Sub
 *  øͷԱȶȡ
 * ˵ (IN)levelԱȶȼ
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetContrast_Sub(CONTRAST_E level)
{
    SINT32             iRet         = -1;
    T_MSP_CONTRAST_LEVEL  tConLevel = (T_MSP_CONTRAST_LEVEL)level;


    iRet = zMspCom_SetContrast(tConLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DC_SetWhiteBalance_Sub
 *  øͷƽ⡣
 * ˵ (IN)paramWHITEBALANCE_MODE_Eṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DC_SetWhiteBalance_Sub(WHITEBALANCE_MODE_E param)
{
    SINT32  iRet = -1;
    T_MSP_WHITE_BALANCE whiteBalance = (T_MSP_WHITE_BALANCE)param;

    iRet = zMspCom_SetWhiteBalance(whiteBalance);
    if(iRet != 0)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}


/**************************************************************************
 *                           ֲʵ                                 *
 **************************************************************************/
//ԱYUV,ɾ
static void SaveYUVData(T_ZDrv_ImageDataBuf imageData, UINT32 iWidth, UINT32 iHeight, char * index)
{
    FILE   *fp           = NULL;    
    SINT32  iRet         = -1;
    CHAR    filename[50] = {0};

    sprintf(filename, "%s%s", "C:\\img.yuv",index);
    fp = zOss_FOpen((const CHAR *)filename, "wb");
    if (NULL == fp)
    {
        return;
    }
    
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Y,  (SSIZE_T)1, (SSIZE_T)iWidth * iHeight,   fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cb, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/4, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cr, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/4, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    
    zOss_FClose(fp);
}

static void SaveYUVData422(T_ZDrv_ImageDataBuf imageData, UINT32 iWidth, UINT32 iHeight, char * index)
{
    FILE   *fp           = NULL;    
    SINT32  iRet         = -1;
    CHAR    filename[50] = {0};

    sprintf(filename, "%s%s", "C:\\img.yuv",index);
    fp = zOss_FOpen((const CHAR *)filename, "wb");
    if (NULL == fp)
    {
        return;
    }
    
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Y,  (SSIZE_T)1, (SSIZE_T)iWidth * iHeight,   fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cb, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/2, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cr, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/2, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    
    zOss_FClose(fp);
}

/**
 * ƣ DC_CamPreviewThreadEntry
 *  Ԥ߳ں
 * ˵ (IN)
 *   ֵ 
 * ˵ 
 */
static VOID DC_CamPreviewThreadEntry(SINT32 iArg)
{
    UINT32             uiMsg;
    BOOL               bQuit = FALSE;
    SINT32             iRet  = DC_SUCCESS;

    zOss_PutSemaphore(g_tPreviewCtrlParam.pControlSemp);
    
    /* Ϣѭ */
    while(!bQuit)
    {  
        iRet = zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER);
        if(MSP_COM_OP_SUCCESS != iRet)
        {
            g_ErrorCode = DC_ERROR;
            break;
        }
        switch(uiMsg)
        {
            case EV_DC_START_PREVIEW:
            {
                //zOss_Sleep(2000);
                iRet = DC_GetVideoData(CAM_PREVIEW);  
                if(iRet != DC_SUCCESS)
                {
                    g_ErrorCode = DC_ERROR;
                }
                zOss_PutSemaphore(g_tPreviewCtrlParam.pControlSemp);

                break;               
            }

            case EV_DC_GET_VIDEO_DATA:
            {
                DC_GetVideoData(CAM_PREVIEW);
                
                break;
            }

            case EV_DC_CAPTURE_ONE:
            {
                iRet = DC_GetVideoData(CAM_CAPTURE); 
                if(iRet != DC_SUCCESS)
                {
                    g_ErrorCode = DC_ERROR;
                }
                zOss_PutSemaphore(g_tPreviewCtrlParam.pControlSemp);
                break;
            }

            case EV_DC_PHOTO_REVIEW:
            {
                iRet = DC_PhotoReviewMsg();
                if(iRet != DC_SUCCESS)
                {
                    g_ErrorCode = DC_ERROR;
                }
                zOss_PutSemaphore(g_tPreviewCtrlParam.pControlSemp);
                break;
            }

            case EV_DC_STOP_PREVIEW:
            {
                bQuit = TRUE;
                zOss_PutSemaphore(g_tPreviewCtrlParam.pControlSemp);

                break;
            }
#if 0
            case EV_DC_SET_RESOLUTION:
            {
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_STOP, NULL);    
                if (DRV_SUCCESS != iRet)
                {
                    g_ErrorCode = DC_ERROR;
                }

                iRet = DC_SetResolutionEx(g_tPreviewCtrlParam.tPreviewParam.resolution);
                if (DC_SUCCESS != iRet)
                {
                    g_ErrorCode = DC_ERROR;
                } 
                
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_START, NULL);    
                if (DRV_SUCCESS != iRet)
                {
                    g_ErrorCode = DC_ERROR;
                }
                
                zOss_PutSemaphore(g_tPreviewCtrlParam.pControlSemp);

                break;
            }
#endif

            default:
            {
                break;
            }
        }
    }

    
    return;
}

/**
 * ƣ DC_EncYUV2JPEG
 *  һ֡YUVݱΪJPEGݡ
 * ˵ (IN)ɼƵ
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ cyx 
 */
static SINT32 DC_EncYUV2JPEG(T_ZDrv_CamDataInfo *pYUVDataIn)
{
    SINT32  iRet = 0;
    T_VideoEncInstParam   *pVideoEncHandle = NULL;
    T_VideoEncParam        tVideoEncParam  = {0};
    T_VideoEncInitParam    tEncInitParam   = {0};

    /* ʼ */
    tEncInitParam.tCodecStd    = VIDEO_CODEC_STD_MJPEG;
    tEncInitParam.tMirror      = MIR_NONE;
    tEncInitParam.tPixelFmt    = pYUVDataIn->pixeFmt;
    tEncInitParam.tRotate      = ROT_0;
    tEncInitParam.uiBitrate    = 300;
    tEncInitParam.uiFrameRate  = 15;
    tEncInitParam.uiHeight     = pYUVDataIn->Height;
    tEncInitParam.uiStride     = pYUVDataIn->Width;
    tEncInitParam.uiVideoFd    = g_tPreviewCtrlParam.uiVideoFd;
    tEncInitParam.uiWidth      = pYUVDataIn->Width;
    tEncInitParam.tQuality     = (T_ZDrv_EncQualityType)g_tPreviewCtrlParam.tPreviewParam.quality;

    /* 򿪱ʼ */
    pVideoEncHandle = zMspCom_OpenVideoEncoder(&tEncInitParam);
    if(NULL == pVideoEncHandle)
    {
        return DC_ERROR;
    }

    tVideoEncParam.pDataIn        = pYUVDataIn->dataBuf;
    tVideoEncParam.pDataOut       = g_pPictureBuffer->data_buffer;
    tVideoEncParam.uiLenOut       = g_pPictureBuffer->data_length;
    tVideoEncParam.bIsBufferValid = TRUE;

    /* һ֡Ƶ */
    iRet = zMspCom_VideoEncode(pVideoEncHandle, &tVideoEncParam);
    if(MSP_COM_OP_SUCCESS != iRet)
    {
        zMspCom_CloseVideoEncoder(pVideoEncHandle);
        return DC_ERROR;
    }

    /* 볤ȴû */
    g_pPictureBuffer->data_length = tVideoEncParam.uiLenOut;

    /* رս */
    zMspCom_CloseVideoEncoder(pVideoEncHandle);

    return DC_SUCCESS;
}

/**
 * ƣ DC_DecJPEG2YUV
 *  һ֡YUVݱΪJPEGݡ
 * ˵ (IN)Buffer
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ cyx 
 */
static SINT32 DC_DecJPEG2YUV(T_ZDrvVideo_BufInfo *pJpegDecBuf)
{
    SINT32  iRet      = -1;
    T_ZDrvVideo_DecCfg   JpegDecCfg;
    T_ZDrvVideo_BufInfo  tStreamBuf;
    T_ZDrvVideo_DecParam tDecParam;
    
    tStreamBuf.bufType                = STREAM_TYPE;
    tStreamBuf.bufSize.streamBufSize  = g_pReviewBuffer->data_length;
    tStreamBuf.pDataBuf.streamDataBuf = NULL;

    /* ȡӲBuffer */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tStreamBuf);
    if(iRet < 0)
    {
        return DC_ERROR;
    }

    /* ûĻݿӲBuffer */
    zOss_Memcpy(tStreamBuf.pDataBuf.streamDataBuf, (g_pReviewBuffer->data_buffer), tStreamBuf.bufSize.streamBufSize);

    /* ý */
    JpegDecCfg.tInput.tCodecStd   = VIDEO_CODEC_STD_MJPEG;
    JpegDecCfg.tInput.pEncHeader  = tStreamBuf.pDataBuf.streamDataBuf;
    JpegDecCfg.tInput.headerLenth = tStreamBuf.bufSize.streamBufSize;
    JpegDecCfg.tMirror            = MIR_NONE;
    JpegDecCfg.tRotate            = ROT_0;
    JpegDecCfg.tOutput.tPixelFmt  = PIXEL_YCbCr420;

    /* 򿪽ʱԶͷӲBuffer */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_DECSTART, (VOID *)&JpegDecCfg);
    if(iRet < 0)
    {
        return DC_ERROR;
    }

    JpegDecCfg.tInput.pEncHeader  = NULL;
    JpegDecCfg.tInput.headerLenth = 0;

    /* ݴ򿪽ʱصBuffer */
    pJpegDecBuf->bufType                   = YUV_TYPE;
    pJpegDecBuf->bufSize.YuvBufSize.ySize  = (JpegDecCfg.tOutput.uiWidth) * (JpegDecCfg.tOutput.uiHeight);
    pJpegDecBuf->bufSize.YuvBufSize.uSize  = (JpegDecCfg.tOutput.uiWidth) * (JpegDecCfg.tOutput.uiHeight)/4;
    pJpegDecBuf->bufSize.YuvBufSize.vSize  = (JpegDecCfg.tOutput.uiWidth) * (JpegDecCfg.tOutput.uiHeight)/4;

    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, pJpegDecBuf);
    if(iRet < 0)
    {
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_DECSTOP, (VOID *)(&(JpegDecCfg.uiVideoInst)));
        return DC_ERROR;
    }

    /* һBufferڴ򿪽ʱѾͷţ˽ʱBufferٴ */
    tStreamBuf.bufType                = STREAM_TYPE;
    tStreamBuf.bufSize.streamBufSize  = g_pReviewBuffer->data_length;
    tStreamBuf.pDataBuf.streamDataBuf = NULL;

    /* ȡӲBuffer */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tStreamBuf);
    if(iRet < 0)
    {
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, pJpegDecBuf);
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_DECSTOP, (VOID *)(&(JpegDecCfg.uiVideoInst)));
        return DC_ERROR;
    }

    /* ûĻݿӲBuffer */
    zOss_Memcpy(tStreamBuf.pDataBuf.streamDataBuf, g_pReviewBuffer->data_buffer, tStreamBuf.bufSize.streamBufSize);

    /* ý,׼ */
    tDecParam.uiVideoInst = JpegDecCfg.uiVideoInst;
    tDecParam.pDataIn     = tStreamBuf.pDataBuf.streamDataBuf;
    tDecParam.uiLenIn     = tStreamBuf.bufSize.streamBufSize;
    tDecParam.hasDecdata  = TRUE;

    tDecParam.pDataOut    = pJpegDecBuf->pDataBuf;
    tDecParam.uiStride    = JpegDecCfg.tOutput.uiWidth;

    /* 룬Ϊ tStreamBuf Ŀռ佫ɽԶͷ */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_DECONEFRAME, &tDecParam);
    if(iRet < 0)
    {
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, pJpegDecBuf);
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_DECSTOP, (VOID *)(&(JpegDecCfg.uiVideoInst)));
        return DC_ERROR;
    }

    /* Buffer봦ˢʹãﲻͷ */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_DECSTOP, (VOID *)(&(JpegDecCfg.uiVideoInst)));

    return DC_SUCCESS;
}

/**
 * ƣ DC_GetVideoData
 *  Ԥʱȡͷݲˢ
 * ˵ (IN)ɼƵݵͣԤ
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ cyx 2009-8-27 
 */
static SINT32 DC_GetVideoData(SINT32 eType)
{
    SINT32                  iRet      = -1;
    RECT_T                  rect      = {0,};
    T_ZDrv_CamDataInfo      tCamData;
    T_ZDrv_CamDataInfo      tCamDataForSelfMode;
    T_DCDataInfo            tDCDataInfo;      /* ͷģʽݻ */
    T_ZDrvVideo_BufInfo     tPostBuf;         /* buffer,ˢӿڣˢӿȥͷbuffer */
    BOOL bNeedSave = FALSE;

    if(CAM_PREVIEW > g_tPreviewCtrlParam.uiState)
    {
        return DC_ERROR;
    }

    zOss_Memset(&tCamData, 0, sizeof(T_ZDrv_CamDataInfo));
    zOss_Memset(&tPostBuf, 0, sizeof(T_ZDrvVideo_BufInfo));
    /* Ԥ״̬ʱɼ */
    if(CAM_PREVIEW == g_tPreviewCtrlParam.uiState && CAM_PREVIEW == eType)
    {
        /* ȡƵ */
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_GET_DATAINFO, &tCamData);
        if (DRV_SUCCESS != iRet)
        {
            return DC_ERROR;
        }
    
        if(bNeedSave)
        {
            SaveYUVData422(tCamData.dataBuf, tCamData.Height, tCamData.Width, "cam");
        }
        
        /* Cameraɼͼݽһκˢ */
        iRet = DC_PpuForRefreshScreen(&tCamData, &tPostBuf);
        if (DC_SUCCESS != iRet)
        {
            /* ͷsensorbuffer */
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
            return DC_ERROR;    
        }
      
        /* ͷsensorbuffer */
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
    
        /* ˢ */
        {
            rect = g_tPreviewCtrlParam.tPreviewParam.disp_rect;
    
	     if(bNeedSave)
            {
                SaveYUVData(tPostBuf.pDataBuf, rect.height, rect.height, "ppu");
            }

            Zte_OsdUpdateVideoInput(&(tPostBuf.pDataBuf), FALSE, &rect); 
        }

        /* ͶȡϢȡһ֡ */    
        iRet = zMspCom_PostMsg(g_tPreviewCtrlParam.pCamPreviewThread, EV_DC_GET_VIDEO_DATA);
        if(iRet != MSP_COM_OP_SUCCESS)
        {        
            return DC_ERROR;
        }  
    }
    
    else if(CAM_CAPTURE == g_tPreviewCtrlParam.uiState && CAM_CAPTURE == eType)
    {
       
        //ֱ
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_STOP, NULL);    
        if (DRV_SUCCESS != iRet)
        {
            g_ErrorCode = DC_ERROR;
        }
        iRet = DC_SetResolutionEx(g_tPreviewCtrlParam.tPreviewParam.resolution);
        if (DC_SUCCESS != iRet)
        {
            g_ErrorCode = DC_ERROR;
        } 
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_START, NULL);    
        if (DRV_SUCCESS != iRet)
        {
            g_ErrorCode = DC_ERROR;
        }
       
        /* 2009-9-3 cyx
           Ϊûʵֱ빦ܣһȫֱ¼ղɼ
           һ֡ݣʵģˢԣӱ֮ȥȫ
           Ԥľֲʵֱ빦
         */
        zOss_Memset(&g_tCaptureVideoData, 0, sizeof(T_ZDrvVideo_BufInfo));
        
        /* ȡƵ */
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_GET_DATAINFO, &tCamData);
        if (DRV_SUCCESS != iRet)
        {
            return DC_ERROR;
        }
        
        /* ͷģʽ */
        if(g_tPreviewCtrlParam.tPreviewParam.resolution != RESOLUTION_70X70)
        {
            /*JPEG*/        
            iRet = DC_EncYUV2JPEG(&tCamData);
            if (DC_SUCCESS != iRet)
            {
                /* ͷsensorbuffer */
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
                return DC_ERROR;    
            }
  
            /* Cameraɼͼݽеһκˢ */
            iRet = DC_PpuForRefreshScreen(&tCamData, &g_tCaptureVideoData);
            if (DC_SUCCESS != iRet)
            {
                /* ͷsensorbuffer */
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
                return DC_ERROR;    
            }
      
            /* ͷsensorbuffer */
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
            if(DRV_SUCCESS != iRet)
            {
                return DC_ERROR;
            }
        }
        /* ͷģʽ */
        else
        {
            /* ƵݴΪ96*96ͼĿǰֵ֧С */
            iRet = DC_PpuForSelfMode(&tCamData, &tDCDataInfo);
            if(DC_SUCCESS != iRet)
            {
                /* ͷsensorbuffer,ݵBuffer */
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &(tDCDataInfo.tVideoData));
                return DC_ERROR;    
            }

            /* ͷsensorbuffer */
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_FREE_DATABUFFER, &tCamData);
            if(DRV_SUCCESS != iRet)
            {
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &(tDCDataInfo.tVideoData));
                return DC_ERROR;
            }

            tCamDataForSelfMode.dataBuf = tDCDataInfo.tVideoData.pDataBuf;
            tCamDataForSelfMode.pixeFmt = tDCDataInfo.tPixelFmt;
            tCamDataForSelfMode.Height  = tDCDataInfo.uiHeight;
            tCamDataForSelfMode.Width   = tDCDataInfo.uiWidth;

            /* ԤݽJpeg */
            iRet = DC_EncYUV2JPEG(&tCamDataForSelfMode);
            if(DRV_SUCCESS != iRet)
            {
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &(tDCDataInfo.tVideoData));
                return DC_ERROR;
            }

            /* ٽһκˢ */
            iRet = DC_PpuForRefreshScreen(&tCamDataForSelfMode, &g_tCaptureVideoData);
            if (DC_SUCCESS != iRet)
            {
                /* ͷźݵbuffer */
                iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &(tDCDataInfo.tVideoData));
                return DC_ERROR;    
            }
      
            /* ͷźݵbuffer */
            iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &(tDCDataInfo.tVideoData));
            if(DRV_SUCCESS != iRet)
            {
                return DC_ERROR;
            }
        }
        
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_STOP, NULL);    
        if (DRV_SUCCESS != iRet)
        {
            g_ErrorCode = DC_ERROR;
        }        
        iRet = DC_SetResolutionEx(RESOLUTION_640X480);
        if (DC_SUCCESS != iRet)
        {
            g_ErrorCode = DC_ERROR;
        } 
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_START, NULL);    
        if (DRV_SUCCESS != iRet)
        {
            g_ErrorCode = DC_ERROR;
        }  
        
    }

    return DC_SUCCESS;
}

/**
 * ƣ DC_PhotoReviewMsg
 *  ʵջ
 * ˵ (IN)
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ 2009-9-3 cyx ʵֻԹ
 */
static SINT32 DC_PhotoReviewMsg()
{
    SINT32 iRet = 0;
    T_ZDrvVideo_BufInfo tJpegDecBuf;

    if(NULL == g_pReviewBuffer)
    {
        zMspCom_Print();

        return DC_ERROR;
    }

    #if 0
    /* jpeg */
    iRet = DC_DecJPEG2YUV(&tJpegDecBuf);
    
    SaveYUVData(tJpegDecBuf.pDataBuf, 640, 480, 1);

    /* ͷŽBuffer */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tJpegDecBuf);
    #endif

    /* ĿǰJpeg벻ִ֧320*240ͼƬ´󲿷ͼƬ޷ͨ
     * ݻԣʱģ鱣һ֡Ϊԣ
     * ƵģĽ
     */
    Zte_OsdUpdateVideoInput(&(g_tCaptureVideoData.pDataBuf), 
                            FALSE, 
                            &(g_pReviewBuffer->display_rect)); 

    return DC_SUCCESS;
}


/**
 * ƣ DC_PpuForSelfMode
 *  Ƶ
 * ˵ (IN)param
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ 
 */
static SINT32 DC_PpuForSelfMode(T_ZDrv_CamDataInfo *ptDataIn, T_DCDataInfo *ptDataOut)
{
    SINT32   iRet = 0;
    /* bufferͼСת*/
    T_ZDrvVideo_BufInfo     t_SizeBuf;
    T_ZDrvVideo_PpuInfo     t_PpuInfo;
    T_ZDrvVideo_PpuOutPut   t_PpuOutPut;
    T_ZDrvVideo_PpuInPut    t_PpuInPut;
    T_ZDrvVideo_PpuOSDInfo  tOsdInfo;

    /* ͼǿ */
    if(ptDataIn->Height < ptDataIn->Width)
    {
        t_PpuInPut.uiStartX = (ptDataIn->Width - ptDataIn->Height) / 2;
        t_PpuInPut.uiStartY = 0;
        t_PpuInPut.uiHeight = ptDataIn->Height;
        t_PpuInPut.uiWidth  = ptDataIn->Height;/* ȡΪģʽҪ */
    }
    /* ͼΪ */
    else
    {
        t_PpuInPut.uiStartX = 0;
        t_PpuInPut.uiStartY = (ptDataIn->Height - ptDataIn->Width) / 2;
        t_PpuInPut.uiHeight = ptDataIn->Width;
        t_PpuInPut.uiWidth  = ptDataIn->Width;/* ȡΪģʽҪ */
    }
    t_PpuInPut.pInPutbuffer = ptDataIn->dataBuf;
    t_PpuInPut.tPixelFmt    = ptDataIn->pixeFmt;
    t_PpuInPut.uiStride     = ptDataIn->Width;

    t_PpuOutPut.uiWidth   = 96;/* Ŀǰ2960ƵԤСֵΪ96 */
    t_PpuOutPut.uiHeight  = 96;
    t_PpuOutPut.uiStride  = 96;
    t_PpuOutPut.tPixelFmt = PIXEL_YCbCr420;

    /* ԤBuffer */
    t_SizeBuf.bufSize.YuvBufSize.ySize = t_PpuOutPut.uiWidth * t_PpuOutPut.uiHeight;
    t_SizeBuf.bufSize.YuvBufSize.uSize = t_PpuOutPut.uiWidth * t_PpuOutPut.uiHeight / 4;
    t_SizeBuf.bufSize.YuvBufSize.vSize = t_PpuOutPut.uiWidth * t_PpuOutPut.uiHeight / 4;
    t_SizeBuf.bufType                  = YUV_TYPE;
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &t_SizeBuf);
    if (DRV_SUCCESS != iRet)
    {
        return DC_ERROR;
    }

    t_PpuOutPut.pOutPutbuffer = t_SizeBuf.pDataBuf;

    tOsdInfo.bEnable = FALSE;

    t_PpuInfo.inputInfo  = t_PpuInPut;
    t_PpuInfo.outputInfo = t_PpuOutPut;
    t_PpuInfo.osdInfo    = tOsdInfo;

    /* Ƶ */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &t_PpuInfo);
    if (DRV_SUCCESS != iRet)
    {
        /* ͷĺbuffer */ 
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &t_SizeBuf);
                
        return DC_ERROR;
    }

    ptDataOut->tVideoData      = t_SizeBuf;
    ptDataOut->tPixelFmt       = t_PpuInfo.outputInfo.tPixelFmt;
    ptDataOut->uiHeight        = t_PpuInfo.outputInfo.uiHeight;
    ptDataOut->uiWidth         = t_PpuInfo.outputInfo.uiWidth;

    return DC_SUCCESS;
    
}


/**
 * ƣ DC_PpuForRefreshScreen
 *  Ƶ
 * ˵ (IN)param
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ 
 */
static SINT32 DC_PpuForRefreshScreen(T_ZDrv_CamDataInfo *pCamData, T_ZDrvVideo_BufInfo *ptPostBuf)
{
    SINT32                  iRet         = -1;
    T_ZDrvVideo_PpuInfo     tAllDataInfo = {0};    /* ҪĲ롢ԼOSD */
    T_ZDrvVideo_PpuInPut    tInputInfo   = {0};
    T_ZDrvVideo_PpuOutPut   tOutputInfo  = {0};
    T_ZDrvVideo_PpuOSDInfo  tOsdInfo     = {0};

    if (NULL == ptPostBuf)
    {
        return DC_ERROR;
    }
#if 0
    /* ɼͼݽкˢ */
    /* ͼƬȴĻȣȡĻȴС */
    if(pCamData->Width > DC_SCREEN_WIDTH)
    {
        tInputInfo.uiStartX     = (pCamData->Width - DC_SCREEN_WIDTH)/2;
        tInputInfo.uiWidth      = DC_SCREEN_WIDTH;
    }
    else
    {/* ͼƬСĻȣȷټ */
        tInputInfo.uiStartX = 0;
        tInputInfo.uiWidth  = pCamData->Width;
    }

    /* ͼƬĸ߶ȴĻ߶ȣȡĻ߶ȴС */
    if(pCamData->Height > DC_SCREEN_HEIGHT)
    {
        tInputInfo.uiStartY     = (pCamData->Height - DC_SCREEN_HEIGHT)/2;
        tInputInfo.uiHeight     = DC_SCREEN_HEIGHT;
    }
    else
    {
        tInputInfo.uiStartY     = 0;
        tInputInfo.uiHeight     = pCamData->Height;
    }
#endif

    tInputInfo.uiStartX     = 0;
    tInputInfo.uiStartY     = 0;
    tInputInfo.uiWidth      = pCamData->Width;
    tInputInfo.uiHeight     = pCamData->Height;
    tInputInfo.uiStride     = pCamData->Width;  
    tInputInfo.tPixelFmt    = pCamData->pixeFmt;
    tInputInfo.pInPutbuffer = pCamData->dataBuf;

    tOutputInfo.uiWidth   = g_uiScreenHeight;//ѡװʱΪת֮ǰ
    tOutputInfo.uiHeight  = g_uiScreenWidth;
    tOutputInfo.uiStride  = g_uiScreenWidth;
    tOutputInfo.tPixelFmt = PIXEL_YCbCr420;

    ptPostBuf->bufSize.YuvBufSize.ySize  = g_uiScreenWidth * g_uiScreenHeight;
    ptPostBuf->bufSize.YuvBufSize.uSize  = g_uiScreenWidth * g_uiScreenHeight / 4;
    ptPostBuf->bufSize.YuvBufSize.vSize  = g_uiScreenWidth * g_uiScreenHeight / 4;
    ptPostBuf->bufType = YUV_TYPE;
    
    /* buffer,ˢ */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, ptPostBuf);
    if (DRV_SUCCESS != iRet)
    {
        return DC_ERROR;
    }

    /* ɫ */
    zOss_Memset((VOID *)ptPostBuf->pDataBuf.YuvBuf.Y,  0,   ptPostBuf->bufSize.YuvBufSize.ySize);
    zOss_Memset((VOID *)ptPostBuf->pDataBuf.YuvBuf.Cb, 128, ptPostBuf->bufSize.YuvBufSize.uSize);
    zOss_Memset((VOID *)ptPostBuf->pDataBuf.YuvBuf.Cr, 128, ptPostBuf->bufSize.YuvBufSize.vSize);
 
    /* Ϊˢɫм򣬴˴ƫƵַ */
    {
        #if 0
        UINT32  uiXpos = 0;
        UINT32  uiYpos = 0;
        UINT32  uiYOffset;                  /* YӦƫ */
        UINT32  uiUOffset;                  /* UӦƫ */
        UINT32  uiVOffset;                  /* VӦƫ */
        
        T_ZDrv_YuvBuf  tTempYuvBuf; /* ¼ɫƫƺBuffer׵ַ */


        /* ǰѾ֤ͼĻΧ */
        uiXpos = (DC_SCREEN_WIDTH - tInputInfo.uiWidth)/2;
        uiYpos = (DC_SCREEN_HEIGHT - tInputInfo.uiHeight)/2;

        uiYOffset = DC_SCREEN_WIDTH * uiYpos + uiXpos;
        uiUOffset = DC_SCREEN_WIDTH * uiYpos / 4 + uiXpos / 2;
        uiVOffset = DC_SCREEN_WIDTH * uiYpos / 4 + uiXpos / 2;

        tTempYuvBuf.Y  = (PhyAddr *)((UINT32)ptPostBuf->pDataBuf.YuvBuf.Y  + uiYOffset);
        tTempYuvBuf.Cb = (PhyAddr *)((UINT32)ptPostBuf->pDataBuf.YuvBuf.Cb + uiUOffset);
        tTempYuvBuf.Cr = (PhyAddr *)((UINT32)ptPostBuf->pDataBuf.YuvBuf.Cr + uiVOffset);
        #endif

        tOutputInfo.pOutPutbuffer.YuvBuf = ptPostBuf->pDataBuf.YuvBuf;  
    }

    tOsdInfo.bEnable = FALSE;

    tAllDataInfo.inputInfo = tInputInfo;
    tAllDataInfo.outputInfo = tOutputInfo;
    tAllDataInfo.osdInfo = tOsdInfo;
    tAllDataInfo.tRotate = ROT_270;
    tAllDataInfo.tMirror = MIR_NONE;
    
    /* Ƶ */
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &tAllDataInfo);
    if (DRV_SUCCESS != iRet)
    {
        /* ͷĺbuffer */ 
        iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, ptPostBuf);
                
        return DC_ERROR;
    }

    return DC_SUCCESS;
}

/**
 * ƣ DC_SetPreviewInitParam
 *  Ԥʼá
 * ˵ (IN)tParamԤĲ
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ ĿǰԤֻ֧ЧȡԱȶȡֱʣ
 *            ֧(Сͷ֧֣ͷ֧)ת
 *            ͼ(ֻڱʱԸλ)
 *            ƽ(lightmode)ģʽ(NIGHTã
 *            NORMALûУ֡ʵ)
 */
static SINT32 DC_SetPreviewInitParam(T_PreviewInitParam tParam)
{
    SINT32 iRet = -1;
        
    iRet = zMspCom_SetEffect((T_MSP_EFFECT_LEVEL)(tParam.effect));
    if (MSP_COM_OP_SUCCESS != iRet)
    {
        return DC_ERROR;
    }
    
    if(g_tPreviewCtrlParam.SensorId == MSP_SENSOR_MAIN)
    {
    		iRet = zMspCom_SetZoom((T_MSP_ZOOM_LEVEL)(tParam.zoomlevel));
		    if (MSP_COM_OP_SUCCESS != iRet)
		    {
		        return DC_ERROR;
		    }
    }

    iRet = zMspCom_SetBrightness((T_MSP_BRIGHTNESS_LEVEL)(tParam.brightness));
    if (MSP_COM_OP_SUCCESS != iRet)
    {
        return DC_ERROR;
    }

    iRet = zMspCom_SetContrast((T_MSP_CONTRAST_LEVEL)(tParam.contrastness));
    if (MSP_COM_OP_SUCCESS != iRet)
    {
        return DC_ERROR;
    }

    iRet = zMspCom_SetCaputureMode(tParam.mode);
    if (MSP_COM_OP_SUCCESS != iRet)
    {
        return DC_ERROR;
    }

    iRet = zMspCom_SetMirror(&(tParam.mirror));
    if (MSP_COM_OP_SUCCESS != iRet)
    {
        return DC_ERROR;
    }

    iRet = zMspCom_SetWhiteBalance(tParam.whitebalance);
    if (MSP_COM_OP_SUCCESS != iRet)
    {
        return DC_ERROR;
    }
#if 0
    /* ¼ԤҪΪ640 X 480 */
    if(APP_PREVIEW_VID == g_tPreviewCtrlParam.tPreviewParam.previewtype)
    {
        tParam.resolution = RESOLUTION_640X480;
    }
#endif
    tParam.resolution = RESOLUTION_640X480;

    iRet = DC_SetResolutionEx(tParam.resolution);
    if (DC_SUCCESS != iRet)
    {
        return DC_ERROR;
    }    
#if 0
    //mirror
    if(g_tPreviewCtrlParam.SensorId == MSP_SENSOR_SUB)
    {
        iRet = zDrv_Ioctl((UINT32)g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_SET_MIRROR, &t_MirrorType);
        if(iRet != DRV_SUCCESS)
        {
            return DC_ERROR;
        }
    } 
#endif 

    return DC_SUCCESS;
}

/**
 * ƣ DC_SetResolutionEx
 *  յķֱʡ
 * ˵ (IN)resolutionֱʼ
 *   ֵ ɹDC_SUCCESS;򷵻DC_ERROR
 * ˵ 
 */
static SINT32 DC_SetResolutionEx(RESOLUTION_MODE_E resolution)
{
    SINT32 iRet = -1;
    T_ZDrv_CamOutputSize tImgSize = OUTPUT_IMG_SXGA;
    
    /* P98C-CXX-0001 2012-7-18EC:617001630060÷ֱ쳣 BEGIN */
    if(g_tPreviewCtrlParam.uiCamFd == 0)
    {
	zOss_Printf(1, 1, "ͷδ");
	return DC_ERROR;	
    }	
    /* P98C-CXX-0001 2012-7-18EC:617001630060÷ֱ쳣 END */
    
    switch (resolution)
    {
        case RESOLUTION_320X240:
        {
            tImgSize = OUTPUT_IMG_QVGA;
            
            break;
        }

        case RESOLUTION_640X480:
        {
            tImgSize = OUTPUT_IMG_VGA;
            
            break;
        }

        /* дͷд˷ֱ */
        case RESOLUTION_1280X960:
        {
            if(MSP_SENSOR_MAIN == g_tPreviewCtrlParam.SensorId)
            {
                tImgSize = OUTPUT_IMG_SXGA;
                //tImgSize = OUTPUT_IMG_VGA;
            }
            else
            {
                tImgSize = OUTPUT_IMG_VGA;
            }
            break;
        }

/* Ŀǰ֧⼸ָʽ */
#if 1
        case RESOLUTION_1600X1200:
        {
            if(MSP_SENSOR_MAIN == g_tPreviewCtrlParam.SensorId)
            {
                tImgSize = OUTPUT_IMG_USVGA;
                //tImgSize = OUTPUT_IMG_VGA;
            }
            else
            {
                tImgSize = OUTPUT_IMG_VGA;
            }
            
            break;
        }
#endif
        case RESOLUTION_70X70:
        {
            tImgSize = OUTPUT_IMG_QVGA;
            
            break;
        }

        default:
        {
            tImgSize = OUTPUT_IMG_VGA;
            
            break;
        }
    }
    iRet = zDrv_Ioctl(g_tPreviewCtrlParam.uiCamFd, IOCTL_CAM_SENSOR_OUTSIZE, &tImgSize);
    if (DRV_SUCCESS != iRet)
    {
        return DC_ERROR;
    }

    return DC_SUCCESS;
}




