/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : linux_mmu_csky.h
* ļ : 
* ʵֹ : cskymmuͷļ
*      : 
*      : V1.0
*  : 2011/11/22 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/

/**************************************************************************
* ޸ı : 0001
*    : 
*    : V1.1
* ޸ : 2012/03/09
* ޸ : ںĿ¼ֲplatĿ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

#ifndef _LINUX_MMU_CSKY_H
#define _LINUX_MMU_CSKY_H

/**************************************************************************
* #include
**************************************************************************/
#include <cyg/infra/cyg_type.h>
#include <pkgconf/hal_cskycpu.h>
#include <cyg/hal/hal_arch.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef CYG_HAL_CSKYCPU_MMU

/**************************************************************************
* 궨
**************************************************************************/
#define CSKY_PAGE_CACHE_ENABLE  (3<<3)
#define CSKY_PAGE_CACHE_DISABLE (2<<3)
#define CSKY_PAGE_DIRTY         (1<<2)
#define CSKY_PAGE_VALID         (1<<1)
#define CSKY_PAGE_GLOBAL        (1<<0)

#define CSKY_PAGE_SIZE_4K       (1<<12)
#define CSKY_PAGE_SIZE_16K      (1<<14)
#define CSKY_PAGE_SIZE_64K      (1<<16)
#define CSKY_PAGE_SIZE_256K     (1<<18)
#define CSKY_PAGE_SIZE_1M       (1<<20)
#define CSKY_PAGE_SIZE_4M       (1<<22)
#define CSKY_PAGE_SIZE_16M      (1<<24)
#define CSKY_PAGE_SIZE_DEFAULT  (CSKY_PAGE_SIZE_16M)

#define CSKY_PAGE_MASK_OFFSET   (13)
#define CSKY_PAGE_MASK_4K       (0x000<<CSKY_PAGE_MASK_OFFSET)
#define CSKY_PAGE_MASK_16K      (0x003<<CSKY_PAGE_MASK_OFFSET)
#define CSKY_PAGE_MASK_64K      (0x00f<<CSKY_PAGE_MASK_OFFSET)
#define CSKY_PAGE_MASK_256K     (0x03f<<CSKY_PAGE_MASK_OFFSET)
#define CSKY_PAGE_MASK_1M       (0x0ff<<CSKY_PAGE_MASK_OFFSET)
#define CSKY_PAGE_MASK_4M       (0x3ff<<CSKY_PAGE_MASK_OFFSET)
#define CSKY_PAGE_MASK_16M      (0xfff<<CSKY_PAGE_MASK_OFFSET)

#define CSKY_PFN_OFFSET         (6)
#define CSKY_PFN_MASK           (((1<<20) - 1)<<CSKY_PFN_OFFSET)

#define CSKY_VPN_OFFSET         (12)
#define CSKY_VPN_MASK           (((1<<20) - 1)<<CSKY_VPN_OFFSET)

#define CSKY_TLB_NUM            (64)
#ifdef CYG_HAL_CSKYCPU_MMU_MAP_USEG
# define CSKY_TLB_REG_START     (0x01)  /* tlb[0] is used by 32M RAM */
#else
# define CSKY_TLB_REG_START     (0x00)
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct csky_mmu_region 
{
    cyg_uint32 phy_addr;            /* physical address */
    cyg_uint32 vir_addr;            /* virtual address  */
    cyg_uint32 size;                /* region size      */
    cyg_uint32 attr;                /* region attribute */
    struct csky_mmu_region *next;   /* next region      */
} csky_mmu_region_t;

typedef struct 
{
    cyg_uint32 MRR;
    cyg_uint32 MEL0;
    cyg_uint32 MEL1;
    cyg_uint32 MEH;
} csky_tlb_entry_t;

typedef struct 
{
    /* read from MEH */
    cyg_uint32 MEH;
    cyg_uint32 vpn;
    cyg_uint32 asid;

    /* read from MCR */
    cyg_uint32 MCR;
    cyg_uint32 pte_base;
    cyg_uint32 bad_vpn2;

    /* epc */
    cyg_uint32 epc;
} csky_tlb_mismatch_t;

/**************************************************************************
* 
**************************************************************************/
extern void tos_csky_mmu_init(void);
extern void tos_csky_mmu_tlb_mismatch(HAL_SavedRegisters *reg);

/**************************************************************************
* ȫֳ/
**************************************************************************/

#endif  /* CYG_HAL_CSKYCPU_MMU */

#ifdef __cplusplus
}
#endif

#endif  /* _LINUX_MMU_CSKY_H */

