/*******************************************************************************
 * Copyright (C) 2016, ZTE Corporation.
 *
 * File Name:    hal_pmic_adc.h
 * File Mark:
 * Description:  pmic adc interface.
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2016-01-27
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef __DRVS_PMIC_ADC_H_
#define __DRVS_PMIC_ADC_H_

#if defined(_USE_PMIC_ZX234290)
typedef enum _T_ZDrvPmic_AdcChannel
{
    ADC_CHANNEL_VBAT_ADC = 0,
    ADC_CHANNEL_VADC2 = 1,	/* 01 */
    ADC_CHANNEL_VADC1 = 2,	/* 10 */

    MAX_ADC_CHANNEL
}T_ZDrvPmic_AdcChannel;

/* ADC */
#define ZX234290_ADC_ADC_START_LSH    		(5)
#define ZX234290_ADC_ADC1_EN_LSH            (4)
#define ZX234290_ADC_ADC2_EN_LSH           	(3)

#define ZX234290_ADC_ADC_START_WID         	(1)
#define ZX234290_ADC_ADC1_EN_WID          	(1)
#define ZX234290_ADC_ADC2_EN_WID         	(1)

/* CODE 12BIT 	*/
#define ZX234290_ADC_DATAMSB_LSH           	(0)  /* DATA0 - DATA11 */
#define ZX234290_ADC_DATALSB_LSH          	(4)  /*  */
#define ZX234290_ADC_DATAMSB_WID           	(8)  /* DATA0 - DATA11 */
#define ZX234290_ADC_DATALSB_WID           	(4)  /*  */

SINT32 zDrvPmic_AdcInit(VOID);
SINT32 zDrvPmic_AdcExit(VOID);
SINT32 zDrvPmic_AdcSingleAdcRead(T_ZDrvPmic_AdcChannel channel, SINT32 *value);
SINT32 zDrvPmic_AdcAvgAdcRead(T_ZDrvPmic_AdcChannel channel, SINT32 *avgValue);
#endif
#endif

