/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:  definition of clock name and frequency for zx297520
 * Others:
 * Version:       v1.0
 * Author:        xuzhiguo
 * Date:          2014-07-01
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_SYS_H
#define _DRVS_SYS_H

/****************************************************************************
*                                           Macros
****************************************************************************/

/****************************************************************************
*                                           Types
****************************************************************************/
#if 0//modify by xxx def _OS_LINUX

#define DRV_USE_MODEM_TYPE

#include <mach/clk.h>  /*use linux define*/

#else

#if defined (_CHIP_ZX297520V3)
/*
* ACLK: AXI BUS CLOCK
* HCLK: AHB BUS CLOCK
* PCLK: APB BUS CLOCK
*/
typedef enum
{
    /*
    * PS mg input clock
    */
    CLK_PS_CORE,
    CLK_PS_CORE_IDLE,
	CLK_TODDR_ACLK,
	CLK_TOMATIRX_ACLK,
    CLK_FROMMATIRX_PCLK,
	CLK_PSMATIRX_AXI,

	
	#if 0
	CLK_R7INT,
	CLK_R7CRM_PCLK,
	CLK_AXI2AXI_APB_AS_FOR_TCM,
	CLK_AXI2AXI_AS_M1,
    CLK_AXI2AXI_APB_AS,
    CLK_R7CFG_APBMUX_PCLK,
	#endif
	/*
    * lsp mg input clock
    */
    CLK_LSP32K,
    CLK_LSP26M,
	CLK_LSP52M,
	CLK_LSP78M,
	CLK_LSP124M8,		
    CLK_LSP156M,      
    CLK_LSP104M,
	CLK_LSP122M88,		
    CLK_LSPTDM,
    CLK_LSPAPB,

    /*
    * USB
    */
    /*CLK_USB_HCLK,
    CLK_USB_CTRL_WCLK,
    CLK_USB_12M_PHY_WCLK, 

    CLK_HSIC_HCLK,       
    CLK_HSIC_12M_PHY_WCLK,   
    CLK_HSIC_480M_PHY_WCLK,
	CLK_HSIC_CTRL_WCLK,*/
	
    /*
    *dma
    */
    CLK_DMA0_PCLK,    
    CLK_DMA0_ACLK,  

    /*
    * M2_AXI2AHB
    */
    //CLK_M2_ACLK,
    //CLK_M2_HCLK,

    /*
    * edcp  in matrix blcok
    */             
    CLK_EDCP_HCLK,
    CLK_EDCPASYNC_ACLK,   
    CLK_EDCPSYNC_ACLK,   

    /*
    * nand
    */
	/*CLK_4M1SNAND_HCLK,*/
    CLK_NAND_HCLK ,
    CLK_NAND_WCLK,

    /*
    * sd
    */
    CLK_SD0_HCLK,
    CLK_SD1_HCLK, 
	
    CLK_SD0_32K, 
    CLK_SD1_32K,
	
    CLK_SD0_WCLK,    
    CLK_SD1_WCLK,   

    /*i2s in lsp*/    
    CLK_I2S0_PCLK,
	CLK_I2S1_PCLK,
    
    CLK_I2S0_WCLK,
    CLK_I2S1_WCLK,

    /*spifc in lsp*/  
    CLK_SPIFC_PCLK,
    CLK_SPIFC_WCLK,    

    /* ssp in lsp*/
    CLK_SSP0_PCLK,
    CLK_SSP1_PCLK,
    
    CLK_SSP0_WCLK,    
    CLK_SSP1_WCLK,

    /*uart0 in rm,uart1&2 in lsp*/
    CLK_UART0_PCLK,
    CLK_UART1_PCLK,
    CLK_UART2_PCLK, 
  
    CLK_UART0_WCLK, 
    CLK_UART1_WCLK,        
    CLK_UART2_WCLK,     

    /*i2c0 in rm, i2c1 in lsp*/
    CLK_RMI2C_PCLK,
    CLK_I2C1_PCLK,	
	
    CLK_RMI2C_WCLK,               
    CLK_I2C1_WCLK,

	/*gpio0&1 in rm*/
	CLK_GPIO0_PCLK,
    CLK_GPIO1_PCLK,	

	/*gsm in rm*/
    CLK_GSM_156M,
    CLK_GSM_104M,
    CLK_GSM_48M,
    CLK_GSM_32K,
	CLK_GSM_MAIN,

	/*tdm in lsp*/
	CLK_TDM_PCLK,
    CLK_TDM_WCLK,

    /*ps timer1&2&rm timer1 in rm, ps timer0&ps-rm timer in lsp*/
	CLK_TIMER0_PCLK,/*ps timer0*/
	CLK_TIMER4_PCLK,/*ps rm timer*/
	CLK_TIMER1_PCLK,/*ps timer1*/ 
	CLK_TIMER2_PCLK,/*ps timer2*/
	CLK_TIMER3_PCLK,/*rm timer1*/

	CLK_TIMER0_WCLK,/*ps timer0*/  
    CLK_TIMER4_WCLK,/*ps rm timer*/
    CLK_TIMER1_WCLK,/*ps timer1*/   
	CLK_TIMER2_WCLK,/*ps timer2*/
	CLK_TIMER3_WCLK,/*rm timer1*/

    /*
    * usim
    */
    CLK_USIM_PCLK,     
    CLK_USIM_WCLK,   

    /*
    * mpll
    */
    CLK_MPLL_156M_CLK,
    CLK_MPLL_48M_CLK,
    CLK_AON_DPLL_491M52_CLK,

    /*
    * rtc
    */
    //CLK_RTC_PCLK,   
    //CLK_RTC_WCLK,

	/*wdt in lsp*/
    CLK_WDT_PCLK,   
    CLK_WDT_WCLK,

    /*key in rm*/
    CLK_KEY_PCLK,
    CLK_KEY_WCLK,    
	/*VOU */
	CLK_OSD_PCLK,
	CLK_OSD_ACLK,
	CLK_OSD_VEDIO_CLK,
	CLK_OSD_GRAPHIC_CLK,
	CLK_OSD_MAINMIX_CLK,
	CLK_OSD_PPU_CLK,
	CLK_CSC_WCLK,
	CLK_CSC_PCLK,
	CLK_VOU_ACLK,
	CLK_VOU_PCLK,
	CLK_VOU_WCLK,
	CLK_MCU_WCLK,
	CLK_MCU_PCLK,
    /*
    * gsmlpm
    */
    CLK_GSMLPM_PCLK,    
    CLK_GSMLPM_WCLK,  

	/*matrix ps block*/
	CLK_PS2MATRIX_ACLK,
	CLK_PS2DDR_ACLK,

	/*matrix block*/
	CLK_DPLL_122M88,

	/*matrix ssc block*/
	CLK_SSC_WCLK,
	CLK_SSC_PCLK,
	CLK_RFFE_WCLK,

} T_ZDrvSysClk_Name;




/*
*  bits domain definition  for clock frequency
*  base clock name   same clock number  reserved       clock selection   frequency division
*  31...28 27...24   		 23...20            19...16        15...12 11...8         7...4 3...0
*  invalid value:
*  		0xff              	   0xf or 0x0       0x0 or ignore           0xff                    0xff
*/

typedef enum
{
    /*fixed frequency*/
	FIXED_FREQ =0xffffffff,
	
	/*ps core  & ps core idle*/
    PS_CORE_26M       = (CLK_PS_CORE << 24) | 0x00200000,
    PS_CORE_624M      = (CLK_PS_CORE << 24) | 0x00200100,
    PS_CORE_312M      = (CLK_PS_CORE << 24) | 0x00200200,
    PS_CORE_156M      = (CLK_PS_CORE << 24) | 0x00200300,
    
	/*ps matrix axi*/
	PS_MATRIX_AXI_26M   = (CLK_PSMATIRX_AXI << 24) | 0x00100000,
	PS_MATRIX_AXI_156M  = (CLK_PSMATIRX_AXI << 24) | 0x00100100,
	PS_MATRIX_AXI_124M8	= (CLK_PSMATIRX_AXI << 24) | 0x00100200,
	PS_MATRIX_AXI_104M	= (CLK_PSMATIRX_AXI << 24) | 0x00100300,
	PS_MATRIX_AXI_78M	= (CLK_PSMATIRX_AXI << 24) | 0x00100400,
	PS_MATRIX_AXI_52M	= (CLK_PSMATIRX_AXI << 24) | 0x00100500,
	PS_MATRIX_AXI_39M	= (CLK_PSMATIRX_AXI << 24) | 0x00100600,
	PS_MATRIX_AXI_6M5	= (CLK_PSMATIRX_AXI << 24) | 0x00100700,

	/*TDM WCLK*/
	WCLK_TDM_26M  		= (CLK_LSPTDM << 24) | 0x00100000,
	WCLK_TDM_122M88 	= (CLK_LSPTDM << 24) | 0x00100100,
	WCLK_TDM_104M 		= (CLK_LSPTDM << 24) | 0x00100200,
	
    /* EDCP WCLK*/
	WCLK_EDCP_26M  	= (CLK_EDCPASYNC_ACLK << 24) | 0x00100000,
	WCLK_EDCP_208M 	= (CLK_EDCPASYNC_ACLK << 24) | 0x00100100,
	WCLK_EDCP_156M 	= (CLK_EDCPASYNC_ACLK << 24) | 0x00100200,
	WCLK_EDCP_104M 	= (CLK_EDCPASYNC_ACLK << 24) | 0x00100300,

	/*NAND WCLK*/
	WCLK_NAND_26M  = (CLK_NAND_WCLK << 24) | 0x00100000,
	WCLK_NAND_104M = (CLK_NAND_WCLK << 24) | 0x00100100,
 	WCLK_NAND_78M  = (CLK_NAND_WCLK << 24) | 0x00100200,

	/* SD0 WCLK*/
	WCLK_SD0_26M  = (CLK_SD0_WCLK << 24) | 0x00100000,
	WCLK_SD0_156M = (CLK_SD0_WCLK << 24) | 0x00100100,
	WCLK_SD0_100M = (CLK_SD0_WCLK << 24) | 0x00100200,
	WCLK_SD0_78M  = (CLK_SD0_WCLK << 24) | 0x00100300,
	WCLK_SD0_50M  = (CLK_SD0_WCLK << 24) | 0x00100400,
	WCLK_SD0_25M  = (CLK_SD0_WCLK << 24) | 0x00100500,

	/* SD1 WCLK*/
	WCLK_SD1_26M  = (CLK_SD1_WCLK << 24) | 0x00100000,
	WCLK_SD1_100M = (CLK_SD1_WCLK << 24) | 0x00100100,
	WCLK_SD1_78M  = (CLK_SD1_WCLK << 24) | 0x00100200,
	WCLK_SD1_50M  = (CLK_SD1_WCLK << 24) | 0x00100300,
	WCLK_SD1_39M  = (CLK_SD1_WCLK << 24) | 0x00100400,
	WCLK_SD1_25M  = (CLK_SD1_WCLK << 24) | 0x00100500,
	
	/* I2S0&1 WCLK*/
	WCLK_I2S_26M  	   	= (CLK_I2S0_WCLK << 24) | 0x00200000,
	WCLK_I2S_122M88  	= (CLK_I2S0_WCLK << 24) | 0x00200100,
	WCLK_I2S_104M 		= (CLK_I2S0_WCLK << 24) | 0x00200200,

    /*SPIFC WCLK*/
	WCLK_SPIFC_26M    = (CLK_SPIFC_WCLK << 24) | 0x00100000,
	WCLK_SPIFC_156M   = (CLK_SPIFC_WCLK << 24) | 0x00100100,
	WCLK_SPIFC_124M8  = (CLK_SPIFC_WCLK << 24) | 0x00100200,
	WCLK_SPIFC_104M   = (CLK_SPIFC_WCLK << 24) | 0x00100300,
	WCLK_SPIFC_78M    = (CLK_SPIFC_WCLK << 24) | 0x00100400,
	WCLK_SPIFC_52M    = (CLK_SPIFC_WCLK << 24) | 0x00100500,    

	/* SSP0&1 WCLK*/
    WCLK_SSP_26M 	= (CLK_SSP0_WCLK << 24) | 0x00200000,
	WCLK_SSP_13M 	= (CLK_SSP0_WCLK << 24) | 0x00200001,
    WCLK_SSP_6M5 	= (CLK_SSP0_WCLK << 24) | 0x00200003,
    WCLK_SSP_156M 	= (CLK_SSP0_WCLK << 24) | 0x00200100,
    WCLK_SSP_78M 	= (CLK_SSP0_WCLK << 24) | 0x00200101,
    WCLK_SSP_19M5 	= (CLK_SSP0_WCLK << 24) | 0x00200107,
    WCLK_SSP_104M 	= (CLK_SSP0_WCLK << 24) | 0x00200200,
    WCLK_SSP_52M 	= (CLK_SSP0_WCLK << 24) | 0x00200201,

    /*ps timer1& ps timer2& rm timer1*/
    WCLK_AON_TIMER_32K = (CLK_TIMER1_WCLK << 24) | 0x00300000,
    WCLK_AON_TIMER_26M = (CLK_TIMER1_WCLK << 24) | 0x00300100,     /* 1 div*/
	WCLK_AON_TIMER_13M = (CLK_TIMER1_WCLK << 24) | 0x00300101,     /* 2 div*/

	/*ps timer0&ps rm timer*/
    WCLK_LSP_TIMER_32K = (CLK_TIMER0_WCLK << 24) | 0x00200000,
    WCLK_LSP_TIMER_26M = (CLK_TIMER0_WCLK << 24) | 0x00200100,     /* 1 div*/
	WCLK_LSP_TIMER_13M = (CLK_TIMER0_WCLK << 24) | 0x00200101,     /* 2 div*/

    /* I2C0&1 WCLK*/
    WCLK_I2C_26M  = (CLK_RMI2C_WCLK << 24) | 0x00200000,
    WCLK_I2C_104M = (CLK_RMI2C_WCLK << 24) | 0x00200100,

    /* UART0&1&2 WCLK*/
    WCLK_UART_26M  = (CLK_UART0_WCLK << 24) | 0x00300000,
    WCLK_UART_104M = (CLK_UART0_WCLK << 24) | 0x00300100,

    /*PS WDT WCLK*/
    WCLK_WDT_32K  = (CLK_WDT_WCLK << 24) | 0x00100000,
    WCLK_WDT_26M  = (CLK_WDT_WCLK << 24) | 0x00100100,
    WCLK_WDT_13M  = (CLK_WDT_WCLK << 24) | 0x00100101,

    /* USIM WCLK */
    /* usim work clock is fixed 13MHz*/
    /*WCLK_USIM_13M = (CLK_USIM_WCLK << 24) | 0x0010ffff,*/

    /* RTC WCLK */
    /* rtc work clock is fixed 32KHz*/
    /*WCLK_RTC_32K = (CLK_RTC_WCLK << 24) | 0x0010ffff,*/

    /* KEY WCLK */
    /* KEY work clock is fixed 32KHz*/
    /*WCLK_KEY_32K = (CLK_RTC_WCLK << 24) | 0x0010ffff,*/
    

} T_ZDrvSysClk_Freq;
#elif defined (_CHIP_ZX297520V2)
/*
* ACLK: AXI BUS CLOCK
* HCLK: AHB BUS CLOCK
* ACLK: APB BUS CLOCK
*/
typedef enum
{
    /*
    * PS
    */
    CLK_PS_CORE,
    CLK_PS_CORE_IDLE,
	CLK_R7INT,
	CLK_R7CRM_PCLK,
	CLK_AXI2AXI_APB_AS_FOR_TCM,
	CLK_AXI2AXI_AS_M1,
    CLK_AXI2AXI_APB_AS,
    CLK_R7CFG_APBMUX_PCLK,
    CLK_FROMMATIRX_ACLK,
    CLK_TOMATIRX_ACLK,
    CLK_TODDR3_ACLK,

	/*
    * lsp mg input clock
    */
    CLK_LSP124M8,       
    CLK_LSP156M,      
    CLK_LSP104M,
    CLK_LSP78M,
    CLK_LSP52M,
    CLK_LSP26M,
    CLK_LSP32K,
    CLK_LSPAPB,
    CLK_LSPTDM,

    /*
    * USB
    */
    /*CLK_USB_HCLK,
    CLK_USB_CTRL_WCLK,
    CLK_USB_12M_PHY_WCLK, 

    CLK_HSIC_HCLK,       
    CLK_HSIC_12M_PHY_WCLK,   
    CLK_HSIC_480M_PHY_WCLK,
	CLK_HSIC_CTRL_WCLK,*/
	
    /*
    *dma
    */
    CLK_DMA0_PCLK,    
    CLK_DMA0_ACLK,  

    /*
    * M2_AXI2AHB
    */
    //CLK_M2_ACLK,
    //CLK_M2_HCLK,

    /*
    * edcp
    */             
    CLK_EDCP_HCLK,
    CLK_EDCPASYNC_ACLK,   
    CLK_EDCPSYNC_ACLK,   

    /*
    * nand
    */
	/*CLK_4M1SNAND_HCLK,*/
    CLK_NAND_HCLK ,
    CLK_NAND_WCLK,

    /*
    * sd
    */
    CLK_SD0_HCLK,
    CLK_SD1_HCLK, 
	
    CLK_SD0_32K, 
    CLK_SD1_32K,
	
    CLK_SD0_WCLK,    
    CLK_SD1_WCLK,   

    /*
    * i2s
    */    
    CLK_I2S0_PCLK,
	CLK_I2S1_PCLK,
    
    CLK_I2S0_WCLK,
    CLK_I2S1_WCLK,

    /*
    * spifc
    */
    CLK_SPIFC_PCLK,
    CLK_SPIFC_WCLK,    

    /*
    * ssp
    */      
    CLK_SSP0_PCLK,
    CLK_SSP1_PCLK,
    
    CLK_SSP0_WCLK,    
    CLK_SSP1_WCLK,

    /*
    * uart0
    */
    CLK_UART0_PCLK,
    CLK_UART1_PCLK,
    CLK_UART2_PCLK, 
  
    CLK_UART0_WCLK, 
    CLK_UART1_WCLK,        
    CLK_UART2_WCLK,     

    /*
    * i2c
    */
    CLK_RMI2C_PCLK,
    CLK_I2C1_PCLK,	
	
    CLK_RMI2C_WCLK,               
    CLK_I2C1_WCLK,

	/*
    * gpio
    */
	CLK_GPIO0_PCLK,
    CLK_GPIO1_PCLK,	

	/*
    * gsm
    */
	CLK_GSM_PCLK,
    CLK_GSM_32K,
    CLK_GSM_MAIN,
    CLK_GSM_48M,
    CLK_GSM_104M,
    CLK_GSM_156M,
    CLK_GSM_SYS_26M,

	/*
    * tdm
    */
	CLK_TDM_PCLK,
    CLK_TDM_WCLK,

    /*
    * timer
    */
	CLK_TIMER1_PCLK, 
	CLK_TIMER2_PCLK,
	CLK_TIMER3_PCLK,/*m0 rm timer1*/
	
	CLK_TIMER0_PCLK,
	CLK_TIMER4_PCLK,/*ps rm timer*/
		  
    CLK_TIMER1_WCLK,   
	CLK_TIMER2_WCLK,
    CLK_TIMER3_WCLK,/*m0 rm timer1*/
    
    CLK_TIMER0_WCLK,  
    CLK_TIMER4_WCLK,/*ps rm timer*/

    /*
    * usim
    */
    //CLK_USIM_PCLK,     
    //CLK_USIM_WCLK,    

    /*
    * rtc
    */
    //CLK_RTC_PCLK,   
    //CLK_RTC_WCLK,

	/*
    * wdt
    */
    CLK_WDT_PCLK,   
    CLK_WDT_WCLK,

    /*
    * key
    */
    CLK_KEY_PCLK,
    CLK_KEY_WCLK,    

    /*
    * gsmlpm
    */
    //CLK_GSMLPM_PCLK,    
    //CLK_GSMLPM_WCLK,  
    //CLK_WIFI_BT
} T_ZDrvSysClk_Name;




/*
*  bits domain definition  for clock frequency
*  base clock name   same clock number  reserved       clock selection   frequency division
*  31...28 27...24   23...20            19...16        15...12 11...8    7...4 3...0
*  invalid value:
*  0xff              0xf or 0x0         0x0 or ignore     0xff          0xff
*/

typedef enum
{
    /*fixed frequency*/
	FIXED_FREQ =0xffffffff,
	    /*
    *ps core
    */
    PS_CORE_624M      = (CLK_PS_CORE << 24) | 0x00100000,
    PS_CORE_26M       = (CLK_PS_CORE << 24) | 0x00100100,
    PS_CORE_491M52    = (CLK_PS_CORE << 24) | 0x00100200,
    PS_CORE_312M      = (CLK_PS_CORE << 24) | 0x00100300,
    PS_CORE_208M      = (CLK_PS_CORE << 24) | 0x00100400,
    PS_CORE_104M      = (CLK_PS_CORE << 24) | 0x00100500,
    PS_CORE_78M       = (CLK_PS_CORE << 24) | 0x00100600,
    PS_CORE_52M       = (CLK_PS_CORE << 24) | 0x00100700,

    /*
     *ps core idle
     */
    PS_CORE_IDLE_624       = (CLK_PS_CORE << 24) | 0x00100000,
    PS_CORE_IDLE_26M       = (CLK_PS_CORE << 24) | 0x00100100,
    PS_CORE_IDLE_491M52    = (CLK_PS_CORE << 24) | 0x00100200,
    PS_CORE_IDLE_312M      = (CLK_PS_CORE << 24) | 0x00100300,
    PS_CORE_IDLE_208M      = (CLK_PS_CORE << 24) | 0x00100400,
    PS_CORE_IDLE_104M      = (CLK_PS_CORE << 24) | 0x00100500,
    PS_CORE_IDLE_78M       = (CLK_PS_CORE << 24) | 0x00100600,
    PS_CORE_IDLE_52M       = (CLK_PS_CORE << 24) | 0x00100700,

    /* EDCP WCLK*/
	WCLK_EDCP_208M = (CLK_EDCPASYNC_ACLK << 24) | 0x00100000,
	WCLK_EDCP_26M  = (CLK_EDCPASYNC_ACLK << 24) | 0x00100100,
	WCLK_EDCP_156M = (CLK_EDCPASYNC_ACLK << 24) | 0x00100200,
	WCLK_EDCP_104M = (CLK_EDCPASYNC_ACLK << 24) | 0x00100300,
	
	/*NAND WCLK*/
	WCLK_NAND_104M = (CLK_NAND_WCLK << 24) | 0x00100000,
	WCLK_NAND_26M  = (CLK_NAND_WCLK << 24) | 0x00100100,
	WCLK_NAND_78M  = (CLK_NAND_WCLK << 24) | 0x00100200,
	WCLK_NAND_52M  = (CLK_NAND_WCLK << 24) | 0x00100300,

	/* SD0 WCLK*/
	WCLK_SD0_200M = (CLK_SD0_WCLK << 24) | 0x00100000,
	WCLK_SD0_26M  = (CLK_SD0_WCLK << 24) | 0x00100100,
	WCLK_SD0_156M = (CLK_SD0_WCLK << 24) | 0x00100200,
	WCLK_SD0_100M = (CLK_SD0_WCLK << 24) | 0x00100300,
	WCLK_SD0_78M  = (CLK_SD0_WCLK << 24) | 0x00100400,
	WCLK_SD0_50M  = (CLK_SD0_WCLK << 24) | 0x00100500,
	WCLK_SD0_178M = (CLK_SD0_WCLK << 24) | 0x00100600,
	WCLK_SD0_25M  = (CLK_SD0_WCLK << 24) | 0x00100700,

	/* SD1 WCLK*/
	WCLK_SD1_100M = (CLK_SD1_WCLK << 24) | 0x00100000,
	WCLK_SD1_26M  = (CLK_SD1_WCLK << 24) | 0x00100100,
	WCLK_SD1_78M  = (CLK_SD1_WCLK << 24) | 0x00100200,
	WCLK_SD1_50M  = (CLK_SD1_WCLK << 24) | 0x00100300,
	WCLK_SD1_39M  = (CLK_SD1_WCLK << 24) | 0x00100400,
	WCLK_SD1_25M  = (CLK_SD1_WCLK << 24) | 0x00100500,
	

	/* I2S WCLK*/
	/*I2S not be used in zx297520, so ignore it's clock*/
	WCLK_I2S_26M  = (CLK_I2S0_WCLK << 24) | 0x00200000,
	WCLK_I2S_104M = (CLK_I2S0_WCLK << 24) | 0x00200100,

	/* BLG WCLK*/
	/* blg work clock used default 32KHz*/

    /*SPIFC WCLK*/
	WCLK_SPIFC_156M   = (CLK_SPIFC_WCLK << 24) | 0x00100000,
	WCLK_SPIFC_26M    = (CLK_SPIFC_WCLK << 24) | 0x00100100,
	WCLK_SPIFC_124M8  = (CLK_SPIFC_WCLK << 24) | 0x00100200,
	WCLK_SPIFC_104M   = (CLK_SPIFC_WCLK << 24) | 0x00100300,
	WCLK_SPIFC_78M    = (CLK_SPIFC_WCLK << 24) | 0x00100400,
	WCLK_SPIFC_52M    = (CLK_SPIFC_WCLK << 24) | 0x00100500,

    /*AON TIMER WCLK timer1&timer2&timer3*/
    WCLK_AON_TIMER_32K = (CLK_TIMER1_WCLK << 24) | 0x00300100,
    WCLK_AON_TIMER_26M = (CLK_TIMER1_WCLK << 24) | 0x00300000,     /* 1 div*/
	WCLK_AON_TIMER_13M = (CLK_TIMER1_WCLK << 24) | 0x00300001,     /* 2 div*/

	/*LSP TIMER0 WCLK timer0&timer4*/
    WCLK_LSP_TIMER_32K = (CLK_TIMER0_WCLK << 24) | 0x00200000,
    WCLK_LSP_TIMER_26M = (CLK_TIMER0_WCLK << 24) | 0x00200100,     /* 1 div*/
	WCLK_LSP_TIMER_13M = (CLK_TIMER0_WCLK << 24) | 0x00200101,     /* 2 div*/

	/* RM I2C WCLK*/
	WCLK_RMI2C_26M  = (CLK_RMI2C_WCLK << 24) | 0x00100100,
	WCLK_RMI2C_104M = (CLK_RMI2C_WCLK << 24) | 0x00100000,
	
	/* I2C1 WCLK*/
	WCLK_I2C1_26M  = (CLK_I2C1_WCLK << 24) | 0x00100000,
	WCLK_I2C1_104M = (CLK_I2C1_WCLK << 24) | 0x00100100,


    /* UART WCLK*/
    WCLK_UART0_26M  = (CLK_UART0_WCLK << 24) | 0x00100100,
    WCLK_UART0_104M = (CLK_UART0_WCLK << 24) | 0x00100000,

	WCLK_UART12_26M  = (CLK_UART1_WCLK << 24) | 0x00200000,
    WCLK_UART12_104M = (CLK_UART1_WCLK << 24) | 0x00200100,

    /* SSP WCLK*/
    WCLK_SSP_0M  = (CLK_SSP0_WCLK << 24) | 0x00200301,
    WCLK_SSP_6M5 = (CLK_SSP0_WCLK << 24) | 0x00200203,
    WCLK_SSP_13M = (CLK_SSP0_WCLK << 24) | 0x00200201,
    WCLK_SSP_26M = (CLK_SSP0_WCLK << 24) | 0x00200200,
    WCLK_SSP_52M = (CLK_SSP0_WCLK << 24) | 0x00200101,
    WCLK_SSP_78M = (CLK_SSP0_WCLK << 24) | 0x00200001,
    WCLK_SSP_156M = (CLK_SSP0_WCLK << 24) | 0x00200000,

    /* WDT WCLK*/
    WCLK_WDT_32K  = (CLK_WDT_WCLK << 24) | 0x00100000,
    WCLK_WDT_26M  = (CLK_WDT_WCLK << 24) | 0x00100100,

    /* USIM WCLK */
    /* usim work clock is fixed 13MHz*/
    /*WCLK_USIM_13M = (CLK_USIM_WCLK << 24) | 0x0010ffff,*/

    /* RTC WCLK */
    /* rtc work clock is fixed 32KHz*/
    /*WCLK_RTC_32K = (CLK_RTC_WCLK << 24) | 0x0010ffff,*/

    /* KEY WCLK */
    /* KEY work clock is fixed 32KHz*/
    /*WCLK_KEY_32K = (CLK_RTC_WCLK << 24) | 0x0010ffff,*/
	
	/*AON_CLK_OUT1*/
	/*
	 CLK_OUT1_40M  = (CLK_WIFI_BT << 24) | 0x00100300,
       CLK_OUT1_20M  = (CLK_WIFI_BT << 24) | 0x00100200,
       CLK_OUT1_26M  = (CLK_WIFI_BT << 24) | 0x00100100,
	CLK_OUT1_13M  = (CLK_WIFI_BT << 24) | 0x00100000,
	*/

} T_ZDrvSysClk_Freq;

#endif


typedef enum
{
    SYSCLK_DISABLE = 0x100,   /*disable  software gate */
    SYSCLK_ENABLE,            /*enable   software gate */
    SYSCLK_DISAUTO,           /*disable  hardware gate */
    SYSCLK_AUTO,              /*enable   hardware gate */
} T_ZDrvSysClk_Gate;


/****************************************************************************
*                                           function
****************************************************************************/
/*******************************************************************************
* Function: zDrvSys_PreInit
* Description: system previous initialization
* Parameters:
*	Input:
*
*	Output:
*
* Returns:
*
* Others:
********************************************************************************/
SINT32 zDrvSys_PreInit(void);

/*******************************************************************************
* Function: zDrvSys_Initiate
* Description: system initialization
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
SINT32 zDrvSys_Initiate(void);

/*******************************************************************************
* Function:    zDrvSysClk_IsEnable
* Description: get clock software gate status
* Parameters:
*   Input:
*           name: clock number
*
*   Output: NULL
*
* Returns: 0: software gate disable
*          1: software gate enable
*          DRV_ERR_INVALID_PARAM: invalid parameter
*
* Others:
********************************************************************************/
SINT32 zDrvSysClk_IsEnable(T_ZDrvSysClk_Name name);


/*******************************************************************************
* Function:    zDrvSysClk_IsAutoGate
* Description: get clock hardware gate status
* Parameters:
*   Input:
*           name: clock number
*
*   Output: NULL
*
* Returns: 0: hardware gate disable
*          1: hardware gate enable
*          DRV_ERR_INVALID_PARAM:invalid parameter
*
* Others:
********************************************************************************/
SINT32 zDrvSysClk_IsAutoGate(T_ZDrvSysClk_Name name);


/*******************************************************************************
 * Function:    zDrvSysClk_Reset
 * Description: set logic to reset status
 * Parameters:
 *   Input:
 *           name: clock number
 *
 *   Output: NULL
 *
 * Returns: DRV_SUCCESS
 *          DRV_ERR_INVALID_PARAM
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvSysClk_Reset(T_ZDrvSysClk_Name name);

/*******************************************************************************
 * Function:    zDrvSysClk_Release
 * Description:  set logic out of reset status
 * Parameters:
 *   Input:
 *           name: clock number
 *
 *   Output: NULL
 *
 * Returns: DRV_SUCCESS
 *          DRV_ERR_INVALID_PARAM
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvSysClk_Release(T_ZDrvSysClk_Name name);

/*******************************************************************************
* Function:    zDrvSysClk_SetGate
* Description:  set clock gate status
* Parameters:
*   Input:
*           name: clock number
*           gate: gate status
*   Output: NULL
*
* Returns: DRV_SUCCESS
*          DRV_ERR_INVALID_PARAM
*
* Others:
********************************************************************************/
SINT32 zDrvSysClk_SetGate(T_ZDrvSysClk_Name name, T_ZDrvSysClk_Gate gate);

/*******************************************************************************
* Function: zDrvSysClk_SetFreq
* Description: set clock frequency which defined in drvs_sys.h by T_ZDrvSysClk_Freq
* Parameters:
 *   Input:
 *           name: clock number
*            freq: clock frequency
*   Output: NULL
*
* Returns:  DRV_SUCCESS
*           DRV_ERR_INVALID_PARAM
* Others:
********************************************************************************/
SINT32 zDrvSysClk_SetFreq(T_ZDrvSysClk_Name name, T_ZDrvSysClk_Freq freq);

#endif

#endif

