/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v0.1
 * Author:        wuhui
 * Date:          2016-12-17
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_VOU_REF_H
#define _DRVS_VOU_REF_H



/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_chip_cfg.h"
#include "drvs_sys.h"
#include "drvs_vou.h"


/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define MAIN_CHANNEL 0     
#define MCU_LCD 1  

//BASE ADDRESSS
#define OSD_CSC_BASE          (VOU_CTRL_BASE+0x0000)
#define OSD_GLOBAL_BASE       (VOU_CTRL_BASE+0x2000) 

#define OSD_VL_CFG_BASE       (OSD_GLOBAL_BASE+0x024) 
#define OSD_GL_CFG_BASE       (OSD_GLOBAL_BASE+0x090) 
#define OSD_MAIN_CHANL_BASE   (OSD_GLOBAL_BASE+0x114) 
#define OSD_WB_CFG_BASE   	  (OSD_GLOBAL_BASE+0x14C)

/*VOU CLK CFG ADDRESS*/
#define VOU_DIF_CFG_BASE   	  (SOC_CRM_REG_BASE+0x164)
#define VOU_DIF_CTRL_OFFSET     16

#define MAX_OSD_OUTSTAND_DEPTH 15
#define OSD_VALID_FMARK_OFFSET 18
#define OSDCTRL1_H_BLANK_OFFSET 2
#define OSDCTRL1_V_BLANK_OFFSET 10
#define OSDCTRL1_BLANK_SIZE 8
#define OSDCTRL1_MCU_OFFSET 0

#define OSDCTRL0_OUTSTAND_DEPTH_OFFSET 16
#define OSDCTRL0_OUTSTAND_DEPTH_SIZE 4
#define OSDCTRL0_VL_ENABLE_OFFSET 11
#define OSDCTRL0_VL_CHANNEL_OFFSET 10
#define OSDVL0CTRL0_VL_PRIO_OFFSET 24
#define OSDVL0CTRL0_VL_PRIO_SIZE 3
#define OSDVL0CTRL0_VL_STARTX_OFFSET 12
#define OSDVL0CTRL0_VL_STARTXY_SIZE 12
#define OSDVL0CTRL0_VL_STARTY_OFFSET 0
#define OSDVL0CTRL0_VL_YUV420PLA_OFFSET 24
#define OSDVL0CTRL0_VL_YUV422ENABLE_OFFSET 25
#define OSDVL0CTRL0_VL_YUV422SEQ_OFFSET 26
#define OSDVL0CTRL0_VL_YUV422SEQ_SIZE 2
#define OSDVL0STRI_VL_LUMASTR_OFFSET 16
#define OSDVL0STRI_VL_STR_SIZE 16
#define OSDVL0STRI_VL_CHROMSTR_OFFSET 0
#define OSDVL0SRCHW_VL_SRCW_OFFSET 16
#define OSDVL0SRCHW_VL_SRCHW_SIZE 14
#define OSDVL0SRCHW_VL_SRCH_OFFSET 0
#define OSDVL0ALP_VL_GALPENABLE_OFFSET 0
#define OSDVL0ALP_VL_GALPVAL_OFFSET 8
#define OSDVL0ALP_VL_GALPVAL_SIZE 8

#define OSDCTRL0_GL_ENABLE_OFFSET 5
#define OSDCTRL0_GL_CHANNEL_OFFSET 4
#define OSDGL0CTRL0_GL_PRIO_OFFSET 24
#define OSDGL0CTRL0_GL_PRIO_SIZE 3
#define OSDCTRL0_GL_ENDIANSEL_OFFSET 27
#define OSDGL0CTRL0_GL_POSX_OFFSET 12
#define OSDGL0CTRL0_GL_POSXY_SIZE 12
#define OSDGL0CTRL0_GL_POSY_OFFSET 0
#define OSDGL0CTRL1_GL_FORMAT_OFFSET 24
#define OSDGL0CTRL1_GL_FORMAT_SIZE 4
#define OSDGL0CTRL2_GL_ALP_A0RGB1555_OFFSET 24
#define OSDGL0CTRL2_GL_ALP_VAL_SIZE 8
#define OSDGL0CTRL2_GL_ALP_A1RGB1555_OFFSET 16
#define OSDGL0CTRL2_GL_GALP_OFFSET 8
#define OSDGL0CTRL2_GL_ALPRANG_OFFSET 3
#define OSDGL0CTRL2_GL_ALPMODE_OFFSET 4
#define OSDGL0CTRL2_GL_ALPMODE_SIZE 2
#define OSDGL0CTRL2_GL_EXTDIR_OFFSET 2
#define OSDGL0CTRL2_GL_EXTTYPE_OFFSET 0
#define OSDGL0CTRL2_GL_EXTTYPE_SIZE 2
#define OSDGL0STRI_GL_STRI_OFFSET 0
#define OSDGL0STRI_GL_STRI_SIZE 14
#define OSDGL0KEY_GL_CKALP_OFFSET 24
#define OSDGL0KEY_GL_CKALP_SIZE 8
#define OSDGL0KEY_GL_CKRGB_SIZE 8
#define OSDGL0KEY_GL_CKR_OFFSET 16
#define OSDGL0KEY_GL_CKG_OFFSET 8
#define OSDGL0KEY_GL_CKB_OFFSET 0
#define OSDGL0KEYMIN1_GL_CKREG1_ENABLE_OFFSET 31
#define OSDMCTRL1_MC_SCRW_OFFSET 20
#define OSDMCTRL1_MC_SCRWH_SIZE 12
#define OSDMCTRL1_MC_SCRH_OFFSET 8
#define OSDMBGCTRL_MC_R_OFFSET 16
#define OSDMBGCTRL_MC_G_OFFSET 8
#define OSDMBGCTRL_MC_B_OFFSET 0
#define OSDMBGCTRL_MC_RGB_SIZE 8
#define OSDMCTRL0_MC_ENABLE_OFFSET 0
#define OSDMUPT_ENABLE_OFFSET 0


#define OSDWBCTRL0_WB_STRIDE_OFFSET 12
#define OSDWBCTRL0_WB_STRIDE_SIZE 16
#define OSDWBCTRL0_WB_ENABLE_OFFSET 0
#define OSDWBCTRL0_WB_BUFNUM_OFFSET 10
#define OSDWBCTRL0_WB_BUFNUM_SIZE 2
#define OSDWBCTRL0_WB_PERIOD_OFFSET 7
#define OSDWBCTRL0_WB_PERIOD_SIZE 3
#define OSDWBCTRL0_WB_FORMAT_OFFSET1 3
#define OSDWBCTRL0_WB_FORMAT_OFFSET2 4

#define CSC_ENABLE_OFFSET 16
#define CSC_MODE_OFFSET 0
#define CSC_MODE_SIZE 16
#define CSC_AC_OFFSET 16
#define CSC_BD_OFFSET 0
#define CSC_ACBD_SIZE 16
#define CSC_SPACE_FLOOR_OFFSET 16
#define CSC_SPACE_TOP_OFFSET 0
#define CSC_SPACE_LEVEL_SIZE 8

/*OSD interrupt status bit offset*/
#define OSD_MC_FINISH_OFFSET 0
#define OSD_CFG_ERROR_OFFSET 2
#define OSD_BUS_ERROR_OFFSET 3
#define OSD_VL_BWLOW_OFFSET 7
#define OSD_GL_BWLOW_OFFSET 10
#define OSD_MC_REGUPT_OFFSET 13
#define OSD_WR_FINISH_OFFSET 24
#define OSD_WR_OVERFLOW_OFFSET 25

#define set_reg_bit(regName, bitAddr, bitValue)      \
do{                                                  \
    if(bitValue == TRUE)                             \
        reg32(regName) |= (0x1<<bitAddr);            \
    else                                             \
        reg32(regName) &= ~(0x1<<bitAddr);           \
}while(0)

#define set_reg_bits(regName, bitsAddr, bitsLen, bitsValue)   \
do{                                                             \
    reg32(regName) = (reg32(regName)&(~(((0x1<<bitsLen)-0x1)<<bitsAddr)))|(bitsValue<<bitsAddr);\
}while(0)


/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum
{
	EPOSEDGE_VALID = 0,
	eNEGEDGE_VALID = 1,
	MAX_POLARITY_TYPE =2
}E_MCU_FMARK_POLARITY;

typedef volatile struct _T_OSDGlobal_Regs
{ 
    UINT32 OSD_VER;                 //0x00  
    UINT32 OSD_INT_STA;             //0x04 
    UINT32 OSD_CLRINT_STA;          //0x08  
    UINT32 OSD_INT_MSK;             //0x0C   
    UINT32 OSD_CTRL0;               //0x10   
}T_OSDGlobal_Regs;          

typedef volatile struct _T_OSD_VL_Regs
{ 
    UINT32 OSD_VL0_CTRL0;           //0x024  
    UINT32 OSD_VL0_CTRL1;           //0x028
    UINT32 RESERVED0;					 
    UINT32 OSD_VL0_STRI;            //0x30  
    UINT32 OSD_VL0_SRC_HW;          //0x34   
    UINT32 OSD_VL0_Y;               //0x38   
    UINT32 OSD_VL0_U;               //0x3C 
    UINT32 OSD_VL0_V;               //0x40 
    UINT32 OSD_VL0_ALP;             //0x44 
}T_OSD_VL_Regs; 

typedef volatile struct _T_OSD_GL_Regs
{ 
    UINT32 OSD_GL0_CTRL0;                //0x090  
    UINT32 OSD_GL0_CTRL1;                //0x094
    UINT32 OSD_GL0_CTRL2;                //0x098
    UINT32 RESERVED0;                    //0x09C
    UINT32 OSD_GL0_STRI;                 //0x0A0
    UINT32 OSD_GL0_ADDR;                 //0x0A4
    UINT32 RESERVED1;                    //0x0A8
    UINT32 OSD_GL0_KEY_MIN0;             //0x0AC
    UINT32 OSD_GL0_KEY_MAX0;             //0x0B0
    UINT32 OSD_GL0_KEY_MIN1;             //0x0B4
    UINT32 OSD_GL0_KEY_MAX1;             //0x0B8				    
}T_OSD_GL_Regs; 

typedef volatile struct _T_OSD_MainChanel_Regs
{ 
    UINT32 OSD_MAIN_CHANL_CTRL0;          //0x114  
    UINT32 OSD_MAIN_CHANL_CTRL1;          //0x118
    UINT32 OSD_MAIN_CHANL_UPT;            //0x11C
    UINT32 RESERVED0;				      //0x120
    UINT32 OSD_MAIN_BG_CTRL;              //0x124
    UINT32 RESERVED[5];					  //0x128~0x138
 	UINT32 OSD_CTRL1;                     //0x13C	
}T_OSD_MainChanel_Regs; 

typedef volatile struct _T_OSD_WB_Regs
{ 
    UINT32 OSD_WB_CTRL0;                  //0x14C 
    UINT32 OSD_WB_CTRL1;                  //0x150 
    UINT32 OSD_WB_ADDR0;                  //0x154 
    UINT32 OSD_WB_ADDR1;                  //0x158 
    UINT32 OSD_WB_ADDR2;                  //0x15C 
    UINT32 OSD_WB_ADDR3;                  //0x160
}T_OSD_WB_Regs; 

typedef volatile struct _T_OSD_CSC_Regs
{ 
    UINT32 OSD_CSC_MODE;              //0x00 
    UINT32 OSD_A1_B1;                 //0x04
    UINT32 OSD_C1_D1;                 //0x08
    UINT32 OSD_A2_B2;				  //0x0C
    UINT32 OSD_C2_D2;                 //0x10
    UINT32 OSD_A3_B3;                 //0x14
    UINT32 OSD_C3_D3;                 //0x18	
    UINT32 OSD_SPACE_IN1;             //0x1C
    UINT32 OSD_SPACE_IN2;             //0x20
    UINT32 OSD_SPACE_IN3;             //0x24
    UINT32 OSD_SPACE_OUT1;            //0x28
    UINT32 OSD_SPACE_OUT2;            //0x2C
    UINT32 OSD_SPACE_OUT3;            //0x30
}T_CSC_Regs; 

typedef volatile struct _T_VOU_Regs
{ 
	T_OSDGlobal_Regs *ptOSDGlobal;
	T_OSD_VL_Regs *ptOSDVL;
	T_OSD_GL_Regs *ptOSDGL;
	T_OSD_MainChanel_Regs *ptOSDMC;
	T_OSD_WB_Regs *ptOSDWB;
	T_CSC_Regs *ptOSDCSC;
}T_VOU_Regs; 

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
SINT32 zDrvVOU_Open(void);
void zDrvVOU_GetDevInfo(T_ZDrv_OSDInfo *ptDevInfo);
SINT32 	zDrvVOU_Close(VOID);
SINT32 zDrvVOU_OneFrame(T_ZDrv_VOU_OSDPara *ptOSDPara);
SINT32 zDrvVOU_WBParaUpdate(T_ZDrv_VOU_WBPara *ptWBPara);
void zDrvVOU_ClkCtrl(T_ZDrvSysClk_Gate ClkCtrl);



#endif/*_FILENAME_H*/

