/* ------------------------------------------------------------------
 * Copyright (C) 2009 Martin Storsjo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */


#define AMRNB_WRAPPER_INTERNAL
#include <sp_dec.h>
#include <amrdecode.h>
#include <amrencode.h>
#include "interf_dec.h"
#include "interf_enc.h"
//#include <stdlib.h>
#include "oss_clib.h"

void* Decoder_Interface_init(void)
{
	void* ptr = NULL;
	int ret = GSMInitDecode(&ptr, (int8*)"Decoder");
	if (ret == -1)
	{
		return NULL;
	}

	return ptr;
}

void Decoder_Interface_exit(void* state)
{
	GSMDecodeFrameExit(&state);

}


long Decoder_Interface_Decode(void* state, const unsigned char* in, short* out, long format)
{
	unsigned char type;
	int ret = 0;

	if (format == 1)
	{
		type = in[0] & 0x0f;
		ret = AMRDecode(state, (enum Frame_Type_3GPP) type, (UWord8*) in, out, IF2);
	}
	if (format == 2)
	{
		type = (in[0] >> 3) & 0x0f;
		in++;
		ret = AMRDecode(state, (enum Frame_Type_3GPP) type, (UWord8*) in, out, MIME_IETF);
	}
	if (ret == -1)
	{
		return 0;
	}
	else
	{
		return 160;
	}


}

struct encoder_state
{
	void* encCtx;
	void* pidSyncCtx;
};

void* Encoder_Interface_init(long dtx)
{
	struct encoder_state* state = (struct encoder_state*) malloc(sizeof(struct encoder_state));
	if (state == NULL)
		return NULL;
	long ret = 0;
	ret = AMREncodeInit(&state->encCtx, &state->pidSyncCtx, dtx);
	if (ret == -1)
	{
		free(state);
		state = NULL;
	}
	return state;
}

void Encoder_Interface_exit(void* s)
{
	struct encoder_state* state = (struct encoder_state*) s;
	AMREncodeExit(&state->encCtx, &state->pidSyncCtx);
	free(state);
}

//int Encoder_Interface_Encode(void* s, enum Mode mode, const short* speech, unsigned char* out, int forceSpeech) {
long Encoder_Interface_Encode(void* s, long mode, const short* speech, unsigned char* out, long format)
{
	struct encoder_state* state = (struct encoder_state*) s;
	enum Frame_Type_3GPP frame_type;
	int ret = 0;
	/*cxx*/
	mode = mode > 8 ? 7 : mode;
	frame_type = (enum Frame_Type_3GPP)mode;

	if (format == 1)
	{
		ret = AMREncode(state->encCtx, state->pidSyncCtx, (enum Mode)mode, (Word16*) speech, out, &frame_type, AMR_TX_IF2);
	}
	if (format == 2)
	{
		ret = AMREncode(state->encCtx, state->pidSyncCtx, (enum Mode)mode, (Word16*) speech, out, &frame_type, AMR_TX_IETF);
		out[0] |= 0x04;
	}
	return ret;
}

