/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  This source file contains the T=0 transport handler statemachine engine.
 * Others:        
 * Version:       v0.1
 * Author:        mtr
 * Date:          2007-03-28
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/


/****************************************************************************
*                                              Include files
****************************************************************************/
#include "uicc_stub.h"
    
#include "uicc.h"
#include "uicc_ctrl.h"
#include "uicc_access.h"
#include "uicc_drv.h"
#include "uicc_trc.h"
        
#ifndef UICC_NO_DEBUG
  #include "trap.h"
#endif


/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Variables
****************************************************************************/
static ubyte *apdu_data_ptr_start; 
static ubyte *apdu_data_ptr_current; 
static ushort tot_cnt, cnt;
static ubyte le_offset;
static ubyte extended_len_handling;
    
#ifndef UICC_NO_DEBUG
  static T_UICC_T0_TRANS_CTRL_STATE debug = UICC_T0_TRANS_NONE;
#endif

#define UICC_GET_RESPONSE_SEGMENT_SUPPORTED   

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
T_UICC_T0_TRANS_CTRL_STATE UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;


/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
* Function:... initiate_cmd
* Parameters:. None.
* Returns:.... None.
* Description: This function triggers the T0 cmd statemachine to initiate the 
*              command execution (event UICC_INITIATE_CMD).
* Created:.... 10.05.04 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
static void initiate_cmd(void)
{
  UICC_t0_cmd_handler(UICC_INITIATE_CMD);
}

/*******************************************************************************
* Function:... rebuild_cmd
* Parameters:. size: codes the SW2 value e.g. as in '6C' 'xx'
* Returns:.... None.
* Description: This function rebuilds the previous command by setting P3 to xx.
* Created:.... 03.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
static void rebuild_cmd(ubyte size)
{
  UICC_tpdu_data[UICC_P3_POS] = size;
  UICC_t0_tpdu_ctrl.data_size = size;
}

/*******************************************************************************
* Function:... build_get_resp
* Parameters:. rx_size     Codes the SW2 value e.g. as in '61' 'xx'
*              cla_coding  The coding of the CLA byte (difference in GSM and 3G).
* Returns:.... None.
* Description: This function builds the GET RESPONSE command setting P3 to xx.
* Created:.... 03.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
static void build_get_resp(ubyte cla_coding, ushort rx_size)
{
  UICC_t0_tpdu_ctrl.cmd_direction = UICC_RX_CMD;
  UICC_t0_tpdu_ctrl.data_size     = rx_size;

  /* The two least significent bits of the APDU CLA byte holdes the used logical channel number. This number 
     should also be used for the GET RESPONSE command. */
  UICC_tpdu_data[UICC_CLA_POS]    = cla_coding | (UICC_apdu.header.cla & 0x03);
  UICC_tpdu_data[UICC_INS_POS]    = 0xC0;
  UICC_tpdu_data[UICC_P1_POS]     = 0x00;
  UICC_tpdu_data[UICC_P2_POS]     = 0x00; 
  UICC_tpdu_data[UICC_P3_POS]     = (rx_size == 256)? 0: rx_size; 
}

/*******************************************************************************
* Function:... build_envelope_cmd
* Parameters:. tx_size      Codes the size of the envelope command.
* Returns:.... None.
* Description: This function builds an ENVELOPE command.
* Created:.... 03.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
static void build_envelope_cmd(ubyte tx_size)
{
  UICC_t0_tpdu_ctrl.cmd_direction = UICC_TX_CMD;
  UICC_t0_tpdu_ctrl.data_size     = tx_size;
  UICC_tpdu_data[UICC_CLA_POS]    = 0xC0;
  UICC_tpdu_data[UICC_INS_POS]    = 0xC2;
  UICC_tpdu_data[UICC_P1_POS]     = 0x00;
  UICC_tpdu_data[UICC_P2_POS]     = 0x00; 
  UICC_tpdu_data[UICC_P3_POS]     = tx_size; 
}

/*******************************************************************************
* Function:... copy_received_data
* Parameters:. None.
* Returns:.... If a state change should be carried out following this function 
*              call.
* Description: This function copies recived data to the apdu payload buffer and 
*              performs an overflow check. If overflow occurs, the overflow state
*              change is flage in a TRUE return value.
* Created:.... 19.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
static BOOL copy_received_data(void)
{
  BOOL return_status = FALSE; /* No overflow state shift is required. */

  tot_cnt += cnt;

  if((tot_cnt > UICC_apdu.header.le) && (UICC_apdu.header.le))
  { /* More data than requested has now been read */
   ushort temp = cnt - (tot_cnt - UICC_apdu.header.le);
 
   UICC_apdu.footer.luicc = UICC_apdu.header.le; 
   #if defined (UICC_FIFO_MODE)
     memcpy(apdu_data_ptr_current, UICC_tpdu_data_ptr+3, temp); //+3 for alignment
   #else
     memcpy(apdu_data_ptr_current, UICC_tpdu_data_ptr, temp);
   #endif

   apdu_data_ptr_current += temp;
   return_status = TRUE; /* Overflow must be indicated in order to reach the 
                            owerflow state. */
  }
  else
  {
   UICC_apdu.footer.luicc = tot_cnt;
   #if defined (UICC_FIFO_MODE)
     memcpy(apdu_data_ptr_current, UICC_tpdu_data_ptr+3, cnt); //+3 for alignment
   #else
     memcpy(apdu_data_ptr_current, UICC_tpdu_data_ptr, cnt);
   #endif
   apdu_data_ptr_current += cnt;
  }

  return(return_status);  
}


/*******************************************************************************
* Function:... UICC_t0_transport_handler
* Parameters:. event: the triggering event.
* Returns:.... None.
* Description: This state machine/engine is controlling the transport execution 
*              of the T=0 protocol
* Created:.... 02.10.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_t0_transport_handler(T_UICC_T0_TRANS_EVENTS event)
{
#ifdef UICC_DEBUG_INF
  UICC_debug_t0[UICC_debug_count_t0][0] = 5;  
UICC_debug_t0[UICC_debug_count_t0][1] = UICC_t0_trans_ctrl_state;
UICC_debug_t0[UICC_debug_count_t0][2] = event;
UICC_debug_count_t0 = (UICC_debug_count_t0+1) % 500;
#endif


  switch(UICC_t0_trans_ctrl_state)
  {
    /*=================================================*/
    /* Inactive - ready to receive instruction request */
    /*=================================================*/
    case UICC_T0_TRANS_READY:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_INITIATE_INS:
        /*----------------------------*/
          /* Initialise response data. */ 
          UICC_apdu.footer.luicc = 0;
          UICC_apdu.footer.sw1   = 0x11;
          UICC_apdu.footer.sw2   = 0x22;
          extended_len_handling = FALSE;
          
          /* Initialize the APDU data pointers. */
          apdu_data_ptr_start   = UICC_apdu.payload_ptr;
          apdu_data_ptr_current = UICC_apdu.payload_ptr;

          /* Initialize the data counters. */
          tot_cnt = 0;
          cnt     = 0;
          le_offset = 0;
          
          /* Then build the rest of the command. */
          switch(UICC_apdu.command_case)
          {
            case UICC_CMD_CASE_1: /* No Tx not Rx */
            /*------------------*/
              UICC_t0_trans_ctrl_state = UICC_CASE_1_CMD;
              /* Initialize command header and data stores. */
              memcpy(&UICC_tpdu_data[UICC_CLA_POS], &UICC_apdu.header, 4);/*change 071219*/
              UICC_tpdu_data[UICC_P3_POS]     = 0;
              UICC_t0_tpdu_ctrl.data_size     = 0;
              UICC_t0_tpdu_ctrl.cmd_direction = UICC_RX_CMD;              
              break;

            case UICC_CMD_CASE_2: /* Rx */
            /*------------------*/
              UICC_t0_trans_ctrl_state = UICC_RX_HANDLING_CASE_2_4_CMD;
              /* Initialize command header and data stores. */
              memcpy(&UICC_tpdu_data[UICC_CLA_POS], &UICC_apdu.header, 4);/*change 071219*/

              cnt = ((UICC_apdu.header.le == 0) || (UICC_apdu.header.le >= 256)) ? 256 : UICC_apdu.header.le;
              UICC_tpdu_data[UICC_P3_POS]     = (cnt == 256) ? 0 : cnt; /* Rx data size in P3 */                           
              UICC_t0_tpdu_ctrl.data_size     = cnt;
              UICC_t0_tpdu_ctrl.cmd_direction = UICC_RX_CMD;              
              break;

            case UICC_CMD_CASE_3: /* Tx */
            case UICC_CMD_CASE_4: /* Tx and Rx */
            /*------------------*/
              UICC_t0_trans_ctrl_state = (UICC_apdu.command_case == UICC_CMD_CASE_4) ? UICC_TX_HANDLING_CASE_4_CMD : UICC_TX_HANDLING_CASE_3_CMD;

              /* Initialize command header and data stores. */
              if(UICC_apdu.header.lc <= 255)
              { /* NO extended Le/Lc handling required for the Tx handling. */
                /* Build the command to be transferred. */
                extended_len_handling = FALSE;
                memcpy(&UICC_tpdu_data[UICC_CLA_POS], &UICC_apdu.header, 4);/*change 071219*/
                cnt = UICC_apdu.header.lc;                
                memcpy(UICC_tpdu_data_ptr, apdu_data_ptr_start, cnt);
                UICC_tpdu_data[UICC_P3_POS]     = cnt;
                UICC_t0_tpdu_ctrl.data_size     = cnt;
              }
              else 
              { /* Extended Lc is required which means that the APDU command are encapsulated
                   in one or more envelope commands (including the command header). */
                extended_len_handling = TRUE;
                build_envelope_cmd(255);
                memcpy(UICC_tpdu_data_ptr, &UICC_apdu.header, 4); /* Header without Lc  change 071219*/
                *(UICC_tpdu_data_ptr + 4) = 0x00;                     /* B1 of Lc */
                *(UICC_tpdu_data_ptr + 5) = UICC_apdu.header.lc>>8;   /* B2 of Lc */
                *(UICC_tpdu_data_ptr + 6) = UICC_apdu.header.lc;      /* B3 of Lc */
                tot_cnt = cnt = 255 - 7; /* 7: must be room for CLA,INS,P1,P2,B1,B2,B3 as part 
                                               of the payload of the envelope command. */
                memcpy((UICC_tpdu_data_ptr + 7), apdu_data_ptr_start, cnt);
                apdu_data_ptr_current += cnt;                 
              }  

              UICC_t0_tpdu_ctrl.cmd_direction = UICC_TX_CMD;              
              break;
          }   
          initiate_cmd();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*========================================================*/
    /* Executing Case 1 (no Rx not Tx) or case 3 (Tx) command */
    /*========================================================*/
    case UICC_CASE_1_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:
        /*----------------------------*/

          UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
          UICC_apdu.footer.luicc = 0; /* No Rx data */
          UICC_apdu.footer.sw1 = UICC_tpdu_footer.sw1;
          UICC_apdu.footer.sw2 = UICC_tpdu_footer.sw2;
          UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*===============================*/
    /* Executing Case 2 (Rx) command */
    /*===============================*/
    case UICC_RX_HANDLING_CASE_2_4_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:        
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
             case 0x61: /* Request to send GET RESPONSE using P3=xx */
			#ifdef  UICC_GET_RESPONSE_SEGMENT_SUPPORTED
			{
				UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
				copy_received_data();
				UICC_apdu.footer.sw1 = UICC_tpdu_footer.sw1;
				UICC_apdu.footer.sw2 = UICC_tpdu_footer.sw2;
				UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK); 
			}
			#else
			{
               UICC_t0_trans_ctrl_state = UICC_GET_RESPONSE_AFTER_61H;
              
               /* Copy data if data is received. */
               if(event == UICC_T0_CMD_SUCCEEDED)
               {
                 if(copy_received_data())
                   UICC_t0_trans_ctrl_state = UICC_OVERFLOW_HANDLING;
               }
               cnt = UICC_tpdu_footer.sw2;
               build_get_resp(0x00, cnt);
               initiate_cmd();
			}
			#endif
               break;

             case 0x6C: /* Request to resend command using P3=xx */
               UICC_t0_trans_ctrl_state = UICC_RESEND_CMD;

               /* Copy data if data is received. */
               if(event == UICC_T0_CMD_SUCCEEDED)
               {
                 if(copy_received_data())
                   UICC_t0_trans_ctrl_state = UICC_OVERFLOW_HANDLING;
               }
               cnt = UICC_tpdu_footer.sw2;
               rebuild_cmd(cnt);
               initiate_cmd();
               break;

             case 0x90: /* The command succeeded without the need to resend the command. */
             case 0x91:
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               copy_received_data();
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;

             default:
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;
           } 
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*===================================*/
    /* Executing Case 3 command handling */
    /*===================================*/
    case UICC_TX_HANDLING_CASE_3_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:        
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
            case 0x90:
            case 0x91:
              if(cnt == UICC_apdu.header.lc)
              { /* The non extended case 3 Tx transmission has ended successfully. */
                UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
                UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
                UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
                UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
              }
              else
              { /* Entended Lc handling */

                /* First find the remaining number of bytes to be transferred. */
                cnt = UICC_apdu.header.lc - tot_cnt;

                if(cnt == 0)
                {
                  /* The last APDU segment has been transferred successfully. */
                  UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
                  UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
                  UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
                  UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
                }
                else 
                {
                  /* Find the length of the next segment. */
                  if(cnt > 255)
                  {
                    cnt = 255;                 
                  }

                  /* Construct the envelope command */
                  tot_cnt += cnt;
                  rebuild_cmd((ubyte )cnt);
                  memcpy(UICC_tpdu_data_ptr, apdu_data_ptr_current, cnt);
                  apdu_data_ptr_current += cnt;                 
                  initiate_cmd();
                }
              }
              break;

           case 0x61: 
              /* The response data is of no interest due to the case 3 command nature - and should never occur
                 on a correct functioning UICC. The response cause of SW1 and SW2 is changed to '90 00' because 
                 of the fact that the application layer new should 'see' the response cause '61'! */ 
              UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
		#ifdef  UICC_GET_RESPONSE_SEGMENT_SUPPORTED
		{
			UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
			UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
			UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
		}
		#else
		{
	              UICC_apdu.footer.sw1   = 0x90;
	              UICC_apdu.footer.sw2   = 0x00;
	              UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
		}
		#endif
              break;

           case 0x6C: /* Request to resend command using P3=xx */
             UICC_t0_trans_ctrl_state = UICC_RESEND_CMD;
             cnt = UICC_tpdu_footer.sw2;
             rebuild_cmd(cnt);
             initiate_cmd();
             break;

           default:
             UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
             UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
             UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
             UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
             break;

          }
          break;
          
        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================*/
    /* Executing Case 4 command */
    /*==========================*/
    case UICC_TX_HANDLING_CASE_4_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:                        
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
            case 0x90: 
            case 0x91:
              if(!extended_len_handling)
              {
                UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
                UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
                UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
                UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
              }
              else if((cnt == UICC_apdu.header.lc) || (le_offset == 3))
              {  
                /* The Tx data transfer of the case 4 command has ended. 
                     cnt == UICC_apdu.header.lc -> marks the end of a NON extended Lc
                                                   data transfer.
                     le_offset == 3             -> marks the end of an extended Lc 
                                                   data transfer. */
               
                /* Now continue with the Rx reception - with or without extended Le */
                UICC_t0_trans_ctrl_state   = UICC_GET_RESPONSE_AFTER_61H;
                
                apdu_data_ptr_current = apdu_data_ptr_start;
                tot_cnt = 0;
                cnt = ((UICC_apdu.header.le == 0) || (UICC_apdu.header.le >= 256)) ? 256 : UICC_apdu.header.le;
                build_get_resp(0x00, cnt);
                initiate_cmd();
              }
              else
              { /* Entended Lc handling */
              
                /* The next segment of the case 4 APDU command needs to be composed 
                   and sent. If cnt is larger than 255, there is a need for additional
                   segments to be sent. If on the other hand cnt is less than 253, this 
                   will be the last segment to be sent. The requirement that the coding
                   of Le needs to be place in the end of the last segment causes special
                   treatment of cases where cnt is 253, 254, 255 (an additional segment is
                   needed to carry the Le coding. */
                   
                /* First find the remaining number of bytes to be transferred. */
                cnt = UICC_apdu.header.lc - tot_cnt;
                
                /* Le offset is used to allocat the offset for the 3 bytes 
                   forming Le (B1, B2 and B3). */
                if(cnt >= 255)      
                { 
                  cnt = 255;
                  le_offset = 0;  
                }                 
                else if(cnt == 254) 
                { 
                  le_offset = 1;  
                } 
                else if(cnt == 253) 
                { 
                  le_offset = 2;  
                } 
                else /* this includes the cnt value of 0 */              
                { 
                  le_offset = 3;  
                }
         
                /* Construct the envelope command */
                tot_cnt += cnt;
                rebuild_cmd((ubyte )(cnt + le_offset));
                memcpy(UICC_tpdu_data_ptr, apdu_data_ptr_current, cnt);
                apdu_data_ptr_current += cnt;                 

                /* The coding of Le will now be placed after the TPDU payload in the 
                   envelope coding - based on the Le offset found. */
                switch(le_offset)
                {
                  case 3:
                    *(UICC_tpdu_data_ptr + cnt + 2) = UICC_apdu.header.le;    /* B3 of Le */
                    /* Break left out on purpose. */
                  case 2:
                    *(UICC_tpdu_data_ptr + cnt + 1) = UICC_apdu.header.le>>8; /* B2 of Le */
                    /* Break left out on purpose. */
                  case 1:
                    *(UICC_tpdu_data_ptr + cnt)     = 0x00;                   /* B1 of Le */                                                
                    /* Break left out on purpose. */
                }
                /* Stay in this state and execute the command. */
                initiate_cmd();
              }
              break;
              
            case 0x61: 
#if 0
if (UICC_GET_RESPONSE_SEGMENT_SUPPORTED)
{
UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
}
else
#endif
{
              UICC_t0_trans_ctrl_state = UICC_GET_RESPONSE_AFTER_61H;
              cnt = (UICC_tpdu_footer.sw2 == 0) ? 256 : UICC_tpdu_footer.sw2;

              build_get_resp(0x00, cnt);
              initiate_cmd();
}
              break;

            case 0x6C: /* Request to resend command using P3=xx */
              UICC_t0_trans_ctrl_state = UICC_RESEND_CMD;
              cnt = UICC_tpdu_footer.sw2;
              rebuild_cmd(cnt);
              initiate_cmd();
              break;

            case 0x9F: /* Request to send GET RESPONSE using P3=xx */
            case 0x9E:
              UICC_t0_trans_ctrl_state   = UICC_GET_RESPONSE_AFTER_9FH;
              apdu_data_ptr_current = apdu_data_ptr_start;
              tot_cnt = 0;
              if((UICC_tpdu_footer.sw2 < UICC_apdu.header.le) || (UICC_apdu.header.le == 0))
              {
                cnt = UICC_tpdu_footer.sw2;
              }
              else
              {
                cnt = UICC_apdu.header.le;               
              }
              build_get_resp(0xA0, cnt);
              initiate_cmd();
              break;

            case 0x62: /* Warnings */                   
            case 0x63: /* Warnings */                           
              UICC_t0_trans_ctrl_state = UICC_GET_RESPONSE_AFTER_62_63H;
              tot_cnt = cnt = 0;
              /* Remember the warning causes to be used when returning the response APDU. */
              UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
              UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
              build_get_resp(0x00, cnt);
              initiate_cmd();
              break;

            default:
              UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
              UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
              UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
              UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
              break;
          }                                             
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*==============================*/
    /* Resending command after '6C' */
    /*==============================*/
    case UICC_RESEND_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
             case 0x61: /* Request to send GET RESPONSE using P3=xx */
               UICC_t0_trans_ctrl_state   = UICC_GET_RESPONSE_AFTER_61H;

               /* Copy data if data is received. */
               if(event == UICC_T0_CMD_SUCCEEDED)
               {
                 if(copy_received_data())
                   UICC_t0_trans_ctrl_state = UICC_OVERFLOW_HANDLING;
               }
               cnt = UICC_tpdu_footer.sw2;
               build_get_resp(0x00, cnt);
               initiate_cmd();
               break;

             case 0x6C: /* Request to resend command using P3=xx */
               /* Stay in this state. */
               cnt = UICC_tpdu_footer.sw2;
               rebuild_cmd(cnt);
               initiate_cmd();
               break;

             case 0x90: /* The command succeeded without the need to resend the command. */
             case 0x91:
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               copy_received_data();
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;

             default:   /* The command succeeded without the need to resend the command. */
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;
          } 
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*=================================*/
    /* Sending GET_RESPONSE after '61' */
    /*=================================*/
    case UICC_GET_RESPONSE_AFTER_61H:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:        
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
             case 0x61: /* Request to send GET RESPONSE using P3=xx */
               /* Stay in this state. */
               /* Copy data if data is received. */
			#ifdef UICC_GET_RESPONSE_SEGMENT_SUPPORTED
			{
				UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
				copy_received_data();
				UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
				UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;

				UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
			}
			#else
			{
			   if(event == UICC_T0_CMD_SUCCEEDED)
			   {
				 if(copy_received_data())
				   UICC_t0_trans_ctrl_state = UICC_OVERFLOW_HANDLING;
			   }
				cnt = UICC_tpdu_footer.sw2;
				build_get_resp(0x00, cnt);
				initiate_cmd();
			}   
			#endif
				break;

             case 0x6C: /* Request to resend command using P3=xx */
               UICC_t0_trans_ctrl_state   = UICC_RESEND_CMD;
               cnt = UICC_tpdu_footer.sw2;
               rebuild_cmd(cnt);
               initiate_cmd();
               break;

             case 0x90: /* The command succeeded without the need to resend the command. */
             case 0x91:
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               copy_received_data();
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;

             default:   /* The command succeeded without the need to resend the command. */
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;
          } 
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*========================================*/
    /* Sending GET_RESPONSE after '62' & '63' */
    /*========================================*/
    case UICC_GET_RESPONSE_AFTER_62_63H:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:        
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
             case 0x61: /* Request to send GET RESPONSE using P3=xx */
               /* Stay in this state. */
               /* Copy data if data is received. */
               if(event == UICC_T0_CMD_SUCCEEDED)
               {
                 if(copy_received_data())
                   UICC_t0_trans_ctrl_state = UICC_OVERFLOW_HANDLING;
               }
               cnt = UICC_tpdu_footer.sw2;
               build_get_resp(0x00, cnt);
               initiate_cmd();
               break;

             case 0x6C: /* Request to resend command using P3=xx */
               cnt = UICC_tpdu_footer.sw2;
               rebuild_cmd(cnt);
               initiate_cmd();
               break;

             case 0x90: /* The command succeeded without the need to resend the command. */
             case 0x91:
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               copy_received_data();
               //UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               //UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;

             default:   /* The command succeeded without the need to resend the command. */
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;
          } 
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*=================================*/
    /* Sendinf GET_RESPONSE after '9F' */
    /*=================================*/
    case UICC_GET_RESPONSE_AFTER_9FH:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:        
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
             case 0x90:
             case 0x91:
               copy_received_data();
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;              

             default: /* The command succeeded without the need to resend the command. */
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;
          } 
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*=======================================*/
    /* Handling overflow data (length error) */
    /*=======================================*/
    case UICC_OVERFLOW_HANDLING:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CMD_SUCCEEDED:
        case UICC_T0_CMD_SUCCEEDED_NO_DATA:        
        /*----------------------------*/

          switch(UICC_tpdu_footer.sw1)
          {
             case 0x61: /* Request to send GET RESPONSE using P3=xx */
               /* Remain in this state. */
               cnt = UICC_tpdu_footer.sw2;
               build_get_resp(0x00, cnt);
               initiate_cmd();
               break;

             case 0x6C: /* Request to resend command using P3=xx */
               /* Remain in this state. */
               cnt = UICC_tpdu_footer.sw2;
               rebuild_cmd(cnt);
               initiate_cmd();
               break;

             default: /* The command succeeded without the need to resend the command. */
               UICC_t0_trans_ctrl_state = UICC_TRANS_SUCCEEDED;
               UICC_apdu.footer.sw1   = UICC_tpdu_footer.sw1;
               UICC_apdu.footer.sw2   = UICC_tpdu_footer.sw2;
               UICC_t0_cmd_handler(UICC_STOP_CMD_CLOCK);
               break;
          }
          break;

        /*----------------------------*/
        case UICC_T0_CMD_FAILED:
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*=======================================*/
    /* Handling overflow data (length error) */
    /*=======================================*/
    case UICC_TRANS_SUCCEEDED:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_CLOCK_STOPPED :
        /*----------------------------*/
          UICC_t0_trans_ctrl_state = UICC_T0_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_SUCCEEDED);
          break;
                   
        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_trans_ctrl_state;
          #endif
          break;
      }
      break;
          
    /*==========================================*/
    /* Default                                  */
    /*==========================================*/
    default:
      #ifndef UICC_NO_DEBUG
        debug = UICC_t0_trans_ctrl_state;
      #endif
      break;
  }

  #ifndef UICC_NO_DEBUG
    if(debug != UICC_T0_TRANS_NONE)
    {
      UICC_log_data_ptr[0] = debug;
      UICC_log_data_ptr[1] = event;
      UICC_log_data_ptr[2] = UICC_current_reader;
      UICC_log_data_ptr[3] = 0xAA;
      UICC_raise_exception(TRAP_UICC_T0_TRANS, UICC_T0_TRANS_ERROR_1, 4); 
      debug = UICC_T0_TRANS_NONE;
    }
  #endif
}
                                                 /* End of file.              */
