/************************************************************************
 * Ȩ (C)2007,ͨѶɷ޹˾
 * ģ   ýģ
 * ļƣ Zte_stream.h
 * ļʶ 
 * ժҪ Ҫýģĺ궨塢ȫֱԼ
 *
 * ޸      汾     ޸ı    ޸          ޸      
 * ----------------------------------------------------------------------
 * 2009/06/08    1.0                              
 ************************************************************************/

#ifndef ZTE_STREAM_H
#define ZTE_STREAM_H

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/

/**************************************************************************
 *                                                                    *
 **************************************************************************/
typedef enum 
{
    DD_STREAMING_NONE = 0,
    DD_STREAMING_MP3 = 0x80,
    DD_STREAMING_MIDI,
    DD_STREAMING_ONE,
    DD_STREAMING_AMR_NB,
    DD_STREAMING_AAC,
    DD_STREAMING_DRA,
    DD_STREAMING_UNKNOW
}DD_STEAMING_AUDIO;

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
                         
/**************************************************************************
 *                                                                *
 **************************************************************************/


typedef struct _DD_AUDIO_STREAM_AAC_PARAM_
{
	UINT32 headerLength;
	UINT8 *headerAddr;
}DD_AUDIO_STREAM_AAC_PARAM;

typedef struct DD_STREAM_AUDIO_SET_
{
   
   UINT8 *bConfig;
   DD_AUDIO_STREAM_AAC_PARAM dd_aac;
      
}DD_STREAM_AUDIO_SET;

typedef struct STREAM_AUDIO_PARAM_
{

    DD_STEAMING_AUDIO stream_audio_type;
    
    DD_STREAM_AUDIO_SET stream_param_set;
    

}STREAM_AUDIO_PARAM;

typedef STREAM_AUDIO_PARAM *STREAM_AUDIO_HANDLE;

/* Ƶʽ */
typedef enum
{
    STREAM_VIDEO_NONE =0,
    STREAM_VIDEO_H263,         /* H263 */
    STREAM_VIDEO_H264,         /* H264 */
    STREAM_VIDEO_MP4,          /* MP4  */
    STREAM_VIDEO_MAX
}STREAM_VIDEO_FORMAT;

/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/

/**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/
/**
 * ƣ Stream_Video_Open
 *  ýƵ豸
 * ˵ 
 *   ֵ 豸ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Open(void);

/**
 * ƣ Stream_Video_Close
 *  ͷý򿪵Ƶ豸
 * ˵ 
 *   ֵ ͷ豸ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Close(void);

/**
 * ƣ Stream_Video_Init
 *  ýģʼ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Init(STREAM_VIDEO_FORMAT eStreamVideoType);

/**
 * ƣ Stream_Video_Release
 *  ͷýģԴ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ ʼɶʹ
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Release(void);

/**
 * ƣ Stream_Video_Decode
 *  ýƵ롢
 * ˵ (IN)param:Ƶݽṹָ룬ָ볤
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ úṩҰƵ
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Decode(STREAM_DATA *param);

/**
 * ƣ Stream_Video_SetParam
 *  ýƵá
 * ˵ (IN)param:òƵʾתǶ
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_SetParam(STREAM_SET_PARAM *param);

/**
 * ƣStream_Audio_Open
 * ýƵ豸
 * ˵(IN)data_type:ý
 *           (IN)stream_param:ò
 *   ֵ ɹýƵž;򷵻NULL
 * ˵ 
 */
STREAM_AUDIO_HANDLE Stream_Audio_Open(DD_STEAMING_AUDIO data_type, DD_STREAM_AUDIO_SET *stream_param);

/**
 * ƣStream_Audio_Close
 * رýƵ豸
 * ˵(IN)handle:ýƵž
 *   ֵ ɹAUDIO_NO_ERROR;򷵻ӦĴ롣
 * ˵ 
 */
AUDIO_RESULT_E Stream_Audio_Close(STREAM_AUDIO_HANDLE handle);

/**
 * ƣStream_Audio_Open
 * ýƵݽ
 * ˵(IN)handle:ýƵž
 *           (IN)buffer:Ƶָ
 *           (IN)buffer_size:Ƶݳ
 *   ֵ ɹAUDIO_NO_ERROR;򷵻ӦĴ롣
 * ˵ 
 */
AUDIO_RESULT_E Stream_Audio_Decode(STREAM_AUDIO_HANDLE handle,
                                   UINT32 *buffer,
                                   UINT32 buffer_size);

#ifdef __cplusplus
}
#endif

#endif  /* ZTE_STREAM_H */

