/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : ose_mmu_arm.c
*    : ose_mmu_arm.c
* ļ : 
* ʵֹ : 
*      : κ
*      : V1.0
*  : 2011-8-15
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "cpu_hal_arch.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/

#define MMU_REGION_MAX          (255)

#define LV1_SECTION_SIZE        0x100000    /* 1M                                           */
#define LV2_LARGE_SIZE          0x10000     /* 64k */
#define LV2_SMALL_SIZE          0x1000      /* 4k  */
#define LV2_TINY_SIZE           0x400       /* 1k  */

/* virtual address */
#define VA_OFFSET_SECTION(v)    ((UINT32)(v) & 0x000FFFFF)          /* 19~0  */
#define VA_OFFSET_LARGE(v)      ((UINT32)(v) & 0x0000FFFF)          /* 15~0  */
#define VA_OFFSET_SMALL(v)      ((UINT32)(v) & 0x00000FFF)          /* 11~0  */
#define VA_OFFSET_TINY(v)       ((UINT32)(v) & 0x000003FF)          /*  9~0  */

/* physical address */
#define PA_SECTION(d1,v)        (LV1_DESC_PTA_S(d1) | VA_OFFSET_SECTION(v))
#define PA_LARGR(d2,v)          (LV2_DESC_PA_L(d2) | VA_OFFSET_LARGE(v))
#define PA_SMALL(d2,v)          (LV2_DESC_PA_S(d2) | VA_OFFSET_SMALL(v))
#define PA_TINY(d2,v)           (LV2_DESC_PA_T(d2)  | VA_OFFSET_TINY(v))

/* access permision */
#define AP_USER_RW              (3)
#define AP_USER_RO              (2)
#define AP_USER_NA              (1)

#define AP_SECTION(d)           (((d) & LV1_DESC_AP(0x3)) >> 10)
#define AP_LARGE(d)             (((d) & LV2_DESC_AP_L(0x3)) >> 10)
#define AP_SMALL(d)             (((d) & LV2_DESC_AP_S(0x3)) >> 10)
#define AP_TINY(d)              (((d) & LV2_DESC_AP_T(0x3)) >> 4)

/* domain */
#define DOMAIN_NA               (0x0)

#define DOMAIN_RESERVED         (0x2)
#define DOMAIN_SU               (0x3)
#define DOMAIN_VAL(r,d)         (((r)>>((d)<<1)) & 0x3)

/* lv1 descriptor address */
#define LV1_DESC_ADDR(c2,v)     (((UINT32)(c2)&0xFFFFC000) | (((v)&0xFFF00000)>>18))   /* 31~14, 13~2, 1~0 */

/* lv1 descriptor */
#define LV1_DESC_PTA_S(a)       ((UINT32)(a) & 0xFFF00000)  /* 31~20 */

#define LV1_DESC_AP(p)          (((p)&0x3) << 10)           /* 11~10 */          
#define LV1_DESC_DOMAIN(d)      (((d)&0xF) << 5)            /*  8~5  */

/* lv1 descriptor */
#define LV1_FINE                (3)
#define LV1_SECTION             (2)
#define LV1_COARSE              (1)
#define LV1_FAULT               (0)
#define LV1_TYPE(d)             ((d) & 0x3)
#define LV1_DOMAIN(d)           (((d) & LV1_DESC_DOMAIN(0xF)) >> 5)

/* lv2 descriptor address */
#define LV2_DESC_ADDR_C(d,v)    (((UINT32)(d)&0xFFFFFC00) | (((v)&0x000FF000)>>10))   /* 31~10,  9~2, 1~0 */
#define LV2_DESC_ADDR_F(d,v)    (((UINT32)(d)&0xFFFFF000) | (((v)&0x000FFC00)>>8))    /* 31~12, 11~2, 1~0 */

/* lv2 descriptor */
#define LV2_DESC_PA_L(a)        ((UINT32)(a) & 0xFFFF0000) /* 31~16 */
#define LV2_DESC_PA_S(a)        ((UINT32)(a) & 0xFFFFF000) /* 31~12 */
#define LV2_DESC_PA_T(a)        ((UINT32)(a) & 0xFFFFFC00) /* 31~10 */
#define LV2_DESC_AP_L(p)        ((((p)&0x3)<<10) | (((p)&0x3)<<8) | (((p)&0x3)<<6) | (((p)&0x3)<<4))    /* 11~4 */
#define LV2_DESC_AP_S(p)        ((((p)&0x3)<<10) | (((p)&0x3)<<8) | (((p)&0x3)<<6) | (((p)&0x3)<<4))    /* 11~4 */
#define LV2_DESC_AP_T(p)        (((p)&0x3)<<4)             /* 6~4   */

/* lv2 descriptor */
#define LV2_TINY                (3)
#define LV2_SMALL               (2)
#define LV2_LARGE               (1)
#define LV2_FAULT               (0)
#define LV2_TYPE(d)             ((d) & 0x3)

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef enum
{
    C1_M = 1<<0,
    C1_A = 1<<1,
    C1_C = 1<<2,
    C1_W = 1<<3,
    C1_S = 1<<8,
    C1_R = 1<<9,
    C1_I = 1<<12,
    C1_V = 1<<13
}MMU_C1;

typedef enum
{
    SU_NA_USR_NA,
    SU_RO_USR_NA,
    SU_RO_USR_RO,
    SU_RW_USR_NA,
    SU_RW_USR_RO,
    SU_RW_USR_RW
}MMU_AP;

typedef struct
{
    T_ZOss_Node node;
    UINT32      p_start;
    UINT32      v_start;
    UINT32      v_end;
    UINT32      lv1_type;
    UINT32      lv2_type;
    UINT32      access;
}MMU_NODE;
/**************************************************************************
* ֲ
**************************************************************************/
#pragma arm section rodata = "MMU_RO_DATA"

static const UINT32 s_page_size_table[4][4] = 
{   /* fault            large             small             tiny */
    { LV1_SECTION_SIZE, LV1_SECTION_SIZE, LV1_SECTION_SIZE, LV1_SECTION_SIZE }, /* fault    */
    { LV2_TINY_SIZE,    LV2_LARGE_SIZE,   LV2_SMALL_SIZE,   LV2_TINY_SIZE    }, /* coarse   */
    { LV1_SECTION_SIZE, LV1_SECTION_SIZE, LV1_SECTION_SIZE, LV1_SECTION_SIZE }, /* section  */
    { LV2_TINY_SIZE,    LV2_LARGE_SIZE,   LV2_SMALL_SIZE,   LV2_TINY_SIZE    }  /* fine     */
};

#pragma arm section rodata

static const CHAR *s_lv1_type_name[LV1_TYPE(0xFFFFFFFF)+1] = 
{ 
    (const CHAR *)"FAULT",
    (const CHAR *)"COARSE",
    (const CHAR *)"SECTION",
    (const CHAR *)"FINE" 
};

static const CHAR *s_lv2_type_name[LV1_TYPE(0xFFFFFFFF)+1][LV2_TYPE(0xFFFFFFFF)+1] = 
{
    { (const CHAR *)"--",    (const CHAR *)"--",    (const CHAR *)"--",    (const CHAR *)"--"   },
    { (const CHAR *)"FAULT", (const CHAR *)"LARGE", (const CHAR *)"SMALL", (const CHAR *)"--"   },
    { (const CHAR *)"--",    (const CHAR *)"--",    (const CHAR *)"--",    (const CHAR *)"--"   },
    { (const CHAR *)"FAULT", (const CHAR *)"LARGE", (const CHAR *)"SMALL", (const CHAR *)"TINY" }
};

static const CHAR *s_mmu_accessible[] = 
{
    (const CHAR *)"SU_NA_USR_NA",
    (const CHAR *)"SU_RO_USR_NA",
    (const CHAR *)"SU_RO_USR_RO",
    (const CHAR *)"SU_RW_USR_NA",
    (const CHAR *)"SU_RW_USR_RO",
    (const CHAR *)"SU_RW_USR_RW"
};

/**************************************************************************
* ֲ
**************************************************************************/
T_ZOss_List         s_mmu_list                      = { 0 };
static MMU_NODE     s_mmu_regions[MMU_REGION_MAX]   = { 0 };
static UINT32       s_mmu_region_cnt                = 0;
/**************************************************************************
* ȫֳ/
**************************************************************************/
const UINT32 s_mmu_stack_bottom = 0;
/**************************************************************************
* ȫֺ
**************************************************************************/
extern UINT32 cp15_readControlRegister(VOID);
//extern VOID   cp15_writeControlRegister(UINT32);
extern UINT32 cp15_readDomainRegister(VOID);
extern UINT32 cp15_readTTB(VOID);
extern UINT32 get_arm_mode(VOID);
#pragma arm section code = "MMU_CODE"
/**************************************************************************
* ֲʵ
**************************************************************************/
static VOID mmu_get_desc(UINT32 v_addr, UINT32 *p_lv1_desc, UINT32 *p_lv2_desc)
{
    UINT32 c2       = cp15_readTTB();
    UINT32 lv1_desc = 0;
    UINT32 lv1_type = 0;

    lv1_desc = *(UINT32 *)LV1_DESC_ADDR(c2, v_addr);
    if (NULL != p_lv1_desc)
    {
        *p_lv1_desc = lv1_desc;
    }

    if (NULL != p_lv2_desc)
    {
        lv1_type = LV1_TYPE(lv1_desc);
        if (LV1_COARSE == lv1_type)
        {
            *p_lv2_desc = *(UINT32 *)LV2_DESC_ADDR_C(lv1_desc, v_addr);
        }
        else if (LV1_FINE == lv1_type)
        {
            *p_lv2_desc = *(UINT32 *)LV2_DESC_ADDR_F(lv1_desc, v_addr);
        }
        else
        {
            *p_lv2_desc = LV2_FAULT;
        }
    }
}

static BOOL mmu_is_addr_valid(UINT32 v_addr)
{
    UINT32 lv1_desc = 0;
    UINT32 lv1_type = 0;
    UINT32 lv2_desc = 0;
    UINT32 lv2_type = 0;

    mmu_get_desc(v_addr, &lv1_desc, &lv2_desc);
    
    lv1_type = LV1_TYPE(lv1_desc);
    lv2_type = LV2_TYPE(lv2_desc);
    if ((LV1_FAULT == lv1_type) || ((LV1_COARSE == lv1_type) && ((LV2_FAULT == lv2_type) || (LV2_TINY == lv2_type))) || ((LV1_FINE == lv1_type) && (LV2_FAULT == lv2_type)))
    {
        return FALSE;
    }
    else
    {
        return TRUE;
    }
}

static UINT32 mmu_get_phy_addr(UINT32 v_addr)
{
    UINT32 lv1_desc = 0;
    UINT32 lv1_type = 0;
    UINT32 lv2_desc = 0;
    UINT32 lv2_type = 0;
    UINT32 p_addr   = 0;

    if (!mmu_is_addr_valid(v_addr))
    {
        return ZOSS_ERROR;
    }
    
    mmu_get_desc(v_addr, &lv1_desc, &lv2_desc);
    lv1_type = LV1_TYPE(lv1_desc);
    lv2_type = LV2_TYPE(lv2_desc);
    if (LV1_SECTION == lv1_type)
    {
        p_addr = PA_SECTION(lv1_desc, v_addr);
    }
    else if (LV2_LARGE == lv2_type)
    {
        p_addr = PA_LARGR(lv2_desc, v_addr);
    }
    else if (LV2_SMALL == lv2_type)
    {
        p_addr = PA_SMALL(lv2_desc, v_addr);
    }
    else if (LV2_TINY == lv2_type)
    {
        p_addr = PA_TINY(lv2_desc, v_addr);
    }
    else
    {
        zOss_ASSERT(0);
    }

    return p_addr;
}

static UINT32 mmu_get_ap(UINT32 v_addr)
{
    UINT32 lv1_desc = 0;
    UINT32 lv1_type = LV1_FAULT;
    UINT32 lv2_desc = 0;
    UINT32 lv2_type = LV2_FAULT;
    UINT32 ap       = 0;

    if (!mmu_is_addr_valid(v_addr))
    {
        return AP_USER_NA;
    }

    mmu_get_desc(v_addr, &lv1_desc, &lv2_desc);
    lv1_type = LV1_TYPE(lv1_desc);
    lv2_type = LV2_TYPE(lv2_desc);
    
    if (LV1_SECTION == lv1_type)
    {
        ap = AP_SECTION(lv1_desc);
    }
    else if (LV2_LARGE == lv2_type)
    {
        ap = AP_LARGE(lv2_desc);
    }
    else if (LV2_SMALL == lv2_type)
    {
        ap = AP_SMALL(lv2_desc);
    }
    else if (LV2_TINY == lv2_type)
    {
        ap = AP_TINY(lv2_desc);
    }
    else
    {
        zOss_ASSERT(0);
    }

    return ap;
}

static UINT32 mmu_get_access_permmision(UINT32 v_addr)
{
    UINT32 lv1_desc = 0;
    UINT32 c1       = 0;
    UINT32 c3       = 0;
    UINT32 d        = 0;
    UINT32 ap       = 0;
    UINT32 s        = 0;
    UINT32 r        = 0;
    
    if (!mmu_is_addr_valid(v_addr))
    {
        return SU_NA_USR_NA;
    }

    mmu_get_desc(v_addr, &lv1_desc, NULL);
    c3 = cp15_readDomainRegister();
    d  = DOMAIN_VAL(c3, LV1_DOMAIN(lv1_desc));
    if ((DOMAIN_NA == d) || (DOMAIN_RESERVED == d))
    {
        return SU_NA_USR_NA;
    }
    else if (DOMAIN_SU == d)
    {
        return SU_RW_USR_RW;
    }
    else
    {
        ap = mmu_get_ap(v_addr);
        if (AP_USER_NA == ap)
        {
            return SU_RW_USR_NA;
        }
        else if (AP_USER_RO == ap)
        {
            return SU_RW_USR_RO;
        }
        else if (AP_USER_RW == ap)
        {
            return SU_RW_USR_RW;
        }
        else
        {
            MMU_C1 temp = C1_S; /* ȥPC-LINT 澯*/
            c1 = cp15_readControlRegister();
            s  = (0 == (c1 & temp)) ? 0 : 1;
            r  = (0 == (c1 & C1_R)) ? 0 : 1;
            if ((1 == s) && (0 == r))
            {
                return SU_RO_USR_NA;
            }
            else if ((0 == s) && (1 == r))
            {
                return SU_RO_USR_RO;
            }
            else
            {
                return SU_NA_USR_NA;
            }
        }
    }
}

static BOOL mmu_is_readable(UINT32 v_addr)
{
    UINT32 mode = 0;
    UINT32 ap   = 0;
    UINT32 c2   = cp15_readTTB();
    
    mode = get_arm_mode();
    
    hal_arch_cpu_descriptor->disable_mmu();
    
    ap = mmu_get_access_permmision(v_addr);
    
    hal_arch_cpu_descriptor->enable_mmu(1, 1, 0, 0, 0, c2);

    if (0 == mode)    /* user mode */
    {
        MMU_AP temp = SU_NA_USR_NA; /* ȥPC-LINT 澯*/
        if ((temp == ap) || (SU_RO_USR_NA == ap) || (SU_RW_USR_NA == ap))
        {
            return FALSE;
        }
    }
    else    /*privileged modes */
    {
        if (SU_NA_USR_NA == ap)
        {
            return FALSE;
        }
    }

    return TRUE;
}

BOOL mmu_is_writeable(UINT32 v_addr)
{
    UINT32 mode = 0;
    UINT32 ap   = 0;
    UINT32 c2   = cp15_readTTB();
    
    mode = get_arm_mode();
    
    hal_arch_cpu_descriptor->disable_mmu();
    
    ap = mmu_get_access_permmision(v_addr);
    
    hal_arch_cpu_descriptor->enable_mmu(1, 1, 0, 0, 0, c2);

    if (0 == mode)    /* user mode */
    {
        MMU_AP temp = SU_RW_USR_RW; /* ȥPC-LINT 澯*/
        if ( temp != ap)
        {
            return FALSE;
        }
    }
    else    /*privileged modes */    
    {
        if (SU_NA_USR_NA == ap || SU_RO_USR_NA == ap || SU_RO_USR_RO == ap)
        {
            return FALSE;
        }
    }

    return TRUE;
}


static MMU_NODE *mmu_alloc_region_buf(VOID)
{
    if (MMU_REGION_MAX > s_mmu_region_cnt)
    {
        return &s_mmu_regions[s_mmu_region_cnt++];
    }
    else
    {
        return NULL;
    }
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/
VOID mmu_generate_info(VOID)
{
    UINT32      c2               = cp15_readTTB();
    UINT32      lv1_desc         = 0;
    UINT32      lv2_desc         = 0;
    UINT32      lv1_type         = LV1_FAULT;
    UINT32      lv2_type         = LV2_FAULT;
    UINT32      v_addr           = 0;
    UINT32      v_addr_last      = 0;
    UINT32      accessible       = SU_NA_USR_NA;
    UINT32      accessible_last  = SU_NA_USR_NA;
    BOOL        is_start         = FALSE;
    BOOL        is_end           = FALSE;
    MMU_NODE    *node            = NULL;
    static BOOL isInit           = FALSE;

    if(isInit == TRUE)
    {
        return;
    }
    
    zOss_ListInit(&s_mmu_list);

    zOss_Memset(s_mmu_regions, 0, sizeof(s_mmu_regions));
    
    s_mmu_region_cnt = 0;
    
    hal_arch_cpu_descriptor->disable_mmu();
    for (v_addr=0, v_addr_last=0; ; v_addr_last = v_addr, v_addr += s_page_size_table[lv1_type][lv2_type])
    {
        /* address overflow */
        if (v_addr < v_addr_last)
        {
            if (NULL != node)
            {
                node->v_end = 0xFFFFFFFF;
                zOss_ListAdd(&s_mmu_list, (T_ZOss_Node *)node);
            }
            break;
        }

        /* descriptor & type */
        mmu_get_desc(v_addr, &lv1_desc, &lv2_desc);
        lv1_type = LV1_TYPE(lv1_desc);
        lv2_type = LV2_TYPE(lv2_desc);

        /* access permision */
        accessible = mmu_get_access_permmision(v_addr);

        if ( /*(lv1_type_last != lv1_type)
            || (lv2_type_last != lv2_type)
            ||*/ (accessible_last != accessible))
        {
            if (mmu_is_addr_valid(v_addr))
            {
                is_start = TRUE;
            }
            if (NULL != node)
            {
                is_end = TRUE;
            }
        }

        if (is_end)
        {
            zOss_ASSERT(NULL != node);
            node->v_end = v_addr - 1;
            zOss_ListAdd(&s_mmu_list, (T_ZOss_Node *)node);
            node = NULL;
        }
        if (is_start)
        {
            node = mmu_alloc_region_buf();
            zOss_ASSERT(NULL != node);
            
            node->p_start  = mmu_get_phy_addr(v_addr);
            node->v_start  = v_addr;
            node->lv1_type = lv1_type;
            node->lv2_type = lv2_type;
            node->access   = accessible;
        }
        accessible_last = accessible;
        is_start        = FALSE;
        is_end          = FALSE;
    }
    
    hal_arch_cpu_descriptor->enable_mmu(1, 1, 0, 0, 0, c2);

    isInit = TRUE;
}

BOOL mmu_get_readable_region(UINT32 begin, UINT32 end , UINT32 *p_begin, UINT32 *p_end)
{
    MMU_NODE    *node           = NULL;
    UINT32      region_start    = 0;
    UINT32      region_end      = 0;

    if(begin > end)
    {
        return FALSE;
    } 
    node = (MMU_NODE *)zOss_ListFirst(&s_mmu_list);
    while (NULL != node)
    {
        if (mmu_is_readable(node->v_start))
        {
            region_start = node->v_start;
            region_end   = node->v_end;   
            if ((region_start <= begin) && (region_end >= begin))
            {
                *p_begin =  begin;
                *p_end   = (region_end > end) ? end : region_end;
                return TRUE;
            }
            else if ((region_start > begin) && (region_start <= end))
            {
                *p_begin = region_start;
                *p_end   = (region_end > end) ? end : region_end;
                return TRUE;
            }
        }
        node = (MMU_NODE *)zOss_ListNext((T_ZOss_Node *)node);
    }
    
    return FALSE;
}

VOID print_mmu_info(VOID)
{
    MMU_NODE    *node   = NULL;
    Msr         oldMsr  = 0;

    LOCK_SAVE(oldMsr);   
    mmu_generate_info();
    LOCK_RESTORE(oldMsr);
    
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "########################################");
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "mmu configuration start");
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "phy_start\tvirtual_start\tvirtual_end\tlv1_type\tlv2_type\taccess");
    
    node = (MMU_NODE *)zOss_ListFirst(&s_mmu_list);
    while (NULL != node)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "0x%08x\t0x%08x\t0x%08x\t%s\t\t%s\t\t%s",
                    node->p_start,
                    node->v_start,
                    node->v_end,
                    s_lv1_type_name[node->lv1_type],
                    s_lv2_type_name[node->lv1_type][node->lv2_type],
                    s_mmu_accessible[node->access]);
        
        node = (MMU_NODE *)zOss_ListNext((T_ZOss_Node *)node);
    }

    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "mmu configuration end");
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "########################################");
}

#pragma arm section code

#ifdef __cplusplus
}
#endif

