/**
 * 
 * @file      amtnv.c
 * @brief     
 *            This file is part of FTM.
 *            AMTģNVӿ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2018/04/28  1.0      liu.xin        Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <unistd.h>
#include "amtnv.h"
#include "libcpnv.h"
#include "cfg_api.h"
#include "NvParam_drv.h"

/**
 * ȫֱ
 */

typedef struct
{
    UINT32   dwMsgID;
    UINT32   dwAddress;
    UINT32   dwSize;
} T_zAMT_CommNv_Info;

const T_zAMT_CommNv_Info g_amtCommNvCfg[] =
{
    { ABIMEI_NVPARAM,         OS_FLASH_AMT_COMM_RO_IMEI_ADDRESS,        OS_FLASH_AMT_COMM_RO_IMEI_SIZE          },
    { ABIMEISV_NVPARAM,       OS_FLASH_AMT_COMM_RO_IMEISV_ADDRESS,      OS_FLASH_AMT_COMM_RO_IMEISV_SIZE        },
    { ABBORDNUm_NVPARAM,      OS_FLASH_AMT_COMM_RO_BOARDNNUM_ADDRESS,   OS_FLASH_AMT_COMM_RO_BOARDNNUM_SIZE     },
    { ABMSERIALNUM_NVPARAM,   OS_FLASH_AMT_COMM_RO_MSerialNum_ADDRESS,  OS_FLASH_AMT_COMM_RO_MSerialNum_SIZE    },
    { ABVALIDFLAG_NVPARAM,    OS_FLASH_AMT_COMM_RO_ValidFlag_ADDRESS,   OS_FLASH_AMT_COMM_RO_ValidFlag_SIZE     },
    { ABMAC_INT_NVPARAM,      OS_FLASH_AMT_COMM_RO_InternalMAC_ADDRESS, OS_FLASH_AMT_COMM_RO_InternalMAC_SIZE   },
    { ABMAC_EXT_NVPARAM,      OS_FLASH_AMT_COMM_RO_ExternalMAC_ADDRESS, OS_FLASH_AMT_COMM_RO_ExternalMAC_SIZE   },
    { ABMAC_WIFI_NVPARAM,     OS_FLASH_AMT_COMM_RO_WIFIMAC_ADDRESS,     OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE       },
    { ABNV_VERSION_NVPARAM,   OS_FLASH_AMT_COMM_RO_NvVersion_ADDRESS,   OS_FLASH_AMT_COMM_RO_NvVersion_SIZE     },
    { ABTESTINFO_NVPARAM,     OS_FLASH_AMT_COMM_RO_TestInfo_ADDRESS,    OS_FLASH_AMT_COMM_RO_TestInfo_SIZE      },
    { ABSOFTVERSION_NVPARAM,  OS_FLASH_AMT_COMM_RO_SOFTVERSION_ADDRESS, OS_FLASH_AMT_COMM_RO_SOFTVERSION_SIZE   },
    { ABNET_V4KEY_NVPARAM,    OS_FLASH_AMT_COMM_RO_V4Key_ADDRESS,       OS_FLASH_AMT_COMM_RO_V4Key_SIZE         },
    { ABSALE_STATE_NVPARAM,   OS_FLASH_AMT_COMM_RO_SaleState_ADDRESS,   OS_FLASH_AMT_COMM_RO_SaleState_SIZE     },
    { ABBANDBITMAP_NVPARAM,   OS_FLASH_AMT_COMM_RO_BANDBITMAP_ADDRESS,  OS_FLASH_AMT_COMM_RO_BANDBITMAP_SIZE    },
    { ABMAC_ETH_NVPARAM,      OS_FLASH_AMT_COMM_RO_ETHMAC_ADDRESS,      OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE        },
    { ABNET_LCOKKEY_NVPARAM,  OS_FLASH_AMT_COMM_RO_LockKey_ADDRESS,     OS_FLASH_AMT_COMM_RO_LockKey_SIZE       },
    { ABMAC_WIFI2_NVPARAM,    OS_FLASH_AMT_COMM_RO_WIFIMAC2_ADDRESS,    OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE      },
    { ABMAC_USBMAC_NVPARAM,   OS_FLASH_AMT_COMM_RO_USBMAC_ADDRESS,      OS_FLASH_AMT_COMM_RO_USBMAC_SIZE        },
    { ABMAC_GMAC_NVPARAM,     OS_FLASH_AMT_COMM_RO_GMAC_ADDRESS,        OS_FLASH_AMT_COMM_RO_GMAC_SIZE          },
    { ABFEATURE_KEY_MD5_NVPARAM,	  OS_FLASH_AMT_COMM_RO_FEATURE_KEY_MD5_ADDRESS,	OS_FLASH_AMT_COMM_RO_FEATURE_KEY_MD5_SIZE},
    { ABAUTH_KEY_NVPARAM,     OS_FLASH_AMT_COMM_RO_AUTH_KEY_ADDRESS,        OS_FLASH_AMT_COMM_RO_AUTH_KEY_SIZE  },
    { ABSOFTDOG_CIPHER_TEXT_NVPARAM,     OS_FLASH_AMT_COMM_RO_SOFTDOG_CIPHER_TEXT_ADDRESS,   OS_FLASH_AMT_COMM_RO_SOFTDOG_CIPHER_TEXT_SIZE  },
    { ABGBDATA_NVPARAM,       OS_FLASH_AMT_COMM_RO_GBDATA_ADDRESS,      OS_FLASH_AMT_COMM_RO_GBDATA_SIZE        },
};

SINT32 GetBitOffset(SINT32 testItem)
{
    return 2 * (3 - (testItem % 4));
}

/**
 * @brief дnvro
 * @param dwStart nvʼַƫ,0 ~ 2M-1 bytes
 * @param dwLen nv,1 ~ 2M bytes
 * @param from д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_nvro_write(unsigned int dwStart, unsigned int dwLen, unsigned char *from)
{
    UINT32  retCode = CPNV_ERROR;

    /*ȵӿڷſֻд*/
	/*amtģʽ£zte_amtӦ֮Ѿҳɿд*/
	if(!is_amt_mode()) 
	{
	    retCode = cpnv_ChangeFsPartitionAttr(FS_NVROFS, 1);
	    if(CPNV_OK != retCode)
	    {
	        return retCode;
	    }
	}

    retCode = cpnv_NvItemWriteNvro(dwStart, from, dwLen);
    if(CPNV_OK != retCode)
    {
        return retCode;
    }

    cpnv_FsGcWait(FS_NVROFS);
	if(!is_amt_mode()) 
	{
	    retCode = cpnv_ChangeFsPartitionAttr(FS_NVROFS, 0);
	    if(CPNV_OK != retCode)
	    {
	        return retCode;
	    }
	}
	return retCode;
}

/**
 * @brief nvro
 * @param dwStart nvʼַƫ,0 ~ 2M-1 bytes
 * @param dwLen nv,1 ~ 2M bytes
 * @param to 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_nvro_read(unsigned int dwStart, unsigned int dwLen, unsigned char *to)
{
    unsigned int ret = CPNV_ERROR;
    unsigned int max_length = OS_FLASH_RO_NVRAM_SIZE + OS_FLASH_ROW_NVRAM_SIZE;
    
    if (dwStart >= max_length || dwLen > max_length || (dwStart + dwLen) > max_length)
    {
        return -1;
    }
    
    ret = cpnv_NvItemRead(dwStart, to, dwLen);
    
    if(ret ==  CPNV_ERROR)
    {
        return -1;
    }
    else
    {
        return 0;
    }

}

/**
 * @brief дһNVRO
 * @param nvParam NV
 * @param NvItemData дݵĵַ
 * @param NvItemLen ݳ
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int  amt_write_nv_item(NvParam_AMT nvParam, UINT8 *NvItemData, UINT32 NvItemLen)
{
    UINT32  retCode = CPNV_ERROR;
    UINT32  i = 0;

    if (nvParam >= MAXABNVPARAM_NVPARAM || NULL == NvItemData || NvItemLen == 0)
    {
        return  -1;
    }

    for (i = 0; i < (sizeof(g_amtCommNvCfg) / sizeof (g_amtCommNvCfg[0])); i++)
    {
        if ( nvParam == g_amtCommNvCfg[i].dwMsgID )
        {
            if (NvItemLen > g_amtCommNvCfg[i].dwSize)
            {
                NvItemLen = g_amtCommNvCfg[i].dwSize;
            }

            retCode = amt_nvro_write(g_amtCommNvCfg[i].dwAddress, NvItemLen, NvItemData);

            break;
        }
    }
            
    if (retCode != CPNV_OK)
    {
        assert(0);
    }
    return  0;
}

/**
 * @brief һNVRO
 * @param nvParam  NV
 * @param NvItemData 
 * @param NvItemLen  ݳ
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_read_nv_item(NvParam_AMT nvParam,UINT8 *NvItemData, UINT32 NvItemLen)
{
    UINT32  retCode = CPNV_ERROR;
    UINT32  i = 0;

    //  zOss_Printf(0x7f, 0x2,"[zPS_NvAMTItemRead]nvParam is %d and NvItemLen is %d\n",nvParam,NvItemLen);
    if (nvParam >= MAXABNVPARAM_NVPARAM || NULL == NvItemData || NvItemLen == 0)
    {
        return  -1;
    }

   /* if (ABBANDBITMAP_NVPARAM == nvParam)
    {
        BYTE band_bit_map_flag = 0;
        zPS_NvAMFlagsTItemRead(BAND_BIT_MAP_FLAG, &band_bit_map_flag);

        if (band_bit_map_flag != '1')
        {
            retCode = zPs_NvCheckBandBitmap(NvItemData, NvItemLen);

            return retCode;
        }
    }*/
    for (i = 0; i < (sizeof(g_amtCommNvCfg) / sizeof (g_amtCommNvCfg[0])); i++)
    {
        if ( nvParam == g_amtCommNvCfg[i].dwMsgID )
        {
            if (NvItemLen > g_amtCommNvCfg[i].dwSize)
            {
                NvItemLen = g_amtCommNvCfg[i].dwSize;
            }
            retCode = cpnv_NvItemRead(g_amtCommNvCfg[i].dwAddress, NvItemData, NvItemLen);
            break;        
        }
    }
    if(retCode == CPNV_ERROR)
    {
         return  -1;
    }
    else
    {
         return  0;
    }
}

/**
 * @brief дԱ־λ
 * @param nvParam  Ա־λöֵ
 * @param NvItemData д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_write_test_flag_item(NvParam_AMTFlags nvParam,UINT8 *NvItemData)
{
    UINT32 retCode = CPNV_ERROR;
    UINT32 AMTFlagAddress = 0;
    BYTE   pTestInfoBuf[1];
    BYTE   *pByte;
    int byteIndex = 0;

    if (nvParam >= MAXAMTFALGS_NVPARAM)
    {
        return -1;
    }
    memset(pTestInfoBuf, 0, sizeof(pTestInfoBuf));
    byteIndex = nvParam/4; //Ҫдı־λڱ־λ׵ַƫ
    AMTFlagAddress = OS_FLASH_AMT_COMM_RO_TestInfo_ADDRESS + byteIndex;

    /*ȽNVеݶpTestInfoBuf*/
    retCode = cpnv_NvItemRead(AMTFlagAddress , pTestInfoBuf,1);
    if (CPNV_ERROR ==retCode )
    {
       return -1;
    }
    /*޸Ӧı־λ*/
    pByte = pTestInfoBuf ;
    *pByte &= ~(0x03 << GetBitOffset(nvParam));
    *pByte |= (*NvItemData-0x30) << GetBitOffset(nvParam);
    

    /*޸֮д*/
    retCode = amt_nvro_write(AMTFlagAddress, 1, pTestInfoBuf);

    if (CPNV_ERROR ==retCode )
    {
        assert(0);
    }
    return  0;
}

/**
 * @brief Ա־λ
 * @param nvParam  Ա־λöֵ
 * @param NvItemData 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_read_test_flag_item(NvParam_AMTFlags nvParam,UINT8 *NvItemData)
{
    UINT32 retCode = CPNV_ERROR;
    UINT32 AMTFlagAddress = 0;
    BYTE   pTestInfoBuf[1];
    BYTE byteVal = 0;
    BYTE byteRet = 0;
    int byteIndex = 0;

    if (nvParam >= MAXAMTFALGS_NVPARAM)
    {
        return -1;
    }
    
    byteIndex = nvParam/4; //Ҫı־λڱ־λ׵ַƫ
    AMTFlagAddress = OS_FLASH_AMT_COMM_RO_TestInfo_ADDRESS + byteIndex;
    /*ȽNVеݶpTestInfoBuf*/
    retCode = cpnv_NvItemRead(AMTFlagAddress,pTestInfoBuf, 1);
    if (CPNV_ERROR ==retCode )
    {
       return -1;
    }
    /*ȡӦbitλ*/
  
    byteVal =( (*pTestInfoBuf ) >> GetBitOffset(nvParam)) & 0x03;
    
    switch (byteVal)
    {
    case 0:
        byteRet = 0x30;
        break;
    case 1:
        byteRet = 0x31;
        break;
    case 2:
        byteRet = 0x32;
        break;
    case 3:
        byteRet = 0x33;
        break;
    default:
        break;
    }
    
    memcpy(NvItemData, &byteRet, sizeof(byteRet));
    #if 0
    if (CPNV_ERROR ==retCode )
    {
        assert(0);
    }
    #endif
    return 0;
}

/**
 * @brief NVROûԶ
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param from д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
 int amt_nvro_user_write(UINT32 dwStart, UINT32 dwLen, UINT8* from)
 {
    unsigned int  ret = CPNV_ERROR;
    
    if (dwStart >= OS_FLASH_AMT_COMM_RO_USER_DEFINE_SIZE || dwLen > OS_FLASH_AMT_COMM_RO_USER_DEFINE_SIZE || (dwStart + dwLen) > OS_FLASH_AMT_COMM_RO_USER_DEFINE_SIZE)
    {
        return -1;
    }

    ret = amt_nvro_write(dwStart + OS_FLASH_AMT_COMM_RO_USER_DEFINE_ADDRESS, dwLen, from);

    cpnv_FsGcWait(FS_NVROFS);
         
    if(ret == CPNV_ERROR)
    {
        return -1;
    }
    else
    {
        return 0;
    }
    
 }

/**
 * @brief NVROûԶд
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param from 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_nvro_user_read(UINT32 dwStart, UINT32 dwLen, UINT8* to)
{
    unsigned int ret = CPNV_ERROR;
    
    if (dwStart >= OS_FLASH_AMT_COMM_RO_USER_DEFINE_SIZE || dwLen > OS_FLASH_AMT_COMM_RO_USER_DEFINE_SIZE || (dwStart + dwLen) > OS_FLASH_AMT_COMM_RO_USER_DEFINE_SIZE)
    {
        return -1;
    }
    
    ret = cpnv_NvItemRead(dwStart + OS_FLASH_AMT_COMM_RO_USER_DEFINE_ADDRESS, to,dwLen);
    
    if(ret ==  CPNV_ERROR)
    {
        return -1;
    }
    else
    {
        return 0;
    }
}

/**
 * @brief NVROοԶд
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param from д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_nvro_ref_write(UINT32 dwStart, UINT32 dwLen, UINT8* from)
{
    unsigned int ret = CPNV_ERROR;
    
    if (dwStart >= OS_FLASH_AMT_COMM_RO_REF_DEFINE_SIZE || dwLen > OS_FLASH_AMT_COMM_RO_REF_DEFINE_SIZE || (dwStart + dwLen) > OS_FLASH_AMT_COMM_RO_REF_DEFINE_SIZE)
    {
        return -1;
    }

    ret = amt_nvro_write(dwStart + OS_FLASH_AMT_COMM_RO_REF_DEFINE_ADDRESS, dwLen, from);
    
    if(ret ==  CPNV_ERROR)
    {
        return -1;
    }
    else
    {
        return 0;
    }
}

/**
 * @brief NVROοԶ
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param to 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_nvro_ref_read(UINT32 dwStart, UINT32 dwLen, UINT8* to)
{
    unsigned int  ret = CPNV_ERROR;
    
    if (dwStart >= OS_FLASH_AMT_COMM_RO_REF_DEFINE_SIZE || dwLen > OS_FLASH_AMT_COMM_RO_REF_DEFINE_SIZE || (dwStart + dwLen) > OS_FLASH_AMT_COMM_RO_REF_DEFINE_SIZE)
    {
        return -1;
    }
    
    ret = cpnv_NvItemRead(dwStart + OS_FLASH_AMT_COMM_RO_REF_DEFINE_ADDRESS, to,dwLen);
    
    if(ret ==  CPNV_ERROR)
    {
        return -1;
    }
    else
    {
        return 0;
    }
}


 /**
 * @brief ӦòжϵǰǷamtģʽ
 * @param 
 * @return 1 amtģʽ
 * @return 0 normalģʽ
 * @note   
 * @warning 
 */
int is_amt_mode(void)
{
    char verMode[4] = {0};
    int ret = 0;

    ret = sc_cfg_get("ver_mode", verMode, sizeof(verMode));
    if(!strncmp(verMode, "0", strlen("0")))
    {
        ret = 1;
    }
    else
    {
        ret = 0;
    }
	
	return ret;
}

/**
 * @brief bootģʽ
 * @param bootmode 2ֽڵıʶ: 
 *              {0x54,0x00} : user,
 *              {0x54,0x01} : debug,
 *              {0x54,0x02} : factory,
 *              {0x54,0x4D} : amt,
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_set_bootmode(unsigned char  bootmode[])
{
    unsigned int  ret = CPNV_OK;

    if(CPNV_ERROR == cpnv_ChangeFsPartitionAttr(FS_IMAGEFS, 1))
    {
        printf("cpnv_ChangeFsPartitionAttr failed\r\n");
        return -1;
    }
    ret = cpnv_NvItemWrite(OS_FLASH_TSP_RW_NONFAC_OFFSET_FROM_NV, bootmode, 2);
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvItemWrite bootmode fail !\n");
        return ret;
    }
    
    cpnv_NvItemWriteFactory(OS_FLASH_TSP_RW_NONFAC_OFFSET_FROM_NV, bootmode, 2);
    ret = cpnv_NvramFlush();
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvramFlush bootmode fail !\n");
    }
    
    cpnv_FsGcWait(FS_IMAGEFS);
    if(CPNV_ERROR == cpnv_ChangeFsPartitionAttr(FS_IMAGEFS, 0))
    {
        printf("cpnv_ChangeFsPartitionAttr failed\r\n");
        return -1;
    }

    return ret;
}

unsigned int amt_set_batdet_flag(int batdet_value)
{
	unsigned int  ret = CPNV_OK;

    if(CPNV_ERROR == cpnv_ChangeFsPartitionAttr(FS_IMAGEFS, 1))
    {
        printf("cpnv_ChangeFsPartitionAttr failed\r\n");
        return -1;
    }
    ret = cpnv_NvItemWrite(DRV_PERI_NV_ADDR,(unsigned char*)&batdet_value,1);
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvItemWrite batdet_value fail !\n");
        return ret;
    }
    
    cpnv_NvItemWriteFactory(DRV_PERI_NV_ADDR, (unsigned char*)&batdet_value,1);
    ret = cpnv_NvramFlush();
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvramFlush batdet_value fail !\n");
    }
    
    cpnv_FsGcWait(FS_IMAGEFS);
    if(CPNV_ERROR == cpnv_ChangeFsPartitionAttr(FS_IMAGEFS, 0))
    {
        printf("cpnv_ChangeFsPartitionAttr failed\r\n");
        return -1;
    }

    return ret;
}

unsigned int amt_get_batdet_flag(int *pbatdet_value)
{
	unsigned int retCode= CPNV_ERROR;
   
    retCode =cpnv_NvItemRead(DRV_PERI_NV_ADDR, (unsigned char *)pbatdet_value, 1);

	return retCode;
    
}

unsigned int amt_set_amt_atmode(unsigned char  bootmode[],unsigned char  atmode[])
{
	 unsigned int  ret = CPNV_OK;

    if(CPNV_ERROR == cpnv_ChangeFsPartitionAttr(FS_IMAGEFS, 1))
    {
        printf("cpnv_ChangeFsPartitionAttr failed\r\n");
        return -1;
    }
    ret = cpnv_NvItemWrite(OS_FLASH_TSP_RW_NONFAC_OFFSET_FROM_NV, bootmode, 2);
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvItemWrite bootmode fail !\n");
        return ret;
    }
    cpnv_NvItemWriteFactory(OS_FLASH_TSP_RW_NONFAC_OFFSET_FROM_NV, bootmode, 2);
	
    ret = cpnv_NvItemWrite(OS_FLASH_TSP_RW_NONFAC_AT_MODE_ADDR, atmode, 2);
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvItemWrite at mode fail !\n");
        return ret;
    }
    cpnv_NvItemWriteFactory(OS_FLASH_TSP_RW_NONFAC_AT_MODE_ADDR, atmode, 2);
    ret = cpnv_NvramFlush();
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvramFlush fail !\n");
    }
    
    cpnv_FsGcWait(FS_IMAGEFS);
    if(CPNV_ERROR == cpnv_ChangeFsPartitionAttr(FS_IMAGEFS, 0))
    {
        printf("cpnv_ChangeFsPartitionAttr failed\r\n");
        return -1;
    }

    return ret;

}

unsigned int is_amt_atmode()
{
	unsigned int  ret = CPNV_OK;
	unsigned char  mode[4] = {0};

    ret = cpnv_NvItemRead(OS_FLASH_TSP_RW_NONFAC_BASE_ADDR, mode, 2);
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvItemRead at mode fail !\n");
        return ret;
    }
	
	ret = cpnv_NvItemRead(OS_FLASH_TSP_RW_NONFAC_AT_MODE_ADDR, mode+2, 2);
    if(CPNV_ERROR == ret)
    {
        printf("cpnv_NvItemRead at mode fail !\n");
        return ret;
    }

	printf("mode[0] = %x,mode[1] = %x,mode[2] = %x,mode[3] = %x!\n",mode[0],mode[1],mode[2],mode[3]);

	if((mode[0] == 0x54)&&(mode[1] == 0x4D)&&(mode[2] == 0x41)&&(mode[3] == 0x54))
	{
	    printf("mode = 1\n");
		return 1;
	}
	else
	{
	    printf("mode = 0\n");
		return 0;
	}

}





