#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <stdarg.h>

#include "pub_debug_info.h"

#define DEBUG_INFO_MAX_TOTAL_LEN (140)
//#define DEBUG_INFO_MAX_DATA_LEN  (128)
//#define DEBUG_INFO_MEM_HEAD_LEN  (8)

ssize_t  safe_write(int fd, const void *buf, size_t count)
{
	ssize_t n;

	for (;;) {
		n = write(fd, buf, count);
		if (n >= 0 || errno != EINTR)
			break;
		/* Some callers set errno=0, are upset when they see EINTR.
		 * Returning EINTR is wrong since we retry write(),
		 * the "error" was transient.
		 */
		errno = 0;
		/* repeat the write() */
	}

	return n;
}
int sc_debug_info_record(char *id, const char *format, ...)
{
    int fd = -1;
    ssize_t writelen;
    int len;
    va_list args;
    char str_buf[DEBUG_INFO_MAX_TOTAL_LEN] __attribute__((aligned(4)));
    char *ptmpstr = str_buf;

    /* args是一个char*类型指针，指向format之后的第一个参数*/
    if( id == NULL)
        return -1;
    
    len = snprintf((char *)ptmpstr, DEBUG_INFO_MAX_TOTAL_LEN, "[%s]",id);
    ptmpstr += len;
    va_start(args, format);
    len +=  vsnprintf(ptmpstr, DEBUG_INFO_MAX_TOTAL_LEN - len, format, args);
    va_end(args);
    if (len < 0)
    {
        printf("[libdebug_info]: vsnprintf format error, %s.\n", strerror(errno));
        return -1;
    }

    fd = open(DEBUG_INFO_DEV_PATH, O_WRONLY);
    if (fd < 0)
    {
        printf("[libdebug_info]: sc_debug_info_record, open debug_info error, %s\n", strerror(errno));
        return -1;
    }

    writelen = safe_write(fd, (char *)str_buf, len);
    if (writelen < 0)
    {
        printf("[libdebug_info]: sc_debug_info_record, write debug_info error, %s\n", strerror(errno));
        return -1;
    }

    if (fd >= 0)
    {
        close(fd);
    }

    return writelen;
}
