//
// Tm = getTm(Word16 wsph, Word16 wspx, Word16 L_frame, Word16 *ww, Word16 need, Word16 *we);
//
// r0 --- wsph   r1 --- wspx   r2 --- L_frame   r3 --- ww
// r0 -- wsph          r1 -- wspx        r2  -- tm     r3 -- L_frame    r4 -- wspx_v 
// r5-r7 -- wsph_v     r8-r11 -- sum     r12 -- max    r14 --- 

#include "oscl_base_macros.h"
#include "gsm_amr_typedefs.h"

#if (PV_COMPILER == EPV_ARM_RVCT)

__asm Word16 GetTm_asm(Word16 *wsph, Word16 *wspx, Word16 L_frame, Word16 *ww, Word16 need, Word16 *we)
{
        PRESERVE8

#if (PV_CPU_ARCH_VERSION >= 6)
    STMFD     r13!, {r0 - r12, r14}
    MOV       r14, #0
    LDR       r12, =0x80000000
    MOV       r2,  #0

LOOP
    LDR       r3, [r13, #8]               // get L_frame, L_frameλ4ı
    LDR       r0, [r13]                   // get h addr
    LDR       r1, [r13, #4]               // get x ԭʼaddr
    MOV       r3, r3, ASR #2              // ÿμ4
    ADD       r1, r1, r14, LSL #3         // ÿѭ4xԭʼaddrĻƫ8ֽ
    MOV       r8,  #0
    MOV       r9,  #0
    MOV       r10, #0
    MOV       r11, #0
    CMP       r14, #24                    //Ѿ24飬һֻ2(97-98)
    BGE       LastTwoLine
    
    //ʼ
    LDRSH     r5, [r0], #2
    LDRSH     r6, [r0], #2
    LDRSH     r4, [r1], #2
    PKHBT     r5, r5, r6, LSL #16
    
    SMLABB    r8, r4, r5, r8
    
    LDRSH     r4, [r1], #2
    SMLABB    r9, r4, r5, r9
    SMLABT    r8, r4, r5, r8
    
    LDRSH     r6, [r0], #2
    LDRSH     r7, [r0], #2
    LDRSH     r4, [r1], #2
    PKHBT     r6, r6, r7, LSL #16
    SMLABB    r10, r4, r5, r10
    SMLABT    r9, r4, r5, r9
    SMLABB    r8, r4, r6, r8
    
    LDRSH     r4, [r1], #2
    SMLABB    r11, r4, r5, r11
    SMLABT    r10, r4, r5, r10
    SMLABB    r9, r4, r6, r9
    SMLABT    r8, r4, r6, r8
    SUB       r3, r3, #1
	
LOOP1 //мķ
    LDRSH     r7, [r0], #2
    LDRSH     r4, [r1], #2
    
    SMLABT    r11, r4, r5, r11
    LDRSH     r5, [r0], #2
    SMLABB    r10, r4, r6, r10
    SMLABT    r9,  r4, r6, r9
    PKHBT     r7, r7, r5, LSL #16
    SMLABB    r8,  r4, r7, r8
    
    LDRSH     r4, [r1], #2
    SMLABB    r11, r4, r6, r11
    SMLABT    r10, r4, r6, r10
    SMLABB    r9,  r4, r7, r9
    SMLABT    r8,  r4, r7, r8
    
    LDRSH     r5, [r0], #2
    LDRSH     r4, [r1], #2
    SMLABT    r11, r4, r6, r11
    LDRSH     r6, [r0], #2
    SMLABB    r10, r4, r7, r10
    SMLABT    r9,  r4, r7, r9
    PKHBT     r5, r5, r6, LSL #16
    SMLABB    r8,  r4, r5, r8
    
    LDRSH     r4, [r1], #2
    SMLABB    r11, r4, r7, r11
    SMLABT    r10, r4, r7, r10
    SMLABB    r9,  r4, r5, r9
    SMLABT    r8,  r4, r5, r8
    
    MOV       r6, r5
    MOV       r5, r7
    
    SUBS      r3, r3, #1
    BNE       LOOP1
    
    //
    LDRSH     r4, [r1], #2
    SMLABT    r9,  r4, r6, r9
    SMLABB    r10, r4, r6, r10
    SMLABT    r11, r4, r5, r11
    
    LDRSH     r4, [r1], #2
    SMLABT    r10, r4, r6, r10
    SMLABB    r11, r4, r6, r11	
    
    LDRSH     r4, [r1], #2
    SMLABB    r11, r4, r6, r11	
    
    QADD      r8,  r8,  r8 
    QADD      r9,  r9,  r9
    QADD      r10, r10, r10
    QADD      r11, r11, r11

WeightingCorr
    LDR       r3, [r13, #12]                  // get ww
    LDRSH     r4, [r3], #-2
    LDRSH     r5, [r3], #-2
    LDRSH     r6, [r3], #-2
    LDRSH     r7, [r3], #-2
    STR       r3, [r13, #12]
    SMULWB    r8, r8, r4
    SMULWB    r9, r9, r5
    SMULWB    r10, r10, r6
    SMULWB    r11, r11, r7
    QADD      r8,  r8,  r8 
    QADD      r9,  r9,  r9
    QADD      r10, r10, r10
    QADD      r11, r11, r11
    
    LDR       r5, [r13, #56]                  // ȡneed
    CMP       r5, #0                          
    BNE       WeightingEnd

WeightingNeigh                                // if ((L_0 > 0) && (wght_flg > 0)) 
    LDR       r3, [r13, #60]
    LDRSH     r4, [r3], #-2
    LDRSH     r5, [r3], #-2
    LDRSH     r6, [r3], #-2
    LDRSH     r7, [r3], #-2
    STR       r3, [r13, #60]
    SMULWB    r8,  r8,  r4
    SMULWB    r9,  r9,  r5
    SMULWB    r10, r10, r6
    SMULWB    r11, r11, r7
    QADD      r8,  r8,  r8 
    QADD      r9,  r9,  r9
    QADD      r10, r10, r10
    QADD      r11, r11, r11
	
WeightingEnd
    MOV       r5, r14, LSL #2                 // tm
    CMP       r8, r12
    MOVGT     r12, r8
    ADDGT     r2,  r5, #0
    CMP       r9, r12
    MOVGT     r12, r9
    ADDGT     r2,  r5, #1
    CMP       r10, r12
    MOVGT     r12, r10
    ADDGT     r2,  r5, #2
    CMP       r8, r12
    MOVGT     r12, r10
    ADDGT     r2,  r5, #3
    
    ADD       r14, r14, #1
    B         LOOP	
	
LastTwoLine
    LDRSH     r5, [r0], #2
    LDRSH     r7, [r0], #2
    PKHBT     r5, r5, r7, LSL #16
    LDRSH     r4, [r1], #2
    
    SMLABB    r8, r4, r5, r8
    
    LDRSH     r4, [r1], #2
    SMLABT    r8, r4, r5, r8
    SMLABB    r9, r4, r5, r9
    
    LDRSH     r6, [r0], #2
    LDRSH     r7, [r0], #2
    LDRSH     r4, [r1], #2
    PKHBT     r6, r6, r7, LSL #16
    SMLABB    r8, r4, r6, r8
    SMLABT    r9, r4, r5, r9
    
    LDRSH     r4, [r1], #2
    SMLABT    r8, r4, r6, r8
    SMLABB    r9, r4, r6, r9
    
    MOV       r5, r6
    SUB       r3, r3, #1
	
LastLOOP1 //мķ
    LDRSH     r6, [r0], #2
    LDRSH     r7, [r0], #2
    LDRSH     r4, [r1], #2
    PKHBT     r6, r6, r7, LSL #16
    
    SMLABB    r8,  r4, r6, r8
    SMLABT    r9,  r4, r5, r9
    
    LDRSH     r4, [r1], #2
    MOV       r5, r6
    SMLABT    r8,  r4, r6, r8
    SMLABB    r9,  r4, r6, r9
    
    LDRSH     r6, [r0], #2
    LDRSH     r7, [r0], #2
    LDRSH     r4, [r1], #2
    PKHBT     r6, r6, r7, LSL #16
    
    SMLABB    r8,  r4, r6, r8
    SMLABT    r9,  r4, r5, r9
    
    LDRSH     r4, [r1], #2
    MOV       r5, r6
    SMLABT    r8,  r4, r6, r8
    SMLABB    r9,  r4, r6, r9
    
    SUBS      r3, r3, #1
    BNE       LastLOOP1
    
    //
    LDRSH     r4, [r1], #2
    SMLABT    r9,  r4, r5, r9
    QADD      r8,  r8,  r8 
    QADD      r9,  r9,  r9

LastWeightingCorr
    LDR       r3, [r13, #12]                   //get ww
    LDRSH     r4, [r3], #-2
    LDRSH     r5, [r3], #-2
    STR       r3, [r13, #12]
    SMULWB    r8,  r8,  r4
    SMULWB    r9,  r9,  r5
    QADD      r8,  r8,  r8
    QADD      r9,  r9,  r9
    
    LDR       r5, [r13, #56]                   // ȡneed
    CMP       r5, #0                          
    BNE       LastWeightingEnd

LastWeightingNeigh	                           //if ((L_0 > 0) && (wght_flg > 0)) 
    LDR       r3, [r13, #60]                   // get we
    LDRSH     r4, [r3], #-2
    LDRSH     r5, [r3], #-2
    STR       r3, [r13, #60]
    SMULWB    r8,  r8,  r4
    SMULWB    r9,  r9,  r5
    QADD      r8,  r8,  r8
    QADD      r9,  r9,  r9
	
LastWeightingEnd
    MOV       r5, r14, LSL #2                  // tm
    CMP       r8, r12
    MOVGT     r12, r8
    ADDGT     r2,  r5, #0
    CMP       r9, r12
    MOVGT     r12, r9
    ADDGT     r2,  r5, #1

The_end
    ADD       r13,  r13, #4
    MOV       r0,   r2
    LDMFD     r13!, {r1 - r12, r15}
#endif

}
#endif

