
#include "oscl_base_macros.h"
#include "syn_filt.h"

#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)
__asm     OSCL_IMPORT_REF void Syn_filt_asm(
        Word16 a[],        /* (i)  : a[m+1] prediction coefficients   (m=10)    */
        Word16 x[],        /* (i)  : input signal                               */
        Word16 y[],        /* (o)  : output signal                              */
        Word16 lg,         /* (i)  : size of filtering                          */
        Word16 mem[],      /* (i/o): memory associated with this filtering.     */
        Word16 update      /* (i)  : 0=no update, 1=update of memory.           */
    )
{
        PRESERVE8
            
//ֲƫ

AA          EQU 0 //ϵ8*Word16a[1-8]
A_X         EQU 16 //a[0]
P_X         EQU 20
P_Y         EQU 24
I           EQU 28
LOC_SIZE    EQU 32
P_MEM       EQU (LOC_SIZE+10*4)
UPDATE      EQU (LOC_SIZE+10*4+4) //ֲĴС+10Ĵ

a_0    RN 0
a_1    RN 1
a_2    RN 2
a_3    RN 3
a_4    RN 4

m_0    RN 5
m_1    RN 6
m_2    RN 7
m_3    RN 8
m_4    RN 9

s_0    RN 10
s_1    RN 11

a_a    RN 14


//¸ļĴ

a_x    RN 1
x      RN 2
s_a    RN 3
p_y    RN 14
p_x    RN 12
s_b    RN 0
i      RN 1

    MACRO
    LOAD $reg, $off
    LDR  $reg, [sp, #$off]
    MEND

    MACRO
    STORE $reg, $off
    STR   $reg, [sp, #$off]
    MEND
    

        STMFD   sp!, {r4-r12, lr}
        SUB     sp, sp, #LOC_SIZE   //ֲ

//ʼ
        MOV      p_x, r1
        STORE    r2, P_Y        
        ASR      r3, r3, #1
        STORE    r3, I
    
//a[1-10]    
        TST      r0, #2
        BNE      A_NOT_ALIGN

        LDM      r0!, {r5-r9}
        LDRSH    r10, [r0]
        
        PKHBT    a_0, r10, r9
        PKHBT    a_1, r9,  r8
        PKHBT    a_2, r8,  r7
        PKHBT    a_3, r7,  r6
        PKHBT    a_4, r6,  r5

A_END
        LOAD     r14, P_MEM
        STORE    r5, A_X   //a[0]
        STM      sp, {a_0-a_3} //a[1-8], a[9,10]
        
        TST      r14, #2
        BNE      M_NOT_ALIGN        
        
        LDM      r14, {m_0-m_4} //һεֵ

M_END

//ѭ
LOOP
        SMUAD     s_0, a_0, m_0
        
        SMULBT    s_1, a_0, m_0
        PKHTB     a_a, a_0, a_1 //ǰ        
        
        SMLAD     s_0, a_1, m_1, s_0      

        SMLADX    s_1, a_a, m_1, s_1        
        PKHTB     a_a, a_1, a_2        
          
        SMLAD     s_0, a_2, m_2, s_0
        
        SMLADX    s_1, a_a, m_2, s_1       
        PKHTB     a_a, a_2, a_3        
        
        SMLAD     s_0, a_3, m_3, s_0        
        
        SMLADX    s_1, a_a, m_3, s_1      
        PKHTB     a_a, a_3, a_4                           

        LOAD      a_x, A_X
        LDM       p_x!, {x}
                
        SMLAD     s_0, a_4, m_4, s_0

        SMLADX    s_1, a_a, m_4, s_1                  
        
        MOV       s_b, #0x800
        SMLABB    s_a, a_x, x, s_b
        SMLABT    s_b, a_x, x, s_b
       
        MOV       m_0, m_1       
       
        QSUB      s_0, s_a, s_0
        MOV       m_1, m_2
        MOV       m_2, m_3        
        SSAT      s_0, #16, s_0, asr #12
        MOV       m_3, m_4     
        LOAD      p_y, P_Y    
        SMLATB    s_1, a_4, s_0, s_1
        LOAD      i, I
        QSUB      s_1, s_b, s_1
        SUBS      i, i, #1		
        STRNE     i, [sp, #I]          
        SSAT      s_1, #16, s_1, asr #12
        
        PKHBT     m_4, s_0, s_1, LSL #16
       
        STM       p_y!, {m_4}
        
        LDM       sp, {a_0-a_3}   
        STORE     p_y, P_Y
				
//LOOP END
        BNE      LOOP

        LDRSH    r14, [sp, #UPDATE]
        CMP      r14, #0
        BEQ      END
        
        LOAD     r14, P_MEM
        TST      r14, #2
        BNE      COPY_M
        
        STM      r14, {m_0-m_4}

END
        ADD     sp, sp, #(LOC_SIZE)   //ֲͷ
        LDMFD   sp!, {r4-r12, pc}

A_NOT_ALIGN
        LDRSH    r5, [r0], #2
        LDM      r0, {r6-r10}
        ROR      a_0, r10, #16
        ROR      a_1, r9,  #16
        ROR      a_2, r8,  #16
        ROR      a_3, r7,  #16
        ROR      a_4, r6,  #16         
        B        A_END

M_NOT_ALIGN
        LDRSH    r6, [r14], #2
        LDM      r14!, {r7-r10} //һεֵ
        LDRSH    r11, [r14], #2
        
        PKHBT    m_0, r6, r7, LSL #16
        PKHTB    m_1, r7, r8       
        PKHTB    m_2, r8, r9                                    
        PKHTB    m_3, r9, r10  
        PKHTB    m_4, r10, r11
        
        ROR      m_1, m_1,  #16                   
        ROR      m_2, m_2,  #16       
        ROR      m_3, m_3,  #16                   
        ROR      m_4, m_4,  #16       
                                     
        B        M_END

COPY_M
        STRH    m_0, [r14], #2
        
        PKHTB    r0, m_0, m_1
        PKHTB    r1, m_1, m_2
        PKHTB    r2, m_2, m_3
        PKHTB    r3, m_3, m_4
        
        ROR      r0, r0,  #16                                       
        ROR      r1, r1,  #16  
        ROR      r2, r2,  #16                                       
        ROR      r3, r3,  #16

        STM      r14!, {r0-r3}
        
        ASR      m_4, m_4, #16          
        STRH     m_4, [r14]
        
        B        END
}
#endif        
        

