/************************************************************************
 * Ȩ (C)2010,ͨѶɷ޹˾
 * ģ  
 * ļƣ os_file.c
 * ļʶ Zcoreļزӿ
 * ժҪ
 *
 * ޸    汾       ޸ı        ޸        ޸
 * ----------------------------------------------------------------------
 * 2010-04-28    1.0                        Darren.Ma       ½
 ************************************************************************/

/**************************************************************************
 *                        ͷļ                                                                         *
 **************************************************************************/
#include    "os_type.h"
#include    "os_pub.h"
#include    "os_sema.h"
#include    "os_mem.h"
#include    "os_list.h"
#include    "os_mutex.h"
#include    "os_queue.h"


/****************************************************************************
 *                          غ
 ****************************************************************************/
#define queue_context(qid)      ((OSA_QUEUE_CONTEXT *)qid)
#define queue_info(qid)         (queue_context(qid)->info)


/****************************************************************************
 *                         
 ****************************************************************************/
typedef struct
{
    OS_LIST_NODE    node;
    VOID            *p_msg;
} OSA_QUEUE_NODE;

typedef struct
{
    OS_MUTEX_ID         mutex;
    OS_SEMA_ID          wait_recv_sema;
    OS_SEMA_ID          wait_send_sema;
    OS_LIST             msg_list;
    OS_QUEUE_INFO       info;
} OSA_QUEUE_CONTEXT;


/****************************************************************************
 *                          غԭ
 ****************************************************************************/
static SINT32 queue_context_add( OSA_QUEUE_CONTEXT **p_context );
static VOID queue_context_remove( OSA_QUEUE_CONTEXT *p_context );

/****************************************************************************
 *                          ȫֺʵ
****************************************************************************/

/**************************************************************************
* ƣ tp_os_queue_create
*  Ϣ
* ˵ nameĶ
                                msg_sizeϢĴС
                                max_numsϢĿ
*   ֵ    ɹ򷵻Ϣеıʶţ򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_QUEUE_ID tp_os_queue_create( CHAR*name, UINT32 msg_size, UINT32 max_nums )
{
    OSA_QUEUE_CONTEXT   *p_context = NULL;

    TP_OS_ASSERTEx( NULL != name, OS_QUEUE_INVALID_ID );
    TP_OS_ASSERTEx( 0 < max_nums, OS_QUEUE_INVALID_ID );

    if ( OS_SUCCESS != queue_context_add( &p_context ) )
    {
        return OS_QUEUE_INVALID_ID;
    }
    strncpy( p_context->info.name, name, OS_MAX_NAME_LEN-1 );
    p_context->info.max_msg_num = max_nums;
    p_context->info.used_count  = 0;

    return p_context->info.id;
}
/**************************************************************************
* ƣ tp_os_queue_delete
*  ɾָϢУеϢȫԶͷţ
                                ȴϢе߳ȫȴ״̬
* ˵ qidϢеıʶ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_queue_delete( OS_QUEUE_ID qid )
{
    TP_OS_ASSERTEx( OS_QUEUE_INVALID_ID != qid, OS_FAILURE );

    queue_context_remove( queue_context(qid) );

    return OS_SUCCESS;
}

/**************************************************************************
* ƣ tp_os_queue_receive
*  ָϢнһϢѴϢضַ
* ˵ qidϢеıʶ
                                msg_ptrϢĵַָ
                                timeoutָʾϢȴʱ䣬λΪ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_queue_receive( OS_QUEUE_ID qid, VOID **msg_ptr, UINT32 timeout )
{
    SINT32  ret = OS_SUCCESS;
    OSA_QUEUE_CONTEXT   *p_context = NULL;
    OSA_QUEUE_NODE      *p_node = NULL;

    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != qid, OS_FAILURE );
    p_context = queue_context(qid);

    tp_os_mutex_get( p_context->mutex, OS_WAIT_FOREVER );

    if ( 0 == p_context->info.used_count )
    {   /* no free msg in queue, so we need to check the timeout parameter */
        if ( 0 == timeout )
        {
            tp_os_mutex_put( p_context->mutex );
            //TP_OS_SET_ERRNO( ERR_OS_NO_INSTANCE );
            return OS_FAILURE;
        }
        else
        {
            if ( OS_SEMA_INVALID_ID == p_context->wait_recv_sema )
            {
                p_context->wait_recv_sema = tp_os_sema_create( "tp_os_queue_", 0 );
                TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != p_context->wait_recv_sema, OS_FAILURE );
            }
            tp_os_mutex_put( p_context->mutex );
            if ( OS_SUCCESS != (ret = tp_os_sema_get( p_context->wait_recv_sema, timeout )) )
            {
                /*if ( ERR_OS_INVALID_SEMAPHORE == TP_OS_GET_ERRNO() )
                {
                    TP_OS_SET_ERRNO( ERR_OS_INVALID_QUEUE );
                }*/
                return OS_FAILURE;
            }
            tp_os_mutex_get( p_context->mutex, OS_WAIT_FOREVER );
        }
    }

    /* dequeue msg */
    p_node = (OSA_QUEUE_NODE *)tp_os_list_first( &p_context->msg_list );
    if (p_node == NULL)
    {
        tp_os_mutex_put( p_context->mutex );
        return OS_FAILURE;
    }
    p_context->info.used_count --;
    *msg_ptr = p_node->p_msg;
    tp_os_list_delete( (OS_LIST *)&p_context->msg_list, (OS_LIST_NODE *)p_node );
    tp_os_mem_free( p_node );
    p_node = NULL;
    if ( (OS_SEMA_INVALID_ID != p_context->wait_send_sema)
            && (p_context->info.max_msg_num-1 == p_context->info.used_count) )
    {
        tp_os_sema_put( p_context->wait_send_sema );
    }

    tp_os_mutex_put( p_context->mutex );

    return OS_SUCCESS;
}

/**************************************************************************
* ƣ tp_os_queue_send
*  ָϢзһϢ
* ˵ qidϢеıʶ
                                msg_ptrϢĵַָ
                                timeoutָʾϢȴʱ䣬λΪ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_queue_send( OS_QUEUE_ID qid, VOID *msg_ptr, UINT32 timeout )
{
    OSA_QUEUE_CONTEXT   *p_context = NULL;
    OSA_QUEUE_NODE      *p_node = NULL;

    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != qid, OS_FAILURE );
    p_context = queue_context(qid);

    tp_os_mutex_get( p_context->mutex, OS_WAIT_FOREVER );

    if ( p_context->info.max_msg_num == p_context->info.used_count )
    {   /* the queue if full, so wo check the timeout parameter */
        if ( 0 == timeout )
        {
            tp_os_mutex_put( p_context->mutex );
            return OS_FAILURE;
        }
        else
        {
            if ( OS_SEMA_INVALID_ID == p_context->wait_send_sema )
            {
                p_context->wait_send_sema = tp_os_sema_create( "tp_os_queue_", 0 );
                TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != p_context->wait_send_sema, OS_FAILURE );
            }
            tp_os_mutex_put( p_context->mutex );
            if ( OS_FAILURE == tp_os_sema_get( p_context->wait_send_sema, timeout ) )
            {
                return OS_FAILURE;
            }
            tp_os_mutex_get( p_context->mutex, OS_WAIT_FOREVER );
        }
    }

    /* queue msg */
    p_node = (OSA_QUEUE_NODE *)tp_os_mem_malloc( sizeof(OSA_QUEUE_NODE) );
    if ( NULL == p_node )
    {
        tp_os_mutex_put( p_context->mutex );
        return OS_FAILURE;
    }
    p_node->p_msg = msg_ptr;
    tp_os_list_add( (OS_LIST *)&p_context->msg_list, (OS_LIST_NODE *)p_node );
    p_context->info.used_count ++;
    if ( (OS_SEMA_INVALID_ID != p_context->wait_recv_sema)
            && (1 == p_context->info.used_count) )
    {
        tp_os_sema_put( p_context->wait_recv_sema );
    }

    tp_os_mutex_put( p_context->mutex );

    return OS_SUCCESS;
}


/**************************************************************************
* ƣ tp_os_queue_info_get
*  ȡָϢеϢ
* ˵ qidϢеıʶ
                                info_ptrϢϢĴ洢ṹ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_queue_info_get( OS_QUEUE_ID qid, OS_QUEUE_INFO *info_ptr )
{
    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != qid, OS_FAILURE );

    tp_os_mem_cpy( info_ptr, &queue_info(qid), sizeof(OS_QUEUE_INFO) );

    return OS_SUCCESS;
}


/**************************************************************************
* ƣ queue_context_add
* 
* ˵
*   ֵ    
* ˵ ѡ
**************************************************************************/
static SINT32 queue_context_add( OSA_QUEUE_CONTEXT **p_context )
{
    OSA_QUEUE_CONTEXT   *p_queue_context = NULL;

    p_queue_context = (OSA_QUEUE_CONTEXT *)tp_os_mem_malloc( sizeof(OSA_QUEUE_CONTEXT) );
    if ( NULL == p_queue_context )
    {
        return OS_FAILURE;
    }
    tp_os_mem_set( p_queue_context, 0, sizeof(OSA_QUEUE_CONTEXT) );

    p_queue_context->mutex          = tp_os_mutex_create( "queue_mutex", TRUE );
    TP_OS_ASSERTEx( OS_MUTEX_INVALID_ID != p_queue_context->mutex, OS_FAILURE );
    p_queue_context->wait_recv_sema = OS_SEMA_INVALID_ID;
    p_queue_context->wait_send_sema = OS_SEMA_INVALID_ID;
    tp_os_list_init( (OS_LIST *)&p_queue_context->msg_list );
    p_queue_context->info.id        = (OS_QUEUE_ID)p_queue_context;

    *p_context = p_queue_context;

    return OS_SUCCESS;
}

/**************************************************************************
* ƣ queue_context_remove
* 
* ˵
*   ֵ    
* ˵ ѡ
**************************************************************************/
static VOID queue_context_remove( OSA_QUEUE_CONTEXT *p_context )
{
    if ( OS_SEMA_INVALID_ID != p_context->wait_recv_sema )
    {
        tp_os_sema_delete( p_context->wait_recv_sema );
        p_context->wait_recv_sema = OS_SEMA_INVALID_ID;
    }
    if ( OS_SEMA_INVALID_ID != p_context->wait_send_sema )
    {
        tp_os_sema_delete( p_context->wait_send_sema );
        p_context->wait_send_sema = OS_SEMA_INVALID_ID;
    }
    if ( OS_MUTEX_INVALID_ID != p_context->mutex )
    {
        tp_os_mutex_delete( p_context->mutex );
        p_context->mutex = OS_MUTEX_INVALID_ID;
    }

    tp_os_mem_free( p_context );
    p_context = NULL;
}
