/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  Library for function related to internal polyphonic ringer for the audio driver.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_intern_midilib.c
 *   Version: \main\102
 *   Date: 2007-10-02 09:07:03
 *   Comment:
 *     merged steon changes
 */

#ifdef INTERNAL_POLYRINGER
/*---------------------------------------------*/
/* Include files.                              */
/*---------------------------------------------*/
//#include "scttypes.h"
#include "bastypes.h"
//#include "ms.h"
//#include "trap.h"

#ifdef DWD_VIB
#include "vib.h"
#endif

//#include "gsmtu.h"
//#include "psv.h"
#include "aud_drv.h"
#include "aud_com.h"
#include "aud_ringer.h"
#include "aud_data.h"
#include "drvs_rtt.h"

#if defined (SMPOWER3)
//#include "pmu_hal.h"
#else
#include "pow_sm.h"
#endif

#include "aud_path_control.h"
#include "aud_intern_midilib.h"
#include "aud_intern_midilib_lib.h"
//#include "aud_mixer.h"
#include "midi_api.h"
#include "drvs_teak.h"
typedef void(*MidiGetTotalTime_CallbackFunc)(UINT32);
typedef void(*MidiGetPlayPosition_CallbackFunc)(UINT32);
/*---------------------------------------------*/
/* Global data.                                                            */
/*---------------------------------------------*/
aud_glob_melody_suspend_array_type aud_melody_suspend_array;
aud_glob_midi_type     aud_glob_midi;

/* Related to Audio post processor for intern polyringer */
T_DSP_CMD_AUDIOPOSTPROC_PAR aud_dsp_audioproc;

/*---------------------------------------------*/
/* Internal data.                                                     */
/*---------------------------------------------*/
static UINT8 midi_player_state;  // midi player internal state
const UINT8 imelody2midi_volume[16] = { 0, 38, 42, 45, 49, 54, 59, 64, 70, 76, 83, 90, 99, 107, 117, 127};
T_DSP_CMD_MIDI    aud_dsp_midi;

MidiGetTotalTime_CallbackFunc GetTotalTimeCaB = NULL; /* add by zhouzhongyao */
MidiGetPlayPosition_CallbackFunc GetPlayPositionCaB = NULL;/* add by zhouzhongyao */
T_ZDrvMidi_CallbackFunc PlayEndCaB = NULL;/* add by zhouzhongyao */

//HISR setup for parsing midi data to next buffer - running while other buffer is being loaded into the DSP
STATUS AUD_ParseToNextMidiBuffer_status;

#if defined(__ARMCC_VERSION) /*rvct*/
__align(8) static CHAR AUD_ParseToNextMidiBuffer_stack[((500)+7)&0xFFFFFFF8];
#elif defined(__GNUC__) /* gcc */
__attribute__((aligned(8))) static CHAR AUD_ParseToNextMidiBuffer_stack[((500)+7)&0xFFFFFFF8];
#else
#error This file must be compiled in arm mode, either gcc or arm-rvct !!
#endif

static NU_HISR AUD_ParseToNextMidiBuffer_HISR;

rtt_timer_list_type* aud_rtt_timer_handle_midi; //used to download midi intrument bank to POAK

/* AC To be removed: */
UINT32 frame_error_sum = 0;
/*---------------------------------------------*/
/* Prototypes                              */
/*---------------------------------------------*/
static void ResumeMelody(UINT8 flag);
static void NormalizeMidiVolume(midi_conv_statics_t *p_conv_statics);
static void NormalizeImelodyVolume(imelody_conv_statics_t *p_imelody_conv_statics);
static void CheckMidiFile(huge UINT8 *pMidiFile, UINT32 file_size, UINT8 *pFormat, UINT8 *pNumOfTracks,
                          UINT16 *pDivision, midi_track_info_type *track_info, melody_conv_errors_enum* conv_error);
static huge UINT8 *ReadVarLen(SINT32 *p_len, huge UINT8 *p_var_len);
static void CalcStartIndex(midi_conv_statics_t *p_conv_statics);
static void SetTempo(midi_conv_statics_t *p_conv_statics, SINT32 tempo);
static void ConvertMidiFrame(midi_conv_statics_t *p_conv_statics,  UINT8 *p_frame_start);
static UINT8 EndOfMidiFileReached(midi_conv_statics_t *p_conv_statics);
static void UpdateDeltaTime(midi_conv_statics_t *p_conv_statics);
static void FillBufferWithMidiData(UINT16 *buff);
static void FillMidiPlayerBuffer(UINT16 *buff);
static void InitMidiConverter(midi_conv_statics_t *p_conv_statics);
static void ReInitMidiConverter(midi_conv_statics_t *p_conv_statics);
static void InitializeMidiParser(void);
static void InitializeImelodyParser(void);
static void InitImelodyConverter(imelody_conv_statics_t *p_imelody_conv_statics);
static void ReInitImelodyConverter(imelody_conv_statics_t *p_imelody_conv_statics);
static void InitImelodyCommands(imelody_conv_statics_t *p_imelody_conv_statics);
static void SetImelodyTempo(imelody_conv_statics_t *p_imelody_conv_statics, SINT16 beat);
static void CheckImelodyFile(huge UINT8 *p_imelody_data, UINT32 file_size, imelody_conv_statics_t *p_imelody_conv_statics,
                             melody_conv_errors_enum *conv_error);
static huge UINT8 * SkipLine(huge UINT8 *ptr);
static void ReadImelodyEvent(imelody_conv_statics_t *p_imelody_conv_statics);
static SINT16 ReadImelodyRepeat(imelody_conv_statics_t *p_imelody_conv_statics);
static void ReadImelodyVolume(imelody_conv_statics_t *p_imelody_conv_statics);
static void ReadImelodySilence(imelody_conv_statics_t *p_imelody_conv_statics);
static void ReadImelodyNote(imelody_conv_statics_t *p_imelody_conv_statics);
static SINT32 ConvertDuration_imy(SINT16 duration, UINT8 duration_specifier, UINT32 indeces_per_full_note);
static UINT8 ReadDurationSpecifier_imy(const huge UINT8 *c, huge UINT8 **ptr);
static SINT16 atoi_imy(const huge UINT8 *c, huge UINT8 **ptr);
static SINT16 strncmp_imy(const huge UINT8 *cs, const huge UINT8 *ct, UINT16 num, huge UINT8 **ptr);
static void ConvertImelodyFrame(imelody_conv_statics_t *p_imelody_conv_statics, UINT8 *p_frame_start);
static void FillBufferWithImelodyData(UINT16 *buff);
static void hstrncpy(SINT8 *p_dest, huge UINT8 *p_source, UINT16 num);
static void trig_vibra(UINT16 trig);
static void AUD_set_internal_midi_player_state(UINT8 new_state);
static void write_midi_data(void);
static void change_midi_headroom(void);
static void DspStartMidiPlayer(int mode);
static void DspStopMidiPlayer(void);
static void DriverStopMidiPlayer(void);
static void SuspendMelody(void);
static void StopSuspendMelody(void);
static UINT32 AUD_midi_get_play_position(void);
static UINT8 AUD_midi_set_play_position(UINT8 handle, UINT32 milli_second, aud_format_enum format);
static UINT32 aud_imelody_get_play_position(void);
static UINT8 aud_imelody_set_play_position(UINT32 milli_second);

static void InitializeMelodyParser(UINT8 event);
static void InitializeMidiPlayer(void);
void AUD_ParseToNextMidiBuffer(void);

/*---------------------------------------------*/
/* Audio post processor data                                         */
/*---------------------------------------------*/
//START: data for the audio post processor - should be made as const if Phonetool is not updated to support download of these parameters
static UINT16 update_audio_post_processor=0x0; //Set to 1 if post processor data below should be downloaded - only set this true if you know what you are doing !

UINT16  aud_mode=0x0;
UINT16  aud_b_exp=0x0;
UINT16  aud_b1=0x0;
UINT16  aud_b0=0x0;
UINT16  aud_a1=0x0;

UINT16  aud_INITDATA_mono_flag=0x0;
UINT16  aud_INITDATA_m_bufflen=0x0;
UINT16  aud_INITDATA_m_inv_bufflen=0x0;
UINT16  aud_INITDATA_m_hp_coef_exp=0x0;
UINT16  aud_INITDATA_m_lp1_coeff=0x0;
UINT16  aud_INITDATA_m_lp2_coeff=0x0;
UINT16  aud_INITDATA_m_lp3_coeff=0x0;
UINT16  aud_INITDATA_m_lp4_coeff=0x0;
UINT16  aud_INITDATA_m_L_A=0x0;
UINT16  aud_INITDATA_m_L_B=0x0;
UINT16  aud_INITDATA_m_G_comp=0x0;
UINT16  aud_INITDATA_um_infA=0x0;
UINT16  aud_INITDATA_um_R_AB=0x0;
UINT16  aud_INITDATA_um_R_B0=0x0;
//END : data for the audio post processor

/****************************************************************************************
* Function:... AudInternalMidiPlayerSM
* Description: The Internal Midi Player state machine
****************************************************************************************/
BOOL AudInternalMidiPlayerSM(aud_event_enum event, void* pData)
{
#ifdef AUD_MIDI_AUTO_RESUME_ON_IDLE
    UINT32 e_idle_restart_time; //used in auto restart for idle handling
#endif
    BOOL ret = TRUE;
    disp_to_SM_data_type *SM_data = (disp_to_SM_data_type*)pData; //contains the structure passed from the dispatcher
    UINT32 time_start = 0;
//    static BOOL bRamBufferUsed = FALSE;

    static UINT8 AUD_internal_midi_sm_execution_complete = TRUE;
#ifdef AUDIO_LLT
    //time_start=RTT_stm_get_time_10us_resolution(); //Get start time

    /* tracing: Send string : at+xl1set="l1 8l" To enable this LLT trace */
    if (SM_data != NULL)
        aud_common_trace(llt_group_audio, llt_type_audio_sm_internal_ringer, 11, 0,                // LLT params
                         'e', 0x01,                                               // LIS params
                         aud_log_lis_display, aud_log_lis_display_nodata, aud_log_llt_trace, // LIS params
                         (UINT32)time_start,
                         (UINT32)aud_get_SM_state(aud_resource_midi_player),
                         (UINT32)event,
                         (UINT32)SM_data->parm1,
                         (UINT32)SM_data->parm2,
                         (UINT32)SM_data->parm3,
                         (UINT32)SM_data->parm4,
                         (UINT32)SM_data->parm5,
                         (UINT32)SM_data->parm6,
                         (UINT32)SM_data->parm7,
                         (UINT32)E_audio_llt_type_id_0);
    else
        aud_common_trace(llt_group_audio, llt_type_audio_sm_internal_ringer, 4, 0,  // LLT params
                         'e', 0x01,                                               // LIS params
                         aud_log_lis_display, aud_log_lis_display_nodata, aud_log_llt_trace, // LIS params
                         (UINT32)time_start,
                         (UINT32)aud_get_SM_state(aud_resource_midi_player),
                         (UINT32)event,
                         (UINT32)E_audio_llt_type_id_1);
#endif

    /* Prevent simultaneous access of state machine */
    if (FALSE == AUD_internal_midi_sm_execution_complete)
    {
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Simultaneous access of internal MIDI state machine !!",FALSE)
        return FALSE;
    }

    AUD_internal_midi_sm_execution_complete = FALSE;

    switch (aud_get_SM_state(aud_resource_midi_player))
    {
            /*-------------------------------------------------------------------*/
            /*                           Idle state                              */
            /*-------------------------------------------------------------------*/
        case S_idle:
            switch (event)
            {
                case E_midi_start:
                case E_midi_start_user_melody:
                case E_midi_resume:
                    if (event == E_midi_resume)
                    {
                        aud_melody_suspend_array.AssignedSuspendSlot = (UINT8)((*SM_data).parm1);

                        if (aud_melody_suspend_array.MelodySlot[SM_data->parm1].melody_data==NULL)
                        {
                            aud_send_response_signal(SM_data->sender, aud_resource_ringer, aud_rc_suspend_resume_error, 0, 0, 0, 0, NULL, NULL);
                            if (PlayEndCaB != NULL)
                            {
                                (*PlayEndCaB)(MIDI_INFO_PLAY_ERR);
                            }
                            break;
                        }
                    }

                    if (event == E_midi_start)
                    {
                        UINT16 Melody_pointer = 0;
                        UINT16 Melody_id;
                        Melody_id=(UINT16)((*SM_data).parm1);

#if 0
//                        if (Melody_id != ringer_test_rambuff)       /*Checking whether the data is downloaded from PC to RamBuffer*/
                        {
                            for (Melody_pointer=0;;Melody_pointer++)
                                if (aud_smaf_melody_table[Melody_pointer].ringer_tone_enum>=aud_ringer_tone_id_end || /* Melody not available */
                                        aud_smaf_melody_table[Melody_pointer].ringer_tone_enum==Melody_id)
                                    break;
                        }
                        if (Melody_pointer>=aud_ringer_tone_id_end)
                        { //Melody is not avaliable
                            aud_send_response_signal(SM_data->sender, aud_resource_ringer, aud_rc_parameter_out_of_range, 0, 0, 0, 0, NULL, NULL);
                            break;
                        }

#endif
                        /*[Begin]no use [lvwenhua-2012/4/11]*/
                        #if 0
                        /* Check RamBuffer*/
                        if ((Melody_id == ringer_test_rambuff) && (gAudTestRamBuffer_Status == aud_testrambufferstatus_idle))
                        {
                            aud_glob_midi.melody_data     = gAudTestRamBuffer.ptrdata;
                            aud_glob_midi.melody_size      = gAudTestRamBuffer.size;
                            aud_glob_midi.format        = gAudTestRamBuffer.format;
                            aud_glob_midi.nof_repeats   = (UINT16)((*SM_data).parm2);
                            aud_glob_midi.sender        = ((*SM_data).sender);
                            gAudTestRamBuffer_Status = aud_testrambufferstatus_busy;
                            bRamBufferUsed = TRUE;
                        }
                        else
                        #endif
                        /*[End] [lvwenhua-2012/4/11]*/
                        /*[Begin]no use [lvwenhua-2013/8/16]*/
#if 0
                        {
                            aud_glob_midi.midi_pointer  = Melody_pointer;
                            aud_glob_midi.melody_data   = NULL;
                            aud_glob_midi.format        = aud_smaf_melody_table[Melody_pointer].format;
                            aud_glob_midi.nof_repeats   = (UINT16)((*SM_data).parm2);
                            aud_glob_midi.sender        = ((*SM_data).sender);
                        }
#endif
					/*[End] [lvwenhua-2012/4/11]*/
                    }

                    if (event == E_midi_start_user_melody)
                    {
                        aud_glob_midi.melody_data     = (huge UINT8*)((*SM_data).parm1);
                        aud_glob_midi.melody_size      = (UINT32)((*SM_data).parm2);
                        aud_glob_midi.format        = (aud_format_enum)((*SM_data).parm3);
                        aud_glob_midi.nof_repeats = (UINT16)((*SM_data).parm4);
                        aud_glob_midi.sender        = ((*SM_data).sender);
                        PlayEndCaB = (T_ZDrvMidi_CallbackFunc)((*SM_data).parm5);
                    }


                    //check if format is right
                    if (((aud_glob_midi.format !=aud_format_midi) && (aud_glob_midi.format !=aud_format_imelody)))
                    {
                        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_tone_error, aud_glob_midi.melody_conv_error, 0, 0, 0, NULL, NULL);
                        if (PlayEndCaB != NULL)
                        {
                            (*PlayEndCaB)(MIDI_INFO_PLAY_ERR);
                        }
                        AUD_internal_midi_sm_execution_complete = TRUE;
                        return(ret);
                    }
#ifdef DWD_VIB
                    VIB_trig(0); //make sure vibra (metronome function) is always off in idle
#endif
                    //update resume status and initialize midi/Imel parser = check file+prepare converter settings+vol. normalization
                    //No write buffer updates or anything towards FW
                    InitializeMelodyParser(event);

                    //check if there where errors in the file
                    if (aud_glob_midi.melody_conv_error)
                    {
                        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_tone_error, aud_glob_midi.melody_conv_error, 0, 0, 0, NULL, NULL);
                        AUD_internal_midi_sm_execution_complete = TRUE;
                        if (PlayEndCaB != NULL)
                        {
                            (*PlayEndCaB)(MIDI_INFO_FILE_INVALID);
                        }
                        return(ret);
                    }

                    aud_enable_path_and_resource(aud_resource_midi_player, S_active, TRUE);

                    //the playback will start - inform
                    aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_started, 0, 0, 0, 0, NULL, NULL);

                    /* store the total playtime - right here the melody-data-pointers are pointing at the start of the file so midi-id can be ignored */
                    aud_glob_midi.total_playtime = AUD_melody_get_total_playtime((aud_ringer_tone_id_enum)0, aud_glob_midi.melody_data, aud_glob_midi.melody_size, aud_glob_midi.format);

                    /* Do always switch off handsfree when starting internal midi - done when midi id for sure started */
                    //aud_dsp_hf_on_parms.mode = 0;  //Handsfree off!
                    //DSP_ASYNC_HF_ON(&aud_dsp_hf_on_parms);

                    //Setup the to write buffers (1 and 2) towards FW and fill buffer 1
                    InitializeMidiPlayer();

                    memset(&(p_l1d_sm_synth_data->synth_buffer), 0, MIDI_WORDS_PER_20MS_FRAME*sizeof(UINT16));
                    aud_glob_midi.data_buff_read_index=0;

                    write_midi_data();
                    AUD_set_internal_midi_player_state(S_midi_playing);

                    change_midi_headroom(); /* needed here */
                    DspStartMidiPlayer(2);

                    aud_dsp_midi.sample_rate_headroom = aud_int_poly_instrument_sample_rate; /* samle rate only set once here */
                    DspStartMidiPlayer(1);

                    /* set the head room used during playing */
                    change_midi_headroom();

                    break;

                case E_midi_suspend:
                    /* indicate error */
                    aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_no_playback, 0, 0, 0, 0, NULL, NULL);
                    if (PlayEndCaB != NULL)
                    {
                        (*PlayEndCaB)(MIDI_INFO_PLAY_ERR);
                    }
                    break;

                case E_midi_stop_suspend:
                    aud_melody_suspend_array.AssignedSuspendSlot = (UINT8)((*SM_data).parm1);
                    StopSuspendMelody();
                    aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_stopped, 0, 0, 0, AUD_STOPPED_BY_APP, NULL, NULL);
                    break;

                case E_midi_get_total_playtime:
                    {
                        UINT16 Melody_pointer;
                        UINT16 Melody_id;
                        Melody_id=(UINT16)((*SM_data).parm1);
#if 0
                        for (Melody_pointer=0;;Melody_pointer++)
                        {//Melody is not avaliable
                            if (aud_smaf_melody_table[Melody_pointer].ringer_tone_enum>=aud_ringer_tone_id_end)
                                break;
                            if (aud_smaf_melody_table[Melody_pointer].ringer_tone_enum==Melody_id)
                                break;
                        }
#endif

                        if (Melody_pointer>=aud_ringer_tone_id_end)
                        { //Melody is not avaliable
                            aud_send_response_signal(SM_data->sender, aud_resource_ringer, aud_rc_parameter_out_of_range,
                                                     0, 0, 0, 0, NULL, NULL);
                            if (PlayEndCaB != NULL)
                            {
                                (*PlayEndCaB)(MIDI_INFO_PLAY_ERR);
                            }
                            break;
                        }

                        aud_glob_midi.midi_pointer =  Melody_pointer;
                        aud_glob_midi.melody_data = (huge UINT8*)((*SM_data).parm2);
                        aud_glob_midi.melody_size = (UINT32)((*SM_data).parm3);
                        aud_glob_midi.format = (aud_format_enum)((*SM_data).parm4);
                        GetTotalTimeCaB = (MidiGetTotalTime_CallbackFunc)((*SM_data).parm5); /* add by zhouzhongyao */

                        if (aud_glob_midi.melody_data != NULL)
                        {
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_total_playtime,
                                                     AUD_melody_get_total_playtime((aud_ringer_tone_id_enum)0, aud_glob_midi.melody_data, aud_glob_midi.melody_size, aud_glob_midi.format),
                                                     0, 0, 0, NULL, NULL);
                            if (GetTotalTimeCaB != NULL)
                            {
                                (*GetTotalTimeCaB)(AUD_melody_get_total_playtime((aud_ringer_tone_id_enum)0, aud_glob_midi.melody_data, aud_glob_midi.melody_size, aud_glob_midi.format));
                            }
                        }
                        else
                        {
                        #if 0
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_total_playtime,
                                                     AUD_melody_get_total_playtime(aud_smaf_melody_table[aud_glob_midi.midi_pointer].ringer_tone_enum, NULL, 0, aud_glob_midi.format),
                                                     0, 0, 0, NULL, NULL);
                            (*GetTotalTimeCaB)(0);
                            if (PlayEndCaB != NULL)
                            {
                                (*PlayEndCaB)(MIDI_INFO_FILE_INVALID);
                            }
						#endif
                        }
                    }
                    break;

                case E_midi_get_play_position:
                    GetPlayPositionCaB = (MidiGetPlayPosition_CallbackFunc)((*SM_data).parm1); /* add by zhouzhongyao */
                    aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_no_playback,
                                             0, 0, 0, 0, NULL, NULL);
                    (*GetPlayPositionCaB)(0);
                    break;

                case E_midi_set_play_position:
                    //just set the postion - can not overwrite aud_glob_midi.data !
                    if (aud_glob_midi.format == aud_format_midi)
                        AUD_midi_set_play_position(0, (UINT32)((*SM_data).parm2), (aud_format_enum)0);
                    else if (aud_glob_midi.format == aud_format_imelody)
                        (void)aud_imelody_set_play_position((UINT32)((*SM_data).parm2));
                    break;

                case E_idle_command:
                case E_midi_release_stop:
                case E_midi_stop:
                case E_midi_data_copy:
                    break;       /* Ignore */

                default:
                    ret = FALSE;
                    break;
            }
            break;

            /*-------------------------------------------------------------------*/
            /*                          Active state                             */
            /*-------------------------------------------------------------------*/
        case S_active:
            {
                switch (event)
                {
                    case E_midi_start:
                    case E_midi_start_user_melody:
                    case E_midi_resume:
                        //Do not allow start/start sequence
                        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_request_error, 0, 0, 0, 0, NULL, NULL);
                        if (PlayEndCaB != NULL)
                        {
                            (*PlayEndCaB)(MIDI_INFO_PLAY_ERR);
                        }
                        break;

                    case E_midi_release_stop:
                    case E_midi_stop:
                        DspStopMidiPlayer();
#ifdef IFWD_AUD_NEW_RC_PARAMETER
                        //decide which return code to send
                        if (AUD_get_internal_midi_player_state()==S_midi_waiting_to_close) //melody played to the end
                        {
                            if (aud_glob_midi.format == aud_format_imelody)
                                aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_finish, aud_imelody_get_play_position(), aud_glob_midi.imelody_conv_statics.frames_passed, 0, 0, NULL, NULL);
                            else if (aud_glob_midi.format == aud_format_midi)
                                aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_finish, AUD_midi_get_play_position(), aud_glob_midi.midi_conv_statics.frames_passed, 0, 0, NULL, NULL);
                        }
                        else //a stop was requested
                        {
                            if (aud_glob_midi.format == aud_format_imelody)
                                aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_stopped, aud_imelody_get_play_position(), aud_glob_midi.imelody_conv_statics.frames_passed, 0, AUD_STOPPED_BY_APP, NULL, NULL);
                            else if (aud_glob_midi.format == aud_format_midi)
                                aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_stopped, AUD_midi_get_play_position(), aud_glob_midi.midi_conv_statics.frames_passed, 0, AUD_STOPPED_BY_APP, NULL, NULL);
                        }
#else
                        //decide which return code to send
                        if (AUD_get_internal_midi_player_state()==S_midi_waiting_to_close) //melody played to the end
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_finish, 0, 0, 0, 0, NULL, NULL);
                        else //a stop was requested
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_stopped, 0, 0, 0, AUD_STOPPED_BY_APP, NULL, NULL);
#endif
                        // Driver stopped after responsesignal as state is changed in DriverStopMidiPlayer
                        DriverStopMidiPlayer();

                        /*[Begin]no use [lvwenhua-2012/4/11]*/
                        #if 0
                        /* Change the rambuffer status if the data is used from RamBuffer */
                        if ((bRamBufferUsed == TRUE) && (gAudTestRamBuffer_Status == aud_testrambufferstatus_busy))
                        {
                            gAudTestRamBuffer_Status = aud_testrambufferstatus_idle;
                            bRamBufferUsed = FALSE;
                        }
                        #endif
                        /*[End] [lvwenhua-2012/4/11]*/

                        break;

                    case E_midi_suspend:
                        aud_melody_suspend_array.AssignedSuspendSlot = (UINT8)((*SM_data).parm1);

                        DspStopMidiPlayer();
                        SuspendMelody();
                        DriverStopMidiPlayer();
#ifdef IFWD_AUD_NEW_RC_PARAMETER
                        if (aud_glob_midi.format == aud_format_imelody)
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_suspended, aud_imelody_get_play_position(), aud_glob_midi.imelody_conv_statics.frames_passed, 0, 0, NULL, NULL);
                        else if (aud_glob_midi.format == aud_format_midi)
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_suspended, AUD_midi_get_play_position(), aud_glob_midi.midi_conv_statics.frames_passed, 0, 0, NULL, NULL);

#else
                        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_suspended, 0, 0, 0, 0, NULL, NULL);
#endif
                        break;

                    case E_midi_stop_suspend:
                        aud_melody_suspend_array.AssignedSuspendSlot = (UINT8)((*SM_data).parm1);
                        StopSuspendMelody();
                        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_stopped, 0, 0, 0, AUD_STOPPED_BY_APP, NULL, NULL);
                        break;

                    case E_midi_get_play_position:
                        GetPlayPositionCaB = (MidiGetPlayPosition_CallbackFunc)((*SM_data).parm1); /* add by zhouzhongyao */
#ifdef IFWD_AUD_NEW_RC_PARAMETER
                        if (aud_glob_midi.format == aud_format_midi)
                        {
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_elapsed_time,
                                                     AUD_midi_get_play_position(), aud_glob_midi.midi_conv_statics.frames_passed, 0, 0, NULL, NULL);
                            if (GetPlayPositionCaB!=NULL && aud_glob_midi.midi_conv_statics.skip_status != melody_skip_status_on)
                            {
                                (*GetPlayPositionCaB)(AUD_midi_get_play_position());
				                 GetPlayPositionCaB = NULL;	
                            }
                        }
                        else if (aud_glob_midi.format == aud_format_imelody)
                        {
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_elapsed_time,
                                                     aud_imelody_get_play_position(), aud_glob_midi.imelody_conv_statics.frames_passed, 0, 0, NULL, NULL);
				 if (GetPlayPositionCaB!=NULL && aud_glob_midi.imelody_conv_statics.skip_status != melody_skip_status_on)
                            {
                                (*GetPlayPositionCaB)(aud_imelody_get_play_position());
				                 GetPlayPositionCaB = NULL;	
                            }			

		          }
#else
                        if (aud_glob_midi.format == aud_format_midi)
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_elapsed_time,
                                                     AUD_midi_get_play_position(), 0, 0, 0, NULL, NULL);
                        else if (aud_glob_midi.format == aud_format_imelody)
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_elapsed_time,
                                                     aud_imelody_get_play_position(), 0, 0, 0, NULL, NULL);

#endif
                        break;

                    case E_midi_set_play_position:
                        //check if set pos is longer than actual length of active melody playing - can not be done if no melody is playing (we do NOT know
                        //the melody which will be played later on).
                        if ((UINT32)((disp_to_SM_data_type*) SM_data->parm2) > aud_glob_midi.total_playtime)
                        { //total playtime is as default calculated during start of playback
                            DriverStopMidiPlayer();
                            aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_unknown_position, 0, 0, 0, AUD_STOPPED_BY_DRV, NULL, NULL);
                            if (PlayEndCaB != NULL)
                            {
                                (*PlayEndCaB)(MIDI_INFO_PLAY_ERR);
                            }
                        }
                        else
                        {
                            if (aud_glob_midi.format == aud_format_midi)
                                //just set the postion - can not overwrite aud_glob_midi.data !
                                AUD_midi_set_play_position(0, (UINT32)((*SM_data).parm2), (aud_format_enum)0);
                            else if (aud_glob_midi.format == aud_format_imelody)
                                aud_imelody_set_play_position((UINT32)((*SM_data).parm2));
                        }
                        break;
                        // if idle command is received during playing - "restart" OR "stop and reset player. Inform upper layer".
                    case E_idle_command:
#ifdef AUD_MIDI_AUTO_RESUME_ON_IDLE
                        // first stop
                        e_idle_restart_time=AUD_midi_get_play_position();
                        AUD_set_internal_midi_player_state(S_midi_idle);
                        aud_glob_midi.data_buff_status=data_buff_status_idle;

                        //start
                        InitializeMidiPlayer();
                        AUD_midi_set_play_position(0,e_idle_restart_time,aud_glob_midi.format);

                        memset(&(p_l1d_sm_synth_data->synth_buffer), 0, MIDI_WORDS_PER_20MS_FRAME*sizeof(UINT16));

                        write_midi_data();
                        AUD_set_internal_midi_player_state(S_midi_playing);

                        change_midi_headroom(); /* needed here */
                        DspStartMidiPlayer(2);

                        aud_dsp_midi.sample_rate_headroom = aud_int_poly_instrument_sample_rate; /* samle rate only set once here */
                        DspStartMidiPlayer(1);

                        /* set the head room used during playing */
                        change_midi_headroom();
#else //Auto resume is not enabled
                        DriverStopMidiPlayer();
                        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_tone_error, 0, 0, 0, 0, NULL, NULL);
                        //aud_enable_standby(aud_resource_midi_player);
#endif //AUD_MIDI_AUTO_RESUME_ON_IDLE
                        break;

                        //Events there must be ignored
                    case E_midi_get_total_playtime:
                        GetTotalTimeCaB = (MidiGetTotalTime_CallbackFunc)((*SM_data).parm5); /* add by zhouzhongyao */
                        if (SM_data->parm2 != 0)
                        {
                            aud_send_response_signal(SM_data->sender, aud_resource_midi_player, aud_rc_total_playtime,
                                                     AUD_melody_get_total_playtime((aud_ringer_tone_id_enum)0,
                                                                                   (UINT8 huge *)SM_data->parm2, SM_data->parm3,
                                                                                   (aud_format_enum)SM_data->parm4), 0, 0, 0, NULL, NULL);
                            if (GetTotalTimeCaB!=NULL)
                            {
                                (*GetTotalTimeCaB)(AUD_melody_get_total_playtime((aud_ringer_tone_id_enum)0, aud_glob_midi.melody_data, aud_glob_midi.melody_size, aud_glob_midi.format));
                            }
                        }
                        else
                        {
                            aud_send_response_signal(SM_data->sender, aud_resource_midi_player, aud_rc_total_playtime,
                                                     AUD_melody_get_total_playtime((aud_ringer_tone_id_enum)SM_data ->parm1,
                                                                                   NULL, 0,(aud_format_enum)((*SM_data).parm2)), 0, 0, 0, NULL, NULL);
                            (*GetTotalTimeCaB)(0);
                            if (PlayEndCaB != NULL)
                            {
                                (*PlayEndCaB)(MIDI_INFO_FILE_INVALID);
                            }
                        }
                        break;

                    case E_midi_data_copy:
                        /*------------------------------------*/
                        /* Start copying midi next frame data to the -*/
                        /* internal buffer in Audio process context      */
                        /*------------------------------------*/
                        AUD_ParseToNextMidiBuffer();
                        break;


                    default:
                        ret = FALSE;
                        break;
                }
            }
            break;
        default:
            ret = FALSE; /*wrong state*/
            break;
    }
    AUD_internal_midi_sm_execution_complete = TRUE;
    return ret;
}

/****************************************************************************************
* Function:... InitMidi
* Description:
****************************************************************************************/
void InitMidi(void)
{
    UINT8 i;
    AUD_set_internal_midi_player_state(S_midi_idle);
    for (i=0; i<AUD_NOF_SUSPENDNEST; i++)
        aud_melody_suspend_array.MelodySlot[i].melody_data=NULL;

    aud_dsp_midi.mode = 0;
    aud_dsp_midi.sample_rate_headroom   = 1;
    aud_dsp_midi.midi_data_shared_mem_address = (word)((UINT32)(&p_l1d_sm_synth_data->synth_buffer) -(UINT32)BASEADR_COM_INT)>>1;  // Offset of SM location, where the 65 words are copied to.
    aud_glob_midi.total_playtime = 0;

    //Create HISR for parsing midi data to next buffer - running while other buffer is being loaded into the DSP
    //AUD_ParseToNextMidiBuffer_status=NU_Create_HISR(&AUD_ParseToNextMidiBuffer_HISR, "AUD_ParseToNextMidiBuffer", AUD_ParseToNextMidiBuffer, 2, AUD_ParseToNextMidiBuffer_stack, 500);
//  if(AUD_ParseToNextMidiBuffer_status!=NU_SUCCESS)
}

/****************************************************************************************
* Function:... DspStartMidiPlayer
* Description:
****************************************************************************************/
static void DspStartMidiPlayer(int mode)
{
    /*lint -e40*/
    /*lint -e63*/
    aud_dsp_midi.mode = mode;
#ifdef STEON2_PROJECT
    if (mode == 1)
    {
        if (aud_get_hw_src_allocation()==aud_hw_src_no_usage)
        {
            aud_set_hw_src_allocation(aud_hw_src_MIDI);
            aud_dsp_midi.sample_rate_headroom = aud_hw_src_MIDI;
        }
        else
        {
            aud_dsp_midi.sample_rate_headroom = aud_get_hw_src_allocation();
        }
    }
#endif
    DSP_ASYNC_MIDI(&aud_dsp_midi);
    /*lint restore*/
    /*lint restore*/
}

/****************************************************************************************
* Function:... DspStopMidiPlayer
* Description:
****************************************************************************************/
static void DspStopMidiPlayer(void)
{
    aud_dsp_midi.mode = 0;
#ifdef STEON2_PROJECT
    if (aud_get_hw_src_allocation()==aud_hw_src_MIDI)
    {
        aud_set_hw_src_allocation(aud_hw_src_no_usage);
        aud_dsp_midi.sample_rate_headroom = aud_hw_src_no_usage;
    }
#endif
    DSP_ASYNC_MIDI(&aud_dsp_midi);
    //reset the skip status to default values, re-playback will be started from the begining
    //unless MMI set the play position again.
    aud_glob_midi.imelody_conv_statics.skip_status = melody_skip_status_off;
    aud_glob_midi.midi_conv_statics.skip_status = melody_skip_status_off;
}

/****************************************************************************************
* Function:... DriverStopMidiPlayer
* Description:
****************************************************************************************/
static void DriverStopMidiPlayer(void)
{
    aud_glob_midi.data_buff_status=data_buff_status_idle;
    AUD_set_internal_midi_player_state(S_midi_idle);
    aud_disable_path_and_resource(aud_resource_midi_player, S_idle, TRUE);

    /* restore handsfree */
    //if (aud_get_SM_state(aud_resource_speech) ==S_active)
    //    aud_ear_dsp_start_hands_free(aud_path_settings_result.aud_audio_uplink_parms.hf->hf_algorithm_restart);
}

/****************************************************************************************
* Function:... AUD_HandleMidiPlayerTimeout
* Description: Triggered by DSP interrupt every 20ms.
*                   Overall control of midi data towards DSP and command control towards DSP
*                   HISR context
****************************************************************************************/
void AUD_HandleMidiPlayerTimeout(void)
{
    /* Se midi machine e' in IDLE non fare nulla */
    /* Se midi machine e' waiting to start ... controlla se fn = 0 ed allora falla partire */
    /* Se e' partita ogni 20 ms carica 65 words dal buffer0 e incrementa il contatore interno.
        una volta arrivato alla fine del buffer ... scambia i buffers ed attiva il player */
#ifdef AUD_HISR_TIMER_MEASUREMENT
    UINT32 time_end;
    static UINT32 max_time=200;
#endif

#if defined(AUDIO_LLT) || defined(AUD_HISR_TIMER_MEASUREMENT)
    UINT32 time_start;
    //time_start=RTT_stm_get_time_10us_resolution(); //Get start time
#endif

#ifdef AUDIO_LLT
    /* Send string : at+xl1set="l1 26l" To enable this LLT trace */
    aud_common_trace(llt_group_audio, llt_type_audio_hisr_internal_ringer, 2, 0,                // LLT params
                     'e', 0x01,                                               // LIS params
                     aud_log_lis_raw_data, aud_log_lis_display_data, aud_log_llt_trace, // LIS params
                     (UINT32) time_start,
                     (UINT32) AUD_get_internal_midi_player_state());
#endif // AUDIO_LLT

    switch (AUD_get_internal_midi_player_state())
    {
        case S_midi_playing:
        case S_midi_waiting_to_close:
            //The SM is very close to stopping the playback if aud_dsp_midi.mode==0.
            if (aud_dsp_midi.mode!=0)
            {
                write_midi_data();
                DspStartMidiPlayer(2);
            }
            break;
        case S_midi_idle:
        case S_midi_waiting_to_start:
        default:
            break;
    }

#ifdef AUD_HISR_TIMER_MEASUREMENT
    //time_end= RTT_stm_get_time_10us_resolution();

    //check for wrap around of STM timer - happen app. each 5.8 hours
    if (time_start>time_end)
    {
        time_end=0xFFFFFFFF-(time_start-time_end); //store result in time_end - 32bit counter
        time_start=0;   // do not mess up reading out of result later
    }

    if ((time_end-time_start)>=max_time)
    { //if time spend is beyond 2ms (200*10us) - notify
        max_time=time_end-time_start; //store the maximum time
        /* Send string : at+xl1set="l22 6|" To enable this LLT trace */
        aud_common_trace(llt_group_audio2, llt_type_audio_timing_measurement, 5, 0,   // LLT params
                         'e', 0x01,                                               // LIS params
                         aud_log_lis_display, aud_log_lis_display_nodata, aud_log_llt_trace, // LIS params
                         (UINT32) time_start,
                         (UINT32) max_time,
                         (UINT32) AUD_get_internal_midi_player_state(),
                         (UINT32) aud_resource_midi_player,
                         (UINT32) E_audio_llt_type_id_0);
    }
#endif
}

/****************************************************************************************
* Function:... InitializeMelodyParser
* Description:
****************************************************************************************/
static void InitializeMelodyParser(UINT8 event)
{
    ResumeMelody((event==E_midi_resume)); //if event is resuem, the global stores will be re-loaded. Else resume state will be set to off.

    if (aud_glob_midi.format == aud_format_midi)
        InitializeMidiParser(); //find melody data and size (if not given by application).Check file and load data into converter stores + normalize volume.
    else if (aud_glob_midi.format == aud_format_imelody)
        InitializeImelodyParser();
}

/****************************************************************************************
* Function:... ResumeMelody
* Description:
****************************************************************************************/
static void ResumeMelody(UINT8 flag)
{
    UINT8 sl = aud_melody_suspend_array.AssignedSuspendSlot;

    if (flag==FALSE || aud_glob_midi.midi_conv_statics.skip_status != melody_skip_status_off
            || aud_glob_midi.imelody_conv_statics.skip_status != melody_skip_status_off)
    {
        aud_glob_midi.midi_conv_statics.resume = melody_resume_status_off;
        aud_glob_midi.imelody_conv_statics.resume =melody_resume_status_off;
    }
    else
    {
        aud_glob_midi.melody_data = aud_melody_suspend_array.MelodySlot[sl].melody_data;
        aud_glob_midi.melody_size = aud_melody_suspend_array.MelodySlot[sl].melody_size;
        aud_glob_midi.format = aud_melody_suspend_array.MelodySlot[sl].format;
        aud_glob_midi.nof_repeats = aud_melody_suspend_array.MelodySlot[sl].nof_repeats;
        aud_glob_midi.caller_id= aud_melody_suspend_array.MelodySlot[sl].caller_id;
        aud_glob_midi.sender = aud_melody_suspend_array.MelodySlot[sl].sender;

        if (aud_glob_midi.format == aud_format_midi)
        {
            aud_glob_midi.midi_conv_statics.n_event_resume = aud_melody_suspend_array.MelodySlot[sl].n_event_processed;
            aud_glob_midi.midi_conv_statics.resume = melody_resume_status_on;
            //restore the playposition
            aud_glob_midi.midi_conv_statics.frames_passed = aud_melody_suspend_array.MelodySlot[sl].frames_passed;

        }
        else if (aud_glob_midi.format == aud_format_imelody)
        {
            aud_glob_midi.imelody_conv_statics.n_event_resume = aud_melody_suspend_array.MelodySlot[sl].n_event_processed;
            aud_glob_midi.imelody_conv_statics.resume = melody_resume_status_on;
            //restore the playposition
            aud_glob_midi.imelody_conv_statics.frames_passed = aud_melody_suspend_array.MelodySlot[sl].frames_passed;

        }

        aud_melody_suspend_array.MelodySlot[sl].melody_data = NULL;
    }
}

/****************************************************************************************
* Function:... InitializeMidiPlayer
* Description:
****************************************************************************************/
static void InitializeMidiPlayer(void)
{
    static UINT16 buff1[MIDI_BUFF_SIZE];
    static UINT16 buff2[MIDI_BUFF_SIZE];

    memset(buff1, 0,sizeof(buff1));
    memset(buff2, 0,sizeof(buff2));

    /* fill first buffer */
    FillMidiPlayerBuffer(buff1);

    /* The second buffer will be filled run-time: this will keep auto-closing time to 1 buffer length */
    aud_glob_midi.data_buff_read = (UINT16 *)buff1;
    aud_glob_midi.data_buff_write = (UINT16 *)buff2;
    AUD_set_internal_midi_player_state(S_midi_waiting_to_start);
}

/****************************************************************************************
* Function:... write_midi_data
* Description:  Load FW with new 20ms midi frame - HISR context
****************************************************************************************/
static void write_midi_data(void)
{
    UINT16  *ptr_read;
    UINT16 *p_exchange;

    // pick out Metronome and use vibra - bit 1 in Synth_par_out
#ifdef DWD_VIB
    trig_vibra((UINT16)(p_l1d_synth_par_out_data->flag) & 0x02);   //use this in SGold2 and newer
#endif

    //load one 20ms midi frame to DSP
    ptr_read = aud_glob_midi.data_buff_read + (aud_glob_midi.data_buff_read_index * MIDI_WORDS_PER_20MS_FRAME);
    memcpy(&(p_l1d_sm_synth_data->synth_buffer), ptr_read, MIDI_WORDS_PER_20MS_FRAME*sizeof(UINT16)); //SGOLD2 and onwards
    aud_glob_midi.data_buff_read_index++;

    //start to prepare next buffer
    if (aud_glob_midi.data_buff_read_index == 1) //write first frame of one buffer => start preparing next buffer
    {
        //NU_Activate_HISR(&AUD_ParseToNextMidiBuffer_HISR);
        aud_send_mail(E_midi_data_copy, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL);
    }

    //end of current buffer reached ?
    if (aud_glob_midi.data_buff_read_index == MIDI_NUM_20MS_FRAMES_BUFFERIZED)
    {
        if (AUD_get_internal_midi_player_state() == S_midi_waiting_to_close) //stop when the current buffer is fully written (contains from 1-5 valid frames.Rest are 0's)
        {
            AudInternalMidiPlayerSM(E_midi_stop, NULL);
        }
        else
        {
            if ((aud_glob_midi.data_buff_status==data_buff_status_fill)||
                    (aud_glob_midi.data_buff_status==data_buff_status_busy))
            {
                // error condition parser has not finished its job in time
                // wait 20ms without doing anything, i.e. repeat previous frame index and substitute data with 0's
                aud_glob_midi.data_buff_read_index--;
                memset(ptr_read, 0, MIDI_WORDS_PER_20MS_FRAME*sizeof(UINT16));
            }
            else
            {
                //switch pointers to read/write buffers - during next interrupt the process for parsing will be restarted.
                p_exchange = aud_glob_midi.data_buff_read;
                aud_glob_midi.data_buff_read = aud_glob_midi.data_buff_write;
                aud_glob_midi.data_buff_write =  p_exchange;
                aud_glob_midi.data_buff_read_index = 0;
            }
        }
    }
}


/****************************************************************************************
* Function:... AUD_ParseToNextMidiBuffer
* Description: Fill next buffer with the wanted number of midi frames if needed - HISR context
****************************************************************************************/
void AUD_ParseToNextMidiBuffer(void)
{
    //midi file was parsed to the end during previous run, check for this status
    if (aud_glob_midi.data_buff_status == data_buff_status_eof)
    {
        AUD_set_internal_midi_player_state(S_midi_waiting_to_close); //indicate that current buffer should be "played" to the end and then stop
        if (PlayEndCaB != NULL)
        {
            (*PlayEndCaB)(MIDI_INFO_PLAY_END);
        }
    }
    else
    {
        //start parsing midi file to fill the next buffer
        aud_glob_midi.data_buff_status = data_buff_status_fill;

        if (aud_glob_midi.data_buff_status==data_buff_status_fill)
        {
            aud_glob_midi.data_buff_status =   data_buff_status_busy;

            FillMidiPlayerBuffer(aud_glob_midi.data_buff_write);

            if (aud_glob_midi.data_buff_status==data_buff_status_busy)
                aud_glob_midi.data_buff_status=data_buff_status_ready;
        }
    }
}


/****************************************************************************************
* Function:... SuspendMelody
* Description:
****************************************************************************************/
static void SuspendMelody(void)
{
    UINT8 sl = aud_melody_suspend_array.AssignedSuspendSlot;
    aud_melody_suspend_array.MelodySlot[sl].melody_data = aud_glob_midi.melody_data;
    aud_melody_suspend_array.MelodySlot[sl].format = aud_glob_midi.format;
    aud_melody_suspend_array.MelodySlot[sl].melody_size = aud_glob_midi.melody_size;
    aud_melody_suspend_array.MelodySlot[sl].nof_repeats = aud_glob_midi.nof_repeats;
    aud_melody_suspend_array.MelodySlot[sl].caller_id = aud_glob_midi.caller_id;
    aud_melody_suspend_array.MelodySlot[sl].sender = aud_glob_midi.sender;
    if (aud_glob_midi.format==aud_format_midi)
    {
        aud_melody_suspend_array.MelodySlot[sl].n_event_processed = aud_glob_midi.midi_conv_statics.n_event_processed;
        //store the play position
        aud_melody_suspend_array.MelodySlot[sl].frames_passed = aud_glob_midi.midi_conv_statics.frames_passed;
    }
    else if (aud_glob_midi.format==aud_format_imelody)
    {
        aud_melody_suspend_array.MelodySlot[sl].n_event_processed = aud_glob_midi.imelody_conv_statics.n_event_processed;
        //store the play position
        aud_melody_suspend_array.MelodySlot[sl].frames_passed = aud_glob_midi.imelody_conv_statics.frames_passed;
    }
}

/****************************************************************************************
* Function:... StopSuspendMelody
* Description:
****************************************************************************************/
static void StopSuspendMelody(void)
{
    UINT8 sl = aud_melody_suspend_array.AssignedSuspendSlot;
    aud_melody_suspend_array.MelodySlot[sl].melody_data = NULL;
}

/****************************************************************************************
* Function:... change_midi_headroom
* Description:
****************************************************************************************/
static void change_midi_headroom(void)
{
    /* the other parameters use the default value */
    if (aud_glob_midi.format == aud_format_midi)
        aud_dsp_midi.sample_rate_headroom = 3;
    else if (aud_glob_midi.format == aud_format_imelody)
        aud_dsp_midi.sample_rate_headroom = 0;
}

/****************************************************************************************
* Function:... InitializeMidiParser
* Description:
****************************************************************************************/
static void InitializeMidiParser(void)
{
	#if 0
    if (aud_glob_midi.melody_data==NULL)
    {
        aud_glob_midi.melody_data = aud_smaf_melody_table[aud_glob_midi.midi_pointer].melody_ptr;
        aud_glob_midi.melody_size = aud_smaf_melody_table[aud_glob_midi.midi_pointer].size;
    }
	#endif
    /* check midi file and initialize converter */
    aud_glob_midi.melody_conv_error = melody_error_none;

    //Check header+track chunks + load track data info - start and stop pointers etc.
    CheckMidiFile(aud_glob_midi.melody_data, aud_glob_midi.melody_size, &aud_glob_midi.midi_conv_statics.format,
                  &aud_glob_midi.midi_conv_statics.number_of_tracks, &aud_glob_midi.midi_conv_statics.division,
                  &aud_glob_midi.midi_conv_statics.track_info[0], &aud_glob_midi.melody_conv_error);

    if (aud_glob_midi.melody_conv_error)
        return;

    InitMidiConverter(&(aud_glob_midi.midi_conv_statics));
    NormalizeMidiVolume(&(aud_glob_midi.midi_conv_statics));

    aud_glob_midi.melody_conv_error = melody_error_none;
}

/****************************************************************************************
* Function:... InitializeImelodyParser
* Description:
****************************************************************************************/
static void InitializeImelodyParser(void)
{
	#if 0
	if (aud_glob_midi.melody_data==NULL)
    {
        aud_glob_midi.melody_data = aud_smaf_melody_table[aud_glob_midi.midi_pointer].melody_ptr;
        aud_glob_midi.melody_size = aud_smaf_melody_table[aud_glob_midi.midi_pointer].size;
    }
	#endif
    aud_glob_midi.melody_conv_error =melody_error_none;
    InitImelodyConverter(&(aud_glob_midi.imelody_conv_statics));
    CheckImelodyFile(aud_glob_midi.melody_data, aud_glob_midi.melody_size, &aud_glob_midi.imelody_conv_statics, &aud_glob_midi.melody_conv_error);
    if (aud_glob_midi.melody_conv_error)
        return;
    NormalizeImelodyVolume(&(aud_glob_midi.imelody_conv_statics));
    InitImelodyCommands(&(aud_glob_midi.imelody_conv_statics));
    aud_glob_midi.melody_conv_error = melody_error_none;
}

/****************************************************************************************
* Function:... CheckMidiFile
* Description: Checks header chunk. Loops thorugh all track chunks (not event track 0) checks them and loads
*                    all track data info (pointer to p_track_start, p_track_stop) and removes EndOfTrack MetaEvent.
*                   track 0 is added and will be used as the virtual event track => increase the track number with +1
****************************************************************************************/
static void CheckMidiFile(huge UINT8 *pMidiFile, UINT32 file_size, UINT8 *pFormat, UINT8 *pNumOfTracks,
                          UINT16 *pDivision, midi_track_info_type *track_info, melody_conv_errors_enum* conv_error)
{
    int i, j;
    UINT32 Buffer;
    huge UINT8 *p_midi_data=pMidiFile;
    SINT8 StringBuf[5];
    UINT32 bytesParsed;
    huge UINT8 *ptr;

    if (file_size<14)
    {
        *conv_error = midi_error_file_empty;
        return ;
    }

    /* read file header */
    for (i=0; i<4; i++)
        StringBuf[i] = *p_midi_data++;

    StringBuf[4] = '\0';

    /* check Header */
    if (strcmp((char *)StringBuf, "MThd") != 0)
    {
        *conv_error = midi_error_invalid_header;
        return ;
    }

    /* check header length */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    if (Buffer != 6)
    {
        *conv_error = midi_error_invalid_header;
        return ;
    }

    /* check format */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    if (Buffer > 1)
    {
        *conv_error = midi_error_invalid_format;
        return ;
    }
    *pFormat = Buffer;

    /* check ntrks */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    /* Save number of tracks (add converter event track - virtual track not from midi file. Kept as track 0) */
    *pNumOfTracks = (unsigned char)(Buffer+1);
    if ((*pFormat==0)&&(Buffer != 1))
    {
        *conv_error = midi_error_invalid_tracks_number;
        return ;
    }
    else if (*pNumOfTracks>MIDI_MAX_NUM_OF_TRACKS)
        *pNumOfTracks = MIDI_MAX_NUM_OF_TRACKS + 1;

    /* read division */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    *pDivision = Buffer;

    /* check division (only metrical time supported) */
    if (Buffer & 0x8000)
    {
        *conv_error = midi_error_invalid_division;
        return;
    }
    bytesParsed = 14;

    //  loop through all tracks (in midi file) - starting from track 1. Ignoring virtual event track 0
    for (i=1; i< *pNumOfTracks; i++)
    {
        if ((bytesParsed+8)>file_size)
        {
            *conv_error = midi_error_file_truncated;
            return ;
        }

        /* read track header */
        for (j=0; j<4; j++)
            StringBuf[j] = *p_midi_data++;

        /* read track length */
        Buffer = *p_midi_data++;
        Buffer<<=8, Buffer |= *p_midi_data++;
        Buffer<<=8, Buffer |= *p_midi_data++;
        Buffer<<=8, Buffer |= *p_midi_data++;

        if ((bytesParsed+8+Buffer)>file_size)
        {
            *conv_error = midi_error_file_truncated;
            return ;
        }

        /* check track header */
        if (strcmp((char *)StringBuf, "MTrk") != 0)
        {
            p_midi_data+=Buffer;
            i--;
            (*pNumOfTracks)--;
        }
        else
        {
            track_info[i].p_track_start = p_midi_data;
            track_info[i].p_track_data = p_midi_data;
            ptr = p_midi_data + Buffer; /* point to end of current track - buffer contains current track length */
            if ((*(ptr-3)==0xFF)&&(*(ptr-2)==0x2F)&&(*(ptr-1)==0x00)) /* remove the last metaevent EndOfTrack if present*/
                track_info[i].p_track_end = ptr-3;
            else
                track_info[i].p_track_end = ptr;
            track_info[i].track_ended=0; /* flag indicating track has not ended */
            p_midi_data+=Buffer; /* point to beginning of nexst track */
        }
        bytesParsed += 8+Buffer; /* indicate that this track has been parsed-> 8(track chunk fixed length) + actual length of track */
    }
}

/****************************************************************************************
* Function:... InitMidiConverter
* Description: Load all internal settings for the converter.
*                   Sets up the event converter track
*                   Preloads the first delta time event for all midi tracks (from midi file)
****************************************************************************************/
static void InitMidiConverter(midi_conv_statics_t *p_conv_statics)
{
    UINT8 i;
    SINT32 delta_time;

    /* set default tempo (120BPM = 500000) */
    SetTempo(p_conv_statics, 500000);

    p_conv_statics->calc_index = 0;
    p_conv_statics->write_index = 0;
    p_conv_statics->n_bytes2write = 0;
    p_conv_statics->n_event_processed = 0;
    p_conv_statics->n_noteonoff_processed = 0;

    /* Init MIDI normalization (default: off) */
    p_conv_statics->norm_flag = 0;

    /* Init converter event track */
    p_conv_statics->track_info[0].track_ended = 0;
    p_conv_statics->track_info[0].p_track_start = p_conv_statics->conv_event_buffer;
    p_conv_statics->track_info[0].p_track_data = p_conv_statics->conv_event_buffer;
    p_conv_statics->track_info[0].p_track_end = p_conv_statics->conv_event_buffer + CONV_EVENT_BUFFER_SIZE;
    p_conv_statics->track_info[0].last_status = 0;

    /* Init MIDI clock distance in ticks: 24 MIDI clocks per quarter note */
    p_conv_statics->midi_clock_delta_time_max = p_conv_statics->division / 24;

    /* Init bar marker distance in ticks: default time signature: 4/4
         ==> barmarker shall be sent all 4 * division ticks */
    p_conv_statics->bar_marker_delta_time_max = p_conv_statics->division * 4;

    /* Init first generator event: send MIDI clock immediately */
    p_conv_statics->conv_event_buffer[0] = 0xF8;
    p_conv_statics->track_info[0].delta_time = 0;

    /* Update delta times for next converter event(s): MIDI clock and bar marker.
        Ensure that bar marker is sent just before associated timing clock. */
    p_conv_statics->midi_clock_delta_time = p_conv_statics->midi_clock_delta_time_max;
    p_conv_statics->bar_marker_delta_time = p_conv_statics->bar_marker_delta_time_max - 1;

    /* Read delta times for first event on all MIDI file tracks - right after each track chunck length field */
    for (i=1; i<p_conv_statics->number_of_tracks; i++)
    {
        p_conv_statics->track_info[i].last_status=0;
        p_conv_statics->track_info[i].p_track_data=ReadVarLen(&delta_time, p_conv_statics->track_info[i].p_track_start);
        p_conv_statics->track_info[i].delta_time = delta_time;

        if (p_conv_statics->track_info[i].p_track_data >= p_conv_statics->track_info[i].p_track_end)
            p_conv_statics->track_info[i].track_ended=1;
        else
            p_conv_statics->track_info[i].track_ended=0;

    }
    /* start with a reset */
    p_conv_statics->reset = TRUE;
    p_conv_statics->BankSelectMSB.write_flag= 0;
    p_conv_statics->BankSelectLSB.write_flag = 0;
    p_conv_statics->ModulationDepthMSB.write_flag= 0;
    p_conv_statics->ModulationDepthLSB.write_flag = 0;
    p_conv_statics->ChannelVolumeMSB.write_flag= 0;
    p_conv_statics->ChannelVolumeLSB.write_flag = 0;
    p_conv_statics->PanMSB.write_flag= 0;
    p_conv_statics->PanLSB.write_flag = 0;
    p_conv_statics->ExpressionMSB.write_flag= 0;
    p_conv_statics->ExpressionLSB.write_flag = 0;
    p_conv_statics->ProgramChange.write_flag= 0;
    p_conv_statics->PitchBendChange.write_flag = 0;

    /* 2006-10-11, needn't reset to 0 in case of resume*/
    if (aud_glob_midi.midi_conv_statics.resume == melody_resume_status_off)
    {
        aud_glob_midi.midi_conv_statics.frames_passed = 0;
    }

    CalcStartIndex(p_conv_statics);
}

/****************************************************************************************
* Function:... ReInitMidiConverter
* Description:
****************************************************************************************/
static void ReInitMidiConverter(midi_conv_statics_t *p_conv_statics)
{
    UINT8 i;

    for (i=0; i<p_conv_statics->number_of_tracks; i++)
        p_conv_statics->track_info[i].p_track_data = p_conv_statics->track_info[i].p_track_start;

    InitMidiConverter(&(aud_glob_midi.midi_conv_statics));
    /*2005-03-17, michael, do normalization again before repeat */
    NormalizeMidiVolume(&(aud_glob_midi.midi_conv_statics));
}

/****************************************************************************************
* Function:... NormalizeMidiVolume
* Description: Scan tracks and find maximum volume, key pressure
****************************************************************************************/
void NormalizeMidiVolume(midi_conv_statics_t *p_conv_statics)
{
    UINT8 i;
    huge UINT8 *p_track_data;
    SINT32 tmp32; //after
    UINT8 last_status;
    UINT8 max_velocity = 0;
    UINT8 max_volume = 0;
    unsigned char max_expression = 0;
    /* Flag field for active channels (= channel with Note On CMD) */
    UINT16 active_channel_flags = 0;
    /* Flag field for channels with no Channel Volume CMD */
    UINT16 novol_channel_flags = 0xFFFFu;
    /* Flag field for channels with no Expression CMD */
    UINT16 noexp_channel_flags = 0xFFFFu;

    for (i=1; i < p_conv_statics->number_of_tracks; i++)
    {
        p_track_data = p_conv_statics->track_info[i].p_track_data;

        last_status = 0;

        while (1)
        {
            if (*p_track_data >= 0x80) /* read new status byte */
                last_status = *p_track_data++;

            /* get number of bytes which will follow */
            switch (last_status & 0xF0)
            {
                case (0x90):
                                /* Note ON */
                                if (*(p_track_data+1) != 0)
                        {
                            max_velocity = MAX(max_velocity, *(p_track_data+1));
                            /* Save flag info (add channel to list of active channels) */
                            active_channel_flags |= ((UINT16)1 << (last_status & 0x0F));
                        }
                    p_track_data+=2;
                    break;

                case (0xB0):
                                /* ControlChange : 2 Data Byte follows */
                                if (*p_track_data==0x07)
                        {
                            max_volume = MAX(max_volume, *(p_track_data+1));
                            /* Save flag info (delete channel from list of channels without Channel Volume CMD) */
                            novol_channel_flags &= ~(1 << (last_status & 0x0F));
                        }
                        else if (*p_track_data==0x0B)
                        {
                            /* Expression */
                            max_expression = MAX(max_expression, *(p_track_data+1));

                            /* Save flag info (delete channel from list of channels without Expression CMD) */
                            noexp_channel_flags &= ~(1 << (last_status & 0x0F));
                        }
                    p_track_data += 2;
                    break;

                case (0xC0):  /* Program Change : 1 Data Byte follows */
                            case (0xD0):  /* Channel Pressure: 1 Data Byte follows */
                                    p_track_data++;
                    break;

                default:
                    /* All other Messages have 2 Data Bytes */
                    p_track_data += 2;
                    break;

                case (0xF0):
                                /* System Message, has to be further distinguished */
                                switch (last_status)
                        {
                            case(0xF0):
                                        case(0xF7):
                                                /* System Exclusive: Number of bytes to write has to be decoded from length word */
                                                p_track_data = ReadVarLen(&tmp32, p_track_data);
                                p_track_data += tmp32;
                                break;

                            case(0xF1):
                                        case(0xF3):
                                                /* MIDI Time Code or Song Select: 1 Data Byte follows, will be ignored */
                                                p_track_data++;
                                break;

                            case(0xF2):
                                            /* Song Position Pointer: 2 Data Bytes follow, will be ignored */
                                            p_track_data += 2;
                                break;

                            case(0xFF):
                                            /* Meta Event*/
                                            if (*p_track_data++==0x2F)
                                    {
                                        p_track_data = p_conv_statics->track_info[i].p_track_end;
                                        break;
                                    }
                                /* All the Meta Events will be skipped; get length
                                   and adjust input pointer accordingly */
                                p_track_data = ReadVarLen(&tmp32, p_track_data);
                                p_track_data += tmp32;
                                break;

                            default:
                                /* All other Messages have 0 Data Bytes, will be ignored */
                                break;
                        }
                    break;
            }

            /* check for end of track */
            if (p_track_data < p_conv_statics->track_info[i].p_track_end)
                p_track_data = ReadVarLen(&tmp32, p_track_data); /* skip delta time */
            else /* go to next track */
                break;
        }
    }

    /* Save all active channels without Channel Volume CMDs in statics struct (needed for the correction
       of the default volume setting on these channels after initialization and GM reset commands) */
    p_conv_statics->vol_corr_flags = active_channel_flags & novol_channel_flags;

    /* Check for active channels without a Channel Volume CMD */
    if (p_conv_statics->vol_corr_flags)
    {
        /* Increase max. Volume found to at least 100 (as this is the default channel volume) */
        if (max_volume < 100)
            max_volume = 100;
    }

    /* Check for active channels without an Expression CMD */
    if (active_channel_flags & noexp_channel_flags)
        max_expression = 127; /* Increase max. Expression found to 127 (as this is the default expression) */

    /* update normalization values (only if found values are within valid range) */
    if (max_volume <= 127)
        p_conv_statics->delta_volume = 127 - max_volume;
    else
        p_conv_statics->delta_volume = 0;

    if (max_velocity <= 127)
        p_conv_statics->delta_velocity = 127 - max_velocity;
    else
        p_conv_statics->delta_velocity = 0;

    if (max_expression <= 127)
        p_conv_statics->delta_expression = 127 - max_expression;
    else
        p_conv_statics->delta_expression = 0;

    /* Prepare sending of (normalized) Channel Volume commands on all active channels without a Channel Volume CMD */
    if (p_conv_statics->vol_corr_flags)
    {
        UINT8 channel=0;

        /* Replace first converter event (Timing Clock) by Channel Volume message */
        p_conv_statics->midi_clock_delta_time = 0;

        /* get first channel to send CMD on */
        while (((p_conv_statics->vol_corr_flags) & (1 << channel)) == 0)
            channel++;

        /* Prepare Channel Volume message in converter event buffer */
        p_conv_statics->conv_event_buffer[0] = (0xB0 | channel);
        p_conv_statics->conv_event_buffer[1] = 0x07;
        /* Volume = 100 in buffer, will get normalized in ConvertMidiFrame() */
        p_conv_statics->conv_event_buffer[2] = 100;
    }

    /* Set normalization flag */
    p_conv_statics->norm_flag = 1;
}

/****************************************************************************************
* Function:... FillMidiPlayerBuffer
* Description: Fill the buffer indicated in parameter. Loop through nof frames (20ms) buffered.
****************************************************************************************/
static void FillMidiPlayerBuffer(UINT16 *buff)
{
    UINT8 i;

    memset(buff, 0, MIDI_BUFF_SIZE*sizeof(UINT16));

    for (i=0; i<MIDI_NUM_20MS_FRAMES_BUFFERIZED; i++)
    {
        if (aud_glob_midi.format==aud_format_midi)
            FillBufferWithMidiData((UINT16*)&buff[i*MIDI_WORDS_PER_20MS_FRAME]); //index into buffer - use complete frames
        else if (aud_glob_midi.format==aud_format_imelody)
            FillBufferWithImelodyData((UINT16*)&buff[i*MIDI_WORDS_PER_20MS_FRAME]); //index into buffer - use complete frames
    }
    if (aud_glob_midi.data_buff_status != data_buff_status_eof)
        aud_glob_midi.data_buff_status = data_buff_status_ready;
}

/****************************************************************************************
* Function:... FillBufferWithMidiData
* Description:
****************************************************************************************/
static void FillBufferWithMidiData(UINT16 *buff)
{
    ConvertMidiFrame(&aud_glob_midi.midi_conv_statics, (UINT8*)buff);
    if ((EndOfMidiFileReached(&aud_glob_midi.midi_conv_statics)) && ((aud_glob_midi.nof_repeats==0) || (aud_glob_midi.nof_repeats>1)))
    {
        if (aud_glob_midi.nof_repeats>1)
            aud_glob_midi.nof_repeats--;
        ReInitMidiConverter(&(aud_glob_midi.midi_conv_statics));

        /* send indication that playing the repeated melody is finished */
        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_loop, 0, (UINT32) aud_format_midi, aud_glob_midi.nof_repeats, 0, NULL, NULL);
    }
    else if (EndOfMidiFileReached(&aud_glob_midi.midi_conv_statics))
    {
        aud_glob_midi.data_buff_status = data_buff_status_eof;
        /* reset frames_passed to 0 */
        aud_glob_midi.midi_conv_statics.frames_passed = 0;
    }
    else if (aud_glob_midi.midi_conv_statics.skip_status == melody_skip_status_off)
    {
        /* accumulate the frames having been passed */
        aud_glob_midi.midi_conv_statics.frames_passed++;
    }
}

/*??FUNB**********************************************************************
* NAME   :  EndOfMidiFileReached
* INPUT  :  p_conv_statics        pointer to converter static memory.
* DESCR. :  Indicate if we reached the end of file.
***********************************************************************??FUNE*/
static UINT8 EndOfMidiFileReached(midi_conv_statics_t *p_conv_statics)
{
    UINT8 i;
    UINT8 eot;

    eot = TRUE;
    for (i=1; i<p_conv_statics->number_of_tracks; i++)
        eot = eot && p_conv_statics->track_info[i].track_ended;

    return eot;
}

/****************************************************************************************
* Function:... ConvertMidiFrame
* Description:
****************************************************************************************/
static void ConvertMidiFrame(midi_conv_statics_t *p_conv_statics,  UINT8 *p_frame_start)
{
    UINT8 *p_work = p_frame_start;
    UINT8 *p_frame_end = p_frame_start + FRAME_SIZE;
    huge UINT8 *p_track_data;
    SINT8 write_flag;
    SINT32 byte_counter;
    UINT8 channel;
    UINT16 resume_item;
    /* clear the current MIDI-Frame (fill with zeros) - which we are going to fill later */
    /* Needed on the S-Gold. Since the last interrupt under certain conditions else will send faulty data to the dsp */
    /* resulting in audible noise */
    while (p_work < p_frame_end)
        *p_work++ = 0;
    p_work = p_frame_start;

    /* if reset flag is set */
    if (p_conv_statics->reset)
    {
        p_conv_statics->reset=FALSE;
        *p_work++ = 0xF0;
        *p_work++ = 0x7E;
        *p_work++ = 0x7F;
        *p_work++ = 0x09;
        *p_work++ = 0x01;
        *p_work++ = 0xF7;
        /* 2004-0119, after reset, the write_index should be updated */
        p_conv_statics->write_index += 6;
    }


    /* ********** check if there are some bytes left to write from an event which started in the last frame ********** */
    byte_counter = p_conv_statics->n_bytes2write;
    if (byte_counter)
    {
        p_track_data = p_conv_statics->track_info[p_conv_statics->active_track].p_track_data;

        /* write out all values */
        do
        {
            /* check if end of output frame reached */
            if (p_work >= p_frame_end)
            {
                /* go to next frame */
                p_conv_statics->write_index = 0;
                p_conv_statics->calc_index -= CALC_INDEX_LIMIT;
                p_conv_statics->n_bytes2write = byte_counter;
                p_conv_statics->track_info[p_conv_statics->active_track].p_track_data=p_track_data;
                return;
            }
            *p_work++ = *p_track_data++;
            byte_counter--;
        }
        while (byte_counter);

        /* update write index and number of bytes to write */
        p_conv_statics->write_index = p_work - p_frame_start;
        p_conv_statics->n_bytes2write = 0;
        p_conv_statics->track_info[p_conv_statics->active_track].p_track_data=p_track_data;

        UpdateDeltaTime(p_conv_statics);
        if (EndOfMidiFileReached(p_conv_statics))
            return;

        /* get start index for next event */
        CalcStartIndex(p_conv_statics);
    }


    /* ********** loop over all events for the current frame ********** */
    for (;;)
    {
        // **********are we resuming or skipping events ? - handle last event which has to be written to synth
        while (p_conv_statics->resume==melody_resume_status_on_final || p_conv_statics->skip_status == melody_skip_status_on_final)
        {
            /* write out all values to midi buffer, latest actual state for the midi status is written
            - variabel resume_status_index starts a value 0 and is incremented +1 after each run through resume_items */

            //loop through all resume_items 16 times (for each midi channel)
            // resume_status_index=0-15  =>  resume_item=0
            // resume_status_index=16-31  =>  resume_item=1 etc.
            resume_item = (p_conv_statics->resume_status_index)>>4;

            //find current midi channel number - use lower 4 bit "counter" to identify one of 16 midi channels
            channel = p_conv_statics->resume_status_index & 0x0F;
            switch (resume_item)
            {
                case 0:
                    if (p_conv_statics->BankSelectMSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 0;
                        *p_work++ = p_conv_statics->BankSelectMSB.value[channel];
                    }
                    break;
                case 1:
                    if (p_conv_statics->BankSelectLSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 32;
                        *p_work++ = p_conv_statics->BankSelectLSB.value[channel];
                    }
                    break;
                case 2:
                    if (p_conv_statics->ProgramChange.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xC0 | channel;
                        *p_work++ = p_conv_statics->ProgramChange.value[channel];
                    }
                    break;
                case 3:
                    if (p_conv_statics->PitchBendChange.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xE0 | channel;
                        *p_work++ = p_conv_statics->PitchBendChange.value1[channel];
                        *p_work++ = p_conv_statics->PitchBendChange.value2[channel];
                    }
                    break;
                case 4:
                    if (p_conv_statics->ModulationDepthMSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 1;
                        *p_work++ = p_conv_statics->ModulationDepthMSB.value[channel];
                    }
                    break;
                case 5:
                    if (p_conv_statics->ModulationDepthLSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 33;
                        *p_work++ = p_conv_statics->ModulationDepthLSB.value[channel];
                    }
                    break;
                case 6:
                    if (p_conv_statics->ChannelVolumeMSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 7;
                        *p_work++ = p_conv_statics->ChannelVolumeMSB.value[channel];
                    }
                    break;
                case 7:
                    if (p_conv_statics->ChannelVolumeLSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 39;
                        *p_work++ = p_conv_statics->ChannelVolumeLSB.value[channel];
                    }
                    break;
                case 8:
                    if (p_conv_statics->PanMSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 10;
                        *p_work++ = p_conv_statics->PanMSB.value[channel];
                    }
                    break;
                case 9:
                    if (p_conv_statics->PanLSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 42;
                        *p_work++ = p_conv_statics->PanLSB.value[channel];
                    }
                    break;
                case 10:
                    if (p_conv_statics->ExpressionMSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 11;
                        *p_work++ = p_conv_statics->ExpressionMSB.value[channel];
                    }
                    break;
                case 11:
                    if (p_conv_statics->ExpressionLSB.write_flag & (1<<channel))
                    {
                        *p_work++ = 0xB0 | channel;
                        *p_work++ = 43;
                        *p_work++ = p_conv_statics->ExpressionLSB.value[channel];
                    }
                    break;
            }
            p_conv_statics->resume_status_index++; //another single channel for an event has been handled
            if (p_conv_statics->resume_status_index == MIDI_RESUME_STATUS_ITEMS)
            {
                p_conv_statics->resume=melody_resume_status_off;
                p_conv_statics->skip_status = melody_skip_status_off;
            }
            /* check if end of output frame reached */
            if (p_work >= p_frame_end)
            {
                /* go to next frame */
                p_conv_statics->write_index = 0;
                return;
            }
            /* update write index and number of bytes to write */
            p_conv_statics->write_index = p_work - p_frame_start;
        }


        // ********** start "normal" midi event processing - individual checks for resume or skipping in each event
        p_track_data = p_conv_statics->track_info[p_conv_statics->active_track].p_track_data;

        /* check if start index is in current frame */
        if (p_conv_statics->write_index < WRITE_INDEX_LIMIT)
        {
            /* next event starts in current frame; set default value for write flag (all events will be written) */
            write_flag = 1;

            /* update frame pointer to next write position - this pointer works in the buffers to wrtie to FW*/
            p_work = p_frame_start + p_conv_statics->write_index;

            /* get status byte (if present, else use running status) */
            if (*p_track_data >= 0x80)
            {
                /* read new status byte */
                p_conv_statics->track_info[p_conv_statics->active_track].last_status = *p_track_data++;
            }
            channel = p_conv_statics->track_info[p_conv_statics->active_track].last_status & 0x0F;

            /* get number of bytes which will follow */
            switch ((p_conv_statics->track_info[p_conv_statics->active_track].last_status) & 0xF0)
            {
                case (0x80):
                            case (0x90):
                                case (0xA0):
                                        /* Note ON, Note OFF, Note Aftertouch */
                                        /* if resuming p_track_data+=2; and write_flag = 0; else */
                                        if (p_conv_statics->resume!=melody_resume_status_off || p_conv_statics->skip_status != melody_skip_status_off)
                                {
                                    p_track_data+=2;
                                    write_flag = 0;
                                }
                                else
                                {
                                    byte_counter = 2;
                                }
                    p_conv_statics->n_noteonoff_processed++;
                    break;

                case (0xB0):
                                /* ControlChange : 2 Data Byte follows */
                                //if resuming or skipping, update internal stores. last update send to FW synth when fast chasing is done.
                                if (p_conv_statics->resume!=melody_resume_status_off || p_conv_statics->skip_status != melody_skip_status_off)
                        {
                            switch (*p_track_data)
                            {
                                case 0:         /* Bank Select MSB */
                                    p_conv_statics->BankSelectMSB.write_flag|= 1<<channel;
                                    p_conv_statics->BankSelectMSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 32:       /* Bank Select LSB */
                                    p_conv_statics->BankSelectLSB.write_flag|= 1<<channel;
                                    p_conv_statics->BankSelectLSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 1:         /* Modulation Depth MSB */
                                    p_conv_statics->ModulationDepthMSB.write_flag|= 1<<channel;
                                    p_conv_statics->ModulationDepthMSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 33:       /* Modulation Depth LSB */
                                    p_conv_statics->ModulationDepthLSB.write_flag|= 1<<channel;
                                    p_conv_statics->ModulationDepthLSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 7:         /* Channel Volume MSB */
                                    p_conv_statics->ChannelVolumeMSB.write_flag|= 1<<channel;
                                    p_conv_statics->ChannelVolumeMSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 39:       /* Channel Volume LSB */
                                    p_conv_statics->ChannelVolumeLSB.write_flag|= 1<<channel;
                                    p_conv_statics->ChannelVolumeLSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 10:       /* Pan MSB */
                                    p_conv_statics->PanMSB.write_flag|= 1<<channel;
                                    p_conv_statics->PanMSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 42:       /* Pan LSB */
                                    p_conv_statics->PanLSB.write_flag|= 1<<channel;
                                    p_conv_statics->PanLSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 11:       /* Expression MSB */
                                    p_conv_statics->ExpressionMSB.write_flag|= 1<<channel;
                                    p_conv_statics->ExpressionMSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 43:       /* Expression LSB */
                                    p_conv_statics->ExpressionLSB.write_flag|= 1<<channel;
                                    p_conv_statics->ExpressionLSB.value[channel] = *(p_track_data+1);
                                    p_track_data += 2;
                                    write_flag = 0;
                                    break;
                                case 121:       /* Reset All controllers */
                                    //write event directly to FW device
                                    byte_counter = 2;
                                    //remove stored info for the specific channel
                                    p_conv_statics->ModulationDepthMSB.write_flag&=~(1<<channel);
                                    p_conv_statics->ModulationDepthLSB.write_flag &=~(1<<channel);
                                    ;
                                    p_conv_statics->ChannelVolumeMSB.write_flag&=~(1<<channel);
                                    p_conv_statics->ChannelVolumeLSB.write_flag &=~(1<<channel);
                                    p_conv_statics->PanMSB.write_flag &=~(1<<channel);
                                    p_conv_statics->PanLSB.write_flag &=~(1<<channel);
                                    p_conv_statics->ExpressionMSB.write_flag&=~(1<<channel);
                                    p_conv_statics->ExpressionLSB.write_flag &=~(1<<channel);
                                    break;

                                default:
                                    byte_counter = 2;
                                    break;
                            }
                        }
                        else
                        { //normal transfer to FW synth
                            byte_counter = 2;
                        }
                    break;

                case (0xC0):
                                /* Program Change : 1 Data Byte follows */
                                if (p_conv_statics->resume!=melody_resume_status_off || p_conv_statics->skip_status != melody_skip_status_off)
                        {
                            p_conv_statics->ProgramChange.write_flag|= 1<<channel;
                            p_conv_statics->ProgramChange.value[channel] = *p_track_data++;
                            write_flag = 0;
                        }
                        else
                        {
                            byte_counter = 1;
                        }
                    break;

                case (0xD0):
                                /* Channel Pressure: 1 Data Byte follows */
                                if (p_conv_statics->resume!=melody_resume_status_off || p_conv_statics->skip_status != melody_skip_status_off)
                        {
                            p_track_data+=1;
                            write_flag = 0;
                        }
                        else
                        {
                            byte_counter = 1;
                        }
                    break;

                case(0xE0):
                                /* Pitch bend change */
                                if (p_conv_statics->resume!=melody_resume_status_off || p_conv_statics->skip_status != melody_skip_status_off)
                        {
                            p_conv_statics->PitchBendChange.write_flag|= 1<<channel;
                            p_conv_statics->PitchBendChange.value1[channel] = *p_track_data++;
                            p_conv_statics->PitchBendChange.value2[channel] = *p_track_data++;
                            write_flag = 0;
                        }
                        else
                        {
                            byte_counter = 2;
                        }
                    break;

                default:
                    /* All other Messages have 2 Data Bytes */
                    byte_counter = 2;
                    break;

                case (0xF0):
                                /* System Message, has to be further distinguished */
                                switch (p_conv_statics->track_info[p_conv_statics->active_track].last_status)
                        {

                            case (0xF8):
                                            /* Timing clock (converter-generated), no Data Byte follows */
                                            byte_counter = 0;
                                break;

                            case (0xF0):
                                        case (0xF7):
                                                /* System Exclusive: Number of bytes to write has to be decoded from length word */
                                                p_track_data = ReadVarLen(&byte_counter, p_track_data);

                                /* Check, if MIDI normalization is active and if there are active channels without Channel Volume CMDs */
                                if ((p_conv_statics->norm_flag) && (p_conv_statics->vol_corr_flags))
                        {
                                    /* Check for GM reset commands (GM1/2 System On) */
                                    if ((p_track_data[0] == 0x7E) &&
                                            (p_track_data[1] == 0x7F) &&
                                            (p_track_data[2] == 0x09) &&
                                            ((p_track_data[3] == 0x01) || (p_track_data[3] == 0x03)))
                                    {
                                        UINT8 channel = 0;

                                        /* Replace current converter event by a Channel Volume message */
                                        if (p_conv_statics->conv_event_buffer[0] == 0xF8)
                                        {
                                            /* Replace Timing Clock */
                                            p_conv_statics->midi_clock_delta_time = p_conv_statics->track_info[0].delta_time -
                                                                                    p_conv_statics->track_info[p_conv_statics->active_track].delta_time;
                                            p_conv_statics->bar_marker_delta_time += p_conv_statics->midi_clock_delta_time;
                                        }
                                        else
                                        {
                                            /* Replace Bar Marker */
                                            p_conv_statics->bar_marker_delta_time = p_conv_statics->track_info[0].delta_time -
                                                                                    p_conv_statics->track_info[p_conv_statics->active_track].delta_time;
                                            p_conv_statics->midi_clock_delta_time += p_conv_statics->bar_marker_delta_time;
                                        }
                                        /* get first channel to send CMD on */
                                        while (((p_conv_statics->vol_corr_flags) & (1 << channel)) == 0)
                                            channel++;

                                        /* Prepare Channel Volume message in converter event buffer */
                                        p_conv_statics->conv_event_buffer[0] = (0xB0 | channel);
                                        p_conv_statics->conv_event_buffer[1] = 0x07;
                                        /* Volume = 100 in buffer, will get normalized in ConvertMidiFrame() */
                                        p_conv_statics->conv_event_buffer[2] = 100;

                                        /* make sure that the first Channel Volume message will be sent immediately - handled in CalcStartIndex(...) */
                                        p_conv_statics->track_info[0].delta_time = p_conv_statics->track_info[p_conv_statics->active_track].delta_time;
                                    }
                                }

                                /* 2004-10-26, michael, take into account all the messages supported by
                                 *the IFX synthesiser.
                                 */
                                if (p_track_data[0]==0x7f)
                                {
                                    /* real time message */
                                    /* mip message */
                                    if ((p_track_data[2]==0x0B) && (p_track_data[3]==0x01))
                                    {
                                        /* mip message */
                                        write_flag = 1;
                                    }
                                    else if ((p_track_data[2]==0x03) && (p_track_data[3]==0x02))
                                    {
                                        /* Master Volume */
                                        write_flag = 1;
                                    }
                                    else if ((p_track_data[2]==0x04) && ((p_track_data[3]==0x01) ||(p_track_data[3]==0x02)))
                                    {
                                        /* Notation Information: Bar Number and Time Signature (Immediate) */
                                        write_flag = 1;
                                    }
                                    else
                                    {
                                        /* unsupported real time messages */
                                        p_track_data += byte_counter;
                                        write_flag = 0;
                                    }
                                }
                                else if (p_track_data[0]==0x7E)
                                {
                                    /* Non-Real Time */
                                    if ((p_track_data[1] == 0x7F) &&(p_track_data[2] == 0x09) &&
                                            ((p_track_data[3] == 0x01) || (p_track_data[3] == 0x03)))
                                    {
                                        /* GM1/2 System On Message */
                                        write_flag = 1;
                                    }
                                    else
                                    {
                                        /* unsupported non-real time messages */
                                        p_track_data += byte_counter;
                                        write_flag = 0;
                                    }
                                }
                                else
                                {
                                    /* unsupported system exclusive messages */
                                    p_track_data += byte_counter;
                                    write_flag = 0;
                                }
                                break;

                            case(0xF1):
                                        case(0xF3):
                                                /* MIDI Time Code or Song Select: 1 Data Byte follows, will be ignored */
                                                p_track_data++;
                                write_flag = 0;
                                break;

                            case(0xF2):
                                            /* Song Position Pointer: 2 Data Bytes follow, will be ignored */
                                            p_track_data += 2;
                                write_flag = 0;
                                break;

                            default:
                                /* All other Messages have 0 Data Bytes, will be ignored */
                                write_flag = 0;
                                break;

                            case(0xFF):
                                            /* Meta Event, has to be distinguished further */
                                            switch (*p_track_data++)
                                    {
                                        case(0x51):
                                                        /* Set Tempo event: get tempo and restore input track pointer */
                                                        p_track_data++; /* skip legth (only 1 byte for set tempo) */
                                            byte_counter = *p_track_data++;
                                            byte_counter <<= 8;
                                            byte_counter |= *p_track_data++;
                                            byte_counter <<= 8;
                                            byte_counter |= *p_track_data, p_track_data-=3;

                                            /* change tempo setting */
                                            SetTempo(p_conv_statics, byte_counter);
                                            break;

                                        case(0x58):
                                                        /* Time signature: transform into time signature immediate SysEx message
                                                          and update bar marker spacing */
                                                        p_track_data++; /* skip length (fixed to 4) */

                                            /* adjust timing for converter event which will be repaced by time signature message:
                                               check if timing clock is active (bar marker will be updated anyway) */
                                            if (p_conv_statics->conv_event_buffer[0] == 0xF8)
                                    {
                                                p_conv_statics->midi_clock_delta_time = p_conv_statics->track_info[0].delta_time -
                                                                                        p_conv_statics->track_info[p_conv_statics->active_track].delta_time;
                                            }

                                            /* Prepare SysEx message in converter event buffer */
                                            p_conv_statics->conv_event_buffer[0] = 0xF0;
                                            p_conv_statics->conv_event_buffer[1] = 0x0A;
                                            p_conv_statics->conv_event_buffer[2] = 0x7F;
                                            p_conv_statics->conv_event_buffer[3] = 0x7F;
                                            p_conv_statics->conv_event_buffer[4] = 0x03;
                                            p_conv_statics->conv_event_buffer[5] = 0x02;
                                            p_conv_statics->conv_event_buffer[6] = 0x04;
                                            p_conv_statics->conv_event_buffer[7] = *p_track_data++; //copy the data from midi track
                                            p_conv_statics->conv_event_buffer[8] = *p_track_data++;
                                            p_conv_statics->conv_event_buffer[9] = *p_track_data++;
                                            p_conv_statics->conv_event_buffer[10] = *p_track_data, p_track_data-=4; //copay last byte from midi track and reposition pointer to the events length indication
                                            p_conv_statics->conv_event_buffer[11] = 0xF7; //write end of SysEx message

                                            /* update bar marker spacing/timing:
                                              spacing in ticks = (division * nn * 4)/2^dd */
                                            p_conv_statics->bar_marker_delta_time_max =
                                                (p_conv_statics->division * p_conv_statics->conv_event_buffer[7] * 4) /
                                                (1 << p_conv_statics->conv_event_buffer[8]);
                                            /* ensure that next bar marker is sent before the corresponding midi clock */
                                            p_conv_statics->bar_marker_delta_time = p_conv_statics->bar_marker_delta_time_max - 1;

                                            /* make sure that time signature will be sent next - handled in CalcStartIndex(...) */
                                            p_conv_statics->track_info[0].delta_time = p_conv_statics->track_info[p_conv_statics->active_track].delta_time;
                                            break;

                                        case(0x2F):
                                                        /* End of Track: */
                                                        p_conv_statics->track_info[p_conv_statics->active_track].track_ended=1;
                                            break;
                                    }

                                /* None of the  Meta Events will be transmitted; get length
                                   and adjust input pointer accordingly */
                                write_flag = 0;
                                if (!p_conv_statics->track_info[p_conv_statics->active_track].track_ended)
                        {
                                    p_track_data = ReadVarLen(&byte_counter, p_track_data);//get length of Meta Event to skip
                                    p_track_data += byte_counter; //point to next event
                                }
                                break;
                        }
                    break;
            }

            /* write event to output frame buffer only if it has not been omitted */
            if (write_flag)
            {
                /* write status byte, no check of frame limit necessary as status byte can always be written (because of extension word) */
                *p_work++ = p_conv_statics->track_info[p_conv_statics->active_track].last_status;

                /* write data bytes (if any) */
                while (byte_counter)
                {
                    /* check if end of output frame reached */
                    if (p_work >= p_frame_end)
                    {
                        /* go to next frame */
                        p_conv_statics->write_index = 0;
                        p_conv_statics->calc_index -= CALC_INDEX_LIMIT;
                        p_conv_statics->n_bytes2write = byte_counter;
                        p_conv_statics->track_info[p_conv_statics->active_track].p_track_data=p_track_data;
                        return ;
                    }
                    *p_work++ = *p_track_data++;
                    byte_counter--;
                }

                /* do volume normalization if necessary */
                if (p_conv_statics->norm_flag)
                {
                    if ((p_conv_statics->track_info[p_conv_statics->active_track].last_status & 0xF0) == 0x90) //check if it note on event
                    {
                        if (*(p_work-1) != 0x00)
                        {
                            /* Note On */
                            *(p_work-1) += p_conv_statics->delta_velocity;
                        }
                    }
                    else if ((p_conv_statics->track_info[p_conv_statics->active_track].last_status & 0xF0) == 0xB0) //check if it is control change event
                    {
                        if (*(p_work-2) == 0x07)
                        {
                            /* Channel Volume */
                            *(p_work-1) += p_conv_statics->delta_volume;
                        }
                        else if (*(p_work-2) == 0x0B)
                        {
                            /* Expression */
                            *(p_work-1) += p_conv_statics->delta_expression;
                        }
                    }
                }

                /* update write index */
                p_conv_statics->write_index = p_work - p_frame_start;
            }
        }
        else
        {
            /* no event left for current frame, move on to next frame */
            p_conv_statics->write_index -= WRITE_INDEX_LIMIT;
            p_conv_statics->calc_index -= CALC_INDEX_LIMIT;
            p_conv_statics->track_info[p_conv_statics->active_track].p_track_data=p_track_data;
            return ;
        }

        //update active track info - point to next delta time
        p_conv_statics->track_info[p_conv_statics->active_track].p_track_data=p_track_data;

        //handle delta time
        UpdateDeltaTime(p_conv_statics);

        //loops through all tracks to see if ALL has ended
        if (EndOfMidiFileReached(p_conv_statics))
            return;

        /* get start index for next event */
        CalcStartIndex(p_conv_statics);
    }
}

/*??FUNB**********************************************************************
* NAME   :  UpdateDeltaTime
* INPUT  :  p_conv_statics        pointer to converter static memory.
* Description:
***********************************************************************??FUNE*/
static void UpdateDeltaTime(midi_conv_statics_t *p_conv_statics)
{
    SINT8 i;
    UINT8 channel;
    UINT32 delta_time=p_conv_statics->track_info[p_conv_statics->active_track].delta_time; //get current delta time (from active track)

    //loop through all tracks (event track 0 + all from file) and update the individual tracks current delta time
    //with the delta time already "used" from current tracks - which means deduct the delta time already handled.
    //Done so, because the current delta time is the minimum time found
    for (i=0; i<p_conv_statics->number_of_tracks; i++)
        if (!p_conv_statics->track_info[i].track_ended)
            p_conv_statics->track_info[i].delta_time-=delta_time;

    /* Get delta time for next event on active track (only if track has not ended already) */
    if (!p_conv_statics->track_info[p_conv_statics->active_track].track_ended)
    {
        /* Check if file or converter track - converter track is track 0*/
        if (p_conv_statics->active_track)
        {
            /* Get delta time for next event on file track - p_track_data points to delta time, so the length read equals delta time. Pointer points to next event after this*/
            p_conv_statics->track_info[p_conv_statics->active_track].p_track_data =
                ReadVarLen(&(p_conv_statics->track_info[p_conv_statics->active_track].delta_time),
                           p_conv_statics->track_info[p_conv_statics->active_track].p_track_data);

            /* Check if active track has ended (remember end of track info is not included) */
            if (p_conv_statics->track_info[p_conv_statics->active_track].p_track_data >=
                    p_conv_statics->track_info[p_conv_statics->active_track].p_track_end)
                p_conv_statics->track_info[p_conv_statics->active_track].track_ended = TRUE;
        }
        else
        {
            /* Reset pointer to converter event buffer - point to start of converter track 0 */
            p_conv_statics->track_info[p_conv_statics->active_track].p_track_data = p_conv_statics->conv_event_buffer;

            /* Check which converter event has to be processed next */
            if (((p_conv_statics->conv_event_buffer[0]) & 0xF0) == 0xB0)
            {
                /* Channel Volume CMD has been introduced for volume normalization,
                   check if further Channel Volume CMDs required. */
                channel = (p_conv_statics->conv_event_buffer[0]) & 0x0F;

                /* get next channel to send CMD on */
                while (++channel < 16)
                {
                    if ((p_conv_statics->vol_corr_flags) & (1 << channel))
                    {
                        /* Prepare next Channel Volume message in converter event buffer */
                        p_conv_statics->conv_event_buffer[0] = (0xB0 | channel);
                        return;
                    }
                }
            }

            /* Default case: generate MIDI clock or bar marker */
            if (p_conv_statics->midi_clock_delta_time <= p_conv_statics->bar_marker_delta_time)
            {
                /* Send MIDI clock next */
                p_conv_statics->track_info[p_conv_statics->active_track].delta_time = p_conv_statics->midi_clock_delta_time;
                p_conv_statics->conv_event_buffer[0] = 0xF8; //set first entry of event track to "midi clock"

                /* Update delta times for next events */
                p_conv_statics->bar_marker_delta_time -= p_conv_statics->midi_clock_delta_time;
                p_conv_statics->midi_clock_delta_time = p_conv_statics->midi_clock_delta_time_max;
            }
            else
            {
                /* Send bar marker next */
                p_conv_statics->track_info[p_conv_statics->active_track].delta_time = p_conv_statics->bar_marker_delta_time;
                p_conv_statics->conv_event_buffer[0] = 0xF0;
                p_conv_statics->conv_event_buffer[1] = 0x07;
                p_conv_statics->conv_event_buffer[2] = 0x7F;
                p_conv_statics->conv_event_buffer[3] = 0x7F;
                p_conv_statics->conv_event_buffer[4] = 0x03;
                p_conv_statics->conv_event_buffer[5] = 0x01;
                p_conv_statics->conv_event_buffer[6] = 0x7F;
                p_conv_statics->conv_event_buffer[7] = 0x3F;
                p_conv_statics->conv_event_buffer[8] = 0xF7;

                /* Update delta times for next events */
                p_conv_statics->midi_clock_delta_time -= p_conv_statics->bar_marker_delta_time;
                p_conv_statics->bar_marker_delta_time = p_conv_statics->bar_marker_delta_time_max;
            }
        }
    }
}

/*??FUNB**********************************************************************
* NAME   :  ReadVarLen
* INPUT  :  p_len                pointer where read length value will be
*                                written to
*           p_var_len            pointer to variable length value to be read
* RETURN :  Returns a pointer to the next byte after the variable length
*           quantity
* DESCR. :  Reads a variable length quantity and writes its value to the
*           memory location pointed to by p_len.
***********************************************************************??FUNE*/
static huge UINT8 *ReadVarLen(SINT32 *p_len, huge UINT8 *p_var_len)
{
    SINT32 len;
    UINT8 byte;

    if ((len = *p_var_len++) & 0x80)
    {
        len &= 0x7F;
        do
        {
            len = (len << 7) | ((byte = *p_var_len++) & 0x7F);
        }
        while (byte & 0x80);
    }

    *p_len = len;

    return p_var_len;
}

/*??FUNB**********************************************************************
* NAME   :  CalcStartIndex
*
* INPUT  :  p_conv_statics        pointer to converter static memory.
*           p_delta_time        pointer to variable length delta time value to
*                                be converted
* RETURN :  Returns a pointer to the next byte after the variable length
*           delta time.
* DESCR. :  Calculates the exact (calc_index) and the next available frame
*           index (write_index) for a event from the delta time value passed.
*           The calculated index values are written to the static data struct.
***********************************************************************??FUNE*/
static void CalcStartIndex(midi_conv_statics_t *p_conv_statics)
{
    SINT8   idx_fa;         /* index of first active track */
    SINT32 min_delta_time;
    UINT8   i;
    midi_track_info_type *track_info;
    SINT32 calc_buffer;
    UINT32 nof_frames;

    //take a copy off all track info - start/end/current data/track ended/last send event/actual delta time  for all tracks
    track_info = p_conv_statics->track_info;
    min_delta_time = 0x7FFFFFFFL; //set minimum delta time to maximum. Later will be looped trhough all tracks to find the min. value
    idx_fa = -1;

    //loop through all tracks (in file) to identify next minimum delta time
    for (i=1; i<p_conv_statics->number_of_tracks; i++)
    {
        if ((track_info[i].delta_time<min_delta_time)&&(!track_info[i].track_ended))
        {
            min_delta_time= track_info[i].delta_time;
            idx_fa = i; //store the track number which has the minimum delta time = first active
        }
    }

    /* Check if all file tracks have ended */
    if (idx_fa == -1)
        return;  //2004-06-17, shouldn't work here

    /* Check for event on converter track
       (is treated with higher prio than all file tracks) */
    if ((track_info[0].delta_time <= min_delta_time) && (!track_info[0].track_ended))
    {
        min_delta_time = track_info[0].delta_time;
        idx_fa = 0; //store the track number which has the minimum delta time = first active
    }

    p_conv_statics->active_track = idx_fa; //update to next active track
    p_conv_statics->delta_time = min_delta_time; //store the min delta time found - on system level
    p_conv_statics->n_event_processed++;

    //are we resuming AND has passed the number of events stored when the suspend was done?
    if ((p_conv_statics->resume!=melody_resume_status_off)&&(p_conv_statics->n_event_processed>=p_conv_statics->n_event_resume))
    {
        p_conv_statics->resume = melody_resume_status_on_final;
        p_conv_statics->calc_index = 0;
        p_conv_statics->resume_status_index = 0;
    }

    //are we doing a set play position?
    if (p_conv_statics->skip_status == melody_skip_status_on)
    {
        calc_buffer = min_delta_time * p_conv_statics->ticks2index;
        nof_frames = (calc_buffer >> (FRAME_INDEX_SIZE + CALC_INDEX_SCALING));
        p_conv_statics->frames_passed += nof_frames;
        frame_error_sum = frame_error_sum + (calc_buffer - (nof_frames << (FRAME_INDEX_SIZE + CALC_INDEX_SCALING)));
        if (frame_error_sum >= CALC_INDEX_LIMIT)
        {
            p_conv_statics->frames_passed++;
            frame_error_sum -= CALC_INDEX_LIMIT;
        }

        if (p_conv_statics->frames_passed >= p_conv_statics->set_pos)
        {
            p_conv_statics->skip_status = melody_skip_status_on_final;
            p_conv_statics->calc_index = 0;
            p_conv_statics->resume_status_index = 0;
            frame_error_sum = 0;
	        if (GetPlayPositionCaB!=NULL)
            {
                     (*GetPlayPositionCaB)(AUD_midi_get_play_position());
			         GetPlayPositionCaB = NULL;
            }
        }
    }

    //normal operation - no resuming or set position
    if (p_conv_statics->resume==melody_resume_status_off && p_conv_statics->skip_status == melody_skip_status_off)
    {

        /* convert delta time in ticks to delta time in (full precision) frame indices */
        calc_buffer = min_delta_time * p_conv_statics->ticks2index;

        /* calculate and update the exact index position of the current event */
        calc_buffer += p_conv_statics->calc_index;
        p_conv_statics->calc_index = calc_buffer;

        /* round calculated index value to nearest possible real write index */
        calc_buffer += 1 << (CALC_INDEX_SCALING - 1);
        calc_buffer >>= CALC_INDEX_SCALING; // >> needs to be arithmetic shift !!!

        /* if NOT resuming */
        /* check, if calculated index lies behind current write index */
        if ((calc_buffer > p_conv_statics->write_index)&&(p_conv_statics->resume==melody_resume_status_off))
        {
            /* calculated position is free, update write index */
            p_conv_statics->write_index = calc_buffer;
        }
    }
}

/*??FUNB**********************************************************************
* NAME   :  SetTempo
* INPUT  :  p_conv_statics        pointer to converter static memory.
*           tempo                new tempo value from the SetTempo meta event
* DESCR. :  Updates the conversion factor from delta time ticks to frame
*           indices according to a new tempo value.
***********************************************************************??FUNE*/
static void SetTempo(midi_conv_statics_t *p_conv_statics, SINT32 tempo)
{
    /* calculate the conversion factor (ticks2index) from delta time in ticks (dT) to delta time in
       (extended precision) frame indices (dI):
       
       dI = ticks2index * dT;
       ticks2index = (WRITE_INDEX_LIMIT * 2^CALC_INDEX_SCALING / FRAME_TIME) * (tempo / division)
    */
    UINT32 tempo_quotient, product_high, product_low;
    UINT32 tmp;

    if (p_conv_statics->division<0x8000)
    {
        /* metric tempo */
        /* tempo_quotient = tempo * 2^8 / division. Scaling by 2^8 because tempo is 24 bit and min.
           division is 1 ==> tempo_quotient is max. 32 bit. Division is done with rounding. */
        tempo_quotient = ((tempo << 8) + (p_conv_statics->division >> 1)) / p_conv_statics->division;
    }
    else
    {
        /* SMPTE + ticks per frame *//* Does any file require it ? */

        UINT16 SMPTE = p_conv_statics->division&&0xFF00;
        UINT16 FpS ;
        UINT16 TpF = p_conv_statics->division&&0x00FF;

        /* idea
        SE (p_conv_statics->division && 0xFF00U) == E2
            FpS = 25 * 100

        TpS = (UINT16) (FpS * TpF)/2^2 ;

        TpS = (UINT16) (FpS * TpF) ;
        tempo_quotient  = ( ((UINT32)25 * 1000000<<8) + (TpS >> 1) ) / TpS ;
        */

        if (SMPTE==0xE200)
            FpS = 3000;    /* 30 * 100 */
        else if (SMPTE==0xE300)
            FpS = 2997;    /* 29,97 * 100 */ /* ??? */
        else if (SMPTE==0xE700)
            FpS = 2500;     /* 25 * 100 */
        else if (SMPTE==0xE800)
            FpS = 2400;     /* 24 * 100 */
        else
        {
            aud_glob_midi.melody_conv_error = midi_error_invalid_smpte;
            return;
        }

        /* tempo_quotient = 1000000 * 2^8 / (FpS * TpF) */
        tempo_quotient  = (((UINT32)100000000L<<5) + (FpS >> 1)) / FpS ;    /* 100 * 1000000 us / FpS */
        tempo_quotient = (((UINT32)tempo_quotient<<3) + (TpF >> 1)) / TpF ;
    }

    /* division by FRAME_TIME is avoided by multiplication with 2^30 / FRAME_TIME;
       for 20ms frames this fits exacly into 16 bit (unsigned). Instead of a 16 * 32 multiplication
       two 16 * 16 multiplications are performed */
    tmp = (0x40000000L / FRAME_TIME);
    product_high = (tempo_quotient >> 16) * tmp;
    product_low = (tempo_quotient & 0x0FFFFL)  * tmp;

    /* combine the two partial products to one 32 bit value by shifting out the lower
       16 bits of the product with rounding */
    product_low = ((product_low + 0x8000L) >> 16);
    product_high += product_low;

    /* undo all above scaling:
       
       ticks2index = product_high * 2^16 / (2^30 * 2^8) * WRITE_INDEX_LIMIT * 2^CALC_INDEX_SCALING 
       = product_high * 2^(16 - 38 + FRAME_INDEX_SIZE + CALC_INDEX_SCALING)

        ==> shift right by 22 - FRAME_INDEX_SIZE - CALC_INDEX_SCALING with rounding */
    product_high = (product_high + (1 << (21 - FRAME_INDEX_SIZE - CALC_INDEX_SCALING))) >> (22 - FRAME_INDEX_SIZE - CALC_INDEX_SCALING);

    p_conv_statics->ticks2index = product_high;
}

/*??FUNB**********************************************************************
* NAME   :  InitImelodyConverter
* INPUT  :  p_imelody_conv_statics   pointer to structure containing all converter
*                                    static memory.
* DESCR. :
***********************************************************************??FUNE*/
static void InitImelodyConverter(imelody_conv_statics_t *p_imelody_conv_statics)
{
    SetImelodyTempo(p_imelody_conv_statics, 120);
    p_imelody_conv_statics->style = 0;
    p_imelody_conv_statics->volume = 7;
    p_imelody_conv_statics->start_volume = 7;
    p_imelody_conv_statics->led_status = OFF;
    p_imelody_conv_statics->vibe_status = OFF;
    p_imelody_conv_statics->backlight_status = OFF;
    p_imelody_conv_statics->repeat_flag = FALSE;
    p_imelody_conv_statics->octave = 4;
    p_imelody_conv_statics->n_event_processed=0;
    p_imelody_conv_statics->reset = TRUE;
    p_imelody_conv_statics->compute_volume = FALSE;
    /* wait some frames before really starting  */
    p_imelody_conv_statics->calc_index = (3L<<(IMELODY_CALC_INDEX_SCALING+FRAME_INDEX_SIZE));
}

/*??FUNB**********************************************************************
* NAME   :  ReInitImelodyConverter
* INPUT  :  p_imelody_conv_statics            pointer to structure containing all converter
*                                                             static memory.
* DESCR. :
***********************************************************************??FUNE*/
static void ReInitImelodyConverter(imelody_conv_statics_t *p_imelody_conv_statics)
{
    p_imelody_conv_statics->volume = p_imelody_conv_statics->start_volume ;
    p_imelody_conv_statics->led_status = OFF;
    p_imelody_conv_statics->vibe_status = OFF;
    p_imelody_conv_statics->backlight_status = OFF;
    p_imelody_conv_statics->repeat_flag = FALSE;
    p_imelody_conv_statics->octave = 4;
    p_imelody_conv_statics->reset = TRUE;
    p_imelody_conv_statics->compute_volume = FALSE;
    /* wait some frames before restarting 60ms) */
    p_imelody_conv_statics->calc_index = (3L<<(IMELODY_CALC_INDEX_SCALING+FRAME_INDEX_SIZE));
    p_imelody_conv_statics->p_imelody_data = p_imelody_conv_statics->p_imelody_start;

    //needn't reset in case of resume
    if (aud_glob_midi.imelody_conv_statics.resume == melody_resume_status_off)
    {
        p_imelody_conv_statics->n_event_processed=0;
        //for get play position.
        p_imelody_conv_statics->frames_passed = 0;
    }
}

/*??FUNB**********************************************************************
* NAME   :  InitImelodyCommands
* INPUT  :  p_imelody_conv_statics            pointer to structure containing all converter
*                                                             static memory.
* DESCR. :
***********************************************************************??FUNE*/
static void InitImelodyCommands(imelody_conv_statics_t *p_imelody_conv_statics)
{
    p_imelody_conv_statics->cmd_queue_len = 3;
    /* program change */
    p_imelody_conv_statics->cmd_queue[0].cmd[0] = 0xC0;
    /* instrument: 0 piano, 25 guitar */
    p_imelody_conv_statics->cmd_queue[0].cmd[1] = 5;
    p_imelody_conv_statics->cmd_queue[0].cmd[2] = 0x00;
    p_imelody_conv_statics->cmd_queue[0].write_index = 0;
    /* volume */
    p_imelody_conv_statics->cmd_queue[1].cmd[0] = 0xB0;
    p_imelody_conv_statics->cmd_queue[1].cmd[1] = 0x07;
    p_imelody_conv_statics->cmd_queue[1].cmd[2] = imelody2midi_volume[p_imelody_conv_statics->volume+p_imelody_conv_statics->delta_volume];
    p_imelody_conv_statics->cmd_queue[1].write_index = 0;
    p_imelody_conv_statics->cmd_queue[2].cmd[0] = 0xB0;
    p_imelody_conv_statics->cmd_queue[2].cmd[1] = 0x27;
    p_imelody_conv_statics->cmd_queue[2].cmd[2] = 0x00;
    p_imelody_conv_statics->cmd_queue[2].write_index = 0;
}

/*??FUNB**********************************************************************
* NAME   :  NormalizeImelodyVolume
* INPUT  :  p_imelody_conv_statics            pointer to structure containing all converter
*                                                             static memory.
* DESCR. :
***********************************************************************??FUNE*/
static void NormalizeImelodyVolume(imelody_conv_statics_t *p_imelody_conv_statics)
{
    p_imelody_conv_statics->compute_volume = TRUE;
    p_imelody_conv_statics->delta_volume = p_imelody_conv_statics->start_volume;
    p_imelody_conv_statics->cmd_queue_len = 0;

    ReadImelodyEvent(p_imelody_conv_statics);
    p_imelody_conv_statics->delta_volume = MIN(15, p_imelody_conv_statics->delta_volume);
    p_imelody_conv_statics->delta_volume = 15 - p_imelody_conv_statics->delta_volume;

    ReInitImelodyConverter(p_imelody_conv_statics);
}

/*??FUNB**********************************************************************
* NAME   :  SetImelodyTempo
* INPUT  :  p_conv_statics        pointer to converter static memory.
*           tempo                new tempo value from the SetTempo meta event
* DESCR. :  Updates the conversion factor from delta time ticks to frame
*          indices according to a new tempo value.
***********************************************************************??FUNE*/
static void SetImelodyTempo(imelody_conv_statics_t *p_imelody_conv_statics, SINT16 beat)
{
    /* calculate conversion factor between full note and midi indeces:
        full note duration in ms: 4 * 60 * 1000 / beat
        indeces per ms: 128 /20
        scaling factor: 2^10
        therefore: (3*4*128*1000*1024)/beat 
    */
    UINT32 quotient;

    quotient = (12L*128L*1000L)<<IMELODY_CALC_INDEX_SCALING;
    p_imelody_conv_statics->midi_indeces_per_full_note = (quotient + (beat>>1)) / beat;
}

/*??FUNB**********************************************************************
* NAME   :  CheckImelodyFile
* INPUT  :  p_imelody_data                   pointer to file
*           file_size                               file size in bytes
*           p_imelody_conv_statics        pointer to converter static memory
*           conv_error                          flags error in conversion
* DESCR. :     read file header and find start and end of i-melody
***********************************************************************??FUNE*/
static void CheckImelodyFile(huge UINT8 *p_imelody_data, UINT32 file_size, imelody_conv_statics_t *p_imelody_conv_statics,
                             melody_conv_errors_enum *conv_error)
{
    huge UINT8 *p_imelody_end;
    SINT8 StringBuf[16];
    UINT8 line;
    UINT8 c, l;
    SINT16 beat, volume,style;
    UINT8 found_start = FALSE;
    UINT8 found_end = FALSE;

    /* check if memory available */
    if (file_size<60)
    {
        *conv_error = imelody_error_file_empty;
        return ;
    }

    p_imelody_end = p_imelody_data + file_size;

    /* check 1st line */
    hstrncpy(StringBuf, p_imelody_data, 13);
    StringBuf[13] = '\0';
    if (strcmp((char *)StringBuf, "BEGIN:IMELODY") != 0)
    {
        *conv_error = imelody_error_invalid_header;
        return ;
    }

    /* skip 1st line, words + <cr><lf> */
    p_imelody_data+=13;
    c=*p_imelody_data++;
    l=*p_imelody_data++;

    if (c!=0x0D || l!=0x0A)
    {
        *conv_error = imelody_error_invalid_header;
        return ;
    }

    /* check 2nd line */
    hstrncpy(StringBuf, p_imelody_data, 11);
    StringBuf[11] = '\0';
    if (strcmp((char *)StringBuf, "VERSION:1.2") != 0)
    {
        *conv_error = imelody_error_invalid_header;
        return ;
    }

    /* skip 2nd line, words + <cr><lf> */
    p_imelody_data+=11;
    c=*p_imelody_data++;
    l=*p_imelody_data++;

    if (c!=0x0D || l!=0x0A)
    {
        *conv_error = imelody_error_invalid_header;
        return ;
    }

    /* check 3nd line */
    hstrncpy(StringBuf, p_imelody_data, 15);
    StringBuf[15] = '\0';
    if (strcmp((char *)StringBuf, "FORMAT:CLASS1.0") != 0)
    {
        *conv_error = imelody_error_invalid_header;
        return ;
    }

    /* skip 3rd line, words + <cr><lf> */
    p_imelody_data+=15;
    c=*p_imelody_data++;
    l=*p_imelody_data++;

    if (c!=0x0D || l!=0x0A)
    {
        *conv_error = imelody_error_invalid_header;
        return ;
    }
    line = 4;

    do
    {
        switch (c=*p_imelody_data)
        {
            case 'N':
                hstrncpy(StringBuf, p_imelody_data, 5);
                StringBuf[5] = '\0';
                p_imelody_data=SkipLine(p_imelody_data);
                break;

            case 'C':
                hstrncpy(StringBuf, p_imelody_data, 9);
                StringBuf[9] = '\0';
                p_imelody_data=SkipLine(p_imelody_data);
                break;

            case 'B':
                hstrncpy(StringBuf, p_imelody_data, 5);
                StringBuf[5] = '\0';
                if (strcmp((char *)StringBuf, "BEAT:") == 0)
                {
                    p_imelody_data+=5;
                    beat = atoi_imy(p_imelody_data, &p_imelody_data);
                    if (beat<=900 && beat>=25)
                        SetImelodyTempo(p_imelody_conv_statics, beat);
                }
                p_imelody_data=SkipLine(p_imelody_data);
                break;

            case 'S':
                hstrncpy(StringBuf, p_imelody_data, 6);
                StringBuf[6] = '\0';
                if (strcmp((char *)StringBuf, "STYLE:") == 0)
                {
                    p_imelody_data+=6;
                    if (*p_imelody_data=='S')
                        p_imelody_data++;
                    style = atoi_imy(p_imelody_data, &p_imelody_data);
                    if (style<=2 && style>=0)
                        p_imelody_conv_statics->style = (UINT8) style;
                }
                p_imelody_data=SkipLine(p_imelody_data);
                break;

            case 'V':
                hstrncpy(StringBuf, p_imelody_data, 7);
                StringBuf[7] = '\0';
                if (strcmp((char *)StringBuf, "VOLUME:7") == 0)
                {
                    p_imelody_data+=7;
                    if (*p_imelody_data=='V')
                        p_imelody_data++;
                    volume = atoi_imy(p_imelody_data, &p_imelody_data);
                    if (volume<=15 && volume>=0)
                    {
                        p_imelody_conv_statics->volume = (UINT8) volume;
                        p_imelody_conv_statics->start_volume = (UINT8) volume;
                    }
                }
                p_imelody_data=SkipLine(p_imelody_data);
                break;

            case 'M':
                hstrncpy(StringBuf, p_imelody_data, 7);
                StringBuf[7] = '\0';
                if (strcmp((char *)StringBuf, "MELODY:") == 0)
                {
                    p_imelody_data+=7;
                    p_imelody_conv_statics->p_imelody_start=p_imelody_data;
                    p_imelody_conv_statics->p_imelody_data=p_imelody_data;
                    found_start = TRUE;
                }
                p_imelody_data=SkipLine(p_imelody_data);
                break;

            case 'E':
                hstrncpy(StringBuf, p_imelody_data, 11);
                StringBuf[11] = '\0';
                if (strcmp((char *)StringBuf, "END:IMELODY") == 0)
                {
                    p_imelody_conv_statics->p_imelody_end=p_imelody_data-1;
                    found_end = TRUE;
                }
                break;

            default:
                /* skip line */
                p_imelody_data=SkipLine(p_imelody_data);
                break;

        }
        line ++;
    }
    while ((!found_end) && (p_imelody_data<p_imelody_end));

    if (!(found_start && found_end))
    {
        *conv_error = imelody_error_file_truncated;
        return ;
    }
}


/****************************************************************************************
* Function:... SkipLine
* Description:
****************************************************************************************/
static huge UINT8 * SkipLine(huge UINT8 *ptr)
{
    /* max line length (1024*16) */
    UINT32 i=0;

    while ((*ptr++!=0x0A) && (i++<=(16*1024)));

    return ptr;
}

/****************************************************************************************
* Function:... FillBufferWithImelodyData
* Description:
****************************************************************************************/
static void FillBufferWithImelodyData(UINT16 *buff)
{
    ConvertImelodyFrame(&aud_glob_midi.imelody_conv_statics, (UINT8*)buff);
    if ((aud_glob_midi.imelody_conv_statics.cmd_queue_len==0) && ((aud_glob_midi.nof_repeats==0) || (aud_glob_midi.nof_repeats>1)))
    {
        if (aud_glob_midi.nof_repeats>1)
            aud_glob_midi.nof_repeats--;
        ReInitImelodyConverter(&(aud_glob_midi.imelody_conv_statics));
        InitImelodyCommands(&(aud_glob_midi.imelody_conv_statics));

        /* send indication that playing the repeated melody is finished */
        aud_send_response_signal(aud_glob_midi.sender, aud_resource_midi_player, aud_rc_playback_loop, 0, (UINT32) aud_format_midi, aud_glob_midi.nof_repeats, 0, NULL, NULL);
    }
    else if (aud_glob_midi.imelody_conv_statics.cmd_queue_len==0)
    {
        aud_glob_midi.data_buff_status = data_buff_status_eof;
        //for get play position.
        aud_glob_midi.imelody_conv_statics.frames_passed = 0;
    }
    else if (aud_glob_midi.imelody_conv_statics.skip_status == melody_skip_status_off)
    {
        /* accumulate the frames having been passed */
        aud_glob_midi.imelody_conv_statics.frames_passed++;
    }

}

/*??FUNB**********************************************************************
* NAME   :  ConvertImelodyFrame
* INPUT  :  p_imelody_conv_statics      pointer to converter static memory.
*           p_frame_data                    pointer to output frame buffer
* DESCR. :  Generates the MIDI protocol data for one 20ms frame from the
*           Imelody file track input.
***********************************************************************??FUNE*/
static void ConvertImelodyFrame(imelody_conv_statics_t *p_imelody_conv_statics, UINT8 *p_frame_start)
{

    UINT8 *p_work = p_frame_start;
    SINT32 write_index;
    SINT16 i;

    if (p_imelody_conv_statics->cmd_queue_len==0)
        return;

    write_index = MAX(p_imelody_conv_statics->cmd_queue[0].write_index, 0);

    /* if reset flag is set */
    if (p_imelody_conv_statics->reset)
    {
        p_imelody_conv_statics->reset=FALSE;
        *p_work++ = 0xF0;
        *p_work++ = 0x7E;
        *p_work++ = 0x7F;
        *p_work++ = 0x09;
        *p_work++ = 0x01;
        *p_work++ = 0xF7;
        /* 2004-0119, Test, after reset, the write_index should be updated */
        write_index += 6;
    }

    /* loop over all events for the current frame */
    while ((p_imelody_conv_statics->cmd_queue_len!=0) && (write_index< WRITE_INDEX_LIMIT))
    {
        /* update frame pointer to next write position */
        p_work = p_frame_start + write_index;
        for (i=0; i<3; i++)
            *p_work++ = p_imelody_conv_statics->cmd_queue[0].cmd[i];
        p_imelody_conv_statics->cmd_queue_len--;
        write_index +=3;

        if (p_imelody_conv_statics->cmd_queue_len>0)
        {
            for (i=0; i<p_imelody_conv_statics->cmd_queue_len; i++)
                memcpy(&p_imelody_conv_statics->cmd_queue[i], &p_imelody_conv_statics->cmd_queue[i+1], sizeof(midi_cmd_item_type));
        }
        else
            ReadImelodyEvent(p_imelody_conv_statics);
        write_index = MAX(write_index, p_imelody_conv_statics->cmd_queue[0].write_index);

    }

    /* no event left for current frame, move on to next frame */
    for (i=0; i<p_imelody_conv_statics->cmd_queue_len; i++)
        p_imelody_conv_statics->cmd_queue[i].write_index -= WRITE_INDEX_LIMIT;
    if (p_imelody_conv_statics->resume==melody_resume_status_off
            && p_imelody_conv_statics->skip_status == melody_skip_status_off)
    {

        p_imelody_conv_statics->calc_index -= (1L<<(IMELODY_CALC_INDEX_SCALING+FRAME_INDEX_SIZE));
    }
}

/*??FUNB**********************************************************************
* NAME   :  strncmp_imy
* OUTPUT :  ptr of next caracter in cs
* DESCR. :  compare at most n characters of string cs to string ct; return <0 if cs<ct, 0 if cs==ct, or >0 if cs>ct
*           all <cr>,<lf>,space,htab characters are skipped
***********************************************************************??FUNE*/
static SINT16 strncmp_imy(const huge UINT8 *cs, const huge UINT8 *ct, UINT16 num, huge UINT8 **ptr)
{
    UINT16 i;

    for (i=0; i<num; i++)
    {
        while (*cs==0x0D || *cs==0x0A  || *cs==32 || *cs==9)
            cs++;
        while (*ct==0x0D || *ct==0x0A  || *ct==32 || *ct==9)
            ct++;
        if (*cs!=*ct)
            return(*cs - *ct);
        else
        {
            if (*cs=='\0')
                return 0;
            else
            {
                cs++;
                ct++;
                *ptr = (UINT8 *)cs;
            }
        }
    }
    return 0;
}

/*??FUNB**********************************************************************
* NAME   :  atoi_imy
* OUTPUT :  ptr of next caracter in cs
* DESCR. :  converts s to int
*           all <cr>,<lf>,space,htab characters are skipped
***********************************************************************??FUNE*/
static SINT16 atoi_imy(const huge UINT8 *c, huge UINT8 **ptr)
{
    SINT16 val=0;
    while (1)
    {
        while (*c==0x0D || *c==0x0A  || *c==32 || *c==9)
            c++;
        if (*c<='9' && *c>='0')
        {
            val = (val*10) + (*c++-'0');
            *ptr = (UINT8 *)c;
        }
        else
            return val;
    }
}

/*??FUNB**********************************************************************
* NAME   :  ReadDurationSpecifier_imy
* OUTPUT :  ptr of next caracter in cs
* DESCR. :  read duration specifier
***********************************************************************??FUNE*/
static UINT8  ReadDurationSpecifier_imy(const huge UINT8 *c, huge UINT8 **ptr)
{
    while (*c==0x0D || *c==0x0A  || *c==32 || *c==9)
        c++;
    if ((*c == '.') || (*c == ':') ||(*c == ';'))
    {
        *ptr = (UINT8*)c+1;
        return *c;
    }
    else
        return 0;
}

/*??FUNB**********************************************************************
* NAME   :  ConvertDuration_imy
* OUTPUT :  ptr of next caracter in cs
* DESCR. :  compute note duration
***********************************************************************??FUNE*/
static SINT32 ConvertDuration_imy(SINT16 duration, UINT8 duration_specifier, UINT32 indeces_per_full_note)
{
    UINT32 note_len;

    note_len = indeces_per_full_note>>duration;
    if (duration_specifier=='.')
        return(note_len+ (note_len>>1));
    else if (duration_specifier==':')
        return(note_len+ (note_len>>1) + (note_len>>2));
    else if (duration_specifier==';')
        return((note_len<<1)/3);
    else
        return note_len;
}

/*??FUNB**********************************************************************
* NAME   :  ReadImelodyNote
* INPUT  :  p_imelody_conv_statics        pointer to converter static memory.
* DESCR. :  Read Imelody Note
***********************************************************************??FUNE*/
static void ReadImelodyNote(imelody_conv_statics_t *p_imelody_conv_statics)
{
    huge UINT8 *p = p_imelody_conv_statics->p_imelody_data;
    SINT16 octave = 4;
    SINT16 flat_sharp = 0;
    SINT16 note_num;
    const SINT16 midi_notes[7] = {33, 35, 24, 26, 28, 29, 31};
    SINT16 duration;
    UINT8 duration_specifier;
    SINT32 full_duration, note_duration, silence_duration;

    /* check octave */
    if (*p=='*')
    {
        p++;
        octave = atoi_imy(p, &p);
        if (octave<0 || octave>8)
        {
            p_imelody_conv_statics->p_imelody_data = p++;
            aud_glob_midi.melody_conv_error = imelody_error_parsing;
            return;
        }
        p_imelody_conv_statics->octave = (UINT8) octave;
    }

    /* remove any space */
    while (*p==0x0D || *p==0x0A  || *p==32 || *p==9) p++;

    /* check flat_sharp indication */
    if (*p=='#')
    {
        p++;
        flat_sharp = 1;
    }
    else if (*p=='&')
    {
        p++;
        flat_sharp = 1;
    }

    /* remove any space */
    while (*p==0x0D || *p==0x0A  || *p==32 || *p==9) p++;

    /* read note */
    if (*p<'a' || *p>'g')
    {
        p_imelody_conv_statics->p_imelody_data = p++;
        aud_glob_midi.melody_conv_error = imelody_error_parsing;
        return;
    }
    else
        note_num = midi_notes[*p++-'a'] + flat_sharp + 12 * p_imelody_conv_statics->octave;

    duration = atoi_imy(p, &p);
    if (duration>5 || duration<0)
    {
        aud_glob_midi.melody_conv_error = imelody_error_parsing;
        p_imelody_conv_statics->p_imelody_data = p;
        return;
    }

    duration_specifier = ReadDurationSpecifier_imy(p, &p);
    p_imelody_conv_statics->p_imelody_data = p;

    if (!p_imelody_conv_statics->compute_volume)
    {
        full_duration = ConvertDuration_imy(duration, duration_specifier, p_imelody_conv_statics->midi_indeces_per_full_note);
        if (p_imelody_conv_statics->style == 0)
        {
            silence_duration = full_duration / 21;
            note_duration = full_duration - silence_duration;
        }
        else if (p_imelody_conv_statics->style == 1)
        {
            silence_duration = 0;
            note_duration = full_duration;
        }
        else
        { // style == 2
            silence_duration = full_duration >> 1;
            note_duration = full_duration - silence_duration;
        }
        if (p_imelody_conv_statics->resume==melody_resume_status_off)
        {
            if (p_imelody_conv_statics->skip_status == melody_skip_status_off)
            {
                p_imelody_conv_statics->cmd_queue_len = 2;
                p_imelody_conv_statics->cmd_queue[0].write_index = (p_imelody_conv_statics->calc_index)>>IMELODY_CALC_INDEX_SCALING;
                p_imelody_conv_statics->cmd_queue[0].cmd[0] = 0x90;
                p_imelody_conv_statics->cmd_queue[0].cmd[1] = (UINT8)note_num;
                p_imelody_conv_statics->cmd_queue[0].cmd[2] = 64;
            }
            p_imelody_conv_statics->calc_index += note_duration;

            if (p_imelody_conv_statics->skip_status == melody_skip_status_off)
            {
                p_imelody_conv_statics->cmd_queue[1].write_index = (p_imelody_conv_statics->calc_index)>>IMELODY_CALC_INDEX_SCALING;
                p_imelody_conv_statics->cmd_queue[1].cmd[0] = 0x80;
                p_imelody_conv_statics->cmd_queue[1].cmd[1] = (UINT8)note_num;
                p_imelody_conv_statics->cmd_queue[1].cmd[2] = 127;
            }

            p_imelody_conv_statics->calc_index += silence_duration;

        }
    }
}

/*??FUNB**********************************************************************
* NAME   :  ReadImelodySilence
* INPUT  :  p_imelody_conv_statics        pointer to converter static memory.
* DESCR. :  Read Imelody silence period
***********************************************************************??FUNE*/
static void ReadImelodySilence(imelody_conv_statics_t *p_imelody_conv_statics)
{
    huge UINT8 *p = p_imelody_conv_statics->p_imelody_data;
    SINT16 duration;
    UINT8 duration_specifier;

    p++;
    duration = atoi_imy(p, &p);
    if (duration<=5 && duration>=0)
    {
        duration_specifier = ReadDurationSpecifier_imy(p, &p);
        if (p_imelody_conv_statics->resume==melody_resume_status_off)
        {
            p_imelody_conv_statics->calc_index +=
                ConvertDuration_imy(duration, duration_specifier, p_imelody_conv_statics->midi_indeces_per_full_note);
        }
        p_imelody_conv_statics->p_imelody_data = p;
    }
    else
    {
        aud_glob_midi.melody_conv_error = imelody_error_parsing;
        p_imelody_conv_statics->p_imelody_data = p;
    }

}

/*??FUNB**********************************************************************
* NAME   :  ReadImelodyVolume
* INPUT  :  p_imelody_conv_statics        pointer to converter static memory.
* DESCR. :  Read Imelody Volume change
***********************************************************************??FUNE*/
static void ReadImelodyVolume(imelody_conv_statics_t *p_imelody_conv_statics)
{
    huge UINT8 *p = p_imelody_conv_statics->p_imelody_data;
    SINT16 volume;

    p++;

    /* skip spaces */
    while (*p==0x0D || *p==0x0A  || *p==32 || *p==9) p++;

    if (*p=='+')
    {
        p++;
        volume = MIN(p_imelody_conv_statics->volume+1,15);
    }
    else if (*p=='-')
    {
        p++;
        volume = MAX((SINT16)p_imelody_conv_statics->volume-1,0);
    }
    else
        volume = atoi_imy(p, &p);

    if (p_imelody_conv_statics->compute_volume && volume<=15 && volume>=0)
    {
        p_imelody_conv_statics->delta_volume = MAX(p_imelody_conv_statics->delta_volume, volume);
        p_imelody_conv_statics->p_imelody_data = p;
    }
    else if (volume<=15 && volume>=0)
    {
        p_imelody_conv_statics->p_imelody_data = p;
        p_imelody_conv_statics->volume = (UINT8)volume;
        p_imelody_conv_statics->cmd_queue_len = 1;
        if (p_imelody_conv_statics->resume==melody_resume_status_off
                && p_imelody_conv_statics->skip_status == melody_skip_status_off)
        {
            p_imelody_conv_statics->cmd_queue[0].write_index = (p_imelody_conv_statics->calc_index)>>IMELODY_CALC_INDEX_SCALING;
        }
        else
        {
            p_imelody_conv_statics->cmd_queue[0].write_index = 0;
        }
        p_imelody_conv_statics->cmd_queue[0].cmd[0] = 0xB0;
        p_imelody_conv_statics->cmd_queue[0].cmd[1] = 0x07;
        p_imelody_conv_statics->cmd_queue[0].cmd[2] = imelody2midi_volume[p_imelody_conv_statics->volume+p_imelody_conv_statics->delta_volume];
    }
    else
    {
        aud_glob_midi.melody_conv_error = imelody_error_parsing;
        p_imelody_conv_statics->p_imelody_data = p;
    }
}

/*??FUNB**********************************************************************
* NAME   :  ReadImelodyRepeat
* INPUT  :  p_imelody_conv_statics        pointer to converter static memory.
* DESCR. :  Check repeat and do correspending action
***********************************************************************??FUNE*/
static SINT16 ReadImelodyRepeat(imelody_conv_statics_t *p_imelody_conv_statics)
{
    huge UINT8 *p = p_imelody_conv_statics->p_imelody_data;
    SINT16 repeat_num=0;

    p++;

    if (!p_imelody_conv_statics->repeat_flag)
    {
        aud_glob_midi.melody_conv_error = imelody_error_parsing;
        p_imelody_conv_statics->p_imelody_data = p;
        return -1;
    }

    /* skip spaces */
    while (*p==0x0D || *p==0x0A  || *p==32 || *p==9) p++;

    if (*p<'0' || *p>'9')
    {
        aud_glob_midi.melody_conv_error = imelody_error_parsing;
        p_imelody_conv_statics->p_imelody_data = p;
        p_imelody_conv_statics->repeat_flag = FALSE;
        return -1;
    }

    repeat_num = atoi_imy(p, &p);
    if (!((repeat_num == 0) || (p_imelody_conv_statics->repeat_count<repeat_num)))
        p_imelody_conv_statics->repeat_flag = FALSE;
    else if (repeat_num == 0 && p_imelody_conv_statics->compute_volume)
        p_imelody_conv_statics->repeat_flag = FALSE;

    /* skip spaces */
    while (*p==0x0D || *p==0x0A  || *p==32 || *p==9) p++;
    if (*p == 'V')
    {
        p_imelody_conv_statics->p_imelody_data=p;
        ReadImelodyVolume(p_imelody_conv_statics);
    }

    if (p_imelody_conv_statics->repeat_flag)
    {
        p_imelody_conv_statics->repeat_count++;
        p_imelody_conv_statics->p_imelody_data = p_imelody_conv_statics->p_repeat_start;
    }
    else
    {
        p = p_imelody_conv_statics->p_imelody_data;
        while (*p!=')' && p < p_imelody_conv_statics->p_imelody_end) p++;
        p_imelody_conv_statics->p_imelody_data = ++p;
    }

    return repeat_num;
}



/*??FUNB**********************************************************************
* NAME   :  ReadImelodyEvent
*
* INPUT  :  p_imelody_conv_statics        pointer to converter static memory.
*
* OUTPUT :
* RETURN :
* DESCR. :     Search for the first note or volume change event
*                   Compute the start index and write the event in the event Q
***********************************************************************??FUNE*/
static void ReadImelodyEvent(imelody_conv_statics_t *p_imelody_conv_statics)
{
    huge UINT8 *ptr;
    SINT16 siRet;
    static BOOL bAudioparam = FALSE; // to check Audio Params like note

    while ((p_imelody_conv_statics->cmd_queue_len==0 || p_imelody_conv_statics->skip_status == melody_skip_status_on)
            &&(p_imelody_conv_statics->p_imelody_data<=p_imelody_conv_statics->p_imelody_end))
    {
        /* search untill first note or volume change event */
        switch (*p_imelody_conv_statics->p_imelody_data)
        {
            case '#':
            case '&':
            case '*':
            case 'a':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
                /* a note follows */
                ReadImelodyNote(p_imelody_conv_statics);
                bAudioparam = TRUE;
                break;

            case 'b':
                /* check if backlight or note */
                if (strncmp_imy(p_imelody_conv_statics->p_imelody_data,(huge UINT8*)"backoff",7, &ptr)==0)
                {
                    p_imelody_conv_statics->backlight_status = OFF;
                    p_imelody_conv_statics->p_imelody_data=ptr;
                }
                else if (strncmp_imy(p_imelody_conv_statics->p_imelody_data,(huge UINT8*)"backon",6, &ptr)==0)
                {
                    p_imelody_conv_statics->backlight_status = ON;
                    p_imelody_conv_statics->p_imelody_data=ptr;
                }
                else
                {
                    /* a note follows */
                    ReadImelodyNote(p_imelody_conv_statics);
                    bAudioparam = TRUE;
                }
                break;
            case 'v':
                /* vibe */
                if (strncmp_imy(p_imelody_conv_statics->p_imelody_data,(huge UINT8*)"vibeoff",7, &ptr)==0)
                {
                    p_imelody_conv_statics->vibe_status = OFF;
                    p_imelody_conv_statics->p_imelody_data=ptr;
                }
                else if (strncmp_imy(p_imelody_conv_statics->p_imelody_data,(huge UINT8*)"vibeon",6, &ptr)==0)
                {
                    p_imelody_conv_statics->backlight_status = ON;
                    p_imelody_conv_statics->p_imelody_data=ptr;
                }
                else
                    aud_glob_midi.melody_conv_error = imelody_error_parsing;
                break;
            case 'l':
                /* led */
                if (strncmp_imy(p_imelody_conv_statics->p_imelody_data,(huge UINT8*)"ledoff",6, &ptr)==0)
                {
                    p_imelody_conv_statics->led_status = OFF;
                    p_imelody_conv_statics->p_imelody_data=ptr;
                }
                else if (strncmp_imy(p_imelody_conv_statics->p_imelody_data,(huge UINT8*)"ledon",5, &ptr)==0)
                {
                    p_imelody_conv_statics->led_status = ON;
                    p_imelody_conv_statics->p_imelody_data=ptr;
                }
                else
                    aud_glob_midi.melody_conv_error = imelody_error_parsing;
                break;
            case 'r':
                /* rest */
                ReadImelodySilence(p_imelody_conv_statics);
                break;
            case 'V':
                ReadImelodyVolume(p_imelody_conv_statics);
                break;
            case '(':
                p_imelody_conv_statics->p_imelody_data++;
                p_imelody_conv_statics->p_repeat_start = p_imelody_conv_statics->p_imelody_data;
                p_imelody_conv_statics->repeat_flag = TRUE;
                p_imelody_conv_statics->repeat_count = 1;
                break;
            case '@':
                siRet = ReadImelodyRepeat(p_imelody_conv_statics);
                // if NO audio parameters in the repeat sequence break the loop
                if ((siRet == 0) &&(bAudioparam == FALSE))
                    return;
                bAudioparam = FALSE;
                break;
            default:
                /* if it is not <cr>, <lf>, space, htab ... what is it ??? */
                if ((*p_imelody_conv_statics->p_imelody_data!=0x0D)&&(*p_imelody_conv_statics->p_imelody_data!=0x0A)&&
                        (*p_imelody_conv_statics->p_imelody_data!=32)&&(*p_imelody_conv_statics->p_imelody_data!=9))
                {
                    p_imelody_conv_statics->p_imelody_data++;
                    aud_glob_midi.melody_conv_error = imelody_error_parsing;
                }
                else
                    p_imelody_conv_statics->p_imelody_data++;
                break;
        }
        if (!p_imelody_conv_statics->compute_volume)
        {
            p_imelody_conv_statics->n_event_processed++;
            if (p_imelody_conv_statics->resume==melody_resume_status_on &&  p_imelody_conv_statics->n_event_processed==p_imelody_conv_statics->n_event_resume)
                p_imelody_conv_statics->resume=melody_resume_status_off;

            if (p_imelody_conv_statics->skip_status == melody_skip_status_on
                    && p_imelody_conv_statics->calc_index >= p_imelody_conv_statics->set_pos)
            {
                p_imelody_conv_statics->skip_status = melody_skip_status_off;
                p_imelody_conv_statics->frames_passed =
                    (p_imelody_conv_statics->calc_index >> (IMELODY_CALC_INDEX_SCALING+FRAME_INDEX_SIZE));
                p_imelody_conv_statics->calc_index = 0;
            }
        }

    }
}

/*??FUNB**********************************************************************
* NAME   :  AUD_midi_get_total_playtime
*
* INPUT  :  midi id
* OUTPUT :  total playtime of the midi file
* DESCR. :
***********************************************************************??FUNE*/
UINT32 aud_midi_get_total_playtime(aud_ringer_tone_id_enum midi_id, UINT8 huge *melody_data, UINT32 size)
{
    int i, j;
    UINT32 Buffer;
    huge UINT8 *p_midi_data;
    UINT32 file_size;
    SINT8 StringBuf[5];
    UINT32 bytesParsed;
    huge UINT8 *ptr, *p_track_data;
    SINT32 delta_time, tmp32;
    UINT8 last_status;
    UINT32 track_end_time;
    UINT32 total_play_time;
    midi_conv_statics_t midi_conv_statics;
    UINT8 tempo_set = 0;
    UINT32 max_note_duration_in_ticks = 2000;

    if (melody_data)
    {
        p_midi_data = melody_data;
        file_size = size;
    }
    else
    {
        UINT16 Melody_pointer;
#if 0
        for (Melody_pointer=0;;Melody_pointer++)
        {
            if (aud_smaf_melody_table[Melody_pointer].ringer_tone_enum>=aud_ringer_tone_id_end)
            {//Melody is not avaliable
                return 0;
            }

            if (aud_smaf_melody_table[Melody_pointer].ringer_tone_enum==midi_id)
            {
                p_midi_data = aud_smaf_melody_table[Melody_pointer].melody_ptr;
                file_size = aud_smaf_melody_table[Melody_pointer].size;
                break;
            }
        }
#endif
    }

    if (file_size<14)
        return 0;

    StringBuf[4] = '\0';

    /* read file header */
    for (i=0; i<4; i++)
        StringBuf[i] = *p_midi_data++;

    /* check Header */
    if (strcmp((char *)StringBuf, "MThd") != 0)
        return 0;

    /* check header length */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    if (Buffer != 6)
        return 0;

    /* check format */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    if (Buffer > 1)
        return 0;
    midi_conv_statics.format = Buffer;

    /* check ntrks */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    midi_conv_statics.number_of_tracks = Buffer;
    if ((midi_conv_statics.format == 0)&&(Buffer != 1))
        return 0;
    else if (midi_conv_statics.number_of_tracks > MIDI_MAX_NUM_OF_TRACKS)
        midi_conv_statics.number_of_tracks = MIDI_MAX_NUM_OF_TRACKS;

    /* read division */
    Buffer = *p_midi_data++;
    Buffer<<=8, Buffer |= *p_midi_data++;
    //*pDivision = Buffer;
    midi_conv_statics.division= Buffer;

    bytesParsed = 14;
    for (i=0; i< midi_conv_statics.number_of_tracks; i++)
    {
        if ((bytesParsed+8)>file_size)
            return 0;

        /* read track header */
        for (j=0; j<4; j++)
            StringBuf[j] = *p_midi_data++;

        /* read track length */
        Buffer = *p_midi_data++;
        Buffer<<=8, Buffer |= *p_midi_data++;
        Buffer<<=8, Buffer |= *p_midi_data++;
        Buffer<<=8, Buffer |= *p_midi_data++;

        if ((bytesParsed+8+Buffer)>file_size)
            return 0;

        /* check track header */
        if (strcmp((char *)StringBuf, "MTrk") != 0)
        {
            p_midi_data+=Buffer;
            i--;
            midi_conv_statics.number_of_tracks--;
        }
        else
        {
            midi_conv_statics.track_info[i].p_track_start = p_midi_data;
            midi_conv_statics.track_info[i].p_track_data = p_midi_data;
            ptr = p_midi_data + Buffer;
            if ((*(ptr-3)==0xFF)&&(*(ptr-2)==0x2F)&&(*(ptr-1)==0x00))
            {
                /* remove the last metaevent EndOfTrack */
                midi_conv_statics.track_info[i].p_track_end = ptr-3;
            }
            else
                midi_conv_statics.track_info[i].p_track_end = ptr;
            midi_conv_statics.track_info[i].track_ended=0;
            p_midi_data+=Buffer;
        }
        bytesParsed += 8+Buffer;
    }

    total_play_time = 0;
    /* calculate the total play time */
    for (i=0; i < midi_conv_statics.number_of_tracks; i++)
    {
        p_track_data = midi_conv_statics.track_info[i].p_track_data;
        last_status = 0;
        track_end_time = 0;
        while (p_track_data<midi_conv_statics.track_info[i].p_track_end)
        {
            p_track_data = ReadVarLen(&delta_time, p_track_data);
            track_end_time += delta_time;

            if (*p_track_data >= 0x80)
            {
                /* read new status byte */
                last_status = *p_track_data++;
            }

            /* get number of bytes which will follow */
            switch (last_status & 0xF0)
            {
                case (0x90):
                            case (0x80):
                                case (0xA0):
                                    case (0xB0):
                                        case (0xE0):
                                                /* Note OFF, Note Aftertouch */
                                                p_track_data+=2;
                    break;

                case (0xC0):
                            case (0xD0):
                                    /* Channel Pressure: 1 Data Byte follows */
                                    p_track_data++;
                    break;

                default:
                    /* All other Messages have 2 Data Bytes */
                    p_track_data += 2;
                    break;

                case (0xF0):
                                /* System Message, has to be further distinguished */
                                switch (last_status)
                        {
                            case(0xF0):
                                        case(0xF7):
                                                /* System Exclusive: Number of bytes to write has to be decoded from length word */
                                                p_track_data = ReadVarLen(&tmp32, p_track_data);
                                p_track_data += tmp32;
                                break;

                            case(0xF1):
                                        case(0xF3):
                                                /* MIDI Time Code or Song Select: 1 Data Byte follows, will be ignored */
                                                p_track_data++;
                                break;

                            case(0xF2):
                                            /* Song Position Pointer: 2 Data Bytes follow, will be ignored */
                                            p_track_data += 2;
                                break;

                            case(0xFF):
                                            /* Meta Event, has to be distinguished further */
                                            switch (*p_track_data++)
                                    {
                                        case(0x51):
                                                        /* Set Tempo event: get tempo and restore input track pointer */
                                                        p_track_data++; /* skip legth (only 1 byte for set tempo) */
                                            Buffer = *p_track_data++;
                                            Buffer <<= 8;
                                            Buffer |= *p_track_data++;
                                            Buffer <<= 8;
                                            Buffer |= *p_track_data, p_track_data-=3;

                                            /* change tempo setting */
                                            SetTempo(&midi_conv_statics, Buffer);
                                            tempo_set = 1;
                                            /* IMPORTANT: this message should be sent at time 0 in the first track, SMF1.0 */
                                            break;

                                        case(0x2F):
                                                        /* End of Track: */
                                                        midi_conv_statics.track_info[i].track_ended=1;
                                            if (delta_time > max_note_duration_in_ticks)
                                    {
                                                track_end_time -= delta_time;
                                                track_end_time += max_note_duration_in_ticks;
                                            }
                                            break;
                                    }

                                /* None of the  Meta Events will be transmitted; get length
                                      and adjust input pointer accordingly */
                                if (!midi_conv_statics.track_info[i].track_ended)
                                {
                                    p_track_data = ReadVarLen((SINT32 *) &Buffer, p_track_data);
                                    p_track_data += Buffer;
                                }
                                break;
                        }
                    break;
            }
        }
        /* 2004-02-25, record the total play time in ticks */
        if (total_play_time < track_end_time)
            total_play_time = track_end_time;
    }

    if (tempo_set == 0)
        SetTempo(&midi_conv_statics, 500000);

    /* 2004-02-25, to calculate the total play time in ms */
    total_play_time = total_play_time*midi_conv_statics.ticks2index;
    /* round calculated index value to nearest possible real write index */
    total_play_time += 1 << (CALC_INDEX_SCALING - 1);
    total_play_time >>= CALC_INDEX_SCALING; // >> needs to be arithmetic shift !!!
    /* total play time in ms */
    total_play_time = total_play_time* (FRAME_TIME/1000);
    total_play_time = (total_play_time + (1L<< (FRAME_INDEX_SIZE - 1))) >> FRAME_INDEX_SIZE;

    return total_play_time;
}

/*??FUNB**********************************************************************
* NAME   :  aud_imelody_get_total_playtime
* INPUT  :  midi id
* OUTPUT :  total playtime of the midi file
* DESCR. :
***********************************************************************??FUNE*/
UINT32 aud_imelody_get_total_playtime(UINT8 huge *melody_data, UINT32 size)
{
    imelody_conv_statics_t imelody_conv_statics;
    melody_conv_errors_enum melody_conv_error = melody_error_none;
    huge UINT8 *ptr;
    UINT32 total_play_time = 0;
    SINT16 siRepeatCnt;

    imelody_conv_statics.resume = melody_resume_status_off;
    InitImelodyConverter(&imelody_conv_statics);
    CheckImelodyFile(melody_data, size, &imelody_conv_statics, &melody_conv_error);
    if (melody_conv_error)
        return total_play_time;

    /* scan the whole imelody file till the end */
    while (imelody_conv_statics.p_imelody_data<=imelody_conv_statics.p_imelody_end)
    {
        /* search untill first note or volume change event */
        switch (*imelody_conv_statics.p_imelody_data)
        {
            case '#':
            case '&':
            case '*':
            case 'a':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
                /* a note follows */
                ReadImelodyNote(&imelody_conv_statics);
                break;

            case 'b':
                /* check if backlight or note */
                if (strncmp_imy(imelody_conv_statics.p_imelody_data,(huge UINT8*)"backoff",7, &ptr)==0)
                {
                    imelody_conv_statics.backlight_status = OFF;
                    imelody_conv_statics.p_imelody_data=ptr;
                }
                else if (strncmp_imy(imelody_conv_statics.p_imelody_data,(huge UINT8*)"backon",6, &ptr)==0)
                {
                    imelody_conv_statics.backlight_status = ON;
                    imelody_conv_statics.p_imelody_data=ptr;
                }
                else
                {
                    /* a note follows */
                    ReadImelodyNote(&imelody_conv_statics);
                }
                break;
            case 'v':
                /* vibe */
                if (strncmp_imy(imelody_conv_statics.p_imelody_data,(huge UINT8*)"vibeoff",7, &ptr)==0)
                {
                    imelody_conv_statics.vibe_status = OFF;
                    imelody_conv_statics.p_imelody_data=ptr;
                }
                else if (strncmp_imy(imelody_conv_statics.p_imelody_data,(huge UINT8*)"vibeon",6, &ptr)==0)
                {
                    imelody_conv_statics.backlight_status = ON;
                    imelody_conv_statics.p_imelody_data=ptr;
                }
                else
                    aud_glob_midi.melody_conv_error = imelody_error_parsing;
                break;
            case 'l':
                /* led */
                if (strncmp_imy(imelody_conv_statics.p_imelody_data,(huge UINT8*)"ledoff",6, &ptr)==0)
                {
                    imelody_conv_statics.led_status = OFF;
                    imelody_conv_statics.p_imelody_data=ptr;
                }
                else if (strncmp_imy(imelody_conv_statics.p_imelody_data,(huge UINT8*)"ledon",5, &ptr)==0)
                {
                    imelody_conv_statics.led_status = ON;
                    imelody_conv_statics.p_imelody_data=ptr;
                }
                else
                    aud_glob_midi.melody_conv_error = imelody_error_parsing;
                break;
            case 'r':
                /* rest */
                ReadImelodySilence(&imelody_conv_statics);
                break;
            case 'V':
                ReadImelodyVolume(&imelody_conv_statics);
                break;
            case '(':
                imelody_conv_statics.p_imelody_data++;
                imelody_conv_statics.p_repeat_start = imelody_conv_statics.p_imelody_data;
                imelody_conv_statics.repeat_flag = TRUE;
                imelody_conv_statics.repeat_count = 1;
                break;
            case '@':
                siRepeatCnt = ReadImelodyRepeat(&imelody_conv_statics);
                // check for 0 loop forever and return that totalPlaytime cannot be calculated
                if (siRepeatCnt == 0)
                    return 0xFFFFFFFF;
                break;
            default:
                /* if it is not <cr>, <lf>, space, htab ... what is it ??? */
                if ((*imelody_conv_statics.p_imelody_data!=0x0D)&&(*imelody_conv_statics.p_imelody_data!=0x0A)&&
                        (*imelody_conv_statics.p_imelody_data!=32)&&(*imelody_conv_statics.p_imelody_data!=9))
                {
                    imelody_conv_statics.p_imelody_data++;
                    aud_glob_midi.melody_conv_error = imelody_error_parsing;
                }
                else
                    imelody_conv_statics.p_imelody_data++;
                break;
        }   /* end of switch */
    }  /* end of while */

    /* calculate the total play time (ms) of imelody file */
    total_play_time = imelody_conv_statics.calc_index >> (IMELODY_CALC_INDEX_SCALING+FRAME_INDEX_SIZE);
    total_play_time = total_play_time * (FRAME_TIME/1000);
    return total_play_time;
}

/*??FUNB**********************************************************************
* NAME   :  AUD_melody_get_total_playtime
* INPUT  :  midi id
* OUTPUT :  total playtime of the midi file
* DESCR. :
***********************************************************************??FUNE*/
UINT32 AUD_melody_get_total_playtime(aud_ringer_tone_id_enum midi_id, UINT8 huge *melody_data, UINT32 size, aud_format_enum format)
{
    UINT32 total_play_time = 0;
    UINT16 Melody_pointer;

    if (melody_data == NULL)
    {
		#if 0
        /* We got an ID so get the format */
        for (Melody_pointer=0;;Melody_pointer++)
        {
            if (aud_smaf_melody_table[Melody_pointer].ringer_tone_enum>=aud_ringer_tone_id_end)
                return 0; //Melody is not avaliable

            if (aud_smaf_melody_table[Melody_pointer].ringer_tone_enum==midi_id)
            {
                format = aud_smaf_melody_table[Melody_pointer].format;
                break;
            }
        }
		#endif
        /* check format and start calculation */
        if (format == aud_format_midi)
            total_play_time = aud_midi_get_total_playtime(midi_id, NULL, 0);
        else if (format == aud_format_imelody)
        {
			#if 0
            /* imelody file */
            melody_data=aud_smaf_melody_table[Melody_pointer].melody_ptr;
            size = aud_smaf_melody_table[Melody_pointer].size;
            total_play_time = aud_imelody_get_total_playtime(melody_data, size);
			#endif
        }
        else
            return 0;
    }
    else
    { /* Melody data received via pointer */
        if (format == aud_format_midi)
            total_play_time = aud_midi_get_total_playtime((aud_ringer_tone_id_enum)0, melody_data, size);
        else if (format == aud_format_imelody)
        {
            /* imelody file */
            total_play_time = aud_imelody_get_total_playtime(melody_data, size);
        }
        else
            return 0;
    }
    return total_play_time;
}

/*??FUNB**********************************************************************
* NAME   :  AUD_midi_get_play_position
* INPUT  :  midi id
* OUTPUT :  get the current play position of the midi file
* DESCR. :
***********************************************************************??FUNE*/
static UINT32 AUD_midi_get_play_position(void)
{
    UINT32 current_frame_pos;
    current_frame_pos = aud_glob_midi.midi_conv_statics.frames_passed;
    return(current_frame_pos*(FRAME_TIME/1000));
}

/*??FUNB**********************************************************************
* NAME   :  AUD_midi_set_play_position
* INPUT  :    midi id
* OUTPUT :  set the new play position for the midi file
* DESCR. :
***********************************************************************??FUNE*/
static UINT8 AUD_midi_set_play_position(UINT8 handle, UINT32 milli_second, aud_format_enum format)
{
    aud_glob_midi.midi_conv_statics.set_pos = milli_second/(FRAME_TIME/1000);

    if (AUD_get_internal_midi_player_state() != S_midi_idle)
    {
        ReInitMidiConverter(&(aud_glob_midi.midi_conv_statics));
    }

    aud_glob_midi.midi_conv_statics.skip_status = melody_skip_status_on;

    return 1;
}

/***********************************************************************
* NAME   :  aud_imelody_get_play_position
*
* INPUT  :
* OUTPUT :  get the current play position of the imelody file
* RETURN :
* DESCR. :
*
*
***********************************************************************/
UINT32 aud_imelody_get_play_position(void)
{
    UINT32 current_frame_pos;
    current_frame_pos = aud_glob_midi.imelody_conv_statics.frames_passed;
    return (current_frame_pos*(FRAME_TIME/1000));
}


/***********************************************************************
* NAME   :  aud_imelody_set_play_position
*
* INPUT  :    mili seconds
* OUTPUT :  set the new play position for the imelody file
* RETURN :
* DESCR. :
*
*
***********************************************************************/
UINT8 aud_imelody_set_play_position(UINT32 milli_second)
{

    aud_glob_midi.imelody_conv_statics.set_pos = milli_second/(FRAME_TIME/1000);
    //calculated in index, scal_index
    aud_glob_midi.imelody_conv_statics.set_pos <<= (IMELODY_CALC_INDEX_SCALING+FRAME_INDEX_SIZE);
    if (midi_player_state != S_midi_idle)
    {
        ReInitImelodyConverter(&(aud_glob_midi.imelody_conv_statics));
        InitImelodyCommands(&(aud_glob_midi.imelody_conv_statics));
    }
    aud_glob_midi.imelody_conv_statics.skip_status = melody_skip_status_on;
    return 1;
}

/*??FUNB**********************************************************************
* NAME   :  hstrncpy
* DESCR. :  a huge string copy
***********************************************************************??FUNE*/
static void hstrncpy(SINT8 *p_dest, huge UINT8 *p_source, UINT16 num)
{
    UINT16 i;
    for (i=0; i<num;i++)
        *p_dest++=*p_source++;
}

/***********************************************************************
* NAME   :  AUD_set_internal_midi_player_state
* INPUT  :  the state for internal midiplayer - only used in this file
* DESCR. :  handles internal midi state - only accessible for extern files though this function
************************************************************************/
static void AUD_set_internal_midi_player_state(UINT8 new_state)
{
    midi_player_state=new_state;
}

/***********************************************************************
* NAME   :  AUD_get_internal_midi_player_state
* INPUT  :  the state for internal midiplayer - only used in this file
* DESCR. :  handles internal midi state - only accessible for extern files though this function
************************************************************************/
UINT8 AUD_get_internal_midi_player_state(void)
{
    return midi_player_state;
}

/****************************************************************************************
* Function:.. trig_vibra
* Parameters: Trig indication received from DSP
* Description: trigs vibra to either on or off
****************************************************************************************/
static void trig_vibra(UINT16 trig)
{
    int static prev_state=0;
    if (trig != prev_state)
    {
#ifdef DWD_VIB
        VIB_trig(trig);
#endif
        prev_state=trig;
    }
}

/****************************************************************************************
* Function:... AUD_update_audio_post_processor()
* Description: updates the audio post processor in dsp's
****************************************************************************************/
void AUD_update_audio_post_processor(void)
{
    if (update_audio_post_processor)
    {
        //load the DSP command for the audio post processor
        aud_dsp_audioproc.AudioPostProcSwitch = aud_mode;

        aud_dsp_audioproc.b_exp= aud_b_exp;
        aud_dsp_audioproc.b1= aud_b1;
        aud_dsp_audioproc.b0= aud_b0;
        aud_dsp_audioproc.a1= aud_a1;

        aud_dsp_audioproc.INITDATA_mono_flag= aud_INITDATA_mono_flag;
        aud_dsp_audioproc.INITDATA_m_bufflen= aud_INITDATA_m_bufflen;
        aud_dsp_audioproc.INITDATA_m_inv_bufflen= aud_INITDATA_m_inv_bufflen;
        aud_dsp_audioproc.INITDATA_m_hp_coef_exp= aud_INITDATA_m_hp_coef_exp;
        aud_dsp_audioproc.INITDATA_mlp1_coef= aud_INITDATA_m_lp1_coeff;
        aud_dsp_audioproc.INITDATA_mlp2_coef= aud_INITDATA_m_lp2_coeff;
        aud_dsp_audioproc.INITDATA_mlp4_coef= aud_INITDATA_m_lp4_coeff;
        aud_dsp_audioproc.INITDATA_mlp3_coef= aud_INITDATA_m_lp3_coeff;
        aud_dsp_audioproc.INITDATA_m_L_A= aud_INITDATA_m_L_A;
        aud_dsp_audioproc.INITDATA_m_L_Bf= aud_INITDATA_m_L_B;
        aud_dsp_audioproc.INITDATA_m_G_Comp= aud_INITDATA_m_G_comp;
        aud_dsp_audioproc.INITDATA_um_R_infA= aud_INITDATA_um_infA;
        aud_dsp_audioproc.INITDATA_um_R_AB= aud_INITDATA_um_R_AB;
        aud_dsp_audioproc.INITDATA_um_R_B0= aud_INITDATA_um_R_B0;

        DSP_ASYNC_AUDIOPROC(&aud_dsp_audioproc);
    }
}
#endif // INTERNAL_POLYRINGER

