/*******************************************************************************
* Copyright (C) 2013, ZTE Corporation.
*
* File Name:    random.c
* File Mark:
* Description:
* Others:
* Version:		 V1.0
* Author:		 geanfeng
* Date: 		 2013-09-24
********************************************************************************/
#include "random.h"

struct rnd_state
{
    UINT32 s1, s2, s3;
};

struct rnd_state g_drvRandState;

/*
 * Handle minimum values for seeds
 */
static UINT32 __seed(UINT32 x, UINT32 m)
{
    return (x < m) ? x + m : x;
}


/**
 *	prandom32 - seeded pseudo-random number generator.
 *	@state: pointer to state structure holding seeded state.
 *
 *	This is used for pseudo-randomness with no outside seeding.
 *	For more random results, use random32().
 */
UINT32 prandom32(struct rnd_state *state)
{
#define TAUSWORTHE(s,a,b,c,d) ((s&c)<<d) ^ (((s <<a) ^ s)>>b)

    state->s1 = TAUSWORTHE(state->s1, 13, 19, 4294967294UL, 12);
    state->s2 = TAUSWORTHE(state->s2, 2, 25, 4294967288UL, 4);
    state->s3 = TAUSWORTHE(state->s3, 3, 11, 4294967280UL, 17);

    return (state->s1 ^ state->s2 ^ state->s3);
}


/*
 *	Generate some initially weak seeding values to allow
 *	to start the random32() engine.
 */
static int  random32_init(VOID)
{

    struct rnd_state *state = &g_drvRandState;

#define LCG(x)	((x) * 69069)	/* super-duper LCG */
    state->s1 = __seed(LCG(0 + 100), 1);
    state->s2 = __seed(LCG(state->s1), 7);
    state->s3 = __seed(LCG(state->s2), 15);

    /* "warm it up" */
    prandom32(state);
    prandom32(state);
    prandom32(state);
    prandom32(state);
    prandom32(state);
    prandom32(state);
    return 0;
}

/**
 *	random32 - pseudo random number generator
 *
 *	A 32 bit pseudo-random number is generated using a fast
 *	algorithm suitable for simulation. This algorithm is NOT
 *	considered safe for cryptographic use.
 */
static UINT32 s_randomInit;
UINT32 random32(VOID)
{
    UINT32 r;
    struct rnd_state *state = &g_drvRandState;

    if (!s_randomInit)
    {
        random32_init();
        s_randomInit = 1;
    }
    r = prandom32(state);
    return r;
}

