/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	drvs_comm.h
* File Mark:  	
* Description:  comm hal interface declaration.
* Others:  	
* Version:  v1.0
* Author:   zhangyingjun
* Date:      2009-05-26
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  

* History 2: 
**********************************************************************/

#ifndef    _DRVS_COMM_H_
#define    _DRVS_COMM_H_

/**************************************************************************
 *                                                      Include files                                	    *
 **************************************************************************/



 
 
 /**************************************************************************
 *                                                      Macro                                    	            *
 **************************************************************************/



/**************************************************************************
 *                                                      Types                                                      *
 **************************************************************************/
/*the diffrent reset info*/
typedef enum 
{
	RESET_TO_NORMAL,                 /*reset to idle*/
	RESET_TO_CHARGER,                /*reset to charger*/
	RESET_TO_ALRAM,               /*reset to alarm*/
	RESET_TO_EXCEPTRESET,
	MAX_RESET_TYPE,
} T_ZDrvSys_RESET_TYPE;

/*the power on info*/
typedef enum 
{
	POWER_ON_NORMAL = 0,
	POWER_ON_FOTA,
	POWER_ON_CHARGING,
	POWER_ON_RTC,
	POWER_ON_RESET,
	POWER_ON_HDT_TEST,
	POWER_ON_EXCEPTRESET,
	POWER_ON_LOCALUPDATE,
	POWER_ON_BOOST_IN,
	POWER_ON_AMT,
	POWER_ON_PRODUCTION,
	POWER_ON_INVALID,
}T_ZDrvSys_PowerOn_Type;

typedef struct _HAL_COMM_OPT_
{
	SINT32  (*halComm_ShutDown)(VOID);				/*system powerdown Device Initialize Handler*/
	SINT32  (*halComm_Soft_Reset)(T_ZDrvSys_RESET_TYPE reset_type);			/*system reset Handler*/
	T_ZDrvSys_PowerOn_Type (*halComm_Get_PowerOnStat)(VOID);
}HAL_COMM_OPT, *HAL_COMM_OPT_PTR;


/**************************************************************************
 *                           Global  Variable                                                                   *
 **************************************************************************/



/**************************************************************************
 *                                      Function Prototypes                                                  *      
 **************************************************************************/

/*******************************************************************************
 * Function: zDrv_ShutDown
 * Description: shut down the mobile
 * Parameters: 
 *   Input: None
 *   Output: None
 *
 * Returns: 
*	DRV_SUCCESS:success to init
*	DRV_ERROR:fail to init
 * Others: None
 ********************************************************************************/
SINT32 zDrv_ShutDown(VOID);


/*******************************************************************************
 * Function: zDrv_Soft_Reset
 * Description: reset the mobile
 * Parameters: 
 *   Input: None
 *   Output: None
 *
 * Returns: 
*	DRV_SUCCESS:success to reset
*	DRV_ERROR:fail to shutdown
*     others: others error code. for detailed information, please refer to the header file of hal layer
 * Others: None
 ********************************************************************************/
SINT32 zDrv_Soft_Reset(T_ZDrvSys_RESET_TYPE reset_type);

/**************************************************************************
* Function: halChg_SetInstance
* Description: this function used for put semp
* Parameters: 
*   Input:
*              None
*   Outpu: None
* Returns:   
*           None
* Others: None
**************************************************************************/
VOID zDrvComm_SetOperations(HAL_COMM_OPT_PTR CommObjPtr);

/**************************************************************************
* Function: zDrvComm_GetPowerOnState
* Description: get the systerm power on reason.
* Parameters: 
*   Input:
*              None
*   Outpu: None
* Returns:   
*           T_ZDrvSys_PowerOn_Type
* Others: None
**************************************************************************/
T_ZDrvSys_PowerOn_Type zDrvComm_GetPowerOnState(VOID);

#endif    /* HAL_COMM_H */
/*last line of file ends with a newline*/
