/****************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:   
 * File Mark:   
 * Description: 
 * Others:      
 * Version:    
 * Author:      
 * Date:        
 * History 1:   
 *     Date:    
 *     Version: 
 *     Author:  
 *     Modification: 
 * History 2:   
 ****************************************************************************/

/****************************************************************************
 *                          Include files
 ****************************************************************************/
#include    "os_type.h"
#include    "os_pub.h"
#include    "os_list.h"


/****************************************************************************
 *                          Local Macros
 ****************************************************************************/


/****************************************************************************
 *                          Local Types
 ****************************************************************************/


/****************************************************************************
 *                          Local Constants
 ****************************************************************************/


/****************************************************************************
 *                          Local Variables
 ****************************************************************************/


/****************************************************************************
 *                          Local Function Prototypes
 ****************************************************************************/


/****************************************************************************
 *                          Global Constants
 ****************************************************************************/


/****************************************************************************
 *                          Global Variables
 ****************************************************************************/


/****************************************************************************
 *                          Global Function Prototypes
 ****************************************************************************/


/****************************************************************************
 *                          Global Function Definitions
 ****************************************************************************/
/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
VOID tp_os_list_init( OS_LIST *p_list )
{
    //TP_OS_ASSERTExN( NULL != p_list );

    p_list->head  = NULL;
    p_list->tail  = NULL;
    p_list->count = 0;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
VOID tp_os_list_add( OS_LIST *p_list, OS_LIST_NODE *p_node )
{
    //TP_OS_ASSERTExN( (NULL != p_list) && (NULL != p_node) );

    tp_os_list_insert( p_list, p_list->tail, p_node );
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
SINT32 tp_os_list_count( OS_LIST *p_list )
{
    //TP_OS_ASSERTEx( NULL != p_list, -1 );
    
    return p_list->count;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
VOID tp_os_list_delete( OS_LIST *p_list, OS_LIST_NODE *p_node )
{
    //TP_OS_ASSERTExN( (NULL != p_list) && (NULL != p_node) );

    if ( NULL == p_node->previous )
    {
        p_list->head = p_node->next;
    }
    else
    {
        p_node->previous->next = p_node->next;
    }

    if ( NULL == p_node->next )
    {
        p_list->tail = p_node->previous;
    }
    else
    {
        p_node->next->previous = p_node->previous;
    }

    p_list->count--;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
OS_LIST_NODE *tp_os_list_first( OS_LIST *p_list )
{
    //TP_OS_ASSERTEx( NULL != p_list, NULL );

    return p_list->head;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
VOID tp_os_list_insert( OS_LIST *p_list, OS_LIST_NODE *p_prev, OS_LIST_NODE *p_node )
{
    OS_LIST_NODE *p_next = NULL;

    //TP_OS_ASSERTExN( NULL != p_list );

    if ( NULL == p_prev )
    {
        p_next = p_list->head;
        p_list->head = p_node;
    }
    else
    {
        p_next = p_prev->next;
        p_prev->next = p_node;
    }

    if ( NULL == p_next )
    {
        p_list->tail = p_node;
    }
    else
    {
        p_next->previous = p_node;
    }

    p_node->next     = p_next;
    p_node->previous = p_prev;

    p_list->count++;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
OS_LIST_NODE *tp_os_list_last( OS_LIST *p_list )
{
    //TP_OS_ASSERTEx( NULL != p_list, NULL );

    return p_list->tail;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
OS_LIST_NODE *tp_os_list_next( OS_LIST_NODE *p_node )
{
    //TP_OS_ASSERTEx( NULL != p_node, NULL );

    return p_node->next;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
OS_LIST_NODE *tp_os_list_previous( OS_LIST_NODE *p_node )
{
    //TP_OS_ASSERTEx( NULL != p_node, NULL );

    return p_node->previous;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
OS_LIST_NODE *tp_os_list_nstep( OS_LIST_NODE *p_node, SINT32 nstep )
{
    int i;

    //TP_OS_ASSERTEx( NULL != p_node, NULL );

    for ( i=0; i<abs(nstep); i++ )
    {
        if ( nstep < 0 )
        {
            p_node = p_node->previous;
        }
        else if ( nstep > 0 )
        {
            p_node = p_node->next;
        }
        
        if ( NULL == p_node )
        {
            break;
        }
    }
    
    return p_node;
}

/****************************************************************************
 * Function:    
 * Description: 
 * Parameters:  
 *   Input:     
 *              
 *   Output:    
 *              
 * Returns:     
 *              
 *              
 * Others:      
 ****************************************************************************/
SINT32 tp_os_list_find( OS_LIST *p_list, OS_LIST_NODE *p_node )
{
    OS_LIST_NODE *p_next = NULL;
    int index = 1;

    //TP_OS_ASSERTEx( ((NULL != p_list) && (NULL != p_node)), -1 );

    p_next = tp_os_list_first( p_list );
    while ( (NULL != p_next) && (p_node != p_next) )
    {
        index++;
        p_next = tp_os_list_next( p_next );
    }

    if ( NULL == p_next )
    {
        return -1;
    }
    else
    {
        return index;
    }
}

