/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   ƵŲģ
* ļƣ zte_audio.h
* ļʶ 
* ժҪ 
*
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/3/25    1.0                        Է                        
************************************************************************/
#ifndef ZTE_AUDIO_H_EX
#define ZTE_AUDIO_H_EX

#ifdef __cplusplus
   extern "C"
   {
#endif 
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/

/**************************************************************************
 *                                                                    *
 **************************************************************************/

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/

/**************************************************************************
 *                                                                *
 **************************************************************************/
typedef enum
{
    AUDIO_NO_ERROR,       /*!<Operation success.*/
    AUDIO_LINKLIST_NULL,    /*!<The link list is null.*/
    AUDIO_UNOPENED_HANDLE,  /*!<This handle has not been opened.*/
    AUDIO_PLAYING,  /*!<This audio is being played.*/
    AUDIO_PAUSING, /*!<This audio has been paused.*/
    AUDIO_NOT_PAUSING, /*!<This audio has not been paused.*/
    AUDIO_HANDLE_IS_INVALID,    /*!<The handle is invalid.*/
    AUDIO_HANDLE_NOT_EXIST,     /*!<This handle is not exist.*/
    AUDIO_FILE_ERROR,   /*!<The file operation is error.*/
    AUDIO_FORMAT_ERROR, /*!<Audio format can't be supported.*/
    AUDIO_MULTI_STOP,   /*!<The destination audio has been stopped.*/
    AUDIO_ERROR_MODULE_HANDLE, /*!<This handle's module type is unconformity.*/
    AUDIO_ERROR_HANDLE_TYPE,   /*!<This handle's handle type is unconformity.*/
    AUDIO_ERROR_SUB_HANDLE_TYPE,/*!<This handle's sub-handle typeis unconformity.*/
    AUDIO_NO_ENOUGH_MEMORY,     /*!<System can't provide enough memory space.*/
    AUDIO_CONFLICT,     /*!<Audio play conflict.*/
    AUDIO_NO_OPERATION,     /*!<Don't exist this operation.*/
    AUDIO_NO_CODECHANDLE,   /*!<Codec handle is not exist.*/
    AUDIO_VB_TRACK_FULL,    /*!<Voiceband track number is full.*/
    AUDIO_PARAM_ERROR,  /*!<Parameter error.*/
    AUDIO_CM_OPERATION_FAILURE, /*!<Collision management operation failure.*/
    AUDIO_CM_CAN_PLAY,  /*!<Collision arbitration pass. */
    AUDIO_CM_CANNOT_PLAY,   /*!<Collision arbitration reject.*/
    AUDIO_CM_PARA_ERROR, /*!<Collision management operation parameter error.*/
    AUDIO_PM_NO_EXT_OPE_SYMBOL, /*!<This extend operation symbol is not exist.*/
    AUDIO_NO_EXPHANDLE,    /*!<This handle is not exist.*/
    AUDIO_INVALID_GAIN,     /*!<The digital gain from codec is invalid.*/    
    AUDIO_ERROR = 0xFF /*!<General ERROR.*/
}AUDIO_RESULT_E;

typedef struct _DD_AUDIO_3DEFFECT_
{
        UINT16 setbass;
        UINT16 setsurr;
}DD_AUDIO_3DEFFECT;

typedef enum _AUDIO_EQMODE_
{
    EQMODE_NORMAL=0,
    EQMODE_CLASSIC,
    EQMODE_POP,
    EQMODE_JAZZ,
    EQMODE_ROCK
}AUDIO_EQMODE_E;

typedef enum _DD_AUDIO_EQMODE_
{
    AUD_EQ_NORMAL=0,
    AUD_EQ_CLASSIC,
    AUD_EQ_POP,
    AUD_EQ_JAZZ,
    AUD_EQ_ROCK,
    AUD_EQ_BALLAD,
    AUD_EQ_LIVE,
    AUD_EQ_USER,
    AUD_EQ_DANCE,
    AUD_EQ_COUNTRY,
    AUD_EQ_BASS
}DD_AUDIO_EQMODE;

typedef struct MP3_tag_id3 
{
    char tag[4];                            // "TAG"                3 bytes
    char title[32];                         // MP3ļ  30bytes
    char artist[32];                        // MP3              30bytes
    char album[32];                         // MP3 Ƭ   30bytes
    char year[5];                           // Ʒʱ             4bytes
    char comment[32];                       //                  30bytes
    char genre[32];                         //              1bytes
} MP3_ID3_TAG_T;

typedef struct _DD_audio_IOCTL_
{
    #ifdef A2KP_DT_LEMANS
    UINT8               volume;
    UINT16              playTimes;        
    const char          *filename; 
    UINT8               *file_ptr;
    UINT32              file_size;   
    UINT32              file_type;   
    UINT32              crescendo;
    UINT8               path; 
    UINT8               keyNum;
    UINT32              totaltime;                 
    UINT32              end_flag;
    UINT32              seek;
    UINT32              position;
    UINT8               powerCtlMode;
    DD_AUDIO_3DEFFECT   Audio3DEffect;   
    UINT16              AudioSAMode;
    DD_AUDIO_EQMODE     eq_mode;
    VOID*               reserve_param;
    #else
    UINT8               volume;
    UINT16              playTimes;
    const char          *filename;
    UINT8               *file_ptr;
    UINT32              file_size;
    UINT32              file_type;
    UINT32              crescendo;
    UINT8               path;
    UINT8               keyNum;
    UINT32              totaltime;
    UINT32              uSampleRate;
    UINT32              end_flag;
    SINT32              seek;
    UINT32              position;
    UINT8               powerCtlMode;
    UINT8               u3DEffectEnable;
    DD_AUDIO_3DEFFECT   Audio3DEffect;
    AUDIO_EQMODE_E      AudioEqMode;
    UINT16              AudioSAMode;
    DD_AUDIO_EQMODE     eq_mode;
    MP3_ID3_TAG_T       audio_info;
    UINT8               keytone_id;
    VOID*               reserve_param;
    #endif
} DD_AUDIO_IOCTL;
typedef DD_AUDIO_IOCTL  *FILE_HANDLE;

typedef enum
{
    AUDIO_FILE_TYPE_MP3,
    AUDIO_FILE_TYPE_MP4A,
    AUDIO_FILE_TYPE_AMR,
    AUDIO_FILE_TYPE_G723,
    AUDIO_FILE_TYPE_AAC,
    AUDIO_FILE_TYPE_OGG,
    AUDIO_FILE_TYPE_MIDI,
    AUDIO_FILE_TYPE_RA,
    AUDIO_FILE_TYPE_WAV,
    AUDIO_FILE_TYPE_WMA,
    AUDIO_FILE_TYPE_PCM,
    AUDIO_FILE_TYPE_UNKNOWN
}AUDIO_FILE_TYPE_E;

typedef enum
{
    DD_AUDIO_FILE_TYPE_MP3,
    DD_AUDIO_FILE_TYPE_MP4A,
    DD_AUDIO_FILE_TYPE_AMR,
    DD_AUDIO_FILE_TYPE_G723,
    DD_AUDIO_FILE_TYPE_AAC,
    DD_AUDIO_FILE_TYPE_OGG,
    DD_AUDIO_FILE_TYPE_MIDI,
    DD_AUDIO_FILE_TYPE_RA,
    DD_AUDIO_FILE_TYPE_WAV,
    DD_AUDIO_FILE_TYPE_WMA,
    DD_AUDIO_FILE_TYPE_PCM,
    DD_AUDIO_FILE_TYPE_UNKNOWN
}DD_AUDIO_FILE_TYPE_E;

typedef struct AUDIO_Fileinfo_struct
{    
    SINT32 audio_total_time;    /*!<File total time*/
    UINT32 uiSampleRate;    /*!<Audio file's samplerate*/
}AUDIO_FILEINFO_T;

typedef enum
{
    dd_volume_lev_0,
    dd_volume_lev_1,
    dd_volume_lev_2,
    dd_volume_lev_3,
    dd_volume_lev_4,
    dd_volume_lev_5,        
}VOLUME_DD_level;

typedef enum
{
    DD_RECEIVER = 1,
    DD_SPEAKER,
    DD_HEADPHONE,
    DD_SPEAKER_AND_HEADPHONE,
    DD_BLUETOOTH_PHONE,     
}DD_CODEC_PATHOUT;

typedef struct
{
    VOLUME_DD_level   volume;      /* ,֧5 */
    DD_CODEC_PATHOUT  channel;     /* ͨ */
    BYTE              iFreq;       /* Ƶ,ֵӦ0-4000֮(0)*/
    DWORD             duration;    /* ʱ, msΪλ */
}AUDIO_TONE_PARAM;

 /**************************************************************************
 *                          CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                         ģ  CԵͷļɲü            *
 **************************************************************************/

/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/

/**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/ 
/**
 * ƣ Audio_Init 
 *  Ƶųʼ
 * ˵ (IN) 
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Init(void);

/**
 * ƣ Audio_Release 
 *  Ƶͷ
 * ˵ (IN) 
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Release(void);

/**
 * ƣ Audio_Open_File 
 *  Ƶģ(ļ)
 * ˵ (IN)filename Ƶļȫ·
 *   ֵ ɹƵļʧܷЧ
 * ˵ 
 */
FILE_HANDLE Audio_Open_File(UINT8 *filename);

/**
 * ƣ Audio_Open_Buffer 
 *  Ƶģ(Buffer)
 * ˵ (IN)buffer_ptr ƵݴŻָ
                  buffer_size: ݴС
                  data_type:   Ƶݸʽ
 *   ֵ ɹƵļʧܷЧ
 * ˵ 
 */
FILE_HANDLE Audio_Open_Buffer(UINT8* buffer_ptr,UINT32 buffer_size, DD_AUDIO_FILE_TYPE_E data_type);

/**
 * ƣ Audio_Close_EX 
 *  رƵģ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E  Audio_Close_EX(FILE_HANDLE handle);

/**
 * ƣ PLAYER_AUDIO_StartPlay 
 *  ʼƵ
 * ˵ (IN)handle Ƶž
                  offset:  ʼλ
                  play_times: Ŵ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E PLAYER_AUDIO_StartPlay(FILE_HANDLE handle, UINT32 offset, UINT16 play_times);

/**
 * ƣ Audio_StopPlay 
 *  ֹͣƵ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_StopPlay(FILE_HANDLE handle);

/**
 * ƣ Audio_PausePlay 
 *  ͣƵ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_PausePlay(FILE_HANDLE handle);

/**
 * ƣ Audio_ResumePlay 
 *  ָƵ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_ResumePlay(FILE_HANDLE handle);

/**
 * ƣ Audio_GetCurTime 
 *  ȡƵǰʱ
 * ˵ (IN)handle Ƶž
              (OUT)curtime: 浱ǰʱ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_GetCurTime(FILE_HANDLE handle ,SINT32*curtime);

/**
 * ƣ Audio_GetTotalTime 
 *  ȡƵʱ
 * ˵ (IN)handle Ƶž
              (OUT)total_time: 沥ʱ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_GetTotalTime(FILE_HANDLE handle, SINT32*total_time);

/**
 * ƣ Audio_Seek 
 *  Ƶļضλ
 * ˵ (IN)handle Ƶž
                  offset:  ¶λλ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ ˽ӿھΪӵǰλÿʼλӿʼλôʼλѾϲ˴
 */
AUDIO_RESULT_E Audio_Seek(FILE_HANDLE handle, SINT32 offset);

/**
 * ƣ Audio_GetFileInfo 
 *  ȡƵļϢ
 * ˵ (IN)handle Ƶž
              (OUT)info: ļϢ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_GetFileInfo(FILE_HANDLE handle, AUDIO_FILEINFO_T *info);

/**
 * ƣ Audio_Mute 
 *  ƵǷ
 * ˵ (IN)handle     Ƶž
                  enable_mute: Ƿ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Mute(FILE_HANDLE handle, BOOL  enable_mute);

/**
 * ƣ Audio_Volume_Get 
 *  ȡƵ
 * ˵ (IN)handle     Ƶž
              (OUT)Volume_level: ŵǰƵļ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E  Audio_Volume_Get(FILE_HANDLE handle, VOLUME_DD_level *Volume_level);

/**
 * ƣ Audio_Volume_Set 
 *  Ƶ
 * ˵ (IN)handle     Ƶž
                  volumn_level: Ƶ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Volume_Set(FILE_HANDLE handle, VOLUME_DD_level volume_level);

/**
 * ƣ Audio_ChannelOut_Get 
 *  ȡƵͨ
 * ˵ (IN)handle   Ƶž
              (OUT)pchannel: ŵǰƵͨ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_ChannelOut_Get(FILE_HANDLE handle,UINT8 *pchannel);

/**
 * ƣ Audio_ChannelOut_Set 
 *  Ƶͨ
 * ˵ (IN)handle Ƶž
                  channel: Ƶͨ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_ChannelOut_Set(FILE_HANDLE handle, DD_CODEC_PATHOUT channel);

/**
 * ƣ Audio_Open_Tone 
 *  Tone豸
 * ˵ (IN)
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Open_Tone(VOID);

/**
 * ƣ Audio_Play_Tone 
 *  Tone
 * ˵ (IN)AUDIO_TONE_PARAM ToneŲ
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Play_Tone(AUDIO_TONE_PARAM *ptParam);

/**
 * ƣ Audio_Stop_Tone 
 *  ֹͣTone
 * ˵ (IN)
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Stop_Tone(VOID);

/**
 * ƣ Audio_Close_Tone 
 *  رTone
 * ˵ (IN)
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Close_Tone(VOID);

#ifdef __cplusplus
   } 
#endif

#endif

