/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    ap_intf.h
 * File Mark:
 * Description:  Provide audio processing interface for driver
 * Others:
 * Version:       V0.1
 * Author:
 * Date:
 * History 1:
 *     Date: 2019/01/15
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _AP_INTF_H
#define _AP_INTF_H


/****************************************************************************
*                                             Include files
****************************************************************************/
//#include "NvParam_drv.h"
#include "typedefs.h"
#include "drvs_voiceprocess.h"
#include "drvs_ramlog.h"
/****************************************************************************
*                                             Macros
****************************************************************************/
#define USE_WEBRTC_NSX
//6 level volume

#define FB_STATE_SIZE_WORD32                    6

/* number of samples per 10ms frame */
#define FRAMESAMPLES_10ms                       160      /* ((10*FS)/1000) */

//voice path
#define PARAM_PATH_MAX     20       // 2g 4 path ;3g nb 4 path;3g wb 4 path;4g nb 4 path;4g wb 4 path;

#define VP_TX_PARAM_SIZE     84
#define VP_RX_PARAM_SIZE    72
#define VP_PATH_PARAM_SIZE   156  //VP_TX_PARAM_SIZE+VP_RX_PARAM_SIZE

#define VP_MODE_PATH_PARAM_SIZE  4 * VP_PATH_PARAM_SIZE
/****************************************************************************
*                                             Types
****************************************************************************/

typedef enum
{

    HANDSET_2G_TX,
    HANDSET_2G_RX,
    HANDFREE_2G_TX,
    HANDFREE_2G_RX,
    HEADSET_2G_TX,
    HEADSET_2G_RX,
    BT_2G_TX,
    BT_2G_RX,

    HANDSET_3G_NB_TX,
    HANDSET_3G_NB_RX,
    HANDFREE_3G_NB_TX,
    HANDFREE_3G_NB_RX,
    HEADSET_3G_NB_TX,
    HEADSET_3G_NB_RX,
    BT_3G_NB_TX,
    BT_3G_NB_RX,

    HANDSET_3G_WB_TX,
    HANDSET_3G_WB_RX,
    HANDFREE_3G_WB_TX,
    HANDFREE_3G_WB_RX,
    HEADSET_3G_WB_TX,
    HEADSET_3G_WB_RX,
    BT_3G_WB_TX,
    BT_3G_WB_RX,

    HANDSET_4G_NB_TX,
    HANDSET_4G_NB_RX,
    HANDFREE_4G_NB_TX,
    HANDFREE_4G_NB_RX,
    HEADSET_4G_NB_TX,
    HEADSET_4G_NB_RX,
    BT_4G_NB_TX,
    BT_4G_NB_RX,

    HANDSET_4G_WB_TX,
    HANDSET_4G_WB_RX,
    HANDFREE_4G_WB_TX,
    HANDFREE_4G_WB_RX,
    HEADSET_4G_WB_TX,
    HEADSET_4G_WB_RX,
    BT_4G_WB_TX,
    BT_4G_WB_RX,

    MAX_VP_PARAM_PATH
} T_Vp_Param_Path;

typedef struct
{

	T_Vp_Param_Path ppath;
	unsigned short offset;
	unsigned short  size;

} T_Vp_Path_Info;


typedef struct
{

	int agc_on;// 0 off, 1 on
	unsigned short agcMode;	//0 unchanged;1 adaptive analog ;2 adaptive digital kAgcModeAdaptiveDigital;3 fixed digital  kAgcModeFixedDigital
	unsigned short padding;// for align 4
	int minLevel ;
	int maxLevel;
	int targetLevelDbfs;   // default 3 (-3 dBOv)
	int compressionGaindB; // default 9 dB
	int limiterEnable;     // default kAgcTrue (on)


} T_Wrtc_Agc_Para;

typedef struct
{
	int aecm_on;// 0 off, 1 on
	int handset_echodelay_ms;
	unsigned short echoCngMode;            // AECM_FALSE, AECM_TRUE (default)	    AecmFalse = 0,    AecmTrue =1
	unsigned short echoMode;// 0, 1, 2, 3 (default), 4

} T_Wrtc_Aec_Para;
typedef struct
{
	int ns_on;// 0 off, 1 on
	int nsMode;	//0/1/2/3


} T_Wrtc_Ns_Para;

typedef struct
{
	int vol_on;// 0 off, 1 on
	//   float vol[6];
	int vol[6];
} T_Wrtc_Vol_Para;

/****************************************************************************
*                                             Types
****************************************************************************/


typedef struct
{
	int fs;//frequency of sampling
	int rx_on;// 0 off, 1 on

	T_Wrtc_Ns_Para rx_nspara;

	T_Wrtc_Agc_Para rx_agcpara;

	T_Wrtc_Vol_Para rx_volpara;


} T_Webrtc_RxProcPara;


typedef struct
{
	int fs;//frequency of sampling
	int tx_on;// 0 off, 1 on
	T_Wrtc_Ns_Para tx_nspara;

	T_Wrtc_Aec_Para aecpara;

	T_Wrtc_Agc_Para tx_agcpara;

	T_Wrtc_Vol_Para tx_volpara;


} T_Webrtc_TxProcPara;

typedef struct
{
	T_Webrtc_TxProcPara tx_procpara;
	T_Webrtc_RxProcPara rx_procpara;

} T_Webrtc_ProcPara;




typedef struct
{


	int fs;//frequency of sampling
	int tx_on;// 0 off, 1 on
	int txns_on;// 0 off, 1 on
	int aecm_on;// 0 off, 1 on
	int txagc_on;// 0 off, 1 on
	int txvol_on;// 0 off, 1 on

	int rx_on;// 0 off, 1 on
	int rxns_on;// 0 off, 1 on
	int rxagc_on;// 0 off, 1 on
	int rxvol_on;// 0 off, 1 on

	int txvol;// tx volume
	int rxvol;// rx volume



	void *txnsInst;
	void *aecmInst;
	void *txagcInst;

	void *rxnsInst;
	void *rxagcInst;

	void *external_echo_path_;
	void *mode_path_param;
	void *ptx_procpara;
	void *prx_procpara;

	T_ZDrvVoice_MODE voiceMode;
	T_ZDrv_VpPath path;

	int open_flag;// 0 close, 1 open
	int mute_flag;//0 unmute, 1 mute
	int rx_mute_flag;//0 unmute, 1 mute		
} T_Webrtc_Para;






typedef struct
{
	WebRtc_Word32  analysisFBState1[FB_STATE_SIZE_WORD32];
	WebRtc_Word32  analysisFBState2[FB_STATE_SIZE_WORD32];
	WebRtc_Word16  speechInLB[FRAMESAMPLES_10ms];
	WebRtc_Word16  speechInUB[FRAMESAMPLES_10ms];

} T_Ns_Data;

/****************************************************************************
*                                             Constants
****************************************************************************/

/****************************************************************************
*                                             Global  Variables
****************************************************************************/

/****************************************************************************
*                                             Function Prototypes
****************************************************************************/
SINT32 Webrtc_InitParam(VOID);
SINT32 Webrtc_Open(UINT32 fs);
SINT32 Webrtc_Close(VOID);
SINT32 Webrtc_SetParam(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path);
SINT32 Webrtc_RxProcess(UINT8 **pinBuffer, UINT8 **poutBuffer, UINT16 sampleNums);
SINT32 Webrtc_TxProcess(UINT8 **pinBuffer_MAIN, UINT8 **pinBuffer_AUX, UINT8 **poutBuffer, UINT16 sampleNums);
SINT32 Webrtc_GetParam(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path);
SINT32 Webrtc_SetTxParam(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path);
SINT32 Webrtc_SetRxParam(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path);
SINT32 Webrtc_SetVol(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path, int vol);
SINT32 Webrtc_SetMute(int mute);
SINT32 Webrtc_SetParamTool(T_ZDrv_VpPath path, T_ZDrv_VpVol volume, zDrvVp_ParamsTool *paramsTool,   BOOL isLoop, BOOL isVolte);
SINT32 Webrtc_GetParamTool(T_ZDrv_VpPath path, T_ZDrv_VpVol volume, zDrvVp_ParamsTool *paramsTool, BOOL isLoop, BOOL isVolte);
SINT32 Webrtc_SetNvParamTool(T_ZDrv_VpPath path, T_ZDrv_VpVol volume, zDrvVp_ParamsTool *paramsTool,   BOOL isLoop, BOOL isVolte);
SINT32 Webrtc_GetNvParamTool(T_ZDrv_VpPath path, T_ZDrv_VpVol volume, zDrvVp_ParamsTool *paramsTool, BOOL isLoop, BOOL isVolte);

#endif/*_AP_INTF_H*/

