/**
 * 
 * @file      AudioExport.h
 * @brief     
 *            This file is part of ZCAT.
 *            ZCATƵݵģӿڶ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2016/12/13  1.0      hou.bing       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef AUDIO_EXPORT_H
#define AUDIO_EXPORT_H

typedef struct
{
	UINT32 rxIn_Addr;
	UINT32 rxOut_Addr;
	UINT32 txIn_Addr;
	UINT32 txOut_Addr;
	UINT32 rxIn_Len;
	UINT32 rxOut_Len;
	UINT32 txIn_Len;
	UINT32 txOut_Len;
}T_ZCAT_AUDIO_MEM_PARAM;


typedef enum
{
    ZCAT_AUDIO_PS_BASE   = 0,
    ZCAT_AUDIO_PS_DL     = 1,
    ZCAT_AUDIO_PS_UL     = 2,
    ZCAT_AUDIO_PS_SYNC   = 3,
    ZCAT_AUDIO_PS_TMP    = 4,
    ZCAT_AUDIO_PS_END    = 10,
    
    ZCAT_AUDOI_DRV_BASE  = 10,
    ZCAT_AUDIO_DRV_RXIN  = 11,
    ZCAT_AUDIO_DRV_RXOUT = 12,
    ZCAT_AUDIO_DRV_TXIN  = 13,
    ZCAT_AUDIO_DRV_TXOUT = 14,
    ZCAT_AUDIO_DRV_END   = 20

} T_ZCAT_AUDIO_MEM_TYPE;


/**
 * @brief Ƶݵ
 * @param[in] buf ָ
 * @param[in] buf 泤
 * @return void
 * @note
 * @see 
 */
VOID zCatAgt_Audio_Export_ProcessMsg(VOID *buf, UINT32 len);

/**
 * @brief Ƶݵעắ
 * @param[in] type 
 * @param[in] size С
 * @param[in] addr ַ
 * @return ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
 * @note
 * @see 
 */
UINT32 zCatAgt_Audio_Reg(UINT32 type, UINT32 size, UINT32 addr);

/**
 * @brief Ƶݵʼ
 * @param[in] void
 * @return ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
 * @note
 * @see 
 */
UINT32 zCatAgt_Audio_Export_Init(VOID);

/**
 * @brief Ƶļ \n
          ԭй̶Ƶļַ޸ģֶ֧̬Ƶļַ
 * @param[in] ptParam Ƶļ
 * @return void
 * @note
 * @see 
 */
VOID zCatAgt_SetAudioFileInfo(T_ZCAT_AUDIO_MEM_PARAM* ptParam);

#endif
