/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98_VSIM
*    : sup_vsim.c
* ļ : 
* ʵֹ : vsimݹӿ
*      : 
*      : V1.0
*  : 2016-08-06
* ˵ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "drv_api.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define VSIM_OP_MEM           0x01  /* VSIMڴģʽ   */
#define VSIM_OP_FLASH         0x02  /* VSIM FLASHģʽ */

#define VSIM_SYMBOL_DOWNLOAD  0xA2  /* 汾ر־λ */
#define VSIM_SYMBOL_NORMAL    0xB3  /* ־λ     */
#define VSIM_SYMBOL_WRITE     0xC4  /* дݱ־λ   */
#define VSIM_SYMBOL_MEM       0xD5  /* VSIM ڴģʽ  */

#define VSIM_WORK_AREA        0x01  /* ʶ         */
#define VSIM_BACKUP_AREA      0x02  /* ʶ         */
#define VSIM_BOTH_AREA        0x03  /* ͱʶ */

/**************************************************************************
* ⲿ
**************************************************************************/
extern UINT8  zOss_GetVsimSupport(VOID);
extern VOID zOss_vSIMAgtInit(VOID);
extern SINT32 zDrvNand_SimNvRead(UINT32 dwStart, UINT32 dwLen, UINT8* to);
extern SINT32 zDrvNand_SimNvProgram(UINT32 dwStart, UINT32 dwLen, UINT8* from);
extern SINT32 zDrvNand_SimNvFacRead(UINT32 dwStart, UINT32 dwLen, UINT8* to);
extern SINT32 zDrvNand_SimNvFacProgram(UINT32 dwStart, UINT32 dwLen, UINT8* from);

/**************************************************************************
* ֲԭ
**************************************************************************/
static UINT32 vSIM_Resume_Data(UINT8 index);
static VOID vSIM_Fill_Factory(VOID);
static BOOL vSIM_Check_Data(VOID);
static SINT32 vSIM_ReadWithNoReset(UINT32 dwStart, UINT32 dwLen, UINT8* to);

/**************************************************************************
* ȫֳ/
**************************************************************************/
static BOOL             gvSIM_Inited   = FALSE;
static BOOL             gvSIM_OP_MODE  = VSIM_OP_FLASH;
static BOOL             gvSIM_InResume = FALSE;         /* vSIMָ */
static VOID             *gvSIM_FacMem  = NULL;
static ZOSS_MUTEX_ID    gvSIM_Mutex    = ZOSS_NULL;
static T_vSIM_PARAM     *gpvSIM_Param  = NULL;

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* ƣ VSIM_Init
*  VSIMʼ
* ˵ 
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_vSIMInit(VOID)
{
#if 0
    T_OSS_PARAM *pOssParam = NULL;

    if (!zOss_GetVsimSupport())
    {
        return ZOSS_SUCCESS;
    }
    
    if (gvSIM_Inited)
    {
        return ZOSS_SUCCESS;
    }

    pOssParam    = zOss_GetOssCfg();
    gpvSIM_Param = &(pOssParam->vSIMCfg);

    if (!vSIM_Check_Data())
    {
        return ZOSS_ERROR;
    }

    gvSIM_Mutex = zOss_CreateMutex("vSIM_Mutex", ZOSS_INHERIT);
    if (gvSIM_Mutex == NULL)
    {
        return ZOSS_ERROR;
    }

#ifdef _USE_VSIM_AGT
    zOss_vSIMAgtInit();
#endif

    gvSIM_Inited = TRUE;

    return ZOSS_SUCCESS;
#else
	return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣ zOss_vSIMDataRead
*  ȡָvSIM
* ˵ (IN)
*            addr:  ƫƵַ
*            data:  ݴ洢ռ
*            len:   ȡݵĳ,λֽ;
*            (OUT)
*   ֵ ɹZOSS_SUCCESS
* ˵
**************************************************************************/
UINT32 zOss_vSIMDataRead(UINT32 addr, VOID *data, UINT32 len)
{
#if 0
    SINT32  status = -1;

    zOss_AssertEx(gvSIM_Inited, ZOSS_ERROR);
    zOss_AssertEx(addr >= gpvSIM_Param->Work_Area_Base_Addr
                  && len  <= gpvSIM_Param->Area_Size
                  && addr + len <= gpvSIM_Param->Work_Area_Base_Addr + gpvSIM_Param->Area_Size,
                  ZOSS_ERROR);

    zOss_GetMutex(gvSIM_Mutex, ZOSS_WAIT_FOREVER);

    if(VSIM_OP_MEM == gvSIM_OP_MODE)
    {
        if(!gvSIM_FacMem)
        {
            zOss_PutMutex(gvSIM_Mutex);
            return ZOSS_ERROR;
        }
        zOss_Memcpy(data, (VOID *)((UINT8 *)gvSIM_FacMem + addr), len);
        status = 0;
    }
    else
    {
        status = zDrvNand_SimNvRead(gpvSIM_Param->Work_Area_Base_Addr + addr, len, data);
    }


    zOss_PutMutex(gvSIM_Mutex);

    return (status == 0) ? ZOSS_SUCCESS : ZOSS_ERROR;
#else
    zOss_AssertEx(0, ZOSS_ERROR);
    return ZOSS_ERROR;
#endif
}

/**************************************************************************
* ƣ zOss_vSIMDataWrite
*  дָvSIM
* ˵ (IN)
*            addr:  ַ
*            data:  Դռ
*            len:   дݵĳ,λֽ;
*            (OUT)
*   ֵ ɹZOSS_SUCCESS
* ˵
**************************************************************************/
UINT32 zOss_vSIMDataWrite(UINT32 addr, VOID *data, UINT32 len)
{
#if 0
    UINT8   symbol = VSIM_SYMBOL_WRITE;
    SINT32  status = -1;

    zOss_AssertEx(gvSIM_Inited, ZOSS_ERROR);
    zOss_AssertEx(addr >= gpvSIM_Param->Work_Area_Base_Addr
                  && len  <= gpvSIM_Param->Area_Size
                  && addr + len <= gpvSIM_Param->Work_Area_Base_Addr + gpvSIM_Param->Area_Size,
                  ZOSS_ERROR);

    zOss_GetMutex(gvSIM_Mutex, ZOSS_WAIT_FOREVER);

    if(VSIM_OP_MEM == gvSIM_OP_MODE)
    {
        if(!gvSIM_FacMem)
        {
            zOss_PutMutex(gvSIM_Mutex);
            return ZOSS_ERROR;
        }
        zOss_Memcpy((VOID *)((UINT8 *)gvSIM_FacMem + addr), data, len);
        status = 0;
    }
    else
    {
        do
        {
            /* д */
            symbol = VSIM_SYMBOL_WRITE;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }

            status    = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Base_Addr + addr, len, data);
            if (status != 0)
            {
                break;
            }

            symbol = VSIM_SYMBOL_NORMAL;
            status    = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }

            /* д */
            symbol = VSIM_SYMBOL_WRITE;
            status    = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }

            status    = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Base_Addr + addr, len, data);
            if (status != 0)
            {
                break;
            }

            symbol = VSIM_SYMBOL_NORMAL;
            status    = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
        }while(0);
    }

    zOss_PutMutex(gvSIM_Mutex);

    return (status == 0) ? ZOSS_SUCCESS : ZOSS_ERROR;
#else
    zOss_AssertEx(0, ZOSS_ERROR);
    return ZOSS_ERROR;
#endif
}

/**************************************************************************
* ƣ zOss_vSIMFacWrite
*  дvSIMȫ
* ˵ (IN)
*            data:  ݴ洢ռ
*            len:   ȡݵĳ,λֽ;
*            (OUT)
*   ֵ ɹZOSS_SUCCESS
* ˵
**************************************************************************/
UINT32 zOss_vSIMFacWrite(VOID *data, UINT32 len)
{
#if 0
    UINT8   symbol = VSIM_SYMBOL_WRITE;
    SINT32  status = -1;

    zOss_AssertEx(gvSIM_Inited && gpvSIM_Param->Area_Size >= len, ZOSS_ERROR);

    if(VSIM_OP_MEM == gvSIM_OP_MODE)
    {
        zOss_AssertEx(!gvSIM_FacMem, ZOSS_ERROR);
        gvSIM_FacMem = zOss_Malloc(len);
        if(NULL == gvSIM_FacMem)
        {
            return ZOSS_ERROR;
        }
        zOss_Memcpy(gvSIM_FacMem, data, len);
        status = 0;
    }
    else
    {
        do
        {
            symbol = VSIM_SYMBOL_WRITE;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }

            status = zDrvNand_SimNvFacProgram(gpvSIM_Param->Factory_Area_Base_Addr, len, data);
            if(status != 0)
            {
                break;
            }

            symbol = VSIM_SYMBOL_DOWNLOAD;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &symbol);
            if(status != 0)
            {
                break;
            }
        }while(0);
    }
    
    return (status == 0) ? ZOSS_SUCCESS : ZOSS_ERROR;
#else
    zOss_AssertEx(0, ZOSS_ERROR);
    return ZOSS_ERROR;
#endif
}

/**************************************************************************
* ƣ zOss_vSIMRecovery
*  ӳָݵͱ
* ˵ (IN)
*            (OUT)
*   ֵ ɹZOSS_SUCCESS
* ˵ Ч
**************************************************************************/
UINT32 zOss_vSIMRecovery(VOID)
{
#if 0
    UINT8 symbol = VSIM_SYMBOL_DOWNLOAD;
    
    if(gvSIM_OP_MODE == VSIM_OP_MEM)
        return ZOSS_ERROR;

    return zDrvNand_SimNvProgram(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &symbol) == DRV_SUCCESS ? ZOSS_SUCCESS : ZOSS_ERROR;
#else
    zOss_AssertEx(0, ZOSS_ERROR);
    return ZOSS_ERROR;
#endif
}

/**************************************************************************
* ƣ zOss_vSIMSetErrorAddr
*  ݳĵַռ,öӦı־λ,Աָ,nandıλת
* ˵ addr:߼ַ
*   ֵ 
* ˵ vSIMECCʱ
**************************************************************************/
VOID zOss_vSIMSetErrorAddr(UINT32 addr)
{
#if 0
    UINT8  symbol   = VSIM_SYMBOL_WRITE;
    UINT32 rw_start = 0;
    UINT32 bk_start = 0;
    UINT32 rw_end   = 0;
    UINT32 bk_end   = 0;

    rw_start = gpvSIM_Param->Work_Area_Base_Addr;
    bk_start = gpvSIM_Param->Backup_Area_Base_Addr;
    rw_end   = rw_start + gpvSIM_Param->Area_Size - 1;
    bk_end   = bk_start + gpvSIM_Param->Area_Size - 1;

    gvSIM_InResume = TRUE;
    if(addr >= rw_start && addr <= rw_end)
    {
        zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
    }
    else if(addr >= bk_start && addr <= bk_end)
    {
        zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
    }
    else
    {
        zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr,   1, &symbol);
        zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
        symbol = VSIM_SYMBOL_DOWNLOAD;
        zDrvNand_SimNvProgram(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &symbol);
    }
    gvSIM_InResume = FALSE;
    return;
#else
    return;	
#endif
}

/**************************************************************************
* ƣ zOss_vSIMInResume
*  Ƿڻָ
* ˵ 
*   ֵ TRUE:ڻָ̣FLASE:ڻָ
* ˵ ʹ
**************************************************************************/
BOOL zOss_vSIMInResume(VOID)
{
    return gvSIM_InResume;
}

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* ƣ vSIM_Resume_Data
*  ָ
* ˵ (IN)
*                index: :
*                index = VSIM_WORK_AREA:   ָ
*                index = VSIM_BACKUP_AREA: ָ  
*                index = VSIM_BOTH_AREA:   ָͱ  
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 vSIM_Resume_Data(UINT8 index)
{
    UINT8   symbol = 0;
    UINT8   *temp  = NULL;
    SINT32  status = -1;
    
    switch (index)
    {
    case VSIM_WORK_AREA:
        {
            temp = (UINT8 *)zOss_Malloc(gpvSIM_Param->Area_Size);
            if (temp == NULL)
            {
                return ZOSS_ERROR;
            }
            status = zDrvNand_SimNvRead(gpvSIM_Param->Backup_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
            
            if (status != 0)
            {
                break;
            }
            
            gvSIM_InResume = TRUE;

            symbol = VSIM_SYMBOL_WRITE;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
            
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
            if (status != 0)
            {
                break;
            }
            
            symbol = VSIM_SYMBOL_NORMAL;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
            
            gvSIM_InResume = FALSE;
            
            zOss_Free(temp);
            return ZOSS_SUCCESS;
        }
    case VSIM_BACKUP_AREA:
        {
            temp = (UINT8 *)zOss_Malloc(gpvSIM_Param->Area_Size);
            if (temp == NULL)
            {
                return ZOSS_ERROR;
            }
            
            status = zDrvNand_SimNvRead(gpvSIM_Param->Work_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
            if (status != 0)
            {
                break;
            }
            
            gvSIM_InResume = TRUE;

            symbol = VSIM_SYMBOL_WRITE;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
            
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
            if (status != 0)
            {
                break;
            }
            
            symbol = VSIM_SYMBOL_NORMAL;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
            
            gvSIM_InResume = FALSE;
            
            zOss_Free(temp);
            return ZOSS_SUCCESS;
        }
    case VSIM_BOTH_AREA:
        {           
            temp = (UINT8 *)zOss_Malloc(gpvSIM_Param->Area_Size);
            if (temp == NULL)
            {
                return ZOSS_ERROR;
            }
            zOss_Memset(temp, 0xff, gpvSIM_Param->Area_Size);
            
            status = zDrvNand_SimNvFacRead(gpvSIM_Param->Factory_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
            if (status != 0)
            {
                zOss_Free(temp);
                zOss_AssertEx(0, ZOSS_ERROR);
            }

            gvSIM_InResume = TRUE;
            
            /* ָ */
            symbol = VSIM_SYMBOL_WRITE;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
            
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
            if (status != 0)
            {
                break;
            }
            
            symbol = VSIM_SYMBOL_NORMAL;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }

            /* ָ */
            symbol = VSIM_SYMBOL_WRITE;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
            
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
            if (status != 0)
            {
                break;
            }
            
            symbol = VSIM_SYMBOL_NORMAL;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }

            /* ó־λ */
            symbol = VSIM_SYMBOL_NORMAL;
            status = zDrvNand_SimNvProgram(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &symbol);
            if (status != 0)
            {
                break;
            }
            
            gvSIM_InResume = FALSE;
            
            zOss_Free(temp);
            
            return ZOSS_SUCCESS;
        }
    default:
        {
            return ZOSS_ERROR;
        }    
    }

    gvSIM_InResume = FALSE;

    if(temp != NULL)
    {
        zOss_Free(temp);
    }
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣvSIM_Fill_Factory
* ӹ/ݵ
* ˵ 
*   ֵ
* ˵
**************************************************************************/
static VOID vSIM_Fill_Factory(VOID)
{
    VOID    *temp  = NULL;
    UINT8   symbol = 0;
    SINT32  Status = -1;

    temp = zOss_Malloc(gpvSIM_Param->Area_Size);
    zOss_AssertExN(temp != NULL);

    do
    {
        Status = vSIM_ReadWithNoReset(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &symbol);
        if(Status != 0 || symbol != VSIM_SYMBOL_NORMAL)
        {
            break;
        }

        Status = zDrvNand_SimNvRead(gpvSIM_Param->Work_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);        
        if(Status != 0)
        {
            break;
        }

        symbol = VSIM_SYMBOL_NORMAL;
        gvSIM_InResume = TRUE;
        zDrvNand_SimNvFacProgram(gpvSIM_Param->Factory_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
        zDrvNand_SimNvProgram(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &symbol);
        gvSIM_InResume = FALSE;

        zOss_Free(temp);
        return;
    }while(0);

    do
    {
        Status = vSIM_ReadWithNoReset(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &symbol);
        if(Status != 0 || symbol != VSIM_SYMBOL_NORMAL)
        {
            break;
        }

        Status = zDrvNand_SimNvRead(gpvSIM_Param->Backup_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);        
        if(Status != 0)
        {
            break;
        }

        symbol = VSIM_SYMBOL_NORMAL;
        gvSIM_InResume = TRUE;
        zDrvNand_SimNvFacProgram(gpvSIM_Param->Factory_Area_Base_Addr, gpvSIM_Param->Area_Size, temp);
        zDrvNand_SimNvProgram(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &symbol);
        gvSIM_InResume = FALSE;

        zOss_Free(temp);
        return;
    }while(0);

    zOss_Free(temp);
    zOss_AssertExN(0);
}

/**************************************************************************
* ƣ vSIM_ReadWithNoReset
*  򵥷װӿڣECCʱ
* ˵ (IN)
*                dwStart: ƫƵַ
*                dwLen:   
*                to:      Ŀ껺ռ
*            (OUT)
*   ֵ ͬӿڷֵɹ0
* ˵
**************************************************************************/
static SINT32 vSIM_ReadWithNoReset(UINT32 dwStart, UINT32 dwLen, UINT8* to)
{
    SINT32 status = -1;
    
    gvSIM_InResume = TRUE;
    status = zDrvNand_SimNvRead(dwStart, dwLen, to);
    gvSIM_InResume = FALSE;

    return status;
}

/**************************************************************************
* ƣ vSIM_Check_Data
*  vSIMݻָ
* ˵ 
*   ֵ ɹTRUE, 򷵻FALSE
* ˵
**************************************************************************/
static BOOL vSIM_Check_Data(VOID)
{
    UINT8   index           = 0;
    UINT8   WorkArea_Symbol = 0;
    UINT8   BackUp_Symbol   = 0;
    UINT8   Factory_Symbol  = 0;
    UINT32  status          = ZOSS_ERROR;
    SINT32  WorkArea_Status = -1;
    SINT32  BackUp_Status   = -1;

    status = vSIM_ReadWithNoReset(gpvSIM_Param->Factory_Area_Symbol_Addr, 1, &Factory_Symbol);
    if(Factory_Symbol == VSIM_SYMBOL_MEM)
    {
        gvSIM_OP_MODE = VSIM_OP_MEM;
        return TRUE;
    }
    
    /* 汾 */
    if(Factory_Symbol == VSIM_SYMBOL_DOWNLOAD)
    {
        return (vSIM_Resume_Data(VSIM_WORK_AREA | VSIM_BACKUP_AREA) == ZOSS_SUCCESS) ? TRUE : FALSE;
    }

    /*  */
    if(status != 0 || Factory_Symbol == VSIM_SYMBOL_WRITE)
    {
        vSIM_Fill_Factory();
    }

    /* ȡͱеı־λ */
    WorkArea_Status = zDrvNand_SimNvRead(gpvSIM_Param->Work_Area_Symbol_Addr, 1, &WorkArea_Symbol);
    BackUp_Status   = zDrvNand_SimNvRead(gpvSIM_Param->Backup_Area_Symbol_Addr, 1, &BackUp_Symbol);
    if (WorkArea_Status == 0 && BackUp_Status == 0)
    {
        if (WorkArea_Symbol != VSIM_SYMBOL_NORMAL)
        {
            index = VSIM_WORK_AREA;
        }

        if (BackUp_Symbol != VSIM_SYMBOL_NORMAL)
        {
            index |= VSIM_BACKUP_AREA;
        }

        if (index != 0)
        {
            status = vSIM_Resume_Data(index);
            if (status != ZOSS_SUCCESS)
            {
                return FALSE;
            }
        }
    }
    else if (WorkArea_Status == 0 && WorkArea_Symbol == VSIM_SYMBOL_NORMAL)
    {
        index  = VSIM_BACKUP_AREA;
        status = vSIM_Resume_Data(index);
        if (status != ZOSS_SUCCESS)
        {
            return FALSE;
        }
    }
    else if (BackUp_Status == 0 && BackUp_Symbol == VSIM_SYMBOL_NORMAL)
    {
        index  = VSIM_WORK_AREA;
        status = vSIM_Resume_Data(index);
        if (status != ZOSS_SUCCESS)
        {
            return FALSE;
        }  
    }
    else
    {
        index  = VSIM_WORK_AREA | VSIM_BACKUP_AREA;
        status = vSIM_Resume_Data(index);
        if (status != ZOSS_SUCCESS)
        {
            return FALSE;
        }
    }

    return TRUE;
}

#ifdef __cplusplus
}
#endif

