/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v0.1
 * Author:        wuhui
 * Date:          2017-1-13
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_SPICC_H
#define _DRVS_SPICC_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_chip_cfg.h"
#include "drvs_dma.h"
#include "drvs_sys.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
	//BASE ADDRESSS
#define SSP1_FORCAM_BASE          (SPI1_REG_BASE+0x0000)

#define SSP1_COMCTRL_MS_OFFSET (2)
#define SSP1_COMCTRL_SSPE_OFFSET (1)
#define SSP1_FMTCTRL_LaneNum_OFFSET (13)
#define SSP1_FMTCTRL_LaneNum_SIZE (2)
#define SSP1_FMTCTRL_CAMMode_OFFSET (12)
#define SSP1_FIFOCTRL_RXFIFOTHRED_OFFSET (4)
#define SSP1_FIFOCTRL_RXFIFOTHRED_SIZE (4)
#define SSP1_FIFOCTRL_RXFIFOCNTR_OFFSET (5)
#define SSP1_FIFOCTRL_RXFIFOCNTR_SIZE (7)
#define SSP1_FIFOCTRL_RXDMAEN_OFFSET (2)
#define SSP1_SYNC_CODE_OFFSET (0)
#define SSP1_CAMFIFO_RST_OFFSET (1)
#define SSP1_SAMPLE_MODE_OFFSET (2)
#define SSP1_ID_SOL_OFFSET (24)
#define SSP1_ID_EOF_OFFSET (16)
#define SSP1_ID_SOF_OFFSET (8)
#define SSP1_ID_SYNC_SIZE (8)
#define SSP1_PACKETSIZE_OFFSET (0)
#define SSP1_PACKETSIZE_SIZE (16)

//ͬʽʱID 
#define MTK_START       	(0x01)
#define MTK_DATA_PACKET   	(0x40)
#define MTK_END        		(0x00)
#define BT656_START        	(0xab)
#define BT656_LINE_START	(0x80)
#define BT656_END       	(0xb6)


#define set_reg_bit(regName, bitAddr, bitValue)      \
do{                                                  \
    if(bitValue == TRUE)                             \
        reg32(regName) |= (0x1<<bitAddr);            \
    else                                             \
        reg32(regName) &= ~(0x1<<bitAddr);           \
}while(0)

#define set_reg_bits(regName, bitsAddr, bitsLen, bitsValue)   \
do{                                                             \
    reg32(regName) = (reg32(regName)&(~(((0x1<<bitsLen)-0x1)<<bitsAddr)))|(bitsValue<<bitsAddr);\
}while(0)

#define read_reg_bits(regName, bitsAddr, bitsLen)    ((reg32(regName)>>bitsAddr)&((0x1<<bitsLen)-0x1))
#define read_reg_bit(regName, bitsAddr)    ((reg32(regName)>>bitsAddr)&0x1)


/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef volatile struct _T_SPICC_Regs
{ 
	UINT32 SSP1_VER; 				//0x00	
	UINT32 SSP1_COM_CTRL; 			//0x04 
	UINT32 SSP1_FMT_CTRL;			//0x08	
	UINT32 SSP1_DATA_REG; 			//0x0C	 
	UINT32 SSP1_FIFO_CTRL;			//0x10	
	UINT32 SSP1_FIFO_STA;			//0x14
	UINT32 SSP1_INT_EN;				//0x18
	UINT32 SSP1_INT_STACLR;			//0x1C
	UINT32 SSP1_TIMING;				//0x20
	UINT32 Reserved[3];				//0x24~0x2C
	UINT32 SSP1_SYNC_CODE;			//0x30
	UINT32 SSP1_DEBUG;				//0x34
	UINT32 SSP1_PACKET_SIZE;		//0x38
}T_SPICC_Regs; 

typedef enum _T_SSP1_MSMode
{
	SSP1_AS_MASTER = 0x0,
	SSP1_AS_SLAVE = 0x1,
	MAX_MS_MODE = 0X02
}T_SPICC_MSMode;

typedef enum
{	
	DISABLE = 0,	
	ENABLE =1,
	MAX_ENABLE_TYPE =2
}T_SPICC_ENABLE_TYPE;

typedef enum _T_SPICC_LaneNum
{
	LANE_1_CAM = 0,
	LANE_2_CAM = 1,
	LANE_4_CAM = 2,
	LANE_MAX_CAM = 3
}T_SPICC_LaneNum;

typedef enum _T_SPICC_CamMode
{
	SSP1_AS_NORMAL = 0,
	SSP1_AS_CAMERA = 1,
	MAX_SSP1_CAMMODE = 2
}T_SPICC_CamMode;

typedef enum
{	
	RAW_DATA =0,
	PURE_DATA = 1,	
	MAX_SAMPLE_MODE =2
}T_SPICC_ImageSampleMode;

typedef enum
{	
	BT656_MODE = 0,
	MTK_MODE = 1,
	MAX_TRANSFER_MODE =2
}T_SPICC_ImageTransferMode;

typedef enum
{	
	RX_OVERRUN_IE = 0,
	RX_FULL_IE = 2,
	RX_THRED_IE = 4,
	CAM_SOF_IE = 7,
	CAM_EOF_IE = 8,
	MAX_SSP1_INT_EN = 9
}T_SPICC_IntEn;

typedef enum
{	
	eRESET =0,
	eRELEASE = 1,	
	MAX_FIFOCtrl_TYPE =2
}T_SPICC_CamFIFORst;

typedef struct _T_zDrvSPICC_Device
{
	T_SPICC_ImageTransferMode transMode;
	T_SPICC_ImageSampleMode samMode;
	T_SPICC_LaneNum laneNum;
	UINT32 packetSize;	
}T_zDrvSPICC_Device;

typedef struct _T_SPICC_DevCtrl
{
	T_SPICC_Regs* regPtr;
   	UINT32 rxDmaChl;                        // ssp rx Dma channel number
	
}T_SPICC_DevCtrl;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
SINT32 zDrvSPICC_Initiate(VOID);
SINT32 zDrvSPICC_Open(T_zDrvSPICC_Device *spicc_Dev);
SINT32 zDrvSPICC_Close(void);
SINT32 zDrvSPICC_DmaRxloop(zDrvDma_CallbackFunc CallBack,T_ZDrvDma_ChannelDef *rxRegDmaChl,UINT32 transferListNum);
SINT32 zDrvSPICC_DisableDmaRxloop(VOID);
SINT32	zDrvSPICC_DeAllocDmaRxCh(VOID);
VOID zDrvSPICC_ClkGateCtrl(T_ZDrvSysClk_Gate ClkCtrl);



#endif/*_FILENAME_H*/

