/*
 ** Copyright 2003-2010, VisualOn, Inc.
 **
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 **
 **     http://www.apache.org/licenses/LICENSE-2.0
 **
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 */


/* Double precision operations */
/* $Id$ */

#ifndef __OPER_32B_H__
#define __OPER_32B_H__

#include "basic_op.h"

//void VO_L_Extract (Word32 L_32, Word16 *hi, Word16 *lo);
static_vo void VO_L_Extract (Word32 L_32, Word16 *hi, Word16 *lo)
{
	*hi = (Word16)(L_32 >> 16);
	*lo = (Word16)((L_32 & 0xffff) >> 1);
	return;
}   
Word32 L_Comp (Word16 hi, Word16 lo);
//Word32 Mpy_32 (Word16 hi1, Word16 lo1, Word16 hi2, Word16 lo2);
//Word32 Mpy_32_16 (Word16 hi, Word16 lo, Word16 n);
/*****************************************************************************
 * Function Mpy_32()                                                         *
 *                                                                           *
 *   Multiply two 32 bit integers (DPF). The result is divided by 2**31      *
 *                                                                           *
 *   L_32 = (hi1*hi2)<<1 + ( (hi1*lo2)>>15 + (lo1*hi2)>>15 )<<1              *
 *                                                                           *
 *   This operation can also be viewed as the multiplication of two Q31      *
 *   number and the result is also in Q31.                                   *
 *                                                                           *
 * Arguments:                                                                *
 *                                                                           *
 *  hi1         hi part of first number                                      *
 *  lo1         lo part of first number                                      *
 *  hi2         hi part of second number                                     *
 *  lo2         lo part of second number                                     *
 *                                                                           *
 *****************************************************************************
*/

static_vo Word32  Mpy_32 (Word16 hi1, Word16 lo1, Word16 hi2, Word16 lo2)
{
	Word32 L_32;
	L_32 = (hi1 * hi2);
	L_32 += (hi1 * lo2) >> 15;
	L_32 += (lo1 * hi2) >> 15;
	L_32 <<= 1;

	return (L_32);
}

/*****************************************************************************
 * Function Mpy_32_16()                                                      *
 *                                                                           *
 *   Multiply a 16 bit integer by a 32 bit (DPF). The result is divided      *
 *   by 2**15                                                                *
 *                                                                           *
 *                                                                           *
 *   L_32 = (hi1*lo2)<<1 + ((lo1*lo2)>>15)<<1                                *
 *                                                                           *
 * Arguments:                                                                *
 *                                                                           *
 *  hi          hi part of 32 bit number.                                    *
 *  lo          lo part of 32 bit number.                                    *
 *  n           16 bit number.                                               *
 *                                                                           *
 *****************************************************************************
*/

static_vo Word32 Mpy_32_16 (Word16 hi, Word16 lo, Word16 n)
{
	Word32 L_32;

	L_32 = (hi * n)<<1;
	L_32 += (((lo * n)>>15)<<1);

	return (L_32);
}
static_vo Word32 zMmp_AmrWbMpy32(register Word32 var1,
                                 register Word32 var2)
{
    register Word32 result;

    #if  (PV_COMPILER == EPV_ARM_GNUC)
    __asm__ volatile("smmul %0, %1, %2" : "=r"(result) : "r"(var1), "r"(var2));
    __asm__ volatile("qadd %0, %1, %2" : "=r"(result) : "r"(result), "r"(result));
    #elif (PV_COMPILER == EPV_ARM_RVCT)
    __asm{
        smmul result, var1, var2;
        qadd  result, result, result;
    }
    #else
    #error "unkown compiler"
    #endif
    return (result);
}
static_vo Word32 zMmp_AmrWbMpy32_16(register Word32 var1,
                                    Word16 var2)
{
    register Word32 result;
    register Word32 L_var2 = var2;
    
    #if  (PV_COMPILER == EPV_ARM_GNUC)    
    __asm__ volatile("smulwb %0, %1, %2" : "=r"(result) : "r"(var1), "r"(L_var2));
    __asm__ volatile("qadd %0, %1, %2" : "=r"(result) : "r"(result), "r"(result));
    #elif (PV_COMPILER == EPV_ARM_RVCT)
    __asm{
        smulwb result, var1,   L_var2;
        qadd   result, result, result;
    }
    #else
    #error "unkown compiler"
    #endif   
    return (result);
}
static_vo Word32 zMmp_AmrWbSmuad(Word32 var1, Word32 var2)
{
    register Word32 result;
    
    #if  (PV_COMPILER == EPV_ARM_GNUC)        
    __asm__ volatile("smuad %0, %1, %2": "=r"(result) : "r"(var1), "r"(var2));
    #elif (PV_COMPILER == EPV_ARM_RVCT)
    __asm{smuad result, var1, var2};
    #else
    #error "unkown compiler"
    #endif 
    return result;
}

#if PV_CPU_ARCH_VERSION < 6
Word32 Div_32 (Word32 L_num, Word16 denom_hi, Word16 denom_lo);
#else
Word32 Div_32(Word32 L_num, Word32 L_denom);
#endif

#endif //__OPER_32B_H__

