/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Contains variables and functions accessed from path and volume control
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_gain_lib.h
 *   Version: \main\4
 *   Date: 2007-04-30 15:19:05
 *   Responsible: kbj
 *   Comment:
 *     Merged code guideline updates.
 */
#if !defined (_AUD_GAIN_LIB_H_)
#define _AUD_GAIN_LIB_H_

/*******************************************************************************
*
*                          Externally visible variables
*
*******************************************************************************/
extern T_DSP_CMD_CBUF_GAIN         aud_dsp_cbuf_gain_parms;
extern T_DSP_CMD_VB_SET_GAIN_PAR   aud_dsp_gain_parms;
extern T_DSP_CMD_VM_SET_COEFF_PAR  aud_dsp_vm_parms;

/*******************************************************************************
*
*                  Public functions implemented in aud_gain_lib.c
*
*******************************************************************************/
void aud_dsp_set_vb_gains(void);
void aud_dsp_set_cbuf_gains(void);
void aud_dsp_set_vm_gains(void);
void aud_update_side_tone(void);
void aud_update_mix_afe(void);
#endif /* _AUD_GAIN_LIB_H_ */

