/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_oss.h
* ļʶ:     ramdump_oss.h
* ժҪ:     ramdumpϵͳӿ/ݽṹͷļ
* ʹ÷:     
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/3/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

#ifndef _RAMDUMP_OSS_H
#define _RAMDUMP_OSS_H

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"

#ifdef _OS_LINUX 
#include <linux/soc/zte/rpm/rpmsg.h>
#include <asm/io.h>
#include <asm/current.h>
#include <linux/string.h>
#include <linux/sched.h>
#include <asm/memory.h>
#include <linux/irqflags.h>
#include <asm/setup.h>
#include <linux/kthread.h>
#include <linux/bug.h>
#include <linux/kernel.h>
#include <asm/barrier.h>
#include <asm/outercache.h>
#elif defined (_OS_TOS)
#include "oss_api.h"
#include "drvs_rpmsg.h"
#include "drvs_usbPoll.h"
#include "drvs_icp.h"
#include "ps_ephy_interface.h"
#include "drv_api.h"
#include <cyg/hal/tos_arm_mmu.h>
#include <cyg/hal/tos_cache.h>
#include "rpmsg_channel.h"
#endif

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define OSS_MMAP(addr,size) ramdump_oss_mmap(addr,size)

#ifdef _OS_LINUX

#define OSS_PANIC(val)      panic(val)
#define OSS_LOCK(flag)      local_irq_disable()
#define OSS_UNLOCK(flag)    local_irq_enable()
#define OSS_SLEEP(val)      msleep(val)

#define OSS_PHY_TO_VIRT(addr) phys_to_virt(addr)
#define OSS_VIRT_TO_PHY(addr) virt_to_phys(addr)
#define OSS_PHY_TO_PFN(addr)  __phys_to_pfn(addr)
#define OSS_PFN_VALID(pfn)    pfn_valid(pfn)

/*
 * to make sure ramdump init after icp device init
 */
#define OSS_INIT(fn) late_initcall(fn)
#define OSS_PRINTF printk

#elif defined (_OS_TOS)

#define OSS_PANIC(val)                  zOss_ASSERT(0)
#define OSS_LOCK(flag)                  ZOSS_SAVE_IRQ(flag)
#define OSS_UNLOCK(flag)                ZOSS_RESTORE_IRQ(flag)
#define OSS_SLEEP(val)                  zOss_Sleep(val)
#define OSS_CREATE_THREAD(name,entry)   ramdump_oss_create_thread(name,entry)
#define OSS_PHY_TO_VIRT(addr)           (addr)

#define OSS_INIT(fn)
#define OSS_PRINTF(fmt...) zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, fmt)

#endif //#ifdef _OS_LINUX 

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef ramdump_msg_t ramdump_oss_msg_t;

#ifdef _OS_LINUX 

typedef T_ZDrvRpMsg_ActorID ramdump_oss_icp_actorid;
typedef T_ZDrvRpMsg_ChID ramdump_oss_icp_channelid;
typedef T_ZDrvRpMsg_CallbackFunction ramdump_oss_icp_callback;
typedef T_ZDrvRpMsg_Msg ramdump_oss_icp_msg;
typedef void (*ramdump_oss_thread_entry_t)(unsigned long arg);

#elif defined (_OS_TOS) //#ifdef _OS_LINUX 

typedef T_ZDrvRpMsg_MsgActor ramdump_oss_icp_actorid;
typedef T_ZDrvRpMsg_ChID ramdump_oss_icp_channelid;
typedef T_ZDrvRpMsg_CallbackFunction ramdump_oss_icp_callback;
typedef T_ZDrvRpMsg_Msg ramdump_oss_icp_msg;
typedef void (*ramdump_oss_thread_entry_t)(SINT32 arg);

#endif //#ifdef _OS_LINUX 
/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/
extern int ramdump_oss_icp_create_channel(
            ramdump_oss_icp_actorid actorID, 
            ramdump_oss_icp_channelid chID, 
            unsigned int size);
extern int ramdump_oss_icp_regcallback(
            ramdump_oss_icp_actorid actorID, 
            unsigned int chID, 
            ramdump_oss_icp_callback callback);
extern int ramdump_oss_icp_write(const ramdump_oss_icp_msg *pMsg);
extern void ramdump_oss_data_trans_init(void);
extern void ramdump_oss_data_trans_read (
                unsigned char *buffer, 
                unsigned int size);
extern void ramdump_oss_data_trans_write(
                unsigned char *buffer, 
                unsigned int size);
extern void ramdump_oss_data_trans_done(void);
extern void ramdump_oss_error_log_creat(char *buf);
extern int ramdump_oss_icp_send(
            ramdump_oss_msg_t *icp_msg, 
            unsigned int client_id,
            unsigned int ch_id);
extern void ramdump_oss_create_thread(
                char *name, 
                ramdump_oss_thread_entry_t entry);
extern unsigned long ramdump_oss_mmap(
                        unsigned long addr, 
                        unsigned long size);

#endif  //#ifndef _RAMDUMP_OSS_H

