#!/bin/bash

WORKDIR=$PWD
export PATH=$WORKDIR/bin:$PATH

UBI_ARGS="-m 0x1000 -p 0x40000 -s 0x1000 -Q 1024"

if [ $# -lt 2 ]; then
  echo "[error] $0 parameter to less"
  echo "$0 outfile cfg_file_name"
  exit -1
fi
outfile=$1
cfg_file_name=$2


echo "outfile: $outfile"
echo "cfg_file_name: $cfg_file_name"
echo "UBI_ARGS: $UBI_ARGS"


./ubinize-cfg.sh  $outfile $cfg_file_name  "$UBI_ARGS"
