/************************************************************************
 *                                                                      *
 * Netcwmp/Opencwmp Project                                             *
 * A software client for enabling TR-069 in embedded devices (CPE).     *
 *                                                                      *
 * Copyright (C) 2013-2014  netcwmp.netcwmp group                            *
 *                                                                      *
 * This program is free software; you can redistribute it and/or        *
 * modify it under the terms of the GNU General Public License          *
 * as published by the Free Software Foundation; either version 2       *
 * of the License, or (at your option) any later version.               *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU Lesser General Public     *
 * License along with this library; if not, write to the                *
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,          *
 * Boston, MA  02111-1307 USA                                           *
 *                                                                      *
 * Copyright 2013-2014  Mr.x(Mr.x) <netcwmp@gmail.com>          *
 *                                                                      *
 ***********************************************************************/

#include "cwmpd.h"

#include <sys/ipc.h>

#include <errno.h>





#define CWMP_VALUE_UNSET -1



int              cwmp_argc;
char           **cwmp_argv;


static pool_t * cwmp_global_pool;



void cwmp_daemon()
{
    //daemon(0, 1);
}




void cwmp_getopt(int argc, char **argv)
{
    
}


static int cwmp_save_argv( int argc, char *const *argv)
{
    cwmp_argv = (char **) argv;
    cwmp_argc = argc;

    return 0;
}


int cwmp_set_var(cwmp_t * cwmp)
{
    FUNCTION_TRACE();


    cwmp_bzero(cwmp, sizeof(cwmp_t));
    cwmp->new_request = CWMP_TRUE;
    pool_t * pool = pool_create(POOL_DEFAULT_SIZE);
	if(NULL == pool)
	{
	    cwmp_log_error("pool create return null, size:POOL_DEFAULT_SIZE");
		return CWMP_ERROR;
	}
	
    cwmp->pool = pool;


#if 0
    cwmp_event_init(cwmp);

    cwmp->queue = queue_create(pool);
#endif

    return CWMP_OK;
}




#ifdef USE_CWMP_OPENSSL
void cwmp_init_ssl(cwmp_t * cwmp)
{
    char * cafile = cwmp_conf_pool_get(cwmp_global_pool, "cwmp:ca_file");
    char * capasswd = cwmp_conf_pool_get(cwmp_global_pool, "cwmp:ca_password");   
    cwmp->ssl_ctx = openssl_initialize_ctx(cafile, capasswd);
}
#endif


static int copy_file(const char* src, const char* des)
{
	int rc = CWMP_OK;
	FILE *psrc = NULL;
	FILE *pdes = NULL;
	psrc = fopen(src, "r");
	pdes = fopen(des, "w+");
 
 
	if (psrc && pdes)
	{
		int nLen = 0;
		char szBuf[1024] = {0};
		while((nLen = fread(szBuf, 1, sizeof szBuf, psrc)) > 0)
		{
			fwrite(szBuf, 1, nLen, pdes);
		}
		rc = CWMP_OK;
	}
	else
	{
		rc = CWMP_ERROR;
	}
 
 
	if (psrc)
	{
		fclose(psrc);
		psrc = NULL;
	}
 
 
	if (pdes)
	{
		fclose(pdes);
		pdes = NULL;
	}
 
 
	return rc;
}


cwmp_t *g_cwmp = NULL;


#define RO_CWMP_CONF_PATH     "/etc_ro/cwmp.conf"
#define RW_CWMP_CONF_PATH     "/cache/cwmp.conf"

int main(int argc, char **argv)
{
    cwmp_pid_t pid;
    cwmp_t * cwmp;

    int syslog_enable = 0;
    int cwmp_enable = 0;

#ifdef WIN32
    WSADATA wsaData;
    WSAStartup(MAKEWORD(2, 2), &wsaData);
#endif
    pid = getpid();

//    cwmp_log_init("/var/log/cwmpd.log", CWMP_LOG_DEBUG);
    cwmp_log_init("/cache/cwmpd.log", CWMP_LOG_DEBUG_SQL);
    cwmp_global_pool = pool_create(POOL_DEFAULT_SIZE);
	if(NULL == cwmp_global_pool)
	{
	    cwmp_log_error("cwmp_global_pool pool create fail");
		return -1; 
	}

	
    cwmp = pool_palloc(cwmp_global_pool, sizeof(cwmp_t));
	if(NULL == cwmp)
	{
	    cwmp_log_error("cwmp pool palloc fail");
		return -1; 
	}


	if(access(RW_CWMP_CONF_PATH, F_OK) != 0)
	{
		copy_file(RO_CWMP_CONF_PATH, RW_CWMP_CONF_PATH);
		cwmp_log_info("%s not exist, copy %s to it", RW_CWMP_CONF_PATH, RO_CWMP_CONF_PATH);
	}


    cwmp_conf_open(RW_CWMP_CONF_PATH);
    
    cwmp_enable=cwmp_conf_get_int("cwmp:enable");
    if(!cwmp_enable)
    {
        cwmp_log_error("cwmp_enable:%d", cwmp_enable);
		return -1;    
    }

    cwmp_getopt(argc, argv);
    
    //cwmp_init_db(); 

    cwmp_set_var(cwmp);
    cwmp_daemon();
    
    cwmp_conf_init(cwmp);


    cwmp_event_init(cwmp);
    cwmp->queue = queue_create(cwmp->pool);

    g_cwmp = cwmp;

	ini_periodic_info(cwmp);


    init_pdp_type(cwmp);
	

#ifdef USE_CWMP_OPENSSL
    cwmp_init_ssl(cwmp);
#endif

    cwmp_model_load(cwmp, "/etc_ro/device.xml");
    cwmp_process_start_master(cwmp);

    return 0;
}



