#ifndef PPPOE_H
#define PPPOE_H
#include <stdio.h>		
#include <stdlib.h>		
#include <unistd.h>		
#include <string.h>		
#include <errno.h>		
#include <signal.h>
#include <getopt.h>
#include <stdarg.h>
#include <syslog.h>
#include <paths.h>
#include <sys/types.h>		
#include <asm/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>		
#include <sys/select.h>
#include <sys/socket.h>		
#include <net/if.h>		
#include <net/if_arp.h>
#include <netinet/in.h>
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#include <asm/byteorder.h>
#include <linux/if_pppox.h>
#include "pppd.h"

#define MAX_PAYLOAD 1484
#define TAG_RELAY_SID	5
#define TAG_SRV_ERR     6
#define _STR(x) #x
#define TAG_GEN_ERR  	8
#define TAG_EOL		9
#define TAG_SYS_ERR  	7
#define TAG_SRV_NAME	0
#define TAG_AC_NAME	1
#define MAX_TAGS		11
#define TAG_HOST_UNIQ	2
#define FMTSTRING(size) "%x:%x:%x:%x:%x:%x/%x/%" _STR(size) "s"
#define TAG_AC_COOKIE	3
#define TAG_VENDOR 	4

struct pppoe_packet{
	struct sockaddr_ll addr;
	struct pppoe_tag *tags[MAX_TAGS];
	struct pppoe_hdr *hdr;
	char buf[MAX_PAYLOAD];		/* buffer in which tags are held */
};


static int tag_map[] = { PTT_SRV_NAME,
			 PTT_AC_NAME,
			 PTT_HOST_UNIQ,
			 PTT_AC_COOKIE,
			 PTT_VENDOR,
			 PTT_RELAY_SID,
			 PTT_SRV_ERR,
			 PTT_SYS_ERR,
			 PTT_GEN_ERR,
			 PTT_EOL
};

struct session;

typedef int (*packet_cb_t)(struct session* ses,
			   struct pppoe_packet *p_in,
			   struct pppoe_packet **p_out);

struct filter {
	struct pppoe_tag *stag;  
	struct pppoe_tag *ntag;  
	struct pppoe_tag *htag;  
	int num_restart;
	int peermode;
	char *fname;
	char *pppd;
} __attribute__ ((packed));


struct pppoe_tag *make_filter_tag(short type, short length, char* data);

struct session {
	int type;
	int opt_debug;
	int detached;
	int np;
	int log_to_fd;
	int ifindex;			
	char name[IFNAMSIZ];	
	struct pppoe_packet curr_pkt;
	packet_cb_t init_disc;
	packet_cb_t rcv_pado;
	packet_cb_t rcv_padi;
	packet_cb_t rcv_pads;
	packet_cb_t rcv_padr;
	packet_cb_t rcv_padt;
	packet_cb_t timeout;
	struct filter *filt;
	struct sockaddr_ll local;
	struct sockaddr_ll remote;
	struct sockaddr_pppox sp;
	int fd;	
	int retransmits;
	int retries;
	int state;
	int opt_daemonize;
	int fork;
	int fwd_sock;
	char fwd_name[IFNAMSIZ];
} __attribute__ ((packed));
extern int session_connect(struct session *ses);
extern int session_disconnect(struct session*ses);


#define poe_dbglog(a,b...)
#define poe_info(a,b...)
#define poe_notice(a,b...)
extern void copy_tag(struct pppoe_packet *dest, struct pppoe_tag *pt);
extern struct pppoe_tag *get_tag(struct pppoe_hdr *ph, u_int16_t idx);
#define poe_warn(a,b...)
#define poe_error(a,b...)
#define poe_fatal(a,b...)
extern int get_sockaddr_ll(const char *devnam,struct sockaddr_ll* sll);
extern int client_init_ses (struct session *ses, char* devnam);
int log_to_fd;

extern int verify_packet( struct session *ses, struct pppoe_packet *p);
extern int send_disc(struct session *ses, struct pppoe_packet *p);

#endif
