/**
 * 
 * @file      amt_gps_test.c
 * @brief     
 *            This file is part of FTM.
 *            AMTӦò
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2015/04/28  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */


#include <sys/msg.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h> 
#include <semaphore.h>
#include <time.h>
#include <sys/stat.h>
#include "softap_api.h"
#include "kwatch_msg.h"
#include "amt.h"

/**
 * @brief AMTGPSʼ
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_Gps_Init(void)
{
       return 0;
}


/**
 * @brief AMTGPSϢ
 * @param[in] msg_id FID
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_Gps_ProcessMsg(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
	UNUSED(msg_len);
	
	switch(msg_id)
    {
    	case FID_GPS_MODULE_TEST:
	    {
			AmtPrintf(AMT_INFO "%s: MODULE_ID_AMT=%d,MODULE_ID_GPS=%d\n", __FUNCTION__,MODULE_ID_AMT,MODULE_ID_GPS);
		    AmtPrintf(AMT_INFO "%s: KWATCH_MSG_GPS_PWR_SET_REQ=%d\n", __FUNCTION__,KWATCH_MSG_GPS_PWR_SET_REQ);
            unsigned char Flag = 0;
		    memcpy(&Flag,msg_buf,sizeof(unsigned char));
		    if(Flag == 1) //gps
		    {
				char buf[] = {"1"};
			    ipc_send_message2(MODULE_ID_AMT, MODULE_ID_GPS, KWATCH_MSG_GPS_PWR_SET_REQ, sizeof(buf), (unsigned char*)buf, 0);
		    }
		    else if(Flag == 0) //رgps
		    {
				char buf[] = {"0"};
			    ipc_send_message2(MODULE_ID_AMT, MODULE_ID_GPS, KWATCH_MSG_GPS_PWR_SET_REQ, sizeof(buf), (unsigned char*)buf, 0);
		    }
		    else
		    {
		   		AmtPrintf(AMT_ERROR "%s: param error!\n", __FUNCTION__);
		        return -1;
		   	}
	        break;
       	 }
         default:
		     break;
    }
	return 0;
}

/**
 * @brief AMTGPSϢPC
 * @param[in] msg_id FID
 * @param[in] msg Ϣ
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_Process_Gps_Rsp(MSG_BUF *msg, unsigned int msg_id)
{
	unsigned char *buf = msg->aucDataBuf;
	AmtPrintf(AMT_INFO "%s: receive data= %s,datalen=%d.\n", __FUNCTION__,buf,msg->usDataLen);
	if (Amt_CreateResponse(msg_id, buf, msg->usDataLen) == -1)
    {
    	AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
    }
    else
    {
    	AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
    }
	return 0;
}

