/**
 * 
 * @file      amt_agent_devicetest.c
 * @brief     
 *            This file is part of FTM.
 *            AMTӦò
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2018/10/12  1.0      liu.xin        Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */


//#include "oss_api.h"
#include "amt_agent_devicetest.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/msg.h>
#include "amt.h"
#include "softap_api.h"
#include "other_msg.h"
//#include "os_type.h"
#include "battery.h"
#ifdef _USE_VOICE_SUPPORT
#include <tinyalsa/asoundlib.h>
#include <tinyalsa/audio_mixer_ctrl.h>
#endif
#include <stdint.h>
#include <errno.h>
#include "2k_8000.h"
#include <pthread.h>
#include <unistd.h>
#include <stdbool.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/mman.h>
#include <math.h>


#ifdef  FILE
#undef  FILE
#endif
#define FILE    VOID
//#define NULL 				0
typedef unsigned int size_t ;

////test
typedef struct
{
    double freqValue;
    double freqAmp;
}zDrvVp_Freqfft;

extern  int cal_freq_fft(short *data,zDrvVp_Freqfft *freqfft,unsigned short n, int fs);
extern  int get_audioloop_result(FILE* file, int sampfs);

#ifdef _USE_VOICE_SUPPORT

static pthread_t ca_thread_tid;
static pthread_t pb_thread_tid;
static int cap_running = 0;
static FILE *file = NULL;
static struct pcm *cap_pcm, *pb_pcm;

void* audio_ca_thread(void* arg)
{
		struct mixer *mixer;
		struct pcm_config config;
	//	  struct pcm *cap_pcm, *pb_pcm;
		char *buffer;
		unsigned int size;
		unsigned int bytes_read = 0;
	//	FILE *file;
		//int num_read;

		UNUSED(arg);
	
		mixer = mixer_open(0);
		mix_set_input_path(mixer, T_INPUT_MICLP);
		mix_set_input_vol(mixer, T_AUDIO_INPUT_VOL_LEVEL_11);
		mixer_close(mixer);
	
		memset(&config, 0, sizeof(config));
		config.channels = 1;
		config.rate = 8000;
		config.period_size = 320;
		config.period_count = 3;
		config.format = PCM_FORMAT_S16_LE;
		config.start_threshold = 0;
		config.stop_threshold = 0;
		config.silence_threshold = 0;
	
		file = fopen("/mnt/userdata/cache/cap.bin", "wb+");
		if (!file) {
			 AmtPrintf(AMT_ERROR "Unable to create file cap.bin\n");
			return NULL;
		}
		
		cap_pcm = pcm_open(0, 0, PCM_IN, &config);
		if (/*!cap_pcm || */!pcm_is_ready(cap_pcm)) {
			AmtPrintf(AMT_ERROR "Unable to open PCM device (%s)\n",
					pcm_get_error(cap_pcm));
			return NULL;
		}
	
		size = pcm_frames_to_bytes(cap_pcm, pcm_get_buffer_size(cap_pcm));
		buffer = malloc(size);
		if (!buffer) {
			AmtPrintf(AMT_ERROR "Unable to allocate %d bytes\n", size);
			//free(buffer);
			pcm_close(cap_pcm);
			return NULL;
		}
	
		while (!pcm_read(cap_pcm, buffer, size)) {
			if (fwrite(buffer, 1, size, file) != size) {
				AmtPrintf(AMT_ERROR "Error capturing sample\n");
				break;
			}
			bytes_read += size;
			if (bytes_read >= 50000)
				break;
		}
		
		cap_running = 0;
		free(buffer);
	//	fclose(file);
		printf("ca_thread\n");
		AmtPrintf(AMT_INFO "ca_thread\n");
		pthread_exit(0);
}

static void* audio_pb_thread(void *arg)
{
    struct mixer *mixer;
    struct pcm_config config;
 //   struct pcm *cap_pcm, *pb_pcm;
    char *buffer;
    unsigned int size;
    //unsigned int bytes_read = 0;
    //int num_read;

	UNUSED(arg);
	
    mixer = mixer_open(0);
    mix_set_output_path(mixer, T_OUTPUT_SPEAKER);
    mix_set_output_vol(mixer, T_AUDIO_OUTPUT_VOL_LEVEL_11);
    mixer_close(mixer);
	
    memset(&config, 0, sizeof(config));
    config.channels = 1;
    config.rate = 8000;
    config.period_size = 320;
    config.period_count = 3;
    config.format = PCM_FORMAT_S16_LE;
    config.start_threshold = 0;
    config.stop_threshold = 0;
    config.silence_threshold = 0;

    pb_pcm = pcm_open(0, 0, PCM_OUT, &config);
    if (/*!pb_pcm ||*/ !pcm_is_ready(pb_pcm)) {
        AmtPrintf(AMT_ERROR "Unable to open PCM device (%s)\n",
                pcm_get_error(pb_pcm));
        return NULL;
    }

    size = pcm_frames_to_bytes(pb_pcm, pcm_get_buffer_size(pb_pcm));
    buffer = malloc(size);
    if (!buffer) {
        AmtPrintf(AMT_ERROR "Unable to allocate %d bytes\n", size);
       // free(buffer);
        pcm_close(cap_pcm);
        return NULL;
    }

    memcpy(buffer, buffer2k8000, size);      
    if (pcm_write(pb_pcm, buffer, size)) {
         AmtPrintf(AMT_ERROR "Error playing sample\n");
	  free(buffer);
          return NULL;
    }	

    do {
		memcpy(buffer, buffer2k8000, size);      
        if (pcm_write(pb_pcm, buffer, size)) {
            AmtPrintf(AMT_ERROR "Error playing sample\n");
            break;
        }
 
    } while (cap_running > 0);

    free(buffer);
	
    printf("pb_thread\n");
    AmtPrintf(AMT_INFO "pb_thread\n");
    pthread_exit(0);

	return NULL;
}
#endif

int get_audioloop_result(FILE* file, int sampfs)
{
    int  ret = -1,  i = 0, num_read;
	unsigned char testCount = 0, testSucessCount = 0;
	zDrvVp_Freqfft temp = { 0,0 };
	double freq[20] = {0};
	double freqAmp[20] = {0};
	double toneRealFreq = 1000; //2000
	testCount = 20;
	char *buffer = NULL;

    buffer = malloc(2048);
    if (!buffer) 
	{
        AmtPrintf(AMT_ERROR "Unable to allocate %d bytes\n", 2048);
        return -1;
    }
	
	if(fseek(file, 3200, SEEK_SET)!= 0)
	{
	    free(buffer);
		return -1;
	}

	while (testCount > 0)
	{
		//todo
//		zOss_Memcpy(audioPra->dest, audioPra->src, 2048); //2048byte
//		fseek(file, 0, SEEK_SET);
        num_read = fread(buffer, 1, 2048, file);
        if (num_read <= 0) {
			printf("file end\n");
			AmtPrintf(AMT_ERROR "file end\n");
			free(buffer);
			return -1;
		}
		cal_freq_fft((short *)buffer, &temp, 1024, sampfs);//1024 point fft//xiu

		freq[testCount - 1] = temp.freqValue;
		freqAmp[testCount - 1] = temp.freqAmp;
		if (((fabs(freq[testCount - 1] - toneRealFreq)) < 50) && (freqAmp[testCount - 1] > 300))
		{
			testSucessCount++;
			if (testSucessCount >= 5)
			{
				printf("testSucessCount=%d!\n", testSucessCount);
				AmtPrintf(AMT_INFO "testSucessCount=%d!\n", testSucessCount);
				ret = 0;
				testCount--;
				break;
			}
		}
		
		testCount--;
	
	}


	for (i = 19; i >= testCount; i--)
	{
		printf("get_audioloop_result freq[%d]=%f freqAmp =%f!\n", i, freq[i], freqAmp[i]);
		AmtPrintf(AMT_INFO "get_audioloop_result freq[%d]=%f freqAmp =%f!\n", i, freq[i], freqAmp[i]);
	}

	free(buffer);
	return ret;
}
/**************************************************ⲿӿ****************************************************/
#if 0
extern int MMI_Test_TestInfo(unsigned char *msg_buf, unsigned int *msg_len);
extern int MMI_Test_Keyboard_Start(VOID);
extern int MMI_Test_Keyboard_Stop(unsigned char *msg_buf, unsigned int *msg_len);
extern int MMI_Test_KP_Read(char *msg_buf, unsigned int *msg_len);
extern int MMI_Test_LCD_Start(int color);
extern int MMI_Test_LCD_Stop(VOID);
extern int MMI_Test_LCDBacklight_Start(int value);
extern int MMI_Test_LCDBacklight_Stop(VOID);
extern int MMI_Test_Vibrator_Start(int timeout);
extern int MMI_Test_Vibrator_Stop(VOID);
extern int MMI_Test_SIM_Read(int index, char* msg_buf, unsigned int *msg_len);
extern int MMI_Test_Battery_Voltage(char* msg_buf, unsigned int* msg_len);
extern int MMI_Test_KeyBacklight_Start(VOID);
extern int MMI_Test_KeyBacklight_Stop(VOID);
extern int MMI_Test_Camera_Back_Start(VOID);
extern int MMI_Test_Camera_Back_Stop(VOID);
extern int MMI_Test_Camera_Back_Snapshot(unsigned char *msg_buf, unsigned int msg_len);
extern int MMI_Test_SD_Read(int index, char *msg_buf, unsigned int *msg_len);
extern int MMI_Test_Audio_Mic_Speaker(unsigned char *msg_buf, unsigned int msg_len);
extern int MMI_Test_Audio_Mic_Receiver(unsigned char *msg_buf, unsigned int msg_len);
extern int MMI_Test_Audio_Headset_Headset(unsigned char *msg_buf, unsigned int msg_len);
extern int MMI_Test_SetIdle(VOID);

extern FILE* tp_fopen (const char *file_name, const char *mode);
extern int tp_flength(FILE *stream);
extern size_t tp_fread (void *data, size_t size, size_t count, FILE *stream);
extern int tp_fclose(FILE *stream);


/**************************************************Խӿ****************************************************/
static int Amt_Test_Status_Idle(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

    if (MMI_Test_SetIdle() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}

static int Amt_Test_Init(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    unsigned int ret = 0;
#if 0
    ZOSS_S_TIMEVAL tv = {0};

    /* Initialize OS Time */
    if (ZOSS_SUCCESS == zOss_Gettimeofday(&tv, NULL))
    {
        settimeofday(&tv, NULL);
    }

    /* Initialize CFG */
    zCfg_Init();

    ret = zOss_MountDynamicDisk("C:", "/c", "cpfs", "yaffs");
    zOss_ASSERT(ret == ZOSS_SUCCESS);

    zApp_Init();

#ifdef _CONFIG_USE_VOICE
    ret = zDrvVoiceConfig_Init();
    if (ret != ZOSS_SUCCESS)
    {
        result = AMT_ERROR;
    }
    else
#endif
    {
        result = AMT_SUCCESS;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
#endif
    return result;
}

static int Amt_Test_TestInfo(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    unsigned int nSize = 0;
    unsigned char *pBuf = NULL;

    MMI_Test_TestInfo(NULL, &nSize);

    if (nSize > 0)
    {
        pBuf = (unsigned char *)malloc(nSize);
        memset(pBuf, 0, nSize);

        if (MMI_Test_TestInfo(pBuf, &nSize) == 0)
        {
            result = AMT_SUCCESS_RET;
            Amt_DeviceTest_SendMsg(msg_id, result, pBuf, nSize);
            free(pBuf);
            return result;
        }

        free(pBuf);
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}
#endif
static int Amt_Test_Keyboard_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	 UNUSED(msg_id);
	 UNUSED(msg_buf);
	 UNUSED(msg_len);

     //MMIͿʼ
    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_KEY_TEST_START_REQ, 0, NULL);
	
    #if 0
    if (MMI_Test_Keyboard_Start() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
     #endif
    return result;
}

static int Amt_Test_Keyboard_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    #if 0
    unsigned int nSize = 0;
    unsigned char *pBuf = NULL;
	
    nSize = 2*sizeof(T_ZWndEm_CheckKey);
    pBuf = (char *)malloc(nSize);
    memset(pBuf, 0, nSize);
    #endif
    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_KEY_TEST_STOP_REQ, 0, NULL);
    #if 0
    MMI_Test_Keyboard_Stop(NULL, &nSize);

    if (nSize > 0)
    {
        pBuf = (unsigned char *)malloc(nSize);
        memset(pBuf, 0, nSize);

        if (MMI_Test_Keyboard_Stop(pBuf, &nSize) == 0)
        {
            result = AMT_SUCCESS_RET;
            Amt_DeviceTest_SendMsg(msg_id, result, pBuf, nSize);
            free(pBuf);
            return result;
        }

        free(pBuf);
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}
#if 0
static int Amt_Test_Keyboard_Read(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    unsigned int nSize = 0;
    unsigned char *pBuf = NULL;

    MMI_Test_KP_Read(NULL, &nSize);

    if (nSize > 0)
    {
        pBuf = (unsigned char *)malloc(nSize);
        memset(pBuf, 0, nSize);

        if (MMI_Test_KP_Read((char *)pBuf, &nSize) == 0)
        {
            result = AMT_SUCCESS_RET;
            Amt_DeviceTest_SendMsg(msg_id, result, pBuf, nSize);
            free(pBuf);
            return result;
        }

        free(pBuf);
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}
#endif
static int Amt_Test_LCD_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    int color;

	UNUSED(msg_id);
	UNUSED(msg_len);

    memcpy(&color, msg_buf, sizeof(int));

    if (color >= 0 && color < MAX_LCD_COLOR_NUM)
    {
         platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_LCD_TEST_START_REQ, sizeof(int), (unsigned char*)&color);
	 #if 0
        if (MMI_Test_LCD_Start(color) == 0)
        {
            result = AMT_SUCCESS_RET;
        }
	#endif
    }

    //Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
	
    return result;
}

static int Amt_Test_LCD_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_LCD_TEST_STOP_REQ, 0, NULL);
    #if 0
    if (MMI_Test_LCD_Stop() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

static int Amt_Test_LCDBacklight_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    int value;

	UNUSED(msg_id);
	UNUSED(msg_len);

    memcpy(&value, msg_buf, sizeof(int));
    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_LCD_BACKLIGHT_TEST_START_REQ, sizeof(int), (unsigned char*)&value);
    #if 0
    if (MMI_Test_LCDBacklight_Start(value) == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

static int Amt_Test_LCDBacklight_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_LCD_BACKLIGHT_TEST_STOP_REQ, 0, NULL);
    #if 0
    if (MMI_Test_LCDBacklight_Stop() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

static int Amt_Test_Vibrator_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    int timeout = -1;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_VIBRATOR_TEST_START_REQ, sizeof(int), (unsigned char*)&timeout);
    #if 0
    if (MMI_Test_Vibrator_Start(-1) == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

static int Amt_Test_Vibrator_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_VIBRATOR_TEST_STOP_REQ, 0, NULL);
    #if 0
    if (MMI_Test_Vibrator_Stop() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

#if 0
static int Amt_Test_SIM_Read(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    unsigned int nSize = 0;
    char *pBuf = NULL;
    int index = 0;
    memcpy(&index, msg_buf, sizeof(int));

    MMI_Test_SIM_Read(index, NULL, &nSize);

    if (nSize > 0)
    {
        pBuf = (char *)malloc(nSize);
        memset(pBuf, 0, nSize);

        if (MMI_Test_SIM_Read(index, pBuf, &nSize) == 0)
        {
            result = AMT_SUCCESS_RET;
            Amt_DeviceTest_SendMsg(msg_id, result, (unsigned char *)pBuf, nSize);
            free(pBuf);
            return result;
        }

        free(pBuf);
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}

static int Amt_Test_SD_Read(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    unsigned int nSize = 0;
    char *pBuf = NULL;
    int index = 0;
    memcpy(&index, msg_buf, sizeof(int));

    MMI_Test_SD_Read(index, NULL, &nSize);

    if (nSize > 0)
    {
        pBuf = (char *)malloc(nSize);
        memset(pBuf, 0, nSize);

        if (MMI_Test_SD_Read(index, pBuf, &nSize) == 0)
        {
            result = AMT_SUCCESS_RET;
            Amt_DeviceTest_SendMsg(msg_id, result, (unsigned char *)pBuf, nSize);
            free(pBuf);
            return result;
        }

        free(pBuf);
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}
#endif
static int Amt_Test_Battery_Voltage(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    #if 0
    unsigned int nSize = 0;
    char *pBuf = NULL;
	
    //MMI͵صѹ
    nSize = sizeof(MAN_BATTERY_STATUS);
    pBuf = (char *)malloc(nSize);
    memset(pBuf, 0, nSize);
    #endif
    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_BATTERY_VOLTAGE_TEST_REQ, 0, NULL);
    #if 0
    MMI_Test_Battery_Voltage(NULL, &nSize);

    if (nSize > 0)
    {
        pBuf = (char *)malloc(nSize);
        memset(pBuf, 0, nSize);

        if (MMI_Test_Battery_Voltage(pBuf, &nSize) == 0)
        {
            result = AMT_SUCCESS_RET;
            Amt_DeviceTest_SendMsg(msg_id, result, (unsigned char *)pBuf, nSize);
            free(pBuf);
            return result;
        }

        free(pBuf);
    }
  
    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

static int Amt_Test_Battery_Temperature(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    FILE* batteryTempFd = NULL;
    char buf[10] = {0};
    int read_len = 0;
    int battery_temperature = 0; //¶(λ)

	UNUSED(msg_buf);
	UNUSED(msg_len);

    batteryTempFd = fopen(BATTERY_TEMPERATURE_PATH, "r");
    //AmtPrintf(AMT_INFO "%s: batteryTempFd =0x%08x\n", __FUNCTION__, batteryTempFd);
    if(batteryTempFd == NULL)
    {
        AmtPrintf(AMT_ERROR "%s:battery temperature open error,path is \"%s\"!\n",__FUNCTION__, BATTERY_TEMPERATURE_PATH);
	    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
	    return result;
    }
    else
    { 
        read_len = fread(buf, 1, sizeof(buf) - 1, batteryTempFd);
	    AmtPrintf(AMT_INFO "%s:battery temperature read_len=%d\n",__FUNCTION__, read_len);
	    if(read_len > 0)
	    {
	        AmtPrintf(AMT_INFO "%s:battery temperature read:%s\n",__FUNCTION__, buf);
	        battery_temperature = atoi(buf);
	        AmtPrintf(AMT_INFO "%s:battery temperature = %d\n",__FUNCTION__, battery_temperature);
	        result = AMT_SUCCESS_RET;
	    }
	    fclose(batteryTempFd);
   }
   Amt_DeviceTest_SendMsg(msg_id, result, (unsigned char *)&battery_temperature, sizeof(battery_temperature));
   return result;
}

static int Amt_Test_Charger_Status(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    FILE* chargerStatusFd = NULL;
    char buf[50] = {0};
    int read_len = 0;

	UNUSED(msg_buf);
	UNUSED(msg_len);

    chargerStatusFd = fopen(CHARGER_STATUS_PATH, "r");
    //AmtPrintf(AMT_INFO "%s: chargerStatusFd =0x%08x\n", __FUNCTION__, chargerStatusFd);
    if(chargerStatusFd == NULL)
    {
        AmtPrintf(AMT_ERROR "%s:charger status open error,path is \"%s\"!\n",__FUNCTION__, CHARGER_STATUS_PATH);
	    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
	    return result;
    }
    else
    { 
        read_len = fread(buf, 1, sizeof(buf) - 1 , chargerStatusFd);
	    AmtPrintf(AMT_INFO "%s:charger status read_len=%d\n",__FUNCTION__, read_len);
	    if(read_len > 0)
	    {
	        AmtPrintf(AMT_INFO "%s:charger status read:%s\n",__FUNCTION__, buf);
	        if(!strncmp(buf,"Charging",strlen("Charging")) || !strncmp(buf,"Full",strlen("Full")))
	        {
	     	    result = AMT_SUCCESS_RET;
	        }
	    }
	 
	    fclose(chargerStatusFd);
   }
   Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
   return result;
}

#if 0
static int Amt_Test_KeyBacklight_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result;

    if (MMI_Test_KeyBacklight_Start() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}

static int Amt_Test_KeyBacklight_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result;

    if (MMI_Test_KeyBacklight_Stop() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}
#endif
static int Amt_Test_Camera_Back_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_CAMERA_TEST_START_REQ, 0, NULL);
    #if 0
    if (MMI_Test_Camera_Back_Start() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}
#if 0
static int Amt_Test_Camera_Back_Snapshot(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    char PicPath[260] = {0};
    int nSize = 0;
    unsigned char *pBuf = NULL;
    FILE *pFile = NULL;

    if (MMI_Test_Camera_Back_Snapshot((unsigned char *)PicPath, 260) != 0)
    {
        AmtPrintf(AMT_ERROR "%s: MMI_Test_Camera_Back_Snapshot return error!", __FUNCTION__);
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return -1;
    }

    if (PicPath[0] == '\0')
    {
        AmtPrintf(AMT_ERROR "%s: PicPath is empty!", __FUNCTION__);
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return -1;
    }

    if ((pFile = tp_fopen(PicPath, "rb")) == NULL)
    {
        AmtPrintf(AMT_ERROR "%s: Open \"%s\" fail!", __FUNCTION__, PicPath);
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return -1;
    }

    // ȡļС
    if ((nSize = tp_flength(pFile)) <= 0)
    {
        AmtPrintf(AMT_ERROR "%s: nSize(%d) < = 0!", __FUNCTION__, nSize);
        tp_fclose(pFile);
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return -1;
    }

    // 뻺
    pBuf = malloc(nSize);

    // ȡļ
    if (tp_fread(pBuf, 1, nSize, pFile) == nSize)
    {
        result = AMT_SUCCESS_RET;
        Amt_DeviceTest_SendMsg(msg_id, result, pBuf, nSize);
    }
    else
    {
        AmtPrintf(AMT_ERROR "%s: tp_fread error!", __FUNCTION__);
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    }

    free(pBuf);
    tp_fclose(pFile);

    return result;
}
#endif
static int Amt_Test_Camera_Back_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_CAMERA_TEST_STOP_REQ, 0, NULL);
    #if 0
    if (MMI_Test_Camera_Back_Stop() == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

#ifdef _USE_VOICE_SUPPORT
static int Amt_Test_Audio_Mic_Receiver(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_RECEIVER_TEST_REQ, 0, NULL);
    #if 0
    if (MMI_Test_Audio_Mic_Receiver(msg_buf, msg_len) == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    return result;
}

static int Amt_Test_Audio_Mic_Receiver_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_RECEIVER_TEST_STOP_REQ, 0, NULL);
    return result;
}

static int Amt_Test_Audio_Mic_Speaker(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_buf);
	UNUSED(msg_len);

    //platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_SPEAKER_TEST_REQ, 0, NULL);
    #if 0
    if (MMI_Test_Audio_Mic_Speaker(msg_buf, msg_len) == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    #endif
    #if 0
    //Ľӿ¼
    struct mixer *mixer;
    struct pcm_config config;
    struct pcm *cap_pcm, *pb_pcm;
    char *buffer;
    unsigned int size;
    unsigned int bytes_read = 0;
    FILE *file;
    int num_read;
    int errNum = 0;

	mixer = mixer_open(0);
	mix_set_input_path(mixer, T_INPUT_MICLP);
	mix_set_input_vol(mixer, T_AUDIO_INPUT_VOL_LEVEL_11);
	mixer_close(mixer);

    memset(&config, 0, sizeof(config));
    config.channels = 1;
    config.rate = 8000;
    config.period_size = 320;
    config.period_count = 3;
    config.format = PCM_FORMAT_S16_LE;
    config.start_threshold = 0;
    config.stop_threshold = 0;
    config.silence_threshold = 0;

	file = fopen("/mnt/userdata/cache/cap.bin", "wb+");
    if (!file) {
	errNum = errno;
	AmtPrintf(AMT_ERROR "%s:Unable to create file cap.bin,errNum=%d,reason=%s\n",\
		__FUNCTION__,errNum,strerror(errNum));
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return result;
    }
	
    cap_pcm = pcm_open(0, 0, PCM_IN, &config);
    if (!cap_pcm || !pcm_is_ready(cap_pcm)) {
        AmtPrintf(AMT_ERROR "Unable to open PCM device (%s)\n",
                pcm_get_error(cap_pcm));
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return result;
    }

    size = pcm_frames_to_bytes(cap_pcm, pcm_get_buffer_size(cap_pcm));
    buffer = malloc(size);
    if (!buffer) {
        AmtPrintf(AMT_ERROR "Unable to allocate %d bytes\n", size);
        free(buffer);
        pcm_close(cap_pcm);
         Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return result;
    }

    while (!pcm_read(cap_pcm, buffer, size)) {
        if (fwrite(buffer, 1, size, file) != size) {
            AmtPrintf(AMT_ERROR "Error capturing sample\n");
            break;
        }
        bytes_read += size;
		if (bytes_read >= 80000)
			break;
    }

    pcm_close(cap_pcm);

	mixer = mixer_open(0);
	mix_set_output_path(mixer, T_OUTPUT_SPEAKER);
	mix_set_output_vol(mixer, T_AUDIO_OUTPUT_VOL_LEVEL_11);
	mixer_close(mixer);

    pb_pcm = pcm_open(0, 0, PCM_OUT, &config);
    if (!pb_pcm || !pcm_is_ready(pb_pcm)) {
        AmtPrintf(AMT_ERROR "Unable to open PCM device (%s)\n",
                pcm_get_error(pb_pcm));
	 free(buffer);
          Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return result;
    }

	fseek(file, 0, SEEK_SET);
	
    do {
        num_read = fread(buffer, 1, size, file);
        if (num_read > 0) {
            if (pcm_write(pb_pcm, buffer, num_read)) {
                AmtPrintf(AMT_ERROR "Error playing sample\n");
                break;
            }
        }
    } while (num_read > 0);

    free(buffer);
    pcm_close(pb_pcm);
	fclose(file);
	
     remove("/mnt/userdata/cache/cap.bin");
     result = AMT_SUCCESS_RET;
     Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
#endif
    int ret;

#if 1	
	cap_running = 1;
	
	ret = pthread_create(&pb_thread_tid, NULL, audio_pb_thread, NULL);		
	if(ret != 0){		
		printf ("Create pb_thread error!\n"); 
		AmtPrintf(AMT_ERROR "Create pb_thread error!\n");
		Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
                return result;
	} 
	ret = pthread_create(&ca_thread_tid, NULL, audio_ca_thread, NULL);		
	if(ret != 0){		
		printf ("Create ca_thread error!\n"); 
		AmtPrintf(AMT_ERROR "Create ca_thread error!\n");
		Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
                return result;
	} 

	pthread_join(ca_thread_tid, NULL);
	pthread_join(pb_thread_tid, NULL);
	printf("AmtAgent_Test_Audio_Mic_Speaker\n");
	AmtPrintf(AMT_INFO "AmtAgent_Test_Audio_Mic_Speaker\n");
#endif

	pcm_close(pb_pcm);
    pcm_close(cap_pcm);
    printf("cap 1 stop\n");
	AmtPrintf(AMT_INFO "cap 1 stop\n");

	ret = get_audioloop_result(file, 8000);

	fclose(file);

	AmtPrintf(AMT_INFO "ret = %d\n",ret);
    Amt_DeviceTest_SendMsg(msg_id, ret , NULL, 0);
	if(remove("/mnt/userdata/cache/cap.bin") != 0)
	{
	   AmtPrintf(AMT_INFO "remove \"/mnt/userdata/cache/cap.bin\" error! errno=%d(%s)\n",errno,strerror(errno));
	}
    return result;
}

static int Amt_Test_Audio_Mic_Speaker_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_SPEAKER_TEST_STOP_REQ, 0, NULL);
    return result;
}


#if 0
static int Amt_Test_Audio_Headset_Headset(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result;

    if (MMI_Test_Audio_Headset_Headset(msg_buf, msg_len) == 0)
    {
        result = AMT_SUCCESS_RET;
    }
    else
    {
        result = AMT_ERROR_RET;
    }

    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}
#endif
#endif

static int Amt_Test_TP_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
	
	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);
	
    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_TP_TEST_START_REQ, 0, NULL);
    return result;
}

static int Amt_Test_TP_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);
	
    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_TP_TEST_STOP_REQ, 0, NULL);
    return result;
}

static int Amt_Test_TP_Board(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    FILE* tpFd = NULL;
    char buf[10] = {0};
    int read_len = 0;
    int tp_result = 0;

	UNUSED(msg_buf);
	UNUSED(msg_len);

    tpFd = fopen(TP_MODE_PATH, "r");
    //AmtPrintf(AMT_INFO "%s: tpFd =0x%08x\n", __FUNCTION__, tpFd);
    if(tpFd == NULL)
    {
        AmtPrintf(AMT_ERROR "%s:tp device open error,path is \"%s\"!\n",__FUNCTION__, TP_MODE_PATH);
        Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
        return result;
    }
    else
    { 
        read_len = fread(buf, 1, sizeof(buf) - 1, tpFd);
        AmtPrintf(AMT_INFO "%s:tp read_len=%d\n",__FUNCTION__, read_len);
        if(read_len > 0)
        {
            AmtPrintf(AMT_INFO "%s:tp read:%s\n",__FUNCTION__, buf);
            tp_result = atoi(buf);
            AmtPrintf(AMT_INFO "%s:tp mode = %d\n",__FUNCTION__, tp_result);
            if(tp_result != 0xff)
            {
                result = AMT_SUCCESS_RET;
            }
        }
        fclose(tpFd);
    }
    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}

static int Amt_Test_GSensor_Board(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    int fd_gsensor = open(DEVICE_GSENSOR, O_RDWR);

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    if (fd_gsensor < 0)
    {
        AmtPrintf(AMT_ERROR "Failed to open \"%s\"!\n", DEVICE_GSENSOR);
    }
    else
    {
        close(fd_gsensor);
    	result  = AMT_SUCCESS_RET;
    }
    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}

static int Amt_Test_Camera_Board(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    int fd_camera = open(DEVICE_CAMERA, O_RDWR);
	
	UNUSED(msg_buf);
	UNUSED(msg_len);

    if (fd_camera < 0)
    {
        AmtPrintf(AMT_ERROR "Failed to open \"%s\"!\n", DEVICE_CAMERA);
    }
    else
    {
        close(fd_camera);
    	result  = AMT_SUCCESS_RET;
    }
    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}

static int Amt_Test_LCD_Board(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
    int fd_LCD = open(DEVICE_LCD, O_RDWR);
	
	UNUSED(msg_buf);
	UNUSED(msg_len);

    if (fd_LCD < 0)
    {
        AmtPrintf(AMT_ERROR "Failed to open \"%s\"!\n", DEVICE_LCD);
    }
    else
    {
        close(fd_LCD);
    	result  = AMT_SUCCESS_RET;
    }
    Amt_DeviceTest_SendMsg(msg_id, result, NULL, 0);
    return result;
}

static int Amt_Test_GSensor_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);
	
    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_GSENSOR_TEST_START_REQ, 0, NULL);
    return result;
}

static int Amt_Test_GSensor_Stop(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;
	
	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_GSENSOR_TEST_STOP_REQ, 0, NULL);
    return result;
}

static int Amt_Test_Flashlight_Start(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_FLASHLIGHT_START_REQ, 0, NULL);
    return result;
}

static int Amt_Test_Wifi(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    int result = AMT_ERROR_RET;

	UNUSED(msg_id);
	UNUSED(msg_buf);
	UNUSED(msg_len);

    platform_send_msg(MODULE_ID_AMT, MODULE_ID_MMI_SVR, MSG_CMD_AMT_WIFI_TEST_START_REQ, 0, NULL);
    return result;
}
/**
 *
 */
static const T_COMMAND g_CmdTable[] =
{
   #if 0
    // Common
    {TEST_COMMON, MSG_DEVICETEST_STATUS_IDLE, Amt_Test_Status_Idle, "Set idle status"},
    {TEST_COMMON, MSG_DEVICETEST_TESTINIT, Amt_Test_Init, "Test init"},
    // TestInfo
    {TEST_INFO, MSG_DEVICETEST_TESTINFO, Amt_Test_TestInfo, "Get test information"},
    #endif
    //Keyboard
    {TEST_KEYBOARD, MSG_DEVICETEST_KEYBOARD_START, Amt_Test_Keyboard_Start, "Start Keyboard test"},
    {TEST_KEYBOARD, MSG_DEVICETEST_KEYBOARD_STOP, Amt_Test_Keyboard_Stop, "Stop Keyboard test"},
    //{TEST_KEYBOARD, MSG_DEVICETEST_KEYBOARD_READ, Amt_Test_Keyboard_Read, "Read Keyboard state"},
    //LCD
    {TEST_LCD, MSG_DEVICETEST_LCD_START, Amt_Test_LCD_Start, "Start LCD test"},
    {TEST_LCD, MSG_DEVICETEST_LCD_STOP, Amt_Test_LCD_Stop, "Stop LCD test"},
    {TEST_LCD, MSG_DEVICETEST_LCD_BOARD, Amt_Test_LCD_Board, "Board LCD test"},
    //LCD backlight
    {TEST_LCDBACKLIGHT, MSG_DEVICETEST_LCDBACKLIGHT_START, Amt_Test_LCDBacklight_Start, "Start LCD backlight test"},
    {TEST_LCDBACKLIGHT, MSG_DEVICETEST_LCDBACKLIGHT_STOP, Amt_Test_LCDBacklight_Stop, "Stop LCD backlight test"},
    // Vibrator
    {TEST_VIBRATOR, MSG_DEVICETEST_VIBRATOR_START, Amt_Test_Vibrator_Start, "Start vibrator test"},
    {TEST_VIBRATOR, MSG_DEVICETEST_VIBRATOR_STOP, Amt_Test_Vibrator_Stop, "Stop vibrator test"},
    // SIM
    //{TEST_SIM, MSG_DEVICETEST_SIM_READ, Amt_Test_SIM_Read, "SIM card test"},
    // SD
    //{TEST_SD, MSG_DEVICETEST_SD_READ, Amt_Test_SD_Read, "SD card test"},
   
    //Battery
    {TEST_BATTERY, MSG_DEVICETEST_BATTERY_VOLTAGE, Amt_Test_Battery_Voltage, "Battery voltage test"},
    {TEST_BATTERY, MSG_DEVICETEST_BATTERY_TEMPERATURE, Amt_Test_Battery_Temperature, "Battery temperature test"},
    //Charger
     {TEST_CHARGER, MSG_DEVICETEST_CHARGER_STATUS, Amt_Test_Charger_Status, "Charger status test"},
    #if 0
    // Keybacklight
    {TEST_KEYBACKLIGHT, MSG_DEVICETEST_KEYBACKLIGHT_START, Amt_Test_KeyBacklight_Start, "Start Key backlight test"},
    {TEST_KEYBACKLIGHT, MSG_DEVICETEST_KEYBACKLIGHT_STOP, Amt_Test_KeyBacklight_Stop, "Stop Key backlight test"},
    #endif
    // Camera
    {TEST_CAMERA_BACK, MSG_DEVICETEST_CAMERA_BACK_START, Amt_Test_Camera_Back_Start, "Start back camera test"},
    //{TEST_CAMERA_BACK, MSG_DEVICETEST_CAMERA_BACK_SNAPSHOT, Amt_Test_Camera_Back_Snapshot, "Back camera snapshot test"},
    {TEST_CAMERA_BACK, MSG_DEVICETEST_CAMERA_BACK_STOP, Amt_Test_Camera_Back_Stop, "Stop back camera test"},
    {TEST_CAMERA_BACK, MSG_DEVICETEST_CAMERA_BOARD, Amt_Test_Camera_Board, "Board camera test"},
    // Audio
    // Audio
#ifdef _USE_VOICE_SUPPORT
    {TEST_AUDIO, MSG_DEVICETEST_AUDIO_MIC_RECEIVER, Amt_Test_Audio_Mic_Receiver, "Mic-Receiver test"},
     {TEST_AUDIO, MSG_DEVICETEST_AUDIO_MIC_RECEIVER_STOP, Amt_Test_Audio_Mic_Receiver_Stop, "Stop Mic-Receiver test"},
    {TEST_AUDIO, MSG_DEVICETEST_AUDIO_MIC_SPEAKER, Amt_Test_Audio_Mic_Speaker, "Mic-Speaker test"},
    {TEST_AUDIO, MSG_DEVICETEST_AUDIO_MIC_SPEAKER_STOP, Amt_Test_Audio_Mic_Speaker_Stop, "Stop Mic-Speaker test"},
   //{TEST_AUDIO, MSG_DEVICETEST_AUDIO_HEADSET_HEADSET, Amt_Test_Audio_Headset_Headset, "Headset test"},
#endif
     // TP
    {TEST_TP, MSG_DEVICETEST_TP_START,  Amt_Test_TP_Start, "Start TP test"},
    {TEST_TP, MSG_DEVICETEST_TP_STOP,  Amt_Test_TP_Stop, "Stop TP test"},
    {TEST_TP, MSG_DEVICETEST_TP_BOARD,  Amt_Test_TP_Board, "Board TP test"},
     // G-Sensor
    {TEST_GSENSOR, MSG_DEVICETEST_GSENSOR_START,  Amt_Test_GSensor_Start, "Start G-Sensor test"},
    {TEST_GSENSOR, MSG_DEVICETEST_GSENSOR_STOP,  Amt_Test_GSensor_Stop, "Stop G-Sensor test"},
    {TEST_GSENSOR, MSG_DEVICETEST_GSENSOR_BOARD,  Amt_Test_GSensor_Board, "Board G-Sensor test"},
     // flashlight
    {TEST_FLASH_LIGHT, MSG_DEVICETEST_FLASHLIGHT_START,  Amt_Test_Flashlight_Start, "Flashlight test"},
     // wifi
    {TEST_WIFI, MSG_DEVICETEST_WIFI,  Amt_Test_Wifi, "wifi test"}
};

static const int g_CmdTableCount = sizeof(g_CmdTable) / sizeof(T_COMMAND);

/**
 * @brief AMTԳʼ
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_DeviceTest_Init(void)
{
    AmtPrintf(AMT_INFO "%s", __FUNCTION__);
    return 0;
}


/**
 * @brief AMTϢ
 * @param[in] msg_id FID
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_DeviceTest_ProcessMsg(unsigned int msg_id, unsigned char* msg_buf, unsigned int msg_len)
{
    int i;

    AmtPrintf(AMT_INFO "%s: Device test message: %#04x.\n", __FUNCTION__, msg_id);

    for (i = 0; i < g_CmdTableCount; i++)
    {
        if (msg_id == g_CmdTable[i].msg_id)
        {
            if (g_CmdTable[i].fun != NULL)
            {
                AmtPrintf(AMT_INFO "%s: %s.\n", __FUNCTION__, g_CmdTable[i].test_name);
                if (g_CmdTable[i].fun(msg_id, msg_buf, msg_len) == AMT_SUCCESS_RET)
                {
                    //AmtPrintf(AMT_INFO "%s: %s success.\n", __FUNCTION__, g_CmdTable[i].test_name);
                    return 0;
                }
                else
                {
                    //AmtPrintf(AMT_ERROR "%s: %s fail.\n", __FUNCTION__, g_CmdTable[i].test_name);
                    return -1;
                }
            }
            else
            {
                return -1;
            }
        }
    }

    AmtPrintf(AMT_ERROR "%s: Can't find the message: %#04x.\n", __FUNCTION__, msg_id);
    return -1;
}


/**
 * @brief AMTϢPC
 * @param[in] msg_id FID
 * @param[in] result ״̬
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_DeviceTest_SendMsg(unsigned int msg_id, int result, unsigned char* msg_buf, unsigned int msg_len)
{
    unsigned int nRspLen = sizeof(T_DeviceTest_Header) + msg_len;
    T_DeviceTest_Header *pHeader = (T_DeviceTest_Header *)malloc(nRspLen);

    if (pHeader != NULL)
    {
        pHeader->result = result;
        pHeader->length = msg_len;

        if (msg_buf != NULL && msg_len > 0)
        {
            memcpy(pHeader + 1, msg_buf, msg_len);
        }

        if(Amt_CreateResponse(msg_id, (unsigned char *)pHeader, nRspLen) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        }
		else
        {
            AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
       	}
        free(pHeader);
        return 0;
    }
    else
    {
        return -1;
    }
}


