#include "wlan_config_ssid.h"
#include "wifi_hal.h"
#include "wifi_util.h"
#include "rtk_arch.h"
#include "softap_api.h"


const CHAR base[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
static VOID setWifiKeyForImei (CHAR* outkey, CHAR* imeistr, UINT32 num);


static void wlan_set_change_ssid_key_status()
{
	//Zssid_SendMsgFromQueue(MODULE_ID_MMI, MSG_CMD_MODIFY_SSID_KEY, 0, NULL);
	ipc_send_message (MODULE_ID_ZSSID, MODULE_ID_MMI, MSG_CMD_MODIFY_SSID_KEY, 0, NULL, 0);
}

/**********************************************************************************
:ƴSSID , c ΪӷnumΪƵmacλ
***********************************************************************************/
static INT make_user_mac (CHAR * s_mac)
{
	CHAR last_mac[20] = {0};
	CHAR ssid[40] = {0};
	CHAR m_ssid[40] = {0};
    CHAR ssid_cmd[128] = {0};
#ifdef USE_CAP_SUPPORT   //(&& WIFI_5G_SUPPORT)	
	CHAR ssid_5g[40] = {0};
	CHAR m_ssid_5g[40] = {0};
#endif	
	CHAR sLastbyte[3] = {0};
	INT num = 0;
	INT i = 0;
	int ret = 0;
	sc_cfg_get ("wifi_ssid_gen_with_mac_lastbyte", sLastbyte, 3);
	for (i = 0; i < strlen (sLastbyte); i++) {
		num = (sLastbyte[i] - '0') + num * 10;
	}
	wf_log ("make_user_mac  num = %d", num);
	if ( (NULL == s_mac) || (num <= 0) || (num > 12)) {
		wf_log ("make_user_mac  error..");
		return -1;
	}
	/*ȡSSID1 macַλ*/
	sc_cfg_get ("SSIDbak", ssid, sizeof (ssid));

	wf_log ("old ssid = %s", ssid);

	strcpy (&last_mac[0], &s_mac[WLAN_MAC_ADDR_LEN - num]);
	strcat (ssid, last_mac);

	if (strlen (ssid) > 32) {
		wf_log ("mac_len error");
		return -1;
	}

	sprintf (m_ssid, "%s_2", ssid);

	sc_cfg_set ("SSID1", ssid);
	sc_cfg_set ("m_SSID", m_ssid);
#ifdef USE_CAP_SUPPORT   //(&& WIFI_5G_SUPPORT)
	sprintf(ssid_5g, "%s_5G", ssid);
	sprintf(m_ssid_5g, "%s_2_5G", ssid);
	sc_cfg_set ("SSID1_5g", ssid);
	sc_cfg_set ("m_SSID_5g", m_ssid);
#endif
	sc_cfg_set ("ssid_write_flag", "1"); //nvеı־λ1ʾSSIDд롣
	//sc_cfg_save();
	//softap_log(LOG_INFO,WIFI_PRINT,">-------------- ssid = %s", ssid);
	wf_log (">-------------- ssid = %s", ssid);
	wlan_set_change_ssid_key_status();

	//ipc_send_message (MODULE_ID_ZSSID, MODULE_ID_AT_CTL, MSG_CMD_SSID_SET_REQ, 0, NULL, 0); //Ϣat server  ϱSSID
    sprintf(ssid_cmd, "AT+SSID=%s\r", ssid);
    ret = get_modem_info(ssid_cmd, NULL, NULL);
	if (ret != 0) {
		wf_log ("AT+SSID error");
		return -1;
	}

	return 0;
}


static unsigned char proc_readable_ch (unsigned char in)
{
	if (0x30 > in) {
		return (in % 10) + 0x30;
	} else if (0x39 < in && 0x41 > in) {
		return in - 7;
	} else if (0x5A < in && 0x61 > in) {
		return in - 6;
	} else if (0x7A < in) {
		return proc_readable_ch (in - 0x7A);
	}
	return in;
}

VOID zte_filter_charactor (char *ch)
{
	if ('i' == *ch) {
		*ch = 'A';
	} else if ('I' == *ch) {
		*ch = 'B';
	} else if ('l' == *ch) {
		*ch = 'C';
	} else if ('o' == *ch) {
		*ch = 'D';
	} else if ('O' == *ch) {
		*ch = 'E';
	} else if ('q' == *ch) {
		*ch = 'F';
	} else if ('0' == *ch) {
		*ch = 'G';
	} else if ('1' == *ch) {
		*ch = 'H';
	} else if ('9' == *ch) {
		*ch = 'J';
	}
}

static void alpha_to_digital (CHAR* key, UINT32 key_len)
{
	int i = 0;
	if (NULL == key) {
		return;
	}
	wf_log ("before key=%s key_len = %d", key, key_len);
	for (i = 0; i < key_len; i++) {
		if (key[i] < '0' || key[i] > '9') {
			key[i] = key[i] % 10 + 0x30;
		}
	}
	wf_log ("after key=%s ", key);
}
#ifdef WEBS_SECURITY
static void make_password_strong(CHAR* key, UINT32 key_len)
{
    UINT32 rnum = 0;
	int i = 0;
	char punct[] = {'~', '!', '@', '#', '%', '-', '+', '_', '=', '?', '.'};
	char tmpchar = 0;
   
    for (i = 0; i < key_len; i++) {
		rnum = (key[i] - '0') + rnum * 10;
	}

    rnum = rnum % 26;
	*(key + key_len) = 'A' + rnum;

	rnum = 0;
	for (i = 0; i < key_len; i++) {
		rnum = (key[key_len - 1 - i] - '0') + rnum * 10;
	}

	rnum = rnum % 26;
	*(key + key_len + 1) = 'a' + rnum;

	rnum = 0;
	for (i = 0; i < key_len / 2; i++) {
		rnum = (key[i] - '0') + rnum * 10;
	}

	rnum = rnum % (sizeof(punct)/sizeof(punct[0]));
	*(key + key_len + 2) = punct[rnum];

	printf("make_password_strong:%s\n", key);

	tmpchar = *(key);
	*(key) = *(key + key_len);
	*(key + key_len) = tmpchar;

	tmpchar = *(key + 1);
	*(key + 1) = *(key + key_len + 1);
	*(key + key_len + 1) = tmpchar;
   	
}
#endif
static VOID generate_ascii_password (CHAR *macdr, CHAR *outkey, INT outkeylen)
{
	SHORT i = 0;
	SHORT j = 0;
	UCHAR t = 0;
	SHORT ret = -1;
	CHAR imei[16] = {0};
	CHAR only_digit_key[2] = {0};
	CHAR key_gen_type[10] = {0};
	CHAR sLastbyte[3] = {0};
	CHAR sKeylen[3] = {0};
	SHORT iKeylen = 0;
	SHORT iLastbyte = 0;
	SHORT iLimit = 0;

	if (NULL == macdr || NULL == outkey || strlen (macdr) == 0) {
		return;
	}
	ret = sc_cfg_get ("wifi_key_len", sKeylen, 3);
	for (i = 0; i < strlen (sKeylen); i++) {
		iKeylen = (sKeylen[i] - '0') + iKeylen * 10;
	}
	ret = sc_cfg_get ("wifi_key_gen_type", key_gen_type, 10);
	if (ret != -1) {
		wf_log ("wifi_key_gen_type=%s", key_gen_type);
		if (!strncmp (key_gen_type, "DEFAULT", 7)) {
			sc_cfg_get (WLAN_NV_WPAPSK1_NAME, outkey, outkeylen);
			wf_log ("outkey=%s", outkey);
		} else if (!strncmp (key_gen_type, "MAC", 3)) {
			// gen by mac
			ret = sc_cfg_get ("wifi_key_gen_with_mac_lastbyte", sLastbyte, 3);

			if (ret != -1) {
				wf_log ("wifi_key_gen_with_mac_lastbyte=%s", sLastbyte);
				for (i = 0; i < strlen (sLastbyte); i++) {
					iLastbyte = (sLastbyte[i] - '0') + iLastbyte * 10;
				}
				iLimit = (WLAN_MAC_ADDR_LEN - iLastbyte) < 0 ? 0 : (WLAN_MAC_ADDR_LEN - iLastbyte);
				for (i = iLimit; i < WLAN_MAC_ADDR_LEN; i++) {
					outkey[j] = macdr[i];
					j++;
				}
				for (i = 0; i < iLastbyte; i++) {
					if (outkey[i] > 96 && outkey[i] < 123) {
						outkey[i] = outkey[i] - 32;
					}
				}
				outkey[iLastbyte] = '\0';
			} else {

				for (j = 0; j < iKeylen; j++) {
					for (i = 0; i < WLAN_MAC_ADDR_LEN; i++) {
						t ^= macdr[j] & (macdr[i] << (i % 2) ? 1 : 3);
					}
					outkey[j] = proc_readable_ch (t ^ (~macdr[11 - j]));
					zte_filter_charactor (outkey + j);
				}
			}
		} else if (!strncmp (key_gen_type, "IMEI", 4)) {
			// gen by imei
			sc_cfg_get ("imei", imei, sizeof(imei));
			while(strlen(imei) < 15) {
				wf_log ("atctl did not get imei now.");
				wf_ms_sleep (1000);
				sc_cfg_get ("imei", imei, sizeof(imei));
			}
			setWifiKeyForImei (outkey, imei, 8);
		}
	}

	ret = sc_cfg_get ("wifi_key_only_digit", only_digit_key, 2);
	if (0 == strncmp (only_digit_key, "y", 2)) {
		alpha_to_digital (outkey, iKeylen);
	}
#ifdef WEBS_SECURITY
	make_password_strong(outkey, iKeylen);//for security
#else			
	outkey[0] = 'Z';
	outkey[1] = 'z';
#endif
	return;
}

static int make_wifikey (CHAR * key, CHAR * m_key)
{
	char *encode = NULL;

	char * m_encode = NULL;
    char psk_cmd[128]={0};
	int ret = 0;

	if (NULL == key || NULL == m_key) {
		return -1;
	}

	wf_log ("make_wifikey   key=%s,  m_key=%s", key, m_key);

	if (strlen (key) > 0) {
		encode = wlan_base64_encode(key, strlen (key));
		sc_cfg_set ("WPAPSK1", key);
		sc_cfg_set ("WPAPSK1_encode", encode);
#ifdef USE_CAP_SUPPORT   //(&& WIFI_5G_SUPPORT)
		sc_cfg_set ("WPAPSK1_5g", key);
		sc_cfg_set ("WPAPSK1_encode_5g", encode);
#endif
	}

	if (strlen (m_key) > 0) { // protect  multissid  , m_key maybe 0
		m_encode =  wlan_base64_encode(m_key, strlen (m_key));
		sc_cfg_set ("m_WPAPSK1", m_key);
		sc_cfg_set ("m_WPAPSK1_encode", m_encode);
#ifdef USE_CAP_SUPPORT   //(&& WIFI_5G_SUPPORT)
		sc_cfg_set ("m_WPAPSK1_5g", m_key);
		sc_cfg_set ("m_WPAPSK1_encode_5g", m_encode);
#endif
	}
#ifdef __AP_FUNC__
#ifdef __USE_AES__
	//efuse changed...
	wifi_aes_init_key();
	wifi_encrypt_code();
#endif
#endif

	//sc_cfg_save();
	wlan_set_change_ssid_key_status();


	if (encode != NULL) {
		free (encode);
	}
	if (m_encode != NULL) {
		free (m_encode);
	}

    snprintf(psk_cmd, sizeof(psk_cmd), "AT+WIFIKEY=%s\r", key);

	//ipc_send_message (MODULE_ID_WIFI, MODULE_ID_AT_CTL, MSG_CMD_WIFIKEY_SET_REQ, 0, NULL, 0); //Ϣat server
	ret = get_modem_info(psk_cmd, NULL, NULL);
	if (ret != 0) {
		wf_log ("AT+WIFIKEY error");
		return -1;
	}
	return 0;
}

static int set_mac_conf(char *mac, char *mac2)
{
#if defined(__XR_819_CHIP__)
	//xr819 set mac before insmod??
	wf_log ("set_mac_conf:%s", mac);
	wlan_write_file("/etc_rw/wifi/xr_wifi.conf", mac);
#elif defined(__SSV_6X5X_CHIP__)
	//sv6158 set mac before insmod
	char mac_cmd[128]={0};
	snprintf(mac_cmd, sizeof(mac_cmd), "%s\n%s", mac, mac2);
	wf_log ("set_mac_conf:[%s]", mac_cmd);
	wlan_write_file("/etc_rw/wifimac", mac_cmd);
#elif defined(__AIC_8800DW_CHIP__)
	//aic_8800dw set mac before insmod
	char mac_cmd[128]={0};
	snprintf(mac_cmd, sizeof(mac_cmd), "MAC_A1=%s  MAC_A2=%s  MAC_A3=%s\n", mac, mac2, mac2);
	//snprintf(mac_cmd, sizeof(mac_cmd), "MAC_A1=%s\n", mac);
	wf_log ("set_mac_conf:[%s]", mac_cmd);
	wlan_write_file("/etc_rw/aic_macconfig.txt", mac_cmd);
#elif defined(__ESP_8089_CHIP__)
	char mac_cmd[128]={0};
	int ret = 0;

	snprintf(mac_cmd, sizeof(mac_cmd), "AT+MAC=%s\r", s_mac);//no :
	wf_log ("write mac:[%s]", s_mac);

	ret = get_modem_info(mac_cmd, NULL, NULL);
	if (ret != 0) {
		wf_log ("AT+MAC error");
		return -1;
	}
#endif	
	return 0;
}

static VOID setWifiKeyForImei (CHAR* outkey, CHAR* imeistr, UINT32 num)
{
	CHAR old_key[WLAN_NV_WPAPSK1_LENGTH] = {0};
	if (outkey == NULL) {
		wf_log ("outkey is null");
		return ;
	}
	if (imeistr == NULL) {
		wf_log ("imeistr is null");
		return ;
	}
	if (15 != strlen (imeistr)) {
		wf_log ("imeistr is error");
		return ;
	}

	strcpy (&outkey[0], &imeistr[15 - num]);

	sc_cfg_get (WLAN_NV_WPAPSK1_NAME, old_key, WLAN_NV_WPAPSK1_LENGTH);
	if (strcmp (outkey, old_key)) {
		sc_cfg_set (WLAN_NV_WPAPSK1_NAME, outkey);
	}
}

/*

*/
unsigned  char * a2xx (const unsigned char* addr, unsigned char *mac)
{
	int i = 0;
	unsigned char *p = addr;
	unsigned char str[3] = {0};

	for (i = 0; i < 6; i++) {
		strncpy (str, p, 2);
		mac[i] = s2x (str);
		p += 2;
	}

	return mac;
}

/**
 * is_zero_ether_addr - Determine if give Ethernet address is all zeros.
 * @addr: Pointer to a six-byte array containing the Ethernet address
 *
 * Return true if the address is all zeroes.
 *
 * Please note: addr must be aligned to u16.
 */
static  int  is_zero_ether_addr (const unsigned char * a)
{
	return ! (a[0] | a[1] | a[2] | a[3] | a[4] | a[5]);
}

/**
 * is_multicast_ether_addr - Determine if the Ethernet address is a multicast.
 * @addr: Pointer to a six-byte array containing the Ethernet address
 *
 * Return true if the address is a multicast address.
 * By definition the broadcast address is also a multicast address.
 */
static  int  is_multicast_ether_addr (const unsigned char *addr)
{
	return 0x01 & addr[0];
}

/**
 * is_valid_ether_addr - Determine if the given Ethernet address is valid
 * @addr: Pointer to a six-byte array containing the Ethernet address
 *
 * Check that the Ethernet address (MAC) is not 00:00:00:00:00:00, is not
 * a multicast address, and is not FF:FF:FF:FF:FF:FF.
 *
 * Return true if the address is valid.
 *
 * Please note: addr must be aligned to u16.
 */
static  int  is_valid_ether_addr (const unsigned char *addr)
{
	/* FF:FF:FF:FF:FF:FF is a multicast address so we don't need to
	 * explicitly check for it here. */
	return !is_multicast_ether_addr (addr) && !is_zero_ether_addr (addr);
}

/*

*/
static int  is_valid_mac (const char *mac)
{
	unsigned char a[6] = {0};

	a2xx (mac, a);

	wf_log ("addr=%02x%02x%02x%02x%02x%02x", a[0], a[1], a[2], a[3], a[4], a[5]);
	return is_valid_ether_addr ( (const unsigned char *) a);

}

/**********************************************************************************
:MAC ַ

ómacַ

ssid wifikey

дssid wifikey nvֵ

ͨоƬҪд뵽 /mnt/jffs2/firmware/nvram_bcmdhd.txt ļ
***********************************************************************************/
static VOID wlan_setWifiNV (CHAR *macaddress)
{
	CHAR mac[32]   = {0};
	CHAR m_mac[32] = {0};

	CHAR *p = NULL;
	CHAR read_mac[32] = {0};
	CHAR outpassword[32] = {0};
	CHAR wifi_mac_num_str[3] = {0}; // indicate the number of mac needed
	CHAR m_read_mac[32] = {0};
	CHAR m_outpassword[32] = {0};

	int  wifi_mac_num = 0;
	int  ret = -1;

	INT  i = 0;
	INT  valid_mac = 0;
	INT  len = 0, len1 = 0;

	ret = sc_cfg_get ("wifi_mac_num", wifi_mac_num_str, sizeof (wifi_mac_num_str));
	if (ret == 0) {
		wifi_mac_num = atoi (wifi_mac_num_str);
	} else {
		wifi_mac_num = 1;
	}

	len = strlen ("+MAC:");
	len1 = strlen ("+MAC:XXXXXXXXXXXX;"); // 18

	wf_log ("wlan_setWifiNV macaddress=%s", macaddress);

	strncpy (read_mac, macaddress + len, 12);
	if (2 == wifi_mac_num)
		strncpy (m_read_mac, macaddress + len1, 12);

	wf_log ("read mac = %s, m_read_mac=%s", read_mac, m_read_mac);

	char ssid[32] = {0};
	char ssidbak[32] = {0};
	sc_cfg_get ("SSID1", ssid, sizeof (ssid));
	sc_cfg_get ("SSIDbak", ssidbak, sizeof (ssidbak));
	if (strcmp (ssidbak, "") == 0)
		sc_cfg_set ("SSIDbak", ssid);
	if (0 == is_valid_mac (read_mac) || (2 == wifi_mac_num && 0 == is_valid_mac (m_read_mac))) {
		wf_log ("invalid Mac Address read_mac=%s,m_read_mac=%s", read_mac, m_read_mac);
		sc_cfg_set ("ssid_write_flag", "0"); //macϷΪûдɹ
		sc_cfg_set ("SSID1", "Please set Valid MAC firstly");
		sc_cfg_set ("m_SSID", "Please set Valid MAC firstly");
		sc_cfg_set ("wifi_mac", "");
		sc_cfg_set ("m_wifi_mac", "");
		wlan_set_change_ssid_key_status();
		return ;
	}

	//+MAC:XXXXXXXXXXXX;XXXXXXXXXXXX
	sprintf (mac, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c",
	         read_mac[0], read_mac[1], read_mac[2], read_mac[3], read_mac[4], read_mac[5],
	         read_mac[6], read_mac[7], read_mac[8], read_mac[9], read_mac[10], read_mac[11]);

	if (2 == wifi_mac_num) {
		sprintf (m_mac, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c",
		         m_read_mac[0], m_read_mac[1], m_read_mac[2], m_read_mac[3], m_read_mac[4], m_read_mac[5],
		         m_read_mac[6], m_read_mac[7], m_read_mac[8], m_read_mac[9], m_read_mac[10], m_read_mac[11]);

	}
	wf_log ("mac = %s  m_mac= %s", mac, m_mac);

	sc_cfg_set ("wifi_mac", mac);
	if (2 == wifi_mac_num)
		sc_cfg_set ("m_wifi_mac", m_mac);

//    setWifiWpsDefPin();

	generate_ascii_password (read_mac, outpassword, sizeof (outpassword));
	generate_ascii_password (m_read_mac, m_outpassword, sizeof (m_outpassword));
	make_wifikey (outpassword, m_outpassword);
	make_user_mac (read_mac);

	set_mac_conf(mac, m_mac);
}


char *wlan_base64_encode(const char* data, int data_len)
{
	//int data_len = strlen(data);
	int prepare = 0;
	int ret_len;
	int temp = 0;
	char *ret = NULL;
	char *f = NULL;
	int tmp = 0;
	char changed[4];
	int i = 0;
	ret_len = data_len / 3;
	temp = data_len % 3;
	if (temp > 0) {
		ret_len += 1;
	}
	ret_len = ret_len * 4 + 1;
	ret = (char *) malloc (ret_len);

	if (ret == NULL) {
		wf_log ("No enough memory.");
		exit (0);
	}
	memset (ret, 0, ret_len);
	f = ret;
	while (tmp < data_len) {
		temp = 0;
		prepare = 0;
		memset (changed, '\0', 4);
		while (temp < 3) {
			//printf("tmp = %d", tmp);
			if (tmp >= data_len) {
				break;
			}
			prepare = ( (prepare << 8) | (data[tmp] & 0xFF));
			tmp++;
			temp++;
		}
		prepare = (prepare << ( (3 - temp) * 8));
		//printf("before for : temp = %d, prepare = %d", temp, prepare);
		for (i = 0; i < 4 ; i++) {
			if (temp < i) {
				changed[i] = 0x40;
			} else {
				changed[i] = (prepare >> ( (3 - i) * 6)) & 0x3F;
			}
			*f = base[ (UCHAR) changed[i]];
			//printf("%.2X", changed[i]);
			f++;
		}
	}
	*f = '\0';

	return ret;

}


void  send_get_mac_req()
{
	int send_ret = -1;

	char ssid_write_flag[8] = {0};
	sc_cfg_get ("ssid_write_flag", ssid_write_flag, sizeof (ssid_write_flag));
	wf_log ("wifi_ssid_init: ssid_write_flag = %s", ssid_write_flag);
	
	if (!strcmp (ssid_write_flag, "0")) {

		send_ret = ipc_send_message(MODULE_ID_WIFI, MODULE_ID_AT_CTL, MSG_CMD_GET_MAC_REQ, 0, NULL, 0);
		while (send_ret != 0) {
			wf_log ("send message MSG_CMD_GET_MAC to at_ctl to get mac failed");
			wf_ms_sleep (200);
			send_ret = ipc_send_message(MODULE_ID_WIFI, MODULE_ID_AT_CTL, MSG_CMD_GET_MAC_REQ, 0, NULL, 0);
		}
		wf_log ("send message MSG_CMD_GET_MAC to at_ctl to get mac successfully");

	}
}

void  get_mac_config_ssid_key_nv()
{
	char ssid_write_flag[8] = {0};
	char at_wifi_mac[64]    = {0};


	sc_cfg_get ("ssid_write_flag", ssid_write_flag, sizeof (ssid_write_flag));
	wf_log ("wifi_ssid_init: ssid_write_flag = %s", ssid_write_flag);

	/*NVǷдSSID ı־λȽϣΪ1ʾд룬д0ʾδд*/
	if (!strcmp (ssid_write_flag, "0")) {
	
		sc_cfg_get ("at_wifi_mac", at_wifi_mac, sizeof (at_wifi_mac));
		if (strncmp (at_wifi_mac, "0", 2) == 0) {
			wf_log ("at_wifi_mac is null ");
			do {
				wf_log ("ATMain did not get MAC from CP.");
				wf_ms_sleep (1000);
				sc_cfg_get ("at_wifi_mac", at_wifi_mac, sizeof (at_wifi_mac));
			} while (strncmp (at_wifi_mac, "0", 2) == 0);
		}

		wf_log ("wifi_ssid_init:at_wifi_mac = %s", at_wifi_mac);
		wlan_setWifiNV (&at_wifi_mac);
	}
}
