#ifndef SD_HTTPSHARE_H
#define SD_HTTPSHARE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <string.h>
#include <dirent.h>
#include <sys/statvfs.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <utime.h>
#include <linux/stat.h>
#include "message.h"
#include "netapi.h"
#include "softap_api.h"
#include "sdcard_cfg.h"


#define MAX_CMD_LEN   256

#define NV_ITEM_VALUE_MAX_LEN               1024

#define ZTE_HTTPSHARE_FILE_NAME_MAX_LEN     1024
#define ZTE_HTTPSHARE_DEFAULT_LEN           100
#define ZTE_HTTPSHARE_MAX_NUM_SHOW_RECORD   10
//#define ZTE_IP_ADDRESS_LENGTH               32

#define ZTE_HTTPSHARE_LEN_50           50
#define ZTE_HTTPSHARE_LEN_64           64
#define ZTE_HTTPSHARE_LEN_100          100
#define ZTE_HTTPSHARE_LEN_12           12
#define ZTE_HTTPSHARE_MAC_ADDR_MAX_LEN 18

//#define ZTE_HTTPSHARE_TIMEOUT  600
#define ZTE_PARSE_CGI_TAIL_LEN 100
#define MAX_LEN_FOR_SQL 1024

#define HTTPSHARE_BUF_NORMAL_LEN_MAX 255
#define  DECCHK( c ) ((c) >= '0' && (c) <= '9')

/*httpshareSQL*/
#define ZTE_CREATE_TABLE_HTTPSHARE_SQL   "CREATE TABLE IF NOT EXISTS httpshare(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,ip TEXT,path TEXT)"

#define SET_MODE_USB                     "usb"
#define SET_MODE_HTTP_SHARE              "httpshare"

#define USB_MODE                         "usb_mode"
#define HTTP_SHARE_MODE                  "http_share_mode"

#define NO_SDCARD                        "no_sdcad"
#define ZTE_HTTPSHARE_TIME               "path_SD_CARD_time_unix"

#define ZTE_HTTPSHARE_DB_NAME            "httpshare"


typedef enum {
	ZTE_HTTPSHARE_DB_OK = 0,
	ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR = 100,
	ZTE_HTTPSHARE_DB_ERROR_NOT_OPEN_DB,
	ZTE_HTTPSHARE_DB_ERROR_FULL,
	ZTE_HTTPSHARE_DB_ERROR = -1
} zte_httpshare_db_result_e_type;


typedef enum {
	ZTE_HTTPSHARE_FAILURE = -1,
	ZTE_HTTPSHARE_SUCCESS = 0,
	ZTE_HTTPSHARE_NOT_SUPPORT = 1,
	ZTE_HTTPSHARE_MAX
} zte_httpshare_return_e_type;


typedef enum {
	ZTE_ERROR_MODE = -1,
	ZTE_HTTPSHARE_USB = 0,
	ZTE_HTTPSHARE_HTTPSHARE = 1,
	ZTE_RESERVE_MODE
} zte_httpshare_current_mode_type;


typedef enum {
	ZTE_NVIO_FAIL = 0,
	ZTE_NVIO_DONE = 1,
	ZTE_NVIO_BUSY = 2,
	ZTE_NVIO_BADCMD = 3,
	ZTE_NVIO_MAX
} zte_topsw_state_e_type;


typedef enum {
	ZTE_CHANGE_MODE_ERROR = 0,
	ZTE_CHANGE_MODE_OK
} zte_httpshare_change_mode_type;

int zte_httpshare_change_current_mode(zte_httpshare_current_mode_type curr_mode);

int zte_init_sdcard_path();
void zte_httpshare_init();
int zte_umount_dev();
int zte_init_sdcard_mode();


#endif

