/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_batterry_adapter.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIȡ͵Ϣ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
******************************************************************************/


/************************************************************************************
                           ͷļ
***********************************************************************************/
#include <linux/netlink.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "mmi_common.h"
#include "mmi_lcd.h"
/*
extern SINT32 g_mmi_hightempvol;
extern SINT32 g_mmi_superhightempvol;
extern SINT32 g_mmi_lowtempvol;
extern SINT32 g_mmi_superlowtempvol;
*/
extern SINT32 g_mmi_batvoltageline[MMI_BAT_VOLTAGE_LEN];

//ѹ-ñmmiĵѹĵѹбȶԣӶҵΧ
static int bat_volage[] = {
	3090, 3300, 3450, 3490, 3510, 3540, 3550, 3570, 3580, 3600, 3620,
	3650, 3670, 3710, 3740, 3780, 3850, 3900, 3950, 4000, 4060,

};


static T_zMmiChgStateStringItem g_chgStateStringTab[] = {
	{CHARGE_STATUS_FULL,     	STATE_FULL},
	{CHARGE_STATUS_CHARGING, 	STATE_CHARGING},
	{CHARGE_STATUS_DISCHARGING,	STATE_DISCHARGE},
	{CHARGE_STATUS_NOTCHARGING,	STATE_CHARGERROR}
};


/**********************************************************************************
*˵ ȡѹֵ
***********************************************************************************/
SINT32 mmi_voltage_state_read(VOID)
{
	char buf_volt[CHARGE_VOLTAGE_LENGTH+1] = {0};
	FILE* fd_voltage = NULL;
	int len = 0;
	int voltagepower = 0;

	fd_voltage = fopen(CHARGE_VOLTAGE_PATH, "r");
	if (fd_voltage == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI open voltage file fail!\n");
		//MMI_ASSERT(0);
		return -1;
	}
	len = fread(buf_volt, 1, CHARGE_VOLTAGE_LENGTH, fd_voltage);
	if (len > 0) { //kw 3
		voltagepower = atoi(buf_volt);
		fclose(fd_voltage);
		slog(MMI_PRINT, SLOG_NORMAL, "MMI voltagepower=%d\n",voltagepower);
		return voltagepower;
	} else {
		perror("read voltage file failed");
		slog(MMI_PRINT, SLOG_ERR, "MMI read voltage file fail len = %d !\n", len);
		fclose(fd_voltage);
		return -1;
	}
}


/*****************************************************************************************
*˵ ݵذٷֱõ״̬ 10%/25%/normal
*******************************************************************************************/
E_zMmi_Voltage_level mmi_set_battery_state(UINT32 bat_level)
{
	E_zMmi_Voltage_level volt_lev = VOLT_MAX;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_set_battery_state bat_level = %d\n", bat_level);
	if (bat_level <= 5) {
		volt_lev = VOLT_5PERCENTLEVEL;
	} else if (bat_level <= 10) { //kw 3
		volt_lev = VOLT_10PERCENTLEVEL;
	} else if (bat_level <= 20) {
		volt_lev = VOLT_20PERCENTLEVEL;
	} else if (bat_level <= 25) {
		volt_lev = VOLT_25PERCENTLEVEL;
	} else {
		volt_lev = VOLT_NORMALLEVEL;
	}
	return volt_lev;
}
/*****************************************************************************************
*˵ WEBUIظ
*******************************************************************************************/
VOID mmi_set_webUI_batterypers(UINT32 bat_level)
{
	if (bat_level <= 5) {
		sc_cfg_set(WEBUIBATTERYLEVEL, WEBUINOLEVEL);
	} else if (bat_level <= 25) { //kw 3
		sc_cfg_set(WEBUIBATTERYLEVEL, WEBUIONELEVEL);
	} else if (bat_level <= 50) {
		sc_cfg_set(WEBUIBATTERYLEVEL, WEBUITWOLEVEL);
	} else if (bat_level < 100) {
		sc_cfg_set(WEBUIBATTERYLEVEL, WEBUITHRLEVEL);
	} else {
		sc_cfg_set(WEBUIBATTERYLEVEL, WEBUIFOURLEVEL);
	}
}

/*****************************************************************************************
*˵ WEBUI״̬
*******************************************************************************************/
VOID mmi_set_webUI_batterycharge(char* chg_sta, BOOL isFull)
{
	sc_cfg_set(WEBUICHARGESTATTUS, chg_sta);
	if (isFull) {
		sc_cfg_set(BATTERYPERS_NV, WEBUIFULLLEVEL);
		sc_cfg_set(WEBUIBATTERYLEVEL, WEBUIFOURLEVEL);
	}
}
/*****************************************************************************************
*˵ ݵѹȡصٷֱ
*******************************************************************************************/
SINT32 get_voltage_level_from_table(SINT32 voltagepower)
{
	UINT32 bat_lev = 0;
	SINT32 i;

	if (voltagepower < g_mmi_batvoltageline[0]) {
		bat_lev = 0;
	} else if (voltagepower >= g_mmi_batvoltageline[MMI_BAT_VOLTAGE_LEN - 1]) {
		bat_lev = 100;
	} else {
		for (i = 0; i < MMI_BAT_VOLTAGE_LEN - 1; i++) {
			if (voltagepower >= g_mmi_batvoltageline[i] && voltagepower < g_mmi_batvoltageline[i + 1]) {
				bat_lev = i * 5;
				break;
			}
		}
	}
	return bat_lev;
}

/**********************************************************************************
*˵ȡ״̬
 ***********************************************************************************/
E_zMmi_Charge_State mmi_get_charge_status(VOID)
{
	char chg_state_buf[CHARGE_STATUS_LENGTH] = {0};
	int len = 0;
	UINT32 i = 0;
	FILE* fd_charger = NULL;

	fd_charger = fopen(CHARGE_STATUS_PATH, "r");
	if (fd_charger == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_charge_status open charging file fail!\n");
		//MMI_ASSERT(0);
		return STATE_CHARGE_MAX;
	}
	len = fread(chg_state_buf, 1, CHARGE_STATUS_LENGTH, fd_charger);
	if (len > 0) { //kw 3
		fclose(fd_charger);
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_charge_status chg_state_buf=%s !\n", chg_state_buf);
		for (i = 0; i < sizeof(g_chgStateStringTab) / sizeof(T_zMmiChgStateStringItem); ++ i) {
			if (strncmp(chg_state_buf, g_chgStateStringTab[i].devString, strlen(g_chgStateStringTab[i].devString)) == 0) {
				return g_chgStateStringTab[i].chg_sta;
			}
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_charge_status read voltage file fail len = %d !\n", len);
		fclose(fd_charger);
		return STATE_CHARGE_MAX;
	}
	return STATE_CHARGE_MAX;
}
/**********************************************************************************
*˵ȡUSB״̬
 ***********************************************************************************/
BOOL mmi_read_usb_insert_status(VOID)
{
	char usb_state_buf[2] = {0};
	int len = 0;
	FILE* fd_charger = NULL;

	fd_charger = fopen(USB_INSERT_STATUS_PATH, "r");
	if (fd_charger == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_read_usb_insert_status open usb file fail!\n");
		//MMI_ASSERT(0);
		return FALSE;
	}
	len = fread(usb_state_buf, 1, 2, fd_charger);
	if (len > 0) { //kw 3
		fclose(fd_charger);
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_read_usb_insert_status usb_state_buf=%s !\n", usb_state_buf);
		if (!strncmp(usb_state_buf, USB_STATUS_IN, strlen(USB_STATUS_IN))) {
			return TRUE;
		}
		if (!strncmp(usb_state_buf, USB_STATUS_OUT, strlen(USB_STATUS_OUT))) {
			return FALSE;
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_read_usb_insert_status read usb file fail len = %d !\n", len);
		fclose(fd_charger);
		return FALSE;
	}
	return FALSE;
}

