/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_PPP
*    : ppp_api.h
* ļ : 
* ʵֹ : pppģͷļ
*      : zhangpeirong
*      : V1.0
*  : 2012-08-06 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : zpr
* ޸ : 2012-06-20
* ޸ : EC:617001563315,PSBUFλø
**************************************************************************/
#ifndef _PPP_API_H
#define _PPP_API_H

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "psbuf.h"


#ifdef __cplusplus
extern "C"  
{
#endif

/**************************************************************************
* 
**************************************************************************/
/* zPpp_Ctrl commands */
#define ZPPP_CTRL_GET_PDP_TYPE              100  /* ȡPPP·֧PDP          */
#define ZPPP_CTRL_SET_PDP_TYPE              101  /* PPP·֧PDP          */
#define ZPPP_CTRL_GET_MRU                   102  /* ȡppp·ĽյԪ           */
#define ZPPP_CTRL_SET_MRU                   103  /* ppp·ĽյԪ           */     
#define ZPPP_CTRL_SET_PPPOE_INPUTPACKET_CB  104  /* PPPOEص                       */
#define ZPPP_CTRL_SET_ATI_IPADDRS_CB        105  /* õȴATIIP ַDNSص     */
#define ZPPP_CTRL_SET_ATI_NOTREADY          106  /* ATI NOTREADY                */
#define ZPPP_CTRL_GET_AUTH_TYPE             107  /* ȡPPP·е֤     */
#define ZPPP_CTRL_SET_AUTH_TYPE             108  /* PPP·е֤     */

/* Error codes */
#define ZPPP_OPEN_SUCC      1 /* MBBppp Эokopen̬֪ͨ                     */
#define ZPPP_ERR_NONE         0   /* No error.                              */
#define ZPPP_ERR_PARAM        -1  /* Invalid parameter.                     */
#define ZPPP_ERR_OPEN         -2  /* Unable to open PPP session.            */
#define ZPPP_ERR_DEVICE       -3  /* Invalid I/O device for PPP.            */
#define ZPPP_ERR_ALLOC        -4  /* Unable to allocate resources.          */
#define ZPPP_ERR_USER         -5  /* User interrupt. ʱͻ߳Ҳ˳ */
#define ZPPP_ERR_CONNECT      -6  /* Connection lost.                       */
#define ZPPP_ERR_AUTHFAIL     -7  /* Failed authentication challenge.       */
#define ZPPP_ERR_PROTOCOL     -8  /* Failed to meet protocol.               */
#define ZPPP_ERR_RECVATEND    -9  /* set errocode when receive ATH  or +++. */
#define ZPPP_ERR_EXITPPP      -10 /* exit from ppp mode                     */

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct 
{
    SSIZE_T addr;
}T_ZOss_IpAddr;

typedef struct 
{
    UINT32 addr[4];
}T_ZOss_IPv6Addr;

typedef  enum
{
    TCPIP_ADDR_IPV4 = 0,
    TCPIP_ADDR_IPV6
}T_ZOss_IPType;

typedef enum
{
    ZPPP_PPPOE_DOING,               /* Э̬     */
    ZPPP_PPPOE_SUCCESS,             /* Э   */
    ZPPP_PPPOE_FAIL,                /* Эʧ   */
    ZPPP_PPPOE_IPPACKET,            /* IPش   */
    ZPPP_PPPOE_UNKNOWPACKET_ERROR   /* ʶİ */
}T_zPpp_PppoeStatus;

typedef enum
{
    ZPPP_AUTH_NEED_NULL,    /* Ҫ֤   */
    ZPPP_AUTH_NEED_PAP,     /* ҪPAP֤  */
    ZPPP_AUTH_NEED_CHAP     /* ҪCHAP֤ */
}T_zPpp_AuthNeed;

typedef enum
{
    ZPPP_PDP_ALL_SUPPORT,   /* ֧IPV4V6   */
    ZPPP_PDP_IPV4_ONLY,     /* ֧IPV4   */
    ZPPP_PDP_IPV6_ONLY      /* ֧IPV6   */
}T_zPpp_PdpTypeSupport;

/* PPPؽṹ */
typedef struct
{
    UINT32              sioFd;                                              /* fd                        */
    SINT32              (*sioRead)(UINT32 fd, UINT8 *pBuf, UINT32 length);  /* ڶ                    */
    SINT32              (*sioWrite)(UINT32 fd, UINT8 *pBuf, UINT32 length); /* д                    */
    VOID                (*sioReadUnblock)(UINT32 fd);                       /* ʹڴ̬תɷ̬  */
    VOID                (*sioReadBlock)(UINT32 fd);
	VOID                (*sioPPPDisconnect)(UINT32 fd);
	VOID                (*sioPPPConnect)(UINT32 fd);
    T_z_UpLink_Sdu*     (*getUpLinkSdu)(VOID);
    VOID                (*freeUpLinkSdu)(T_z_UpLink_Sdu *pSdu);
    T_z_DownLink_Sdu*   (*getDownLinkSdu)(VOID);
    VOID                (*freeDownLinkSdu)(T_z_DownLink_Sdu *pSdu);
}T_zPpp_Sio;

/* PPP IPCPЭPCOؽṹ */
typedef struct
{
    UINT8           pdpType;    /* 0x01-PPP * 0x21-IPv4 * 0x57-IPv6 */
    T_ZOss_IpAddr   ourIpAddr;
    T_ZOss_IpAddr   hisIpAddr;
    T_ZOss_IpAddr   snmask;     /*                          */
    T_ZOss_IpAddr   dns1;
    T_ZOss_IpAddr   dns2;
    T_ZOss_IPv6Addr ipv6Addr;   /* ӿID64λ                       */
    T_ZOss_IPv6Addr v6dns1;     /* IPv6 DNS server addresses 1      */ 
    T_ZOss_IPv6Addr v6dns2;     /* IPv6 DNS server addresses 2      */
}T_zPpp_IpAddrs;

/* PPP·ؽṹ */
typedef struct
{
  VOID              (*PppLinkCtrl_CB)(UINT32 pppNum, VOID *linkStatusCtx, SINT32 error_code, VOID *arg);
  VOID              (*InputUpLinkData_CB)(UINT32 pppNum, T_z_UpLink_Sdu *ip_packet, SINT32 length, UINT8 channelId);
  VOID              (*InputUpLinkDataV6_CB)(UINT32 pppNum, T_z_UpLink_Sdu *ip_packet, SINT32 length, UINT8 channelId);
  T_zPpp_IpAddrs    *pIpAddrs;
  UINT8             channelId; 
}T_zPpp_LinkCtrl;

/* ֪ͨ߷IPصĺ */          
typedef BOOL (*T_zPpp_OutputPacket_CB)(UINT32 pppNum, VOID *pPacket, UINT32 packetSize, UINT8 flag);

/* ֪ͨATI2pdpỰ дIP DNSصĺ */
//typedef BOOL (*T_zPpp_GetIpAddrsFromAti2_CB)(UINT32 pppNum, VOID *addr, SINT32 length);                                        

//typedef BOOL (*T_zPpp_GetIpAddrsFromAti_CB)(UINT8 iChnelId, T_ZAti_SmIpDnsInfo *pAddr); 

/* ֪ͨPPPOELCPNCPЭӦصĺ */          
typedef SINT32 (*T_zPpp_InputPacketToPppoe_CB)(UINT32 pppNum, VOID *packet, SINT32 packetLen, T_zPpp_PppoeStatus status);                                     


/**************************************************************************
* 
**************************************************************************/ 
UINT32 zPpp_Init(VOID);
UINT32 zPpp_Open(T_zPpp_Sio *pPppSio, T_zPpp_LinkCtrl *pPppCtrl, BOOL isPppoe);
SINT32 zPpp_PcoAuth_AtRecv(UINT32 dev_fd, const UINT8 *data, UINT16 dataLen, UINT32 extData);
UINT32 zPpp_Close(UINT32 pppNum);
UINT32 zPpp_Start(UINT32 pppNum);
UINT32 zPpp_WriteIp(UINT32 pppNum, const UINT8 *pIpPacket, SINT32 length);
UINT32 zPpp_InputDataFromPppoe(UINT32 pppNum, T_z_UpLink_Sdu *pDestSduBuffer);
UINT32 zPpp_Ctrl(UINT32 pppNum, SINT32 cmd, VOID *pArg);
UINT32 zPpp_RegOutputPppPacketCb(T_zPpp_OutputPacket_CB recvFunc);

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
} 
#endif

#endif  /* _PPP_API_H */

