/*****************************************************************************
*汾 (C)2007ͨѶɷ޹˾
*  ģ  
*  ļ  pstraceint.h
*  ļʶ
*  ļ
*  ʵֹܣЭջϱϢĻꡢݽṹ
*      
*  汾    
*  ڣ
*  ˵
*****************************************************************************/

#ifndef ZPS_PS_TRACE_H
#define ZPS_PS_TRACE_H

#include "StdLogMsgID.h"

#define Z_URLC_MAX_TRACE_NUM             (BYTE)25        /*pdu*/
#define Z_URLC_MAX_NACKTRACE_NUM         (BYTE)20        /*ÿٵNACK,ż*/
#define Z_URLC_MAX_DATATRACE_NUM         (BYTE)6         /*ÿٵֽ*/

#define Z_EUMCR_TRACE_LTE_RLT_FREQ_NUM                 (BYTE)8
#define Z_EUMCR_TRACE_LTE_CELL_NUM                     (BYTE)32
#define Z_EUMCR_TRACE_TD_RLT_FREQ_NUM                  (BYTE)16
#define Z_EUMCR_TRACE_TD_CELL_NUM                      (BYTE)32
#define Z_EUMCR_TRACE_GSM_CELL_NUM                     (BYTE)32
#define Z_EUMCR_TRACE_MEASID_NUM                       (BYTE)32
#define Z_EUMCR_TRACE_EVAL_CELL_NUM                    (BYTE)32  

#define Z_TRACE_MaxNTCellNum             (BYTE)6    /*ϱTD(ͬƵƵ)ڿʽ*/
#define Z_TRACE_MaxNGCellNum             (BYTE)6    /*ϱGSMڿʽ*/
#define Z_TRACE_MaxNLCellNum             (BYTE)32   /*ϱLTEڿʽ*/


/*========================== ʽ궨 ==========================*/
#define Z_TRACE_GSM                      (BYTE)0
#define Z_TRACE_TD                       (BYTE)1
#define Z_TRACE_LTE                      (BYTE)2
#define Z_TRACE_W                        (BYTE)3

/*======================== ΪLTEʽʱͳӺȡֵ ========================*/
#define Z_DELAY_CNTTYPE_CR                             (BYTE)0      /*ʱͳ, Сѡ*/
#define Z_DELAY_CNTTYPE_HO                             (BYTE)1      /*ʱͳ, л*/
#define Z_DELAY_CNTTYPE_RD                             (BYTE)2      /*ʱͳ, ض*/
#define Z_DELAY_CNTTYPE_CS                             (BYTE)3      /*ʱͳ, Сѡ*/
#define Z_DELAY_CNTTYPE_SC                             (BYTE)4      /*ʱͳ, С*/
#define Z_DELAY_CNTTYPE_ACC                            (BYTE)5      /*ʱͳ, ʱ*/
#define Z_DELAY_CNTTYPE_M2C                            (BYTE)6      /*ʱͳ, MIBcamp on*/
#define Z_DELAY_CNTTYPE_M2A                            (BYTE)7      /*ʱͳ, MSG1attach complete*/
#define Z_DELAY_CNTTYPE_CP                             (BYTE)8      /*ʱͳ, ʱ*/
#define Z_DELAY_CNTTYPE_PAG                            (BYTE)9      /*ʱͳ, UEѰʱ*/
#define Z_DELAY_CNTTYPE_MAXVALUE                       (BYTE)Z_DELAY_CNTTYPE_PAG

#define Z_DELAY_DIRECT_L2T                             (BYTE)0      /*ʱͳƷ, LTE->TDS*/
#define Z_DELAY_DIRECT_L2G                             (BYTE)1      /*ʱͳƷ, LTE->GSM*/
#define Z_DELAY_DIRECT_T2L                             (BYTE)2      /*ʱͳƷ, TDS->LTE*/
#define Z_DELAY_DIRECT_G2L                             (BYTE)3      /*ʱͳƷ, GSM->LTE*/
#define Z_DELAY_DIRECT_L                               (BYTE)4      /*ʱͳƷ, LTEʽ*/
#define Z_DELAY_DIRECT_T                               (BYTE)5      /*ʱͳƷ, TDʽ*/
#define Z_DELAY_DIRECT_MAXVALUE                        (BYTE)Z_DELAY_DIRECT_T
#define Z_DELAY_DIRECT_INVALID                         (BYTE)0xFF   /*ʱͳƷ, ȡʧʱصЧ*/

/*======================== Ϊģϱ¼źȡֵ ========================*/
#define Z_GSM_LOSENET                 (WORD)1      /* GSMʽ£ʼ¼*/     
#define Z_GSM_CRSTART                 (WORD)2      /* GSMʽ£ѡʼ¼*/ 
#define Z_GSM_CRFAIL                  (WORD)3      /* GSMʽ£ѡʧ¼*/ 
#define Z_GSM_CAMPONSTART             (WORD)4      /* GSMʽ£פʼ¼*/ 
#define Z_GSM_CAMPONSUCC              (WORD)5      /* GSMʽ£פɹ¼*/ 
#define Z_GSM_HOFAIL                  (WORD)6      /* GSMʽ£лʧ¼*/ 
#define Z_GSM_IRATMEASTART            (WORD)7      /* GSMʽ£ʽ¼*/ 
#define Z_GSM_IRATMEASTOP             (WORD)8      /* GSMʽ£ͣʽ¼*/
#define Z_GSM_HOSTART                 (WORD)9      /* GSMʽ£лʼ¼*/
#define Z_GSM_HOSUCC                  (WORD)10     /* GSMʽ£лɹ¼*/
#define Z_GSM_REDERICTSTART           (WORD)11     /* GSMʽ£ضʼ¼*/
#define Z_GSM_REDERICTFAIL            (WORD)12     /* GSMʽ£ضʧ¼*/
#define Z_GSM_CCOSTART                (WORD)13    /* GSMʽ£CCOʼ¼*/
#define Z_GSM_CCOFAIL                 (WORD)14   /* GSMʽ£CCOʧ¼*/
#define Z_GSM_CCOSUCC                 (WORD)15    /* GSMʽ£CCOɹ¼*/

#define Z_TD_LOSENET                  (WORD)100    /* TDʽ£ʼ¼*/          
#define Z_TD_CRSTART                  (WORD)101    /* TDʽ£ѡʼ¼*/  
#define Z_TD_CRFAIL                   (WORD)102    /* TDʽ£ѡʧ¼*/  
#define Z_TD_CAMPONSTART              (WORD)103    /* TDʽ£פʼ¼*/ 
#define Z_TD_CAMPONSUCC               (WORD)104    /* TDʽ£פɹ¼*/ 
#define Z_TD_HOFAIL                   (WORD)105    /* TDʽ£лʧ¼*/ 
#define Z_TD_IRATMEASTART             (WORD)106    /* TDʽ£ʽ¼*/ 
#define Z_TD_RESTFAIL                 (WORD)107    /* TDʽ£ؽʧ¼*/ 
#define Z_TD_IRATMEASTOP              (WORD)108    /* TDʽ£ͣʽ¼*/ 
#define Z_TD_HOSTART                  (WORD)109    /* TDʽ£лʼ¼*/
#define Z_TD_HOSUCC                   (WORD)110    /* TDʽ£лɹ¼*/
#define Z_TD_RESTSTART                (WORD)111    /* TDʽ£ؽʼ¼*/
#define Z_TD_RESTSUCC                 (WORD)112    /* TDʽ£ؽɹ¼*/
#define Z_TD_REDERICTSTART            (WORD)113    /* TDʽ£ضʼ¼*/
#define Z_TD_REDERICTFAIL             (WORD)114    /* TDʽ£ضʧ¼*/
#define Z_TD_CCOSTART                  (WORD)115    /* TDʽ£CCOʼ¼*/
#define Z_TD_CCOFAIL                   (WORD)116   /* TDʽ£CCOʧ¼*/
#define Z_TD_CCOSUCC                   (WORD)117    /* TDʽ£CCOɹ¼*/


#define Z_W_CRSTART                   (WORD)301    /* Wʽ£ѡʼ¼*/  
#define Z_W_CRFAIL                    (WORD)302    /* Wʽ£ѡʧ¼*/
#define Z_W_CRSUCC                    (WORD)303    /* Wʽ£ѡɹ¼*/
#define Z_W_HOSTART                   (WORD)304    /* Wʽ£лʼ¼*/
#define Z_W_HOSUCC                    (WORD)305    /* Wʽ£лɹ¼*/
#define Z_W_HOFAIL                    (WORD)306    /* Wʽ£лʧ¼*/ 
#define Z_W_REDERICTSUCC              (WORD)307    /* Wʽ£ضɹ¼*/
#define Z_W_REDERICTSTART             (WORD)308    /* Wʽ£ضʼ¼*/
#define Z_W_REDERICTFAIL              (WORD)309    /* Wʽ£ضʧ¼*/
#define Z_W_CCOSTART                  (WORD)310    /* Wʽ£CCOʼ¼*/
#define Z_W_CCOFAIL                   (WORD)311   /* Wʽ£CCOʧ¼*/
#define Z_W_CCOSUCC                   (WORD)312    /* Wʽ£CCOɹ¼*/


#define Z_LTE_LOSENET                 (WORD)600    /* LTEʽ£ʼ¼*/            
#define Z_LTE_CRSTART                 (WORD)601    /* LTEʽ£ѡʼ¼*/  
#define Z_LTE_CRFAIL                  (WORD)602    /* LTEʽ£ѡʧ¼*/  
#define Z_LTE_CAMPONSTART             (WORD)603    /* LTEʽ£פʼ¼*/ 
#define Z_LTE_CAMPONSUCC              (WORD)604    /* LTEʽ£פɹ¼*/ 
#define Z_LTE_HOFAIL                  (WORD)605    /* LTEʽ£лʧ¼*/ 
#define Z_LTE_IRATMEASTART            (WORD)606    /* LTEʽ£ʽ¼*/ 
#define Z_LTE_RESTFAIL                (WORD)607    /* LTEʽ£ؽʧ¼*/ 
#define Z_LTE_IRATMEASTOP             (WORD)608    /* LTEʽ£ͣʽ¼*/
#define Z_LTE_HOSTART                 (WORD)609    /* LTEʽ£лʼ¼*/
#define Z_LTE_HOSUCC                  (WORD)610    /* LTEʽ£лɹ¼*/
#define Z_LTE_RESTSTART               (WORD)611    /* LTEʽ£ؽʼ¼*/
#define Z_LTE_RESTSUCC                (WORD)612    /* LTEʽ£ؽɹ¼*/
#define Z_LTE_REDERICTSTART           (WORD)613    /* LTEʽ£ضʼ¼*/
#define Z_LTE_REDERICTFAIL            (WORD)614    /* LTEʽ£ضʧ¼*/
#define Z_LTE_CCOSTART                (WORD)615    /* LTEʽ£CCOʼ¼*/
#define Z_LTE_CCOFAIL                 (WORD)616    /* LTEʽ£CCOʧ¼*/
#define Z_LTE_CCOSUCC                 (WORD)617    /* LTEʽ£CCOɹ¼*/

/*==========Эջϱ·¼Ϣֵֵ =================*/
#define Z_CR_STRART_IDX               (BYTE)1
#define Z_CAMPON_SUCC_IDX             (BYTE)2
#define Z_IRATMEA_START_IDX           (BYTE)3
#define Z_IRATMEA_STOP_IDX            (BYTE)Z_IRATMEA_START_IDX
#define Z_HO_START_IDX                (BYTE)Z_CR_STRART_IDX
#define Z_RD_START_IDX                (BYTE)4
#define Z_CCO_START_IDX               (BYTE)Z_CR_STRART_IDX
/*============= UEЭջϱϢͺ궨 =======================*/
#define Z_TRACE_LTEUEINFO_REQ          (BYTE)0
#define Z_TRACE_CELLRESORCCO_REQ       (BYTE)1
#define Z_TRACE_CELLRESORCCO_STOP      (BYTE)2
#define Z_TRACE_CELLINFO_REQ           (BYTE)3
#define Z_TRACE_CELLINFO_STOP          (BYTE)4

/*============================= ERRC Э鶨ʱ=================================*/
typedef enum
{
    Z_EURRC_TMRI_T300,
    Z_EURRC_TMRI_T301,
    Z_EURRC_TMRI_T302,
    Z_EURRC_TMRI_T303,
    Z_EURRC_TMRI_T304,
    Z_EURRC_TMRI_T305,
    Z_EURRC_TMRI_T310,
    Z_EURRC_TMRI_T311,
    Z_EURRC_TMRI_T320,
    Z_EURRC_TMRI_T321,
    Z_EURRC_TMRI_CONN_REL,
    Z_EURRC_TMRI_OOS,
    Z_EURRC_TMRI_3HOUR,
    Z_EURRC_TMRI_ETWS,
    Z_EURRC_TMRI_CMAS,
    Z_EURRC_TMRI_PAGING_SIMODI_WAIT
} T_zEurrc_TimerType;

/* bNasRegState ȡֵ*/
#define REG_STATE_INACTIVE         (BYTE)0 /* REG_STATE_INACTIVE*/
#define REG_STATE_IDLE             (BYTE)1 /* REG_STATE_IDLE*/
#define REG_STATE_REGISTERING      (BYTE)2 /* REG_STATE_REGISTERING*/
#define REG_STATE_DEREGISTERING    (BYTE)3 /* REG_STATE_DEREGISTERING*/
#define REG_STATE_MANUAL_SEARCH    (BYTE)4 /* REG_STATE_MANUAL_SEARCH*/
#define REG_STATE_AUTOMATIC_SEARCH (BYTE)5 /* REG_STATE_AUTOMATIC_SEARCH*/
#define REG_STATE_OFFLINE          (BYTE)6 /* REG_STATE_OFFLINE*/

/* bPlmnSelMode ȡֵ*/
#define PlmnSelMode_Auto               (BYTE)0 /* Automatic*/
#define PlmnSelMode_Manual             (BYTE)1 /* Manual*/

/* bUeOperMode ȡֵ*/
#define UeOperMode_A         (BYTE)0 /* Class A*/
#define UeOperMode_B         (BYTE)1 /* Class B*/
#define UeOperMode_C         (BYTE)2 /* Class C*/

/*bCcStateȡֵ*/
#define CC_STATE_U0       (BYTE)0 /* U0*/
#define CC_STATE_U1       (BYTE)1 /* U1*/
#define CC_STATE_U0_1     (BYTE)2 /* U0_1*/
#define CC_STATE_U0_2     (BYTE)34 /* U0_2*/
#define CC_STATE_U0_3     (BYTE)35 /* U0_3*/
#define CC_STATE_U0_4     (BYTE)36 /* U0_4*/
#define CC_STATE_U0_5     (BYTE)37 /* U0_5*/
#define CC_STATE_U0_6     (BYTE)38 /* U0_6*/
#define CC_STATE_U3       (BYTE)3 /* U3*/
#define CC_STATE_U4       (BYTE)4 /* U4*/
#define CC_STATE_U6       (BYTE)6 /* U6*/
#define CC_STATE_U7       (BYTE)7 /* U7*/
#define CC_STATE_U8       (BYTE)8 /* U8*/
#define CC_STATE_U9       (BYTE)9 /* U9*/
#define CC_STATE_U10      (BYTE)10 /* U10*/
#define CC_STATE_U11      (BYTE)11 /* U11*/
#define CC_STATE_U12      (BYTE)12 /* U12*/
#define CC_STATE_U19      (BYTE)19 /* U19*/
#define CC_STATE_U26      (BYTE)26 /* U26*/
#define CC_STATE_U27      (BYTE)27 /* U27*/
#define CC_STATE_U10_DTMF  (BYTE)138 /* U10_DTMF*/


/*bHoldStare ȡֵ*/
#define CC_HOLD_IDLE                 (BYTE)0 /*HOLD_IDLE*/
#define CC_HOLD_REQUEST              (BYTE)1 /*HOLD_REQUEST*/
#define CC_HOLD_CALL_HELD            (BYTE)2 /*HOLD_CALL_HELD*/
#define CC_HOLD_RETRIEVE_REQUEST     (BYTE)3 /*HOLD_RETRIEVE_REQUEST*/

/*bCallType ȡֵ*/
#define CC_VOICE_CALL                 (BYTE)0 /*Voice call*/
#define CC_DATA_CALL                  (BYTE)1 /*Data call*/

/*bCallOrigDir ȡֵ*/
#define CC_MT                  (BYTE)0 /*Mobile-terminated*/
#define CC_MO                  (BYTE)1 /*Mobile-originated*/

/*bNSAPI ȡֵ*/
#define NSAPI_5           (BYTE)5  /* NSAPI 5*/
#define NSAPI_6           (BYTE)6  /* NSAPI 6*/
#define NSAPI_7           (BYTE)7  /* NSAPI 7*/
#define NSAPI_8           (BYTE)8  /* NSAPI 8*/
#define NSAPI_9           (BYTE)9  /* NSAPI 9*/
#define NSAPI_10          (BYTE)10 /* NSAPI 10*/
#define NSAPI_11          (BYTE)11 /* NSAPI 11*/
#define NSAPI_12          (BYTE)12 /*NSAPI 12*/
#define NSAPI_13          (BYTE)10 /*NSAPI 13*/
#define NSAPI_14          (BYTE)11 /*NSAPI 14*/
#define NSAPI_15          (BYTE)12 /*NSAPI 15*/

#define Z_TRACE_MAX_PLMN_NUM    (BYTE)15

/* mcr */
#define WRRC_MAX_RES_WCELL                             (BYTE)32
#define WRRC_MAX_RES_GSMCELL                           (BYTE)32
#define WRRC_MAX_RES_LTECELL                           (BYTE)16
#define WRRC_MAX_EVENT_NUM                             (BYTE)16   
#define WRRC_MAX_INTERFREQ_NUM                         (BYTE)2
#define WRRC_MAX_AS_NUM                                (BYTE)8
#define WRRC_MAX_DS_NUM                                (BYTE)8
#define WRRC_MAX_MS_NUM                                (BYTE)32
#define WRRC_MAX_INTRACELL_NUM                         (BYTE)32
#define WRRC_MAX_INTERCELL_NUM                         (BYTE)32
#define WRRC_MAX_GSMCELL_NUM                           (BYTE)32
#define WRRC_MAX_LTECELL_NUM                           (BYTE)16  
#define WRRC_MAX_LTEFREQ_NUM                           (BYTE)8   
#define WRRC_MAX_CM_NUM                                (BYTE)6
#define WRRC_MAX_INTRAMEASEVENT                        (BYTE)9
#define WRRC_MAX_INTERMEASEVENT                        (BYTE)7
#define WRRC_MAX_RATMEASEVENT                          (BYTE)8
#define WRRC_MAX_PRIOUTRAFREQ_NUM                      (BYTE)8


/* rlc */
#define Z_WRLC_MAX_AMNUM                               (BYTE)4
#define Z_WRLC_MAX_LOGNUM                              (BYTE)20
#define Z_WRLC_MAX_TM_NUM                              (BYTE)8
#define Z_WRLC_MAX_UM_NUM                              (BYTE)3
#define Z_WRLC_MAX_AM_CFGUM                            (BYTE)4
#define Z_WRLC_MAX_DLPDU_NUM                           (BYTE)70
#define Z_WRLC_MAX_DLAM_NUM                            (BYTE)4
#define Z_WRLC_RB_NUM                                  (BYTE)32
#define Z_WRLC_MAX_RLCLOGGED_NUM                       (BYTE)4
#define Z_WRLC_MAX_PDCP_RB_NUM                         (BYTE)5

/* mac */
#define WMAC_UPA_PDU_SAMPLE_MAX_NUM_LOG                (BYTE)50                                              /*UPA PDU*/
#define WMAC_UPA_MAC_D_FLOW_DDI_MAX_NUM_LOG            (BYTE)32                                              
#define WMAC_UPA_MAC_E_HEADER_DDI_MAX_NUM_LOG          (BYTE)62                                              
#define WMAC_DPA_RST_MAX_LGCH_NUM_LOG                  (BYTE)32    

typedef BYTE T_zUrrc_ASN1NULL_Trace;

#define Z_MAX_RB_NUM_TRACE                             (BYTE)11
#define Z_W_P_MAX_UL_TRCH_NUM_TRACE                    (BYTE)8 
#define Z_MAX_LGCH_ID_TRACE                            (BYTE)15   
#define Z_W_P_MAX_DL_TRCH_NUM_TRACE                    (BYTE)8 
#define Z_WMAC_MAX_NUM_OF_ASC_TRACE                    (BYTE)8 
#define Z_W_P_MAX_UL_TFC_NUM_TRACE                     (BYTE)64
#define Z_WMAC_MAX_EMAC_D_FLOW_NUM_TRACE               (BYTE)8 
#define Z_WMAC_MAX_SID_NUM_TRACE                       (BYTE)8 
#define Z_WMAC_MAX_DL_QUEUE_NUM_TRACE                  (BYTE)8 

#define Z_TIMER_START  (BYTE)0
#define Z_TIMER_STOP   (BYTE)1
#define Z_TIMER_EXPIRE (BYTE)2


#define Z_CAMPFAIL_CAU_BCHFAIL            (BYTE)0                           /* SIRܾפԭΪBCHʧ */
#define Z_CAMPFAIL_CAU_RSCP               (BYTE)1                           /* SIRܾפԭΪS׼ */
#define Z_CAMPFAIL_CAU_BAR                (BYTE)2                           /* SIRܾפԭΪСBar */
#define Z_CAMPFAIL_CAU_PLMN               (BYTE)3                           /* SIRܾפԭΪPLMN */
#define Z_CAMPFAIL_CAU_LAC                (BYTE)4  

/*+ZEMSCI*/
#define Z_EM_MAX_GSM_NCELL_NUM      32
#define Z_EM_MAX_TD_NCELL_NUM       32
#define Z_EM_MAX_W_NCELL_NUM        32
#define Z_EM_MAX_LTE_NCELL_NUM      32
#define   Z_EM_MAX_TD_EVENT_NUM       16
#define   Z_EM_MAX_W_ASCELL_NUM      8
#define   Z_EM_MAX_W_INTERFREQ_NUM   2
#define   Z_EM_MAX_W_EVENT_NUM       16
#define   Z_EM_MAX_QOS_NUM           8

/*LTE A SCELLϱ*/
#define   Z_EM_LTE_SCELL_NUM         6


/*PlmnId*/
typedef struct {
    BITS                            bMCC1     :4;
    BITS                            bMCC2     :4;
    
    BITS                            bMCC3     :4;
    BITS                            bMNC3     :4;         /*ֻ2MNCʱֶд1111*/
    
    BITS                            bMNC1     :4;
    BITS                            bMNC2     :4;
}T_z_PlmnId_Trace;

typedef struct {
    BYTE         bNum;           /*BCD*/
    BYTE         abPadding[3];
    BYTE         abId[8]; 
}T_z_IMSI_Trace;

/*TDСϢ*/
typedef struct{
    BYTE    bCellParaId; 
    BYTE    bPadding;   
    WORD    wUarfcn;   
}T_z_TdCell_Trace;

/*WCDMAСϢ*/
typedef struct{
    WORD    wPrimSc;     
    WORD    wUarfcn;    
}T_z_WCell_Trace;

/*GSMСϢ*/
typedef struct{
    BYTE    bBand; 
    BYTE    bBsic;  
    WORD    wArfcn; 
}T_z_GsmCell_Trace;

/*LTEСϢ*/
typedef struct{
    DWORD   dwEarfcn;     
    WORD    wPhyCellId;    
}T_z_LteCell_Trace;

/*СϢ*/
typedef struct{
    BYTE                            bAct;                  
    BYTE                            abPadding[3];    
    union{
        T_z_TdCell_Trace            tTd;
        T_z_WCell_Trace             tW;
        T_z_GsmCell_Trace           tGsm;
        T_z_LteCell_Trace           tLte;
    }uCell;
}T_z_CellInfo_Trace;

/*GSM,TD Ϣ*/
typedef struct {
    T_z_GsmCell_Trace          tNGCell; /*TD, GSMϢ*/
    BYTE                       bNGCellRssi;/*TD, GSMRSSIֵ*/
    BYTE                       bNGCellMinRxlev;/*TD,GSMСյƽֵ ȡֵ0..63ӦϵͳϢֵΪ0xff*/
    BYTE                       bSupGprs;      /* GSMСǷ֧GPRSĬϲ֧*/
    BYTE                       bPadding1;
    SHORT                      C1;           /* GSM·, ЧֵΪ-1*/
    SHORT                      C2;           /* GSMЧֵΪ-1*/
    SHORT                      C31;          /* GSMЧֵΪ-1*/
    SHORT                      C32;          /* GSMЧֵΪ-1*/
}T_z_NGcell_info_Trace;

/* ========================================================================
                       ׼LOGӿڶ BIGEN
======================================================================== */

/*========================================================================
LOGͣTG_NAS_MSG_IND_EV 
˵ϱTG NAS׼
=========================================================================*/
typedef struct {
    DWORD  dwCodeLen;
    PBYTE  pCode; 
    BYTE   bUpDownFlag;
    BYTE   bPadding[3];
}T_zTGNasMsg_Ind;

/*========================================================================
LOGͣGSM_RRC_MSG_IND_EV 
˵ϱGSM RRC׼
=========================================================================*/
typedef struct {
    DWORD   dwCodeLen;
    PBYTE   pCode; 
    BYTE    bPduType;
    BYTE    bUpDownFlag;
    BYTE    abPadding[2];    
}T_zGsm_RRCMsg_Ind;

/*========================================================================
LOGͣTD_RRC_MSG_IND_EV /W_RRC_MSG_IND_EV
˵ϱTD /WRRC׼
=========================================================================*/
typedef struct {
    DWORD  dwCodeLen;
    PBYTE  pCode;
    BYTE   bPduType;
    BYTE   abPadding[3]; 
}T_zTd_RRCMsg_Ind,T_zW_RRCMsg_Ind;

/*========================================================================
LOGͣLTE_NAS_MSG_IND_EV
˵ϱLTE NAS׼
=========================================================================*/
typedef struct {
    DWORD  wCodeLen;
    PBYTE  pCode; 
    BYTE   bUpDownFlag;
    BYTE   bPadding[3];
}T_zEmm_NasMsg_Ind;

/*========================================================================
LOGͣLTE_RRC_MSG_IND_EV
˵ϱLTE RRC׼
=========================================================================*/
typedef struct {
    DWORD    dwCodeLen;
    PBYTE    pCode; 
    BYTE     bPduType;
    BYTE     abPadding[3];
}T_z_LteRRCMsg_Ind; 

/* ========================================================================
                      һLOGӿڶ BIGEN
======================================================================== */

/*========================================================================
LOGͣUMAC_UL_UPA_TB_INFO_TRACE_EV
˵ϱUPA TBϢ
=========================================================================*/
typedef struct {
    BYTE    bSiFlag;
    BYTE    bTebs;
    BYTE    bHlbs;
    BYTE    bHlid;
}T_SI_Info;

typedef struct {
    BYTE    bRlcPduSize;
    BYTE    bN;
    BYTE    bTsn;
    BYTE    bLgchId;
}T_Mac_E_Header_Info;

typedef struct {
    BYTE                                bVersion;
    BYTE                                abPadding[2];
    BYTE                                bMacesPduNum;
    T_SI_Info                           tSiInfo;
    T_Mac_E_Header_Info                 atMaceHeaderInfo[15];
}T_UPA_TB_Header_Info;

/*========================================================================
LOGͣURLC_UL_DATAPDU_TRACE_EVURLC_DL_DATAPDU_TRACE_EV
˵ϱURLC ϡData PduϢ
=========================================================================*/
/*pduٽڵṹ*/
typedef struct {
    BYTE    bRbId;
    BYTE    bPollFg;
    WORD    wSn;
    BYTE    bLiNum;
    BYTE    bErrInd;    
    WORD    wPduSize;
}T_zUrlc_DataPduNode_Trace;

typedef struct {
    BYTE                                bVersion;
    BYTE                                bPadding;
    BYTE                                bDirection;
    BYTE                                bPduNum;
    T_zUrlc_DataPduNode_Trace           atDataPduNode[Z_URLC_MAX_TRACE_NUM];
}T_zUrlc_DataPdu_Trace;

/*========================================================================
LOGͣURLC_UL_CTRLPDU_TRACE_EVURLC_DL_CTRLPDU_TRACE_EV
˵ϱURLC ϡCtrl PduϢ
=========================================================================*/
typedef struct {
    BYTE                                bVersion;
    BYTE                                abPadding[3]; 
    BYTE                                bDirection;
    BYTE                                bRbId;
    BYTE                                bPduType;
    BYTE                                bNackNum;
    WORD                                wNackSn[Z_URLC_MAX_NACKTRACE_NUM];
    WORD                                wAckSn;
    BYTE                                abData[Z_URLC_MAX_DATATRACE_NUM];
}T_zUrlc_CtrlPdu_Trace;

/*========================================================================
LOGͣPDCP2URLC_DATA_IND_TRACE_EVPDCP2URLC_DATA_REQ_TRACE_EV
˵ϱPDCP ϡData Ϣ
=========================================================================*/
typedef struct {
    BYTE                                bVersion;
    BYTE                                abPadding[3];
    BYTE                                bDirection;
    BYTE                                bRbId;
    WORD                                wDataLen;
}T_zPdcp_PsData_Trace;

/*========================================================================
LOGͣMSGTRACEPS_CELLRESORCCO_IND_EV
˵ģʽUCSRϱѡCCOϢ
=========================================================================*/
typedef struct {
    BYTE                                bVersion;
    BYTE                                abPadding[2];
    BYTE                                bAct;                     /*ʽϢ 0x00--GSMʽ0x01---TDʽ*/
    WORD                                wIntraRatResSuccCount;    /*ʽѡɹ,bAct=ZPS_TD_ACTTDʽѡ,bAct=ZPS_GSM_ACTGSMʽѡ*/
    WORD                                wIntraRatResFailCount;    /*ʽѡʧܴ,bAct=ZPS_TD_ACTTDʽѡ,bAct=ZPS_GSM_ACTGSMʽѡ*/
    WORD                                wInterRatResSuccCount;    /*ʽѡɹ,bAct=ZPS_TD_ACTTD->GSMѡ,bAct=ZPS_GSM_ACTGSM->TDѡ*/
    WORD                                wInterRatResFailCount;    /*ʽѡɹ,bAct=ZPS_TD_ACTTD->GSMѡ,bAct=ZPS_GSM_ACTGSM->TDѡ*/
    WORD                                wInterRatCcoSuccCount;    /*ʽCCOɹbAct=ZPS_TD_ACTTD->GSMʽCCO,bAct=ZPS_GSM_ACTGSM->TDʽCCO*/
    WORD                                wInterRatCcoFailCount;    /*ʽCCOʧܴbAct=ZPS_TD_ACTTD->GSMʽCCO,bAct=ZPS_GSM_ACTGSM->TDʽCCO*/
}T_z_CellresOrCco_Ind;

/*========================================================================
LOGͣZEMM_NAS_UE_INFO_IND_EV
˵ϱNAS Ϣ
=========================================================================*/
typedef struct {
    BYTE  bVersion;
    BYTE  abPadding[3];
    BYTE  bMmeGroupID[2];
    BYTE  bMmeCode;
    BYTE  bMTmsi[4];
    BYTE  bEmmStatus;   
}T_zEmm_NasUeInfo_Ind;

/*========================================================================
LOGͣZEUCER_RB_INFO_IND_EV
˵ϱLTE RRC RBϢ
=========================================================================*/
typedef struct {
    BYTE  bRbId;
    BYTE  bRbType;
    BYTE  bRlcMode;
    BYTE  bLogChType;
    BYTE  bLogChId;
    BYTE  bLogChGrp;
    BYTE  bRbStatus; 
}T_zEucer_RbInfo;

typedef struct {
    BYTE              bVersion;
    BYTE              bRbCount;
    T_zEucer_RbInfo   atRbInfo[34];
}T_zEucer_RbInfo_Ind;

/*========================================================================
LOGͣZEUCER_RRC_UE_INFO_IND_EV
˵ϱLTE RRC Ϣ
=========================================================================*/
typedef struct {
    BYTE  bVersion;
    BYTE  bCRntiFlag;                 
    BYTE  bSpsCRntiFlag; 
    BYTE  bTpcRntiFlag; 
    WORD  wCRnti;
    WORD  wSpsCRnti;            
    WORD  wTpcRnti;       
    BYTE  bTmMode;       
    BYTE  bRrcStatus;  
}T_zEucer_RrcUeInfo_Ind;

/*========================================================================
LOGͣEUCSR_SYS_PARA_IND_EV
˵ϱLTE ϵͳϢ
=========================================================================*/
typedef struct {
    BYTE        bVersion;
    BYTE        bPadding;
    WORD        wPhyCellId; 
    WORD        wTac;
    T_z_PlmnId_Trace  tPlmnId;  
    BYTE        bBand;
    BYTE        bBandWidthUL;
    BYTE        bBandWidthDL;
    BYTE        bWorkMode;
    BYTE        bSubFrmAssignType;
    BYTE        bSpclSubFrmPatt;
    CHAR        chPuschP0;
    BYTE        bPuschAlpha;
    BYTE        bServTresele;
    BYTE        bServQHyst;
    BYTE        bPadding1;
}T_zEucsr_SysPara_Ind;

/*========================================================================
LOGͣEUDBG_THROUGHPUT_IND_EV
˵ϱLTE Ϣ
=========================================================================*/
typedef struct
{
    BYTE     bVersion;
    BYTE     abPadding[3];
    DWORD    dwMacThroughPutDl;
    DWORD    dwMacThroughPutUl;       
    DWORD    dwRlcThroughPutDl;
    DWORD    dwRlcThroughPutUl;    
    DWORD    dwPdcpThroughPutDl;
    DWORD    dwPdcpThroughPutUl;
}T_zEudbg_ThroughPut_Ind;

/*========================================================================
LOGͣMSGTRACEPS_DALAYTEST_IND_EV
˵ϱLTE ʱϢϢ
=========================================================================*/
typedef struct {
    BYTE                        bVersion;
    BYTE                        bCountType;
    BYTE                        bDirect;
    BYTE                        bRslt;
    DWORD                       dwTimeCount;
} T_z_DelayTest_Ind;

/*========================================================================
LOGͣROADTEST_UEINFO_CNF_EV
˵ϱնϢ
=========================================================================*/
typedef struct {
    BYTE             bVersion;
    BYTE             abPadding[3];
    BYTE             abEquipName[10]; 
    BYTE             abSoftVersion[10];
    BYTE             abImei[8];
    T_z_IMSI_Trace   tImsi;
}T_zAti_RTUeInfo_Cnf;

/*========================================================================
LOGͣTD_RRC_UE_INFO_IND_EV/W_RRC_UE_INFO_IND_EV
˵ϱTD/W RRC״̬Ϣ
=========================================================================*/
typedef struct {
    BYTE  bVersion;
    BYTE  bRrcStatus;    
    BYTE  abPadding[2];
} T_z_TdRrcUeInfo_Ind, T_z_WRrcUeInfo_Ind;

/*========================================================================
LOGͣEM_CELL_INFO_LOG
˵ϱСϢ
=========================================================================*/
typedef struct {
    BYTE                                         bVersion;
    BYTE                                         bSrcIndex;     /* Դ */
    BYTE                                         bDesIndex;     /* Ŀ */
    BYTE                                         bPadding1;
    /*Ϣ*/
    DWORD                                        dwCellId;      /*ϵͳϢй㲥CI*/
    BYTE                                         bRac;          /*·*/
    BYTE                                         bPadding2;
    WORD                                         wLac;          /*λ*/
    T_z_PlmnId_Trace                             tPlmnId;       /*ǰפplmnid*/
    BYTE                                         bPadding3;
    /*СϢ*/
    T_z_CellInfo_Trace                           tSCell;
    BYTE                                         bSubMode;      /*T/Gģʽ0xFFΪЧֵ*/
    BYTE                                         bAtt;          /*0xFFΪЧֵ*/  
    BYTE                                         bNmo;          /*Network mode,0xFFΪЧֵ*/
    BYTE                                         bRssi;         /*СźTDСΪRSCPGSMСΪRSSILTEΪRSRP*/
    
    BYTE                                         bRsrq;         /*LTEΪRsrq0xFFΪЧֵ*/
    BYTE                                         abPadding4[3];
    
    WORD                                         wT3212;        /*oxffffΪЧֵ*/
    WORD                                         wDchArfcn;     /*GSMµǰƵ㣬TD¹Ƶ㣬LTEΪwEarfcn0xffffΪЧ*/
    
    BYTE                                         bLinkTimeOut;  /*·ʧܼ ,0xffΪЧ*/
    BYTE                                         bBand;       /*LTE/GSM/TDƵΣ(GSM900/1800/1900 TD:A/F LTE 38/40)*/
    BYTE                                         abUlFddArfcnPadding[2];
    DWORD                                        dwUlFddArfcn;   /*FDD-LTEΪƵ㣬0xFFΪЧֵ*/
    /*GSMСϢ,ڷСʽΪGSMʱЧ*/
    SHORT                                        sC1;           /* ·, -1 ΪЧ*/
    SHORT                                        sC2;           /*  -1 ΪЧ */
    SHORT                                        sC31;          /*  -1 ΪЧ */
    SHORT                                        sC32;          /*  -1 ΪЧ */
    
    BYTE                                         bSupGprs;      /* СǷ֧GPRS*/
    BYTE                                         bSupDtxFg;     /* СǷ֧DTX*/
    BYTE                                         bSupHop;       /* СǷ֧Ƶ*/
    BYTE                                         bTav;          /* ʱǰ*/
    /*Ϣ*/
    BYTE                                         bNTCellNum;    /*ʵϱTDΪ0*/
    BYTE                                         bNGCellNum;    /*ʵϱGSM,Ϊ0*/
    BYTE                                         bNLCellNum;    /*ʵϱLTE,Ϊ0*/
    BYTE                                         bPadding5;
    
    T_z_TdCell_Trace                             atNTCellList[Z_TRACE_MaxNTCellNum]; /*TDбRSCPǿ0ΪǿС*/
    BYTE                                         abNTCellRscpList[Z_TRACE_MaxNTCellNum];/*TDRSCPֵatNTCellListСһһӦ*/
    BYTE                                         abPadding6[2];
    
    T_z_LteCell_Trace                            atNLCellList[Z_TRACE_MaxNLCellNum]; /*LTEбRSRPǿ0ΪǿС*/
    BYTE                                         abNLCellRsrpList[Z_TRACE_MaxNLCellNum];/*LTERSRPֵatNLCellListСһһӦ*/
    BYTE                                         abNLCellRsrqList[Z_TRACE_MaxNLCellNum];/*LTERSRqֵatNLCellListСһһӦ*/
    BYTE                                         abDetetFlg[Z_TRACE_MaxNLCellNum];/*ԼСʶatNLCellListСһһӦ*/

    T_z_NGcell_info_Trace                        aNGcellInfo[Z_TRACE_MaxNGCellNum];/*GSMϢRSSIǿ0ΪǿС*/

	DWORD                                        dwCsgId;/*СӦCSGСID  ЧֵΪȫF*/
}T_z_CellInfo_Ind;

/*========================================================================
LOGͣEUMAC_CFG_LOG
˵ϱEUMACϢ
=========================================================================*/
/* Log¼߼ŵ */
#define Z_TOOLS_L2_LOG_LCH_MAXNUM        (BYTE)10

/* Eumacÿ߼ŵ */
typedef struct
{
    BYTE    bRbId;
    BYTE    bLcId;
    BYTE    bPriority;
    BYTE    bLcgId;     //ȡֵΧΪ0-3
    WORD    wPBR;       //λΪkByte/s
    BYTE    abPadding[2];
    DWORD   dwBSD;      //λΪbyte     
}T_zToolsL2_Eumac_ConfigData; 

typedef struct
{
    BYTE    bVersion;
    BYTE    abPadding[3];
    WORD    wTaTimer;                             //msΪλ
    WORD    wBsrTimer;                            //msΪλ
    WORD    wBsrRetxTimer;                        //msΪλ
    WORD    wNumOfDelLogch;                       //Ҫɾ߼ŵ
    BYTE    abDelLcId[Z_TOOLS_L2_LOG_LCH_MAXNUM]; //ɾ߼ŵID
    WORD    wNumOfAddModLogch;                    //Ҫӻ޸ĵ߼ŵ
    T_zToolsL2_Eumac_ConfigData atAddModData[Z_TOOLS_L2_LOG_LCH_MAXNUM];  //ӻ޸߼ŵ
}T_zToolsL2_Eumac_ConfigInfo;

/*========================================================================
LOGͣEUMAC_RACH_TRACE_LOG
˵ϱRAӰϢ
=========================================================================*/
typedef struct
{
    BYTE    bVersion;
    BYTE    abPadding[3];
    BYTE    bRaStep;     //RA裺0ʾRA1ʾյCNF
    BYTE    bRaReason;   //RAԭ0ڽ1ؽ2л3PHYRA
    BYTE    bRachContention;     //0ʾǾ1ʾ
    BYTE    bMsg3Size;    
    WORD    wRarRecvSfn;
    WORD    wMsg3SendSfn;
    BYTE    bRaResult;   //RAִн0ʾǾɹ1ʾɹ2ʾʱ3ʾǰ
    BYTE    bRaPreambleCnt;  //ǰ
    WORD    wCRnti;    //C-RNTIֵ
}T_zToolsL2_Eumac_RaInfo; 

/*========================================================================
LOGͣEURLC_DL_CFG_LOG
˵ϱEURLCӰϢ
=========================================================================*/
/* Log¼RB */
#define Z_TOOLS_L2_LOG_RB_MAXNUM        (BYTE)10

/* EURLC RBϢ */
typedef struct
{
    BYTE bRbId;              //RB ID
    BYTE bAction;            //ԸRBִеĲ1ʾӣ2ʾ޸ģ4ʾͷš  
}T_zToolsL2_Eurlc_ConfigInfo; 

/* EURLCRB */
typedef struct
{
    BYTE bRbMode;  //1ӦAM2ӦUM
    BYTE bLcId;    //߼ŵID
    BYTE bRbId;    //RB ID
    BYTE bRbType;  //1ӦSRB2ӦDRB
    union {
        struct {
            WORD wTreordering;    //msΪλ
            WORD wStatusProhibit; //msΪλ
        } Am_ConfigData;
        
        struct {
            WORD wTreordering;   //msΪλ
            BYTE bSnFieldLength; //SNȣ510 
            BYTE bPadding;
        } Um_ConfigData;
    }ConfigData;
}T_zToolsL2_Eurlc_DlConfigData; 

typedef struct
{
    BYTE    bVersion;
    BYTE    abPadding[2]; 
    BYTE    bCfgReason;    //bit0-bit3ֱӦConfigHandoverReestRelease
    BYTE    bNumOfRelRb;   //ɾRB
    BYTE    abRbId[Z_TOOLS_L2_LOG_RB_MAXNUM];      //гɾRB   
    BYTE    bNumOfAddedModifiedRb;    //ӻ޸ĵRB
    T_zToolsL2_Eurlc_ConfigInfo atRbConfigInfo[Z_TOOLS_L2_LOG_RB_MAXNUM];
    BYTE    abPadding1[3]; 
    BYTE    bNumOfActiveRb;           //RB
    T_zToolsL2_Eurlc_DlConfigData atRbConfigData[Z_TOOLS_L2_LOG_RB_MAXNUM];
}T_zToolsL2_Eurlc_DlConfig;

/*========================================================================
LOGͣEURLC_UL_CFG_LOG
˵ϱEURLCӰϢ
=========================================================================*/

/* EURLCRB */
typedef struct
{
    BYTE    bRbMode;  //1ӦAM2ӦUM
    BYTE    bLcId;    //߼ŵID
    BYTE    bRbId;    //RB ID
    BYTE    bRbType;  //1ӦSRB2ӦDRB
    union {
        struct {
            DWORD    dwPollByte;    //byteΪλ
            WORD     wPollPdu;      //PDU
            WORD     wPollRetrans;  //PollشʱʱmsΪλ
            BYTE     bMaxRetxCnt;   //ش
            BYTE     abPadding[3];             
        } Am_ConfigData;
        struct {
            BYTE     wSnFieldLength;   //SNȣ510
            BYTE     abPadding[11];
        } Um_ConfigData;
    }ConfigData;
}T_zToolsL2_Eurlc_UlConfigData;  

typedef struct
{
    BYTE    bVersion;
    BYTE    abPadding[2];
    BYTE    bCfgReason;    //bit0-bit3ֱӦConfigHandoverReestRelease
    BYTE    bNumOfRelRb;   //ɾRB
    BYTE    abRbId[Z_TOOLS_L2_LOG_RB_MAXNUM];      //гɾRB    
    BYTE    bNumOfAddedModifiedRb;    //ӻ޸ĵRB
    T_zToolsL2_Eurlc_ConfigInfo   atRbConfigInfo[Z_TOOLS_L2_LOG_RB_MAXNUM];
    BYTE    abPadding1[3]; 
    BYTE    bNumOfActiveRb;           //RB    
    T_zToolsL2_Eurlc_UlConfigData atRbConfigData[Z_TOOLS_L2_LOG_RB_MAXNUM];
}T_zToolsL2_Eurlc_UlConfig;

/*========================================================================
LOGͣEPDCP_DL_CFG_LOG
˵ϱEPDCPӰϢ
=========================================================================*/

/* EPDCP RBϢ */
typedef struct
{
    BYTE    bRbId;              //RB ID
    BYTE    bAction;            //ԸRBִеĲ1ʾadd2ʾmodify3ʾModifySuspend4ʾModifyResume5ʾRelease6ʾFullconfig  
}T_zToolsL2_Epdcp_ConfigInfo;

/* EPDCPRB */
typedef struct
{
    BYTE    bRbId;       //RB ID
    BYTE    bEpsId;      //ID
    BYTE    bRbMode;     //1ӦAM2ӦUM
    BYTE    bRbType;     //1ӦSRB2ӦDRB
    BYTE    bSnLength;   //5712
    BYTE    bIsStatusRptEnable;  
    WORD    wRohcMaxCid;
    WORD    wRohcMask;   //Enabled Rohc Profile
}T_zToolsL2_Epdcp_DlConfigData;

typedef struct
{
    BYTE     bVersion;
    BYTE     bCfgReason;    //bit0-bit3ֱӦConfigHandoverReestRelease
    BYTE     bCipherAlg;    //㷨
    BYTE     bIntAlg;       //Ա㷨
    BYTE     bNumOfRelRb;   //ɾRB
    BYTE     abRbId[Z_TOOLS_L2_LOG_RB_MAXNUM];      //гɾRB    
    BYTE     bNumOfAddModRb;           //ӻ޸ĵRB
    T_zToolsL2_Epdcp_ConfigInfo     atRbConfigInfo[Z_TOOLS_L2_LOG_RB_MAXNUM];
    BYTE     abPadding[3]; 
    BYTE     bNumOfActiveRb;           //RB
    T_zToolsL2_Epdcp_DlConfigData   atRbConfigData[Z_TOOLS_L2_LOG_RB_MAXNUM];
}T_zToolsL2_Epdcp_DlConfig;

/*========================================================================
LOGͣEPDCP_UL_CFG_LOG
˵ϱEPDCPӰϢ
=========================================================================*/

/* EPDCPRB */
typedef struct
{
    BYTE    bRbId;    //RB ID
    BYTE    bEpsId;   //ID
    BYTE    bRbMode;  //1ӦAM2ӦUM
    BYTE    bRbType;  //1ӦSRB2ӦDRB
    BYTE    bSnLength;   //5712
    BYTE    bPadding;
    WORD    wDiscardTimer;
    WORD    wRohcMaxCid;
    WORD    wRohcMask;   //Enabled Rohc Profile
}T_zToolsL2_Epdcp_UlConfigData; 

typedef struct
{
    BYTE     bVersion;
    BYTE     bCfgReason;    //bit0-bit3ֱӦConfigHandoverReestRelease
    BYTE     bCipherAlg;    //㷨
    BYTE     bIntAlg;       //Ա㷨
    BYTE     bNumOfRelRb;   //ɾRB
    BYTE     abRbId[Z_TOOLS_L2_LOG_RB_MAXNUM];      //гɾRB    
    BYTE     bNumOfAddModRb;  //ӻ޸ĵRB
    T_zToolsL2_Epdcp_ConfigInfo   atRbConfigInfo[Z_TOOLS_L2_LOG_RB_MAXNUM];
    BYTE     abPadding[3]; 
    BYTE     bNumOfActiveRb;           //RB
    T_zToolsL2_Epdcp_UlConfigData atRbConfigData[Z_TOOLS_L2_LOG_RB_MAXNUM];
}T_zToolsL2_Epdcp_UlConfig;

/*========================================================================
LOGͣUSIM_CARD_MODE_LOG
˵ϱUsimģʽϢ
=========================================================================*/
typedef struct{ 
    BYTE                     bIdType:3; 
    BITS                     bOorE:1; 
    BITS                          :4;
    T_z_PlmnId_Trace         tPlmn; 
    BYTE                     bMMEGROUPID[2]; 
    BYTE                     bMMECODE; 
    BYTE                     bMTMSI[4]; 
    BYTE                     bPadding; 
}T_z_GUTI_Trace;

/*TAC*/
typedef WORD  T_z_TAC_Trace;

/*Tracking Area Identity*/
typedef struct {
    T_z_PlmnId_Trace      tPlmnId;
    T_z_TAC_Trace         tTac;
}T_z_TAI_Trace;


typedef struct
{
    T_z_GUTI_Trace          tGuti;              /*GUTI */
    T_z_TAI_Trace           tTai;                /*TAI */
    BYTE                    bTauStatus;     
    BYTE                    abPadding2[2];
}T_z_UiccId_EpsLoci_Trace;

typedef struct
{
    BYTE                    bVersion;
    BYTE                    bCardMode;     
    BYTE                    bIsLTEServSupp; 
    BYTE                    bPadding;
    T_z_IMSI_Trace          tImsi;       
    T_z_UiccId_EpsLoci_Trace      tEpsLoci;    
}T_zApUicc_UsimCardInfo;

/*========================================================================
LOGͣUSIM_SRV_TABLE_LOG
˵ϱUSimбϢ
=========================================================================*/
typedef struct {
    BITS                                    bLocalPbFg:1;   /* Service n1:  Local Phone Book */
    BITS                                    bFdnFg:1;       /* Service n2:  Fixed Dialling Numbers (FDN) */
    BITS                                    bExtension2:1;  /* Service n3:  Extension 2 */
    BITS                                    bSdnFg:1;       /* Service n4:  Service Dialling Numbers (SDN) */
    BITS                                    bExtension3:1;  /* Service n5:  Extension3 */
    BITS                                    bBdnFg:1;       /* Service n6:  Barred Dialling Numbers (BDN) */
    BITS                                    bExtension4:1;  /* Service n7:  Extension4 */
    BITS                                    bOciFg:1;       /* Service n8:  Outgoing Call Information (OCI and OCT) */

    BITS                                    bIciFg:1;       /* Service n9:  Incoming Call Information (ICI and ICT) */
    BITS                                    bSmsFg:1;       /* Service n10: Short Message Storage (SMS) */
    BITS                                    bSmsrFg:1;      /* Service n11: Short Message Status Reports (SMSR) */
    BITS                                    bSmspFg:1;      /* Service n12: Short Message Service Parameters (SMSP) */
    BITS                                    bAocFg:1;       /* Service n13: Advice of Charge (AoC) */
    BITS                                    bCcpFg:1;       /* Service n14: Capability Configuration Parameters (CCP) */
    BITS                                    bCbmiFg:1;      /* Service n15: Cell Broadcast Message Identifier  */
    BITS                                    bCbmirFg:1;     /* Service n16: Cell Broadcast Message Identifier Ranges  */

    BITS                                    bGrpIdL1Fg:1;   /* Service n17: Group Identifier Level 1 */
    BITS                                    bGrpIdL2Fg:1;   /* Service n18: Group Identifier Level 2 */
    BITS                                    bBspnFg:1;      /* Service n19: Service Provider Name */
    BITS                                    bUPlmnFg:1;     /* Service n20: User controlled PLMN selector with Access Technology */
    BITS                                    bMsisdnFg:1;    /* Service n21: MSISDN */
    BITS                                    bImgFg:1;       /* Service n22: Image (IMG) */
    BITS                                    bSolsaFg:1;     /* Service n23: Support of Localised Service Areas (SoLSA)  */
    BITS                                    bEmlppFg:1;     /* Service n24: Enhanced Multi Level Precedence and Pre emption Service  */

    BITS                                    bAaemlppFg:1;   /* Service n25: Automatic Answer for eMLPP */
    BITS                                    :1;             /* Service n26: RFU */
    BITS                                    bGsmAccFg:1;    /* Service n27: GSM Access */
    BITS                                    bDdvSmsPpFg:1;  /* Service n28: Data download via SMS-PP */
    BITS                                    bDdvSmsCbFg:1;  /* Service n29: Data download via SMS CB */
    BITS                                    bCcByUsimFg:1;  /* Service n30: Call Control by USIM */
    BITS                                    bMosmsByUsimFg:1;/* Service n31:  MO-SMS Control by USIM */
    BITS                                    bRunAtcmdFg:1;  /* Service n32: RUN AT COMMAND command */

    BITS                                    :1;                 /* Service n33: shall be set to '1' */
    BITS                                    bEstFg:1;           /* Service n34: Enabled Services Table */
    BITS                                    bAclFg:1;           /* Service n35: APN Control List (ACL) */
    BITS                                    bDckFg:1;           /* Service n36: Depersonalisation Control Keys */
    BITS                                    bCoopNetListFg:1;   /* Service n37: Co-operative Network List */
    BITS                                    bGsmSecFg:1;        /* Service n38: GSM security context  */
    BITS                                    bCpbcchInfoFg:1;    /* Service n39: CPBCCH Information */
    BITS                                    bIsFg:1;            /* Service n40: Investigation Scan */

    BITS                                    bMexeFg:1;          /* Service n41: MExE */
    BITS                                    bOPlmnFg:1;         /* Service n42: Operator controlled PLMN selector with Access Technology */
    BITS                                    bHPlmnFg:1;         /* Service n43: HPLMN selector with Access Technology */
    BITS                                    bExtension5:1;      /* Service n44: Extension 5 */
    BITS                                    bPlmnNetNameFg:1;   /* Service n45: PLMN Network Name */
    BITS                                    bOPlmnListFg:1;     /* Service n46: Operator PLMN List */
    BITS                                    bMdnFg:1;           /* Service n47: Mailbox Dialling Numbers  */
    BITS                                    bMwiStaFg:1;        /* Service n48: Message Waiting Indication Status */

    BITS                                    bCfiStaFg:1;        /* Service n49: Call Forwarding Indication Status */
    BITS                                    :1;                 /* Service n50: Reserved and shall be ignored */
    BITS                                    bSpdInfoFg:1;       /* Service n51: Service Provider Display Information */
    BITS                                    bMmsFg:1;           /* Service n52  Multimedia Messaging Service (MMS) */
    BITS                                    bExtension8:1;      /* Service n53  Extension 8 */
    BITS                                    bCcOnGprsUsimFg:1;  /* Service n54  Call control on GPRS by USIM */
    BITS                                    bMmsUcpFg:1;        /* Service n55  MMS User Connectivity Parameters */
    BITS                                    bNiaFg:1;           /* Service n56  Network's indication of alerting in the MS (NIA) */

    BITS                                    bVgcsFg:1;          /* Service n57  VGCS Group Identifier List (EFVGCS and EFVGCSS) */
    BITS                                    bVbsFg:1;           /* Service n58  VBS Group Identifier List (EFVBS and EFVBSS) */
    BITS                                    bPseudonymFg:1;     /* Service n59  Pseudonym */
    BITS                                    bUPlmnForIWlanFg:1; /* Service n60    User Controlled PLMN selector for I-WLAN access */
    BITS                                    bOPlmnForIWlanFg:1; /* Service n61    Operator Controlled PLMN selector for I-WLAN access */
    BITS                                    bUWsidListFg:1;     /* Service n62    User controlled WSID list */
    BITS                                    bOWsidListFg:1;     /* Service n63    Operator controlled WSID list */
    BITS                                    bVgcsSecurityFg:1;  /* Service n64    VGCS security */
    
    BITS                                    bVbsSecurityFg:1;   /* Service n65    VBS security */
    BITS                                    bWlanReAuthIdFg:1;  /* Service n66    WLAN Reauthentication Identity */
    BITS                                    bMultiMediaMsgStoFg:1;  /* Service n67    Multimedia Messages Storage */
    BITS                                    bGbaFg:1;               /* Service n68    Generic Bootstrapping Architecture (GBA) */
    BITS                                    bMbmsSecurityFg:1;      /* Service n69    MBMS security */
    BITS                                    bDataDlViaUssdAndUssdAppFg:1;  /* Service n70 Data download via USSD and USSD application mode */
    BITS                                    bEHplmnFg:1;                   /* Service n71 Equivalent HPLMN */
    BITS                                    bAdTermProfAfterUiccActFg:1;   /* Service n72 Additional TERMINAL PROFILE after UICC activation */
    
    BITS                                    bEHplmnPresentIndFg:1;         /* Service n73 Equivalent HPLMN Presentation Indication */
    BITS                                    bLastRplmnSelIndFg:1;          /* Service n74 Last RPLMN Selection Indication */
    BITS                                    bOmaBcastSmartCardProfFg:1;    /* Service n75 OMA BCAST Smart Card Profile */
    BITS                                    bGbaBasedLocalKeyFg:1;         /* Service n76 GBA-based Local Key Establishment Mechanism */
    BITS                                    bTermAppFg:1;                  /* Service n77 Terminal Applications */
    BITS                                    bSpnIconFg:1;                  /* Service n78 Service Provider Name Icon */
    BITS                                    bPlmnNameIconFg:1;             /* Service n79 PLMN Network Name Icon */
    BITS                                    bParaForUsimIpConnecFg:1;      /* Service n80 Connectivity Parameters for USIM IP connections */
    
    BITS                                    bHomeIWlanSpecIdListFg:1;      /* Service n81 Home I-WLAN Specific Identifier List */
    BITS                                    bIWlanEHplmnPresentIndFg:1;    /* Service n82 I-WLAN Equivalent HPLMN Presentation Indication */
    BITS                                    bIWlanHplmnPriorityIndFg:1;    /* Service n83 I-WLAN HPLMN Priority Indication */
    BITS                                    bIWlanLastRplmnFg:1;           /* Service n84 I-WLAN Last Registered PLMN */
    BITS                                    bEmmInfoFg:1;                  /* Service n85 EPS Mobility Management Information */
    BITS                                    bAllowedCsgListAndIndFg:1;     /* Service n86 Allowed CSG Lists and corresponding indications */
    BITS                                    bCallCtrlOnEPdnConnectFg:1;    /* Service n87 Call control on EPS PDN connection by USIM */
    BITS                                    bHplmnDirectAccessFg:1;        /* Service n88 HPLMN Direct Access */
    
    BITS                                    bECallDataFg:1;                /* Service n89 eCall Data */
    BITS                                    bOperatorCsgListAndIndFg:1;    /* Service n90 Operator CSG Lists and corresponding indications */
    BITS                                    bSuppSmOverIpFg:1;             /* Service n91 Support for SM-over-IP */
    BITS                                    :5;
}T_z_UICC_Ust_Trace;

typedef struct{
    BYTE                    bVersion;
    BYTE                    abPadding[3];
    T_z_UICC_Ust_Trace      tUst;        
}T_zApUicc_UsimServTable;
/*========================================================================
LOGͣFRBDN_TAI_LIST_LOG
˵ϱǰĽֹTA listͷֹTA List
=========================================================================*/
#define Z_TRACE_MAX_FTAI_NUM          (BYTE)40        /*ֹTAI*/


typedef struct { 
    BYTE                        bVersion;
    BYTE                        bPadding;
    BYTE                        bFTaiNum;
    BYTE                        bFSTaiNum;
    T_z_TAI_Trace               atFTaiList[Z_TRACE_MAX_FTAI_NUM];
    T_z_TAI_Trace               atFSTaiList[Z_TRACE_MAX_FTAI_NUM];
} T_z_FrbdnTaListLog;

/*========================================================================
LOGͣESM_BEARER_CTX_STATE_LOG
˵ϱESM״̬Ϣ
=========================================================================*/
typedef struct { 
    BYTE                        bVersion;
    BYTE                        bEpsBearerId;
    BYTE                        bEpsBearerState;
    BYTE                        bConnectId;
} T_z_EsmBearerStateLog;

/*========================================================================
LOGͣESM_BEARER_CTX_INFO_LOG
˵ϱESMϢ
=========================================================================*/
typedef struct {
    BYTE                        bLength;
    BYTE                        bQci;
    BYTE                        bUlMBR;
    BYTE                        bDLMBR;
    BYTE                        bULGBR;
    BYTE                        bDLGBR;
    BYTE                        bEXUlMBR;
    BYTE                        bEXDLMBR;
    BYTE                        bEXULGBR;
    BYTE                        bEXDLGBR;
} T_zEsm_EpsQosInfo;

typedef struct { 
    BYTE                        bVersion;
    BYTE                        bEpsBearerType;
    BYTE                        bEpsBearerId;
    BYTE                        bEpsBearerState;
    WORD                        wSdfId;
    BYTE                        bConnectId;
    BYTE                        bLbiFlg;
    BYTE                        bLbi;
    BYTE                        bRbId;
    T_zEsm_EpsQosInfo           tEpsQos;
} T_z_EsmBearerInfoLog;

/*========================================================================
LOGͣESM_PROCE_STATE_LOG
˵ϱESM̷Ϣ
=========================================================================*/
typedef struct { 
    BYTE                        bVersion;
    BYTE                        bInstanceId;
    BYTE                        bProcState;
    BYTE                        bPti;
    WORD                        wSdfId;
    BYTE                        bPendingMsg;
    BYTE                        bPadding;
} T_z_EsmProcStateLog;


/*========================================================================
LOGͣEUMCR_INTRA_FREQ_MEAS_RLTS_LOG
˵ϱСͬƵ
=========================================================================*/
typedef struct
{
    WORD    wPci;
    BYTE    bRsrp;
    BYTE    bRsrq; 
    BYTE    bSrxlev;
    BYTE    bSqual;   
    SHORT   sRValue; 
} T_zEumcr_NEutraCellMeasRlts;

typedef struct
{
    BYTE    bVersion;
    DWORD    dwEarfcn; 
    WORD    wPci;
    BYTE    bRsrp;
    BYTE    bRsrq;   
    BYTE    bSrxlev;
    BYTE    bSqual;  
    SHORT   sRValue; 
    CHAR    cScellPrior; 
    BYTE    bThreshServingLowQIndicator; 
    BYTE    bCellNum; 
    DWORD   dwTreselection; 
    T_zEumcr_NEutraCellMeasRlts   tNIntraCellMeasRlts[Z_EUMCR_TRACE_LTE_CELL_NUM];
} T_zEumcr_EutraIntraFreqMeasRlts;

/*========================================================================
LOGͣEUMCR_INTER_FREQ_MEAS_RLTS_LOG
˵ϱƵ
=========================================================================*/
typedef struct
{
    DWORD   dwEarfcn; 
    BYTE   bReselPrior;
    BYTE   bThresh;
    DWORD  dwTreselection; 
    BYTE   bCellNum;
    BYTE   bCsgFreqInd;
    T_zEumcr_NEutraCellMeasRlts   tNEutraCellRlts[Z_EUMCR_TRACE_LTE_CELL_NUM];
} T_zEumcr_NEutraFreqMeasRlts;

typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bFreqNum;    
    T_zEumcr_NEutraFreqMeasRlts   tNInterFreqMeasRlts[Z_EUMCR_TRACE_LTE_RLT_FREQ_NUM];
} T_zEumcr_EutraInterFreqMeasRlts;

/*========================================================================
LOGͣEUMCR_UTRA_MEAS_RLTS_LOG
˵ϱTD
=========================================================================*/
typedef struct
{
    WORD  wPci;
    BYTE  bRscp;
    BYTE  bSrxlev;
} T_zEumcr_NUtraCellMeasRlts;

typedef struct
{
    WORD   wUarfcn; 
    BYTE   bPrior;
    BYTE   bThresh; 
    DWORD  dwTreselection; 
    BYTE   bCellNum;
    BYTE   abPadding[3];
    T_zEumcr_NUtraCellMeasRlts   tNUtraCellRlts[Z_EUMCR_TRACE_TD_CELL_NUM];
} T_zEumcr_NUtraFreqMeasRlts;

typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bFreqNum;
    T_zEumcr_NUtraFreqMeasRlts   tNUtraFreqMeasRlts[Z_EUMCR_TRACE_TD_RLT_FREQ_NUM];
} T_zEumcr_UtraMeasRlts;

/*========================================================================
LOGͣEUMCR_GSM_FREQ_MEAS_RLTS_LOG
˵ϱGSM
=========================================================================*/
typedef struct
{
    WORD   wArfcn;
    BYTE   bRssi;
    BYTE   bBsic;
    BYTE   bPrior;
    BYTE   bSrxlev;
    BYTE   bThresh; 
    BYTE   bBandindicator;
    DWORD  dwTreselection;  
} T_zEumcr_NGeranCellMeasRlts;

typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bCellNum;    
    T_zEumcr_NGeranCellMeasRlts   tNGeranCellInfo[Z_EUMCR_TRACE_GSM_CELL_NUM];
} T_zEumcr_GeranMeasRlts;

/*========================================================================
LOGͣEUMCR_EUTRA_MEAS_FREQ_LOG
˵ϱõLTEƵ
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bFreqNum;     
    DWORD  dwEarfcn[Z_EUMCR_TRACE_LTE_RLT_FREQ_NUM]; 
} T_zEumcr_EutraMeasConfigEphy;

/*========================================================================
LOGͣEUMCR_UTRA_MEAS_FREQ_LOG
˵ϱõUTRAƵ
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bFreqNum;     
    WORD  wUarfcn[Z_EUMCR_TRACE_TD_RLT_FREQ_NUM];
} T_zEumcr_UtraMeasConfigEphy;

/*========================================================================
LOGͣEUMCR_GSM_MEAS_FREQ_LOG
˵ϱõGSMƵ
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bFreqNum;     
    WORD  wArfcn[Z_EUMCR_TRACE_GSM_CELL_NUM]; 
} T_zEumcr_GeranMeasConfigEphy;

/*========================================================================
LOGͣEUMCR_MOBILITY_CHG_LOG
˵UEƶ״̬仯и,HystNormalʱʱص̬µĹ
=========================================================================*/
typedef struct
{
    BYTE    bVersion;
    BYTE  abPadding[3];
    DWORD    dwEarfcn;
    WORD    wPci;
    BYTE    bPreviousMobilityState;
    BYTE    bCurrentMobilityState;
    BYTE    bTevalution;
    BYTE    bHystNormal; 
    BYTE    bCellChangeNumMedium;
    BYTE    bCellChangeNumHigh;
} T_zEumcr_MoblityStateChange;

/*========================================================================
LOGͣEUMCR_MEAS_CONFIG_CONN_LOG
˵յʱбø
=========================================================================*/
typedef struct
{
    WORD  wCellId;
    CHAR  cCellOffset; 
    BYTE  bPadding;
} T_zEumcr_ListCellInfo;

typedef struct
{
    BYTE  bMeasId;
    BYTE  bEventCfgId;
    DWORD  dwArfcn; 
    BYTE  abPadding[2];
    CHAR  cFreqOffset;
    BYTE  bScellTriggerQuatity; 
    BYTE  bNcellTriggerQuatity;
    BYTE  bScellThreshHold; 
    BYTE  bNcellThreshHold;
    CHAR  cA3offset; 
    BYTE  bHyst;
    BYTE  bPadding;
    DWORD dwReportInterval;    
    WORD  wTTT; 
    BYTE  bReportAmount;
    BYTE  bListCellNum;
    T_zEumcr_ListCellInfo tCellInfo[Z_EUMCR_TRACE_LTE_CELL_NUM];
} T_zEumcr_MeasIdConfig;

typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bSmeasure;
    BYTE  bGapIndicator;
    BYTE  bTTTSf[2];
    BYTE  bMeasIdNum;    
    T_zEumcr_MeasIdConfig  tEvalReport[Z_EUMCR_TRACE_MEASID_NUM];
} T_zEumcr_EvalConfigInfo;

/*========================================================================
LOGͣEUMCR_CELL_EVA_CONN_LOG
˵СĴ״̬ıʱи
=========================================================================*/
typedef struct
{
    BYTE  bMeasId;
    BYTE  bCellState; 
    WORD wCellId;
    DWORD dwArfcn;
    BYTE  bRatType;
    BYTE  abPadding[3];
} T_zEumcr_EvalCellInfoConn;

typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bCellNum;    
    T_zEumcr_EvalCellInfoConn  tEvalCellInfo[Z_EUMCR_TRACE_EVAL_CELL_NUM];
} T_zEumcr_EvalInfoConn;

/*========================================================================
LOGͣEUSIR_S_CHECK_LOG
˵ڴ̬ؿ̬߷СѡʱСS
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[3];
    DWORD dwEarfcn;
    WORD  wPci;
    BYTE  bRsrp;
    BYTE  bRsrq;
    CHAR  cSrxlev;
    CHAR  cSqual;
    SHORT sQxlevMin;
    BYTE  bQxlevMinOffset;
    CHAR  cPemax;
    CHAR  cPumax;
    CHAR  cQualMin;
    BYTE  bQualMinOffset;    
    BYTE  abPadding1[3];
} T_zEusir_SCheckInfo;

/*========================================================================
LOGͣEUSIR_PAGE_CONFIG_LOG
˵СפSIB2DRXڷ仯ʱи
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[3];
    DWORD dwEarfcn;
    WORD  wPci;
    WORD  wPageCycle;
} T_zEusir_PageInfo;

/*========================================================================
LOGͣEUMCR_MEAS_RULE_IDLE_LOG
˵׼ıʱ
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    DWORD  dwEarfcn;
    WORD  wPci;
    BYTE  bRsrp;
    BYTE  bRsrq;
    BYTE  bSrxlev;
    BYTE  bSqual;
    BYTE  bMeasRule;
    BYTE  bSintraSearchP;
    BYTE  bSintraSearchQ;
    BYTE  bSnonintraSearchP;
    BYTE  bSnonintraSearchQ;
} T_zEumcr_MeasRuleInfo;

/*========================================================================
LOGͣEUMCR_LOW_EQUAL_RESEL_LOG
˵Сֵ仯¶Եȡȼѡ׼ıʱ
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bPadding;
    BYTE  bAllowEqualLowPriorResel;
    BYTE  bUseRsrq;
    BYTE  bScellSrxlev;
    BYTE  bScellSqual;
    BYTE  bThreshServingLow;
    BYTE  bThreshServingLowQ;    
} T_zEumcr_EqualLowPriorReselIndicator;

/*========================================================================
LOGͣEUMCR_CELL_EVA_IDLE_LOG
˵̬²С״̬ıʱи
=========================================================================*/
typedef struct
{
    DWORD   dwArfcn;
    WORD    wPadding;
    WORD   wCellId;
    BYTE   bCellState;
    BYTE   bRsrp;
    BYTE   bRsrq;
    BYTE   bRat ;
    DWORD  dwTreselection; 
} T_zEumcr_EvalCellInfoIdle;

typedef struct
{
    BYTE  bVersion;
    BYTE  bPadding[2];
    BYTE  bCellNum;    
    T_zEumcr_EvalCellInfoIdle  tEvalCellInfo[Z_EUMCR_TRACE_EVAL_CELL_NUM];
} T_zEumcr_EvalInfoIdle;

/* ========================================================================
                      һEVENTӿڶ BIGEN
======================================================================== */

/*========================================================================
EVENTͣTRACS_DELAYEVENT_IND_EV
˵ϱѡлؽʽԡפ¼Ϣ
=========================================================================*/


typedef struct {
    BYTE    bAct;
    BYTE    abPadding[3];
    union{
        T_z_TdCell_Trace    tTd;
        T_z_GsmCell_Trace   tGsm;
        T_z_LteCell_Trace   tLte;
        T_z_WCell_Trace     tW;
    }uCell;
}T_z_TargetCell; 

typedef struct {
    DWORD    dwCellId;
} T_z_CampOnCell; 

typedef struct {
    BYTE       bAct;
    BYTE       abPadding[3];
}T_z_IratMeaAct,T_z_RedirectAct;



typedef struct {
    BYTE        bHoTypeFlg;/*л͡bHoTypeFlg Ϊ1ʱЧ0ӲУ1У2У3ͬУ4첽*/
    BYTE        bHoType;
    BYTE        bPadding;
    BYTE        bIdx;/*idx==0ʾҪUnionݡ ccoʧ޷ȷСidxȡֵΪ0.*/
    union{
        T_z_TargetCell    tTCell;
        T_z_CampOnCell    tCOCell;
        T_z_IratMeaAct    tIMAct;
        T_z_RedirectAct   tRDAct;
    }uInfo;
} T_z_EventInfo; 

typedef struct {
    BYTE    bVersion;
    BYTE    bPadding;
    WORD    wDelayEvent;
    T_z_EventInfo    tEventinfo;
} T_z_DelayEvent_Ind;

/*========================================================================
EVENTͣTA_EVENT
˵յTa advance¼
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bPadding;
    WORD  wTaTimer;       //TaʱʱmsΪλ
}T_zToolsL2_Event_Ta;

/*========================================================================
EVENTͣUL_OOS_EVENT
˵TaʱûյµTa advanceʱ¼޲
=========================================================================*/

/*========================================================================
EVENTͣRACH_ACS_STARE_EVENT
˵ʼRachʱ¼
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bPadding;
    BYTE  bRachCause;                               //Rach̵ԭ
    BYTE  bRachContention;                          //Rach뷽ʽ
}T_zToolsL2_Event_RaStart;

/*========================================================================
EVENTͣRACH_ACS_RSLT_EVENT
˵Rach̽ϱ¼
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bRachResult;                               //Rachִн
}T_zToolsL2_Event_RaResult;

/*========================================================================
EVENTͣBSR_OR_SR_REQ_EVENT
˵BSRSRʱϱ¼
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  abPadding[2];
    BYTE  bCauseMask;                               //ÿλ¼BSRSRϢ
}T_zToolsL2_Event_BsrOrSrReq;

/*========================================================================
EVENTͣEUMAC_TIMER_EVENT
˵Macඨʱʱֹͣʱϱ¼
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bPadding;
    BYTE  bTimerType;                               //ʱ
    BYTE  bAction;                                  //ʱ¼
}T_zToolsL2_Event_EUMACTIMER;

/*========================================================================
EVENTͣEUMAC_RESET_EVENT
˵ϱEUMACRESET¼
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bCause;
    BYTE  bPadding[2];
} T_zEucer_MacResetEvent;

/*========================================================================
EVENTͣEURRC_TIMER_EVENT
˵ֹͣʱʱٶʱϢ
=========================================================================*/
typedef struct
{
    BYTE   bVersion;
    BYTE   bTimerName;
    BYTE   bTimerStatus;
    BYTE   bPadding;
    DWORD  dwTimerLength;
} T_zEurrc_TimerInfo;

/*========================================================================
EVENTͣPAGING_DRX_CYCLE_EVENT
˵ϱѰDRC
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bDrxcycleindex;
    BYTE  abPadding[2];
} T_zEucer_DrxCycleCfgEvent;

/*========================================================================
EVENTͣSIB_READ_FAIL_EVENT
˵פSI»лɹȡSIBʧܵ¸
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bPadding;    
    WORD  wPci;
    DWORD dwEarfcn; 
    DWORD dwSibRecvMask;
} T_zEusir_ReadSibFailInfo;

/*========================================================================
EVENTͣEURRC_SECUIRITY_CFG_EVENT
˵ϱLTE RRCȫ
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bStatus;
    BYTE  bPadding[2];
} T_zEucer_RrcSecurityCfgEvent;

/*========================================================================
EVENTͣEMM_TIMER_START_EVENT
˵EMMʱ¼
=========================================================================*/
typedef struct { 
    BYTE    bVersion;
    BYTE    bTimerId;
    BYTE    abpadding[2];
} T_zEmm_Timer_Start;

/*========================================================================
EVENTͣEMM_TIMER_EXPIRY_EVENT
˵EMMʱֹͣ¼
=========================================================================*/
typedef struct { 
    BYTE    bVersion;
    BYTE    bTimerId;
    BYTE    abpadding[2];
} T_zEmm_Timer_Expiry;

/*========================================================================
EVENTͣESM_TIMER_START_EVENT
˵ESMʱ¼
=========================================================================*/
typedef struct { 
    BYTE    bVersion;
    BYTE    bEsmTimerId;
    BYTE    abpadding[2];
} T_zEsm_Timer_Start;

/*========================================================================
EVENTͣESM_TIMER_EXPIRY_EVENT
˵ESMʱֹͣ¼
=========================================================================*/
typedef struct { 
    BYTE    bVersion;
    BYTE    bEsmTimerId;
    BYTE    abpadding[2];
} T_zEsm_Timer_Expiry;

/* ========================================================================
                     LTE EUL2 Ϣӿڶ
======================================================================== */
typedef struct {
    BYTE     bEUMacDlBlc;
    BYTE     bEUMacUlBlc;
    BYTE     bEUMacStatic;
    
    BYTE     bEURlcDlAMAllPdu;
    BYTE     bEURlcDlAMCtrlPdu;
    BYTE     bEURlcDlAMPollPdu;
    BYTE     bEURlcDlAMSignalPdu;
    BYTE     bEURlcDlUMPdu;
    BYTE     bEURlcDlStatic;
    
    BYTE     bEURlcUlAMAllPdu;
    BYTE     bEURlcUlAMCtrlPdu;
    BYTE     bEURlcUlAMPollPdu;
    BYTE     bEURlcUlAMSignalPdu;
    BYTE     bEURlcUlUMPdu;
    BYTE     bEURlcUlStatic;
    
    BYTE     bEPdcpDlPdu;
    BYTE     bEPdcpUlPdu;
    BYTE     bEPdcpDlCipherPdu;
    BYTE     bEPdcpUlCipherPdu;
    BYTE     bEPdcpDlCtrlPdu;
    BYTE     bEPdcpUlCtrlPdu;
    BYTE     bEPdcpDlSrbIntegrityPdu;
    BYTE     bEPdcpUlSrbIntegrityPdu;
    BYTE     bEPDCPDlStatic;
    BYTE     bEPDCPUlStatic;
    
    BYTE     abPadding[3];
    
} T_zEUL2_LogMask_Ind;


/*==============================================================================
 ԭMSGTRACEPS_CELLRESORCCOCOUNT_REQ_EV (->MMIA)
 ˵ģʽ֪ͨMMIAرϱѡCCOϢ
==============================================================================*/
typedef struct {
    BYTE                                         bStackIndex;
    BYTE                                         bAction; /*1:СѡʽCCOͳϱ0:رСѡʽCCOͳϱ*/
    BYTE                                         abPadding[2];
}T_z_MsgtracePs_CellresOrCcoCount_Req;

/* for MsgTrace */
typedef struct {
    BYTE                                         bStackIndex;
    BYTE                                         bAction;
    BYTE                                         abPadding[2];
}T_zMsgtracePs_CellDisplay_Req;



/*========================================================================
LOGͣGMM_STATE_LOG
˵NAS GMM state
=========================================================================*/
typedef struct
{   BYTE                    bVersion;
    BYTE                    bGmmState;
    BYTE                    bGmmUpdateState;
    BYTE                    bPadding;
 }T_zNas_Gmm_StateInfo;

/*========================================================================
LOGͣMM_STATE_LOG
˵NAS MM state
=========================================================================*/
typedef struct
{
    BYTE                    bVersion;
    BYTE                    bMmState;
    BYTE                    bMmUpdateState;
    BYTE                    bPadding;
 }T_zNas_Mm_StateInfo;

/*========================================================================
LOGͣNAS_REGISRT_STATE_LOG
˵NAS_REG state
=========================================================================*/
typedef struct
{
    BYTE                    bVersion;
    BYTE                    bPlmnSelMode;
    BYTE                    bUeOperMode;
    BYTE                    bPadding;
 }T_zNas_MM_RegState;

/*========================================================================
LOGͣCC_MO_SETUP_LOG
˵WCDMA NAS CS connection management call set up
=========================================================================*/
typedef struct
{
    BYTE                    bVersion;
    BYTE                    bCircuitcallID;  /*integer from 0 to 6, 8 to 14*/
    BYTE                    bStreamId;       /*0 (no bearer) to 255*/
    BYTE                    bCcState;
    BYTE                    bMpartyStare;   /*State of multiparty calls*/
    BYTE                    bHoldStare;     /*hold State of the call*/
    BYTE                    bCallType;     
    BYTE                    bCallOrigDir;   /*This is the call origination direction*/
    BYTE                    bCallingNumberLen; /*The number of CALLING_Number ; if 0, there is no number available*/
    BYTE                    abCallingNumber[20]; /*Calling party BCD number*/
    BYTE                    bCalledNumberLenth; /*The number of CALLED_Number ; if 0, there is no number available*/
    BYTE                    abCalledNumber[40]; /*Called party BCD number*/
    BYTE                    abPadding[2];
} T_zNas_Cc_Setup;

/*========================================================================
LOGͣSM_MO_SETUP_LOG
˵WCDMA NAS PS connection management call set up
=========================================================================*/
typedef struct
{
    BYTE                    bVersion;
    BYTE                    bPsConnInd;     /*Packet switch call ID; integer from 0 to 6*/
    BYTE                    bNSAPI;         /*The NSAPI value*/
    BYTE                    bPadding;
} T_zNas_Sm_Setup;

/*========================================================================
LOGͣNAS_MM_CHARACTERISTICS_LOG
˵UMTS NAS MM characteristics
=========================================================================*/
typedef struct
{
    BYTE                    bVersion;
    BYTE                    bNetOpMode;     /*ģʽ 0 C Class 1 1 C Class 22 C Class 3*/
    BYTE                    bServType;      /*ͣ0 C NO_SERVICE 1 C CS_ONLY2 C PS_ONLY3 C CS_PS_SERVICE4 C LIMITED_SERVICE*/
    T_z_PlmnId_Trace        bServPlmnId;    /*ID*/
    WORD                    wLac;           /*λ*/
    BYTE                    bRac;           /*·*/
    BYTE                    bEplmnNum;      /*EPLMN*/
    T_z_PlmnId_Trace        atPLMN[Z_TRACE_MAX_PLMN_NUM];  /*EPLMN б*/
} T_zNas_Mm_Characteristics;

/*========================================================================
LOGͣNAS_QoS_LOG
˵UMTS NAS QoS
=========================================================================*/
/*24008_10.5.6.5 , Quality_of_service*/
typedef struct{
    BYTE                     bVersion;
    BYTE                     abPadding[3];
    BYTE                     bSpare0:2;
    BYTE                     bDlyClss  :3;
    BYTE                     bReliabClss  :3;
    BYTE                     bPeakPut  :4;
    BYTE                     bSpare4:1;
    BYTE                     bPrecClss  :3;
    BYTE                     bSpare6:3;
    BYTE                     bMeanPut  :5;
    BYTE                     bpresentfg1;
    BYTE                     bTraffClss  :3;
    BYTE                     bDelivOrd  :2;
    BYTE                     bDelivErrSDU  :3;
    BYTE                     bMaxSDUsiz;
    BYTE                     bMaxBitUp;
    BYTE                     bMaxBitDown;
    BYTE                     bResiBER  :4;
    BYTE                     bSDUerrRat  :4;
    BYTE                     bTranLay  :6;
    BYTE                     bTrafHand  :2;
    BYTE                     bGuarBitUp;
    BYTE                     bGuarBitDown;
    BYTE                     bpresentfg2;
    BYTE                     bSpare20:3;
    BYTE                     bSignInd  :1;
    BYTE                     bSourDescr  :4;
    BYTE                     bpresentfg3;
    BYTE                     bMaxBitExtDl;
    BYTE                     bGuarBitExtDl;
    BYTE                     bpresentfg4;
    BYTE                     bMaxBitExtUl;
    BYTE                     bGuarBitExtUl;
}T_zNas_QoS;

/*========================================================================
LOGͣNAS_BC_LOG
˵ UMTS NAS connection bearer capability
=========================================================================*/
typedef struct{
    BYTE                     bVersion;
    BYTE                     abPadding[3];
    BYTE                     bSpare0:1;
    BYTE                     bRChReq  :2;
    BYTE                     bCodeStd  :1;
    BYTE                     bTranMode  :1;
    BYTE                     bTranCapa  :3;
    BYTE                     bpresentfg1;
    BYTE                     bSpare5:1;
    BYTE                     bCmprss  :1;
    BYTE                     bStru  :2;
    BYTE                     bDuplMode  :1;
    BYTE                     bCfg  :1;
    BYTE                     bNIRR  :1;
    BYTE                     bEst  :1;
    BYTE                     bpresentfg2;
    BYTE                     bExt2  :1;
    BYTE                     bSpare13:2;
    BYTE                     bRateAdap  :2;
    BYTE                     bSignalAP  :3;
    BYTE                     bSpare16:1;
    BYTE                     bOtherITC  :2;
    BYTE                     bOtherAdapt  :2;
    BYTE                     bSpare19:3;
    BYTE                     bpresentfg3;
    BYTE                     bExt4  :1;
    BYTE                     bSpare21:2;
    BYTE                     bUserlay1  :4;
    BYTE                     bSyncAsync  :1;
    BYTE                     bExt5  :1;
    BYTE                     bNumStopBit  :1;
    BYTE                     bNego  :1;
    BYTE                     bNumDataBit  :1;
    BYTE                     bUserRate  :4;
    BYTE                     bExt6  :1;
    BYTE                     bIntermRate  :2;
    BYTE                     bNIConTX  :1;
    BYTE                     bNIConRX  :1;
    BYTE                     bParity  :3;
    BYTE                     bExt7  :1;
    BYTE                     bConnElem  :2;
    BYTE                     bModemType  :5;
    BYTE                     bExt8  :1;
    BYTE                     bOtherType  :2;
    BYTE                     bFixRate  :5;
    BYTE                     bExt9  :1;
    BYTE                     bAccptCode  :4;
    BYTE                     bMaxNum  :3;
    BYTE                     bExt10  :1;
    BYTE                     bUIMI  :3;
    BYTE                     bWantUserRate  :4;
    BYTE                     bSpare46:1;
    BYTE                     bAccptCodeExt  :3;
    BYTE                     bAsyInd  :2;
    BYTE                     bSpare49:2;
    BYTE                     bpresentfg4;
    BYTE                     bSpare50:1;
    BYTE                     bSpare51:2;
    BYTE                     bLay2Proto  :5;
}T_zNas_BC;

/*========================================================================
LOGͣUE_DYNAMICID_LOG
˵ UMTS UE Dynamic ID
=========================================================================*/
typedef struct
{
    BYTE                    bVersion;
    BYTE                    bTmsiFlag;     /*ʱûID 0 C TMSI1 C PTMSI*/
    BYTE                    abPadding[2];
    BYTE                    abId[4];       /*TMSIP-TMSI*/
} T_zUe_DynamicId;

/*========================================================================
LOGͣUE_STATIC_LOG
˵ UMTS UE Static ID
=========================================================================*/
typedef struct
{
    BYTE                    bVersion;
    BYTE                    abPadding[3];
    T_z_IMSI_Trace          tImsiId;              /*IMSI*/
    BYTE                    abImeiId[8];          /*IMEI*/
    BYTE                    abImeisvId[8];        /*IMEISV*/
} T_zUe_StaticId;

/*========================================================================
EVENTͣW_TIMER_EVENT
˵:ʱֹͣʱʱٶʱϢ
=========================================================================*/
typedef enum{
    Z_UMTS_T300,/*WRRC*/
    Z_UMTS_T302,
    Z_UMTS_T304,
    Z_UMTS_T305,
    Z_UMTS_T307,
    Z_UMTS_T308,
    Z_UMTS_T309,
    Z_UMTS_T312Idle,
    Z_UMTS_T312Con,
    Z_UMTS_T313,
    Z_UMTS_T314,
    Z_UMTS_T315,
    Z_UMTS_T316,
    Z_UMTS_T317,
    Z_UMTS_T319,
    Z_UMTS_T320,
    Z_UMTS_T323,
    Z_UMTS_T325,
    Z_UMTS_Twait,
    Z_UMTS_Treselect,

    Z_T3210, /*MM*/
    Z_T3211,
    Z_T3212,
    Z_T3213,
    Z_T3214,
    Z_T3216,
    Z_T3218,
    Z_T3220,
    Z_T3230,
    Z_T3240,
    
    Z_T3310,  /*GMM*/
    Z_T3311,
    Z_T3316,
    Z_T3318,
    Z_T3320,
    Z_T3321,
    Z_T3330,
    Z_T3340,
    Z_T3302,
    Z_T3312,
    Z_T3314,
    Z_T3317,
    Z_T3319,
    Z_T3323,

    Z_T3380, /*SM*/
    Z_T3381,
    Z_T3390,
//   Z_T3320,

    Z_T303,  /*CC*/
    Z_T305,
    Z_T308,
    Z_T310,
    Z_T313,
    Z_T323,
    Z_T324,
    Z_T332,
    Z_T335,
    Z_T336,
    Z_T337,

    Z_TR1M, /*SMS*/
    Z_TRAM,
    Z_TR2M,
    Z_TC1M,

    Z_SS_T_M,    /*SS*/
    Z_SS_T_ML,
    Z_SS_T_MS_USSD
}T_zUmts_TimerType;


typedef struct
{
    BYTE   bVersion;
    BYTE   bPadding;
    BYTE   bTimerName;
    BYTE   bTimerStatus;
    DWORD  dwTimerLength;
} T_Umts_TimerInfo;

/*========================================================================
EVENTͣW_CAMPFAIL_EVENT
˵פʧ¼ϱ
=========================================================================*/
typedef struct
{
    BYTE  bVersion;
    BYTE  bFailCause; 
    BYTE  abPadding[2];
} T_zUmts_CampFailEvent;

/*========================================================================
EVENTͣW_OUTSYNC_EVENT
˵ʧ¼ϱ
=========================================================================*/


/*========================================================================
EVENTͣW_RLCUNRECOVERR_EVENT
˵WRLC޷ָԴ¼ϱ
=========================================================================*/


/*========================================================================
LOGͣZ_WCDMA_RRC_STATUS_LOG
˵WRRC״̬Ϣ
=========================================================================*/
typedef struct{
    BYTE     bVersion;
    BYTE     bRrcStatus;   /* 0: Dch; 1: Fach; 2: CellPch; 3: UraPch; 4: Idle; 5 FachCcch*/   
    BYTE     abPadding[2];
}T_zWRRC_STATUS;

/*========================================================================
LOGͣZ_WCDMA_RRC_PROTOCOL_ERROR_LOG
˵WRRCЭϢ
=========================================================================*/
typedef struct{
    BYTE    bVersion;
    BYTE    bProtocolError; /* 0 C ASN.1 violation or encoding error; 
                        1 C Message type non-existent or not implemented; 
                        2 C Message not compatible with receiver state; 
                        3 C Information element value not comprehended; 
                        4 C Information element missing; 
                        5 C Message extension not comprehended  10.3.3.26*/
    BYTE    abPadding[2];
}T_zWRRC_PROTOCOL_ERROR;

/*========================================================================
LOGͣZ_WCDMA_RRC_SERVCELL_INFO_LOG
˵W ServCellϢ(Dch̬ʹãDch̬wDlUarfcnЧDch̬ʱᷢһwDlUarfcnȫΪ0xFFϢ)
=========================================================================*/
typedef struct{
    BYTE                  bHcsInd:1;
    BYTE                  :7;
    BYTE                  bServHcs;
    BYTE                  bQhyst;
    BYTE                  bQhcs;
    CHAR                  cSIntraSrh;       /*ʵֵ*2, ЧֵΪ0*/
    CHAR                  cSInterSrh;       /*ʵֵ*2, ЧֵΪ0*/
    CHAR                  cSSrhHcs;         /*ЧֵΪ0*/
    CHAR                  cQQualMin;
    CHAR                  cQRxlevMin;
    CHAR                  cSrhRat;          /*ʵֵ*2, ЧֵΪ0*/
    CHAR                  cSHcsRat;         /*ЧֵΪ0*/
    CHAR                  cSLimitSrhRat;    /*ʵֵ*2, ЧֵΪ0*/
    CHAR                  cMaxAlwUlTxPwr;
    CHAR                  cPadding[3];
    WORD                  wTreselect;       /*ѡʱ䣬Ϊ0,λΪms*/
    WORD                  wPadding;      
}T_zWRRC_SERVCELL_RESINFO;

typedef struct{
    BYTE       bVersion;
    BYTE       abPadding[2];
    BYTE       bCellAccessRest;  /*First bit 0 C Cell barred,1 C Cell not barred
                                   Second bit: 0 C Cell reserved for operator use; 1 C Cell not reserved for operator use
                                   Third bit:  0 C Cell reserved Extension, 1 C Cell not reserved Extension
                                   Чֵ0xFF(DCH)*/
    WORD       wUlUarfcn;        /*0..16383*/
    WORD       wDlUarfcn;        /*0..16383*/
    WORD       wPrimSrc;         /*Dch̬ȡֵΪ0xFFFF*/
    
    WORD       wCallAccs;        /*ȼǷbarϢBit0~15Ӧȼ0~150 C Cell not barred,1 C Cell barred*/  


    WORD       wUraId;           /*Which URA to use in case of overlapping URAs, bit string (16) 10.3.2.6 RecfgMsg, Чֵ0xFFFF(DCH)*/
    WORD       wPadding;
    DWORD      dwCellId;         /*Cell identity, bit string (28), Dch̬棬Чֵ0xFFFFFFFF(DCH)*/
    T_zWRRC_SERVCELL_RESINFO   tResInfo;
}T_zWRRC_SERVCELLINFO;

/*========================================================================
LOGͣZ_WCDMA_RRC_CMINFO_LOG
˵WΪʽʱר̬ѹģʽϢ
=========================================================================*/
typedef struct {   
    BYTE         bRpp;               /*Recovery Period Powerģʽ0ģʽ1*/
    BYTE         bItp;               /*initial Transmit Power ģʽ0ģʽ1*/
    BYTE         bCmMode;            /*Ул, 0:У 1:У2:*/
    BYTE         bDlCmMethod;        /*0: SF/2, 1: higher layer scheduling)*/
    BYTE         bUlCmMethod;        /*0: SF/2, 1: higher layer scheduling)*/
    BYTE         bDlFrameType;       /*0:A 1:B*/
    BYTE         bDeltaSir1;         /*0~30, ʵֵ0.1*/
    BYTE         bDeltaSirAfter1;    /*0~30, ʵֵ0.1*/
    BYTE         bDeltaSir2;         /*0~30, ʵֵ0.1ĬΪbDeltaSir1*/
    BYTE         bDeltaSirAfter2;    /*0~30, ʵֵ0.1ĬΪbDeltaSirAfter1*/
    BYTE         abPadding[2];
}T_zWRRC_CmStaticInfo;

typedef struct{
    BYTE          bTgmp;        /*ѹģʽĿģ0:TDD; 1:FDD; 2:GsmRssi; 3: InitBsic; 4: Bsic Recnf; 5: Multicarrier; 6: Eutra*/
	BYTE          bTgsn;        /*ʼʱ϶ţ 0~14*/
    BYTE          bTgl1;        /*һGAPĳȣʱ϶ 1~14*/
    BYTE          bTgl2;        /*ڶGAPĳȣ 1~14ASN.1ֵΪ0ʱbTgl1*/
    BYTE          bTgpl;        /*ȣ֡1~144*/
    BYTE          abPadding[3];
    WORD          wTgd;         /*GAPʼľ룬ʱ϶15~269,0XFFFFʾundifined*/
    WORD          wTgprc;       /*ظ1~5110XFFFFinfinity*/
    T_zWRRC_CmStaticInfo    tStaticInfo;
}T_zWRRC_CmCfgInfo;

typedef struct{
    BYTE          bTgpsi;             /*1~6*/
    BYTE          bStatus;   	      /*0ʾ1ʾȥ*/
	BYTE          bCmCfgFlg;          /*ָʾbCmCfgFlgǷڣӦTgpsiStatusϢ*/
	BYTE          bPadding;
	T_zWRRC_CmCfgInfo    tCmCfgInfo;
}T_zWRRC_CmItem;

typedef struct{
	BYTE             bVersion;
	BYTE             bCmNum;
	BYTE             abPadding[2];
	T_zWRRC_CmItem   atCmItem[WRRC_MAX_CM_NUM];
}T_zWRRC_CMINFO;

/*========================================================================
LOGͣZ_WCDMA_RRC_RESELECTCELL_LOG
˵WΪʽʱСѡϢWGSMϢ
=========================================================================*/
typedef struct{
    WORD        wDlUarfcn;
    WORD        wPrimSrc;              /*Primary scrambling code, 0~511*/
    BYTE        bRscp;                 /*0~96*/
    BYTE        bEcNo;                 /*0~49*/
    BYTE        abPadding[2];
    SHORT       sValueRscp;            /*RscpRֵSֵϢbResType0Rֵ1Sֵ*/
    SHORT       sValueEcNo;            /*EcNoRֵSֵϢbResType0Rֵ1SֵڸֵΪ-10000*/
}T_zWRRC_BETTER_WCELL;

typedef struct{ 
    BYTE        bBsic;              /*Bcc: Bit0~2, Ncc:Bit3~5*/   
    BYTE        bRssi;              /*0~63*/
    BYTE        abPadding[2];
    WORD        wArfcn;             /*0 ~1023, Band900λ1*/
    SHORT       sValue;             /*ϢbResType0Rֵ1Sֵ*/
}T_zWRRC_BETTER_GSMCELL;

typedef struct{
    DWORD       dwEarfcn;
    WORD        wPci;
    SHORT       sSrxlev;
    SHORT       sSqual;            /*ڸֵΪ10000*/
    BYTE        abPadding[2];
}T_zWRRC_BETTER_LTECELL;

typedef struct{
    BYTE        bVersion;
    BYTE        bResType;             /*1:ͨѡ2ȼѡֵWGSMСValueֵΪRֵSֵ*/
    BYTE        bWCellNum;            /*0~32*/
    BYTE        bGsmCellNum;          /*0~32*/
	BYTE        bLteCellNum;          /*0~16*/
	BYTE        abPadding[3];
    T_zWRRC_BETTER_WCELL    atBetterWCell[WRRC_MAX_RES_WCELL];
    T_zWRRC_BETTER_GSMCELL  atBetterGsmCell[WRRC_MAX_RES_GSMCELL];
	T_zWRRC_BETTER_LTECELL  atBetterLteCell[WRRC_MAX_RES_LTECELL];
}T_zWRRC_RESELECTCELL;

/*========================================================================
LOGͣZ_WCDMA_RRC_FMOINFO_LOG
˵FACH Measurement Occasion Information
=========================================================================*/
typedef struct{
    BYTE         bVersion;
    BYTE         bFmoCfgInd;        /*1:confg, 0: not cfg*/
    BYTE         abPadding[2];
    WORD         wTtiPeriod;        /*FACH Measurement occasion cycle length, 1~4096*/
    WORD         wTtiOffset;
}T_zWRRC_FMOINFO;

/*========================================================================
LOGͣZ_WCDMA_RRC_MCEVENTINFO_LOG
˵Wʽ£Dch EventϢ
=========================================================================*/
typedef struct {
    BYTE        bMcId;
    BYTE        bEventId;        /*0:1A,1:1B,...5:1F, 9:1J (ͬƵ¼ƫ10) */
    BYTE        bW;                   
    BYTE        bHysteresis;
    BYTE        bTimeToTrigger; 
    BYTE        bCellNumThld;        /*0~7 1A¼ΪReporting deactivation threshold 1C1J¼ΪReplacement activation threshold*/
    BYTE        bTriggerCondition;   /* 0: not used, 1: Active set cells, 2:Monitored set cells, 
                                     3:Active set cells and monitored set cells, 4: Detected set cells, 
                                     5: Detected set cells and monitored set cells.*/ 
    BYTE        bRptRange;
    SHORT       sThld;                  /*ʹ1EF¼*/
	SHORT       sPadding;
}T_zWRRC_IntraEventInfo;

typedef struct {
    BYTE        bMcId;
    BYTE        bEventId;             /*0:2A,1:2B,...5:2F (Ƶ¼ƫ20)*/
    BYTE        bUsedFreqW;
    BYTE        bNotUsedFreqW; 
    BYTE        bHysteresis;
    BYTE        bTimeToTrigger;
    BYTE        abPadding[2];
    SHORT       sUsedFreqThld;        /*Event2B,2D,2F*/
    SHORT       sNotUsedFreqThld;     /*Event2B,2C,2E*/
}T_zWRRC_InterEventInfo;

typedef struct {
    BYTE        bMcId;
    BYTE        bEventId;           /*0:2A,1:2B,...5:2F(RAT¼ƫ30)*/
    BYTE        bW; 
    BYTE        bHysteresis;
    BYTE        bTimeToTrigger;
    BYTE        abPadding[3]; 
    SHORT       sOwnThreshold;     /*Integer (-115..0),in event 3A*/ 
    SHORT       sOtherSysThreshold;
}T_zWRRC_RatEventInfo;

typedef struct{
    BYTE                bIdx;   /*bIdx=0: dch*//*bIdx=1: NULL*//*bIdx=2: usch*/
    
    union{
        BYTE                      bDch;
        T_zUrrc_ASN1NULL_Trace    tRachNull;
        BYTE                      bUsch;
    }Val;
    BYTE                abPadding[2];
}T_zWRRC_UlTrchId;

typedef struct {
    BYTE        bMcId;
    BYTE        bEventId;               /*0:4A 1:4B, (ҵ¼ƫ40)*/
    BYTE        bThreshold;             /*0~25*/
    BYTE        bPadding;
    WORD        wTimeToTrigger;         /*0~15*/
    WORD        wPendTime;              /*0~5*/
    WORD        wTxIntAfterTrig;         /*0~6*/
    WORD        wPadding;
    T_zWRRC_UlTrchId      tTrchId;
}T_zWRRC_TvEventInfo;

typedef struct {
    BYTE           bMcId;
    BYTE           bTrchId;           /*1~32*/
    BYTE           abPadding[2];
    WORD           wTotalCrc;         /*1~512*/
    WORD           wBadCrc;           /*1~512*/
    WORD           wPendAfterTrig;    /*1~512*/
    WORD           wPadding;  
}T_zWRRC_QuaEventInfo;

typedef struct {
    BYTE        bMcId;
    BYTE        bEventId;               /*0:6A 1:6B ... 5:6F (UEڲ¼ƫ60)*/
    BYTE        bPadding;
    BYTE        bTxpThld;               /*Event 6A,6B, -50~33ƫ71*/
    WORD        wRtdThld;               /*Event 6F,6G, 768~1280*/
    WORD        wTimeToTrigger;         /*0 ~ 5000*/
}T_zWRRC_UeInterEventInfo;

typedef struct {
    BYTE    bEventType;             /*0:Intra, 1:Inter, 2: Rat, 4:Tv, 5:Qua, 6:UeInter  (No 3)*/
    BYTE    abPadding[3];
    union{
        T_zWRRC_IntraEventInfo      tIntraEvent;
        T_zWRRC_InterEventInfo      tInterEvent;
        T_zWRRC_RatEventInfo        tRatEvent;
        T_zWRRC_TvEventInfo         tTvEvent;
        T_zWRRC_QuaEventInfo        tQuaEvent;
        T_zWRRC_UeInterEventInfo    tUeInterEvent;
    }uEventInfo;
}T_zWRRC_MeasEventInfo;

typedef struct {
    BYTE        bVersion;
    BYTE        bEventNum;
	BYTE        abPadding[2];
    T_zWRRC_MeasEventInfo    atMeasEventInfo[WRRC_MAX_EVENT_NUM];
}T_zWRRC_MCEVENTINFO;

/*========================================================================
LOGͣ Z_WCDMA_RRC_CELLINFO_LOG
˵Wʽ£Ϣ
=========================================================================*/

typedef struct {
    BYTE                 bHcsCellFlg:1; 
    BYTE                 bQrxlevminFlg:1;
    BYTE                 bQqualinFlg:1;
    BYTE                 :5;
    BYTE                 bHcsPrio;                          /*Integer (0..7)*/
    BYTE                 bQhcs;
    CHAR                 cQoffset1;                         /*Integer(-50..50), default is 0*/
    CHAR                 cQoffset2;                         /*Integer(-50..50), default is 0*/
    CHAR                 cMaxTxP;                           /*Maximum allowed UL TX power,Integer(-50..33)*/                     
    CHAR                 cQrxlevmin;                        /*Integer (-115..-25 by step of 2)*/ 
    CHAR                 cQqualmin;                         /*Integer(-24~0), default serv*/
}T_zWRRC_CellCsrInfo;

typedef struct {
	BYTE                bReadSfnInd:1;
    BYTE                bTxDivInd:2;
	BYTE                :5;
	BYTE                bCellId;
    CHAR                cCellIndvOff;
	CHAR                cPcpichTxPwr;
	WORD                wPrimSrc;
	WORD                wPadding;
    T_zWRRC_CellCsrInfo  tCsrInfo;
}T_zWRRC_FddCellInfo;

typedef struct {
	BYTE                bCellId;
	BYTE                bBand;
	BYTE                bBsic;
	CHAR                cCellIndvOff;
	WORD                wArfcn;  /*Band 1900ʱλ1*/
    WORD                wPadding;
    T_zWRRC_CellCsrInfo   tCsrInfo;
}T_zWRRC_GsmCellInfo;

typedef struct {
    BYTE         bVersion;
    BYTE         abPadding[3];
	BYTE         bIntraCellNum;
	BYTE         bInterCellNum;
	BYTE         bGsmCellNum;
	BYTE         bLteFreqNum;
	WORD         awDlUarfcn[WRRC_MAX_INTERCELL_NUM];       /*atInterCellInfo[]Ӧ*/
	T_zWRRC_FddCellInfo     atIntraCellInfo[WRRC_MAX_INTRACELL_NUM];
	T_zWRRC_FddCellInfo     atInterCellInfo[WRRC_MAX_INTERCELL_NUM];
	T_zWRRC_GsmCellInfo     atGsmCellInfo[WRRC_MAX_GSMCELL_NUM];
	DWORD                    adwEuarfcn[WRRC_MAX_LTEFREQ_NUM];
}T_zWRRC_CELLINFO;


/*========================================================================
LOGͣ Z_WCDMA_RRC_PRIOINFO_LOG
˵Wʽ£ƵȼϢ
=========================================================================*/

typedef struct {
    BYTE           bPrio;                        /*0-7*/
    BYTE           bSprioSearch1;                /*MP, 0..62 by step of 2*/
    BYTE           bSprioSearch2;                /*MD, default:0, 0..7 by step of 1 ʵֵ2*/
    BYTE           bThreshServlow;               /*MP, 0..62 by step of 2*/
    BYTE           bThreshServlow2;              /*MD,default 0, 0..62, FDD. R9汾֮ǰʹ*/ 
    BYTE           abPadding[3];
}T_zWRRC_ServPrioInfo;

typedef struct {
    BYTE            bPrio;
    BYTE            bThodhighFg:1;
    BYTE            bThodlowFg:1;
    BYTE            :6;
    BYTE            bThreshxhigh;              /*0..62 by step of 2*/
    BYTE            bThreshxlow;               /*0..62 by step of 2*/
    CHAR            cQrxlevmin;                /*MD, -119..-25 by step of 2, */
    CHAR            cQqualmin;                 /*MD, -24..0, Default value is -24*/
    WORD            wUarfcn;
}T_zWRRC_UtraFreqPrioInfo;

typedef struct {
    BYTE            bFreqNum;
    BYTE            abPadding[3];
    T_zWRRC_UtraFreqPrioInfo  atFreqPrioInfo[WRRC_MAX_PRIOUTRAFREQ_NUM];
}T_zWRRC_UtraPrioInfo;

typedef struct {
    BYTE            bPrio;
    BYTE            bThodhighFg:1;
    BYTE            bThodlowFg:1;
    BYTE            :6;
    BYTE            bThreshxhigh;         /*0..62 by step of 2*/
    BYTE            bThreshxlow;          /*0..62 by step of 2*/
    CHAR            cQmin;                /*MD, -115..-56 by step of 2, Default value is -115*/
    CHAR            cPadding;
    WORD            wArfcn;               /*MP, 0..1023*/
}T_zWRRC_GsmCellPrioInfo;

typedef struct {
    BYTE            bCellNum;
    BYTE            abPadding[3];
    T_zWRRC_GsmCellPrioInfo   atGsmCellPrioInfo[WRRC_MAX_GSMCELL_NUM];
}T_zWRRC_GsmPrioInfo;

typedef struct {
    BYTE            bPrio;
    BYTE            bThodhighFg:1;
    BYTE            bThodlowFg:1;
    BYTE            bThodhigh2Fg:1;       /*R8֧Ч*/
    BYTE            bThodlow2Fg:1;        /*R8֧Ч*/
    BYTE            :4;
    BYTE            bThreshxhigh;         /*0..62 by step of 2*/
    BYTE            bThreshxlow;          /*0..62 by step of 2*/
    BYTE            bThreshxhigh2;        /*Integer (0..31)*2,  ʵֵ*2*/
    BYTE            bThreshxlow2;         /*Integer (0..31)*2,  ʵֵ*2*/
    CHAR            cQqualmin;            /*MD, -34..-3, Default value is negative infinity*/
    CHAR            cPadding; 
    SHORT           sQrxlevmin;           /*MD, -140..-44 by step of 2, Default value is -140*/
    BYTE            abPadding[2];
    DWORD            dwEarfcn;              /*MP, 0 .. 65535*/
}T_zWRRC_LteFreqPrioInfo;

typedef struct {
    BYTE                              bFreqNum;
    BYTE                              abPadding[3];
    T_zWRRC_LteFreqPrioInfo           atLteFreqPrioInfo[WRRC_MAX_LTEFREQ_NUM];
}T_zWRRC_LtePrioInfo;

typedef struct {
    BYTE                       bVersion;
    BYTE                       abPadding[3]; 
    T_zWRRC_ServPrioInfo       tServPrioInfo;
    T_zWRRC_UtraPrioInfo       tUtraFreqPrioInfo;
    T_zWRRC_GsmPrioInfo        tGsmPrioInfo;
    T_zWRRC_LtePrioInfo        tLteFreqPrioInfo;
}T_zWRRC_PRIOINFO;

/*========================================================================
LOGͣZ_WCDMA_RRC_EVENT_FREQQUA_LOG
˵Wʽ£ͬƵ¼ƵϢ
=========================================================================*/
typedef struct {
    BYTE           bMcId;
	BYTE           bEventId;
	SHORT          sFreqQua;
}T_zWRRC_IntraEventFreqQua;

typedef struct {
    BYTE           bEventNum;
    BYTE           abPadding[3];
    T_zWRRC_IntraEventFreqQua  atIntraEventFreqQua[WRRC_MAX_INTRAMEASEVENT]; 
}T_zWRRC_IntraMcEventFreqQua;

typedef struct{
    BYTE                   bAsQuaFlg;
    BYTE                   bFreqQuaInd;          /*ƵǷЧָʾasFreqQua[]Ӧ*/
    BYTE                   abPadding[2];
    WORD                   awDlUarfcn[WRRC_MAX_INTERFREQ_NUM];
    SHORT                  asFreqQua[WRRC_MAX_INTERFREQ_NUM];
    SHORT                  sAsQua;
    SHORT                  sPadding;
}T_zWRRC_EventFreqQua;

typedef struct {
    BYTE                   bMcId;
	BYTE                   bEventId;
	BYTE                   abPadding[2];
	T_zWRRC_EventFreqQua        tFreqQua;
}T_zWRRC_InterEventFreqQua;

typedef struct {
    BYTE           bEventNum;
    BYTE           abPadding[3];
    T_zWRRC_InterEventFreqQua  atInterEventFreqQua[WRRC_MAX_INTERMEASEVENT]; 
}T_zWRRC_InterMcEventFreqQua;

typedef struct {
    BYTE            bMcId;
	BYTE            bEventId;
    BYTE            abPadding[2];
    SHORT           sAsQua;
	SHORT           sPadding;
}T_zWRRC_RatEventAsQua;

typedef struct {
    BYTE             bEventNum;
    BYTE             abPadding[3];
    T_zWRRC_RatEventAsQua     atRatEventAsQua[WRRC_MAX_RATMEASEVENT]; 
}T_zWRRC_RatMcEventFreqQua;

typedef struct {
    BYTE                    bVersion;
    BYTE                    abPadding[3];         
    T_zWRRC_IntraMcEventFreqQua   tIntraEventFreqQua;
    T_zWRRC_InterMcEventFreqQua   tInterEventFreqQua;
    T_zWRRC_RatMcEventFreqQua     tRatEventAsQua;
}T_zWRRC_EVENTFREQ_QUA;

/*========================================================================
LOGͣZ_WCDMA_RRC_CELLRST_LOG
˵Wʽ£СϢ
=========================================================================*/
typedef struct {
    BYTE        bRscp;
    BYTE        bEcNo;
    BYTE        abPadding[2]; 
    SHORT       sSrxlev;
    SHORT       sQqual;
    SHORT       sRvalue;       /*Чֵ0*/
    SHORT       sHvalue;       /*Чֵ0*/ 
}T_zWRRC_CELLVALUE;

typedef struct {
    WORD       wPrimSrc;
    WORD       wPadding;
    T_zWRRC_CELLVALUE    tCellValue;
}T_zWRRC_IntraCellRst;

typedef struct {
    BYTE        bAsNum;          /*0~8, Dch̬1ӦatAsCell[]С*/
    BYTE        bMsNum;          /*0~32*/
    BYTE        bDsNum;          /*0~8*/
    BYTE        bPadding;
    T_zWRRC_IntraCellRst   atAsCell[WRRC_MAX_AS_NUM];
    T_zWRRC_IntraCellRst   atMsCell[WRRC_MAX_MS_NUM];
    T_zWRRC_IntraCellRst   atDsCell[WRRC_MAX_DS_NUM];
}T_zWRRC_IntraCellRstInfo;

typedef struct {
    WORD        wUarfcn;
    WORD        wPrimSrc;
    T_zWRRC_CELLVALUE    tCellValue;
}T_zWRRC_InterCellRst;

typedef struct {
    BYTE                       bInterCellNum;    /*0~32*/
    BYTE                       abPadding[3];
    T_zWRRC_InterCellRst       atInterCell[WRRC_MAX_INTERCELL_NUM];
}T_zWRRC_InterCellRstInfo;

typedef struct{ 
    BYTE       bBsic;
    BYTE       bRssi;        /*0~63*/
    SHORT      sSrxlev;
    SHORT      sRvalue;
    SHORT      sHvalue;
    WORD       wArfcn;       /*λ1ʾ1900Ƶ*/
    WORD       wPadding;
}T_zWRRC_GsmCellRst;

typedef struct {
    BYTE       bGsmNum;        /*0~32*/
    BYTE       abPadding[3];
    T_zWRRC_GsmCellRst        atGsmCell[WRRC_MAX_GSMCELL_NUM];
}T_zWRRC_GsmCellRstInfo;

typedef struct {
    BYTE        bRsrp;
    BYTE        bRsrq;
    WORD        wPci;
    DWORD       dwEarfcn;
    SHORT       sSrxlev;
    SHORT       sSqual;
}T_zWRRC_LteCellRst;

typedef struct {
    BYTE        bLteNum;
    BYTE        abPadding[3];
    T_zWRRC_LteCellRst     atLteCell[WRRC_MAX_LTECELL_NUM];
}T_zWRRC_LteCellRstInfo;

typedef struct {
    BYTE                    bVersion;
    BYTE                    abPadding[3];
    T_zWRRC_IntraCellRstInfo    tIntraCellInfo;
    T_zWRRC_InterCellRstInfo    tInterCellInfo;
    T_zWRRC_GsmCellRstInfo      tGsmCellInfo;
    T_zWRRC_LteCellRstInfo      tLteCellInfo;
}T_zWRRC_CELLRSTINFO;

/*========================================================================
LOGͣZ_WCDMA_RRC_TRAFFIC_REPORT_LOG
˵Wʽ£СϢ
=========================================================================*/
typedef struct{
    BYTE                           bRbId;   /*1-32*/
    BYTE                           bBo;     /*ʱBOֵʵBOֵ.2^bBo*/
    BYTE                           bAvgBo;  /*üڵľֵ ʵBOֵ.2^bAvgBo0ʾЧֵUE޷*/
    BYTE                           bVarBo;  /*üڵķ ʵBOֵ.2^bAvgBo0ʾЧֵUE޷*/
}T_zWRRC_RbBoInfo;

typedef struct{
    BYTE                           bEventId;   /*¼ʱЧ40ʾ4A, 41ʾ4B*/
    BYTE                           bTrchType;  /*¼Ĵŵͣ0ʾDCH,1ʾRACH, 3ʾEDCH*/
    BYTE                           bTrchId;    /*¼ĴŵID1-32*/
    BYTE                           bPadding; 
}T_zWRRC_TvEventRst;

typedef struct {
    BYTE                           bVersion;
    BYTE                           bMeasId;     /*1-32*/
    BYTE                           bRepMode;    /*0ʾ¼,1ʾ*/
    BYTE                           bRbNum;      /*RB0-11*/
    union{
        T_zWRRC_TvEventRst         tEventRst;
        BYTE                       bPrdRptSendNum;  /*ڱѾ͵Ĵʱ0*/
    }uRptCriInfo;
    T_zWRRC_RbBoInfo               atRbBoInfo[Z_MAX_RB_NUM_TRACE];
}T_zWRRC_TRAFFIC_REPORT;

/*========================================================================
LOGͣZ_WCDMA_RLC_DlAmSta_TV_LOG
˵WCDMA RLC DL AM Statistics
=========================================================================*/
typedef struct
{
    BYTE                 bDlAmdLochId;                                /*DL DATA LOCH ID ; ȡֵ0-255 */
    BYTE                 bDlCtrlLochId;                               /*DL Ctrl LOCH ID ; ȡֵ0-255 */
    BYTE                 bDlLochType;                                 /*LOCH ; 0: BCCH ,1: PCCH, 2: CCCH, 3: DCCH, 4: CTCH, 5-DTCH*/
    BYTE                 bPadding;
    WORD                 wVrr;                                        /*Vrr ; ȡֵ0-4095*/
    WORD                 wVrh;                                        /*vrh; ȡֵ0-4095*/
    DWORD                dwRecvPduNum;                                /*ۼƽյPDU(ȷ)*/
    DWORD                dwRecvSduNum;                                /*ۼSDU*/
    DWORD                dwRecvErrPduNum;                             /*ۼƽյȷPDU(ߴ)*/
    DWORD                dwRecvAmdPduNum;                             /*ۼƽյAMD PDU(ȷ)*/
    DWORD                dwRecvCtrlPduNum;                            /*ۼƽյPDU*/
    DWORD                dwNackedPduNum;                              /* Ctrl PDUϱNACK'd AMD PDU*/
}T_zWrlcDlAmSta_Info;

typedef struct
{
    BYTE                        bVersion;
    BYTE                        abPadding[2];
    BYTE                        bDlLogNum;/*дAMʵͳƸ*/
    T_zWrlcDlAmSta_Info         atRlcDlAmInfo[Z_WRLC_MAX_AMNUM];/*AMʵͳϢ*/
}T_zWrlcDlAmSta_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_UlAmSta_Tv_LOG
˵WCDMA RLC UL AM Statistics
=========================================================================*/
typedef struct
{
    BYTE                  bUlAmdLogId;                  /*ݷLoch ID ; ȡֵ0-255*/
    BYTE                  bUlCtrlLogId;                 /*пݷLoch ID; ȡֵ0-255*/
    BYTE                  bUlLogType;                   /*Loch ; 0 :BCCH, 1: PCCH, 2: CCCH, 3: DCCH, 4: CTCH,5: DTCH;MACṩ*/
    BYTE                  bPadding;
    WORD                  wResetNum;                    /*Reset*/
    WORD                  wVts;                         /*vts ȡֵ0-4095*/
    WORD                  wVta;                         /*vta ȡֵ0-4095*/
    WORD                  wVtMs;                        /*vtMsȡֵ0-4095*/
    WORD                  wSendSecRetrNum;              /*شPDU*/
    WORD                  wSendthirdRetrNum;            /*شPDU*/
    WORD                  wSendFourRetrNum;             /*ĴشPDU*/
    WORD                  wSendFiveRetrNum;             /*شPDU*/
    WORD                  wSendsixMoreRetrNum;          /*>=شPDU*/
    WORD                  wPadding;
    DWORD                 dwBoSize;                     /*BOֵBIT*/
    DWORD                 dwSendPduBytes;               /*ۼƷPDU bytes,Ƶĺݵ*/
    DWORD                 dwSendSduBytes;               /*ϲۼƷ͸RLCSDU bytes*/
    DWORD                 dwFstSendDataBytes;           /*AMD PDUs  ״η͵ۼBytes*/
    DWORD                 dwRetrDataBytes;              /*AMD PDU شۼBytes*/
    DWORD                 dwCtrlPduBytes;               /*͵Ctrl PDUۼBytes*/
    DWORD                 dwNakPduNum;                  /*UE Ctrl PDUNACK'd PDUۼƸ*/
}T_zWrlcUlAmSta_Info;

typedef struct
{
    BYTE                        bVersion;
    BYTE                        abPadding[2];
    BYTE                        bUlLogNum;                      /*дAMʵͳƸ*/
    T_zWrlcUlAmSta_Info         atRlcUlAmInfo[Z_WRLC_MAX_AMNUM];/*AMʵͳϢ*/
}T_zWrlcUlAmSta_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_Sta_TV_LOG
˵WCDMA RLC UL/DL states
=========================================================================*/
typedef struct
{
    BYTE                       bLochId;/*UL LOCH ID ȡֵ0- 19 ; DL Loch ID ȡֵ0-18*/
    BYTE                       bStatus;                                         
                               /*0 C UL_NULL_STATE
                                 1 C TM_UL_DATA_TRANSFER_READY
                                 2 C UM_UL_DATA TRANSFER READY
                                 3 C UM_UL_SUSPENDED
                                 4 C AM_UL_DATA_TRANSFER_READY
                                 5 C AM_UL_SUSPENDED
                                 6 C AM_UL_RESET_PENDING*/
    
                              /*0 C DL_NULL_STATE
                                1 C TM DL_DATA_TRANSFER_READY
                                2 C UM DL_DATA TRANSFER READY
                                3 C AM_DL_DATA_TRANSFER_READY     
                                4 C UM_DL_SUSPENDED
                                5 C AM_DL_SUSPENDED
                                6 C AM_DL_RESET_PENDING*/     
    BYTE                       abPadding[2];
}T_zWrlcSta_Info;

typedef struct
{
    BYTE                        bVesion;
    BYTE                        bPadding;
    BYTE                        bDirect;/*0-UL  1-DL*/
    BYTE                        bLogNum;/*ȡֵ1-20*/
    T_zWrlcSta_Info             atSta[Z_WRLC_MAX_LOGNUM];
} T_zWrlcSta_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_UlTm_TV_LOG
˵WCDMA RLC UL TM
=========================================================================*/
typedef struct
{
    BYTE                       bTmLochType;                             /*Loch type ȡֵ2 :CCCH,3:DCCH,5:DTCH;MACṩ */
    BYTE                       bUlLochId;                               /*Loch ID ȡֵ0-18; MACṩ*/
    BYTE                       bTimeDiscVal;                            /*ȡֵ0-10  (õֵ/10)*/
    BYTE                       bSegmFg;                                 /*Ƿֶȡֵ0,1*/
}T_zWrlcUlTm_Info;

typedef struct
{
    BYTE                       bVersion;
    BYTE                       abPadding[2];
    BYTE                       bLogNum;/*LOch  1-8*/
    T_zWrlcUlTm_Info           atUlTmInfo[Z_WRLC_MAX_TM_NUM];
}T_zWrlcUlTm_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_UlUm_TV_LOG
˵WCDMA RLC UL UM
=========================================================================*/
typedef struct
{
    BYTE                   bUmLogType;                            /*LOCH type,ȡֵ3:DCCH,5:DTCH*/
    BYTE                   bUlLogId;                              /*LOCH ID ȡֵ0-18*/
    BYTE                   bTimeDiscVal;                          /*0-10  ͬTM*/
    BYTE                   bLiLength;                             /*0-7bit  1-15bit*/
    DWORD                  dwHfn;                                 /*HFN*/
}T_zWrlcUlUm_Info;

typedef struct
{
    BYTE                bVesrion;
    BYTE                abPadding[2];
    BYTE                bLogNum;                                  /*LOG  1-3*/
    T_zWrlcUlUm_Info    atUlUmInfo[Z_WRLC_MAX_UM_NUM];
}T_zWrlcUlUm_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_DlTm_TV_LOG
˵WCDMA RLC DL TM
=========================================================================*/
typedef struct
{
    BYTE                       bDlLochType;                        /*LOCH type ȡֵ2 :CCCH,3:DCCH,4: CTCH 5:DTCH */
    BYTE                       bDlLochId;                          /*LOCH ID;ȡֵ 0-18*/
    BYTE                       bSegm;                              /*Ƿֶ,ȡֵ0,1*/
    BYTE                       bPadding;
}T_zWrlcDlTm_Info;

typedef struct
{
    BYTE                bVersion;
    BYTE                abPadding[2];
    BYTE                bLogNum;                                   /*LOG  1-8*/
    T_zWrlcDlTm_Info    atDlTmInfo[Z_WRLC_MAX_TM_NUM];
}T_zWrlcDlTm_TV;


/*========================================================================
LOGͣZ_WCDMA_RLC_DlUm_TV_LOG
˵RLC DL UM
=========================================================================*/
typedef struct
{
    BYTE                       bDlLochType;                        /*LOCH type ȡֵ2 :CCCH,3:DCCH,4: CTCH 5:DTCH*/
    BYTE                       bDlLochId;                          /*LOG ID ȡֵ0-18*/
    BYTE                       bLiLength;                          /*LI ȣȡֵ0-7bit  1-15bit*/
    BYTE                       bPadding;
    DWORD                      dwHfn;                              /*HFN*/
}T_zWrlcDlUm_Info;

typedef struct
{
    BYTE                       bversion;
    BYTE                       abPadding[2];
    BYTE                       bLogNum;                            /*LOG  1-3*/
    T_zWrlcDlUm_Info           atDlUmInfo[Z_WRLC_MAX_UM_NUM];
}T_zWrlcDlUm_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_DlAmConfig_TV_LOG
˵WCDMA RLC DL AM Configuration
=========================================================================*/
typedef struct
{
    BYTE                             bDlDataLochId;            /*LOCH ID ,ȡֵ0-20; MACṩ*/
    BYTE                             bDlContLochId;            /*LOCH ID,ȡֵ0-20; MACṩ*/
    BYTE                             bRbId;                    /*RbId ȡֵ0-31*/
    BYTE                             bLochType;                /*LOCH type,ȡֵ3:DCCH,5:DTCH;MACṩ*/
    BYTE                             bLiLength;                /*ȡֵ0-7bit 1-15bit*/
    BYTE                             bSeqDelFg;                /*ȡֵ0-false 1-true*/
    BYTE                             bMissInd;                 /*ȡֵ0-false  1-true*/
    BYTE                             bPadding;
    WORD                             wRcvWindSize;             /*vtwsȡֵ0-4095*/
    WORD                             wTimeStatusPrd;           /*Զʱʱȡֵ100, 200, 300, 400, 500, 750, 1000, 2000*/
    WORD                             wTimerStatusPrh;          /*ʱʱȡֵ 10 to 550 by step of 10, and from 550 to 1000 by step of 50*/
    WORD                             wPadding;
    DWORD                            dwHfn;
}T_zWrlcDlAmConfig_Info;

typedef struct
{
    BYTE                             bVersion;
    BYTE                             abPadding[2];
    BYTE                             bDLAmCfgNum;        /*DL Cfg ȡֵ 1-4*/
    T_zWrlcDlAmConfig_Info           atDlAmCfgInfo[Z_WRLC_MAX_AM_CFGUM];
} T_zWrlcDlAmConfig_TV;


/*========================================================================
LOGͣZ_WCDMA_RLC_UlAmConfig_TV_LOG
˵WCDMA RLC UL AM Configuration
=========================================================================*/
typedef struct
{
    BYTE                             bUlDataLochId;      /*LOCH ID ,ȡֵ0-18; MACṩ*/
    BYTE                             bUlContLochId;      /*LOCH ID,ȡֵ0-18; MACṩ*/
    BYTE                             bRbId;              /*RbId ȡֵ0-31*/
    BYTE                             bLochType;          /*LOCH type,ȡֵ3:DCCH,5:DTCH;MACṩ*/
    BYTE                             bLiLength;          /*ȡֵ0-7bit 1-15bit*/
    BYTE                             bMaxRst;            /*<24*/
    BYTE                             bSduDisMode;        /* ȡֵ0 :TBE 1:MAXDAT,2: No discard*/
    BYTE                             bMaxDat;            /*ȡֵ1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 35, 40*/
    BYTE                             bPollPdu;           /*ȡֵ0, 1, 2, 4, 8, 16, 32, 64, 128*/
    BYTE                             bPollSdu;           /*ȡֵ0, 1, 4, 16, 64*/
    BYTE                             bLastTranPollFg;    /*ȡֵ0,1*/
    BYTE                             bLastRetrasPollFg;  /*ȡֵ0,1*/
    BYTE                             bPollWindSize;      /*ȡֵ0, 50, 60, 70, 80, 85, 90, 95, 99*/
    BYTE                             bMaxMrw;            /*ȡֵ1, 4, 6, 8, 12, 16, 24, 32*/
    WORD                             wTransWindSize;     /*<4095*/
    WORD                             wTimeRst;           /*ȡֵ50, 100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 700, 800, 900, 1000*/
    WORD                             wTimeDsc;           /*ȡֵ0, 100, 250, 500, 750, 1000, 1250, 1500, 1750, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 7500*/
    WORD                             wTimeMrw;           /*ȡֵ50, 60, 70, 80, 90, 100, 120, 140, 160, 180, 200, 300, 400, 500, 700, 900*/
    WORD                             wTimePollPrh;       /*ȡֵfrom 0 to 550 by step of 10 and from 600 to 1000 by step of 50*/
    WORD                             wTimePoll;          /*ȡֵ from 0 to 550 by step 10 and from 600 to 1000 by step of 50*/
    WORD                             wTimePollPrd;       /*ȡֵ0, 100, 200, 300, 400, 500, 750, 1000, 2000*/
    DWORD                            dwHfn;
}T_zWrlcUlAmConfig_Info;

typedef struct
{
    BYTE                             bVersion;
    BYTE                             abPadding[2];
    BYTE                             bULAmCfgNum;        /*DL Cfg ȡֵ 1-4*/
    T_zWrlcUlAmConfig_Info           atUlAmCfgInfo[Z_WRLC_MAX_AM_CFGUM];
} T_zWrlcUlAmConfig_TV;


/*========================================================================
LOGͣZ_WCDMA_RLC_AmPdu_TV_LOG
˵WCDMA RLC AM User/Signaling Plane PDU
=========================================================================*/
typedef struct
{
    BYTE                               bLochId;                        /*PDU LOCH ID ȡֵ0 -18MACṩ*/
    BYTE                               bPduNum;                         /*ÿTTIյPDU*/
    BYTE                               abPadding[2];
    DWORD                              dwPduBits;                         /*PDU bitsС,ɱSIZEΪ-1*/
    DWORD                              dwPdu[Z_WRLC_MAX_DLPDU_NUM]; /*ÿPDUǰĸֽ*/
}T_zWrlcAmPdu_Info;

typedef struct
{
    BYTE                             bVersion;
    BYTE                             bDirect;
    BYTE                             bUserFlag;
    BYTE                             bAmNum;        /*1-4*/
    T_zWrlcAmPdu_Info                atAmPduInfo[Z_WRLC_MAX_DLAM_NUM];
} T_zWrlcAmPdu_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_RbRat_TV_LOG
˵WCDMA radio bearer rates
=========================================================================*/
typedef struct
{
    BYTE                               bRbId;            /*0-31*/
    BYTE                               abPadding[3];
    DWORD                               dwUlRbRate;   /*Bits*/
    DWORD                               dwDlRbRate;   /*Bits*/
}T_zWrlcRbRat_Info;

typedef struct
{
    BYTE                             bVersion;
    BYTE                             abPadding[2];
    BYTE                             bRbNum;     /*1-32*/
    T_zWrlcRbRat_Info                atRbRatInfo[Z_WRLC_RB_NUM];
}T_zWrlcRbRat_TV;

/*========================================================================
LOGͣZ_WCDMA_PDCP_RatRat_TV_LOG
˵WCDMA PDCP Sdus Rates
=========================================================================*/
typedef struct
{
    BYTE                                bRbId;            /*5-31*/
    BYTE                                abPadding[3];
    DWORD                               dwUlPdcpRate;   /*Bits*/
    DWORD                               dwDlPdcpRate;   /*Bits*/
}T_zPdcpRat_Info;

typedef struct
{
    BYTE                             bVersion;
    BYTE                             abPadding[2];
    BYTE                             bRbNum;     /*1-5*/
    T_zPdcpRat_Info                  atPdcpRatInfo[Z_WRLC_MAX_PDCP_RB_NUM];
}T_zPdcpRat_TV;


/*========================================================================
LOGͣZ_WCDMA_RLC_AmCtrlPdu_TV_LOG
˵WCDMA RLC UL/DL AM Control PDU LOG NACK
=========================================================================*/
typedef struct
{
    BYTE                             bVersion;
    BYTE                             bLochId;                  /*ȡֵ0-18MACṩ*/
    BYTE                             bDirect;                  /*0-  1-*/
    BYTE                             bPadding;
    WORD                             wPduBitSize;              /*PDU С*/
    WORD                             wPadding;
    BYTE                             abNackPdu[4];                 /*Ctrl PDUݣ ȡǰĸֽ*/
}T_zWrlcAmCtrlPdu_TV;

/*========================================================================
LOGͣZ_WCDMA_RLC_FlexPduPack_TV_LOG
˵Flexible DL RLC AM PDU log packet
=========================================================================*/
typedef struct
{
    WORD                             wPduSize;            /*16-5000bytes*/
    WORD                             wPadding;
    BYTE                             abData[4];           /*PDU ǰ4bytes*/
}T_zWrlcFlexPdu_Info;

typedef struct
{
    BYTE                              bLochId;              /*LochId, 0-31*/
    BYTE                              bLiLength;            /*0-7bits 1-15bits*/
    BYTE                              bPduLoggedNum;        /*1-16*/
    BYTE                              bPadding;
    T_zWrlcFlexPdu_Info               atFlexPduInfo[Z_WRLC_MAX_DLPDU_NUM];
}T_zWrlcFlexPduPack_Info;

typedef struct
{
    BYTE                             bVersion;
    BYTE                             abPadding[2];
    BYTE                             bLochNum;             /*1-4*/
    T_zWrlcFlexPduPack_Info          atFlexPduPackInfo[Z_WRLC_MAX_RLCLOGGED_NUM];
}T_zWrlcFlexPduPack_TV;

/*========================================================================
LOGͣZ_WCDMA_MAC_UlLgchPara_LOG
˵WCDMA MAC UL logical channel parameters
=========================================================================*/
typedef struct{
    BYTE                                  bLgchId;                                            /*LGCH IDȡֵ0~20*/
    BYTE                                  bLgchType;                                          /*߼ŵ͡0BCCH1PCCH2DTCH3DCCH4CCCH5CTCH6SHCCH*/
    BYTE                                  bRlcMode;                                           /*RLCȡRLCģʽAM0UM:1TM2*/
    BYTE                                  bRbId;                                              /*RB ID.ȡֵ1~33SRB0ãRB32&RB33ڲ壬Բ*/
    BYTE                                  bMLP;                                               /*MAC߼ŵȼȡֵ1~8*/
    BYTE                                  abPadding[3];
}T_zWMAC_UlLgchInfo;

typedef struct{
    DWORD                                 dwHfn;                                              /*RLCȡHFN20bitsʾ*/
    BYTE                                  bTrchId;                                            /*ŵIDȡֵ1~32*/
    BYTE                                  bTrchType;                                          /*ŵ͡0 C DCH1 C RACH*/
    BYTE                                  bLgChNum;                                           /*߼ŵȡֵ0~11(4 SRB + 4 PS RB + 3 CS RB = 11).*/
    BYTE                                  bPadding;
    T_zWMAC_UlLgchInfo                    atUlLgchInfo[Z_MAX_RB_NUM_TRACE];
}T_zWMAC_UlTrchInfo;

typedef struct{
    BYTE                                  bVersion;
    BYTE                                  abPadding[2]; 
    BYTE                                  bTrchNum;   /*дŵȡֵ1~8*/   
    T_zWMAC_UlTrchInfo                    atUlTrchInfo[Z_W_P_MAX_UL_TRCH_NUM_TRACE];
}T_zWMAC_UlLgchPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_DlLgchPara_LOG
˵WCDMA MAC DL logical channel parameters
=========================================================================*/
typedef struct{
    BYTE                                  bLgchId;                                             /*RLC ID߼ŵIDȡֵ0~18*/
    BYTE                                  bLgchType;                                           /*߼ŵ͡ȡֵ0~60BCCH1PCCH2DTCH3DCCH4CCCH5CTCH6SHCCH*/
    BYTE                                  bRlcMode;                                            /*RLCģʽȡֵ0~2AM0UM:1TM2*/
    BYTE                                  bRbId;                                               /*RB ID.ȡֵ0~33SRB0ãRB32&RB33ڲ壬Բ*/
}T_zWMAC_DlLgchInfo;

typedef struct{
    BYTE                                  bTrchId;                                             /*ŵIDȡֵ1~32*/
    BYTE                                  bTrchType;                                           /*ŵ͡ȡֵ0~40DCH1FACH2DSCH3HS-DSCH4PCH*/
    BYTE                                  bLgChNum;                                            /*߼ŵȡֵ1~15.*/
    BYTE                                  bPadding;
    T_zWMAC_DlLgchInfo                    atDlLgchInfo[Z_MAX_LGCH_ID_TRACE];
}T_zWMAC_DlTrchInfo;

typedef struct{
    BYTE                                  bVersion;
    BYTE                                  abPadding[2]; 
    BYTE                                  bTrchNum;                                           /*дŵȡֵ1~8*/
    DWORD                                 dwHfn;                                              /*RLCȡHFN20bitsʾ*/
    T_zWMAC_DlTrchInfo                    atDlTrchInfo[Z_W_P_MAX_DL_TRCH_NUM_TRACE];
}T_zWMAC_DlLgchPara;


/*========================================================================
LOGͣZ_WCDMA_MAC_RachCtrlPara_LOG
˵WCDMA RACH control parameters
=========================================================================*/
typedef struct{
    BYTE                                  bAscId;                                                     /*AscʶΪatAscSetting±*/
    BYTE                                  bPadding;
    WORD                                  wPi;                                                        /*ֶȣ0~25600*/
}T_zWMAC_AscSetting;

typedef struct{
    BYTE                                  bVersion;
    BYTE                                  abPadding[3];
    BYTE                                  bMMax;                                                      /*Դ1~32*/    
    BYTE                                  bNB01Min;                                                   /*NB01Сֵ0~50*/
    BYTE                                  bNB01Max;                                                   /*NB01ֵ0~50*/
    BYTE                                  bAscNum;                                                    /*õASC1~8*/
    T_zWMAC_AscSetting                    atAscSetting[Z_WMAC_MAX_NUM_OF_ASC_TRACE];
}T_zWMAC_RachCtrlPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_UlTfcsPara_LOG
˵WCDMA uplink transport format combination
==========================================================================*/
typedef struct {
    BYTE                                  abTfi[Z_W_P_MAX_UL_TRCH_NUM_TRACE];                         /*Tf ID0~31*/
    BYTE                                  bTfci;                                                      /*Tfci0~63*/
    BYTE                                  abPadding[3];
}T_zWmac_UlTfcInfo;

typedef struct {
    BYTE                                  bTrchId;                                                    /*ŵID1~32*/
    BYTE                                  bTti;                                                       /*TTIȡֵ1,2,3,4Z_W_TTI_10MS:10msZ_W_TTI_20MS:20msZ_W_TTI_40MS:40msZ_W_TTI_80MS:80ms*/
    WORD                                  wPadding;
}T_zWmac_UlTrchTtiInfo;

typedef struct {
    BYTE                                  bVersion;
    BYTE                                  bPadding;
    WORD                                  wTfcNum;                                                    /*Tfc1~64*/
    T_zWmac_UlTfcInfo                     atTfc[Z_W_P_MAX_UL_TFC_NUM_TRACE];
    BYTE                                  abPadding[3];
    BYTE                                  bTrchNum;                                                   /*дŵȡֵ1~8*/
    T_zWmac_UlTrchTtiInfo                 atUlTrchTtiInfo[Z_W_P_MAX_UL_TRCH_NUM_TRACE];
}T_zWmac_UlTfcsPara;


/*========================================================================
LOGͣZ_WCDMA_MAC_DynamicUpaPduPara_LOG
˵EUL combined L1/MAC log packet
==========================================================================*/
typedef struct {
    BYTE                                  bSiTrigType;                                                /*0 C No SI present; 1 C SI present, triggered by event/timer; 2 C SI present, triggered by padding; 3 C Reserved*/
    BYTE                                  bHappyBit;                                                  /*0 = unhappy, 1 = happy*/
    BYTE                                  bAgVal;                                                     /*0   ~ 31*/
    BYTE                                  bAgScope;                                                   /*0 C All ;1 C per-HARQ*/
    BYTE                                  bRetransNum;                                                /*0   ~ 15*/
    BYTE                                  bSgIdx;                                                     /*0   ~ 37, 38-ZERO_GRANT, 0x3F-Ȩ*/
    BYTE                                  bLupr;                                                      /*SGȡֵ0   ~ 37*/
    BYTE                                  bEtfci;                                                     /*0   ~ 127*/
}T_zWmac_UpaPduGrantPara;

typedef struct {
    BYTE                                  bVersion;
    BYTE                                  abPadding[2];
    BYTE                                  bSampleNum;                                                 /*Ͷݲȡֵ0~50*/
    T_zWmac_UpaPduGrantPara               atUpaPduGrantPara[WMAC_UPA_PDU_SAMPLE_MAX_NUM_LOG];
    
    BYTE                                  bEdchTTI;                                                   /*EDCH TTI.ȡֵ1~2Z_W_TTI_2MS:2ms tti, Z_W_TTI_10MS:10ms tti*/
    BYTE                                  bEtfciTableIndex;                                           /*Etfci0~3UE16QAMģʽʱӦE-TFCI table index + 2*/
    WORD                                  wPadding;
}T_zWmac_DynamicUpaPduPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_StaticsUpaPduPara_LOG
˵EUL L1 MAC statistics log packet 
ʱ:a.200msϱһ;b.
==========================================================================*/
typedef struct {
    BYTE                                  bVersion;
    BYTE                                  bEdchTTI;                                                   /*EDCH TTI.ȡֵ1~2Z_W_TTI_2MS:2ms tti, Z_W_TTI_10MS:10ms tti*/
    BYTE                                  bEtfciTableIndex;                                           /*Etfci0~3UE16QAMģʽʱӦE-TFCI table index + 2*/
    BYTE                                  bFrameNum;                                                  /*֡0   ~ 100*/
    
    BYTE                                  bSrvRgUpCmdNum;                                             /*SRV RG up0   ~ 100*/
    BYTE                                  bSrvRgDownCmdNum;                                           /*SRV RG down0   ~ 100*/
    BYTE                                  bSrvRgHoldCmdNum;                                           /*SRV RG holde0   ~ 100*/
    BYTE                                  bNonSrvRgDownCmdNum;                                        /*non SRV RG down0   ~ 100*/
    
    BYTE                                  bNonSrvRgHoldCmdNum;                                        /*non SRV RG holde0   ~ 100*/
    BYTE                                  bAgNum;                                                     /*AG0   ~ 100*/
    WORD                                  wAgSum;                                                     /*AGֵ֮ͣ(0   ~ 31)*100 */
    
    WORD                                  wSg;                                                        /*SGֵ֮ͣ(0   ~ 37)*100 */
    WORD                                  wReTransRatio;                                              /*شʣ0~10000ʾ0~100.00%,ȷС2λ*/
    
    BYTE                                  bNewTxNum;                                                  /*°, 0   ~ 100*/
    BYTE                                  bRetransTxNum;                                              /*ش, 0   ~ 100*/
    BYTE                                  bDtxNum;                                                    /*DTX, 0   ~ 100*/
    BYTE                                  bRstNum;                                                    /*t1 reset, 0   ~ 100*/
    WORD                                  wEtfciSum;                                                  /*ETFCI֮͡ȡֵ127*100 */
    WORD                                  wPadding;
    DWORD                                 dwTotalBitsNum;                                             /*divided 64.ش´ȡֵΧ(0~22996)*100/64  */
    DWORD                                 dwSchBitsNum;                                               /*divided 64ȡֵΧ(0~22996)*100/64  */
    DWORD                                 dwNonSchBitsNum;                                            /*ǵdivided 64ȡֵΧ(0~22996)*100/64  */
    DWORD                                 dwNonSchBufSts;                                             /*ʣdivided 64.Ҫ´*/
    BYTE                                  bPmax;                                                      /*ʣҪָʽT_zW_P_pc_flot_dataת*/
    BYTE                                  bSiNum;                                                     /*SI´0   ~ 100*/
    BYTE                                  bHappyNum;                                                  /*´شʱHAPPY0   ~ 100*/
    BYTE                                  bPadding;
}T_zWmac_StaticsUpaPduPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_MaceCfgPara_LOG
˵MAC-e/es Configuration log packet
ʱ:û䣬򴥷
==========================================================================*/
typedef struct {
    BYTE                                  bDdi;                                                       /*DDI0~62*/
    BYTE                                  bPadding;
    WORD                                  wPduSize;                                                   /*pdu size, 10~5000*/
}T_zWmac_UpaLgchDdiInfo;

typedef struct {
    BYTE                                  bRbId;                                                      /*rb id, ȡֵ0~3232Ϊ*/
    BYTE                                  bLgchId;                                                    /*߼ŵID1~15*/
    BYTE                                  bMLP;                                                       /*߼ŵȼ1~8*/
    BYTE                                  bLgchType;                                                  /*δ֣ĬΪDTCH/DCCH*/
    BYTE                                  bRlcMode;                                                   /*RLCȡ*/
    BYTE                                  bIncSiFlg;                                                  /*߼ŵSIǡ0-δ1-*/
    BYTE                                  bPadding;
    BYTE                                  bPduSizeNum;                                                /*DDI0~32*/
    T_zWmac_UpaLgchDdiInfo                atUpaLgchDdiInfo[WMAC_UPA_MAC_D_FLOW_DDI_MAX_NUM_LOG];
}T_zWmac_MacdFlowLgchPara;

typedef struct {
    BYTE                                  bMacdFlowId;                                                /*MAC-D FLOW IDȡֵ0~7*/
    BYTE                                  bPowerOff;                                                  /*Mac-d flowĹƫƣ0~6*/
    BYTE                                  bMaxRetranNum;                                              /*mac-d flowش0~15*/
    BYTE                                  bMuxListBitmap;                                             /*MAC-D FLOWбBit 0 (LSB)ʾmac-d flow 0,Bit 1 (LSB)ʾmac-d flow1,Դ*/
    BYTE                                  bSchType;                                                   /*mac-d flowĵͣ0~10ȣ1ǵ*/
    
    BYTE                                  bLgchNum;                                                   /*mac-d flow߼ŵȡֵ1~15*/
    WORD                                  wPadding;
    T_zWmac_MacdFlowLgchPara              atMacdFlowLgchInfo[Z_MAX_LGCH_ID_TRACE];
    
    WORD                                  wNonSchGrant;                                               /*ǵȨֵbit1~19982ֻbSchTypeΪ1ʱЧ*/
    BYTE                                  bNonSchHarqBitmap;                                          /*ǵHARQ BitmapSIZE 8.Bit 0 (LSB)ʾHarq process0,Bit 1 (LSB)ʾHarq process1,Դ*/
    BYTE                                  bPadding;
}T_zWmac_MacdFlowPara;

typedef struct {
    BYTE                                  bVersion;    
    BYTE                                  bEdchTTI;                                                   /*EDCH TTI.ȡֵ1~2Z_W_TTI_2MS:2ms tti, Z_W_TTI_10MS:10ms tti*/
    BYTE                                  bEtfciTableIndex;                                           /*Etfci0~3UE16QAMģʽʱӦE-TFCI table index + 2*/
    BYTE                                  bEMacdFlowNum;                                             /*mac-d flowĸ1~8*/
    WORD                                  wHappyBitDelayCondition;                                    /*Happy Bitӳʱ.ȡֵΧ2~1000ȡֵ2ʾms2Դơms2, ms10, ms20, ms50, ms100, ms200, ms500, ms1000*/
    WORD                                  wPadding;
    T_zWmac_MacdFlowPara                  atMacdFlowPara[Z_WMAC_MAX_EMAC_D_FLOW_NUM_TRACE];
    
    WORD                                  wTsing;                                                     /*T_SINGʱʱȡֵ2~1000,2ʾms2,0ʾЧms2, ms4, ms10, ms20, ms50, ms100, ms200, ms500, ms1000*/
    WORD                                  wTsig;                                                      /*T_SIGʱʱȡֵ2~1000,2ʾms2,0ʾЧms2, ms4, ms10, ms20, ms50, ms100, ms200, ms500, ms1000*/
    BYTE                                  bMinEtfcSet;                                                /*СE-TFCӼ0~127*/
    BYTE                                  bSchHarqBitmap;                                             /*HarqBITMAPSIZE 8,Bit 0 (LSB)ʾHarq process0,Bit 1 (LSB)ʾHarq process1,Դ*/
    BYTE                                  bSiPowerOff;                                                /*control_only SIʱĹƫƣ0~6*/
    BYTE                                  bPadding;
}T_zWmac_MaceCfgPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_MaceHeaderPara_LOG
˵MAC-e/es header log packet
ʱ:a.100msϱһΣb.䣬ϱһ
==========================================================================*/
typedef struct {
    BYTE                                  bDdi;                                                       /*0~62*/
    BYTE                                  bTsn;                                                       /*0~63*/
    BYTE                                  bN;                                                         /*0~63*/
    BYTE                                  bPadding;
}T_zWmac_MacesHeaderPara;

typedef struct {
    BYTE                                  bHlid;                                                      /*ȼ߼ŵID, 0~15*/
    BYTE                                  bHlbs;                                                      /*ȼ߼buf״̬, 0~15*/
    BYTE                                  bTebs;                                                      /*E-DCH buf״̬, 0~31*/
    BYTE                                  bSiTrigType;                                                /*SIǷbuffer status or periodic trigger0-ǣ1-*/
    BYTE                                  bSiPadFlg;                                                  /*SIǷǶռ롣0-ǣ1-*/
    BYTE                                  bUph;                                                       /*0~31*/
    WORD                                  wPadding;
}T_zWmac_SiPara;

typedef struct {
    BYTE                                  bTxType;                                                    /*0 C New transmission, 1 C Retransmission, 2 C No transmission*/
    BYTE                                  bHappyBit;                                                  /*0 -unhappy ; 1- happy*/
    BYTE                                  bEtfci;                                                     /*0~127*/
    BYTE                                  bMacesHeaderNum;                                            /*0~50*/
    T_zWmac_MacesHeaderPara               atMacesHeaderPara[WMAC_UPA_MAC_E_HEADER_DDI_MAX_NUM_LOG];
    BYTE                                  bIncSiFlg;                                                  /*0 C SI not present; 1 C SI present*/
    BYTE                                  abPadding[3];
    T_zWmac_SiPara                        tSiPara;
}T_zWmac_MaceHeaderInfo;

typedef struct {
    BYTE                                  bVersion;
    BYTE                                  abPadding[2];
    BYTE                                  bSampleNum;                                                 /*Ͷݲȡֵ0~50*/
    T_zWmac_MaceHeaderInfo                atMaceHeaderInfo[WMAC_UPA_PDU_SAMPLE_MAX_NUM_LOG];
    BYTE                                  bEdchTTI;                                                   /*EDCH TTI.ȡֵ1~2Z_W_TTI_2MS:2ms tti, Z_W_TTI_10MS:10ms tti*/
    BYTE                                  bEtfciTableIndex;                                           /*Etfci0~3UE16QAMģʽʱӦE-TFCI table index + 2*/
    WORD                                  wPadding;
}T_zWmac_MaceHeaderPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_MacHsCfgPara_LOG
˵MAC HS configuration log packet
ʱ:ûϱ
==========================================================================*/
typedef struct {
    BYTE                                  bSid;                                                       /*SID:0 to 7*/
    BYTE                                  bPadding;
    WORD                                  wPduSize;                                                   /*PDU SIZE:1 to 5000*/
}T_zWmac_DpaSidnfo;

typedef struct {
    BYTE                                  bLgchId;                                                    /*߼ŵID1~15*/
    BYTE                                  bLgchType;                                                  /*߼ŵͣ0~60BCCH1PCCH2DTCH3DCCH4CCCH5CTCH6SHCCH*/
    BYTE                                  bRlcMode;                                                   /*RLCģʽ0~20AMģʽ1UMʵ壬2TMģʽ*/
    BYTE                                  bPadding;
}T_zWmac_DpaLgchInfo;

typedef struct {
    BYTE                                  bQueueID;                                                   /*ID0~7*/
    BYTE                                  bPadding;
    WORD                                  wMacHsWindowSize;                                           /*ڴСȡֵ4~1284,6,8,12,16,24,32, 64,12864,128Ehs*/
    BYTE                                  abPadding[3];
    BYTE                                  bSidNum;                                                    /*SIDȡֵ1~8*/

    T_zWmac_DpaSidnfo                     atSidToPduSize[Z_WMAC_MAX_SID_NUM_TRACE];
    WORD                                  wT1;                                                        /*reorderingReleaseTimerT1ʱms10~4000Ϊδ*/
    WORD                                  wTreset;                                                    /*Tresetʱȣ1,2,3,40Ϊδ*/
    BYTE                                  abPadding1[3];
    BYTE                                  bLgchNum;                                                   /*жӦLgch1~15*/
    T_zWmac_DpaLgchInfo                   atDpaLgchInfo[Z_MAX_LGCH_ID_TRACE];
}T_zWmac_DpaQueInfo;

typedef struct {
    BYTE                                  bVersion;
    BYTE                                  abPadding[2];
    BYTE                                  bQueueNum;                                                  /*Queue1~8*/
    T_zWmac_DpaQueInfo                    atDpaQueInfo[Z_WMAC_MAX_DL_QUEUE_NUM_TRACE];

    BYTE                                  bMacHsRst;                                                  /*λǡ0-FALSE,1-TRUE*/
    BYTE                                  bMacEntityType;                                             /*ACʵͣ0~10ʾΪhsʵ壬1ʾΪehsʵ*/
    BYTE                                  abPadding1[2];
}T_zWmac_MacHsCfgPara;


/*========================================================================
LOGͣZ_WCDMA_MAC_DpaReorderingPara_LOG
˵MAC HS status log packet
ʱ:״̬£ϱ
==========================================================================*/
typedef struct {
    BYTE                                  bQueueID;                                                   /*ID0~7*/
    BYTE                                  abPadding[3];
    WORD                                  wRcvTsn;                                                    /*0 ~ 63*/
    WORD                                  wNextExpectedTsn;                                           /*0 ~ 63*/
    WORD                                  wRcvWinUpperEdge;                                           /*0 ~ 63*/
    WORD                                  wT1Tsn;                                                     /*0 ~ 63.0xffΪЧֵ*/
}T_zWmac_DpaQueReordering;

typedef struct {
    BYTE                                  bVersion;
    BYTE                                  abPadding[2];
    BYTE                                  bSampleNum;                                                 /*Ͷݲȡֵ0~50*/
    T_zWmac_DpaQueReordering              atDpaQueReodering[Z_WMAC_MAX_DL_QUEUE_NUM_TRACE];
}T_zWmac_DpaReorderingPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_MacHsRstPara_LOG
˵MAC HS reset log packet
==========================================================================*/
typedef struct {
    BYTE                                  bVersion;
    BYTE                                  abPadding[2];
    BYTE                                  bLgchNum;                                                   /*1 ~ 32*/
    BYTE                                  abLgchId[WMAC_DPA_RST_MAX_LGCH_NUM_LOG];                    /*1 ~ 32*/
}T_zWmac_MacHsRstPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_DpaPduPara_LOG
˵MAC-ehs reassembly log packet
ʱ:10ms һ
==========================================================================*/
typedef struct {
    WORD                                  wRcvTsn;                                                    /*0 ~ 63*/
    WORD                                  wNextExpectedTsn;                                           /*0 ~ 63*/
    WORD                                  wRcvWinUpperEdge;                                           /*0 ~ 63*/
    WORD                                  wT1Tsn;                                                     /*0 ~ 63.0xffΪЧֵ*/

    BYTE                                  bQueIdAndLgchId;                                            /*Que ID߼ŵIDBit 2:0 C Queue ID ;Bit 6:3 C LC ID;Bit 7 C Reserved */
    BYTE                                  bPadding;
    WORD                                  wSiL;                                                       /*SiLֵBit 1:0-SI; Bit 12:2 -L; Bit 15:13 C Reserved*/
}T_zWmac_DpaStsPara;

typedef struct {
    BYTE                                  bVersion;
    BYTE                                  bPadding;
    BYTE                                  bMacVersion;                                                /*Bit 3:0-V;  Bit 4: 0 CMAC-hs,1 C MAC-ehs ; Bit 7:5 C Reserved*/                                                  
    BYTE                                  bQueueNum;
    T_zWmac_DpaStsPara                    atDpaStsPara[Z_WMAC_MAX_DL_QUEUE_NUM_TRACE];
}T_zWmac_DpaPduPara;

/*========================================================================
LOGͣZ_WCDMA_MAC_Lgch_TV_LOG
˵ͳ߼ŵҵ
ʱ:1sϱһ
==========================================================================*/
typedef struct
{
    BYTE                                  bLgchId;                                                    /*1-15*/
    BYTE                                  abPadding[3];
    DWORD                                 dwLgchRate;                                                 /*1sڸ߼ŵҵλbit*/
}T_zWmac_LgchTvInfo;

typedef struct
{
    BYTE                                  bVersion;
    BYTE                                  bUlLgchNum;                                                 /*0-15*/
    BYTE                                  bDlLgchNum;                                                 /*0-15*/
    BYTE                                  bPadding;
    T_zWmac_LgchTvInfo                    atUlLgchTvInfo[Z_MAX_LGCH_ID_TRACE];                              /*߼ŵҵ*/
    T_zWmac_LgchTvInfo                    atDlLgchTvInfo[Z_MAX_LGCH_ID_TRACE];                              /*߼ŵҵ*/
}T_zWmac_LgchTv;

typedef struct {
    BYTE                                         bStackIndex;
    BYTE                                         abPadding[3];
}T_zAti_RTUeInfo_Req;


typedef struct {
    BITS                      bMCC1     :4;
    BITS                      bMCC2     :4;    
    BITS                      bMCC3     :4;
    BITS                      bMNC3     :4;    
    BITS                      bMNC1     :4;
    BITS                      bMNC2     :4;
}T_zEM_PlmnId;

/* Nas Ϣ */
typedef struct {
  WORD                        wDrx;     //DRXڣλms
  WORD                        wTac;  
  WORD                        wT3412; //T3412ʱȣλs
  WORD                        wPadding;
  T_zEM_PlmnId                tPlmnId;    /*ǰפplmnid*/  
  BYTE                        bPadding;
}T_zEm_Lte_NasInfo;

/* QoS Ϣ */
typedef struct {
    BYTE                        bConnId;//
    BYTE                        bTrafficClass; //Ӧҵȼ
    BYTE                        abPadding[2];
    DWORD                       dwQosMaxBitRateUp;
    DWORD                       dwQosMaxBitRateDown;
}T_zEm_QosInfo;
/* QoS Ϣ */
typedef struct {
    BYTE                        bQosInfoNum; //
    BYTE                        abPadding[3];
    T_zEm_QosInfo               atQosInfo[Z_EM_MAX_QOS_NUM]; 
}T_zEm_NasQos;

/* СϢ */
typedef struct {
    DWORD                        dwEarfcn;
    WORD                        wPci;
	DWORD                       dwCellId;
    DWORD                       dwCsgId;
    //С
    BYTE                        bDlBandWidth;  //д
    BYTE                        bSubframeAssignment; //֡,SIB1 TDD-CONFIG
    BYTE                        bSpecialSubframePatterns; //֡,,SIB1 TDD-CONFIG
    BYTE                        bTransmissionMode; // ģʽ,̬ԴõAntenalInfo,TM1~TM8
    BYTE                        bRlease; //С汾
    BYTE                        bBand;
    DWORD                        dwUlFddArfcn;   /*FDD-LTEΪƵ*/  
}T_zEm_Lte_SCellInfo;

typedef struct {
    T_zEm_Lte_SCellInfo         tScellInfo;
    T_zEm_NasQos                 tNasQos;
    T_zEm_Lte_NasInfo           tNasInfo;
}T_zEm_Lte_SCellPara;

/*Init_Meas Ϣ*/
typedef struct {
    SHORT                       sServingFreqPrior; //Ƶȼ
    BYTE                        bSintrasearchP;     //ͬƵֵ
    BYTE                        bSintrasearchQ;     //ͬƵֵ
    BYTE                        bSnonintrasearchP;  //ȼƵʽֵ
    BYTE                        bSnonintrasearchQ;  //ȼƵʽֵ
    BYTE                        abPadding[2];
}T_zEM_Lte_InitMeasInfo;

/*Init_Resel Ϣ*/
typedef struct {
    SHORT                       sQhyst; //СRֵ
    BYTE                        bThresholdServinglowP;
    BYTE                        bThresholdServinglowQ;
}T_zEM_Lte_InitReselInfo;

/*LTE IDLE̬²Ϣ*/
typedef struct {
    T_zEM_Lte_InitMeasInfo  tInitMeasInfo;
    T_zEM_Lte_InitReselInfo tInitReselInfo;  
}T_zEM_Lte_IdleMeasInfo;


typedef struct {
    BYTE   bHyst;
    BYTE   bThreshHold; 
    WORD   wTTT; 
}T_zEM_Lte_EventA1Info,T_zEM_Lte_EventA2Info;

typedef struct {
    SHORT  sOff;
    SHORT  sOcs;
    SHORT  sOfs;
    BYTE   bHyst; 
    BYTE   bPadding;
    WORD   wTTT; 
}T_zEM_Lte_EventA3Info;

typedef struct {
    BYTE  bThreshHold; 
    BYTE  bHyst; 
    WORD  wTTT; 
}T_zEM_Lte_EventA4Info;

typedef struct {
    BYTE  bScellThreshHold; 
    BYTE  bNcellThreshHold;
    BYTE  bHyst; 
    BYTE  abPadding[3];
    WORD  wTTT; 
}T_zEM_Lte_EventA5Info,T_zEM_Lte_EventB2Info;

typedef struct {
    SHORT sOff;
    SHORT sOcs;
    BYTE  bHyst; 
    BYTE  bPadding;
    WORD  wTTT; 
}T_zEM_Lte_EventA6Info;

typedef struct {
    BYTE  bThreshHold; 
    BYTE  bHyst;
    WORD  wTTT; 
}T_zEM_Lte_EventB1Info;

typedef struct {
    BYTE  bReportPurpose; // 0 - reportstrongestcell ; 1 - reportstrongestcellForSon ; 2 - Cgi
    BYTE  abPadding[3];
}T_zEM_Lte_PeriodInfo;

typedef struct {
    BYTE  bReportType;//,0 - ڱ棬1~6ӦA1~A678ֱΪB1B2
    BYTE  bMeasId;
    BYTE  abPadding[2];
    DWORD  dwArfcn;
    union{
        T_zEM_Lte_PeriodInfo    tPeriod;
        T_zEM_Lte_EventA1Info   tA1;
        T_zEM_Lte_EventA2Info   tA2;
        T_zEM_Lte_EventA3Info   tA3;
        T_zEM_Lte_EventA4Info   tA4;
        T_zEM_Lte_EventA5Info   tA5;
        T_zEM_Lte_EventA6Info   tA6;
        T_zEM_Lte_EventB1Info   tB1;
        T_zEM_Lte_EventB2Info   tB2;
    }uEventInfo;
}T_zEm_Lte_MeasEventInfo;


/*LTE CONNECT̬²Ϣ*/
typedef struct {
    BYTE  bMeasIdNum;
    BYTE  bSmeasure;
    BYTE  bGapIndicator;
    BYTE  bRankInd;/*˫ָʾȡֵ1ʾ2ʾ˫0ʾЧ*/
    T_zEm_Lte_MeasEventInfo  tMeasEventInfo[32];
}T_zEM_Lte_ConnMeasInfo;

/*LTEϢ*/
typedef struct {
    BYTE                     bIdleFlg; //̬Ϣλ
    BYTE                     bConnFlg; //Ϣλ
    WORD                     wCrnti;
    T_zEM_Lte_IdleMeasInfo   tIdleMeasInfo;
    T_zEM_Lte_ConnMeasInfo   tConnMeasInfo;
}T_zEM_Lte_MeasThreshInfo;


/* ͬƵṹ*/
typedef struct {
  DWORD                       dwEarfcn;
  BYTE                     abPadding[2];
  WORD                       wPci;
  BYTE                       bRsrp;//Rsrp
  BYTE                       bRsrq;
  BYTE                       bDetectFlg;
  CHAR                       cCellOffset;
  DWORD                      dwTreselection; //ͬƵѡʱ
}T_zEm_Lte_IntraCellInfo;

/* Ƶṹ*/
typedef struct {
  DWORD                       dwEarfcn;
  BYTE                     abPadding[2];
  WORD                       wPci;
  BYTE                       bRsrp;
  BYTE                       bRsrq;
  BYTE                       bDetectFlg;
  CHAR                       cFreqOffset;
  SHORT                      sRxlevMin;
  CHAR                       cCellOffset;
  BYTE                       bPriority;
  BYTE                       bThreshHighP;
  BYTE                       bThreshLowP;
  BYTE                       bThreshHighQ;
  BYTE                       bThreshLowQ;
  DWORD                      dwTreselection; //ѡʱ
}T_zEm_Lte_InterCellInfo;

/* GSMṹ*/
typedef struct {
  WORD                        wArfcn;
  BYTE                        bBSIC;
  BYTE                        bBand;
  BYTE                        bRssi;
  //²ڿ̬Ч
  BYTE                        bPriority;
  BYTE                        bThreshHigh;
  BYTE                        bThreshLow;
  BYTE                        bRxlevMin;
  BYTE                        abPadding[3];
  DWORD                       dwTreselection; //ѡʱ
}T_zEm_Lte_NGCellInfo;

/* TDṹ*/
typedef struct {
  WORD                        wArfcn;
  WORD                        wPci;
  BYTE                        bRscp;
  //²ڿ̬Ч
  BYTE                        bPriority;
  BYTE                        bThreshHigh;
  BYTE                        bThreshLow;
  SHORT                       sRxlevMin;
  WORD                        wPadding;
  DWORD                       dwTreselection; //ѡʱ
}T_zEm_Lte_NTCellInfo;

/* Wṹ*/
typedef struct {
  WORD                        wArfcn;
  WORD                        wPci;
  BYTE                        bRscp;
  BYTE                        bEcno;
  BYTE                        bBand;
  //²ڿ̬Ч
  BYTE                        bPriority;
  BYTE                        bThreshHighP;
  BYTE                        bThreshLowP;
  BYTE                        bThreshHighQ;
  BYTE                        bThreshLowQ;

  BYTE                        abPadding[2];
  SHORT                       sRxlevMin;
  DWORD                       dwTreselection; //ѡʱ
}T_zEm_Lte_NWCellInfo;

/* Ϣ*/
typedef struct {
  BYTE                         bIntraCellNum;
  BYTE                         bInterCellNum;
  BYTE                         bGCellNum;
  BYTE                         bTCellNum;
  BYTE                         bWCellNum;
  BYTE                         abPadding[3];
  T_zEm_Lte_IntraCellInfo      tIntraCell[Z_EM_MAX_LTE_NCELL_NUM];//Rsrp
  T_zEm_Lte_InterCellInfo      tInterCell[Z_EM_MAX_LTE_NCELL_NUM];//Rsrp
  T_zEm_Lte_NGCellInfo         tNGCell[Z_EM_MAX_GSM_NCELL_NUM];//RSSI
  T_zEm_Lte_NTCellInfo         tNTCell[Z_EM_MAX_TD_NCELL_NUM];//RSCP
  T_zEm_Lte_NWCellInfo         tNWCell[Z_EM_MAX_W_NCELL_NUM];//򣬵RSCPʱRSCP򣻷򣬰Ec/No򡣲pathloss
}T_zEm_Lte_NCellInfo;

typedef struct {
  BYTE                        bScellRsrp; //С
  BYTE                        bScellRsrq; 
  BYTE                        abPadding[2];
  T_zEM_Lte_MeasThreshInfo    tMeasThreshInfo;
  T_zEm_Lte_NCellInfo         tNCellInfo; 
}T_zEm_Lte_SCellMeasInfo;

typedef struct{
    BYTE                                    bScellFlg;  //SCELLСϢЧʶ0ʾСϢЧ1,Ч
    BYTE                                    bCellIndex; //ò,scellID
    BYTE                                    bRsrp;
    BYTE                                    bRsrq;
    DWORD                                    dwArfcn;
    WORD                                    wPci;
    BYTE                                     abPadding[2]; 
}T_zEm_Lte_ScellGroupInfo;

typedef struct{
    T_zEm_Lte_ScellGroupInfo                tScellGroupInfo[Z_EM_LTE_SCELL_NUM];
}T_zEm_Lte_SCellGroup;

typedef struct {
  T_zEm_Lte_SCellPara         tScellPara;
  T_zEm_Lte_SCellGroup        tSCellGroup;
  T_zEm_Lte_SCellMeasInfo     tMeasInfo;
}T_zEm_Lte_EmInfo_Ind;

/* Nas Ϣ */
typedef struct {
    BYTE                          bDrx;
    BYTE                          bRac;
    WORD                          wLac;  
    T_zEM_PlmnId                  tPlmn;  
    BYTE                          bPadding;
    BYTE                          bAtt;
    BYTE                          bNmo; 
    BYTE                          abPadding[2];
    WORD                          wT3212;
    WORD                          wT3312;  
}T_zEm_Gsm_NasInfo,T_zEm_Td_NasInfo,T_zEm_W_NasInfo;

/* СϢ */
typedef struct {
    BYTE                        bCellVersion;
    BYTE                        bCellParaId;
	BYTE                        bBand;
    BYTE                        bPadding;
    DWORD                       dwCellId;
    WORD                        wUarfcn;
    WORD                        wWorkUarfcn;
}T_zEm_Td_SCellInfo;

typedef struct {
    T_zEm_Td_SCellInfo         tScellInfo;
    T_zEm_NasQos               tNasQos;
    T_zEm_Td_NasInfo           tNasInfo;
}T_zEm_Td_SCellPara;

typedef struct {
    BYTE                        bPrioFlg;    //
    BYTE                        bSintra;//0~91
    BYTE                        bSinter;//0~91
    BYTE                        bSearchHcs;//0~91
    BYTE                        bSearchRat;//0~91
    BYTE                        bSearchHcsRat;//0~91
    BYTE                        bHcsLimtSearchRat;//0~91
    BYTE                        bPriority;//0~7
    BYTE                        bSPrioSearch1;//0~62
    BYTE                        bSPrioSearch2;//0
    BYTE                        abPadding[2];
}T_zEM_Td_InitMeasInfo;

typedef struct {
    BYTE                       bQhyst;//0~40
    BYTE                       bQhcs;
    BYTE                       bTresel;//0~31
    BYTE                       bPrioThreshFlg;  //ָʾȵȼbThreshServLowbThreshServLow2Ƿ
    BYTE                       bThreshServLow;//0~62
    BYTE                       bThreshServLow2;//0
    BYTE                       abPadding[2];
}T_zEM_Td_InitReselInfo;

/*TD IDLE̬²Ϣ*/
typedef struct {
    T_zEM_Td_InitMeasInfo   tInitMeasInfo;
    T_zEM_Td_InitReselInfo  tInitReselInfo;  
}T_zEM_Td_IdleMeasInfo;

typedef struct {
    BYTE                       bHyst;//0~15ֵҪ2
    BYTE                       bTrigTime;//0, 10, 20, 40, 60, 80, 100, 120, 160, 200, 240, 320, 640, 1280, 2560, 5000
    BYTE                       bBestCellId;
    BYTE                       bPadding;
}T_zEM_Td_Event1GInfo;

typedef struct {
    BYTE                       bHyst;//0~29ֵҪ2
    BYTE                       bTrigTime;
    BYTE                       abPadding[2];
}T_zEM_Td_Event2AInfo;

typedef struct {
    SHORT                       sThreshOwn;//-115~0
    SHORT                       sThreshOther;//-115~0
    BYTE                       bHyst;//0~15,ֵҪ4
    BYTE                       bTrigTime;
    BYTE                       abPadding[2];
}T_zEM_Td_Event3AInfo;

typedef struct {
    BYTE                       bMcId;
    BYTE                       bEventType;//0:1G,  1:2A,  2:3A
    BYTE                       abPadding[2];
    union{
        T_zEM_Td_Event1GInfo   t1G;
        T_zEM_Td_Event2AInfo   t2A;
        T_zEM_Td_Event3AInfo   t3A;
    }uEventInfo;
}T_zEm_Td_MeasEventInfo;

/*TD CONNECT̬²Ϣ*/
typedef struct {
    BYTE                       bEventNum;
    BYTE                       abPadding[3];
    T_zEm_Td_MeasEventInfo     atMeasEventInfo[Z_EM_MAX_TD_EVENT_NUM];
}T_zEM_Td_ConnMeasInfo;

/*TD Ϣ*/
typedef struct {
    BYTE                     bIdleFlg; //̬Ϣλ
    BYTE                     bConnFlg; //Ϣλ
    BYTE                     abPadding[2];
    T_zEM_Td_IdleMeasInfo    tIdleMeasInfo;
    T_zEM_Td_ConnMeasInfo    tConnMeasInfo;
}T_zEM_Td_MeasThreshInfo;

typedef struct {
    BYTE                       bPriority;
    BYTE                       bThreshHigh;//0~62
    BYTE                       bThreshLow;//0~62
    BYTE                       bPadding;
    SHORT                       sQrxlevmin;//-119--  -25
    SHORT                       sPadding;
}T_zEm_Td_NCellPrioPara;

typedef struct {
    SHORT                       sQOff1SN;  //-50---50
    SHORT                       sQRxlevMin;//-115--  -25
}T_zEm_Td_NCellCsrPara;

typedef struct {
    BYTE                       bCellEvaType;     /*Сͣ 0: ͨ 1: ȵȼ*/
    BYTE                       abPadding[3];
    union{
        T_zEm_Td_NCellCsrPara     tCsrPara;
        T_zEm_Td_NCellPrioPara    tPrioPara;
    }uCell;
}T_zEm_Td_NCellCsrInfo;

typedef struct {
    WORD                       wUarfcn; 
    BYTE                       bCellParaId;
    BYTE                       bRscp;          //0~91
    BYTE                       bCsrInfoFlg;    /*ָʾtCellCsrInfoǷ*/
    BYTE                       bRssi;
    SHORT                      sCellIndOff;
    T_zEm_Td_NCellCsrInfo      tCellCsrInfo;
}T_zEm_Td_TddCellInfo;     /*ͬƵƵСϢ*/

typedef struct {
    WORD                       wUarfcn; 
    BYTE                       bCellParaId;
    BYTE                       bRscp;          //0~91
}T_zEm_Td_DetectCellInfo;

typedef struct {
    WORD                       wArfcn; //λ1ʾ1900Ƶ
    BYTE                       bBsic;
    BYTE                       bRssi;//0~63
    BYTE                       bCsrInfoFlg;      /*ָʾtCellCsrInfoǷ*/
    BYTE                       bBand;            /*GsmСBand*/
    BYTE                       abPadding[2];
    T_zEm_Td_NCellCsrInfo      tCellCsrInfo;
}T_zEm_Td_NGCellInfo;

typedef struct {
    BYTE                       bPriority;
    BYTE                       bThreshHigh;//0~62
    BYTE                       bThreshHigh2;//0~62
    BYTE                       bThreshLow;//0~62
    BYTE                       bThreshLow2;//0~62
    BYTE                       abPadding[3];
    SHORT                      sQRxLevMinEUTRA;
    SHORT                      sQqualMinEUTRA;
}T_zEm_Td_NLCellCsrInfo;

typedef struct {
    DWORD                      dwEarfcn; 
    WORD                       wPci;    
    BYTE                       bRsrp;//0~97
    BYTE                       bRsrq;//0~34
    BYTE                       bCsrInfoFlg;
    BYTE                       bPadding[3];
    T_zEm_Td_NLCellCsrInfo     tCellCsrInfo;
}T_zEm_Td_NLCellInfo;

/* Ϣ*/
typedef struct {
    BYTE                       bIntraCellNum;
    BYTE                       bInterCellNum;
    BYTE                       bDetectCellNum;
    BYTE                       bGsmCellNum;
    BYTE                       bLteCellNum;
    BYTE                       abPadding[3];
    T_zEm_Td_TddCellInfo       atIntraCell[Z_EM_MAX_TD_NCELL_NUM];  //Rscp
    T_zEm_Td_TddCellInfo       atInterCell[Z_EM_MAX_TD_NCELL_NUM];  //Rscp
    T_zEm_Td_DetectCellInfo    atDetectCell[Z_EM_MAX_TD_NCELL_NUM];
    T_zEm_Td_NGCellInfo        atGsmCell[Z_EM_MAX_GSM_NCELL_NUM];  //RSSI
    T_zEm_Td_NLCellInfo        atLteCell[Z_EM_MAX_LTE_NCELL_NUM];   //RSRP
}T_zEm_Td_NCellInfo;

typedef struct {
    BYTE                       bRscpFlg;      /*ָʾСRscpSvalueǷڣ1ڣ 0*/
    BYTE                       bSvalueFlg;
    BYTE                       bRscp;   //0~91
    BYTE                       bPadding; 
    SHORT                      sSValue;
    SHORT                      sPadding;
    T_zEM_Td_MeasThreshInfo    tMeasThreshInfo;
    T_zEm_Td_NCellInfo         tNCellInfo;
}T_zEm_Td_MeasInfo;

typedef struct {
    T_zEm_Td_SCellPara          tScellPara;
    T_zEm_Td_MeasInfo           tMeasInfo;
}T_zEm_Td_EmInfo_Ind;

typedef struct{
    WORD                       wArfcn;
    BYTE                       bBsic;
    BYTE                       bRelease;
    DWORD                      dwCellId;
    WORD                       wDchArfcn;
    BYTE                       bBand;
    BYTE                       bLinkTimeOut;
    BYTE                       bSupGprs;
    BYTE                       bSupDtxFg;
    BYTE                       bSupHop;
    BYTE                       bTav;
}T_zEm_Gsm_SCellInfo;/*GSMģСϢ*/

typedef struct {
    T_zEm_Gsm_SCellInfo         tScellInfo;
    T_zEm_NasQos                tNasQos;
    T_zEm_Gsm_NasInfo           tNasInfo;
}T_zEm_Gsm_SCellPara;

typedef struct {
    BYTE                       bPriority;
    BYTE                       bQsearchI;
    BYTE                       bThreshPrioritySearch;
    BYTE                       bQsearchP;  
}T_zEM_Gsm_InitMeasInfo;

typedef struct {
    BYTE                       bTreselections;
    BYTE                       bThreshGsmLow;
    BYTE                       bCellReselectHysteresis;
    BYTE                       bHPrio;
    BYTE                       bNc;
    BYTE                       bCcnActive;
    BYTE                       b3GCcnActive;
    BYTE                       bPadding;
}T_zEM_Gsm_ReselInfo;

typedef struct {
    BYTE                       bTddQoffset;
    BYTE                       bThreshUtranHigh;
    BYTE                       bThreshUtranLow;
    BYTE                       bFddQoffset;
    BYTE                       bFddQmin;
    BYTE                       bFddQminOffset;
    BYTE                       bUtranQrxlevMin; 
    BYTE                       bPadding;
    LONG                       lFddRscpThreshold;
}T_zEM_Utran_ReselInfo;

typedef struct {
    BYTE                       bThreshEutranHigh;
    BYTE                       bThreshEutranLow;
    BYTE                       bEutranQrxlevMin;   
    BYTE                       bPadding;
}T_zEM_Eutran_ReselInfo;

typedef struct {
    BYTE                       bGReselFlg;
    BYTE                       bUReselNum;
    BYTE                       bEuReselNum;
    BYTE                       bPadding;
    T_zEM_Gsm_ReselInfo        tInitReselGsm;
    T_zEM_Utran_ReselInfo      atInitReselUtran[Z_EM_MAX_TD_NCELL_NUM];
    T_zEM_Eutran_ReselInfo     atInitReselEutran[Z_EM_MAX_LTE_NCELL_NUM];
}T_zEM_Gsm_InitReselInfo;

typedef struct {
    T_zEM_Gsm_InitMeasInfo     tInitMeasInfo;
    T_zEM_Gsm_InitReselInfo    tInitReselInfo;  
}T_zEM_Gsm_MeasThreshInfo;

typedef struct {
    BYTE                       bBsic;
    BYTE                       bRssi;   
    WORD                       wPrimFreq;
    SHORT                      sC1;
    SHORT                      sC2;
    BYTE                       bBand;
    BYTE                       abPadding[3];
}T_zEm_Gsm_NGCellInfo;

typedef struct {  
    WORD                      wUAfrcn;
    WORD                      WCellId;
    BYTE                      bRscp;
    BYTE                      bPriority; 
    BYTE                      abPadding[2];
}T_zEm_Gsm_NTCellInfo;

typedef struct {  
    WORD                      wUAfrcn;
    WORD                      wCellId;
    BYTE                      bRscp;  // ĿǰϱBYTEֵϲתdBmʽ
    BYTE                      bEcn0;  // ϲתdBmʽ    
    BYTE                      bPriority; 
    BYTE                      bBand;
}T_zEm_Gsm_NWCellInfo;

typedef struct {  
    WORD                      wPrimCarrier;
    WORD                      wCellId;  
    BYTE                      bRsrp;
    BYTE                      bRsrq;      
    BYTE                      bPriority;    
    BYTE                      bPadding;
}T_zEm_Gsm_NLCellInfo;

typedef struct {
    BYTE                      bNGCellNum;
    BYTE                      bTCellNum;
    BYTE                      bWCellNum;
    BYTE                      bLCellNum;
    T_zEm_Gsm_NGCellInfo      tNGCell[Z_EM_MAX_GSM_NCELL_NUM];
    T_zEm_Gsm_NTCellInfo      tNTCell[Z_EM_MAX_TD_NCELL_NUM];
    T_zEm_Gsm_NWCellInfo      tNWCell[Z_EM_MAX_W_NCELL_NUM];
    T_zEm_Gsm_NLCellInfo      tNLCell[Z_EM_MAX_LTE_NCELL_NUM];
}T_zEm_Gsm_NCellInfo;

typedef struct {
    BYTE                        bRssi;      // ĿǰϱBYTEֵϲתdBmʽ
    BYTE                        abPadding[3];
    SHORT                       sC1;        
    SHORT                       sC2;
    T_zEM_Gsm_MeasThreshInfo    tMeasThreshInfo;
    T_zEm_Gsm_NCellInfo         tNCellInfo; 
}T_zEm_Gsm_SCellMeasInfo;


typedef struct {
    
    WORD       wArfcn;
    BYTE         abLai[5];
    BYTE         bRac;        
    BYTE         abCellId[2];
    BYTE         bBsic;
    BYTE         bBcchDec;
    BYTE         bNetMode;
    BYTE         bRxLev;
    BYTE         bMaxTxPwr;
    SHORT      sC1;
    BYTE         bBER;
    BYTE         bTa;
    BYTE         bCcchConf;
    BYTE         bRxQualFull;
    BYTE         bRxQualSub;
    SHORT      sC2;
    BYTE         bChnType;
    BYTE         bSunChn;//ҵŵʱŵ
    BYTE         bChnMode;
    BYTE         bBand;
    BYTE         bMaxRetrans;
    BYTE         bBsAgBlkRes;
    BYTE         atAcc[2];
    BYTE         bRxLevAccMin;
    BYTE         bEC;
    BYTE         bSi7and8;
    BYTE         bAtt;
}T_zEm_GSM_SCellInfo;

typedef struct {
    
    WORD       wArfcn;
    BYTE         bBsic;
    BYTE         bBand;
    BYTE         bBcchDec;
    BYTE         bRxLev;
    BYTE         bRxLevAccMin;
    BYTE         bMaxTxPwr;
    SHORT      sC1;
    SHORT      sC2;
    BYTE         abLai[5];
    BYTE         abCellId[2];
}T_zEm_GSM_NCellInfo;

typedef struct {
    
    BYTE bNCellNum;  /*ͨGSMС*/
    T_zEm_GSM_NCellInfo    atNCellInfo[Z_EM_MAX_GSM_NCELL_NUM];/*ͨGSMСϢ*/
}T_zEm_GSM_NCellList;

typedef struct {
    T_zEm_Gsm_SCellPara         tScellPara;/*GSMģСϢ*/
    T_zEm_Gsm_SCellMeasInfo     tMeasInfo;
    
    T_zEm_GSM_SCellInfo    tScellInfo;/*ͨGSMСϢ*/
    T_zEm_GSM_NCellList     tNcellList;/*ͨGSMСϢ*/
}T_zEm_Gsm_EmInfo_Ind;    /*gsm ģϱĹģʽϢ*/

/**wcdma**/

typedef struct {
    BYTE                        bCellVersion;
	BYTE                        bBand;
    BYTE                        abPadding[2];
    DWORD                       dwCellId;
    T_zEm_NasQos                tNasQos; 
    T_zEm_W_NasInfo             tNasInfo;
}T_zEm_W_CampPara;

typedef struct {
    WORD                       wPsc;
    BYTE                       bRscp;
    BYTE                       bEcNo;
}T_zEM_W_AsVasCellInfo;

typedef struct {
    WORD                      wUarfcn;
    BYTE                      bCellNum;
    BYTE                      bBand;
    T_zEM_W_AsVasCellInfo     atAsVasCell[Z_EM_MAX_W_ASCELL_NUM];
}T_zEM_W_FreqAsVasInfo;

typedef struct {
    BYTE                        bNotUsedFreqNum;
    BYTE                        abPadding[3];
    T_zEM_W_FreqAsVasInfo       tUsedFreqAsInfo;
    T_zEM_W_FreqAsVasInfo       atNotUsedFreqVasInfo[Z_EM_MAX_W_INTERFREQ_NUM];
}T_zEM_W_AsVasInfo;

typedef struct {
    BYTE                       bMcId;
    BYTE                       bEventId;     //0:1A,1:1B,...5:1F, 9:1J
    BYTE                       bW;                   
    BYTE                       bHysteresis;
    BYTE                       bTimeToTrigger; 
    BYTE                       bCellNumThld;         /*0~7 1A¼ΪReporting deactivation threshold 1C1J¼ΪReplacement activation threshold*/
    BYTE                       bTriggerCondition;   /* 0: not used, 1: Active set cells, 2:Monitored set cells, 
                                                                       3:Active set cells and monitored set cells, 4: Detected set cells, 
                                      5: Detected set cells and monitored set cells.*/ 
    BYTE                       bRptRange;
    BYTE                       bRptTimes;             /*¼ڱΪ1*/
    BYTE                       abPadding[3];
    SHORT                      sFreqQua; 	
    SHORT                      sThld;                  /*ʹ1EF¼*/
}T_zEM_W_IntraEventInfo;

typedef struct{
    BYTE                     bAsQuaFlg;
    BYTE                     bFreqQuaInd;                  /*BitMap, T_zEM_W_AsVasInfoƵӦ*/
    SHORT                    sAsQua;
    SHORT                    asFreqQua[Z_EM_MAX_W_INTERFREQ_NUM];   /*T_zEM_W_AsVasInfoƵӦ*/
}T_zEM_W_EventFreqQua;

typedef struct {
    BYTE                       bMcId;
    BYTE                       bEventId;  //0:2A,1:2B,...5:2F
    BYTE                       bUsedFreqW;
    BYTE                       bNotUsedFreqW; 
    BYTE                       bHysteresis;
    BYTE                       bTimeToTrigger;
    BYTE                       abPadding[2];
    SHORT                      sUsedFreqThld;        /*Event2B,2D,2F*/
    SHORT                      sNotUsedFreqThld;     /*Event2B,2C,2E*/
    T_zEM_W_EventFreqQua       tFreqQua;
}T_zEM_W_InterEventInfo;

typedef struct {
    BYTE                       bMcId;
    BYTE                       bEventId;         //0:2A,1:2B,...5:2F
    BYTE                       bW; 
    BYTE                       bAsQuaFlg;        //ָʾsAsQua
    BYTE                       bHysteresis;
    BYTE                       bTimeToTrigger;
    SHORT                      sOwnThreshold;     /*Integer (-115..0),in event 3A*/ 
    SHORT                      sOtherSysThreshold;
    SHORT                      sAsQua;
}T_zEM_W_RatEventInfo;

typedef struct {
    BYTE                       bEventType;       //0:Intra, 1:Inter, 2: Rat
    BYTE                       abPadding[3];
    union{
        T_zEM_W_IntraEventInfo      tIntraEvent;
        T_zEM_W_InterEventInfo      tInterEvent;
        T_zEM_W_RatEventInfo        tRatEvent;
    }uEventInfo;
}T_zEm_W_MeasEventInfo;

typedef struct {
    BYTE                     bEventNum;
    BYTE                     abPadding[3];
    T_zEm_W_MeasEventInfo    atMeasEventInfo[Z_EM_MAX_W_EVENT_NUM];
}T_zEm_W_DchEventInfo;

typedef struct{
    WORD                     wUarfcn;
    WORD                     wPsc;
    SHORT                    sCellOff;//-1-----1 
    BYTE                     bTxInd;/*0,1,2*/    
    BYTE                     bRscp;
    BYTE                     bEcNo;
    BYTE                     bRssi;
    BYTE                     bRssiFlg;
    BYTE                     bBand;
}T_zEM_W_FddCellInfo;

typedef struct{
    WORD                       wArfcn; //λ1ʾ1900Ƶ
    BYTE                       bBsic;
    BYTE                       bRssi;//0~63
    BYTE                       bBand;   /*GsmСBand*/
    BYTE                       abPadding[3];
}T_zEM_W_GsmCellInfo;

typedef struct {
    DWORD                      dwEarfcn;
    WORD                       wPci;
    BYTE                       bRsrp;
    BYTE                       bRsrq;
}T_zEM_W_LteCellInfo;

typedef struct {
    BYTE                    bIntraCellNum;
    BYTE                    bInterCellNum;
    BYTE                    bDetectCellNum;
    BYTE                    bGsmCellNum;
    BYTE                    bLteCellNum;
    BYTE                    abPadding[3];
    T_zEM_W_FddCellInfo     atIntraCell[Z_EM_MAX_W_NCELL_NUM];
    T_zEM_W_FddCellInfo     atInterCell[Z_EM_MAX_W_NCELL_NUM];
    T_zEM_W_FddCellInfo     atDetectCell[Z_EM_MAX_W_NCELL_NUM];
    T_zEM_W_GsmCellInfo     atGsmCell[Z_EM_MAX_GSM_NCELL_NUM];
    T_zEM_W_LteCellInfo     atLteCell[Z_EM_MAX_LTE_NCELL_NUM];
}T_zEM_W_DchNCellInfo;

typedef struct {
    T_zEM_W_AsVasInfo          tFreqAsVasInfo;
    T_zEm_W_DchEventInfo       tEventInfo;
    T_zEM_W_DchNCellInfo       tNCellInfo;
}T_zEm_W_DchMeasInfo;

typedef struct {
    WORD                     wUarfcn;
    WORD                     wPsc;
    BYTE                     bValueFlg;   //ָʾbRscp,bEcNo,sSrxlev,sSqualǷ
    BYTE                     bRscp;
    BYTE                     bEcNo;
    BYTE                     bBand;
    SHORT                    sSrxlev;
    SHORT                    sSqual;
    SHORT                    sCellOff;   //-1-----1 
    WORD                     wPadding;
}T_zEm_W_SCellInfo;

typedef struct{
    BYTE                       bPriority;//7
    BYTE                       bSPrioSearch1;//0--62
    BYTE                       bSPrioSearch2;//0--14
    BYTE                       bThreshServLow;//0--62
    BYTE                       bThreshServLow2;//0--62
    BYTE                       abPadding[3];
}T_zEM_W_ServCellPrioInfo;

typedef struct{
    BYTE                       bHcsPrio;//0--7
    BYTE                       bQhcs;//0--99  ЯdeltaQhcsֵdeltaQhcsӰֵ
    BYTE                       abPadding[2];
}T_zEM_W_Hcs_ServCellInfo;

typedef struct {
    BYTE                       bSintra;//0~20    ЧֵΪ0xFF
    BYTE                       bSinter;// 0---20  ЧֵΪ0xFF
    BYTE                       bSearchHcs;//0--91   ЧֵΪ0xFF
    BYTE                       bSearchRat;// 0---20  ЧֵΪ0xFF
    BYTE                       bSearchHcsRat;//0--91  ЧֵΪ0xFF
    BYTE                       bHcsLimtSearchRat;//0---20   ЧֵΪ0xFF
    BYTE                       bQHyst1S;//0--40   
    BYTE                       bQHyst2S;//0--40Ϊ0xFF
    BYTE                       bTresel;  //0~31     
    BYTE                       bHcsServCellInfoFlg;   //ָʾtHcsServCellInfoǷ
    BYTE                       abPadding[2];
    SHORT                      sQualMin;//-24--0   ЯDeltaQrxlevminֵDeltaQrxlevminӰֵ
    SHORT                      sQRxlevMin;//-115-- -25
    T_zEM_W_Hcs_ServCellInfo   tHcsServCellInfo;
}T_zEM_W_CellSelectSib3_4;

typedef struct{
    BYTE                          bPrioInfoFlg;
    BYTE                          abPadding[3];
    T_zEm_W_SCellInfo             tScellInfo;
    T_zEM_W_ServCellPrioInfo      tSCellPrioInfo;
    T_zEM_W_CellSelectSib3_4      tCellSelecSib34;
}T_zEM_W_FddSCellReselInfo;

typedef struct{
    SHORT                       sQOff1SN;  //-50---50   RSCP/ECNo
    SHORT                       sQOff2SN;  //-50---50 ENNOʹ
    SHORT                       sQQualMin; //-24-0
    SHORT                       sQRxlevMin;//-115--  -25
}T_zEM_W_CellSelecSib11_12;

typedef struct{
    BYTE                       bPriority;//7
    BYTE                       bThreshXhigh;//0--62
    BYTE                       bThreshXlow;//0-62
    BYTE                       bPadding;
    SHORT                      sQQualMinFDD;//-24-0
    SHORT                      sQRxLevMinFDD;//-119--  -25
}T_zEM_W_FddNCellPrioInfo;

typedef struct{
    BYTE                       bCellEvaInfoType;        //0: Sib11/12Info  1Sib19Info
    BYTE                       abPadding[3];
    T_zEM_W_FddCellInfo        tFddCellInfo;
    union{
        T_zEM_W_CellSelecSib11_12    tCellSelecSib11_12;
        T_zEM_W_FddNCellPrioInfo     tFddNCellPrioInfo;
    }tEvaInfo;
}T_zEM_W_FddNCellReselInfo;

typedef struct {
    BYTE                       bPriority;
    BYTE                       bThreshXHigh;   //0~62
    BYTE                       bThreshXLow;    //0~62
    BYTE                       bPadding;
    SHORT                      sQRxLevMinGSM;  //-115--  -25
    WORD                       wPadding;
}T_zEm_W_GCellPrioInfo;

typedef struct{
    BYTE                           bCellEvaInfoType;      //0: Sib11/12Info  1Sib19Info
    BYTE                           abPadding[3];
    T_zEM_W_GsmCellInfo            tGsmCellInfo;
    union{
        T_zEM_W_CellSelecSib11_12  tCellSelecSib11_12;
        T_zEm_W_GCellPrioInfo      tGsmCellPrioInfo;
    }tEvaInfo;
}T_zEM_W_GsmCellReselInfo;

typedef struct {
    BYTE                       bPriority;
    BYTE                       bThreshXHigh;//0~62
    BYTE                       bThreshXHigh2;//0~62
    BYTE                       bThreshXLow;//0~62
    BYTE                       bThreshXLow2;//0~62
    BYTE                       abPadding[3];
    SHORT                      sQRxLevMinEUTRA;//-140-- -44
    SHORT                      sQqualMinEUTRA;//-34~-3
}T_zEm_W_LteCellPrioInfo;

typedef struct{
    T_zEM_W_LteCellInfo       tLteCellInfo;
    T_zEm_W_LteCellPrioInfo  tLteCellPrioInfo;
}T_zEM_W_LteCellReselInfo;

typedef struct {
    BYTE                           bFddIntraCellNum;
    BYTE                           bFddInterCellNum;
    BYTE                           bGsmNCellNum;
    BYTE                           bLteNCellNum;
    T_zEM_W_FddSCellReselInfo      tFddSCellReselInfo;
    T_zEM_W_FddNCellReselInfo      atFddIntraCellInfo[Z_EM_MAX_W_NCELL_NUM];
    T_zEM_W_FddNCellReselInfo      atFddInterCellInfo[Z_EM_MAX_W_NCELL_NUM];
    T_zEM_W_GsmCellReselInfo       atGsmCellReselInfo[Z_EM_MAX_GSM_NCELL_NUM];
    T_zEM_W_LteCellReselInfo       atLteCellReselInfo[Z_EM_MAX_LTE_NCELL_NUM];
}T_zEm_W_NotDchMeasInfo;

typedef struct {
    BYTE                        bStateInd;    /*0: Dch, 1: Fach , 2:CellPch, 3:UraPch, 4:Idle*/
    BYTE                        abPadding[3];
    T_zEm_W_CampPara            tCampPara;
    union{
        T_zEm_W_DchMeasInfo     tDchInfo;
        T_zEm_W_NotDchMeasInfo  tNotDchInfo;
    }uWcellMeasInfo;
}T_zEm_W_EmInfo_Ind;


/****wcdma******/
typedef struct {
    BYTE                       bVersion;
    BYTE                       bRatType;/* ʽָʾ0x04-GSM0x01-TDSCDMA0x02-WCDMA0x10-LTEֵ*/
    BYTE                       bSrcIndex;/*ԭΪpaddingλ,ֵڴ˴APʹòӰ*/
    BYTE                       bDesIndex;
    union{
        T_zEm_Gsm_EmInfo_Ind   tGsmEmInfo;
        T_zEm_Td_EmInfo_Ind    tTdEmInfo;
        T_zEm_W_EmInfo_Ind     tWEmInfo;
        T_zEm_Lte_EmInfo_Ind   tLteEmInfo;
    }uEmInfo;
}T_zEM_EmInfo_Ind;


/**************************************************************************
*                         Ͷ                                    *
 **************************************************************************/
#ifdef _CHIP_ZX297502
extern VOID zReqPsInfo(BYTE bInfoType);
#else 
extern VOID zReqPsInfo(BYTE  bStackIndex, BYTE bInfoType);
#endif

extern VOID zEul2LogMaskInd(T_zEUL2_LogMask_Ind tEul2logMaskInd);

#endif



